﻿//@legacy
//#mode(full-ecma)


//@import "CFG_G150_VT.js"

// ---------------------------------------------------------------------------------
// Bestimme die Consequences aus einer gegebenen Konfiguration

// ###################################################################################################################################
// Consequence-Attributes
// ###################################################################################################################################
/**
* ControlUnit
* FieldbusInterface
* BrakingResistorID
* SelectedCustomBrakingResistor
* BrakeRelays
BrakingModuleID
* 
* DQ Endpoint - true
* 
* InputFilterType			- If Line Filter selected 0, by default 3		LineFilter L00
* ExternalFilterType	 	- If Line Filter selected 2, by default 0		LineFilter L00
* 
* MaxOutputFrequencyLimit	
* 	- Sine-wave filter: The output frequency is limited to max. 115 Hz (at 500 ... 600 V) and 150 Hz (at 380 ... 480 V)
*		- dv/dt filter: max 150 Hz
* MaxPulseFrequency
* 	- Sine-wave filter: Double of the default pulse frequency
*  	- dv/dt filter: 380-480V  && "<= 250 kW", 4kHz; other cases: 2,5 kHz
* MinPulseFrequency
* 	- Sine-wave filter: Double of the default pulse frequency [Add image]
* 		kW	  			default pulse freq [kHz]	Max output freq [Hz]
* 		110...250		3AC 380...480V: 2			  	160
* 		315...900		3AC 380...480V: 1.25			100
* 		110...1000	3AC 500...600V: 1.25	  	100
* 		 75...1500	3AC 660...690V: 1.25	  	100
* 
* OutputReactorOrFilter
* OutputReactorOrFilterType	 - 1,3,4,5 - Based on the selection
* 
* IpProtectionLevelFrequencyConverter 
* 
* IsProtectedDevice - If L26 selected
*/

function determineConsequencesG150(sECSI_MLFB) {
  var strErr = "";

  var oConsequences = {
    ControlUnit: getControlUnit_G150(),
    FieldbusInterface: getFieldbusInterface_G150(),
    InputFilterType: getInputFilterType_G150(),
    ExternalFilterType: getExternalFilterType_G150(),
    MinPulseFrequency: getMinPulseFrequency_G150(),
    MaxOutputFrequencyLimit: getMaxOutputFrequencyLimit_G150(),
    MaxPulseFrequency: getMaxPulseFrequency_G150(),
    OutputReactorOrFilterType: getOutputReactorOrFilterType_G150(),
    OutputReactorOrFilter: getOutputReactorOrFilter_G150(),
    IpProtectionLevelFrequencyConverter: getIpProtectionLevelFrequencyConverter_G150(),
    BrakingResistorID: getBrakingResistorID_G150(),
    //BrakingModuleID				: getBrakingModuleID_G150(),
    //AllowedControlModes		: getAllowedControlModes_G150(),
    IsProtectiveDevice: getIsProtectiveDevice_G150(),
    DQEndpoint: true, //getDQEndpoint_G150(),
    Selected_CU: "G150",
    Selected_PMs: getSelected_PMs(),
    VSM4Motor: getVSM4Motor_G150(),
    Selected_TM31_1: getTM31_1_G150(),
    Selected_TM31_2: getTM31_2_G150(),
    Selected_TM150_1: getTM150_1_G150(),
    Selected_TM54F: getTM54F_G150(),
    Selected_SMC30_1: getSMC30_1_G150(),
    Selected_SMC30_2: getSMC30_2_G150(),
    Error_Message: strErr,
  };

  return oConsequences;
}

function getControlUnit_G150() {
  return "";
}

function getFieldbusInterface_G150() {
  if (ECL_ValueSelected("CB_O_CU_K95_G150", "T")) {
    // if K95: 0, Profinet, else Profibus:1
    return "0";
  } else {
    return "1";
  }
}
/**
 * O_UMGEBUNG_L00_G150 ==> LineFilter
 * 	ExternalFilterType - If Line Filter selected 2, by default 0
 * 	InputFilterType - If Line Filter selected 0, by default 3
 */
function getInputFilterType_G150() {
  switch (ECL_GetValue("O_UMGEBUNG_L00_G150")) {
    case "STD": // ohne C3
      var InputFilterType = "3";
      break;
    case "L00":
      var InputFilterType = "0";
      break;
    default:
      var InputFilterType = "3";
  }
  return InputFilterType;
}

function getExternalFilterType_G150() {
  switch (ECL_GetValue("O_UMGEBUNG_L00_G150")) {
    case "STD": // ohne C3
      var ExternalFilterType = "0";
      break;
    case "L00":
      var ExternalFilterType = "2";
      break;
    default:
      var ExternalFilterType = "0";
  }
  return ExternalFilterType;
}
function getOutputReactorOrFilterType_G150() {
  // OutputReactorOrFilterType
  /* Integer
		0	No output reactor or filter selected
		1	Single motor reactor selected
		2	Two motor reactor in series selected
		3	Sinus filter selected
		4	du/dt filter selected
		5	du/dt filter compact selected
	*/
  var OutputReactorOrFilterType = 0;

  var O_OUTPUT_G150 = ECL_GetValue("O_OUTPUT_G150");
  switch (O_OUTPUT_G150) {
    case "STD":
      OutputReactorOrFilterType = 0;
      break;
    case "L07": //dv/dt compact
      OutputReactorOrFilterType = 5;
      break;
    case "L08": // motor reactor
      OutputReactorOrFilterType = 1;
      break;
    case "L10": //dv/dt
      OutputReactorOrFilterType = 4;
      break;
    case "L15": // sine-wave
      OutputReactorOrFilterType = 3;
      break;
    default:
      OutputReactorOrFilterType = 0;
  }

  return OutputReactorOrFilterType;
}

function getOutputReactorOrFilter_G150() {
  /** OutputReactorOrFilter	
    String	
    This parameter defines the order number for a selected output reactor or filter.	
        String.Empty	No output reactor or filter selected
        String			Order number as MLFB without separating "-"

 	*/
  return "";
}

function getIpProtectionLevelFrequencyConverter_G150() {
  // O_SCHUTZART_G150  	Schutzart
  var IpProtectionLevelFrequencyConverter = "";
  /*O_SCHUTZART_G150
	NON	Standard
	STD	IP20
	M21	IP21 (M21)
	M23	IP23 (M23)
	STM	IP23 (Standard)
	M43	IP43 (M43)
	M54	IP54 (M54)
	STE	IP00
	*/
  var O_SCHUTZART_G150 = ECL_GetValue("O_SCHUTZART_G150");

  switch (O_SCHUTZART_G150) {
    case "NON":
    case "STD":
      IpProtectionLevelFrequencyConverter = "20";
      break;
    case "M21":
      IpProtectionLevelFrequencyConverter = "21";
      break;
    case "M23":
    case "STM":
      IpProtectionLevelFrequencyConverter = "23";
      break;
    case "M43":
      IpProtectionLevelFrequencyConverter = "43";
      break;
    case "M54":
      IpProtectionLevelFrequencyConverter = "54";
      break;
  }
  return IpProtectionLevelFrequencyConverter;
}

function getBrakingResistorID_G150() {
  var O_BREMSEINHEIT_G150 = ECL_GetValue("O_BREMSEINHEIT_G150");
  var MLFB10_G150 = ECL_GetValue("MLFB10_G150");

  if (O_BREMSEINHEIT_G150 == "NON") {
    return "";
  }

  var sTable = "BrakeID";
  var sSQL =
    "SELECT DISTINCT SZ_BR_ID FROM " +
    sTable +
    " WHERE " +
    "O_BREMSEINHEIT_G150 = '" +
    O_BREMSEINHEIT_G150 +
    "' AND " +
    "MLFB10_G150 = '" +
    MLFB10_G150 +
    "';";

  var aResult = Object.fromDatabase("G150_ADD_DATA", sSQL);

  if (aResult.length > 0) {
    var BrakingResistorID = aResult[0].SZ_BR_ID;
  } else {
    return "ERROR";
  }
  return BrakingResistorID;
}
function getBrakingModuleID_G150() {
  var O_BREMSEINHEIT_G150 = ECL_GetValue("O_BREMSEINHEIT_G150");
  var MLFB10_G150 = ECL_GetValue("MLFB10_G150");

  if (O_BREMSEINHEIT_G150 == "NON") {
    return "";
  }

  var sTable = "BrakeID";
  var sSQL =
    "SELECT DISTINCT SZ_BR_ID FROM " +
    sTable +
    " WHERE " +
    "O_BREMSEINHEIT_G150 = '" +
    O_BREMSEINHEIT_G150 +
    "' AND " +
    "MLFB10_G150 = '" +
    MLFB10_G150 +
    "';";

  var aResult = Object.fromDatabase("G150_ADD_DATA", sSQL);

  if (aResult.length > 0) {
    var BrakingModuleID = aResult[0].SZ_BR_ID;
  } else {
    return "ERROR";
  }
  return BrakingModuleID;
}

function getMaxOutputFrequencyLimit_G150() {
  var ConverterRatedPower = parseFloat(ECL_GetValue("ECSI_CX_ConverterRatedPower"));
  var MLFB10_G150 = ECL_GetValue("MLFB10_G150");

  var sWhereConverterRating = "";

  if (MLFB10_G150 == "E") {
    if (ConverterRatedPower <= 250) {
      var ConverterRating = "110_250";
    } else {
      var ConverterRating = "315_900";
    }
    sWhereConverterRating = "ConverterRating = '" + ConverterRating + "' AND ";
  }

  var sTable = "PulseFrequency";

  var sSQL = "SELECT * FROM " + sTable + " WHERE " + sWhereConverterRating + "MLFB10_G150 = '" + MLFB10_G150 + "';";

  var aResult = Object.fromDatabase("G150_ADD_DATA", sSQL);

  if (aResult.length > 0) {
    var MaxOutputFrequencyLimit = ""; //without Line-side comps, no derating! aResult[0].MAXOUTPUTFREQUENCY_DEFAULT;
    // if dv/dt-filter or motor reactor selected
    var O_OUTPUT_G150 = ECL_GetValue("O_OUTPUT_G150");
    if (O_OUTPUT_G150 == "L07" || O_OUTPUT_G150 == "L08" || O_OUTPUT_G150 == "L10") {
      // dv/dt-filter
      MaxOutputFrequencyLimit = aResult[0].MAXOUTPUTFREQUENCY_DV_DT;
    }
    // if sine-wave-filter selected
    if (O_OUTPUT_G150 == "L15") {
      // sine-wave-filter
      MaxOutputFrequencyLimit = aResult[0].MAXOUTPUTFREQUENCY_SINE_WAVE;
    }
  } else {
    return "ERROR";
  }
  return MaxOutputFrequencyLimit;
}
function getMaxPulseFrequency_G150() {
  var ConverterRatedPower = parseFloat(ECL_GetValue("ECSI_CX_ConverterRatedPower"));
  var MLFB10_G150 = ECL_GetValue("MLFB10_G150");

  var sWhereConverterRating = "";

  if (MLFB10_G150 == "E") {
    if (ConverterRatedPower <= 250) {
      var ConverterRating = "110_250";
    } else {
      var ConverterRating = "315_900";
    }
    sWhereConverterRating = "ConverterRating = '" + ConverterRating + "' AND ";
  }

  var sTable = "PulseFrequency";

  var sSQL = "SELECT * FROM " + sTable + " WHERE " + sWhereConverterRating + "MLFB10_G150 = '" + MLFB10_G150 + "';";

  var aResult = Object.fromDatabase("G150_ADD_DATA", sSQL);

  if (aResult.length > 0) {
    var MaxPulseFrequency = ""; //aResult[0].PULSEFREQUENCY_DEFAULT;
    // if dv/dt-filter or motor-reactor selected
    var O_OUTPUT_G150 = ECL_GetValue("O_OUTPUT_G150");
    if (O_OUTPUT_G150 == "L07" || O_OUTPUT_G150 == "L08" || O_OUTPUT_G150 == "L10") {
      // dv/dt-filter
      MaxPulseFrequency = aResult[0].MAXPULSEFREQUENCY_DV_DT;
    }
    // if sine-wave-filter selected
    if (O_OUTPUT_G150 == "L15") {
      // sine-wave-filter
      MaxPulseFrequency = aResult[0].MAXPULSEFREQUENCY_SINE_WAVE;
    }
  } else {
    return "ERROR";
  }
  return MaxPulseFrequency;
}

function getMinPulseFrequency_G150() {
  var ConverterRatedPower = parseFloat(ECL_GetValue("ECSI_CX_ConverterRatedPower"));
  var MLFB10_G150 = ECL_GetValue("MLFB10_G150");

  var sWhereConverterRating = "";

  if (MLFB10_G150 == "E") {
    if (ConverterRatedPower <= 250) {
      var ConverterRating = "110_250";
    } else {
      var ConverterRating = "315_900";
    }
    sWhereConverterRating = "ConverterRating = '" + ConverterRating + "' AND ";
  }

  var sTable = "PulseFrequency";
  var sSQL = "SELECT * FROM " + sTable + " WHERE " + sWhereConverterRating + "MLFB10_G150 = '" + MLFB10_G150 + "';";

  var aResult = Object.fromDatabase("G150_ADD_DATA", sSQL);

  if (aResult.length > 0) {
    var MinPulseFrequency = ""; //aResult[0].PULSEFREQUENCY_DEFAULT;

    var O_OUTPUT_G150 = ECL_GetValue("O_OUTPUT_G150");
    // if sine-wave-filter selected
    if (O_OUTPUT_G150 == "L15") {
      // sine-wave-filter
      MinPulseFrequency = aResult[0].MINPULSEFREQUENCY_SINE_WAVE;
    }
  } else {
    return "ERROR";
  }
  return MinPulseFrequency;
}

// IsProtectedDevice - If L26 selected
function getIsProtectiveDevice_G150() {
  /** IsProtectiveDevice
   */

  if (ECL_ValueSelected("CB_O_SCHALTER_L26_G150", "T")) {
    return "true";
  }
  return "false";
}

function getSelected_PMs() {
  var mlfb = ECL_GetValue("ECSI_MLFB");
  var sSelected_PMs = "";

  if (mlfb.match(/6SL37101GE(321|326|331|338|350|361|375|384|410)(C|A)/)) {
    sSelected_PMs = "CIM_1";
  } 
  else if (mlfb.match(/6SL37101GF(318|322|326|333|341|347|358|374|381)(C|A)/)) {
    sSelected_PMs = "CIM_1";
  }
  else if (mlfb.match(/6SL37101GH(285|310|312|315|318|322|326|333|341|347|358|374|381)(C|A)/)) {
    sSelected_PMs = "CIM_1";
  }
  else if (mlfb.match(/6SL37102GE(411|414|416)A/)) {
    sSelected_PMs = "CIM_1|CIM_2";
  }
  else if (mlfb.match(/6SL37102GF(386|411|414)A/)) {
    sSelected_PMs = "CIM_1|CIM_2";
  }
  else if (mlfb.match(/6SL37102GH(411|414|415)A/)) {
    sSelected_PMs = "CIM_1|CIM_2";
  }
  else if (mlfb.match(/6SL37102GH(418|420|422|424)E/)) {
    sSelected_PMs = "BLM_1|BLM_2|MoMo_1|MoMo_2";
  }
  else if (mlfb.match(/6SL37102GH427E/)) {
    sSelected_PMs = "BLM_1|BLM_2|MoMo_1|MoMo_2|MoMo_3";
  }

  return sSelected_PMs;
}

function getVSM4Motor_G150() {
  var o_module = ECL_GetValue("O_MODULE_G150");

  if (o_module === "K51")
    return "VSM10";

  return "";
}

function getTM31_1_G150() {
  var tm31_1 = ECL_GetValue("CB_O_KLEMMLEISTE_G60_G150");
  var tm31_2 = ECL_GetValue("CB_O_KLEMMLEISTE_G61_G150");

  if (tm31_1 === "T" || tm31_2 === "T")
    return "TM31_1";

  return "";
}

function getTM31_2_G150() {
  var tm31_2 = ECL_GetValue("CB_O_KLEMMLEISTE_G61_G150");

  if (tm31_2 === "T")
    return "TM31_2";

  return "";
}

function getTM150_1_G150() {
  var tm150_1 = ECL_GetValue("CB_O_TM150_G150");

  if (tm150_1 === "T")
    return "TM150_1";

  return "";
}

function getTM54F_G150() {
  var tm54f = ECL_GetValue("CB_O_TM54F_K87_G150");

  if (tm54f === "T")
    return "TM54F";

  return "";
}

function getSMC30_1_G150() {
  var smc30_1 = ECL_GetValue("O_MODULE_G150");
  var smc30_2 = ECL_GetValue("CB_O_ZUS_SMC30_K52_G150");

  if (smc30_1 === "K50" || smc30_2 === "T")
    return "SMC30_1";

  return "";
}

function getSMC30_2_G150() {
  var smc30_2 = ECL_GetValue("CB_O_ZUS_SMC30_K52_G150");

  if (smc30_2 === "T")
    return "SMC30_2";

  return "";
}