﻿//@legacy
//#mode(full-ecma)

// ---------------------------------------------------------
// Script for configuration object CFG_SIEMENS_G150
// 	Date: 2023-06-20
// 	User: Administrator
// ---------------------------------------------------------

//@import "CFG_G150_VT.js"

/**
	zu bestimmen: 
		Spannung, MLFB10
		IP Schutzklasse KAG bzw STD, STM bei Marine O_SCHUTZART_G150
		ggf. Leistung
		IN_Ausfuehrung (STD oder Kompakt) MLFB14
	MLFB01: 6SL3
	MLFB05: 3,7 VT_M00002==> nur 7 (IN_Bauart nur 00001)
	MLFB06: 1
	MLFB07: 0
	MLFB08: 1,2 
	MLFB09: G
	MLFB10: Spannungsbereich [E,F,H]	==>	IN_SPANNUNG_G150, HMK_SPANNUNG_BEREICH_G150
	MLFB11: Leistung 123 	MLFB11_G150 3 digits! (MLFB11...13)
	MLFB12: Leistung 2 
	MLFB13: Leistung 3 
	MLFB14: . Ausführung A (Standard) oder C (kompakt), wenn MLFB08 == 2 ==> nur A 		[A,C,E]		(IN_AUSFUEHRUNG: A,C VT76)
	MLFB15:	A 
	MLFB16:	3 	

*/

function SetInverter_Init_G150(oData) {
  if (oData && !isEmpty(oData)) {
    SetVoltage_G150(oData); //
    SetBauart_G150(oData); // IN_BAUART: Schrank 00001 MLFB05: 7
    SetProtection_G150(oData); // O_SCHUTZART_G150
    SetFallnummer_G150(oData);
    SetAusfuehrung_G150(oData); // IN_AUSFUEHRUNG (MLFB14)
    SetH_TRIGGER_AC230V_G150(oData); // H_TRIGGER_AC230V_G150
  } else {
    // FC-Data
    ExecSetStandardifValueEmpty("IN_SPANNUNG_G150", "400");
    ExecSetStandardifValueEmpty("IN_NETZFREQUENZ_G150", "50");
    ExecSetStandardifValueEmpty("HMK_SPANNUNG_BEREICH_G150", "400");

    ExecSetStandardifValueEmpty("IN_BAUART_G150", "00001");

    //ExecSetStandardifValueEmpty("PMD_ABJ176_001_000_G150","IP20");	// Schutzart IP
    ExecSetStandardifValueEmpty("O_SCHUTZART_G150", "STD"); //

    ExecSetStandardifValueEmpty("HMK_FALLNUMMER_G150", "00001"); // HMK_FALLNUMMER_G150
    ExecSetStandardifValueEmpty("IN_AUSFUEHRUNG_G150", "A"); //
    ExecSetStandardifValueEmpty("H_TRIGGER_AC230V_G150", "NONSPEC"); //
  }
}

function SetInverter_G150(strchangedAttribute, oData) {}
// #########################################################################################################################
/**
MLFB10: Spannungsbereich [E,F,H]	==>	IN_SPANNUNG_G150, HMK_SPANNUNG_BEREICH_G150
*/
// #########################################################################################################################
function SetVoltage_G150(oData) {
  //var oParsingData = oData.oParsingData;
  var oMLFB = oData.oParsingData.MLFB;
  var MLFB10_G150 = oMLFB.POS10;

  // VT_G150_M00001	MLFB_7_VOLTAGE
  // 	IN_SPANNUNG_G150	MLFB10_G150

  var sTable = "VT_G150_M00001" + sDB_Suffix;
  var sSQL =
    "SELECT * FROM " +
    sTable +
    " WHERE " +
    "(IN_SPANNUNG_G150 = 400 OR IN_SPANNUNG_G150 = 600 OR IN_SPANNUNG_G150 = 690) AND " +
    "MLFB10_G150 = '" +
    MLFB10_G150 +
    "';";

  var aResult = GetDBDataSetEXT(sSQL);
  if (aResult.length > 0) {
    var IN_SPANNUNG_G150 = aResult[0].IN_SPANNUNG_G150;

    ECL_DeactivateAllAttributeValues("IN_SPANNUNG_G150");
    ECL_ActivateValue("IN_SPANNUNG_G150", IN_SPANNUNG_G150);
    ECL_SelectValue("IN_SPANNUNG_G150", IN_SPANNUNG_G150);

    ECL_DeactivateAllAttributeValues("HMK_SPANNUNG_BEREICH_G150");
    ECL_ActivateValue("HMK_SPANNUNG_BEREICH_G150", MLFB10_G150);
    ECL_SelectValue("HMK_SPANNUNG_BEREICH_G150", MLFB10_G150);
  } else {
    oData.strError = "DICT1_ERR_G150___PARSER_VOLTAGE";
    return;
  }
}
// #########################################################################################################################
/**
 * MLFB05: 3,7 VT_M00002==> nur 7 (IN_Bauart nur 00001) IN_BAUART: Schrankgerät 00001 MLFB05: 7
 */
// #########################################################################################################################
function SetBauart_G150(oData) {
  //var oParsingData = oData.oParsingData;
  var oMLFB = oData.oParsingData.MLFB;
  var MLFB05_G150 = oMLFB.POS5;

  // VT_G150_M00002	MLFB Stelle 5
  // 	IN_BAUART_G150	MLFB05_G150

  var sTable = "VT_G150_M00002" + sDB_Suffix;
  var sSQL = "SELECT * FROM " + sTable + " WHERE " + "MLFB05_G150 = '" + MLFB05_G150 + "';";

  var aResult = GetDBDataSetEXT(sSQL);
  if (aResult.length > 0) {
    var IN_BAUART_G150 = aResult[0].IN_BAUART_G150;

    ECL_DeactivateAllAttributeValues("IN_BAUART_G150");
    ECL_ActivateValue("IN_BAUART_G150", IN_BAUART_G150);
    ECL_SelectValue("IN_BAUART_G150", IN_BAUART_G150);
  } else {
    oData.strError = "DICT1_ERR_G150___PARSER_BAUART";
    return;
  }
}

// #########################################################################################################################
/**
IP Schutzklasse KAG bzw STD, STM bei Marine O_SCHUTZART_G150
*/
// #########################################################################################################################
function SetProtection_G150(oData) {
  // O_SCHUTZART_G150
  var sDTKAttribute = "O_SCHUTZART_G150";

  // KAGs  STD, (Marine: STM), (NON), M21, M23, M43, M54, (STE - nur Einbaugeräte)
  var aKAG = oData.oParsingData.MLFB.KAG || [];

  var sKAG = getKAGforAttribute(sDTKAttribute, aKAG);
  var bCheck = false;
  /**
   * Series IDs:
   * 	IP 20-43: 31150
   * 	Config context: FrequencyConverterDefaultIpProtectionLevel - 43
   * 	Behavior: Default IP Protection level is 20, max 43
   *
   * IP 54 : 31155
   * 	Config context: FrequencyConverterDefaultIpProtectionLevel - 54
   * 	Behavior: IP Protection level 54
   */
  var strSeriesID = ECL_GetValue("ECSI_CX_SeriesID");
  var strFrequencyConverterDefaultIpProtectionLevel = ECL_GetValue("ECSI_CX_FrequencyConverterDefaultIpProtectionLevel");
  if (strSeriesID == "31155" || strFrequencyConverterDefaultIpProtectionLevel == "54") {
    sKAG = "M54";
  }

  if (sKAG != "NON") {
    bCheck = Check_O_SCHUTZART_G150(oData, sDTKAttribute, sKAG);
  }

  if (bCheck) {
    ECL_ActivateValue(sDTKAttribute, sKAG);
    ECL_SelectValue(sDTKAttribute, sKAG);
  } else {
    if (strFrequencyConverterDefaultIpProtectionLevel == "54") {
      oData.strError = "DICT1_ERR_G150___PARSER_IP_PROTECTION_M54";
      return;
    }

    var aKAG = oData.oParsingData.MLFB.KAG || [];

    if (aKAG.indexOf("M66") >= 0) {
      ECL_ActivateValue(sDTKAttribute, "STM");
      ECL_SelectValue(sDTKAttribute, "STM");
    } else {
      ECL_ActivateValue(sDTKAttribute, "STD");
      ECL_SelectValue(sDTKAttribute, "STD");
    }
  }
}
function Check_O_SCHUTZART_G150(oData, sDTKAttribute, sKAG) {
  if (oData.IsStartConfig == "0") return 1;
  // -----------------------------------------------------------------------------------------
  /*
    VT_G150_M00009	gueltige Schutzart
		IN_BAUART_G150	O_SCHUTZART_G150
	VT_G150_M00022	gueltige Optionen CleanPower/Zertifikate
		O_CLEAN_L01_G150	O_ZERTIFITKAT_G150	O_SCHUTZART_G150
	VT_G150_M00024	gueltige Optionen Anschluesse/Schutzart
		O_NETZANSCH_M13_G150	O_MOTORANSCHL_M78_G150	O_SCHUTZART_G150
	VT_G150_M00102	Mapping Schutzart
		O_SCHUTZART_G150	PMD_ABJ176_001_000_G150
    */
  var IN_BAUART_G150 = ECL_GetValue("IN_BAUART_G150");

  var sTable = "VT_G150_M00009" + sDB_Suffix;
  var sSQL =
    "SELECT " +
    sDTKAttribute +
    " FROM " +
    sTable +
    " WHERE " +
    "IN_BAUART_G150 = '" +
    IN_BAUART_G150 +
    "' AND " +
    sDTKAttribute +
    " = '" +
    sKAG +
    "';";

  var aResult = GetDBDataSetEXT(sSQL);
  if (aResult.length < 1) {
    return 0;
  }
  // -----------------------------------------------------------------------------------------
  return 1;
}
// #############################################################################################

function SetFallnummer_G150(oData) {
  var IN_SPANNUNG_G150 = ECL_GetValue("IN_SPANNUNG_G150");

  var sTable = "VT_G150_M00007" + sDB_Suffix;
  var sSQL =
    "SELECT HMK_FALLNUMMER_G150 FROM " + sTable + " WHERE " + "IN_BAUART_G150 = '00001' AND " + "IN_SPANNUNG_G150 = " + IN_SPANNUNG_G150 + ";";

  var aResult = GetDBDataSetEXT(sSQL);
  if (aResult.length > 0) {
    ECL_SetValue("HMK_FALLNUMMER_G150", aResult[0].HMK_FALLNUMMER_G150);
  } else {
    oData.strError = "DICT1_ERR_G150___PARSER_FALLNUMMER";
    return;
  }
}

function SetAusfuehrung_G150(oData) {
  // VT33
  /*
	VT_G150_M00033 Mapping Ausf.-Mlfb14
		IN_AUSFUEHRUNG_G150	MLFB14_G150
	*/
  var MLFB14_G150 = oData.oParsingData.MLFB.POS14;

  var sTable = "VT_G150_M00033" + sDB_Suffix;
  var sSQL = "SELECT IN_AUSFUEHRUNG_G150 FROM " + sTable + " WHERE " + "MLFB14_G150 = '" + MLFB14_G150 + "';";
  var aResult = GetDBDataSetEXT(sSQL);
  if (aResult.length > 0) {
    ECL_SetValue("IN_AUSFUEHRUNG_G150", aResult[0].IN_AUSFUEHRUNG_G150);
  } else {
    oData.strError = "DICT1_ERR_G150___PARSER_AUSFUEHRUNG";
    return;
  }
}
/*BZ_G150_00187	Trigger Hilfsspannungsversorg.	
		OBJECTS: c is_a (300) skey 'G150'
		RESTRICTION:
			c.H_TRIGGER_AC230V_G150 = 'SPEC'
			if (c.MLFB08_G150 = '2' or
			(
			c.MLFB08_G150 eq '1' and
			c.IN_AUSFUEHRUNG_G150 eq 'A' and
			(
			(c.O_NAMUR_B00_G150 specified and
			c.O_NAMUR_B00_G150 eq 'B00') OR
			(c.O_KLEMMLEISTE_G61_G150 specified and
			c.O_KLEMMLEISTE_G61_G150 eq 'G61') OR
			(c.O_MODULE_G150 specified and
			c.O_MODULE_G150 eq 'K50') OR
			(c.O_SCHUETZ_L13_G150 specified and
			c.O_SCHUETZ_L13_G150 eq 'L13') OR
			(c.O_SCHALTER_L26_G150 specified and
			c.O_SCHALTER_L26_G150 eq 'L26') OR
			(c.O_MOTORSCHUTZ_G150 specified and
			c.O_MOTORSCHUTZ_G150 in ('L57','L59','L60')) OR
			(c.O_THERMISTOR_L83_G150 specified and
			c.O_THERMISTOR_L83_G150 eq 'L83') OR
			(c.O_THERMISTOR_L84_G150 specified and
			c.O_THERMISTOR_L84_G150 eq 'L84') OR
			(c.O_PT100_L86_G150 specified and
			c.O_PT100_L86_G150 eq 'L86') OR
			(c.O_ISO_WACH_L87_G150 specified and
			c.O_ISO_WACH_L87_G150 eq 'L87'))))
		INFERENCES:
			c.H_TRIGGER_AC230V_G150
      */
function SetH_TRIGGER_AC230V_G150(oData) {
  var MLFB08_G150 = oData.oParsingData.MLFB.POS8;
  var IN_AUSFUEHRUNG_G150 = ECL_GetValue("IN_AUSFUEHRUNG_G150");

  var sDTKAttribute = "H_TRIGGER_AC230V_G150";

  var H_TRIGGER_AC230V_G150 = "NONSPEC";

  if (MLFB08_G150 == "2") {
    H_TRIGGER_AC230V_G150 = "SPEC";
  } else if (MLFB08_G150 == "1" && IN_AUSFUEHRUNG_G150 == "A") {
    var aKAG = oData.oParsingData.MLFB.KAG || [];
    if (
      aKAG.indexOf("B00") > -1 ||
      aKAG.indexOf("G61") > -1 ||
      aKAG.indexOf("K50") > -1 ||
      aKAG.indexOf("L13") > -1 ||
      aKAG.indexOf("L26") > -1 ||
      aKAG.indexOf("L57") > -1 ||
      aKAG.indexOf("L59") > -1 ||
      aKAG.indexOf("L60") > -1 ||
      aKAG.indexOf("L83") > -1 ||
      aKAG.indexOf("L84") > -1 ||
      aKAG.indexOf("L86") > -1 ||
      aKAG.indexOf("L87") > -1
    ) {
      H_TRIGGER_AC230V_G150 = "SPEC";
    }
  }
  ECL_ActivateValue(sDTKAttribute, H_TRIGGER_AC230V_G150);
  ECL_SelectValue(sDTKAttribute, H_TRIGGER_AC230V_G150);
}
