//@legacy
//#mode(full-ecma)

//@import "CFG_G150_VT.js"

function SetOptions1_Init_G150(oData) {
  /*
    O_UMGEBUNG_L00_G150	      (L00) Einsatz in der ersten Umgebung nach EN 61800-3 Kategorie C2	x	CB_O_UMGEBUNG_L00_G150
    O_CLEAN_L01_G150	        (L01) Clean Power Ausführung mit integriertem Line Harmonics Filter compact	x	CB_O_CLEAN_L01_G150
    O_SCHNELLANLAUF_L76_G150	(L76) Schnellanlauf (bei Option L01)	x	CB_O_SCHNELLANLAUF_L76_G150
    O_SCHUETZ_L13_G150	      Hauptschütz (für Ströme <= 800 A bei Einfachschaltung)	x	CB_O_SCHUETZ_L13_G150
    O_UEBERSPGSBGZ_L21_G150	  Überspannungsbegrenzung	x	CB_O_UEBERSPGSBGZ_L21_G150
    O_DROSSEL_L22_G150	      Lieferumfang ohne Netzdrossel	x	CB_O_DROSSEL_L22_G150
    O_DROSSELUK_L23_G150	    Netzdrossel uk=2%	x	CB_O_DROSSELUK_L23_G150
    O_SCHALTER_L26_G150	      Hauptschalter inklusive Sicherungen bzw. Leistungsschalter	x	CB_O_SCHALTER_L26_G150
    O_OUTPUT_G150	            Ausgangsseitige Optionen	-	
    O_SCHIRM_M70_G150	        EMV-Schirmschiene	-	
    O_MOTORSCHUTZ_G150	      Not-Aus / Not-Halt	-	
    O_NOT_AUS_TASTER_G150   	NOT-AUS-Taster, eingebaut in der Schranktür	x	CB_O_NOT_AUS_TASTER_G150
    O_THERMISTOR_L83_G150   	Thermistor-Motorschutzgerät (Warnung)	x	CB_O_THERMISTOR_L83_G150
    O_THERMISTOR_L84_G150	    Thermistor-Motorschutzgerät (Abschaltung)	x	CB_O_THERMISTOR_L84_G150
    O_TM150_G150	            1x TM150 Temperatursensorauswerteeinheit	x	CB_O_TM150_G150
    O_PT100_L86_G150	        PT100-Auswertegerät	x	CB_O_PT100_L86_G150
    O_ISO_WACH_L87_G150	      Isolationsüberwachung	x	CB_O_ISO_WACH_L87_G150
    O_FUSSRAUM_G150			      Sockel / Kabelrangierraum	-	
    O_NETZANSCH_M13_G150	    Netzanschluss von oben	x	CB_O_NETZANSCH_M13_G150
    O_KOMFORTGRIFF_M61_G150	  (M61) Komfortgriff mit Verschlusseinsatz 3 mm Doppelbart
    O_KOMFORTGRIFF_M62_G150	  (M62) Komfortgriff mit Verschlusseinsatz Druckknopf
    O_KOMFORTGRIFF_M63_G150	  (M63) Komfortgriff für ein Vorhängeschloss mit Druckknopf als Verschlusseinsatz
    O_MOTORANSCHL_M78_G150	  Motoranschluss von oben	x	CB_O_MOTORANSCHL_M78_G150
    O_KRAN_M90_G150	          Krantransporthilfe	x	CB_O_KRAN_M90_G150
    */

  if (oData && !isEmpty(oData)) {
    Bestimme_L00_G150(oData); //
    Bestimme_L01_G150(oData); //
    Bestimme_L76_G150(oData); //
    Bestimme_L13_G150(oData); //
    Bestimme_L21_G150(oData); //
    Bestimme_L22_G150(oData); //
    Bestimme_L23_G150(oData); //
    Bestimme_L26_G150(oData); //
    Bestimme_O_OUTPUT_G150(oData); //
    Bestimme_M70_G150(oData); //
    Bestimme_O_MOTORSCHUTZ_G150(oData); //
    Bestimme_L45_G150(oData); //
    Bestimme_L83_G150(oData); //
    Bestimme_L84_G150(oData); //
    Bestimme_G51_G150(oData); //
    Bestimme_L86_G150(oData); //
    Bestimme_L87_G150(oData); //
    Bestimme_O_FUSSRAUM_G150(oData); //
    Bestimme_M13_G150(oData); //
    Bestimme_M61_G150(oData); //
    Bestimme_M62_G150(oData); //
    Bestimme_M63_G150(oData); //
    Bestimme_M78_G150(oData); //
    Bestimme_M90_G150(oData); //
  } else {
    ECL_DeselectAttribute("CB_O_UMGEBUNG_L00_G150");
    ECL_DeselectAttribute("CB_O_CLEAN_L01_G150");
    ECL_DeselectAttribute("CB_O_SCHNELLANLAUF_L76_G150");
    ECL_DeselectAttribute("CB_O_SCHUETZ_L13_G150");
    ECL_DeselectAttribute("CB_O_UEBERSPGSBGZ_L21_G150");
    ECL_DeselectAttribute("CB_O_DROSSEL_L22_G150");
    ECL_DeselectAttribute("CB_O_DROSSELUK_L23_G150");

    ExecSetStandardifValueEmpty("O_OUTPUT_G150", "STD");
    ExecSetStandardifValueEmpty("O_SCHIRM_M70_G150", "STD");
    ExecSetStandardifValueEmpty("O_MOTORSCHUTZ_G150", "STD");

    ECL_DeselectAttribute("CB_O_NOT_AUS_TASTER_G150");
    ECL_DeselectAttribute("CB_O_THERMISTOR_L83_G150");
    ECL_DeselectAttribute("CB_O_THERMISTOR_L84_G150");
    ECL_DeselectAttribute("CB_O_TM150_G150");
    ECL_DeselectAttribute("CB_O_PT100_L86_G150");
    ECL_DeselectAttribute("CB_O_ISO_WACH_L87_G150");
    ExecSetStandardifValueEmpty("O_FUSSRAUM_G150", "STD");
    ECL_DeselectAttribute("CB_O_NETZANSCH_M13_G150");
    ECL_DeselectAttribute("CB_O_MOTORANSCHL_M78_G150");
    ECL_DeselectAttribute("CB_O_KRAN_M90_G150");
  }
}

// #############################################################################################
// O_UMGEBUNG_L00_G150	        (L00) Einsatz in der ersten Umgebung nach EN 61800-3 Kategorie C2	x	CB_O_UMGEBUNG_L00_G150
function Bestimme_L00_G150(oData) {
  // O_UMGEBUNG_L00_G150
  var sDTKAttribute = "O_UMGEBUNG_L00_G150";
  var sCB_Attribute = "CB_" + sDTKAttribute;

  var sKAG = "L00";

  var bCheck = false;
  var aKAG = oData.oParsingData.MLFB.KAG || [];

  if (aKAG.indexOf(sKAG) >= 0) {
    bCheck = Check_L00_G150(oData, sDTKAttribute, sKAG);
  }
  if (bCheck) {
    ECL_EnableAttribute(sCB_Attribute);
    ECL_SelectValue(sCB_Attribute, "T");
  } else {
    ECL_DeselectAttribute(sCB_Attribute);
  }
}

function Check_L00_G150(oData, sDTKAttribute, sKAG) {
  if (oData.IsStartConfig == "0") return 1;
  // -----------------------------------------------------------------------------------------
  /*
    A VT_G150_M00110	Einschraenkungen_MLFB_L00_L01_L22_L23
    HMK_FALLNUMMER_G150	MLFB11_G150	O_UMGEBUNG_L00_G150	O_CLEAN_L01_G150	O_DROSSEL_L22_G150	O_DROSSELUK_L23_G150

    B VT_G150_M00076	Gueltige Optionen Ausfuehrung I
    IN_AUSFUEHRUNG_G150	O_UMGEBUNG_L00_G150	O_CLEAN_L01_G150	O_SCHUETZ_L13_G150	O_SCHALTER_L26_G150
    */
  var HMK_FALLNUMMER_G150 = ECL_GetValue("HMK_FALLNUMMER_G150");
  var MLFB11_G150 = oData.oParsingData.MLFB.POS11_13;

  var sTable = "VT_G150_M00110" + sDB_Suffix;
  var sSQL =
    "SELECT " +
    sDTKAttribute +
    " FROM " +
    sTable +
    " WHERE " +
    "HMK_FALLNUMMER_G150 = '" +
    HMK_FALLNUMMER_G150 +
    "' AND " +
    "MLFB11_G150 = '" +
    MLFB11_G150 +
    "' AND " +
    sDTKAttribute +
    " = '" +
    sKAG +
    "';";

  var aResult = GetDBDataSetEXT(sSQL);
  if (aResult.length < 1) {
    return 0;
  }
  // -----------------------------------------------------------------------------------------
  var IN_AUSFUEHRUNG_G150 = ECL_GetValue("IN_AUSFUEHRUNG_G150");

  var sTable = "VT_G150_M00076" + sDB_Suffix;
  var sSQL =
    "SELECT " +
    sDTKAttribute +
    " FROM " +
    sTable +
    " WHERE " +
    "IN_AUSFUEHRUNG_G150 = '" +
    IN_AUSFUEHRUNG_G150 +
    "' AND " +
    sDTKAttribute +
    " = '" +
    sKAG +
    "';";

  var aResult = GetDBDataSetEXT(sSQL);
  if (aResult.length < 1) {
    return 0;
  }
  // -----------------------------------------------------------------------------------------
  return 1;
}
// #############################################################################################
// O_CLEAN_L01_G150	        (L01) Clean Power Ausführung mit integriertem Line Harmonics Filter compact	x	CB_O_CLEAN_L01_G150
function Bestimme_L01_G150(oData) {
  // O_CLEAN_L01_G150
  var sDTKAttribute = "O_CLEAN_L01_G150";
  var sCB_Attribute = "CB_" + sDTKAttribute;

  var sKAG = "L01";

  var bCheck = false;
  var aKAG = oData.oParsingData.MLFB.KAG || [];

  if (aKAG.indexOf(sKAG) >= 0) {
    bCheck = Check_L01_G150(oData, sDTKAttribute, sKAG);
  }
  if (bCheck) {
    ECL_EnableAttribute(sCB_Attribute);
    ECL_SelectValue(sCB_Attribute, "T");
  } else {
    ECL_DeselectAttribute(sCB_Attribute);
  }
}

function Check_L01_G150(oData, sDTKAttribute, sKAG) {
  if (oData.IsStartConfig == "0") return 1;
  // -----------------------------------------------------------------------------------------
  /*
        A VT_G150_M00062	gueltige Optionen L01,L13,L26
        B VT_G150_M00076	Gueltige Optionen Ausfuehrung I
        C VT_G150_M00110	Einschraenkungen_MLFB_L00_L01_L22_L23
    */
  // -----------------------------------------------------------------------------------------
  // A VT_G150_M00062	gueltige Optionen L01,L13,L26
  // 		HMK_FALLNUMMER_G150	MLFB11_G150	O_CLEAN_L01_G150	O_SCHUETZ_L13_G150	O_SCHALTER_L26_G150
  var HMK_FALLNUMMER_G150 = ECL_GetValue("HMK_FALLNUMMER_G150");
  var MLFB11_G150 = oData.oParsingData.MLFB.POS11_13;

  var sTable = "VT_G150_M00062" + sDB_Suffix;

  var sSQL =
    "SELECT " +
    sDTKAttribute +
    " FROM " +
    sTable +
    " WHERE " +
    "HMK_FALLNUMMER_G150 = '" +
    HMK_FALLNUMMER_G150 +
    "' AND " +
    "MLFB11_G150 = '" +
    MLFB11_G150 +
    "' AND " +
    sDTKAttribute +
    " = '" +
    sKAG +
    "';";

  var aResult = GetDBDataSetEXT(sSQL);
  if (aResult.length < 1) {
    return 0;
  }
  // --------------------------------------------------------------------------------------------
  // B VT_G150_M00076	Gueltige Optionen Ausfuehrung I
  // 		IN_AUSFUEHRUNG_G150	O_UMGEBUNG_L00_G150	O_CLEAN_L01_G150	O_SCHUETZ_L13_G150	O_SCHALTER_L26_G150
  var IN_AUSFUEHRUNG_G150 = ECL_GetValue("IN_AUSFUEHRUNG_G150");

  var sTable = "VT_G150_M00076" + sDB_Suffix;

  var sSQL =
    "SELECT " +
    sDTKAttribute +
    " FROM " +
    sTable +
    " WHERE " +
    "IN_AUSFUEHRUNG_G150 = '" +
    IN_AUSFUEHRUNG_G150 +
    "' AND " +
    sDTKAttribute +
    " = '" +
    sKAG +
    "';";

  var aResult = GetDBDataSetEXT(sSQL);
  if (aResult.length < 1) {
    return 0;
  }
  // --------------------------------------------------------------------------------------------
  // C VT_G150_M00110	Einschraenkungen_MLFB_L00_L01_L22_L23
  // 		HMK_FALLNUMMER_G150	MLFB11_G150	O_UMGEBUNG_L00_G150	O_CLEAN_L01_G150	O_DROSSEL_L22_G150	O_DROSSELUK_L23_G150

  var sTable = "VT_G150_M00110" + sDB_Suffix;
  var sSQL =
    "SELECT " +
    sDTKAttribute +
    " FROM " +
    sTable +
    " WHERE " +
    "HMK_FALLNUMMER_G150 = '" +
    HMK_FALLNUMMER_G150 +
    "' AND " +
    "MLFB11_G150 = '" +
    MLFB11_G150 +
    "' AND " +
    sDTKAttribute +
    " = '" +
    sKAG +
    "';";

  var aResult = GetDBDataSetEXT(sSQL);
  if (aResult.length < 1) {
    return 0;
  }
  // -----------------------------------------------------------------------------------------
  return 1;
}
// #############################################################################################
// O_SCHNELLANLAUF_L76_G150	(L76) Schnellanlauf (bei Option L01)	x	CB_O_SCHNELLANLAUF_L76_G150
function Bestimme_L76_G150(oData) {
  // O_SCHNELLANLAUF_L76_G150
  var sDTKAttribute = "O_SCHNELLANLAUF_L76_G150";
  var sCB_Attribute = "CB_" + sDTKAttribute;

  var sKAG = "L76";

  var bCheck = false;
  var aKAG = oData.oParsingData.MLFB.KAG || [];

  if (aKAG.indexOf(sKAG) >= 0) {
    bCheck = Check_L76_G150(oData, sDTKAttribute, sKAG);
  }
  if (bCheck) {
    ECL_EnableAttribute(sCB_Attribute);
    ECL_SelectValue(sCB_Attribute, "T");
  } else {
    ECL_DeselectAttribute(sCB_Attribute);
  }
}

function Check_L76_G150(oData, sDTKAttribute, sKAG) {
  if (oData.IsStartConfig == "0") return 1;
  // -----------------------------------------------------------------------------------------
  /*
    VT_G150_M00108	Einschraenkungen_L01_L76
    O_CLEAN_L01_G150	O_SCHNELLANLAUF_L76_G150
    */
  var O_CLEAN_L01_G150 = "STD";
  if (ECL_ValueSelected("CB_O_CLEAN_L01_G150", "T")) {
    O_CLEAN_L01_G150 = "L01";
  }

  var sTable = "VT_G150_M00108" + sDB_Suffix;
  var sSQL =
    "SELECT " +
    sDTKAttribute +
    " FROM " +
    sTable +
    " WHERE " +
    "O_CLEAN_L01_G150 = '" +
    O_CLEAN_L01_G150 +
    "' AND " +
    sDTKAttribute +
    " = '" +
    sKAG +
    "';";

  var aResult = GetDBDataSetEXT(sSQL);
  if (aResult.length < 1) {
    return 0;
  }
  // -----------------------------------------------------------------------------------------
  return 1;
}
// #############################################################################################
// O_SCHUETZ_L13_G150	        Hauptschütz (für Ströme <= 800 A bei Einfachschaltung)	x	CB_O_SCHUETZ_L13_G150
function Bestimme_L13_G150(oData) {
  // O_SCHUETZ_L13_G150
  var sDTKAttribute = "O_SCHUETZ_L13_G150";
  var sCB_Attribute = "CB_" + sDTKAttribute;

  var sKAG = "L13";

  var bCheck = false;
  var aKAG = oData.oParsingData.MLFB.KAG || [];

  if (aKAG.indexOf(sKAG) >= 0) {
    bCheck = Check_L13_G150(oData, sDTKAttribute, sKAG);
  }
  if (bCheck) {
    ECL_EnableAttribute(sCB_Attribute);
    ECL_SelectValue(sCB_Attribute, "T");
  } else {
    ECL_DeselectAttribute(sCB_Attribute);
  }
}
function Check_L13_G150(oData, sDTKAttribute, sKAG) {
  if (oData.IsStartConfig == "0") return 1;
  // -----------------------------------------------------------------------------------------
  /*  A	VT_G150_M00062	gueltige Optionen L01,L13,L26
        HMK_FALLNUMMER_G150		MLFB11_G150		O_CLEAN_L01_G150	O_SCHUETZ_L13_G150		O_SCHALTER_L26_G150
    B 	VT_G150_M00074	gueltige Optionen L13,26,57,59,60+Strom
      HMK_FALLNUMMER_G150		MLFB11_G150		O_MOTORSCHUTZ_G150	O_SCHUETZ_L13_G150	O_SCHALTER_L26_G150
    C	VT_G150_M00076	gueltige Optionen Ausfuehrung I
      IN_AUSFUEHRUNG_G150		O_UMGEBUNG_L00_G150		O_CLEAN_L01_G150	O_SCHUETZ_L13_G150	O_SCHALTER_L26_G150
    n.n. VT_G150_M00087	Verriegelung Optionen - Einbaugeraet IV
      O_UMGEBUNG_L00_G150		O_CLEAN_L01_G150	O_SCHUETZ_L13_G150	O_DROSSEL_L22_G150	O_DROSSELUK_L23_G150	O_SCHALTER_L26_G150
    D	VT_G150_M00107	Einschraenkungen_MLFB_B00_L13_L26
      HMK_FALLNUMMER_G150		MLFB11_G150		O_NAMUR_B00_G150	O_SCHUETZ_L13_G150	O_SCHALTER_L26_G150
  */

  /* A VT_G150_M00062	gueltige Optionen L01,L13,L26
        HMK_FALLNUMMER_G150		MLFB11_G150		O_CLEAN_L01_G150	O_SCHUETZ_L13_G150		O_SCHALTER_L26_G150
  */
  var HMK_FALLNUMMER_G150 = ECL_GetValue("HMK_FALLNUMMER_G150");
  var MLFB11_G150 = oData.oParsingData.MLFB.POS11_13;

  var O_CLEAN_L01_G150 = "STD";
  if (ECL_ValueSelected("CB_O_CLEAN_L01_G150", "T")) {
    O_CLEAN_L01_G150 = "L01";
  }

  var sTable = "VT_G150_M00062" + sDB_Suffix;
  var sSQL =
    "SELECT " +
    sDTKAttribute +
    " FROM " +
    sTable +
    " WHERE " +
    "HMK_FALLNUMMER_G150 = '" +
    HMK_FALLNUMMER_G150 +
    "' AND " +
    "MLFB11_G150 = '" +
    MLFB11_G150 +
    "' AND " +
    "O_CLEAN_L01_G150 = '" +
    O_CLEAN_L01_G150 +
    "' AND " +
    sDTKAttribute +
    " = '" +
    sKAG +
    "';";

  var aResult = GetDBDataSetEXT(sSQL);
  if (aResult.length < 1) {
    return 0;
  }
  // --------------------------------------------------------------------------------------------
  // B VT_G150_M00074	gueltige Optionen L13,26,57,59,60+Strom
  //		HMK_FALLNUMMER_G150		MLFB11_G150		O_MOTORSCHUTZ_G150	O_SCHUETZ_L13_G150	O_SCHALTER_L26_G150

  var sTable = "VT_G150_M00074" + sDB_Suffix;
  var sSQL =
    "SELECT " +
    sDTKAttribute +
    " FROM " +
    sTable +
    " WHERE " +
    "HMK_FALLNUMMER_G150 = '" +
    HMK_FALLNUMMER_G150 +
    "' AND " +
    "MLFB11_G150 = '" +
    MLFB11_G150 +
    "' AND " +
    sDTKAttribute +
    " = '" +
    sKAG +
    "';";

  var aResult = GetDBDataSetEXT(sSQL);
  if (aResult.length < 1) {
    return 0;
  }
  // --------------------------------------------------------------------------------------------
  // C	VT_G150_M00076	gueltige Optionen Ausfuehrung I
  //		IN_AUSFUEHRUNG_G150		O_UMGEBUNG_L00_G150		O_CLEAN_L01_G150	O_SCHUETZ_L13_G150	O_SCHALTER_L26_G150
  var IN_AUSFUEHRUNG_G150 = ECL_GetValue("IN_AUSFUEHRUNG_G150");

  var O_UMGEBUNG_L00_G150 = "STD";
  if (ECL_ValueSelected("CB_O_UMGEBUNG_L00_G150", "T")) {
    O_UMGEBUNG_L00_G150 = "L00";
  }
  var sTable = "VT_G150_M00076" + sDB_Suffix;
  var sSQL =
    "SELECT " +
    sDTKAttribute +
    " FROM " +
    sTable +
    " WHERE " +
    "IN_AUSFUEHRUNG_G150 = '" +
    IN_AUSFUEHRUNG_G150 +
    "' AND " +
    "O_UMGEBUNG_L00_G150 = '" +
    O_UMGEBUNG_L00_G150 +
    "' AND " +
    "O_CLEAN_L01_G150 = '" +
    O_CLEAN_L01_G150 +
    "' AND " +
    sDTKAttribute +
    " = '" +
    sKAG +
    "';";

  var aResult = GetDBDataSetEXT(sSQL);
  if (aResult.length < 1) {
    return 0;
  }
  // --------------------------------------------------------------------------------------------
  // D	VT_G150_M00107	Einschraenkungen_MLFB_B00_L13_L26
  //		HMK_FALLNUMMER_G150		MLFB11_G150		O_NAMUR_B00_G150	O_SCHUETZ_L13_G150	O_SCHALTER_L26_G150

  var sTable = "VT_G150_M00107" + sDB_Suffix;
  var sSQL =
    "SELECT " +
    sDTKAttribute +
    " FROM " +
    sTable +
    " WHERE " +
    "HMK_FALLNUMMER_G150 = '" +
    HMK_FALLNUMMER_G150 +
    "' AND " +
    "MLFB11_G150 = '" +
    MLFB11_G150 +
    "' AND " +
    sDTKAttribute +
    " = '" +
    sKAG +
    "';";

  var aResult = GetDBDataSetEXT(sSQL);
  if (aResult.length < 1) {
    return 0;
  }
  // -----------------------------------------------------------------------------------------
  return 1;
}

// #############################################################################################
// O_UEBERSPGSBGZ_L21_G150	    Überspannungsbegrenzung	x	CB_O_UEBERSPGSBGZ_L21_G150
function Bestimme_L21_G150(oData) {
  // O_UEBERSPGSBGZ_L21_G150
  var sDTKAttribute = "O_UEBERSPGSBGZ_L21_G150";
  var sCB_Attribute = "CB_" + sDTKAttribute;

  var sKAG = "L21";

  var bCheck = false;
  var aKAG = oData.oParsingData.MLFB.KAG || [];

  if (aKAG.indexOf(sKAG) >= 0) {
    bCheck = Check_L21_G150(oData, sDTKAttribute, sKAG);
  }
  if (bCheck) {
    ECL_EnableAttribute(sCB_Attribute);
    ECL_SelectValue(sCB_Attribute, "T");
  } else {
    ECL_DeselectAttribute(sCB_Attribute);
  }
}
function Check_L21_G150(oData, sDTKAttribute, sKAG) {
  if (oData.IsStartConfig == "0") return 1;
  // -----------------------------------------------------------------------------------------
  /*
    VT_G150_M00122	Ausfuehrung_L21
    IN_AUSFUEHRUNG_G150	O_UEBERSPGSBGZ_L21_G150
  */
  var IN_AUSFUEHRUNG_G150 = ECL_GetValue("IN_AUSFUEHRUNG_G150");

  var sTable = "VT_G150_M00122" + sDB_Suffix;
  var sSQL =
    "SELECT " +
    sDTKAttribute +
    " FROM " +
    sTable +
    " WHERE " +
    "IN_AUSFUEHRUNG_G150 = '" +
    IN_AUSFUEHRUNG_G150 +
    "' AND " +
    sDTKAttribute +
    " = '" +
    sKAG +
    "';";

  var aResult = GetDBDataSetEXT(sSQL);
  if (aResult.length < 1) {
    return 0;
  }
  // -----------------------------------------------------------------------------------------
  return 1;
}
// #############################################################################################
// O_DROSSEL_L22_G150	        Lieferumfang ohne Netzdrossel	x	CB_O_DROSSEL_L22_G150
function Bestimme_L22_G150(oData) {
  // O_DROSSEL_L22_G150
  var sDTKAttribute = "O_DROSSEL_L22_G150";
  var sCB_Attribute = "CB_" + sDTKAttribute;

  var sKAG = "L22";

  var bCheck = false;
  var aKAG = oData.oParsingData.MLFB.KAG || [];

  if (aKAG.indexOf(sKAG) >= 0) {
    bCheck = Check_L22_G150(oData, sDTKAttribute, sKAG);
  }
  if (bCheck) {
    ECL_EnableAttribute(sCB_Attribute);
    ECL_SelectValue(sCB_Attribute, "T");
  } else {
    ECL_DeselectAttribute(sCB_Attribute);
  }
}
function Check_L22_G150(oData, sDTKAttribute, sKAG) {
  if (oData.IsStartConfig == "0") return 1;
  // -----------------------------------------------------------------------------------------
  /*
    // C VT_G150_M00110	Einschraenkungen_MLFB_L00_L01_L22_L23
  // 		HMK_FALLNUMMER_G150	MLFB11_G150	O_UMGEBUNG_L00_G150	O_CLEAN_L01_G150	O_DROSSEL_L22_G150	O_DROSSELUK_L23_G150
  */
  var HMK_FALLNUMMER_G150 = ECL_GetValue("HMK_FALLNUMMER_G150");
  var MLFB11_G150 = oData.oParsingData.MLFB.POS11_13;

  var O_UMGEBUNG_L00_G150 = "STD";
  if (ECL_ValueSelected("CB_O_UMGEBUNG_L00_G150", "T")) {
    O_UMGEBUNG_L00_G150 = "L00";
  }
  var O_CLEAN_L01_G150 = "STD";
  if (ECL_ValueSelected("CB_O_CLEAN_L01_G150", "T")) {
    O_CLEAN_L01_G150 = "L01";
  }

  var sTable = "VT_G150_M00110" + sDB_Suffix;
  var sSQL =
    "SELECT " +
    sDTKAttribute +
    " FROM " +
    sTable +
    " WHERE " +
    "HMK_FALLNUMMER_G150 = '" +
    HMK_FALLNUMMER_G150 +
    "' AND " +
    "MLFB11_G150 = '" +
    MLFB11_G150 +
    "' AND " +
    "O_UMGEBUNG_L00_G150 = '" +
    O_UMGEBUNG_L00_G150 +
    "' AND " +
    "O_CLEAN_L01_G150 = '" +
    O_CLEAN_L01_G150 +
    "' AND " +
    sDTKAttribute +
    " = '" +
    sKAG +
    "';";

  var aResult = GetDBDataSetEXT(sSQL);
  if (aResult.length < 1) {
    return 0;
  }
  // -----------------------------------------------------------------------------------------
  return 1;
}
// #############################################################################################
// O_DROSSELUK_L23_G150	    Netzdrossel uk=2%	x	CB_O_DROSSELUK_L23_G150
function Bestimme_L23_G150(oData) {
  // O_DROSSELUK_L23_G150
  var sDTKAttribute = "O_DROSSELUK_L23_G150";
  var sCB_Attribute = "CB_" + sDTKAttribute;

  var sKAG = "L23";

  var bCheck = false;
  var aKAG = oData.oParsingData.MLFB.KAG || [];

  if (aKAG.indexOf(sKAG) >= 0) {
    bCheck = Check_L23_G150(oData, sDTKAttribute, sKAG);
  }
  if (bCheck) {
    ECL_EnableAttribute(sCB_Attribute);
    ECL_SelectValue(sCB_Attribute, "T");
  } else {
    ECL_DeselectAttribute(sCB_Attribute);
  }
}
function Check_L23_G150(oData, sDTKAttribute, sKAG) {
  if (oData.IsStartConfig == "0") return 1;
  // -----------------------------------------------------------------------------------------
  /*
    VT_G150_M00110	Einschraenkungen_MLFB_L00_L01_L22_L23
    HMK_FALLNUMMER_G150	MLFB11_G150	O_UMGEBUNG_L00_G150	O_CLEAN_L01_G150	O_DROSSEL_L22_G150	O_DROSSELUK_L23_G150
    */
  var HMK_FALLNUMMER_G150 = ECL_GetValue("HMK_FALLNUMMER_G150");
  var MLFB11_G150 = oData.oParsingData.MLFB.POS11_13;

  var O_UMGEBUNG_L00_G150 = "STD";
  if (ECL_ValueSelected("CB_O_UMGEBUNG_L00_G150", "T")) {
    O_UMGEBUNG_L00_G150 = "L00";
  }
  var O_CLEAN_L01_G150 = "STD";
  if (ECL_ValueSelected("CB_O_CLEAN_L01_G150", "T")) {
    O_CLEAN_L01_G150 = "L01";
  }
  var O_DROSSEL_L22_G150 = "STD";
  if (ECL_ValueSelected("CB_O_DROSSEL_L22_G150", "T")) {
    O_DROSSEL_L22_G150 = "L22";
  }

  var sTable = "VT_G150_M00110" + sDB_Suffix;
  var sSQL =
    "SELECT " +
    sDTKAttribute +
    " FROM " +
    sTable +
    " WHERE " +
    "HMK_FALLNUMMER_G150 = '" +
    HMK_FALLNUMMER_G150 +
    "' AND " +
    "MLFB11_G150 = '" +
    MLFB11_G150 +
    "' AND " +
    "O_UMGEBUNG_L00_G150 = '" +
    O_UMGEBUNG_L00_G150 +
    "' AND " +
    "O_CLEAN_L01_G150 = '" +
    O_CLEAN_L01_G150 +
    "' AND " +
    "O_DROSSEL_L22_G150 = '" +
    O_DROSSEL_L22_G150 +
    "' AND " +
    sDTKAttribute +
    " = '" +
    sKAG +
    "';";

  var aResult = GetDBDataSetEXT(sSQL);
  if (aResult.length < 1) {
    return 0;
  }
  // -----------------------------------------------------------------------------------------
  return 1;
}
// #############################################################################################
// O_SCHALTER_L26_G150	        Hauptschalter inklusive Sicherungen bzw. Leistungsschalter	x	CB_O_SCHALTER_L26_G150
function Bestimme_L26_G150(oData) {
  // O_SCHALTER_L26_G150
  var sDTKAttribute = "O_SCHALTER_L26_G150";
  var sCB_Attribute = "CB_" + sDTKAttribute;

  var sKAG = "L26";

  var bCheck = false;
  var aKAG = oData.oParsingData.MLFB.KAG || [];

  if (aKAG.indexOf(sKAG) >= 0) {
    bCheck = Check_L26_G150(oData, sDTKAttribute, sKAG);
  }
  if (bCheck) {
    ECL_EnableAttribute(sCB_Attribute);
    ECL_SelectValue(sCB_Attribute, "T");
  } else {
    ECL_DeselectAttribute(sCB_Attribute);
  }
}
function Check_L26_G150(oData, sDTKAttribute, sKAG) {
  if (oData.IsStartConfig == "0") return 1;
  // -----------------------------------------------------------------------------------------
  /*
    VT_G150_M00108	Einschraenkungen_L01_L76
    O_CLEAN_L01_G150	O_SCHNELLANLAUF_L76_G150
    */
  var HMK_FALLNUMMER_G150 = ECL_GetValue("HMK_FALLNUMMER_G150");
  var MLFB11_G150 = oData.oParsingData.MLFB.POS11_13;
  var IN_AUSFUEHRUNG_G150 = ECL_GetValue("IN_AUSFUEHRUNG_G150");

  // A VT_G150_M00062	gueltige Optionen L01,L13,L26
  // 		HMK_FALLNUMMER_G150		MLFB11_G150		O_CLEAN_L01_G150	O_SCHUETZ_L13_G150		O_SCHALTER_L26_G150
  var O_CLEAN_L01_G150 = "STD";
  if (ECL_ValueSelected("CB_O_CLEAN_L01_G150", "T")) {
    O_CLEAN_L01_G150 = "L01";
  }
  var O_SCHUETZ_L13_G150 = "STD";
  if (ECL_ValueSelected("CB_O_SCHUETZ_L13_G150", "T")) {
    O_SCHUETZ_L13_G150 = "L13";
  }

  var sTable = "VT_G150_M00062" + sDB_Suffix;
  var sSQL =
    "SELECT " +
    sDTKAttribute +
    " FROM " +
    sTable +
    " WHERE " +
    "HMK_FALLNUMMER_G150 = '" +
    HMK_FALLNUMMER_G150 +
    "' AND " +
    "MLFB11_G150 = '" +
    MLFB11_G150 +
    "' AND " +
    "O_CLEAN_L01_G150 = '" +
    O_CLEAN_L01_G150 +
    "' AND " +
    "O_SCHUETZ_L13_G150 = '" +
    O_SCHUETZ_L13_G150 +
    "' AND " +
    sDTKAttribute +
    " = '" +
    sKAG +
    "';";

  var aResult = GetDBDataSetEXT(sSQL);
  if (aResult.length < 1) {
    return 0;
  }
  // --------------------------------------------------------------------------------------------
  // B VT_G150_M00074	gueltige Optionen L13,26,57,59,60+Strom
  //		HMK_FALLNUMMER_G150		MLFB11_G150		O_MOTORSCHUTZ_G150	O_SCHUETZ_L13_G150	O_SCHALTER_L26_G150
  var sTable = "VT_G150_M00074" + sDB_Suffix;
  var sSQL =
    "SELECT " +
    sDTKAttribute +
    " FROM " +
    sTable +
    " WHERE " +
    "HMK_FALLNUMMER_G150 = '" +
    HMK_FALLNUMMER_G150 +
    "' AND " +
    "MLFB11_G150 = '" +
    MLFB11_G150 +
    "' AND " +
    "O_SCHUETZ_L13_G150 = '" +
    O_SCHUETZ_L13_G150 +
    "' AND " +
    sDTKAttribute +
    " = '" +
    sKAG +
    "';";

  var aResult = GetDBDataSetEXT(sSQL);
  if (aResult.length < 1) {
    return 0;
  }
  // --------------------------------------------------------------------------------------------
  // C	VT_G150_M00076	gueltige Optionen Ausfuehrung I
  //		IN_AUSFUEHRUNG_G150		O_UMGEBUNG_L00_G150		O_CLEAN_L01_G150	O_SCHUETZ_L13_G150	O_SCHALTER_L26_G150
  var O_UMGEBUNG_L00_G150 = "STD";
  if (ECL_ValueSelected("CB_O_UMGEBUNG_L00_G150", "T")) {
    O_UMGEBUNG_L00_G150 = "L00";
  }
  var sTable = "VT_G150_M00076" + sDB_Suffix;
  var sSQL =
    "SELECT " +
    sDTKAttribute +
    " FROM " +
    sTable +
    " WHERE " +
    "IN_AUSFUEHRUNG_G150 = '" +
    IN_AUSFUEHRUNG_G150 +
    "' AND " +
    "O_UMGEBUNG_L00_G150 = '" +
    O_UMGEBUNG_L00_G150 +
    "' AND " +
    "O_CLEAN_L01_G150 = '" +
    O_CLEAN_L01_G150 +
    "' AND " +
    "O_SCHUETZ_L13_G150 = '" +
    O_SCHUETZ_L13_G150 +
    "' AND " +
    sDTKAttribute +
    " = '" +
    sKAG +
    "';";

  var aResult = GetDBDataSetEXT(sSQL);
  if (aResult.length < 1) {
    return 0;
  }
  // --------------------------------------------------------------------------------------------
  // D	VT_G150_M00107	Einschraenkungen_MLFB_B00_L13_L26
  //		HMK_FALLNUMMER_G150		MLFB11_G150		O_NAMUR_B00_G150	O_SCHUETZ_L13_G150	O_SCHALTER_L26_G150
  var sTable = "VT_G150_M00107" + sDB_Suffix;
  var sSQL =
    "SELECT " +
    sDTKAttribute +
    " FROM " +
    sTable +
    " WHERE " +
    "HMK_FALLNUMMER_G150 = '" +
    HMK_FALLNUMMER_G150 +
    "' AND " +
    "MLFB11_G150 = '" +
    MLFB11_G150 +
    "' AND " +
    "O_SCHUETZ_L13_G150 = '" +
    O_SCHUETZ_L13_G150 +
    "' AND " +
    sDTKAttribute +
    " = '" +
    sKAG +
    "';";

  var aResult = GetDBDataSetEXT(sSQL);
  if (aResult.length < 1) {
    return 0;
  }
  // -----------------------------------------------------------------------------------------
  return 1;
}
// #############################################################################################
// O_OUTPUT_G150	            Ausgangsseitige Optionen	-
function Bestimme_O_OUTPUT_G150(oData) {
  // O_OUTPUT_G150
  var sDTKAttribute = "O_OUTPUT_G150";

  // KAGs  STD, L07, L08, L10, L15, M75
  var aKAG = oData.oParsingData.MLFB.KAG || [];

  var sKAG = getKAGforAttribute(sDTKAttribute, aKAG);
  var bCheck = false;
  if (sKAG != "NON") {
    bCheck = Check_O_OUTPUT_G150(oData, sDTKAttribute, sKAG);
  }
  if (bCheck) {
    ECL_ActivateValue(sDTKAttribute, sKAG);
    ECL_SelectValue(sDTKAttribute, sKAG);
  } else {
    ECL_ActivateValue(sDTKAttribute, "STD");
    ECL_SelectValue(sDTKAttribute, "STD");
  }
}
function Check_O_OUTPUT_G150(oData, sDTKAttribute, sKAG) {
  if (oData.IsStartConfig == "0") return 1;
  // -----------------------------------------------------------------------------------------
  /*
    VT_G150_M00108	Einschraenkungen_L01_L76
    O_CLEAN_L01_G150	O_SCHNELLANLAUF_L76_G150
    */
  var HMK_FALLNUMMER_G150 = ECL_GetValue("HMK_FALLNUMMER_G150");
  var MLFB11_G150 = oData.oParsingData.MLFB.POS11_13;
  var IN_AUSFUEHRUNG_G150 = ECL_GetValue("IN_AUSFUEHRUNG_G150");
  // --------------------------------------------------------------------------------------------
  // A VT_G150_M00109	Einschraenkungen_MLFB_L07_L08_L10_L15
  //		HMK_FALLNUMMER_G150		MLFB11_G150		O_OUTPUT_G150
  var sTable = "VT_G150_M00109" + sDB_Suffix;
  var sSQL =
    "SELECT " +
    sDTKAttribute +
    " FROM " +
    sTable +
    " WHERE " +
    "HMK_FALLNUMMER_G150 = '" +
    HMK_FALLNUMMER_G150 +
    "' AND " +
    "MLFB11_G150 = '" +
    MLFB11_G150 +
    "' AND " +
    sDTKAttribute +
    " = '" +
    sKAG +
    "';";

  var aResult = GetDBDataSetEXT(sSQL);
  if (aResult.length < 1) {
    return 0;
  }
  // --------------------------------------------------------------------------------------------
  // B VT_G150_M00077	Gueltige Optionen Ausfuehrung II
  //		IN_AUSFUEHRUNG_G150		O_OUTPUT_G150	O_NETZANSCH_M13_G150	O_MOTORANSCHL_M78_G150
  var sTable = "VT_G150_M00077" + sDB_Suffix;
  var sSQL =
    "SELECT " +
    sDTKAttribute +
    " FROM " +
    sTable +
    " WHERE " +
    "IN_AUSFUEHRUNG_G150 = '" +
    IN_AUSFUEHRUNG_G150 +
    "' AND " +
    sDTKAttribute +
    " = '" +
    sKAG +
    "';";

  var aResult = GetDBDataSetEXT(sSQL);
  if (aResult.length < 1) {
    return 0;
  }
  // -----------------------------------------------------------------------------------------
  return 1;
}
// #############################################################################################
// O_SCHIRM_M70_G150	        EMV-Schirmschiene
function Bestimme_M70_G150(oData) {
  // O_SCHIRM_M70_G150
  var sDTKAttribute = "O_SCHIRM_M70_G150";
  // KAGs  STD, EMV, M70 (EMV enthalten in L00)
  var aKAG = oData.oParsingData.MLFB.KAG || [];

  var sKAG = getKAGforAttribute(sDTKAttribute, aKAG);
  var bCheck = false;
  if (sKAG != "NON") {
    bCheck = Check_M70_G150(oData, sDTKAttribute, sKAG);
  }
  if (bCheck) {
    ECL_ActivateValue(sDTKAttribute, sKAG);
    ECL_SelectValue(sDTKAttribute, sKAG);
  } else {
    if (ECL_ValueSelected("CB_O_UMGEBUNG_L00_G150", "T")) {
      ECL_DeactivateAllAttributeValues(sDTKAttribute);
      ECL_ActivateValue(sDTKAttribute, "EMV");
      ECL_SelectValue(sDTKAttribute, "EMV");
    } else {
      ECL_ActivateValue(sDTKAttribute, "STD");
      ECL_SelectValue(sDTKAttribute, "STD");
    }
  }
}
function Check_M70_G150(oData, sDTKAttribute, sKAG) {
  if (oData.IsStartConfig == "0") return 1;
  // -----------------------------------------------------------------------------------------
  /*
        Wenn L00, statt M70 ==> EMV
    */
  if (ECL_ValueSelected("CB_O_UMGEBUNG_L00_G150", "T")) {
    return 0;
  }
  // -----------------------------------------------------------------------------------------
  return 1;
}
// #############################################################################################
// O_MOTORSCHUTZ_G150	        Not-Aus / Not-Halt	-
function Bestimme_O_MOTORSCHUTZ_G150(oData) {
  // O_MOTORSCHUTZ_G150
  var sDTKAttribute = "O_MOTORSCHUTZ_G150";
  // KAGs  STD, L57, L59, L60
  var aKAG = oData.oParsingData.MLFB.KAG || [];

  var sKAG = getKAGforAttribute(sDTKAttribute, aKAG);
  var bCheck = false;
  if (sKAG != "NON") {
    bCheck = Check_O_MOTORSCHUTZ_G150(oData, sDTKAttribute, sKAG);
  }
  if (bCheck) {
    ECL_ActivateValue(sDTKAttribute, sKAG);
    ECL_SelectValue(sDTKAttribute, sKAG);
  } else {
    ECL_ActivateValue(sDTKAttribute, "STD");
    ECL_SelectValue(sDTKAttribute, "STD");
  }
}
function Check_O_MOTORSCHUTZ_G150(oData, sDTKAttribute, sKAG) {
  if (oData.IsStartConfig == "0") return 1;
  // -----------------------------------------------------------------------------------------
  // A VT_G150_M00074	gueltige Optionen L13,26,57,59,60+Strom
  //		HMK_FALLNUMMER_G150	MLFB11_G150	O_MOTORSCHUTZ_G150	O_SCHUETZ_L13_G150	O_SCHALTER_L26_G150
  var HMK_FALLNUMMER_G150 = ECL_GetValue("HMK_FALLNUMMER_G150");
  var MLFB11_G150 = oData.oParsingData.MLFB.POS11_13;
  var IN_AUSFUEHRUNG_G150 = ECL_GetValue("IN_AUSFUEHRUNG_G150");

  var O_SCHUETZ_L13_G150 = "STD";
  if (ECL_ValueSelected("CB_O_SCHUETZ_L13_G150", "T")) {
    O_SCHUETZ_L13_G150 = "L13";
  }
  var O_SCHALTER_L26_G150 = "STD";
  if (ECL_ValueSelected("CB_O_SCHALTER_L26_G150", "T")) {
    O_SCHALTER_L26_G150 = "L26";
  }
  var sTable = "VT_G150_M00074" + sDB_Suffix;
  var sSQL =
    "SELECT " +
    sDTKAttribute +
    " FROM " +
    sTable +
    " WHERE " +
    "HMK_FALLNUMMER_G150 = '" +
    HMK_FALLNUMMER_G150 +
    "' AND " +
    "MLFB11_G150 = '" +
    MLFB11_G150 +
    "' AND " +
    "O_SCHUETZ_L13_G150 = '" +
    O_SCHUETZ_L13_G150 +
    "' AND " +
    "O_SCHALTER_L26_G150 = '" +
    O_SCHALTER_L26_G150 +
    "' AND " +
    sDTKAttribute +
    " = '" +
    sKAG +
    "';";

  var aResult = GetDBDataSetEXT(sSQL);
  if (aResult.length < 1) {
    return 0;
  }
  // --------------------------------------------------------------------------------------------
  // B VT_G150_M00078	Gueltige Optionen Ausfuehrung III
  //		IN_AUSFUEHRUNG_G150	O_MOTORSCHUTZ_G150	O_NOT_AUS_TASTER_G150
  var sTable = "VT_G150_M00078" + sDB_Suffix;
  var sSQL =
    "SELECT " +
    sDTKAttribute +
    " FROM " +
    sTable +
    " WHERE " +
    "IN_AUSFUEHRUNG_G150 = '" +
    IN_AUSFUEHRUNG_G150 +
    "' AND " +
    sDTKAttribute +
    " = '" +
    sKAG +
    "';";

  var aResult = GetDBDataSetEXT(sSQL);
  if (aResult.length < 1) {
    return 0;
  }
  // -----------------------------------------------------------------------------------------
  return 1;
}
// #############################################################################################
// O_NOT_AUS_TASTER_G150   	NOT-AUS-Taster, eingebaut in der Schranktür	x	CB_O_NOT_AUS_TASTER_G150
function Bestimme_L45_G150(oData) {
  // O_NOT_AUS_TASTER_G150
  var sDTKAttribute = "O_NOT_AUS_TASTER_G150";
  var sCB_Attribute = "CB_" + sDTKAttribute;

  var sKAG = "L45";

  var bCheck = false;
  var aKAG = oData.oParsingData.MLFB.KAG || [];

  if (aKAG.indexOf(sKAG) >= 0) {
    bCheck = Check_L45_G150(oData, sDTKAttribute, sKAG);
  }
  if (bCheck) {
    ECL_EnableAttribute(sCB_Attribute);
    ECL_SelectValue(sCB_Attribute, "T");
  } else {
    ECL_DeselectAttribute(sCB_Attribute);
  }
}
function Check_L45_G150(oData, sDTKAttribute, sKAG) {
  if (oData.IsStartConfig == "0") return 1;
  // -----------------------------------------------------------------------------------------
  /*
    VT_G150_M00078	Gueltige Optionen Ausfuehrung III
    IN_AUSFUEHRUNG_G150	O_MOTORSCHUTZ_G150	O_NOT_AUS_TASTER_G150
    */
  var IN_AUSFUEHRUNG_G150 = ECL_GetValue("IN_AUSFUEHRUNG_G150");
  var O_MOTORSCHUTZ_G150 = ECL_GetValue("O_MOTORSCHUTZ_G150");

  var sTable = "VT_G150_M00108" + sDB_Suffix;
  var sSQL =
    "SELECT " +
    sDTKAttribute +
    " FROM " +
    sTable +
    " WHERE " +
    "IN_AUSFUEHRUNG_G150 = '" +
    IN_AUSFUEHRUNG_G150 +
    "' AND " +
    "O_MOTORSCHUTZ_G150 = '" +
    O_MOTORSCHUTZ_G150 +
    "' AND " +
    sDTKAttribute +
    " = '" +
    sKAG +
    "';";

  var aResult = GetDBDataSetEXT(sSQL);
  if (aResult.length < 1) {
    return 0;
  }
  // -----------------------------------------------------------------------------------------
  return 1;
}
// #############################################################################################
// O_THERMISTOR_L83_G150   	Thermistor-Motorschutzgerät (Warnung)	x	CB_O_THERMISTOR_L83_G150
function Bestimme_L83_G150(oData) {
  // O_THERMISTOR_L83_G150
  var sDTKAttribute = "O_THERMISTOR_L83_G150";
  var sCB_Attribute = "CB_" + sDTKAttribute;

  var sKAG = "L83";

  var bCheck = false;
  var aKAG = oData.oParsingData.MLFB.KAG || [];

  if (aKAG.indexOf(sKAG) >= 0) {
    bCheck = Check_L83_G150(oData, sDTKAttribute, sKAG);
  }
  if (bCheck) {
    ECL_EnableAttribute(sCB_Attribute);
    ECL_SelectValue(sCB_Attribute, "T");
  } else {
    ECL_DeselectAttribute(sCB_Attribute);
  }
}
function Check_L83_G150(oData, sDTKAttribute, sKAG) {
  if (oData.IsStartConfig == "0") return 1;
  // -----------------------------------------------------------------------------------------
  /*
    VT_G150_M00079	Gueltige Optionen Ausfuehrung IV
    IN_AUSFUEHRUNG_G150		O_THERMISTOR_L83_G150	O_THERMISTOR_L84_G150	O_PT100_L86_G150	O_ISO_WACH_L87_G150
    */
  var IN_AUSFUEHRUNG_G150 = ECL_GetValue("IN_AUSFUEHRUNG_G150");

  var sTable = "VT_G150_M00079" + sDB_Suffix;
  var sSQL =
    "SELECT " +
    sDTKAttribute +
    " FROM " +
    sTable +
    " WHERE " +
    "IN_AUSFUEHRUNG_G150 = '" +
    IN_AUSFUEHRUNG_G150 +
    "' AND " +
    sDTKAttribute +
    " = '" +
    sKAG +
    "';";

  var aResult = GetDBDataSetEXT(sSQL);
  if (aResult.length < 1) {
    return 0;
  }
  // -----------------------------------------------------------------------------------------
  return 1;
}
// #############################################################################################
// O_THERMISTOR_L84_G150	    Thermistor-Motorschutzgerät (Abschaltung)	x	CB_O_THERMISTOR_L84_G150
function Bestimme_L84_G150(oData) {
  // O_THERMISTOR_L84_G150
  var sDTKAttribute = "O_THERMISTOR_L84_G150";
  var sCB_Attribute = "CB_" + sDTKAttribute;

  var sKAG = "L84";

  var bCheck = false;
  var aKAG = oData.oParsingData.MLFB.KAG || [];

  if (aKAG.indexOf(sKAG) >= 0) {
    bCheck = Check_L84_G150(oData, sDTKAttribute, sKAG);
  }
  if (bCheck) {
    ECL_EnableAttribute(sCB_Attribute);
    ECL_SelectValue(sCB_Attribute, "T");
  } else {
    ECL_DeselectAttribute(sCB_Attribute);
  }
}
function Check_L84_G150(oData, sDTKAttribute, sKAG) {
  if (oData.IsStartConfig == "0") return 1;
  // -----------------------------------------------------------------------------------------
  /*
    VT_G150_M00079	Gueltige Optionen Ausfuehrung IV
    IN_AUSFUEHRUNG_G150		O_THERMISTOR_L83_G150	O_THERMISTOR_L84_G150	O_PT100_L86_G150	O_ISO_WACH_L87_G150
    */
  var IN_AUSFUEHRUNG_G150 = ECL_GetValue("IN_AUSFUEHRUNG_G150");

  var O_THERMISTOR_L83_G150 = "NON";
  if (ECL_ValueSelected("CB_O_THERMISTOR_L83_G150", "T")) {
    O_THERMISTOR_L83_G150 = "L83";
  }

  var sTable = "VT_G150_M00079" + sDB_Suffix;
  var sSQL =
    "SELECT " +
    sDTKAttribute +
    " FROM " +
    sTable +
    " WHERE " +
    "IN_AUSFUEHRUNG_G150 = '" +
    IN_AUSFUEHRUNG_G150 +
    "' AND " +
    "O_THERMISTOR_L83_G150 = '" +
    O_THERMISTOR_L83_G150 +
    "' AND " +
    sDTKAttribute +
    " = '" +
    sKAG +
    "';";

  var aResult = GetDBDataSetEXT(sSQL);
  if (aResult.length < 1) {
    return 0;
  }
  // -----------------------------------------------------------------------------------------
  return 1;
}
// #############################################################################################
// O_TM150_G150	            1x TM150 Temperatursensorauswerteeinheit	x	CB_O_TM150_G150
function Bestimme_G51_G150(oData) {
  // O_TM150_G150
  var sDTKAttribute = "O_TM150_G150";
  var sCB_Attribute = "CB_" + sDTKAttribute;

  var sKAG = "G51";

  var bCheck = false;
  var aKAG = oData.oParsingData.MLFB.KAG || [];

  if (aKAG.indexOf(sKAG) >= 0) {
    bCheck = Check_G51_G150(oData, sDTKAttribute, sKAG);
  }
  if (bCheck) {
    ECL_EnableAttribute(sCB_Attribute);
    ECL_SelectValue(sCB_Attribute, "T");
  } else {
    ECL_DeselectAttribute(sCB_Attribute);
  }
}
function Check_G51_G150(oData, sDTKAttribute, sKAG) {
  if (oData.IsStartConfig == "0") return 1;
  // -----------------------------------------------------------------------------------------
  /*
    VT_G150_M00082	gueltige Optionen L86/G51
      O_PT100_L86_G150	O_TM150_G150
    */

  // -----------------------------------------------------------------------------------------
  return 1;
}
// #############################################################################################
// O_PT100_L86_G150	        PT100-Auswertegerät	x	CB_O_PT100_L86_G150
function Bestimme_L86_G150(oData) {
  // O_PT100_L86_G150
  var sDTKAttribute = "O_PT100_L86_G150";
  var sCB_Attribute = "CB_" + sDTKAttribute;

  var sKAG = "L86";

  var bCheck = false;
  var aKAG = oData.oParsingData.MLFB.KAG || [];

  if (aKAG.indexOf(sKAG) >= 0) {
    bCheck = Check_L86_G150(oData, sDTKAttribute, sKAG);
  }
  if (bCheck) {
    ECL_EnableAttribute(sCB_Attribute);
    ECL_SelectValue(sCB_Attribute, "T");
  } else {
    ECL_DeselectAttribute(sCB_Attribute);
  }
}
function Check_L86_G150(oData, sDTKAttribute, sKAG) {
  if (oData.IsStartConfig == "0") return 1;
  // -----------------------------------------------------------------------------------------
  /*
    VT_G150_M00079	Gueltige Optionen Ausfuehrung IV
      IN_AUSFUEHRUNG_G150		O_THERMISTOR_L83_G150	O_THERMISTOR_L84_G150	O_PT100_L86_G150	O_ISO_WACH_L87_G150
    VT_G150_M00082	gueltige Optionen L86/G51
        O_PT100_L86_G150	O_TM150_G150
    */
  var IN_AUSFUEHRUNG_G150 = ECL_GetValue("IN_AUSFUEHRUNG_G150");

  var O_THERMISTOR_L83_G150 = "NON";
  if (ECL_ValueSelected("CB_O_THERMISTOR_L83_G150", "T")) {
    O_THERMISTOR_L83_G150 = "L83";
  }
  var O_THERMISTOR_L84_G150 = "NON";
  if (ECL_ValueSelected("CB_O_THERMISTOR_L84_G150", "T")) {
    O_THERMISTOR_L84_G150 = "L84";
  }

  var sTable = "VT_G150_M00079" + sDB_Suffix;
  var sSQL =
    "SELECT " +
    sDTKAttribute +
    " FROM " +
    sTable +
    " WHERE " +
    "IN_AUSFUEHRUNG_G150 = '" +
    IN_AUSFUEHRUNG_G150 +
    "' AND " +
    "O_THERMISTOR_L83_G150 = '" +
    O_THERMISTOR_L83_G150 +
    "' AND " +
    "O_THERMISTOR_L84_G150 = '" +
    O_THERMISTOR_L84_G150 +
    "' AND " +
    sDTKAttribute +
    " = '" +
    sKAG +
    "';";

  var aResult = GetDBDataSetEXT(sSQL);
  if (aResult.length < 1) {
    return 0;
  }
  // -----------------------------------------------------------------------------------------
  var O_TM150_G150 = "NON";
  if (ECL_ValueSelected("CB_O_TM150_G150", "T")) {
    var O_TM150_G150 = "G51";
  }

  var sTable = "VT_G150_M00082" + sDB_Suffix;
  var sSQL =
    "SELECT " + sDTKAttribute + " FROM " + sTable + " WHERE " + "O_TM150_G150 = '" + O_TM150_G150 + "' AND " + sDTKAttribute + " = '" + sKAG + "';";

  var aResult = GetDBDataSetEXT(sSQL);
  if (aResult.length < 1) {
    return 0;
  }
  // -----------------------------------------------------------------------------------------
  return 1;
}
// #############################################################################################
// O_ISO_WACH_L87_G150	        Isolationsüberwachung	x	CB_O_ISO_WACH_L87_G150
function Bestimme_L87_G150(oData) {
  // O_ISO_WACH_L87_G150
  var sDTKAttribute = "O_ISO_WACH_L87_G150";
  var sCB_Attribute = "CB_" + sDTKAttribute;

  var sKAG = "L87";

  var bCheck = false;
  var aKAG = oData.oParsingData.MLFB.KAG || [];

  if (aKAG.indexOf(sKAG) >= 0) {
    bCheck = Check_L87_G150(oData, sDTKAttribute, sKAG);
  }
  if (bCheck) {
    ECL_EnableAttribute(sCB_Attribute);
    ECL_SelectValue(sCB_Attribute, "T");
  } else {
    ECL_DeselectAttribute(sCB_Attribute);
  }
}
function Check_L87_G150(oData, sDTKAttribute, sKAG) {
  if (oData.IsStartConfig == "0") return 1;
  // -----------------------------------------------------------------------------------------
  /*
    VT_G150_M00018	gueltige Optionen Umgebung
    O_UMGEBUNG_L00_G150	O_ISO_WACH_L87_G150
  VT_G150_M00079	Gueltige Optionen Ausfuehrung IV
    IN_AUSFUEHRUNG_G150		O_THERMISTOR_L83_G150	O_THERMISTOR_L84_G150	O_PT100_L86_G150	O_ISO_WACH_L87_G150
    */
  var IN_AUSFUEHRUNG_G150 = ECL_GetValue("IN_AUSFUEHRUNG_G150");

  var O_THERMISTOR_L83_G150 = "NON";
  if (ECL_ValueSelected("CB_O_THERMISTOR_L83_G150", "T")) {
    O_THERMISTOR_L83_G150 = "L83";
  }
  var O_THERMISTOR_L84_G150 = "NON";
  if (ECL_ValueSelected("CB_O_THERMISTOR_L84_G150", "T")) {
    O_THERMISTOR_L84_G150 = "L84";
  }

  var sTable = "VT_G150_M00079" + sDB_Suffix;
  var sSQL =
    "SELECT " +
    sDTKAttribute +
    " FROM " +
    sTable +
    " WHERE " +
    "IN_AUSFUEHRUNG_G150 = '" +
    IN_AUSFUEHRUNG_G150 +
    "' AND " +
    "O_THERMISTOR_L83_G150 = '" +
    O_THERMISTOR_L83_G150 +
    "' AND " +
    "O_THERMISTOR_L84_G150 = '" +
    O_THERMISTOR_L84_G150 +
    "' AND " +
    sDTKAttribute +
    " = '" +
    sKAG +
    "';";

  var aResult = GetDBDataSetEXT(sSQL);
  if (aResult.length < 1) {
    return 0;
  }
  // -----------------------------------------------------------------------------------------
  var O_UMGEBUNG_L00_G150 = "STD";
  if (ECL_ValueSelected("CB_O_UMGEBUNG_L00_G150", "T")) {
    O_UMGEBUNG_L00_G150 = "L00";
  }

  var sTable = "VT_G150_M00018" + sDB_Suffix;
  var sSQL =
    "SELECT " +
    sDTKAttribute +
    " FROM " +
    sTable +
    " WHERE " +
    "O_UMGEBUNG_L00_G150 = '" +
    O_UMGEBUNG_L00_G150 +
    "' AND " +
    sDTKAttribute +
    " = '" +
    sKAG +
    "';";

  var aResult = GetDBDataSetEXT(sSQL);
  if (aResult.length < 1) {
    return 0;
  }
  // -----------------------------------------------------------------------------------------
  return 1;
}
// #############################################################################################
// O_FUSSRAUM_G150			Sockel / Kabelrangierraum		M06, M07, STD
function Bestimme_O_FUSSRAUM_G150(oData) {
  // O_FUSSRAUM_G150
  var sDTKAttribute = "O_FUSSRAUM_G150";

  // KAGs  STD, M06, M07
  var aKAG = oData.oParsingData.MLFB.KAG || [];

  var sKAG = getKAGforAttribute(sDTKAttribute, aKAG);
  var bCheck = false;
  if (sKAG != "NON") {
    bCheck = Check_O_FUSSRAUM_G150(oData, sDTKAttribute, sKAG);
  }
  if (bCheck) {
    ECL_ActivateValue(sDTKAttribute, sKAG);
    ECL_SelectValue(sDTKAttribute, sKAG);
  } else {
    ECL_ActivateValue(sDTKAttribute, "STD");
    ECL_SelectValue(sDTKAttribute, "STD");
  }
}
function Check_O_FUSSRAUM_G150(oData, sDTKAttribute, sKAG) {
  if (oData.IsStartConfig == "0") return 1;
  // -----------------------------------------------------------------------------------------
  /*
        keine
    */

  // -----------------------------------------------------------------------------------------
  return 1;
}

// #############################################################################################
// O_NETZANSCH_M13_G150	    Netzanschluss von oben	x	CB_O_NETZANSCH_M13_G150
function Bestimme_M13_G150(oData) {
  // O_NETZANSCH_M13_G150
  var sDTKAttribute = "O_NETZANSCH_M13_G150";
  var sCB_Attribute = "CB_" + sDTKAttribute;

  var sKAG = "M13";

  var bCheck = false;
  var aKAG = oData.oParsingData.MLFB.KAG || [];

  if (aKAG.indexOf(sKAG) >= 0) {
    bCheck = Check_M13_G150(oData, sDTKAttribute, sKAG);
  }
  if (bCheck) {
    ECL_EnableAttribute(sCB_Attribute);
    ECL_SelectValue(sCB_Attribute, "T");
  } else {
    ECL_DeselectAttribute(sCB_Attribute);
  }
}
function Check_M13_G150(oData, sDTKAttribute, sKAG) {
  if (oData.IsStartConfig == "0") return 1;
  // -----------------------------------------------------------------------------------------
  /*
    // A VT_G150_M00115	Einschraenkungen_MLFB_M13
  //		HMK_FALLNUMMER_G150		MLFB11_G150		O_NETZANSCH_M13_G150
    // B VT_G150_M00077	Gueltige Optionen Ausfuehrung II
  //		IN_AUSFUEHRUNG_G150		O_OUTPUT_G150	O_NETZANSCH_M13_G150	O_MOTORANSCHL_M78_G150
    // C VT_G150_M00024	gueltige Optionen Anschluesse/Schutzart
  // 		O_NETZANSCH_M13_G150	O_MOTORANSCHL_M78_G150	O_SCHUTZART_G150
    */
  var HMK_FALLNUMMER_G150 = ECL_GetValue("HMK_FALLNUMMER_G150");
  var MLFB11_G150 = oData.oParsingData.MLFB.POS11_13;
  // A VT_G150_M00115	Einschraenkungen_MLFB_M13
  //		HMK_FALLNUMMER_G150		MLFB11_G150		O_NETZANSCH_M13_G150
  var sTable = "VT_G150_M00115" + sDB_Suffix;
  var sSQL =
    "SELECT " +
    sDTKAttribute +
    " FROM " +
    sTable +
    " WHERE " +
    "HMK_FALLNUMMER_G150 = '" +
    HMK_FALLNUMMER_G150 +
    "' AND " +
    "MLFB11_G150 = '" +
    MLFB11_G150 +
    "' AND " +
    sDTKAttribute +
    " = '" +
    sKAG +
    "';";

  var aResult = GetDBDataSetEXT(sSQL);
  if (aResult.length < 1) {
    return 0;
  }
  // --------------------------------------------------------------------------------------------
  // B VT_G150_M00077	Gueltige Optionen Ausfuehrung II
  //		IN_AUSFUEHRUNG_G150		O_OUTPUT_G150	O_NETZANSCH_M13_G150	O_MOTORANSCHL_M78_G150
  var IN_AUSFUEHRUNG_G150 = ECL_GetValue("IN_AUSFUEHRUNG_G150");
  var O_OUTPUT_G150 = ECL_GetValue("O_OUTPUT_G150");

  var sTable = "VT_G150_M00077" + sDB_Suffix;
  var sSQL =
    "SELECT " +
    sDTKAttribute +
    " FROM " +
    sTable +
    " WHERE " +
    "IN_AUSFUEHRUNG_G150 = '" +
    IN_AUSFUEHRUNG_G150 +
    "' AND " +
    "O_OUTPUT_G150 = '" +
    O_OUTPUT_G150 +
    "' AND " +
    sDTKAttribute +
    " = '" +
    sKAG +
    "';";

  var aResult = GetDBDataSetEXT(sSQL);
  if (aResult.length < 1) {
    return 0;
  }
  // --------------------------------------------------------------------------------------------
  // C VT_G150_M00024	gueltige Optionen Anschluesse/Schutzart
  // 		O_NETZANSCH_M13_G150	O_MOTORANSCHL_M78_G150	O_SCHUTZART_G150
  var O_SCHUTZART_G150 = ECL_GetValue("O_SCHUTZART_G150");

  var sTable = "VT_G150_M00024" + sDB_Suffix;
  var sSQL =
    "SELECT " +
    sDTKAttribute +
    " FROM " +
    sTable +
    " WHERE " +
    "O_SCHUTZART_G150 = '" +
    O_SCHUTZART_G150 +
    "' AND " +
    sDTKAttribute +
    " = '" +
    sKAG +
    "';";

  var aResult = GetDBDataSetEXT(sSQL);
  if (aResult.length < 1) {
    return 0;
  }
  // -----------------------------------------------------------------------------------------
  return 1;
}

// #############################################################################################
// O_KOMFORTGRIFF_M61_G150	(M61) Komfortgriff mit Verschlusseinsatz 3 mm Doppelbart  CB_O_KOMFORTGRIFF_M61_G150
function Bestimme_M61_G150(oData) {
  // O_KOMFORTGRIFF_M61_G150
  var sDTKAttribute = "O_KOMFORTGRIFF_M61_G150";
  var sCB_Attribute = "CB_" + sDTKAttribute;

  var sKAG = "M61";

  var bCheck = false;
  var aKAG = oData.oParsingData.MLFB.KAG || [];

  if (aKAG.indexOf(sKAG) >= 0) {
    bCheck = Check_M61_G150(oData, sDTKAttribute, sKAG);
  }
  if (bCheck) {
    ECL_EnableAttribute(sCB_Attribute);
    ECL_SelectValue(sCB_Attribute, "T");
  } else {
    ECL_DeselectAttribute(sCB_Attribute);
  }
}
function Check_M61_G150(oData, sDTKAttribute, sKAG) {
  if (oData.IsStartConfig == "0") return 1;
  // -----------------------------------------------------------------------------------------
  // VT 155 (only one Option M61, M62, M63)
  return 1;
}

// #############################################################################################
// O_KOMFORTGRIFF_M62_G150	(M62) Komfortgriff mit Verschlusseinsatz Druckknopf  CB_O_KOMFORTGRIFF_M62_G150
function Bestimme_M62_G150(oData) {
  // O_KOMFORTGRIFF_M62_G150
  var sDTKAttribute = "O_KOMFORTGRIFF_M62_G150";
  var sCB_Attribute = "CB_" + sDTKAttribute;

  var sKAG = "M62";

  var bCheck = false;
  var aKAG = oData.oParsingData.MLFB.KAG || [];

  if (aKAG.indexOf(sKAG) >= 0) {
    bCheck = Check_M62_G150(oData, sDTKAttribute, sKAG);
  }
  if (bCheck) {
    ECL_EnableAttribute(sCB_Attribute);
    ECL_SelectValue(sCB_Attribute, "T");
  } else {
    ECL_DeselectAttribute(sCB_Attribute);
  }
}
function Check_M62_G150(oData, sDTKAttribute, sKAG) {
  if (oData.IsStartConfig == "0") return 1;
  // -----------------------------------------------------------------------------------------
  // VT 155 (only one Option M61, M62, M63)
  if (ECL_ValueSelected("CB_O_KOMFORTGRIFF_M61_G150", "T")) {
    return 0;
  }
  return 1;
}

// #############################################################################################
// O_KOMFORTGRIFF_M63_G150	(M63) Komfortgriff für ein Vorhängeschloss mit Druckknopf als Verschlusseinsatz  CB_O_KOMFORTGRIFF_M63_G150
function Bestimme_M63_G150(oData) {
  // O_KOMFORTGRIFF_M63_G150
  var sDTKAttribute = "O_KOMFORTGRIFF_M63_G150";
  var sCB_Attribute = "CB_" + sDTKAttribute;

  var sKAG = "M63";

  var bCheck = false;
  var aKAG = oData.oParsingData.MLFB.KAG || [];

  if (aKAG.indexOf(sKAG) >= 0) {
    bCheck = Check_M63_G150(oData, sDTKAttribute, sKAG);
  }
  if (bCheck) {
    ECL_EnableAttribute(sCB_Attribute);
    ECL_SelectValue(sCB_Attribute, "T");
  } else {
    ECL_DeselectAttribute(sCB_Attribute);
  }
}
function Check_M63_G150(oData, sDTKAttribute, sKAG) {
  if (oData.IsStartConfig == "0") return 1;
  // -----------------------------------------------------------------------------------------
  // VT 155 (only one Option M61, M62, M63)
  if (ECL_ValueSelected("CB_O_KOMFORTGRIFF_M61_G150", "T")) {
    return 0;
  }
  if (ECL_ValueSelected("CB_O_KOMFORTGRIFF_M62_G150", "T")) {
    return 0;
  }
  return 1;
}


// #############################################################################################
// O_MOTORANSCHL_M78_G150	    Motoranschluss von oben	x	CB_O_MOTORANSCHL_M78_G150
function Bestimme_M78_G150(oData) {
  // O_MOTORANSCHL_M78_G150
  var sDTKAttribute = "O_MOTORANSCHL_M78_G150";
  var sCB_Attribute = "CB_" + sDTKAttribute;

  var sKAG = "M78";

  var bCheck = false;
  var aKAG = oData.oParsingData.MLFB.KAG || [];

  if (aKAG.indexOf(sKAG) >= 0) {
    bCheck = Check_M78_G150(oData, sDTKAttribute, sKAG);
  }
  if (bCheck) {
    ECL_EnableAttribute(sCB_Attribute);
    ECL_SelectValue(sCB_Attribute, "T");
  } else {
    ECL_DeselectAttribute(sCB_Attribute);
  }
}
function Check_M78_G150(oData, sDTKAttribute, sKAG) {
  if (oData.IsStartConfig == "0") return 1;
  // -----------------------------------------------------------------------------------------
  /*
    D 	VT_G150_M00024	gueltige Optionen Anschluesse/Schutzart
      O_NETZANSCH_M13_G150	O_MOTORANSCHL_M78_G150	O_SCHUTZART_G150
  C	VT_G150_M00027	gueltige Optionen Anschluss/Ausgang
      O_MOTORANSCHL_M78_G150	O_OUTPUT_G150
  B	VT_G150_M00077	Gueltige Optionen Ausfuehrung II
      IN_AUSFUEHRUNG_G150		O_OUTPUT_G150	O_NETZANSCH_M13_G150	O_MOTORANSCHL_M78_G150
  A	VT_G150_M00116	Einschraenkungen_MLFB_M78
      HMK_FALLNUMMER_G150		MLFB11_G150		O_MOTORANSCHL_M78_G150
    n.n. VT_G150_M00123	Verriegelung Optionen - Einbaugeraet II
  */
  // --------------------------------------------------------------------------------------------
  var HMK_FALLNUMMER_G150 = ECL_GetValue("HMK_FALLNUMMER_G150");
  var MLFB11_G150 = oData.oParsingData.MLFB.POS11_13;
  // A VT_G150_M00116	Einschraenkungen_MLFB_M78
  //		HMK_FALLNUMMER_G150		MLFB11_G150		O_MOTORANSCHL_M78_G150
  var sTable = "VT_G150_M00116" + sDB_Suffix;
  var sSQL =
    "SELECT " +
    sDTKAttribute +
    " FROM " +
    sTable +
    " WHERE " +
    "HMK_FALLNUMMER_G150 = '" +
    HMK_FALLNUMMER_G150 +
    "' AND " +
    "MLFB11_G150 = '" +
    MLFB11_G150 +
    "' AND " +
    sDTKAttribute +
    " = '" +
    sKAG +
    "';";

  var aResult = GetDBDataSetEXT(sSQL);
  if (aResult.length < 1) {
    return 0;
  }
  // --------------------------------------------------------------------------------------------
  // B VT_G150_M00077	Gueltige Optionen Ausfuehrung II
  //		IN_AUSFUEHRUNG_G150		O_OUTPUT_G150	O_NETZANSCH_M13_G150	O_MOTORANSCHL_M78_G150
  var IN_AUSFUEHRUNG_G150 = ECL_GetValue("IN_AUSFUEHRUNG_G150");
  var O_OUTPUT_G150 = ECL_GetValue("O_OUTPUT_G150");

  var O_NETZANSCH_M13_G150 = "STD";
  if (ECL_ValueSelected("CB_O_NETZANSCH_M13_G150", "T")) {
    var O_NETZANSCH_M13_G150 = "M13";
  }
  var sTable = "VT_G150_M00077" + sDB_Suffix;
  var sSQL =
    "SELECT " +
    sDTKAttribute +
    " FROM " +
    sTable +
    " WHERE " +
    "IN_AUSFUEHRUNG_G150 = '" +
    IN_AUSFUEHRUNG_G150 +
    "' AND " +
    "O_OUTPUT_G150 = '" +
    O_OUTPUT_G150 +
    "' AND " +
    "O_NETZANSCH_M13_G150 = '" +
    O_NETZANSCH_M13_G150 +
    "' AND " +
    sDTKAttribute +
    " = '" +
    sKAG +
    "';";

  var aResult = GetDBDataSetEXT(sSQL);
  if (aResult.length < 1) {
    return 0;
  }
  // --------------------------------------------------------------------------------------------
  // C	VT_G150_M00027	gueltige Optionen Anschluss/Ausgang
  //		O_MOTORANSCHL_M78_G150	O_OUTPUT_G150
  var sTable = "VT_G150_M00027" + sDB_Suffix;
  var sSQL =
    "SELECT " + sDTKAttribute + " FROM " + sTable + " WHERE " + "O_OUTPUT_G150 = '" + O_OUTPUT_G150 + "' AND " + sDTKAttribute + " = '" + sKAG + "';";

  var aResult = GetDBDataSetEXT(sSQL);
  if (aResult.length < 1) {
    return 0;
  }
  // --------------------------------------------------------------------------------------------
  // D VT_G150_M00024	gueltige Optionen Anschluesse/Schutzart
  // 		O_NETZANSCH_M13_G150	O_MOTORANSCHL_M78_G150	O_SCHUTZART_G150
  var O_SCHUTZART_G150 = ECL_GetValue("O_SCHUTZART_G150");

  var sTable = "VT_G150_M00024" + sDB_Suffix;
  var sSQL =
    "SELECT " +
    sDTKAttribute +
    " FROM " +
    sTable +
    " WHERE " +
    "O_NETZANSCH_M13_G150 = '" +
    O_NETZANSCH_M13_G150 +
    "' AND " +
    "O_SCHUTZART_G150 = '" +
    O_SCHUTZART_G150 +
    "' AND " +
    sDTKAttribute +
    " = '" +
    sKAG +
    "';";

  var aResult = GetDBDataSetEXT(sSQL);
  if (aResult.length < 1) {
    return 0;
  }
  // -----------------------------------------------------------------------------------------
  return 1;
}
// #############################################################################################
// O_KRAN_M90_G150	            Krantransporthilfe	x	CB_O_KRAN_M90_G150
function Bestimme_M90_G150(oData) {
  // O_KRAN_M90_G150
  var sDTKAttribute = "O_KRAN_M90_G150";
  var sCB_Attribute = "CB_" + sDTKAttribute;

  var sKAG = "M90";

  var bCheck = false;
  var aKAG = oData.oParsingData.MLFB.KAG || [];

  if (aKAG.indexOf(sKAG) >= 0) {
    bCheck = Check_M90_G150(oData, sDTKAttribute, sKAG);
  }
  if (bCheck) {
    ECL_EnableAttribute(sCB_Attribute);
    ECL_SelectValue(sCB_Attribute, "T");
  } else {
    ECL_DeselectAttribute(sCB_Attribute);
  }
}
function Check_M90_G150(oData, sDTKAttribute, sKAG) {
  if (oData.IsStartConfig == "0") return 1;
  // -----------------------------------------------------------------------------------------
  /*
    keine
    */

  // -----------------------------------------------------------------------------------------
  return 1;
}
// #############################################################################################
