//@legacy
//#mode(full-ecma)

//@import "CFG_G150_VT.js"

function SetOptions2_Init_G150(oData) {
  /*
    O_COMMUNICATION_G150	Communication Board     G20, G33, NON
    O_MODULE_G150	Module Cabinet-Mounted          K50, K51, NON
    O_BREMSEINHEIT_G150	Bremseinheit                L61, L62, NON
    O_GEWAEHR_G150	Gewährleistungsverlängerung     Q80, Q81, Q82, Q83, Q84, Q85, NON
    O_HILFSSPG_INTERN_G150	Hilfsspannungsversorgung    K74, EXT, NON
    O_BESCHRIFTUNGSSCHIL_G150	Beschriftungsschild zur Anlagenkennzeichnung    Y31, Y32, Y33, NON
    
    O_KLEMMLEISTE_G60_G150	Kundenklemmleiste TM31	G60	(G60) Kundenklemmleiste TM31	x	CB_O_KLEMMLEISTE_G60_G150
    O_KLEMMLEISTE_G61_G150	zusätzliche Kundenklemmleiste TM31	G61	(G61) zusätzliche Kundenklemmleiste TM31	x	CB_O_KLEMMLEISTE_G61_G150
    O_TERMINAL_BOARD_G150	Terminal Board TB30	G62	(G62) Terminal Board TB30	x	CB_O_TERMINAL_BOARD_G150
    O_SAFETY_LIZENZ_K01__G150	Safety-Lizenz für eine Achse	K01	(K01) Safety-Lizenz für eine Achse	x	CB_O_SAFETY_LIZENZ_K01__G150
    O_ZUS_SMC30_K52_G150	Zusätzliches Sensor Module Cabinet-Mounted SMC30	K52	(K52) Zusätzliches Sensor Module Cabinet-Mounted SMC30	x	CB_O_ZUS_SMC30_K52_G150
    O_KLMOD_K82_G150	Klemmenmodul zur Ansteuerung der Sicherheitsfunktionen "Safe Torque Off" und "Safe Stop 1"	K82	(K82) Klemmenmodul zur Ansteuerung der Sicherheitsfunktionen "Safe Torque Off" und "Safe Stop 1"	x	CB_O_KLMOD_K82_G150
    O_TM54F_K87_G150	Terminal Module TM54F	K87	(K87) Terminal Module TM54F	x	CB_O_TM54F_K87_G150
    O_SAFETY_SBA_K88_G150	Safe Brake Adapter SBA AC 230 V	K88	(K88) Safe Brake Adapter SBA AC 230 V	x	CB_O_SAFETY_SBA_K88_G150
    O_CU_K95_G150	Control Unit CU320-2 PN (PROFINET, EtherNet/IP)	K95	(K95) Control Unit CU320-2 PN (PROFINET, EtherNet/IP)	x	CB_O_CU_K95_G150
    O_HILFSBETR_L19_G150	Anschluss für ext. Hilfsbetriebe	L19	(L19) Anschluss für ext. Hilfsbetriebe	x	CB_O_HILFSBETR_L19_G150
    O_BELEUCHT_L50_G150	Schrankbeleuchtung mit Service-Steckdose	L50	(L50) Schrankbeleuchtung mit Service-Steckdose	x	CB_O_BELEUCHT_L50_G150
    O_STILLST_L55_G150	Schrank Stillstandsheizung	L55	(L55) Schrank Stillstandsheizung	x	CB_O_STILLST_L55_G150
    O_ADEREND_M91_G150	Vollständige Aderendmarkierung der Steuerleitungen	M91	(M91) Vollständige Aderendmarkierung der Steuerleitungen	x	CB_O_ADEREND_M91_G150
    O_SONDERLACK_Y09_G150	Schrank-Sonderlackierung    Y09	(Y09) Schrank-Sonderlackierung
    O_NAMUR_B00_G150	Namur Klemmenleiste	B00	(B00) Namur Klemmenleiste	x	CB_O_NAMUR_B00_G150
    O_USV_B02_G150	Sicher getrennte 24-V-Versorgung	B02	(B02) Sicher getrennte 24-V-Versorgung	x	CB_O_USV_B02_G150
    O_FREMD_B03_G150	Fremdabgang externe Hilfsbetriebe	B03	(B03) Fremdabgang externe Hilfsbetriebe	x	CB_O_FREMD_B03_G150
    O_SCHIFF_M66_G150	Schiffsausführung	M66	(M66) Schiffsausführung	x	CB_O_SCHIFF_M66_G150
    O_ZERTIFITKAT_G150  Einzelzertifikat	Individual certificate	NON [E21, E31, E51, E61, E71, NON]
    */

  if (oData && !isEmpty(oData)) {
    Bestimme_O_COMMUNICATION(oData); //
    Bestimme_O_MODULE(oData); //
    Bestimme_O_BREMSEINHEIT(oData); //
    Bestimme_O_GEWAEHR(oData); //
    Bestimme_O_HILFSSPG_INTERN(oData); //
    Bestimme_O_BESCHRIFTUNGSSCHILD(oData); //
    Bestimme_G60(oData); //
    Bestimme_G61(oData); //
    Bestimme_G62(oData); //
    Bestimme_K01(oData); //
    Bestimme_K52(oData); //
    Bestimme_K82(oData); //
    Bestimme_K87(oData); //
    Bestimme_K88(oData); //
    Bestimme_K95(oData); //
    Bestimme_L19(oData); //
    Bestimme_L50(oData); //
    Bestimme_L55(oData); //
    Bestimme_M91(oData); //
    Bestimme_Y09(oData); //
    Bestimme_B00(oData); //
    Bestimme_B02(oData); //
    Bestimme_B03(oData); //
    Bestimme_M66(oData); //
    Bestimme_O_ZERTIFITKAT(oData);
  } else {
    ExecSetStandardifValueEmpty("O_COMMUNICATION_G150", "NON");
    ExecSetStandardifValueEmpty("O_MODULE_G150", "NON");
    ExecSetStandardifValueEmpty("O_BREMSEINHEIT_G150", "NON");
    ExecSetStandardifValueEmpty("O_GEWAEHR_G150", "NON");
    ExecSetStandardifValueEmpty("O_HILFSSPG_INTERN_G150", "NON");
    ExecSetStandardifValueEmpty("O_BESCHRIFTUNGSSCHIL_G150", "NON");

    ECL_DeselectAttribute("CB_O_KLEMMLEISTE_G60_G150");
    ECL_DeselectAttribute("CB_O_KLEMMLEISTE_G61_G150");
    ECL_DeselectAttribute("CB_O_TERMINAL_BOARD_G150");
    ECL_DeselectAttribute("CB_O_SAFETY_LIZENZ_K01__G150");
    ECL_DeselectAttribute("CB_O_ZUS_SMC30_K52_G150");
    ECL_DeselectAttribute("CB_O_KLMOD_K82_G150");
    ECL_DeselectAttribute("CB_O_TM54F_K87_G150");
    ECL_DeselectAttribute("CB_O_SAFETY_SBA_K88_G150");
    ECL_DeselectAttribute("CB_O_CU_K95_G150");
    ECL_DeselectAttribute("CB_O_HILFSBETR_L19_G150");
    ECL_DeselectAttribute("CB_O_BELEUCHT_L50_G150");
    ECL_DeselectAttribute("CB_O_STILLST_L55_G150");
    ECL_DeselectAttribute("CB_O_ADEREND_M91_G150");
    ExecSetStandardifValueEmpty("O_SONDERLACK_Y09_G150", "NON");
    ECL_DeselectAttribute("CB_O_NAMUR_B00_G150");
    ECL_DeselectAttribute("CB_O_USV_B02_G150");
    ECL_DeselectAttribute("CB_O_FREMD_B03_G150");
    ECL_DeselectAttribute("CB_O_SCHIFF_M66_G150");
    ExecSetStandardifValueEmpty("O_ZERTIFITKAT_G150", "NON");
  }
}

// #############################################################################################
// O_COMMUNICATION_G150	Communication Board     G20, G33, NON
function Bestimme_O_COMMUNICATION(oData) {
  // O_COMMUNICATION_G150
  var sDTKAttribute = "O_COMMUNICATION_G150";

  // KAGs  G20, G33, NON
  var aKAG = oData.oParsingData.MLFB.KAG || [];

  var sKAG = getKAGforAttribute(sDTKAttribute, aKAG);
  var bCheck = false;
  if (sKAG != "NON") {
    bCheck = Check_O_COMMUNICATION(oData, sDTKAttribute, sKAG);
  }
  if (bCheck) {
    ECL_ActivateValue(sDTKAttribute, sKAG);
    ECL_SelectValue(sDTKAttribute, sKAG);
  } else {
    ECL_ActivateValue(sDTKAttribute, "NON");
    ECL_SelectValue(sDTKAttribute, "NON");
  }
}
function Check_O_COMMUNICATION(oData, sDTKAttribute, sKAG) {
  if (oData.IsStartConfig == "0") return 1;
  // -----------------------------------------------------------------------------------------
  /*
    VT_G150_M00080	Gueltige Optionen G20, G33, G62
    O_COMMUNICATION_G150	O_TERMINAL_BOARD_G150
    */

  // -----------------------------------------------------------------------------------------
  return 1;
}
// #############################################################################################
// O_MODULE_G150	Module Cabinet-Mounted          K50, K51, NON
function Bestimme_O_MODULE(oData) {
  // O_MODULE_G150
  var sDTKAttribute = "O_MODULE_G150";
  // KAGs  K50, K51, NON

  // Safety-context
  /* if single-connection (MLFB08 ==1) K50+K52 is mandatory for
        SOS	    6
        SS2	    5
        SBT	    12
    if parallel connection MLFB08==2 K50+K52 is mandatory for
        SS1-a/SS1-r 	14
        SOS             6
        SS2	            5
        SLS	            2
        SSM	            4
        SDI	            3
        SBT	            12
    */
  var MLFB08_G150 = oData.oParsingData.MLFB.POS8;
  var ECSI_CX_SafetyFunctions = ECL_GetValue("ECSI_CX_SafetyFunctions");
  var aSafetyFunctions = ECSI_CX_SafetyFunctions.split(";");
  var bK50Mandatory = false;

  if (aSafetyFunctions && aSafetyFunctions.length > 0 && MLFB08_G150 == "1") {
    for (var i = 0; i < aSafetyFunctions.length; i++) {
      if (aSafetyFunctions[i] == "5" || aSafetyFunctions[i] == "6" || aSafetyFunctions[i] == "12") {
        bK50Mandatory = true;
        break;
      }
    }
  } else if (aSafetyFunctions && aSafetyFunctions.length > 0 && MLFB08_G150 == "2") {
    for (var i = 0; i < aSafetyFunctions.length; i++) {
      if (
        aSafetyFunctions[i] == "2" ||
        aSafetyFunctions[i] == "3" ||
        aSafetyFunctions[i] == "4" ||
        aSafetyFunctions[i] == "5" ||
        aSafetyFunctions[i] == "6" ||
        aSafetyFunctions[i] == "12" ||
        aSafetyFunctions[i] == "14"
      ) {
        bK50Mandatory = true;
        break;
      }
    }
  }

  if (bK50Mandatory) {
    var sKAG = "K50";

    ECL_DeactivateAllAttributeValues(sDTKAttribute);
    ECL_ActivateValue(sDTKAttribute, sKAG);
    ECL_SelectValue(sDTKAttribute, sKAG);
  } else {
    var aKAG = oData.oParsingData.MLFB.KAG || [];

    var sKAG = getKAGforAttribute(sDTKAttribute, aKAG);
    var bCheck = false;
    if (sKAG != "NON") {
      bCheck = Check_O_MODULE(oData, sDTKAttribute, sKAG);
    }
    if (bCheck) {
      ECL_ActivateValue(sDTKAttribute, sKAG);
      ECL_SelectValue(sDTKAttribute, sKAG);
    } else {
      ECL_ActivateValue(sDTKAttribute, "NON");
      ECL_SelectValue(sDTKAttribute, "NON");
    }
  }
}
function Check_O_MODULE(oData, sDTKAttribute, sKAG) {
  if (oData.IsStartConfig == "0") return 1;
  // -----------------------------------------------------------------------------------------
  /*
    VT_G150_M00084	gueltige Optionen Ausfuehrung II
        IN_AUSFUEHRUNG_G150	O_MODULE_G150	O_KLMOD_K82_G150	O_CU_K95_G150
    VT_G150_M00126	Verriegelung Optionen Module-K52
        O_MODULE_G150	O_ZUS_SMC30_K52_G150
    */
  var IN_AUSFUEHRUNG_G150 = ECL_GetValue("IN_AUSFUEHRUNG_G150");
  // --------------------------------------------------------------------------------------------
  // VT_G150_M00084	gueltige Optionen Ausfuehrung II
  //  IN_AUSFUEHRUNG_G150	O_MODULE_G150	O_KLMOD_K82_G150	O_CU_K95_G150
  var sTable = "VT_G150_M00084" + sDB_Suffix;
  var sSQL =
    "SELECT " +
    sDTKAttribute +
    " FROM " +
    sTable +
    " WHERE " +
    "IN_AUSFUEHRUNG_G150 = '" +
    IN_AUSFUEHRUNG_G150 +
    "' AND " +
    sDTKAttribute +
    " = '" +
    sKAG +
    "';";

  var aResult = GetDBDataSetEXT(sSQL);
  if (aResult.length < 1) {
    return 0;
  }
  // -----------------------------------------------------------------------------------------
  return 1;
}
// #############################################################################################
// O_BREMSEINHEIT_G150	Bremseinheit                L61, L62, NON
function Bestimme_O_BREMSEINHEIT(oData) {
  // O_BREMSEINHEIT_G150
  var sDTKAttribute = "O_BREMSEINHEIT_G150";

  // KAGs  L61, L62, NON
  var aKAG = oData.oParsingData.MLFB.KAG || [];

  var sKAG = getKAGforAttribute(sDTKAttribute, aKAG);
  var bCheck = false;
  if (sKAG != "NON") {
    bCheck = Check_O_BREMSEINHEIT(oData, sDTKAttribute, sKAG);
  }
  if (bCheck) {
    ECL_ActivateValue(sDTKAttribute, sKAG);
    ECL_SelectValue(sDTKAttribute, sKAG);
  } else {
    ECL_ActivateValue(sDTKAttribute, "NON");
    ECL_SelectValue(sDTKAttribute, "NON");
  }
}
function Check_O_BREMSEINHEIT(oData, sDTKAttribute, sKAG) {
  if (oData.IsStartConfig == "0") return 1;
  // -----------------------------------------------------------------------------------------
  /*
    VT_G150_M00064	gueltige Optionen Bremseinheit
      HMK_FALLNUMMER_G150		MLFB11_G150		O_BREMSEINHEIT_G150
  VT_G150_M00086	gueltige Optionen Ausfuehrung IV
    IN_AUSFUEHRUNG_G150		O_BREMSEINHEIT_G150		O_NAMUR_B00_G150	O_USV_B02_G150	O_FREMD_B03_G150
    */
  var HMK_FALLNUMMER_G150 = ECL_GetValue("HMK_FALLNUMMER_G150");
  var MLFB11_G150 = oData.oParsingData.MLFB.POS11_13;
  var IN_AUSFUEHRUNG_G150 = ECL_GetValue("IN_AUSFUEHRUNG_G150");
  // --------------------------------------------------------------------------------------------
  // VT_G150_M00064	gueltige Optionen Bremseinheit
  //    HMK_FALLNUMMER_G150		MLFB11_G150		O_BREMSEINHEIT_G150
  var sTable = "VT_G150_M00064" + sDB_Suffix;
  var sSQL =
    "SELECT " +
    sDTKAttribute +
    " FROM " +
    sTable +
    " WHERE " +
    "HMK_FALLNUMMER_G150 = '" +
    HMK_FALLNUMMER_G150 +
    "' AND " +
    "MLFB11_G150 = '" +
    MLFB11_G150 +
    "' AND " +
    sDTKAttribute +
    " = '" +
    sKAG +
    "';";

  var aResult = GetDBDataSetEXT(sSQL);
  if (aResult.length < 1) {
    return 0;
  }
  // --------------------------------------------------------------------------------------------
  // VT_G150_M00086	gueltige Optionen Ausfuehrung IV
  //	IN_AUSFUEHRUNG_G150		O_BREMSEINHEIT_G150		O_NAMUR_B00_G150	O_USV_B02_G150	O_FREMD_B03_G150
  var sTable = "VT_G150_M00086" + sDB_Suffix;
  var sSQL =
    "SELECT " +
    sDTKAttribute +
    " FROM " +
    sTable +
    " WHERE " +
    "IN_AUSFUEHRUNG_G150 = '" +
    IN_AUSFUEHRUNG_G150 +
    "' AND " +
    sDTKAttribute +
    " = '" +
    sKAG +
    "';";

  var aResult = GetDBDataSetEXT(sSQL);
  if (aResult.length < 1) {
    return 0;
  }
  // -----------------------------------------------------------------------------------------
  return 1;
}
// #############################################################################################
// O_GEWAEHR_G150	Gewährleistungsverlängerung     Q80, Q81, Q82, Q83, Q84, Q85, NON
function Bestimme_O_GEWAEHR(oData) {
  // O_GEWAEHR_G150
  var sDTKAttribute = "O_GEWAEHR_G150";

  // KAGs  Q80, Q81, Q82, Q83, Q84, Q85, NON
  var aKAG = oData.oParsingData.MLFB.KAG || [];

  var sKAG = getKAGforAttribute(sDTKAttribute, aKAG);
  var bCheck = false;
  if (sKAG != "NON") {
    bCheck = Check_O_GEWAEHR(oData, sDTKAttribute, sKAG);
  }
  if (bCheck) {
    ECL_ActivateValue(sDTKAttribute, sKAG);
    ECL_SelectValue(sDTKAttribute, sKAG);
  } else {
    ECL_ActivateValue(sDTKAttribute, "NON");
    ECL_SelectValue(sDTKAttribute, "NON");
  }
}
function Check_O_GEWAEHR(oData, sDTKAttribute, sKAG) {
  if (oData.IsStartConfig == "0") return 1;
  // -----------------------------------------------------------------------------------------
  /*
        keine
    */
  // -----------------------------------------------------------------------------------------
  return 1;
}
// #############################################################################################
// O_HILFSSPG_INTERN_G150	Hilfsspannungsversorgung    K74, EXT, NON
function Bestimme_O_HILFSSPG_INTERN(oData) {
  // O_HILFSSPG_INTERN_G150
  var sDTKAttribute = "O_HILFSSPG_INTERN_G150";
  var H_TRIGGER_AC230V_G150 = ECL_GetValue("H_TRIGGER_AC230V_G150");

  // KAGs  K74, EXT, NON
  var aKAG = oData.oParsingData.MLFB.KAG || [];

  var sKAG = getKAGforAttribute(sDTKAttribute, aKAG);
  var bCheck = false;
  if (sKAG != "NON") {
    bCheck = Check_O_HILFSSPG_INTERN(oData, sDTKAttribute, sKAG);
  }
  if (bCheck) {
    ECL_ActivateValue(sDTKAttribute, sKAG);
    ECL_SelectValue(sDTKAttribute, sKAG);
  } else {
    if (
      oData.IsStartConfig == "1" &&
      oData.IsKeepConfig == "0" &&
      aKAG.indexOf("L50") < 0 &&
      aKAG.indexOf("L55") < 0 &&
      aKAG.indexOf("M66") < 0 &&
      H_TRIGGER_AC230V_G150 == "SPEC"
    ) {
      // K74 default
      /*$set_default ($self,O_HILFSSPG_INTERN_G150,'K74')
    if O_BELEUCHT_L50_G150 eq 'NON' and
      O_STILLST_L55_G150 eq 'NON' and
      O_SCHIFF_M66_G150 eq 'STD' and
      H_TRIGGER_AC230V_G150 eq 'SPEC' and
      (H_KONFIG_TYP_G150 = 'NEU' or
      (H_KONFIG_TYP_G150 = 'DI' and
      H_DI_FERTIG_G150 = 'T'))
      */
      ECL_ActivateValue(sDTKAttribute, "K74");
      ECL_SelectValue(sDTKAttribute, "K74");
    } else {
      // NON or EXT
      // if L50, L55 or M66: EXT
      if (H_TRIGGER_AC230V_G150 == "SPEC" || aKAG.indexOf("L50") > -1 || aKAG.indexOf("L55") > -1 || aKAG.indexOf("M66") > -1) {
        ECL_ActivateValue(sDTKAttribute, "EXT");
        ECL_SelectValue(sDTKAttribute, "EXT");
      } else {
        ECL_ActivateValue(sDTKAttribute, "NON");
        ECL_SelectValue(sDTKAttribute, "NON");
      }
    }
  }
}
function Check_O_HILFSSPG_INTERN(oData, sDTKAttribute, sKAG) {
  if (oData.IsStartConfig == "0") return 1;
  // -----------------------------------------------------------------------------------------
  /*
    VT_G150_M00140	Hilfsspannungsversorgung - M66
      O_HILFSSPG_INTERN_G150	O_SCHIFF_M66_G150
  VT_G150_M00141	ZO Header Note K74 L50 L55
    O_HILFSSPG_INTERN_G150	O_BELEUCHT_L50_G150	O_STILLST_L55_G150	HMK_NOTE_K74_L50_L55_G150
    */
  // -----------------------------------------------------------------------------------------
  return 1;
}
// #############################################################################################
// O_BESCHRIFTUNGSSCHIL_G150	Beschriftungsschild zur Anlagenkennzeichnung    Y31, Y32, Y33, NON
function Bestimme_O_BESCHRIFTUNGSSCHILD(oData) {
  // O_BESCHRIFTUNGSSCHIL_G150
  var sDTKAttribute = "O_BESCHRIFTUNGSSCHIL_G150";

  // KAGs  Y31, Y32, Y33, NON
  var aKAG = oData.oParsingData.MLFB.KAG || [];

  var sKAG = getKAGforAttribute(sDTKAttribute, aKAG);
  var bCheck = false;
  if (sKAG != "NON") {
    bCheck = Check_O_BESCHRIFTUNGSSCHILD(oData, sDTKAttribute, sKAG);
  }
  if (bCheck) {
    ECL_ActivateValue(sDTKAttribute, sKAG);
    ECL_SelectValue(sDTKAttribute, sKAG);
  } else {
    ECL_ActivateValue(sDTKAttribute, "NON");
    ECL_SelectValue(sDTKAttribute, "NON");
  }
}
function Check_O_BESCHRIFTUNGSSCHILD(oData, sDTKAttribute, sKAG) {
  if (oData.IsStartConfig == "0") return 1;
  // -----------------------------------------------------------------------------------------
  /*
        keine
    */
  // -----------------------------------------------------------------------------------------
  return 1;
}
// #############################################################################################
// O_KLEMMLEISTE_G60_G150	Kundenklemmleiste TM31	G60	(G60) Kundenklemmleiste TM31	x	CB_O_KLEMMLEISTE_G60_G150
function Bestimme_G60(oData) {
  // O_KLEMMLEISTE_G60_G150
  var sDTKAttribute = "O_KLEMMLEISTE_G60_G150";
  var sCB_Attribute = "CB_" + sDTKAttribute;

  var sKAG = "G60";

  var bCheck = false;
  var aKAG = oData.oParsingData.MLFB.KAG || [];

  if (aKAG.indexOf(sKAG) >= 0) {
    bCheck = Check_G60(oData, sDTKAttribute, sKAG);
  }
  if (bCheck) {
    ECL_EnableAttribute(sCB_Attribute);
    ECL_SelectValue(sCB_Attribute, "T");
  } else {
    ECL_DeselectAttribute(sCB_Attribute);
  }
}

function Check_G60(oData, sDTKAttribute, sKAG) {
  if (oData.IsStartConfig == "0") return 1;
  // -----------------------------------------------------------------------------------------
  /*
    VT_G150_M00058	gueltige Optionen Klemmleiste
    O_KLEMMLEISTE_G60_G150	O_KLEMMLEISTE_G61_G150
    */
  // -----------------------------------------------------------------------------------------
  return 1;
}
// #############################################################################################
// O_KLEMMLEISTE_G61_G150	zusätzliche Kundenklemmleiste TM31	G61	(G61) zusätzliche Kundenklemmleiste TM31	x	CB_O_KLEMMLEISTE_G61_G150
function Bestimme_G61(oData) {
  // O_KLEMMLEISTE_G61_G150
  var sDTKAttribute = "O_KLEMMLEISTE_G61_G150";
  var sCB_Attribute = "CB_" + sDTKAttribute;

  var sKAG = "G61";

  var bCheck = false;
  var aKAG = oData.oParsingData.MLFB.KAG || [];

  if (aKAG.indexOf(sKAG) >= 0) {
    bCheck = Check_G61(oData, sDTKAttribute, sKAG);
  }
  if (bCheck) {
    ECL_EnableAttribute(sCB_Attribute);
    ECL_SelectValue(sCB_Attribute, "T");
  } else {
    ECL_DeselectAttribute(sCB_Attribute);
  }
}

function Check_G61(oData, sDTKAttribute, sKAG) {
  if (oData.IsStartConfig == "0") return 1;
  // -----------------------------------------------------------------------------------------
  /*
    B	VT_G150_M00058	gueltige Optionen Klemmleiste
      O_KLEMMLEISTE_G60_G150	O_KLEMMLEISTE_G61_G150
  A	VT_G150_M00085	gueltige Optionen Ausfuehrung III
      IN_AUSFUEHRUNG_G150		O_KLEMMLEISTE_G61_G150	O_HILFSBETR_L19_G150	O_BELEUCHT_L50_G150
  C	VT_G150_M00136	Option G61<-->Option K87
  n.n.		O_KLEMMLEISTE_G61_G150	O_TM54F_K87_G150
    */
  // -----------------------------------------------------------------------------------------
  // A VT_G150_M00085	gueltige Optionen Ausfuehrung III
  //		IN_AUSFUEHRUNG_G150		O_KLEMMLEISTE_G61_G150	O_HILFSBETR_L19_G150	O_BELEUCHT_L50_G150
  var IN_AUSFUEHRUNG_G150 = ECL_GetValue("IN_AUSFUEHRUNG_G150");
  var MLFB11_G150 = oData.oParsingData.MLFB.POS11_13;

  var sTable = "VT_G150_M00085" + sDB_Suffix;
  var sSQL =
    "SELECT " +
    sDTKAttribute +
    " FROM " +
    sTable +
    " WHERE " +
    "IN_AUSFUEHRUNG_G150 = '" +
    IN_AUSFUEHRUNG_G150 +
    "' AND " +
    "MLFB11_G150 = '" +
    MLFB11_G150 +
    "' AND " +
    sDTKAttribute +
    " = '" +
    sKAG +
    "';";

  var aResult = GetDBDataSetEXT(sSQL);
  if (aResult.length < 1) {
    return 0;
  }
  // --------------------------------------------------------------------------------------------
  // B VT_G150_M00058	gueltige Optionen Klemmleiste
  //		O_KLEMMLEISTE_G60_G150	O_KLEMMLEISTE_G61_G150
  var O_KLEMMLEISTE_G60_G150 = "STD";
  if (ECL_ValueSelected("CB_O_KLEMMLEISTE_G60_G150", "T")) {
    O_KLEMMLEISTE_G60_G150 = "G60";
  }

  var sTable = "VT_G150_M00058" + sDB_Suffix;
  var sSQL =
    "SELECT " +
    sDTKAttribute +
    " FROM " +
    sTable +
    " WHERE " +
    "O_KLEMMLEISTE_G60_G150 = '" +
    O_KLEMMLEISTE_G60_G150 +
    "' AND " +
    sDTKAttribute +
    " = '" +
    sKAG +
    "';";

  var aResult = GetDBDataSetEXT(sSQL);
  if (aResult.length < 1) {
    return 0;
  }
  // --------------------------------------------------------------------------------------------
  // C VT_G150_M00136	Option G61<-->Option K87
  //		O_KLEMMLEISTE_G61_G150	O_TM54F_K87_G150

  // -----------------------------------------------------------------------------------------
  return 1;
}
// #############################################################################################
// O_TERMINAL_BOARD_G150	Terminal Board TB30	G62	(G62) Terminal Board TB30	x	CB_O_TERMINAL_BOARD_G150
function Bestimme_G62(oData) {
  // O_TERMINAL_BOARD_G150
  var sDTKAttribute = "O_TERMINAL_BOARD_G150";
  var sCB_Attribute = "CB_" + sDTKAttribute;

  var sKAG = "G62";

  var bCheck = false;
  var aKAG = oData.oParsingData.MLFB.KAG || [];

  if (aKAG.indexOf(sKAG) >= 0) {
    bCheck = Check_G62(oData, sDTKAttribute, sKAG);
  }
  if (bCheck) {
    ECL_EnableAttribute(sCB_Attribute);
    ECL_SelectValue(sCB_Attribute, "T");
  } else {
    ECL_DeselectAttribute(sCB_Attribute);
  }
}

function Check_G62(oData, sDTKAttribute, sKAG) {
  if (oData.IsStartConfig == "0") return 1;
  // -----------------------------------------------------------------------------------------
  /*
    VT_G150_M00080	Gueltige Optionen G20, G33, G62
    O_COMMUNICATION_G150	O_TERMINAL_BOARD_G150
  */
  var O_COMMUNICATION_G150 = ECL_GetValue("O_COMMUNICATION_G150");

  var sTable = "VT_G150_M00080" + sDB_Suffix;
  var sSQL =
    "SELECT " +
    sDTKAttribute +
    " FROM " +
    sTable +
    " WHERE " +
    "O_COMMUNICATION_G150 = '" +
    O_COMMUNICATION_G150 +
    "' AND " +
    sDTKAttribute +
    " = '" +
    sKAG +
    "';";

  var aResult = GetDBDataSetEXT(sSQL);
  if (aResult.length < 1) {
    return 0;
  }
  // -----------------------------------------------------------------------------------------
  return 1;
}
// #############################################################################################
// O_SAFETY_LIZENZ_K01__G150	Safety-Lizenz für eine Achse	K01	(K01) Safety-Lizenz für eine Achse	x	CB_O_SAFETY_LIZENZ_K01__G150
function Bestimme_K01(oData) {
  // O_SAFETY_LIZENZ_K01__G150
  var sDTKAttribute = "O_SAFETY_LIZENZ_K01__G150";
  var sCB_Attribute = "CB_" + sDTKAttribute;

  var sKAG = "K01";

  // K01 mandatory from context Safetyfunctions
  var ECSI_CX_SafetyFunctions = ECL_GetValue("ECSI_CX_SafetyFunctions");
  var aSafetyFunctions = ECSI_CX_SafetyFunctions.split(";");
  var bK01Mandatory = false;

  if (aSafetyFunctions && aSafetyFunctions.length > 0) {
    for (var i = 0; i < aSafetyFunctions.length; i++) {
      if (
        aSafetyFunctions[i] == "2" ||
        aSafetyFunctions[i] == "3" ||
        aSafetyFunctions[i] == "4" ||
        aSafetyFunctions[i] == "5" ||
        aSafetyFunctions[i] == "6" ||
        aSafetyFunctions[i] == "12" ||
        aSafetyFunctions[i] == "14"
      ) {
        bK01Mandatory = true;
        break;
      }
    }
  }

  if (bK01Mandatory) {
    ECL_SelectValue(sCB_Attribute, "T");
    ECL_DisableAttribute(sCB_Attribute);
  } else {
    var bCheck = false;
    var aKAG = oData.oParsingData.MLFB.KAG || [];

    if (aKAG.indexOf(sKAG) >= 0) {
      bCheck = Check_K01(oData, sDTKAttribute, sKAG);
    }
    if (bCheck) {
      ECL_EnableAttribute(sCB_Attribute);
      ECL_SelectValue(sCB_Attribute, "T");
    } else {
      ECL_DeselectAttribute(sCB_Attribute);
    }
  }
}
function Check_K01(oData, sDTKAttribute, sKAG) {
  if (oData.IsStartConfig == "0") return 1;
  // -----------------------------------------------------------------------------------------
  /*  A VT_G150_M00125	ZO Design - Safety
        IN_AUSFUEHRUNG_G150		O_SAFETY_LIZENZ_K01__G150
    B VT_G150_M00127	Verriegelung Optionen K52-K01
      O_ZUS_SMC30_K52_G150	O_SAFETY_LIZENZ_K01__G150
    C VT_G150_M00137	Option K01<--> Option K87
      O_SAFETY_LIZENZ_K01__G150	O_TM54F_K87_G150
  */

  /* A VT_G150_M00125	ZO Design - Safety
        IN_AUSFUEHRUNG_G150		O_SAFETY_LIZENZ_K01__G150
  */
  var IN_AUSFUEHRUNG_G150 = ECL_GetValue("IN_AUSFUEHRUNG_G150");

  var sTable = "VT_G150_M00125" + sDB_Suffix;
  var sSQL =
    "SELECT " +
    sDTKAttribute +
    " FROM " +
    sTable +
    " WHERE " +
    "IN_AUSFUEHRUNG_G150 = '" +
    IN_AUSFUEHRUNG_G150 +
    "' AND " +
    sDTKAttribute +
    " = '" +
    sKAG +
    "';";

  var aResult = GetDBDataSetEXT(sSQL);
  if (aResult.length < 1) {
    return 0;
  }
  // -----------------------------------------------------------------------------------------
  return 1;
}

// #############################################################################################
// O_ZUS_SMC30_K52_G150	Zusätzliches Sensor Module Cabinet-Mounted SMC30	K52	(K52) Zusätzliches Sensor Module Cabinet-Mounted SMC30	x	CB_O_ZUS_SMC30_K52_G150
function Bestimme_K52(oData) {
  // O_ZUS_SMC30_K52_G150
  var sDTKAttribute = "O_ZUS_SMC30_K52_G150";
  var sCB_Attribute = "CB_" + sDTKAttribute;

  var sKAG = "K52";

  // Safety-context
  /* if single-connection (MLFB08 ==1) K50+K52 is mandatory for
        SOS	    6
        SS2	    5
        SBT	    12
    if parallel connection MLFB08==2 K50+K52 is mandatory for
        SS1-a/SS1-r 	14
        SOS             6
        SS2	            5
        SLS	            2
        SSM	            4
        SDI	            3
        SBT	            12
    */
  var MLFB08_G150 = oData.oParsingData.MLFB.POS8;
  var ECSI_CX_SafetyFunctions = ECL_GetValue("ECSI_CX_SafetyFunctions");
  var aSafetyFunctions = ECSI_CX_SafetyFunctions.split(";");
  var bK52Mandatory = false;

  if (aSafetyFunctions && aSafetyFunctions.length > 0 && MLFB08_G150 == "1") {
    for (var i = 0; i < aSafetyFunctions.length; i++) {
      if (aSafetyFunctions[i] == "5" || aSafetyFunctions[i] == "6" || aSafetyFunctions[i] == "12") {
        bK52Mandatory = true;
        break;
      }
    }
  } else if (aSafetyFunctions && aSafetyFunctions.length > 0 && MLFB08_G150 == "2") {
    for (var i = 0; i < aSafetyFunctions.length; i++) {
      if (
        aSafetyFunctions[i] == "2" ||
        aSafetyFunctions[i] == "3" ||
        aSafetyFunctions[i] == "4" ||
        aSafetyFunctions[i] == "5" ||
        aSafetyFunctions[i] == "6" ||
        aSafetyFunctions[i] == "12" ||
        aSafetyFunctions[i] == "14"
      ) {
        bK52Mandatory = true;
        break;
      }
    }
  }

  if (bK52Mandatory) {
    ECL_SelectValue(sCB_Attribute, "T");
    ECL_DisableAttribute(sCB_Attribute);
  } else {
    var bCheck = false;
    var aKAG = oData.oParsingData.MLFB.KAG || [];

    if (aKAG.indexOf(sKAG) >= 0) {
      bCheck = Check_K52(oData, sDTKAttribute, sKAG);
    }
    if (bCheck) {
      ECL_EnableAttribute(sCB_Attribute);
      ECL_SelectValue(sCB_Attribute, "T");
    } else {
      ECL_DeselectAttribute(sCB_Attribute);
    }
  }
}
function Check_K52(oData, sDTKAttribute, sKAG) {
  if (oData.IsStartConfig == "0") return 1;
  // -----------------------------------------------------------------------------------------
  /*
        B VT_G150_M00126	Verriegelung Optionen Module-K52
        O_MODULE_G150	O_ZUS_SMC30_K52_G150
    C VT_G150_M00127	Verriegelung Optionen K52-K01
      O_ZUS_SMC30_K52_G150	O_SAFETY_LIZENZ_K01__G150
    A VT_G150_M00128	Verriegelung Design-Opt K52
      IN_AUSFUEHRUNG_G150		O_ZUS_SMC30_K52_G150
  */
  // -----------------------------------------------------------------------------------------
  var IN_AUSFUEHRUNG_G150 = ECL_GetValue("IN_AUSFUEHRUNG_G150");

  var sTable = "VT_G150_M00128" + sDB_Suffix;
  var sSQL =
    "SELECT " +
    sDTKAttribute +
    " FROM " +
    sTable +
    " WHERE " +
    "IN_AUSFUEHRUNG_G150 = '" +
    IN_AUSFUEHRUNG_G150 +
    "' AND " +
    sDTKAttribute +
    " = '" +
    sKAG +
    "';";

  var aResult = GetDBDataSetEXT(sSQL);
  if (aResult.length < 1) {
    return 0;
  }
  // -----------------------------------------------------------------------------------------
  // B VT_G150_M00126	Verriegelung Optionen Module-K52
  //  	O_MODULE_G150	O_ZUS_SMC30_K52_G150
  var O_MODULE_G150 = ECL_GetValue("O_MODULE_G150");

  var sTable = "VT_G150_M00126" + sDB_Suffix;
  var sSQL =
    "SELECT " + sDTKAttribute + " FROM " + sTable + " WHERE " + "O_MODULE_G150 = '" + O_MODULE_G150 + "' AND " + sDTKAttribute + " = '" + sKAG + "';";

  var aResult = GetDBDataSetEXT(sSQL);
  if (aResult.length < 1) {
    return 0;
  }
  // -----------------------------------------------------------------------------------------
  // C VT_G150_M00127	Verriegelung Optionen K52-K01
  //		O_ZUS_SMC30_K52_G150	O_SAFETY_LIZENZ_K01__G150
  var O_SAFETY_LIZENZ_K01__G150 = "STD";
  if (ECL_ValueSelected("CB_O_SAFETY_LIZENZ_K01__G150", "T")) {
    O_SAFETY_LIZENZ_K01__G150 = "K01";
  }
  var sTable = "VT_G150_M00127" + sDB_Suffix;
  var sSQL =
    "SELECT " +
    sDTKAttribute +
    " FROM " +
    sTable +
    " WHERE " +
    "O_SAFETY_LIZENZ_K01__G150 = '" +
    O_SAFETY_LIZENZ_K01__G150 +
    "' AND " +
    sDTKAttribute +
    " = '" +
    sKAG +
    "';";

  var aResult = GetDBDataSetEXT(sSQL);
  if (aResult.length < 1) {
    return 0;
  }
  // -----------------------------------------------------------------------------------------
  return 1;
}
// #############################################################################################
// O_KLMOD_K82_G150	Klemmenmodul zur Ansteuerung der Sicherheitsfunktionen "Safe Torque Off" und "Safe Stop 1"	K82	(K82) Klemmenmodul zur Ansteuerung der Sicherheitsfunktionen "Safe Torque Off" und "Safe Stop 1"	x	CB_O_KLMOD_K82_G150
function Bestimme_K82(oData) {
  // O_KLMOD_K82_G150
  var sDTKAttribute = "O_KLMOD_K82_G150";
  var sCB_Attribute = "CB_" + sDTKAttribute;

  var sKAG = "K82";

  var bCheck = false;
  var aKAG = oData.oParsingData.MLFB.KAG || [];

  // if STO, SS1 K82 select todo

  if (aKAG.indexOf(sKAG) >= 0) {
    bCheck = Check_K82(oData, sDTKAttribute, sKAG);
  }
  if (bCheck) {
    ECL_EnableAttribute(sCB_Attribute);
    ECL_SelectValue(sCB_Attribute, "T");
  } else {
    ECL_DeselectAttribute(sCB_Attribute);
  }
}
function Check_K82(oData, sDTKAttribute, sKAG) {
  if (oData.IsStartConfig == "0") return 1;
  // -----------------------------------------------------------------------------------------
  /*
    VT_G150_M00084	gueltige Optionen Ausfuehrung II
    IN_AUSFUEHRUNG_G150		O_MODULE_G150	O_KLMOD_K82_G150	O_CU_K95_G150
  */
  var IN_AUSFUEHRUNG_G150 = ECL_GetValue("IN_AUSFUEHRUNG_G150");
  var O_MODULE_G150 = ECL_GetValue("O_MODULE_G150");

  var sTable = "VT_G150_M00084" + sDB_Suffix;
  var sSQL =
    "SELECT " +
    sDTKAttribute +
    " FROM " +
    sTable +
    " WHERE " +
    "IN_AUSFUEHRUNG_G150 = '" +
    IN_AUSFUEHRUNG_G150 +
    "' AND " +
    "O_MODULE_G150 = '" +
    O_MODULE_G150 +
    "' AND " +
    sDTKAttribute +
    " = '" +
    sKAG +
    "';";

  var aResult = GetDBDataSetEXT(sSQL);
  if (aResult.length < 1) {
    return 0;
  }
  // -----------------------------------------------------------------------------------------
  return 1;
}
// #############################################################################################
// O_TM54F_K87_G150	Terminal Module TM54F	K87	(K87) Terminal Module TM54F	x	CB_O_TM54F_K87_G150
function Bestimme_K87(oData) {
  // O_TM54F_K87_G150
  var sDTKAttribute = "O_TM54F_K87_G150";
  var sCB_Attribute = "CB_" + sDTKAttribute;

  var sKAG = "K87";

  var bCheck = false;
  var aKAG = oData.oParsingData.MLFB.KAG || [];

  if (aKAG.indexOf(sKAG) >= 0) {
    bCheck = Check_K87(oData, sDTKAttribute, sKAG);
  }
  if (bCheck) {
    ECL_EnableAttribute(sCB_Attribute);
    ECL_SelectValue(sCB_Attribute, "T");
  } else {
    ECL_DeselectAttribute(sCB_Attribute);
  }
}
function Check_K87(oData, sDTKAttribute, sKAG) {
  if (oData.IsStartConfig == "0") return 1;
  // -----------------------------------------------------------------------------------------
  /*
        A VT_G150_M00135	Design<--> option K87
        IN_AUSFUEHRUNG_G150		O_TM54F_K87_G150
    B VT_G150_M00136	Option G61<-->Option K87
      O_KLEMMLEISTE_G61_G150	O_TM54F_K87_G150
    C VT_G150_M00137	Option K01<--> Option K87
      O_SAFETY_LIZENZ_K01__G150	O_TM54F_K87_G150
    */
  // A VT_G150_M00135	Design<--> option K87
  //  	IN_AUSFUEHRUNG_G150		O_TM54F_K87_G150
  var IN_AUSFUEHRUNG_G150 = ECL_GetValue("IN_AUSFUEHRUNG_G150");

  var sTable = "VT_G150_M00135" + sDB_Suffix;
  var sSQL =
    "SELECT " +
    sDTKAttribute +
    " FROM " +
    sTable +
    " WHERE " +
    "IN_AUSFUEHRUNG_G150 = '" +
    IN_AUSFUEHRUNG_G150 +
    "' AND " +
    sDTKAttribute +
    " = '" +
    sKAG +
    "';";

  var aResult = GetDBDataSetEXT(sSQL);
  if (aResult.length < 1) {
    return 0;
  }
  // -----------------------------------------------------------------------------------------
  // B VT_G150_M00136	Option G61<-->Option K87
  //		O_KLEMMLEISTE_G61_G150	O_TM54F_K87_G150
  var O_KLEMMLEISTE_G61_G150 = "STD";
  if (ECL_ValueSelected("CB_O_KLEMMLEISTE_G61_G150", "T")) {
    var O_KLEMMLEISTE_G61_G150 = "G61";
  }

  var sTable = "VT_G150_M00136" + sDB_Suffix;
  var sSQL =
    "SELECT " +
    sDTKAttribute +
    " FROM " +
    sTable +
    " WHERE " +
    "O_KLEMMLEISTE_G61_G150 = '" +
    O_KLEMMLEISTE_G61_G150 +
    "' AND " +
    sDTKAttribute +
    " = '" +
    sKAG +
    "';";

  var aResult = GetDBDataSetEXT(sSQL);
  if (aResult.length < 1) {
    return 0;
  }
  // -----------------------------------------------------------------------------------------
  // C VT_G150_M00137	Option K01<--> Option K87
  //		O_SAFETY_LIZENZ_K01__G150	O_TM54F_K87_G150
  var O_SAFETY_LIZENZ_K01__G150 = "STD";
  if (ECL_ValueSelected("CB_O_SAFETY_LIZENZ_K01__G150", "T")) {
    O_SAFETY_LIZENZ_K01__G150 = "K01";
  }

  var sTable = "VT_G150_M00137" + sDB_Suffix;
  var sSQL =
    "SELECT " +
    sDTKAttribute +
    " FROM " +
    sTable +
    " WHERE " +
    "O_SAFETY_LIZENZ_K01__G150 = '" +
    O_SAFETY_LIZENZ_K01__G150 +
    "' AND " +
    sDTKAttribute +
    " = '" +
    sKAG +
    "';";

  var aResult = GetDBDataSetEXT(sSQL);
  if (aResult.length < 1) {
    return 0;
  }
  // -----------------------------------------------------------------------------------------
  return 1;
}
// #############################################################################################
// O_SAFETY_SBA_K88_G150	Safe Brake Adapter SBA AC 230 V	K88	(K88) Safe Brake Adapter SBA AC 230 V	x	CB_O_SAFETY_SBA_K88_G150
function Bestimme_K88(oData) {
  // O_SAFETY_SBA_K88_G150
  var sDTKAttribute = "O_SAFETY_SBA_K88_G150";
  var sCB_Attribute = "CB_" + sDTKAttribute;

  var sKAG = "K88";

  // K88 mandatory from context Safetyfunctions, if SBC (11)
  var ECSI_CX_SafetyFunctions = ECL_GetValue("ECSI_CX_SafetyFunctions");
  var aSafetyFunctions = ECSI_CX_SafetyFunctions.split(";");
  var bK88Mandatory = false;

  if (aSafetyFunctions && aSafetyFunctions.length > 0) {
    for (var i = 0; i < aSafetyFunctions.length; i++) {
      if (aSafetyFunctions[i] == "11") {
        bK88Mandatory = true;
        break;
      }
    }
  }

  if (bK88Mandatory) {
    ECL_SelectValue(sCB_Attribute, "T");
    ECL_DisableAttribute(sCB_Attribute);
  } else {
    var bCheck = false;
    var aKAG = oData.oParsingData.MLFB.KAG || [];

    if (aKAG.indexOf(sKAG) >= 0) {
      bCheck = Check_K88(oData, sDTKAttribute, sKAG);
    }
    if (bCheck) {
      ECL_EnableAttribute(sCB_Attribute);
      ECL_SelectValue(sCB_Attribute, "T");
    } else {
      ECL_DeselectAttribute(sCB_Attribute);
    }
  }
}
function Check_K88(oData, sDTKAttribute, sKAG) {
  if (oData.IsStartConfig == "0") return 1;
  // -----------------------------------------------------------------------------------------
  /*
      VT_G150_M00138	Design <--> option K88
      IN_AUSFUEHRUNG_G150		O_SAFETY_SBA_K88_G150
    */
  var IN_AUSFUEHRUNG_G150 = ECL_GetValue("IN_AUSFUEHRUNG_G150");

  var sTable = "VT_G150_M00138" + sDB_Suffix;
  var sSQL =
    "SELECT " +
    sDTKAttribute +
    " FROM " +
    sTable +
    " WHERE " +
    "IN_AUSFUEHRUNG_G150 = '" +
    IN_AUSFUEHRUNG_G150 +
    "' AND " +
    sDTKAttribute +
    " = '" +
    sKAG +
    "';";

  var aResult = GetDBDataSetEXT(sSQL);
  if (aResult.length < 1) {
    return 0;
  }
  // -----------------------------------------------------------------------------------------
  return 1;
}
// #############################################################################################
// O_CU_K95_G150	Control Unit CU320-2 PN (PROFINET, EtherNet/IP)	K95	(K95) Control Unit CU320-2 PN (PROFINET, EtherNet/IP)	x	CB_O_CU_K95_G150

function Bestimme_K95(oData) {
  // O_CU_K95_G150
  var sDTKAttribute = "O_CU_K95_G150";
  var sCB_Attribute = "CB_" + sDTKAttribute;

  var sKAG = "K95";

  var bCheck = false;
  var aKAG = oData.oParsingData.MLFB.KAG || [];

  if (aKAG.indexOf(sKAG) >= 0) {
    bCheck = Check_K95(oData, sDTKAttribute, sKAG);
  }
  if (bCheck) {
    ECL_EnableAttribute(sCB_Attribute);
    ECL_SelectValue(sCB_Attribute, "T");
  } else {
    ECL_DeselectAttribute(sCB_Attribute);
  }
}
function Check_K95(oData, sDTKAttribute, sKAG) {
  if (oData.IsStartConfig == "0") return 1;
  // -----------------------------------------------------------------------------------------
  /*
    VT_G150_M00084	gueltige Optionen Ausfuehrung II
    IN_AUSFUEHRUNG_G150		O_MODULE_G150	O_KLMOD_K82_G150	O_CU_K95_G150
    */
  var IN_AUSFUEHRUNG_G150 = ECL_GetValue("IN_AUSFUEHRUNG_G150");
  var O_MODULE_G150 = ECL_GetValue("O_MODULE_G150");

  var O_KLMOD_K82_G150 = "NON";
  if (ECL_ValueSelected("CB_O_KLMOD_K82_G150", "T")) {
    O_KLMOD_K82_G150 = "K82";
  }

  var sTable = "VT_G150_M00084" + sDB_Suffix;
  var sSQL =
    "SELECT " +
    sDTKAttribute +
    " FROM " +
    sTable +
    " WHERE " +
    "IN_AUSFUEHRUNG_G150 = '" +
    IN_AUSFUEHRUNG_G150 +
    "' AND " +
    "O_MODULE_G150 = '" +
    O_MODULE_G150 +
    "' AND " +
    "O_KLMOD_K82_G150 = '" +
    O_KLMOD_K82_G150 +
    "' AND " +
    sDTKAttribute +
    " = '" +
    sKAG +
    "';";

  var aResult = GetDBDataSetEXT(sSQL);
  if (aResult.length < 1) {
    return 0;
  }
  // -----------------------------------------------------------------------------------------
  return 1;
}
// #############################################################################################
// O_HILFSBETR_L19_G150	Anschluss für ext. Hilfsbetriebe	L19	(L19) Anschluss für ext. Hilfsbetriebe	x	CB_O_HILFSBETR_L19_G150
function Bestimme_L19(oData) {
  // O_HILFSBETR_L19_G150
  var sDTKAttribute = "O_HILFSBETR_L19_G150";
  var sCB_Attribute = "CB_" + sDTKAttribute;

  var sKAG = "L19";

  var bCheck = false;
  var aKAG = oData.oParsingData.MLFB.KAG || [];

  if (aKAG.indexOf(sKAG) >= 0) {
    bCheck = Check_L19(oData, sDTKAttribute, sKAG);
  }
  if (bCheck) {
    ECL_EnableAttribute(sCB_Attribute);
    ECL_SelectValue(sCB_Attribute, "T");
  } else {
    ECL_DeselectAttribute(sCB_Attribute);
  }
}
function Check_L19(oData, sDTKAttribute, sKAG) {
  if (oData.IsStartConfig == "0") return 1;
  // -----------------------------------------------------------------------------------------
  /*
    VT_G150_M00085	gueltige Optionen Ausfuehrung III
      IN_AUSFUEHRUNG_G150		O_KLEMMLEISTE_G61_G150	O_HILFSBETR_L19_G150	O_BELEUCHT_L50_G150
    */
  var IN_AUSFUEHRUNG_G150 = ECL_GetValue("IN_AUSFUEHRUNG_G150");

  var O_KLEMMLEISTE_G61_G150 = "STD";
  if (ECL_ValueSelected("CB_O_KLEMMLEISTE_G61_G150", "T")) {
    var O_KLEMMLEISTE_G61_G150 = "G61";
  }

  var sTable = "VT_G150_M00085" + sDB_Suffix;
  var sSQL =
    "SELECT " +
    sDTKAttribute +
    " FROM " +
    sTable +
    " WHERE " +
    "IN_AUSFUEHRUNG_G150 = '" +
    IN_AUSFUEHRUNG_G150 +
    "' AND " +
    "O_KLEMMLEISTE_G61_G150 = '" +
    O_KLEMMLEISTE_G61_G150 +
    "' AND " +
    sDTKAttribute +
    " = '" +
    sKAG +
    "';";

  var aResult = GetDBDataSetEXT(sSQL);
  if (aResult.length < 1) {
    return 0;
  }
  // -----------------------------------------------------------------------------------------
  return 1;
}
// #############################################################################################
// O_BELEUCHT_L50_G150	Schrankbeleuchtung mit Service-Steckdose	L50	(L50) Schrankbeleuchtung mit Service-Steckdose	x	CB_O_BELEUCHT_L50_G150
function Bestimme_L50(oData) {
  // O_BELEUCHT_L50_G150
  var sDTKAttribute = "O_BELEUCHT_L50_G150";
  var sCB_Attribute = "CB_" + sDTKAttribute;

  var sKAG = "L50";

  var bCheck = false;
  var aKAG = oData.oParsingData.MLFB.KAG || [];

  if (aKAG.indexOf(sKAG) >= 0) {
    bCheck = Check_L50(oData, sDTKAttribute, sKAG);
  }
  if (bCheck) {
    ECL_EnableAttribute(sCB_Attribute);
    ECL_SelectValue(sCB_Attribute, "T");
  } else {
    ECL_DeselectAttribute(sCB_Attribute);
  }
}
function Check_L50(oData, sDTKAttribute, sKAG) {
  if (oData.IsStartConfig == "0") return 1;
  // -----------------------------------------------------------------------------------------
  /*
    VT_G150_M00085	gueltige Optionen Ausfuehrung III
        IN_AUSFUEHRUNG_G150		O_KLEMMLEISTE_G61_G150	O_HILFSBETR_L19_G150	O_BELEUCHT_L50_G150
    VT_G150_M00141	ZO Header Note K74 L50 L55
        O_HILFSSPG_INTERN_G150	O_BELEUCHT_L50_G150		O_STILLST_L55_G150		HMK_NOTE_K74_L50_L55_G150
    */
  var IN_AUSFUEHRUNG_G150 = ECL_GetValue("IN_AUSFUEHRUNG_G150");

  var O_KLEMMLEISTE_G61_G150 = "STD";
  if (ECL_ValueSelected("CB_O_KLEMMLEISTE_G61_G150", "T")) {
    var O_KLEMMLEISTE_G61_G150 = "G61";
  }

  var O_HILFSBETR_L19_G150 = "NON";
  if (ECL_ValueSelected("CB_O_HILFSBETR_L19_G150", "T")) {
    O_HILFSBETR_L19_G150 = "L19";
  }

  var sTable = "VT_G150_M00085" + sDB_Suffix;
  var sSQL =
    "SELECT " +
    sDTKAttribute +
    " FROM " +
    sTable +
    " WHERE " +
    "IN_AUSFUEHRUNG_G150 = '" +
    IN_AUSFUEHRUNG_G150 +
    "' AND " +
    "O_KLEMMLEISTE_G61_G150 = '" +
    O_KLEMMLEISTE_G61_G150 +
    "' AND " +
    "O_HILFSBETR_L19_G150 = '" +
    O_HILFSBETR_L19_G150 +
    "' AND " +
    sDTKAttribute +
    " = '" +
    sKAG +
    "';";

  var aResult = GetDBDataSetEXT(sSQL);
  if (aResult.length < 1) {
    return 0;
  }
  // -----------------------------------------------------------------------------------------
  var O_HILFSSPG_INTERN_G150 = ECL_GetValue("O_HILFSSPG_INTERN_G150");
  var sTable = "VT_G150_M00141" + sDB_Suffix;
  var sSQL =
    "SELECT " +
    sDTKAttribute +
    " FROM " +
    sTable +
    " WHERE " +
    "O_HILFSSPG_INTERN_G150 = '" +
    O_HILFSSPG_INTERN_G150 +
    "' AND " +
    sDTKAttribute +
    " = '" +
    sKAG +
    "';";

  var aResult = GetDBDataSetEXT(sSQL);
  if (aResult.length < 1) {
    return 0;
  }
  // -----------------------------------------------------------------------------------------
  return 1;
}
// #############################################################################################
// O_STILLST_L55_G150	Schrank Stillstandsheizung	L55	(L55) Schrank Stillstandsheizung	x	CB_O_STILLST_L55_G150
function Bestimme_L55(oData) {
  // O_STILLST_L55_G150
  var sDTKAttribute = "O_STILLST_L55_G150";
  var sCB_Attribute = "CB_" + sDTKAttribute;

  var sKAG = "L55";

  var bCheck = false;
  var aKAG = oData.oParsingData.MLFB.KAG || [];

  if (aKAG.indexOf(sKAG) >= 0) {
    bCheck = Check_L55(oData, sDTKAttribute, sKAG);
  }
  if (bCheck) {
    ECL_EnableAttribute(sCB_Attribute);
    ECL_SelectValue(sCB_Attribute, "T");
  } else {
    ECL_DeselectAttribute(sCB_Attribute);
  }
}
function Check_L55(oData, sDTKAttribute, sKAG) {
  if (oData.IsStartConfig == "0") return 1;
  // -----------------------------------------------------------------------------------------
  /*
    VT_G150_M00112	Einschraenkungen_M66_L55
        O_SCHIFF_M66_G150	O_STILLST_L55_G150
    VT_G150_M00141	ZO Header Note K74 L50 L55
        O_HILFSSPG_INTERN_G150	O_BELEUCHT_L50_G150		O_STILLST_L55_G150		HMK_NOTE_K74_L50_L55_G150
    */
  var O_HILFSSPG_INTERN_G150 = ECL_GetValue("O_HILFSSPG_INTERN_G150");

  var O_BELEUCHT_L50_G150 = "NON";
  if (ECL_ValueSelected("CB_O_BELEUCHT_L50_G150", "T")) {
    var O_BELEUCHT_L50_G150 = "L50";
  }

  var sTable = "VT_G150_M00141" + sDB_Suffix;
  var sSQL =
    "SELECT " +
    sDTKAttribute +
    " FROM " +
    sTable +
    " WHERE " +
    "O_HILFSSPG_INTERN_G150 = '" +
    O_HILFSSPG_INTERN_G150 +
    "' AND " +
    "O_BELEUCHT_L50_G150 = '" +
    O_BELEUCHT_L50_G150 +
    "' AND " +
    sDTKAttribute +
    " = '" +
    sKAG +
    "';";

  var aResult = GetDBDataSetEXT(sSQL);
  if (aResult.length < 1) {
    return 0;
  }
  // -----------------------------------------------------------------------------------------
  return 1;
}
// #############################################################################################
// O_ADEREND_M91_G150	Vollständige Aderendmarkierung der Steuerleitungen	M91	(M91) Vollständige Aderendmarkierung der Steuerleitungen	x	CB_O_ADEREND_M91_G150
function Bestimme_M91(oData) {
  // O_ADEREND_M91_G150
  var sDTKAttribute = "O_ADEREND_M91_G150";
  var sCB_Attribute = "CB_" + sDTKAttribute;

  var sKAG = "M91";

  var bCheck = false;
  var aKAG = oData.oParsingData.MLFB.KAG || [];

  if (aKAG.indexOf(sKAG) >= 0) {
    bCheck = Check_M91(oData, sDTKAttribute, sKAG);
  }
  if (bCheck) {
    ECL_EnableAttribute(sCB_Attribute);
    ECL_SelectValue(sCB_Attribute, "T");
  } else {
    ECL_DeselectAttribute(sCB_Attribute);
  }
}

function Check_M91(oData, sDTKAttribute, sKAG) {
  if (oData.IsStartConfig == "0") return 1;
  // -----------------------------------------------------------------------------------------
  /*
        keine
    */
  // -----------------------------------------------------------------------------------------
  return 1;
}
// #############################################################################################
// O_SONDERLACK_Y09_G150	Schrank-Sonderlackierung					NON, Y09
//	OE_LACK_G150	(Y09) Schrank-Sonderlackierung - RAL Farbe:
function Bestimme_Y09(oData) {
  // O_SONDERLACK_Y09_G150
  var sDTKAttribute = "O_SONDERLACK_Y09_G150";
  // KAGs  NON, Y09
  var aKAG = oData.oParsingData.MLFB.KAG || [];

  var sKAG = getKAGforAttribute(sDTKAttribute, aKAG);
  var bCheck = false;
  if (sKAG != "NON") {
    bCheck = Check_Y09(oData, sDTKAttribute, sKAG);
  }
  if (bCheck) {
    ECL_ActivateValue(sDTKAttribute, sKAG);
    ECL_SelectValue(sDTKAttribute, sKAG);
  } else {
    ECL_ActivateValue(sDTKAttribute, "NON");
    ECL_SelectValue(sDTKAttribute, "NON");
    ECL_ResetAttribute("OE_LACK_G150");
  }
}

function Check_Y09(oData, sDTKAttribute, sKAG) {
  if (oData.IsStartConfig == "0") return 1;
  // -----------------------------------------------------------------------------------------
  /*
        keine
    */
  // -----------------------------------------------------------------------------------------
  return 1;
}
// #############################################################################################
// O_NAMUR_B00_G150	Namur Klemmenleiste	B00	(B00) Namur Klemmenleiste	x	CB_O_NAMUR_B00_G150
function Bestimme_B00(oData) {
  // O_NAMUR_B00_G150
  var sDTKAttribute = "O_NAMUR_B00_G150";
  var sCB_Attribute = "CB_" + sDTKAttribute;

  var sKAG = "B00";

  var bCheck = false;
  var aKAG = oData.oParsingData.MLFB.KAG || [];

  if (aKAG.indexOf(sKAG) >= 0) {
    bCheck = Check_B00(oData, sDTKAttribute, sKAG);
  }
  if (bCheck) {
    ECL_EnableAttribute(sCB_Attribute);
    ECL_SelectValue(sCB_Attribute, "T");
  } else {
    ECL_DeselectAttribute(sCB_Attribute);
  }
}
function Check_B00(oData, sDTKAttribute, sKAG) {
  if (oData.IsStartConfig == "0") return 1;
  // -----------------------------------------------------------------------------------------
  /*
        VT_G150_M00086	gueltige Optionen Ausfuehrung IV
          IN_AUSFUEHRUNG_G150		O_BREMSEINHEIT_G150		O_NAMUR_B00_G150	O_USV_B02_G150		O_FREMD_B03_G150
    n.n. VT_G150_M00089	Verriegelung Optionen - Einbaugeraet VI
    VT_G150_M00107	Einschraenkungen_MLFB_B00_L13_L26
      HMK_FALLNUMMER_G150		MLFB11_G150		O_NAMUR_B00_G150	O_SCHUETZ_L13_G150	O_SCHALTER_L26_G150
    */
  var IN_AUSFUEHRUNG_G150 = ECL_GetValue("IN_AUSFUEHRUNG_G150");
  var O_BREMSEINHEIT_G150 = ECL_GetValue("O_BREMSEINHEIT_G150");

  var sTable = "VT_G150_M00086" + sDB_Suffix;
  var sSQL =
    "SELECT " +
    sDTKAttribute +
    " FROM " +
    sTable +
    " WHERE " +
    "IN_AUSFUEHRUNG_G150 = '" +
    IN_AUSFUEHRUNG_G150 +
    "' AND " +
    "O_BREMSEINHEIT_G150 = '" +
    O_BREMSEINHEIT_G150 +
    "' AND " +
    sDTKAttribute +
    " = '" +
    sKAG +
    "';";

  var aResult = GetDBDataSetEXT(sSQL);
  if (aResult.length < 1) {
    return 0;
  }
  // -----------------------------------------------------------------------------------------
  var HMK_FALLNUMMER_G150 = ECL_GetValue("HMK_FALLNUMMER_G150");
  var MLFB11_G150 = oData.oParsingData.MLFB.POS11_13;

  var O_SCHUETZ_L13_G150 = "STD";
  if (ECL_ValueSelected("CB_O_SCHUETZ_L13_G150", "T")) {
    O_SCHUETZ_L13_G150 = "L13";
  }
  var O_SCHALTER_L26_G150 = "STD";
  if (ECL_ValueSelected("CB_O_SCHALTER_L26_G150", "T")) {
    O_SCHALTER_L26_G150 = "L26";
  }

  var sTable = "VT_G150_M00107" + sDB_Suffix;
  var sSQL =
    "SELECT " +
    sDTKAttribute +
    " FROM " +
    sTable +
    " WHERE " +
    "HMK_FALLNUMMER_G150 = '" +
    HMK_FALLNUMMER_G150 +
    "' AND " +
    "MLFB11_G150 = '" +
    MLFB11_G150 +
    "' AND " +
    "O_SCHUETZ_L13_G150 = '" +
    O_SCHUETZ_L13_G150 +
    "' AND " +
    "O_SCHALTER_L26_G150 = '" +
    O_SCHALTER_L26_G150 +
    "' AND " +
    sDTKAttribute +
    " = '" +
    sKAG +
    "';";

  var aResult = GetDBDataSetEXT(sSQL);
  if (aResult.length < 1) {
    return 0;
  }
  // -----------------------------------------------------------------------------------------
  return 1;
}
// #############################################################################################
// O_USV_B02_G150	Sicher getrennte 24-V-Versorgung	B02	(B02) Sicher getrennte 24-V-Versorgung	x	CB_O_USV_B02_G150
function Bestimme_B02(oData) {
  // O_USV_B02_G150
  var sDTKAttribute = "O_USV_B02_G150";
  var sCB_Attribute = "CB_" + sDTKAttribute;

  var sKAG = "B02";

  var bCheck = false;
  var aKAG = oData.oParsingData.MLFB.KAG || [];

  if (aKAG.indexOf(sKAG) >= 0) {
    bCheck = Check_B02(oData, sDTKAttribute, sKAG);
  }
  if (bCheck) {
    ECL_EnableAttribute(sCB_Attribute);
    ECL_SelectValue(sCB_Attribute, "T");
  } else {
    ECL_DeselectAttribute(sCB_Attribute);
  }
}
function Check_B02(oData, sDTKAttribute, sKAG) {
  if (oData.IsStartConfig == "0") return 1;
  // -----------------------------------------------------------------------------------------
  /*
        VT_G150_M00086	gueltige Optionen Ausfuehrung IV
        IN_AUSFUEHRUNG_G150		O_BREMSEINHEIT_G150		O_NAMUR_B00_G150	O_USV_B02_G150		O_FREMD_B03_G150
    */
  var IN_AUSFUEHRUNG_G150 = ECL_GetValue("IN_AUSFUEHRUNG_G150");
  var O_BREMSEINHEIT_G150 = ECL_GetValue("O_BREMSEINHEIT_G150");

  var O_NAMUR_B00_G150 = "NON";
  if (ECL_ValueSelected("CB_O_NAMUR_B00_G150", "T")) {
    O_NAMUR_B00_G150 = "B00";
  }

  var sTable = "VT_G150_M00086" + sDB_Suffix;
  var sSQL =
    "SELECT " +
    sDTKAttribute +
    " FROM " +
    sTable +
    " WHERE " +
    "IN_AUSFUEHRUNG_G150 = '" +
    IN_AUSFUEHRUNG_G150 +
    "' AND " +
    "O_BREMSEINHEIT_G150 = '" +
    O_BREMSEINHEIT_G150 +
    "' AND " +
    "O_NAMUR_B00_G150 = '" +
    O_NAMUR_B00_G150 +
    "' AND " +
    sDTKAttribute +
    " = '" +
    sKAG +
    "';";

  var aResult = GetDBDataSetEXT(sSQL);
  if (aResult.length < 1) {
    return 0;
  }
  // -----------------------------------------------------------------------------------------
  return 1;
}
// #############################################################################################
// O_FREMD_B03_G150	Fremdabgang externe Hilfsbetriebe	B03	(B03) Fremdabgang externe Hilfsbetriebe	x	CB_O_FREMD_B03_G150
function Bestimme_B03(oData) {
  // O_FREMD_B03_G150
  var sDTKAttribute = "O_FREMD_B03_G150";
  var sCB_Attribute = "CB_" + sDTKAttribute;

  var sKAG = "B03";

  var bCheck = false;
  var aKAG = oData.oParsingData.MLFB.KAG || [];

  if (aKAG.indexOf(sKAG) >= 0) {
    bCheck = Check_B03(oData, sDTKAttribute, sKAG);
  }
  if (bCheck) {
    ECL_EnableAttribute(sCB_Attribute);
    ECL_SelectValue(sCB_Attribute, "T");
  } else {
    ECL_DeselectAttribute(sCB_Attribute);
  }
}
function Check_B03(oData, sDTKAttribute, sKAG) {
  if (oData.IsStartConfig == "0") return 1;
  // -----------------------------------------------------------------------------------------
  /*
    VT_G150_M00086	gueltige Optionen Ausfuehrung IV
    IN_AUSFUEHRUNG_G150		O_BREMSEINHEIT_G150		O_NAMUR_B00_G150	O_USV_B02_G150		O_FREMD_B03_G150
  */
  // --------------------------------------------------------------------------------------------
  var IN_AUSFUEHRUNG_G150 = ECL_GetValue("IN_AUSFUEHRUNG_G150");
  var O_BREMSEINHEIT_G150 = ECL_GetValue("O_BREMSEINHEIT_G150");

  var O_NAMUR_B00_G150 = "NON";
  if (ECL_ValueSelected("CB_O_NAMUR_B00_G150", "T")) {
    var O_NAMUR_B00_G150 = "B00";
  }

  var O_USV_B02_G150 = "NON";
  if (ECL_ValueSelected("CB_O_USV_B02_G150", "T")) {
    var O_USV_B02_G150 = "B02";
  }

  // A VT_G150_M00116	Einschraenkungen_MLFB_M78
  //		HMK_FALLNUMMER_G150		MLFB11_G150		O_MOTORANSCHL_M78_G150
  var sTable = "VT_G150_M00086" + sDB_Suffix;
  var sSQL =
    "SELECT " +
    sDTKAttribute +
    " FROM " +
    sTable +
    " WHERE " +
    "IN_AUSFUEHRUNG_G150 = '" +
    IN_AUSFUEHRUNG_G150 +
    "' AND " +
    "O_BREMSEINHEIT_G150 = '" +
    O_BREMSEINHEIT_G150 +
    "' AND " +
    "O_NAMUR_B00_G150 = '" +
    O_NAMUR_B00_G150 +
    "' AND " +
    "O_USV_B02_G150 = '" +
    O_USV_B02_G150 +
    "' AND " +
    sDTKAttribute +
    " = '" +
    sKAG +
    "';";

  var aResult = GetDBDataSetEXT(sSQL);
  if (aResult.length < 1) {
    return 0;
  }
  // -----------------------------------------------------------------------------------------
  return 1;
}
// #############################################################################################
// O_SCHIFF_M66_G150	Schiffsausführung	M66	(M66) Schiffsausführung	x	CB_O_SCHIFF_M66_G150
function Bestimme_M66(oData) {
  // O_SCHIFF_M66_G150
  var sDTKAttribute = "O_SCHIFF_M66_G150";
  var sCB_Attribute = "CB_" + sDTKAttribute;

  var sKAG = "M66";

  var bCheck = false;
  var aKAG = oData.oParsingData.MLFB.KAG || [];

  if (aKAG.indexOf(sKAG) >= 0) {
    bCheck = Check_M66(oData, sDTKAttribute, sKAG);
  }
  if (bCheck) {
    ECL_EnableAttribute(sCB_Attribute);
    ECL_SelectValue(sCB_Attribute, "T");
  } else {
    ECL_DeselectAttribute(sCB_Attribute);
  }
}
function Check_M66(oData, sDTKAttribute, sKAG) {
  if (oData.IsStartConfig == "0") return 1;
  // -----------------------------------------------------------------------------------------
  /*
    E 	VT_G150_M00059	gueltige Optionen Schiff/Zertifikat
        O_SCHIFF_M66_G150	O_ZERTIFITKAT_G150
    n.n. VT_G150_M00060	Verriegelung Anwendung - M66
      HMK_ANWENDUNG_G150	O_SCHIFF_M66_G150
  B	VT_G150_M00111	Einschraenkungen_M66_L01
      O_CLEAN_L01_G150	O_SCHIFF_M66_G150
  C	VT_G150_M00112	Einschraenkungen_M66_L55
      O_SCHIFF_M66_G150	O_STILLST_L55_G150
  A	VT_G150_M00113	Einschraenkungen_MLFB_M66
      HMK_FALLNUMMER_G150		MLFB11_G150		O_SCHIFF_M66_G150
  D	VT_G150_M00140	Hilfsspannungsversorgung - M66
      O_HILFSSPG_INTERN_G150		O_SCHIFF_M66_G150
    */
  // A VT_G150_M00113	Einschraenkungen_MLFB_M66
  //		HMK_FALLNUMMER_G150		MLFB11_G150		O_SCHIFF_M66_G150
  var HMK_FALLNUMMER_G150 = ECL_GetValue("HMK_FALLNUMMER_G150");
  var MLFB11_G150 = oData.oParsingData.MLFB.POS11_13;

  var sTable = "VT_G150_M00113" + sDB_Suffix;
  var sSQL =
    "SELECT " +
    sDTKAttribute +
    " FROM " +
    sTable +
    " WHERE " +
    "HMK_FALLNUMMER_G150 = '" +
    HMK_FALLNUMMER_G150 +
    "' AND " +
    "MLFB11_G150 = '" +
    MLFB11_G150 +
    "' AND " +
    sDTKAttribute +
    " = '" +
    sKAG +
    "';";

  var aResult = GetDBDataSetEXT(sSQL);
  if (aResult.length < 1) {
    return 0;
  }
  // -----------------------------------------------------------------------------------------
  // B VT_G150_M00111	Einschraenkungen_M66_L01
  //		O_CLEAN_L01_G150	O_SCHIFF_M66_G150
  var O_CLEAN_L01_G150 = "STD";
  if (ECL_ValueSelected("CB_O_CLEAN_L01_G150", "T")) {
    O_CLEAN_L01_G150 = "L01";
  }

  var sTable = "VT_G150_M00111" + sDB_Suffix;
  var sSQL =
    "SELECT " +
    sDTKAttribute +
    " FROM " +
    sTable +
    " WHERE " +
    "O_CLEAN_L01_G150 = '" +
    O_CLEAN_L01_G150 +
    "' AND " +
    sDTKAttribute +
    " = '" +
    sKAG +
    "';";

  var aResult = GetDBDataSetEXT(sSQL);
  if (aResult.length < 1) {
    return 0;
  }
  // -----------------------------------------------------------------------------------------
  // C VT_G150_M00112	Einschraenkungen_M66_L55
  //		O_SCHIFF_M66_G150	O_STILLST_L55_G150
  var O_STILLST_L55_G150 = "NON";
  if (ECL_ValueSelected("CB_O_STILLST_L55_G150", "T")) {
    O_STILLST_L55_G150 = "L55";
  }

  var sTable = "VT_G150_M00112" + sDB_Suffix;
  var sSQL =
    "SELECT " +
    sDTKAttribute +
    " FROM " +
    sTable +
    " WHERE " +
    "O_STILLST_L55_G150 = '" +
    O_STILLST_L55_G150 +
    "' AND " +
    sDTKAttribute +
    " = '" +
    sKAG +
    "';";

  var aResult = GetDBDataSetEXT(sSQL);
  if (aResult.length < 1) {
    return 0;
  }
  // -----------------------------------------------------------------------------------------
  // D VT_G150_M00140	Hilfsspannungsversorgung - M66
  //		O_HILFSSPG_INTERN_G150		O_SCHIFF_M66_G150
  var O_HILFSSPG_INTERN_G150 = ECL_GetValue("O_HILFSSPG_INTERN_G150");

  var sTable = "VT_G150_M00140" + sDB_Suffix;
  var sSQL =
    "SELECT " +
    sDTKAttribute +
    " FROM " +
    sTable +
    " WHERE " +
    "O_HILFSSPG_INTERN_G150 = '" +
    O_HILFSSPG_INTERN_G150 +
    "' AND " +
    sDTKAttribute +
    " = '" +
    sKAG +
    "';";

  var aResult = GetDBDataSetEXT(sSQL);
  if (aResult.length < 1) {
    return 0;
  }
  // -----------------------------------------------------------------------------------------
  // E VT_G150_M00059	gueltige Optionen Schiff/Zertifikat
  //		O_SCHIFF_M66_G150	O_ZERTIFITKAT_G150
  var O_ZERTIFITKAT_G150 = ECL_GetValue("O_ZERTIFITKAT_G150");

  var sTable = "VT_G150_M00059" + sDB_Suffix;
  var sSQL = "SELECT " + sDTKAttribute + " FROM " + sTable + " WHERE " +
    "O_ZERTIFITKAT_G150 = '" + O_ZERTIFITKAT_G150 + "' AND " +
    sDTKAttribute + " = '" + sKAG + "';";

  var aResult = GetDBDataSetEXT(sSQL);
  if (aResult.length < 1) {
    return 0;
  }
  // -----------------------------------------------------------------------------------------
  return 1;
}
// #############################################################################################
/*
O_ZERTIFITKAT_G150  Einzelzertifikat	Individual certificate	NON [E21, E31, E51, E61, E71, NON]
    VT_G150_M00022	gueltige Optionen CleanPower/Zertifikate
      O_CLEAN_L01_G150	O_ZERTIFITKAT_G150	O_SCHUTZART_G150
  VT_G150_M00059	gueltige Optionen Schiff/Zertifikat
    O_SCHIFF_M66_G150	O_ZERTIFITKAT_G150
*/
function Bestimme_O_ZERTIFITKAT(oData) {
  // O_ZERTIFITKAT_G150
  var sDTKAttribute = "O_ZERTIFITKAT_G150";

  // KAGs  [E21, E31, E51, E61, E71, NON]
  var aKAG = oData.oParsingData.MLFB.KAG || [];

  var sKAG = getKAGforAttribute(sDTKAttribute, aKAG);
  var bCheck = false;
  if (sKAG != "NON") {
    bCheck = Check_O_ZERTIFITKAT(oData, sDTKAttribute, sKAG);
  }
  if (bCheck) {
    ECL_ActivateValue(sDTKAttribute, sKAG);
    ECL_SelectValue(sDTKAttribute, sKAG);
  } else {
    ECL_ActivateValue(sDTKAttribute, "NON");
    ECL_SelectValue(sDTKAttribute, "NON");
  }
}
function Check_O_ZERTIFITKAT(oData, sDTKAttribute, sKAG) {
  if (oData.IsStartConfig == "0") return 1;

  /* todo
     * VT:
   * 	VT_G150_M00022	gueltige Optionen CleanPower/Zertifikate
   * 		O_CLEAN_L01_G150	O_ZERTIFITKAT_G150	O_SCHUTZART_G150
    VT_G150_M00059	gueltige Optionen Schiff/Zertifikat
      O_SCHIFF_M66_G150	O_ZERTIFITKAT_G150
  * /
  var O_CLEAN_L01_G150 = "STD";
  if (ECL_ValueSelected("CB_O_CLEAN_L01_G150", "T")){
    var O_CLEAN_L01_G150 = "L01";
  }
  var O_SCHUTZART_G150 = ECL_GetValue("O_SCHUTZART_G150");

  var sTable = "VT_G150_M00022" + sDB_Suffix;
  var sWhere = 	"O_CLEAN_L01_G150 = '" + O_CLEAN_L01_G150 + "' AND " +
          "O_SCHUTZART_G150 = '" + O_SCHUTZART_G150 + "';";
	
  var sStatus = SetAttributeLogic1st(sTable, sDTKAttribute, sWhere);
	
  if (sStatus == "Error"){
    strError = "DICT1_ERR_G150___PL_O_ZERTIFITKAT";
    return strError;
  }
  // --------------------------------------------------------------------------------------------
  // VT_G150_M00059	gueltige Optionen Schiff/Zertifikat
  //		O_SCHIFF_M66_G150	O_ZERTIFITKAT_G150
	
  var O_SCHIFF_M66_G150 = "STD";
  if (ECL_ValueSelected("CB_O_SCHIFF_M66_G150", "T")){
    var O_SCHIFF_M66_G150 = "M66";
  }
	
  var sTable = "VT_G150_M00059" + sDB_Suffix;
  var sWhere = "O_SCHIFF_M66_G150 = '" + O_SCHIFF_M66_G150 + "';";
	
  var sStatus = SetAttributeLogic2nd(sTable, sDTKAttribute, sWhere);
	
  if (sStatus == "Error"){
    strError = "DICT1_ERR_G150___PL_O_ZERTIFITKAT";
    return strError;
  }
    */
  return 1;
}
