//@legacy
//#mode(full-ecma)

//@import "CFG_G150_VT.js"

function SetOptions4_Init_G150(oData) {
  /*
    O_SPRACHE_SCHILD_G150	Leistungsschildangaben  NON, T58, T60, T80, T85, T91
    O_DOKU_SPRACHE_G150	    Dokumentationssprache   NON, D58, D60, D80, D91, D94
    O_FLOWCHARTS_G150	    Fertigungsablaufpläne   B43, B44, B45
    
    O_DOKU_D02_G150	Kundendokumentation im DXF-Format	        D02     x	CB_O_DOKU_D02_G150
    O_DOKU_D14_G150	Vorab-Erstellung der Kundendokumentation	D14	x	CB_O_DOKU_D14_G150
    O_DOKU_D00_G150	Dokumentation in Einzelsprache, Deutsch	    D00	x	CB_O_DOKU_D00_G150
    O_DOKU_D56_G150	Dokumentation in Einzelsprache, Russisch	D56	x	CB_O_DOKU_D56_G150
    O_DOKU_D72_G150	Dokumentation in Einzelsprache, Italienisch	D72	x	CB_O_DOKU_D72_G150
    O_DOKU_D76_G150	Dokumentation in Einzelsprache, Englisch	D76	x	CB_O_DOKU_D76_G150
    O_DOKU_D77_G150	Dokumentation in Einzelsprache, Französisch	D77	x	CB_O_DOKU_D77_G150
    O_DOKU_D78_G150	Dokumentation in Einzelsprache, Spanisch	D78	x	CB_O_DOKU_D78_G150
    O_DOKU_D84_G150	Dokumentation in Einzelsprache, Chinesisch	D84	x	CB_O_DOKU_D84_G150

    ==> in SecMLFB
        OZ_EPLAN_MLFB_G150	EPLAN Electric P8 Projekt-Dokumentation für SINAMICS Schrankgeräte	6SL3780-0AK00-0AA0	x	CB_OZ_EPLAN_MLFB_G150

    O_FUNCTION_TEST_G150        Function test                                 NON, F03, F71, F72, F74, F75
    O_INSULATION_TEST_G150	    Insulation test                               NON, F77, F76

    O_ABNAHME_F97_G150	        Kundenspezifische Abnahme   F97, NON    x	CB_O_ABNAHME_F97_G150
    */

  if (oData && !isEmpty(oData)) {
    Bestimme_O_SPRACHE_SCHILD(oData); //
    Bestimme_O_DOKU_SPRACHE(oData); //
    Bestimme_O_FLOWCHARTS(oData); //

    Bestimme_D01(oData); //
    Bestimme_D02(oData); //
    Bestimme_D14(oData); //
    Bestimme_D00(oData); //
    Bestimme_D56(oData); //
    Bestimme_D72(oData); //
    Bestimme_D76(oData); //
    Bestimme_D77(oData); //
    Bestimme_D78(oData); //
    Bestimme_D84(oData); //

    setFunctionTest(oData); //
    setInsulationTest(oData); //
    Bestimme_F97(oData); //
  } else {
    ExecSetStandardifValueEmpty("O_SPRACHE_SCHILD_G150", "NON");
    ExecSetStandardifValueEmpty("O_DOKU_SPRACHE_G150", "NON");
    ExecSetStandardifValueEmpty("O_FLOWCHARTS_G150", "NON");

    ECL_DeselectAttribute("CB_O_DOKU_D01_G150");
    ECL_DeselectAttribute("CB_O_DOKU_D02_G150");
    ECL_DeselectAttribute("CB_O_DOKU_D14_G150");
    ECL_DeselectAttribute("CB_O_DOKU_D00_G150");
    ECL_DeselectAttribute("CB_O_DOKU_D56_G150");
    ECL_DeselectAttribute("CB_O_DOKU_D72_G150");
    ECL_DeselectAttribute("CB_O_DOKU_D76_G150");
    ECL_DeselectAttribute("CB_O_DOKU_D77_G150");
    ECL_DeselectAttribute("CB_O_DOKU_D78_G150");
    ECL_DeselectAttribute("CB_O_DOKU_D84_G150");

    ExecSetStandardifValueEmpty("O_FUNCTION_TEST_G150", "NON");
    ExecSetStandardifValueEmpty("O_INSULATION_TEST_G150", "NON");

    ECL_DeselectAttribute("CB_O_ABNAHME_F97_G150");
  }
}

// #############################################################################################
//  O_SPRACHE_SCHILD_G150	Leistungsschildangaben  NON, T58, T60, T80, T85, T91
function Bestimme_O_SPRACHE_SCHILD(oData) {
  // O_SPRACHE_SCHILD_G150
  var sDTKAttribute = "O_SPRACHE_SCHILD_G150";

  // KAGs  NON, T58, T60, T80, T85, T91
  var aKAG = oData.oParsingData.MLFB.KAG || [];

  var sKAG = getKAGforAttribute(sDTKAttribute, aKAG);

  if (sKAG != "NON") {
    ECL_ActivateValue(sDTKAttribute, sKAG);
    ECL_SelectValue(sDTKAttribute, sKAG);
  } else {
    ECL_ActivateValue(sDTKAttribute, "NON");
    ECL_SelectValue(sDTKAttribute, "NON");
  }
}

// #############################################################################################
// O_DOKU_SPRACHE_G150	    Dokumentationssprache   NON, D58, D60, D80, D91, D94
function Bestimme_O_DOKU_SPRACHE(oData) {
  // O_DOKU_SPRACHE_G150
  var sDTKAttribute = "O_DOKU_SPRACHE_G150";

  // KAGs  NON, D58, D60, D80, D91, D94
  var aKAG = oData.oParsingData.MLFB.KAG || [];

  var sKAG = getKAGforAttribute(sDTKAttribute, aKAG);

  if (sKAG != "NON") {
    ECL_ActivateValue(sDTKAttribute, sKAG);
    ECL_SelectValue(sDTKAttribute, sKAG);
  } else {
    ECL_ActivateValue(sDTKAttribute, "NON");
    ECL_SelectValue(sDTKAttribute, "NON");
  }
}

// #############################################################################################
// O_FLOWCHARTS_G150	    Fertigungsablaufpläne   B43, B44, B45, "NON" manuell ergänzt
function Bestimme_O_FLOWCHARTS(oData) {
  // O_FLOWCHARTS_G150
  var sDTKAttribute = "O_FLOWCHARTS_G150";

  // KAGs  B43, B44, B45, NON
  var aKAG = oData.oParsingData.MLFB.KAG || [];

  var sKAG = getKAGforAttribute(sDTKAttribute, aKAG);

  if (sKAG != "NON") {
    ECL_ActivateValue(sDTKAttribute, sKAG);
    ECL_SelectValue(sDTKAttribute, sKAG);
  } else {
    ECL_ActivateValue(sDTKAttribute, "NON");
    ECL_SelectValue(sDTKAttribute, "NON");
  }
}

// #############################################################################################
// O_DOKU_D01_G150	Kundendokumentation im EPLAN-Format	        D01     x	CB_O_DOKU_D01_G150
function Bestimme_D01(oData) {
  // O_DOKU_D01_G150
  var sDTKAttribute = "O_DOKU_D01_G150";
  var sCB_Attribute = "CB_" + sDTKAttribute;

  var sKAG = "D01";

  var aKAG = oData.oParsingData.MLFB.KAG || [];

  if (aKAG.indexOf(sKAG) >= 0) {
    ECL_EnableAttribute(sCB_Attribute);
    ECL_SelectValue(sCB_Attribute, "T");
  } else {
    ECL_DeselectAttribute(sCB_Attribute);
  }
}

// #############################################################################################
// O_DOKU_D02_G150	Kundendokumentation im DXF-Format	        D02     x	CB_O_DOKU_D02_G150
function Bestimme_D02(oData) {
  // O_DOKU_D02_G150
  var sDTKAttribute = "O_DOKU_D02_G150";
  var sCB_Attribute = "CB_" + sDTKAttribute;

  var sKAG = "D02";

  var aKAG = oData.oParsingData.MLFB.KAG || [];

  if (aKAG.indexOf(sKAG) >= 0) {
    ECL_EnableAttribute(sCB_Attribute);
    ECL_SelectValue(sCB_Attribute, "T");
  } else {
    ECL_DeselectAttribute(sCB_Attribute);
  }
}

// #############################################################################################
// O_DOKU_D14_G150	Vorab-Erstellung der Kundendokumentation	D14	x	CB_O_DOKU_D14_G150
function Bestimme_D14(oData) {
  // O_DOKU_D14_G150
  var sDTKAttribute = "O_DOKU_D14_G150";
  var sCB_Attribute = "CB_" + sDTKAttribute;

  var sKAG = "D14";

  var aKAG = oData.oParsingData.MLFB.KAG || [];

  if (aKAG.indexOf(sKAG) >= 0) {
    ECL_EnableAttribute(sCB_Attribute);
    ECL_SelectValue(sCB_Attribute, "T");
  } else {
    ECL_DeselectAttribute(sCB_Attribute);
  }
}

// #############################################################################################
// O_DOKU_D00_G150	Dokumentation in Einzelsprache, Deutsch	    D00	x	CB_O_DOKU_D00_G150
function Bestimme_D00(oData) {
  // O_DOKU_D00_G150
  var sDTKAttribute = "O_DOKU_D00_G150";
  var sCB_Attribute = "CB_" + sDTKAttribute;

  var sKAG = "D00";

  var aKAG = oData.oParsingData.MLFB.KAG || [];

  if (aKAG.indexOf(sKAG) >= 0) {
    ECL_EnableAttribute(sCB_Attribute);
    ECL_SelectValue(sCB_Attribute, "T");
  } else {
    ECL_DeselectAttribute(sCB_Attribute);
  }
}

// #############################################################################################
// O_DOKU_D56_G150	Dokumentation in Einzelsprache, Russisch	D56	x	CB_O_DOKU_D56_G150
function Bestimme_D56(oData) {
  // O_DOKU_D56_G150
  var sDTKAttribute = "O_DOKU_D56_G150";
  var sCB_Attribute = "CB_" + sDTKAttribute;

  var sKAG = "D56";

  var aKAG = oData.oParsingData.MLFB.KAG || [];

  if (aKAG.indexOf(sKAG) >= 0) {
    ECL_EnableAttribute(sCB_Attribute);
    ECL_SelectValue(sCB_Attribute, "T");
  } else {
    ECL_DeselectAttribute(sCB_Attribute);
  }
}

// #############################################################################################
// O_DOKU_D72_G150	Dokumentation in Einzelsprache, Italienisch	D72	x	CB_O_DOKU_D72_G150
function Bestimme_D72(oData) {
  // O_DOKU_D72_G150
  var sDTKAttribute = "O_DOKU_D72_G150";
  var sCB_Attribute = "CB_" + sDTKAttribute;

  var sKAG = "D72";

  var aKAG = oData.oParsingData.MLFB.KAG || [];

  if (aKAG.indexOf(sKAG) >= 0) {
    ECL_EnableAttribute(sCB_Attribute);
    ECL_SelectValue(sCB_Attribute, "T");
  } else {
    ECL_DeselectAttribute(sCB_Attribute);
  }
}

// #############################################################################################
// O_DOKU_D76_G150	Dokumentation in Einzelsprache, Englisch	D76	x	CB_O_DOKU_D76_G150
function Bestimme_D76(oData) {
  // O_DOKU_D76_G150
  var sDTKAttribute = "O_DOKU_D76_G150";
  var sCB_Attribute = "CB_" + sDTKAttribute;

  var sKAG = "D76";

  var aKAG = oData.oParsingData.MLFB.KAG || [];

  if (aKAG.indexOf(sKAG) >= 0) {
    ECL_EnableAttribute(sCB_Attribute);
    ECL_SelectValue(sCB_Attribute, "T");
  } else {
    ECL_DeselectAttribute(sCB_Attribute);
  }
}

// #############################################################################################
// O_DOKU_D77_G150	Dokumentation in Einzelsprache, Französisch	D77	x	CB_O_DOKU_D77_G150
function Bestimme_D77(oData) {
  // O_DOKU_D77_G150
  var sDTKAttribute = "O_DOKU_D77_G150";
  var sCB_Attribute = "CB_" + sDTKAttribute;

  var sKAG = "D77";

  var aKAG = oData.oParsingData.MLFB.KAG || [];

  if (aKAG.indexOf(sKAG) >= 0) {
    ECL_EnableAttribute(sCB_Attribute);
    ECL_SelectValue(sCB_Attribute, "T");
  } else {
    ECL_DeselectAttribute(sCB_Attribute);
  }
}

// #############################################################################################
// O_DOKU_D78_G150	Dokumentation in Einzelsprache, Spanisch	D78	x	CB_O_DOKU_D78_G150
function Bestimme_D78(oData) {
  // O_DOKU_D78_G150
  var sDTKAttribute = "O_DOKU_D78_G150";
  var sCB_Attribute = "CB_" + sDTKAttribute;

  var sKAG = "D78";

  var aKAG = oData.oParsingData.MLFB.KAG || [];

  if (aKAG.indexOf(sKAG) >= 0) {
    ECL_EnableAttribute(sCB_Attribute);
    ECL_SelectValue(sCB_Attribute, "T");
  } else {
    ECL_DeselectAttribute(sCB_Attribute);
  }
}

// #############################################################################################
// O_DOKU_D84_G150	Dokumentation in Einzelsprache, Chinesisch	D84	x	CB_O_DOKU_D84_G150
function Bestimme_D84(oData) {
  // O_DOKU_D84_G150
  var sDTKAttribute = "O_DOKU_D84_G150";
  var sCB_Attribute = "CB_" + sDTKAttribute;

  var sKAG = "D84";

  var aKAG = oData.oParsingData.MLFB.KAG || [];

  if (aKAG.indexOf(sKAG) >= 0) {
    ECL_EnableAttribute(sCB_Attribute);
    ECL_SelectValue(sCB_Attribute, "T");
  } else {
    ECL_DeselectAttribute(sCB_Attribute);
  }
}

// #############################################################################################
// O_FUNCTION_TEST_G150     Function test      NON, F03, F71, F72, F74, F75
function setFunctionTest(oData) {
  // O_FUNCTION_TEST_G150
  var sDTKAttribute = "O_FUNCTION_TEST_G150";

  // KAGs  NON, F03, F71, F72, F74, F75
  var aKAG = oData.oParsingData.MLFB.KAG || [];

  var sKAG = getKAGforAttribute(sDTKAttribute, aKAG);

  if (sKAG != "NON") {
    ECL_ActivateValue(sDTKAttribute, sKAG);
    ECL_SelectValue(sDTKAttribute, sKAG);
  } else {
    ECL_ActivateValue(sDTKAttribute, "NON");
    ECL_SelectValue(sDTKAttribute, "NON");
  }
}

// #############################################################################################
// O_INSULATION_TEST_G150	    Insulation test                               NON, F77, F76
function setInsulationTest(oData) {
  // O_INSULATION_TEST_G150
  var sDTKAttribute = "O_INSULATION_TEST_G150";

  // KAGs  NON, F77, F76
  var aKAG = oData.oParsingData.MLFB.KAG || [];

  var sKAG = getKAGforAttribute(sDTKAttribute, aKAG);

  if (sKAG != "NON") {
    ECL_ActivateValue(sDTKAttribute, sKAG);
    ECL_SelectValue(sDTKAttribute, sKAG);
  } else {
    ECL_ActivateValue(sDTKAttribute, "NON");
    ECL_SelectValue(sDTKAttribute, "NON");
  }
}

// #############################################################################################
// O_ABNAHME_F97_G150	        Kundenspezifische Abnahme   F97, NON    x	CB_O_ABNAHME_F97_G150
function Bestimme_F97(oData) {
  // O_ABNAHME_F97_G150
  var sDTKAttribute = "O_ABNAHME_F97_G150";
  var sCB_Attribute = "CB_" + sDTKAttribute;

  var sKAG = "F97";

  var aKAG = oData.oParsingData.MLFB.KAG || [];

  if (aKAG.indexOf(sKAG) >= 0) {
    ECL_EnableAttribute(sCB_Attribute);
    ECL_SelectValue(sCB_Attribute, "T");
  } else {
    ECL_DeselectAttribute(sCB_Attribute);
  }
}
// #############################################################################################
