﻿//@legacy
//#mode(full-ecma)

// ---------------------------------------------------------
// Script for configuration object CFG_SIEMENS_G150
// 	Date: 2023-06-20
// 	User: Administrator
// ---------------------------------------------------------

//@import "CFG_G150_VT.js"

/**
  Abbildung der Produktlogik aus Variantentabellen
*/
function ExecProductLogicG150(strchangedAttribute) {
  var strError = "";
  var sStatus = "";

  var sMLFB = ECL_GetValue("ECSI_MLFB");
  var strBaseTypeMLFB = ECL_GetValue("ECSI_MLFB_BASE_TYPE");
  var strSeriesID = ECL_GetValue("ECSI_CX_SeriesID");
  var strFrequencyConverterDefaultIpProtectionLevel = ECL_GetValue("ECSI_CX_FrequencyConverterDefaultIpProtectionLevel");
  /**
      MLFB01: 6SL3
    MLFB05: 3,7 VT_M00002==> nur 7 (IN_Bauart nur 00001)
    MLFB06: 1
    MLFB07: 0
    MLFB08: 1,2 
    MLFB09: G
    MLFB10: Spannungsbereich [E,F,H]
    MLFB11: Leistung 123 	MLFB11_G150 3 digits! (MLFB11...13)
    MLFB12: Leistung 2 
    MLFB13: Leistung 3 
    MLFB14: . Ausführung A (Standard) oder C (kompakt), wenn MLFB08 == 2 ==> nur A 		[A,C,E]		(IN_AUSFUEHRUNG: A,C VT76)
    MLFB15:	A 
    MLFB16:	3 
  	
    H_MLFB08_13_G150 VT104
  */
  /*
  var MLFB06_G150 = sMLFB.charAt(5);		// 
  var MLFB07_G150 = sMLFB.charAt(6);		// 
      // 
  var MLFB09_G150 = sMLFB.charAt(8);		// 
  var MLFB10_G150 = sMLFB.charAt(9);		// 
  */
  var MLFB08_G150 = sMLFB.charAt(7);
  var MLFB11_G150 = sMLFB.charAt(10) + sMLFB.charAt(11) + sMLFB.charAt(12); // 	Bemessungsleistung
  //var MLFB12_G150 = sMLFB.charAt(11);		// 	Bemessungsleistung
  //var MLFB13_G150 = sMLFB.charAt(12);		// Bemessungsleistung

  //var MLFB14_G150 = sMLFB.charAt(13);		//
  //var MLFB15_G150 = sMLFB.charAt(14);		//
  //var MLFB16_G150 = sMLFB.charAt(15);		// Verion fix

  var sECSI_CX_SafetyFunctions = ECL_GetValue("sECSI_CX_SafetyFunctions");

  var IN_AUSFUEHRUNG_G150 = ECL_GetValue("IN_AUSFUEHRUNG_G150");
  var HMK_FALLNUMMER_G150 = ECL_GetValue("HMK_FALLNUMMER_G150");
  var IN_BAUART_G150 = ECL_GetValue("IN_BAUART_G150");

  // ################################################################################################################
  // Fix Values from SIZER
  // ################################################################################################################
  /**
	
  */
  if (strBaseTypeMLFB.charAt(13) == ".") {
    ECL_EnableAttribute("IN_AUSFUEHRUNG_G150");
  } else {
    ECL_DisableAttribute("IN_AUSFUEHRUNG_G150");
  }

  // ################################################################################################################
  // O_SCHUTZART_G150	Schutzart
  // ################################################################################################################
  var sDTKAttribute = "O_SCHUTZART_G150";
  /**	
  n.n. VT_G150_M00006	Derating Faktor Schrankgeraet
  VT_G150_M00009	gueltige Schutzart
    IN_BAUART_G150	O_SCHUTZART_G150
  VT_G150_M00022	gueltige Optionen CleanPower/Zertifikate
    O_CLEAN_L01_G150	O_ZERTIFITKAT_G150	O_SCHUTZART_G150
  VT_G150_M00024	gueltige Optionen Anschluesse/Schutzart
    O_NETZANSCH_M13_G150	O_MOTORANSCHL_M78_G150	O_SCHUTZART_G150
  n.n. VT_G150_M00034	Zuweisung Schutzart Einbaugeraete	<== nur Einbaugerät
  VT_G150_M00102	Mapping Schutzart
    O_SCHUTZART_G150	PMD_ABJ176_001_000_G150
  n.n. VT_G150_M00123	Verriegelung Optionen - Einbaugeraet II
  */
  if (strSeriesID == "31155" || strFrequencyConverterDefaultIpProtectionLevel == "54") {
    // IP54 only
    ECL_DeactivateAllAttributeValues(sDTKAttribute);
    ECL_ActivateValue(sDTKAttribute, "M54");
    ECL_SelectValue(sDTKAttribute, "M54");
  } else {
    // VT_G150_M00009	gueltige Schutzart
    //	IN_BAUART_G150	O_SCHUTZART_G150
    var sTable = "VT_G150_M00009" + sDB_Suffix;
    var sWhere = "IN_BAUART_G150 = '" + IN_BAUART_G150 + "';";

    var sStatus = SetAttributeLogic1st(sTable, sDTKAttribute, sWhere);

    if (sStatus == "Error") {
      strError = "DICT1_ERR_G150___PL_O_SCHUTZART";
      return strError;
    }
    // for SeriesID 31150 IP only IP20...43
    ECL_DeactivateValue(sDTKAttribute, "M54");

    var O_SCHIFF_M66_G150 = "STD";
    if (ECL_ValueSelected("CB_O_SCHIFF_M66_G150", "T")) {
      O_SCHIFF_M66_G150 = "M66";
    }
    if (O_SCHIFF_M66_G150 !== "M66") {
      ECL_DeactivateValue(sDTKAttribute, "STM");
    }
    ExecSetStandardifValueEmpty(sDTKAttribute, "STD");
  }
  // --------------------------------------------------------------------------------------------

  // ################################################################################################################
  // Design A or C        MLFB14_G150
  // ################################################################################################################
  if (strBaseTypeMLFB.charAt(13) == ".") {
    ECL_EnableAttribute("IN_AUSFUEHRUNG_G150");
    var IN_AUSFUEHRUNG_G150 = ECL_GetValue("IN_AUSFUEHRUNG_G150");

    var sMLFB = replaceAt(sMLFB, 13, IN_AUSFUEHRUNG_G150);

    ECL_SetValue("ECSI_MLFB", sMLFB);
  } else {
    ECL_DisableAttribute("IN_AUSFUEHRUNG_G150");
  }

  // ################################################################################################################

  // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  // Optionen 1	Optionen 1	Optionen 1	Optionen 1	Optionen 1	Optionen 1	Optionen 1	Optionen 1	Optionen 1
  // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

  // ################################################################################################################
  // O_UMGEBUNG_L00_G150	(L00) Einsatz in der ersten Umgebung nach EN 61800-3 Kategorie C2
  // ################################################################################################################
  var sDTKAttribute = "O_UMGEBUNG_L00_G150";
  var sCB_Attribute = "CB_" + sDTKAttribute; //var sCB_Attribute = "CB_O_UMGEBUNG_L00_G150";
  /**
   * KAG: STD, L00
   * CB: CB_O_UMGEBUNG_L00_G150
   *
   * VT:
   * C VT_G150_M00018	gueltige Optionen Umgebung
   *		O_UMGEBUNG_L00_G150	O_ISO_WACH_L87_G150
   * B VT_G150_M00076	Gueltige Optionen Ausfuehrung I
   * 		IN_AUSFUEHRUNG_G150	O_UMGEBUNG_L00_G150	O_CLEAN_L01_G150	O_SCHUETZ_L13_G150	O_SCHALTER_L26_G150
   * n.n. VT_G150_M00087	Verriegelung Optionen - Einbaugeraet IV
   *
   * A VT_G150_M00110	Einschraenkungen_MLFB_L00_L01_L22_L23
   * 		HMK_FALLNUMMER_G150	MLFB11_G150	O_UMGEBUNG_L00_G150	O_CLEAN_L01_G150	O_DROSSEL_L22_G150	O_DROSSELUK_L23_G150
   *
   */
  // --------------------------------------------------------------------------------------------
  // A	VT_G150_M00110	Einschraenkungen_MLFB_L00_L01_L22_L23
  // 		HMK_FALLNUMMER_G150	MLFB11_G150	O_UMGEBUNG_L00_G150	O_CLEAN_L01_G150	O_DROSSEL_L22_G150	O_DROSSELUK_L23_G150
  var sWhereL01 = "";
  var O_CLEAN_L01_G150 = "STD";
  if (ECL_ValueSelected("CB_O_CLEAN_L01_G150", "T")) {
    O_CLEAN_L01_G150 = "L01";
    sWhereL01 = "O_CLEAN_L01_G150 = 'L01' AND ";
  }
  var O_DROSSEL_L22_G150 = "STD";
  if (ECL_ValueSelected("CB_O_DROSSEL_L22_G150", "T")) {
    O_DROSSEL_L22_G150 = "L22";
  }
  var sWhereL23 = "";
  var O_DROSSELUK_L23_G150 = "STD";
  if (ECL_ValueSelected("CB_O_DROSSELUK_L23_G150", "T")) {
    O_DROSSELUK_L23_G150 = "L23";
    sWhereL23 = " AND O_DROSSELUK_L23_G150 = 'L23'";
  }

  var sTable = "VT_G150_M00110" + sDB_Suffix;
  var sWhere =
    "HMK_FALLNUMMER_G150 = '" +
    HMK_FALLNUMMER_G150 +
    "' AND " +
    "MLFB11_G150 = '" +
    MLFB11_G150 +
    "' AND " +
    sWhereL01 +
    "O_DROSSEL_L22_G150 = '" +
    O_DROSSEL_L22_G150 +
    "'" +
    sWhereL23 +
    ";";

  var sStatus = SetAttributeLogic_Checkbox(sTable, sDTKAttribute, sCB_Attribute, "L00", "STD", sWhere, false);

  if (sStatus == "Error") {
    strError = "DICT1_ERR_G150___PL_L00";
    return strError;
  }
  // --------------------------------------------------------------------------------------------
  // B	VT_G150_M00076	Gueltige Optionen Ausfuehrung I
  // 		IN_AUSFUEHRUNG_G150	O_UMGEBUNG_L00_G150	O_CLEAN_L01_G150	O_SCHUETZ_L13_G150	O_SCHALTER_L26_G150
  var O_CLEAN_L01_G150 = "STD";
  if (ECL_ValueSelected("CB_O_CLEAN_L01_G150", "T")) {
    O_CLEAN_L01_G150 = "L01";
  }
  var O_SCHUETZ_L13_G150 = "STD";
  if (ECL_ValueSelected("CB_O_SCHUETZ_L13_G150", "T")) {
    O_SCHUETZ_L13_G150 = "L13";
  }
  var O_SCHALTER_L26_G150 = "STD";
  if (ECL_ValueSelected("CB_O_SCHALTER_L26_G150", "T")) {
    O_SCHALTER_L26_G150 = "L26";
  }
  var sTable = "VT_G150_M00076" + sDB_Suffix;
  var sWhere =
    "IN_AUSFUEHRUNG_G150 = '" +
    IN_AUSFUEHRUNG_G150 +
    "' AND " +
    "O_CLEAN_L01_G150 = '" +
    O_CLEAN_L01_G150 +
    "' AND " +
    "O_SCHUETZ_L13_G150 = '" +
    O_SCHUETZ_L13_G150 +
    "' AND " +
    "O_SCHALTER_L26_G150 = '" +
    O_SCHALTER_L26_G150 +
    "';";

  var sStatus = SetAttributeLogic_Checkbox(sTable, sDTKAttribute, sCB_Attribute, "L00", "STD", sWhere, true);

  if (sStatus == "Error") {
    strError = "DICT1_ERR_G150___PL_L00";
    return strError;
  }
  // --------------------------------------------------------------------------------------------
  // C	VT_G150_M00018	gueltige Optionen Umgebung
  // 		O_UMGEBUNG_L00_G150	O_ISO_WACH_L87_G150
  var O_ISO_WACH_L87_G150 = "STD";
  if (ECL_ValueSelected("CB_O_ISO_WACH_L87_G150", "T")) {
    O_ISO_WACH_L87_G150 = "L87";
  }
  var sTable = "VT_G150_M00018" + sDB_Suffix;
  var sWhere = "O_ISO_WACH_L87_G150 = '" + O_ISO_WACH_L87_G150 + "';";

  var sStatus = SetAttributeLogic_Checkbox(sTable, sDTKAttribute, sCB_Attribute, "L00", "STD", sWhere, true);

  if (sStatus == "Error") {
    strError = "DICT1_ERR_G150___PL_L00";
    return strError;
  }
  var O_UMGEBUNG_L00_G150 = "STD";
  if (ECL_ValueSelected("CB_O_UMGEBUNG_L00_G150", "T")) {
    O_UMGEBUNG_L00_G150 = "L00";
  }
  // ################################################################################################################

  // ################################################################################################################
  // O_CLEAN_L01_G150	(L01) Clean Power Ausführung mit integriertem Line Harmonics Filter compact
  // ################################################################################################################
  var sDTKAttribute = "O_CLEAN_L01_G150";
  var sCB_Attribute = "CB_" + sDTKAttribute; //var sCB_Attribute = "CB_O_CLEAN_L01_G150";
  /**
   * KAG: STD, L01
   * CB: CB_O_CLEAN_L01_G150
   *
   * VT:
   * D VT_G150_M00022	gueltige Optionen CleanPower/Zertifikate
   * 		O_CLEAN_L01_G150	O_ZERTIFITKAT_G150	O_SCHUTZART_G150
   * A VT_G150_M00062	gueltige Optionen L01,L13,L26
   * 		HMK_FALLNUMMER_G150	MLFB11_G150	O_CLEAN_L01_G150	O_SCHUETZ_L13_G150	O_SCHALTER_L26_G150
   * B VT_G150_M00076	Gueltige Optionen Ausfuehrung I
   * 		IN_AUSFUEHRUNG_G150	O_UMGEBUNG_L00_G150	O_CLEAN_L01_G150	O_SCHUETZ_L13_G150	O_SCHALTER_L26_G150
   * n.n. VT_G150_M00087	Verriegelung Optionen - Einbaugeraet IV
   * E VT_G150_M00108	Einschraenkungen_L01_L76
   * 		O_CLEAN_L01_G150	O_SCHNELLANLAUF_L76_G150
   * C VT_G150_M00110	Einschraenkungen_MLFB_L00_L01_L22_L23
   * 		HMK_FALLNUMMER_G150	MLFB11_G150	O_UMGEBUNG_L00_G150	O_CLEAN_L01_G150	O_DROSSEL_L22_G150	O_DROSSELUK_L23_G150
   * F VT_G150_M00111	Einschraenkungen_M66_L01
   * 		O_CLEAN_L01_G150	O_SCHIFF_M66_G150
   */
  // --------------------------------------------------------------------------------------------
  // A VT_G150_M00062	gueltige Optionen L01,L13,L26
  // 		HMK_FALLNUMMER_G150	MLFB11_G150	O_CLEAN_L01_G150	O_SCHUETZ_L13_G150	O_SCHALTER_L26_G150
  var O_SCHUETZ_L13_G150 = "STD";
  if (ECL_ValueSelected("CB_O_SCHUETZ_L13_G150", "T")) {
    O_SCHUETZ_L13_G150 = "L13";
  }
  var O_SCHALTER_L26_G150 = "STD";
  if (ECL_ValueSelected("CB_O_SCHALTER_L26_G150", "T")) {
    O_SCHALTER_L26_G150 = "L26";
  }

  var sTable = "VT_G150_M00062" + sDB_Suffix;
  var sWhere =
    "HMK_FALLNUMMER_G150 = '" +
    HMK_FALLNUMMER_G150 +
    "' AND " +
    "MLFB11_G150 = '" +
    MLFB11_G150 +
    "' AND " +
    //"O_SCHUETZ_L13_G150 = '" + O_SCHUETZ_L13_G150 + "' AND " +
    "O_SCHALTER_L26_G150 = '" +
    O_SCHALTER_L26_G150 +
    "';";

  var sStatus = SetAttributeLogic_Checkbox(sTable, sDTKAttribute, sCB_Attribute, "L01", "STD", sWhere, false);

  if (sStatus == "Error") {
    strError = "DICT1_ERR_G150___PL_L01";
    return strError;
  }
  // --------------------------------------------------------------------------------------------
  // B VT_G150_M00076	Gueltige Optionen Ausfuehrung I
  // 		IN_AUSFUEHRUNG_G150	O_UMGEBUNG_L00_G150	O_CLEAN_L01_G150	O_SCHUETZ_L13_G150	O_SCHALTER_L26_G150

  var O_UMGEBUNG_L00_G150 = "STD";
  if (ECL_ValueSelected("CB_O_UMGEBUNG_L00_G150", "T")) {
    O_UMGEBUNG_L00_G150 = "L00";
  }
  var sTable = "VT_G150_M00076" + sDB_Suffix;
  var sWhere =
    "IN_AUSFUEHRUNG_G150 = '" +
    IN_AUSFUEHRUNG_G150 +
    "' AND " +
    "O_UMGEBUNG_L00_G150 = '" +
    O_UMGEBUNG_L00_G150 +
    "' AND " +
    "O_SCHUETZ_L13_G150 = '" +
    O_SCHUETZ_L13_G150 +
    "' AND " +
    "O_SCHALTER_L26_G150 = '" +
    O_SCHALTER_L26_G150 +
    "';";

  var sStatus = SetAttributeLogic_Checkbox(sTable, sDTKAttribute, sCB_Attribute, "L01", "STD", sWhere, true);

  if (sStatus == "Error") {
    strError = "DICT1_ERR_G150___PL_L01";
    return strError;
  }
  // --------------------------------------------------------------------------------------------
  // C VT_G150_M00110	Einschraenkungen_MLFB_L00_L01_L22_L23
  // 		HMK_FALLNUMMER_G150	MLFB11_G150	O_UMGEBUNG_L00_G150	O_CLEAN_L01_G150	O_DROSSEL_L22_G150	O_DROSSELUK_L23_G150
  var O_DROSSEL_L22_G150 = "STD";
  if (ECL_ValueSelected("CB_O_DROSSEL_L22_G150", "T")) {
    var O_DROSSEL_L22_G150 = "L22";
  }
  var O_DROSSELUK_L23_G150 = "STD";
  if (ECL_ValueSelected("CB_O_DROSSELUK_L23_G150", "T")) {
    var O_DROSSELUK_L23_G150 = "L23";
  }

  var sTable = "VT_G150_M00110" + sDB_Suffix;
  var sWhere =
    "HMK_FALLNUMMER_G150 = '" +
    HMK_FALLNUMMER_G150 +
    "' AND " +
    "MLFB11_G150 = '" +
    MLFB11_G150 +
    "' AND " +
    "O_UMGEBUNG_L00_G150 = '" +
    O_UMGEBUNG_L00_G150 +
    "' AND " +
    "O_DROSSEL_L22_G150 = '" +
    O_DROSSEL_L22_G150 +
    "' AND " +
    "O_DROSSELUK_L23_G150 = '" +
    O_DROSSELUK_L23_G150 +
    "';";

  var sStatus = SetAttributeLogic_Checkbox(sTable, sDTKAttribute, sCB_Attribute, "L01", "STD", sWhere, true);

  if (sStatus == "Error") {
    strError = "DICT1_ERR_G150___PL_L01";
    return strError;
  }
  // --------------------------------------------------------------------------------------------
  // D VT_G150_M00022	gueltige Optionen CleanPower/Zertifikate
  // 		O_CLEAN_L01_G150	O_ZERTIFITKAT_G150	O_SCHUTZART_G150
  var O_ZERTIFITKAT_G150 = ECL_GetValue("O_ZERTIFITKAT_G150");
  var O_SCHUTZART_G150 = ECL_GetValue("O_SCHUTZART_G150");

  var sTable = "VT_G150_M00022" + sDB_Suffix;
  var sWhere = "O_ZERTIFITKAT_G150 = '" + O_ZERTIFITKAT_G150 + "' AND " + "O_SCHUTZART_G150 = '" + O_SCHUTZART_G150 + "';";

  var sStatus = SetAttributeLogic_Checkbox(sTable, sDTKAttribute, sCB_Attribute, "L01", "STD", sWhere, true);

  if (sStatus == "Error") {
    strError = "DICT1_ERR_G150___PL_L01";
    return strError;
  }
  // --------------------------------------------------------------------------------------------
  // E VT_G150_M00108	Einschraenkungen_L01_L76
  // 		O_CLEAN_L01_G150	O_SCHNELLANLAUF_L76_G150
  var O_SCHNELLANLAUF_L76_G150 = "NON";
  if (ECL_ValueSelected("CB_O_SCHNELLANLAUF_L76_G150", "T")) {
    O_SCHNELLANLAUF_L76_G150 = "L76";
  }
  var sTable = "VT_G150_M00108" + sDB_Suffix;
  var sWhere = "O_SCHNELLANLAUF_L76_G150 = '" + O_SCHNELLANLAUF_L76_G150 + "';";

  var sStatus = SetAttributeLogic_Checkbox(sTable, sDTKAttribute, sCB_Attribute, "L01", "STD", sWhere, true);

  if (sStatus == "Error") {
    strError = "DICT1_ERR_G150___PL_L01";
    return strError;
  }
  // --------------------------------------------------------------------------------------------
  // F VT_G150_M00111	Einschraenkungen_M66_L01
  // 		O_CLEAN_L01_G150	O_SCHIFF_M66_G150

  var O_SCHIFF_M66_G150 = "STD";
  if (ECL_ValueSelected("CB_O_SCHIFF_M66_G150", "T")) {
    O_SCHIFF_M66_G150 = "M66";
  }

  var sTable = "VT_G150_M00111" + sDB_Suffix;
  var sWhere = "O_SCHIFF_M66_G150 = '" + O_SCHIFF_M66_G150 + "';";

  var sStatus = SetAttributeLogic_Checkbox(sTable, sDTKAttribute, sCB_Attribute, "L01", "STD", sWhere, true);

  if (sStatus == "Error") {
    strError = "DICT1_ERR_G150___PL_L01";
    return strError;
  }
  // ################################################################################################################

  // ################################################################################################################
  // O_SCHNELLANLAUF_L76_G150	(L76) Schnellanlauf (bei Option L01)
  // ################################################################################################################
  var sDTKAttribute = "O_SCHNELLANLAUF_L76_G150";
  var sCB_Attribute = "CB_" + sDTKAttribute; //CB_O_SCHNELLANLAUF_L76_G150";
  /**
   * KAG: NON, L76
   * CB: CB_O_SCHNELLANLAUF_L76_G150
   *
   * VT:
   * VT_G150_M00108	Einschraenkungen_L01_L76
   * 		O_CLEAN_L01_G150	O_SCHNELLANLAUF_L76_G150
   */
  var O_CLEAN_L01_G150 = "STD";
  if (ECL_ValueSelected("CB_O_CLEAN_L01_G150", "T")) {
    O_CLEAN_L01_G150 = "L01";
  }

  var sTable = "VT_G150_M00108" + sDB_Suffix;
  var sWhere = "O_CLEAN_L01_G150 = '" + O_CLEAN_L01_G150 + "';";

  var sStatus = SetAttributeLogic_Checkbox(sTable, sDTKAttribute, sCB_Attribute, "L76", "NON", sWhere, false);

  if (sStatus == "Error") {
    strError = "DICT1_ERR_G150___PL_L76";
    return strError;
  }
  // ################################################################################################################

  // ################################################################################################################
  // O_SCHUETZ_L13_G150		Hauptschütz (für Ströme <= 800 A bei Einfachschaltung)
  // ################################################################################################################
  var sDTKAttribute = "O_SCHUETZ_L13_G150";
  var sCB_Attribute = "CB_" + sDTKAttribute; //CB_O_SCHUETZ_L13_G150";
  /**
   * KAG: STD, L13
   * CB: CB_O_SCHUETZ_L13_G150
   * 
   * VT:
   *  A	VT_G150_M00062	gueltige Optionen L01,L13,L26
   * 		HMK_FALLNUMMER_G150		MLFB11_G150		O_CLEAN_L01_G150	O_SCHUETZ_L13_G150		O_SCHALTER_L26_G150
    B 	VT_G150_M00074	gueltige Optionen L13,26,57,59,60+Strom
      HMK_FALLNUMMER_G150		MLFB11_G150		O_MOTORSCHUTZ_G150	O_SCHUETZ_L13_G150	O_SCHALTER_L26_G150
    C	VT_G150_M00076	gueltige Optionen Ausfuehrung I
      IN_AUSFUEHRUNG_G150		O_UMGEBUNG_L00_G150		O_CLEAN_L01_G150	O_SCHUETZ_L13_G150	O_SCHALTER_L26_G150
    n.n. VT_G150_M00087	Verriegelung Optionen - Einbaugeraet IV
      O_UMGEBUNG_L00_G150		O_CLEAN_L01_G150	O_SCHUETZ_L13_G150	O_DROSSEL_L22_G150	O_DROSSELUK_L23_G150	O_SCHALTER_L26_G150
    D	VT_G150_M00107	Einschraenkungen_MLFB_B00_L13_L26
      HMK_FALLNUMMER_G150		MLFB11_G150		O_NAMUR_B00_G150	O_SCHUETZ_L13_G150	O_SCHALTER_L26_G150
  */

  /* A VT_G150_M00062	gueltige Optionen L01,L13,L26
        HMK_FALLNUMMER_G150		MLFB11_G150		O_CLEAN_L01_G150	O_SCHUETZ_L13_G150		O_SCHALTER_L26_G150
  */
  var O_CLEAN_L01_G150 = "STD";
  if (ECL_ValueSelected("CB_O_CLEAN_L01_G150", "T")) {
    O_CLEAN_L01_G150 = "L01";
  }
  var O_SCHALTER_L26_G150 = "STD";
  if (ECL_ValueSelected("CB_O_SCHALTER_L26_G150", "T")) {
    O_SCHALTER_L26_G150 = "L26";
  }

  var sTable = "VT_G150_M00062" + sDB_Suffix;
  var sWhere =
    "HMK_FALLNUMMER_G150 = '" +
    HMK_FALLNUMMER_G150 +
    "' AND " +
    "MLFB11_G150 = '" +
    MLFB11_G150 +
    "' AND " +
    "O_SCHALTER_L26_G150 = '" +
    O_SCHALTER_L26_G150 +
    "' AND " +
    "O_CLEAN_L01_G150 = '" +
    O_CLEAN_L01_G150 +
    "';";

  var sStatus = SetAttributeLogic_Checkbox(sTable, sDTKAttribute, sCB_Attribute, "L13", "STD", sWhere, false);

  if (sStatus == "Error") {
    strError = "DICT1_ERR_G150___PL_L13";
    return strError;
  }
  // --------------------------------------------------------------------------------------------
  // B VT_G150_M00074	gueltige Optionen L13,26,57,59,60+Strom
  //		HMK_FALLNUMMER_G150		MLFB11_G150		O_MOTORSCHUTZ_G150	O_SCHUETZ_L13_G150	O_SCHALTER_L26_G150
  var O_MOTORSCHUTZ_G150 = ECL_GetValue("O_MOTORSCHUTZ_G150");

  var sTable = "VT_G150_M00074" + sDB_Suffix;
  var sWhere =
    "HMK_FALLNUMMER_G150 = '" +
    HMK_FALLNUMMER_G150 +
    "' AND " +
    "MLFB11_G150 = '" +
    MLFB11_G150 +
    "' AND " +
    "O_SCHALTER_L26_G150 = '" +
    O_SCHALTER_L26_G150 +
    "' AND " +
    "O_MOTORSCHUTZ_G150 = '" +
    O_MOTORSCHUTZ_G150 +
    "';";

  var sStatus = SetAttributeLogic_Checkbox(sTable, sDTKAttribute, sCB_Attribute, "L13", "STD", sWhere, true);

  if (sStatus == "Error") {
    strError = "DICT1_ERR_G150___PL_L13";
    return strError;
  }
  // --------------------------------------------------------------------------------------------
  // C	VT_G150_M00076	gueltige Optionen Ausfuehrung I
  //		IN_AUSFUEHRUNG_G150		O_UMGEBUNG_L00_G150		O_CLEAN_L01_G150	O_SCHUETZ_L13_G150	O_SCHALTER_L26_G150
  var O_UMGEBUNG_L00_G150 = "STD";
  if (ECL_ValueSelected("CB_O_UMGEBUNG_L00_G150", "T")) {
    O_UMGEBUNG_L00_G150 = "L00";
  }
  var sTable = "VT_G150_M00076" + sDB_Suffix;
  var sWhere =
    "IN_AUSFUEHRUNG_G150 = '" +
    IN_AUSFUEHRUNG_G150 +
    "' AND " +
    "O_UMGEBUNG_L00_G150 = '" +
    O_UMGEBUNG_L00_G150 +
    "' AND " +
    "O_CLEAN_L01_G150 = '" +
    O_CLEAN_L01_G150 +
    "' AND " +
    "O_SCHALTER_L26_G150 = '" +
    O_SCHALTER_L26_G150 +
    "';";

  var sStatus = SetAttributeLogic_Checkbox(sTable, sDTKAttribute, sCB_Attribute, "L13", "STD", sWhere, true);

  if (sStatus == "Error") {
    strError = "DICT1_ERR_G150___PL_L13";
    return strError;
  }
  // --------------------------------------------------------------------------------------------
  // D	VT_G150_M00107	Einschraenkungen_MLFB_B00_L13_L26
  //		HMK_FALLNUMMER_G150		MLFB11_G150		O_NAMUR_B00_G150	O_SCHUETZ_L13_G150	O_SCHALTER_L26_G150
  var O_NAMUR_B00_G150 = "NON";
  if (ECL_ValueSelected("CB_O_NAMUR_B00_G150", "T")) {
    O_NAMUR_B00_G150 = "B00";
  }
  var sTable = "VT_G150_M00107" + sDB_Suffix;
  var sWhere =
    "HMK_FALLNUMMER_G150 = '" +
    HMK_FALLNUMMER_G150 +
    "' AND " +
    "MLFB11_G150 = '" +
    MLFB11_G150 +
    "' AND " +
    "O_SCHALTER_L26_G150 = '" +
    O_SCHALTER_L26_G150 +
    "' AND " +
    "O_NAMUR_B00_G150 = '" +
    O_NAMUR_B00_G150 +
    "';";

  var sStatus = SetAttributeLogic_Checkbox(sTable, sDTKAttribute, sCB_Attribute, "L13", "STD", sWhere, true);

  if (sStatus == "Error") {
    strError = "DICT1_ERR_G150___PL_L13";
    return strError;
  }
  // ################################################################################################################

  // ################################################################################################################
  // O_UEBERSPGSBGZ_L21_G150	Überspannungsbegrenzung
  // ################################################################################################################
  var sDTKAttribute = "O_UEBERSPGSBGZ_L21_G150";
  var sCB_Attribute = "CB_" + sDTKAttribute; //CB_O_UEBERSPGSBGZ_L21_G150";
  /**
   * KAG: STD, L21
   * CB: CB_O_UEBERSPGSBGZ_L21_G150
   *
   * VT:
   * 	VT_G150_M00122	Ausfuehrung_L21
   * 		IN_AUSFUEHRUNG_G150	O_UEBERSPGSBGZ_L21_G150
   */
  var sTable = "VT_G150_M00122" + sDB_Suffix;
  var sWhere = "IN_AUSFUEHRUNG_G150 = '" + IN_AUSFUEHRUNG_G150 + "';";

  var sStatus = SetAttributeLogic_Checkbox(sTable, sDTKAttribute, sCB_Attribute, "L21", "STD", sWhere, false);

  if (sStatus == "Error") {
    strError = "DICT1_ERR_G150___PL_L21";
    return strError;
  }
  // ################################################################################################################

  // ################################################################################################################
  // O_DROSSEL_L22_G150		Lieferumfang ohne Netzdrossel
  // ################################################################################################################
  var sDTKAttribute = "O_DROSSEL_L22_G150";
  var sCB_Attribute = "CB_" + sDTKAttribute; //CB_O_DROSSEL_L22_G150";
  /**
   * KAG: STD, L22
   * CB: CB_O_DROSSEL_L22_G150
   * 
   * VT:
   * 	n.n. VT_G150_M00087	Verriegelung Optionen - Einbaugeraet IV
    VT_G150_M00110	Einschraenkungen_MLFB_L00_L01_L22_L23
  */
  // C VT_G150_M00110	Einschraenkungen_MLFB_L00_L01_L22_L23
  // 		HMK_FALLNUMMER_G150	MLFB11_G150	O_UMGEBUNG_L00_G150	O_CLEAN_L01_G150	O_DROSSEL_L22_G150	O_DROSSELUK_L23_G150
  var O_UMGEBUNG_L00_G150 = "STD";
  if (ECL_ValueSelected("CB_O_UMGEBUNG_L00_G150", "T")) {
    O_UMGEBUNG_L00_G150 = "L00";
  }
  var O_CLEAN_L01_G150 = "STD";
  if (ECL_ValueSelected("CB_O_CLEAN_L01_G150", "T")) {
    O_CLEAN_L01_G150 = "L01";
  }
  var O_DROSSELUK_L23_G150 = "STD";
  if (ECL_ValueSelected("CB_O_DROSSELUK_L23_G150", "T")) {
    O_DROSSELUK_L23_G150 = "L23";
  }

  var sTable = "VT_G150_M00110" + sDB_Suffix;
  var sWhere =
    "HMK_FALLNUMMER_G150 = '" +
    HMK_FALLNUMMER_G150 +
    "' AND " +
    "MLFB11_G150 = '" +
    MLFB11_G150 +
    "' AND " +
    "O_UMGEBUNG_L00_G150 = '" +
    O_UMGEBUNG_L00_G150 +
    "' AND " +
    "O_CLEAN_L01_G150 = '" +
    O_CLEAN_L01_G150 +
    "' AND " +
    "O_DROSSELUK_L23_G150 = '" +
    O_DROSSELUK_L23_G150 +
    "';";

  var sStatus = SetAttributeLogic_Checkbox(sTable, sDTKAttribute, sCB_Attribute, "L22", "STD", sWhere, false);

  if (sStatus == "Error") {
    strError = "DICT1_ERR_G150___PL_L22";
    return strError;
  }
  // ################################################################################################################

  // ################################################################################################################
  // O_DROSSELUK_L23_G150	Netzdrossel uk=2%
  // ################################################################################################################
  var sDTKAttribute = "O_DROSSELUK_L23_G150";
  var sCB_Attribute = "CB_" + sDTKAttribute; //CB_O_DROSSELUK_L23_G150";
  /**
   * KAG: STD, L23
   * CB: CB_O_DROSSELUK_L23_G150
   * 
   * VT:
   * 	n.n. VT_G150_M00087	Verriegelung Optionen - Einbaugeraet IV
    VT_G150_M00110	Einschraenkungen_MLFB_L00_L01_L22_L23
      HMK_FALLNUMMER_G150	MLFB11_G150	O_UMGEBUNG_L00_G150	O_CLEAN_L01_G150	O_DROSSEL_L22_G150	O_DROSSELUK_L23_G150
  */
  var O_UMGEBUNG_L00_G150 = "STD";
  if (ECL_ValueSelected("CB_O_UMGEBUNG_L00_G150", "T")) {
    O_UMGEBUNG_L00_G150 = "L00";
  }
  var O_CLEAN_L01_G150 = "STD";
  if (ECL_ValueSelected("CB_O_CLEAN_L01_G150", "T")) {
    O_CLEAN_L01_G150 = "L01";
  }
  var O_DROSSEL_L22_G150 = "STD";
  if (ECL_ValueSelected("CB_O_DROSSEL_L22_G150", "T")) {
    O_DROSSEL_L22_G150 = "L22";
  }

  var sTable = "VT_G150_M00110" + sDB_Suffix;
  var sWhere =
    "HMK_FALLNUMMER_G150 = '" +
    HMK_FALLNUMMER_G150 +
    "' AND " +
    "MLFB11_G150 = '" +
    MLFB11_G150 +
    "' AND " +
    "O_UMGEBUNG_L00_G150 = '" +
    O_UMGEBUNG_L00_G150 +
    "' AND " +
    "O_CLEAN_L01_G150 = '" +
    O_CLEAN_L01_G150 +
    "' AND " +
    "O_DROSSEL_L22_G150 = '" +
    O_DROSSEL_L22_G150 +
    "';";

  var sStatus = SetAttributeLogic_Checkbox(sTable, sDTKAttribute, sCB_Attribute, "L23", "STD", sWhere, false);

  if (sStatus == "Error") {
    strError = "DICT1_ERR_G150___PL_L23";
    return strError;
  }

  // ################################################################################################################

  // ################################################################################################################
  // O_SCHALTER_L26_G150		Hauptschalter inklusive Sicherungen bzw. Leistungsschalter
  // ################################################################################################################
  var sDTKAttribute = "O_SCHALTER_L26_G150";
  var sCB_Attribute = "CB_" + sDTKAttribute;
  /**
   * KAG: STD, L26
   * CB: CB_O_SCHALTER_L26_G150
   * 
   * VT:
   * 	VT_G150_M00062	gueltige Optionen L01,L13,L26
    VT_G150_M00074	gueltige Optionen L13,26,57,59,60+Strom
    VT_G150_M00076	Gueltige Optionen Ausfuehrung I
    n.n. VT_G150_M00087	Verriegelung Optionen - Einbaugeraet IV
    VT_G150_M00107	Einschraenkungen_MLFB_B00_L13_L26
  */

  // A VT_G150_M00062	gueltige Optionen L01,L13,L26
  // 		HMK_FALLNUMMER_G150		MLFB11_G150		O_CLEAN_L01_G150	O_SCHUETZ_L13_G150		O_SCHALTER_L26_G150
  var O_CLEAN_L01_G150 = "STD";
  if (ECL_ValueSelected("CB_O_CLEAN_L01_G150", "T")) {
    O_CLEAN_L01_G150 = "L01";
  }
  var O_SCHUETZ_L13_G150 = "STD";
  if (ECL_ValueSelected("CB_O_SCHUETZ_L13_G150", "T")) {
    O_SCHUETZ_L13_G150 = "L13";
  }

  var sTable = "VT_G150_M00062" + sDB_Suffix;
  var sWhere =
    "HMK_FALLNUMMER_G150 = '" +
    HMK_FALLNUMMER_G150 +
    "' AND " +
    "MLFB11_G150 = '" +
    MLFB11_G150 +
    "' AND " +
    "O_SCHUETZ_L13_G150 = '" +
    O_SCHUETZ_L13_G150 +
    "' AND " +
    "O_CLEAN_L01_G150 = '" +
    O_CLEAN_L01_G150 +
    "';";

  var sStatus = SetAttributeLogic_Checkbox(sTable, sDTKAttribute, sCB_Attribute, "L26", "STD", sWhere, false);

  if (sStatus == "Error") {
    strError = "DICT1_ERR_G150___PL_L26";
    return strError;
  }
  // --------------------------------------------------------------------------------------------
  // B VT_G150_M00074	gueltige Optionen L13,26,57,59,60+Strom
  //		HMK_FALLNUMMER_G150		MLFB11_G150		O_MOTORSCHUTZ_G150	O_SCHUETZ_L13_G150	O_SCHALTER_L26_G150
  var O_MOTORSCHUTZ_G150 = ECL_GetValue("O_MOTORSCHUTZ_G150");

  var sTable = "VT_G150_M00074" + sDB_Suffix;
  var sWhere =
    "HMK_FALLNUMMER_G150 = '" +
    HMK_FALLNUMMER_G150 +
    "' AND " +
    "MLFB11_G150 = '" +
    MLFB11_G150 +
    "' AND " +
    "O_SCHUETZ_L13_G150 = '" +
    O_SCHUETZ_L13_G150 +
    "' AND " +
    "O_MOTORSCHUTZ_G150 = '" +
    O_MOTORSCHUTZ_G150 +
    "';";

  var sStatus = SetAttributeLogic_Checkbox(sTable, sDTKAttribute, sCB_Attribute, "L26", "STD", sWhere, true);

  if (sStatus == "Error") {
    strError = "DICT1_ERR_G150___PL_L26";
    return strError;
  }
  // --------------------------------------------------------------------------------------------
  // C	VT_G150_M00076	gueltige Optionen Ausfuehrung I
  //		IN_AUSFUEHRUNG_G150		O_UMGEBUNG_L00_G150		O_CLEAN_L01_G150	O_SCHUETZ_L13_G150	O_SCHALTER_L26_G150
  var O_UMGEBUNG_L00_G150 = "STD";
  if (ECL_ValueSelected("CB_O_UMGEBUNG_L00_G150", "T")) {
    O_UMGEBUNG_L00_G150 = "L00";
  }
  var sTable = "VT_G150_M00076" + sDB_Suffix;
  var sWhere =
    "IN_AUSFUEHRUNG_G150 = '" +
    IN_AUSFUEHRUNG_G150 +
    "' AND " +
    "O_UMGEBUNG_L00_G150 = '" +
    O_UMGEBUNG_L00_G150 +
    "' AND " +
    "O_CLEAN_L01_G150 = '" +
    O_CLEAN_L01_G150 +
    "' AND " +
    "O_SCHUETZ_L13_G150 = '" +
    O_SCHUETZ_L13_G150 +
    "';";

  var sStatus = SetAttributeLogic_Checkbox(sTable, sDTKAttribute, sCB_Attribute, "L26", "STD", sWhere, true);

  if (sStatus == "Error") {
    strError = "DICT1_ERR_G150___PL_L26";
    return strError;
  }
  // --------------------------------------------------------------------------------------------
  // D	VT_G150_M00107	Einschraenkungen_MLFB_B00_L13_L26
  //		HMK_FALLNUMMER_G150		MLFB11_G150		O_NAMUR_B00_G150	O_SCHUETZ_L13_G150	O_SCHALTER_L26_G150
  var O_NAMUR_B00_G150 = "NON";
  if (ECL_ValueSelected("CB_O_NAMUR_B00_G150", "T")) {
    O_NAMUR_B00_G150 = "B00";
  }
  var sTable = "VT_G150_M00107" + sDB_Suffix;
  var sWhere =
    "HMK_FALLNUMMER_G150 = '" +
    HMK_FALLNUMMER_G150 +
    "' AND " +
    "MLFB11_G150 = '" +
    MLFB11_G150 +
    "' AND " +
    "O_SCHUETZ_L13_G150 = '" +
    O_SCHUETZ_L13_G150 +
    "' AND " +
    "O_NAMUR_B00_G150 = '" +
    O_NAMUR_B00_G150 +
    "';";

  var sStatus = SetAttributeLogic_Checkbox(sTable, sDTKAttribute, sCB_Attribute, "L26", "STD", sWhere, true);

  if (sStatus == "Error") {
    strError = "DICT1_ERR_G150___PL_L26";
    return strError;
  }
  // ################################################################################################################

  // ################################################################################################################
  // O_OUTPUT_G150			Ausgangsseitige Optionen		STD, L07, L08, L10, L15, M75
  // ################################################################################################################
  var sDTKAttribute = "O_OUTPUT_G150";

  /**
   * KAG: STD, L07, L08, L10, L15, M75
   * 
   * VT:
   * 	C VT_G150_M00027	gueltige Optionen Anschluss/Ausgang
   * 		O_MOTORANSCHL_M78_G150	O_OUTPUT_G150
    B VT_G150_M00077	Gueltige Optionen Ausfuehrung II
      IN_AUSFUEHRUNG_G150		O_OUTPUT_G150	O_NETZANSCH_M13_G150	O_MOTORANSCHL_M78_G150	
    n.n. VT_G150_M00088	Verriegelung Optionen - Einbaugeraet V
    A VT_G150_M00109	Einschraenkungen_MLFB_L07_L08_L10_L15
      HMK_FALLNUMMER_G150		MLFB11_G150		O_OUTPUT_G150
  */
  // --------------------------------------------------------------------------------------------
  // A VT_G150_M00109	Einschraenkungen_MLFB_L07_L08_L10_L15
  //		HMK_FALLNUMMER_G150		MLFB11_G150		O_OUTPUT_G150

  var sTable = "VT_G150_M00109" + sDB_Suffix;
  var sWhere = "HMK_FALLNUMMER_G150 = '" + HMK_FALLNUMMER_G150 + "' AND " + "MLFB11_G150 = '" + MLFB11_G150 + "';";

  var sStatus = SetAttributeLogic1st(sTable, sDTKAttribute, sWhere);

  if (sStatus == "Error") {
    strError = "DICT1_ERR_G150___PL_O_OUTPUT";
    return strError;
  }
  // --------------------------------------------------------------------------------------------
  // B VT_G150_M00077	Gueltige Optionen Ausfuehrung II
  //		IN_AUSFUEHRUNG_G150		O_OUTPUT_G150	O_NETZANSCH_M13_G150	O_MOTORANSCHL_M78_G150

  var O_NETZANSCH_M13_G150 = "STD";
  if (ECL_ValueSelected("CB_O_NETZANSCH_M13_G150", "T")) {
    O_NETZANSCH_M13_G150 = "M13";
  }
  var O_MOTORANSCHL_M78_G150 = "STD";
  if (ECL_ValueSelected("CB_O_MOTORANSCHL_M78_G150", "T")) {
    O_MOTORANSCHL_M78_G150 = "M78";
  }
  var sTable = "VT_G150_M00077" + sDB_Suffix;
  var sWhere =
    "IN_AUSFUEHRUNG_G150 = '" +
    IN_AUSFUEHRUNG_G150 +
    "' AND " +
    "O_NETZANSCH_M13_G150 = '" +
    O_NETZANSCH_M13_G150 +
    "' AND " +
    "O_MOTORANSCHL_M78_G150 = '" +
    O_MOTORANSCHL_M78_G150 +
    "';";

  var sStatus = SetAttributeLogic2nd(sTable, sDTKAttribute, sWhere);

  if (sStatus == "Error") {
    strError = "DICT1_ERR_G150___PL_O_OUTPUT";
    return strError;
  }
  // --------------------------------------------------------------------------------------------
  // C VT_G150_M00027	gueltige Optionen Anschluss/Ausgang
  // 		O_MOTORANSCHL_M78_G150	O_OUTPUT_G150
  var sTable = "VT_G150_M00027" + sDB_Suffix;
  var sWhere = "O_MOTORANSCHL_M78_G150 = '" + O_MOTORANSCHL_M78_G150 + "';";

  var sStatus = SetAttributeLogic2nd(sTable, sDTKAttribute, sWhere);

  if (sStatus == "Error") {
    strError = "DICT1_ERR_G150___PL_O_OUTPUT";
    return strError;
  }
  // ################################################################################################################

  // ################################################################################################################
  // O_SCHIRM_M70_G150		EMV-Schirmschiene				STD, EMV, M70 (EMV enthalten in L00)
  // ################################################################################################################
  var sDTKAttribute = "O_SCHIRM_M70_G150";
  /**
   * KAG: STD, EMV, M70 (EMV enthalten in L00)
   *
   * VT:
   * n.n. VT_G150_M00088	Verriegelung Optionen - Einbaugeraet V
   * wenn L00, dann fix EMV
   */
  if (ECL_ValueSelected("CB_O_UMGEBUNG_L00_G150", "T")) {
    ECL_DeactivateAllAttributeValues(sDTKAttribute);
    ECL_ActivateValue(sDTKAttribute, "EMV");
    ECL_SelectValue(sDTKAttribute, "EMV");
  } else {
    ECL_ActivateAllAttributeValues(sDTKAttribute);
    ECL_DeactivateValue(sDTKAttribute, "EMV");
    ExecSetStandardifValueEmpty(sDTKAttribute, "STD");
  }

  // ################################################################################################################

  // ################################################################################################################
  // O_MOTORSCHUTZ_G150		Not-Aus / Not-Halt				STD, L57, L59, L60
  // ################################################################################################################
  var sDTKAttribute = "O_MOTORSCHUTZ_G150";

  /**
   * KAG: STD, L57, L59, L60
   * 
   * VT:
   *  A	VT_G150_M00074	gueltige Optionen L13,26,57,59,60+Strom
   * 			HMK_FALLNUMMER_G150	MLFB11_G150	O_MOTORSCHUTZ_G150	O_SCHUETZ_L13_G150	O_SCHALTER_L26_G150
    B 	VT_G150_M00078	Gueltige Optionen Ausfuehrung III
        IN_AUSFUEHRUNG_G150	O_MOTORSCHUTZ_G150	O_NOT_AUS_TASTER_G150
    n.n. VT_G150_M00088	Verriegelung Optionen - Einbaugeraet V
  */
  // --------------------------------------------------------------------------------------------
  // A VT_G150_M00074	gueltige Optionen L13,26,57,59,60+Strom
  //		HMK_FALLNUMMER_G150	MLFB11_G150	O_MOTORSCHUTZ_G150	O_SCHUETZ_L13_G150	O_SCHALTER_L26_G150
  var O_SCHUETZ_L13_G150 = "STD";
  if (ECL_ValueSelected("CB_O_SCHUETZ_L13_G150", "T")) {
    O_SCHUETZ_L13_G150 = "L13";
  }
  var O_SCHALTER_L26_G150 = "STD";
  if (ECL_ValueSelected("CB_O_SCHALTER_L26_G150", "T")) {
    O_SCHALTER_L26_G150 = "L26";
  }
  var sTable = "VT_G150_M00074" + sDB_Suffix;
  var sWhere =
    "HMK_FALLNUMMER_G150 = '" +
    HMK_FALLNUMMER_G150 +
    "' AND " +
    "MLFB11_G150 = '" +
    MLFB11_G150 +
    "' AND " +
    "O_SCHUETZ_L13_G150 = '" +
    O_SCHUETZ_L13_G150 +
    "' AND " +
    "O_SCHALTER_L26_G150 = '" +
    O_SCHALTER_L26_G150 +
    "';";

  var sStatus = SetAttributeLogic1st(sTable, sDTKAttribute, sWhere);

  if (sStatus == "Error") {
    strError = "DICT1_ERR_G150___PL_O_MOTORSCHUTZ";
    return strError;
  }
  // --------------------------------------------------------------------------------------------
  // B VT_G150_M00078	Gueltige Optionen Ausfuehrung III
  //		IN_AUSFUEHRUNG_G150	O_MOTORSCHUTZ_G150	O_NOT_AUS_TASTER_G150

  var O_NOT_AUS_TASTER_G150 = "NON";
  if (ECL_ValueSelected("CB_O_NOT_AUS_TASTER_G150", "T")) {
    O_NOT_AUS_TASTER_G150 = "L45";
  }

  var sTable = "VT_G150_M00078" + sDB_Suffix;
  var sWhere = "IN_AUSFUEHRUNG_G150 = '" + IN_AUSFUEHRUNG_G150 + "' AND " + "O_NOT_AUS_TASTER_G150 = '" + O_NOT_AUS_TASTER_G150 + "';";

  var sStatus = SetAttributeLogic2nd(sTable, sDTKAttribute, sWhere);

  if (sStatus == "Error") {
    strError = "DICT1_ERR_G150___PL_O_MOTORSCHUTZ";
    return strError;
  }
  // ################################################################################################################

  // ################################################################################################################
  // O_NOT_AUS_TASTER_G150	NOT-AUS-Taster, eingebaut in der Schranktür	NON, L45
  // ################################################################################################################
  var sDTKAttribute = "O_NOT_AUS_TASTER_G150";
  var sCB_Attribute = "CB_" + sDTKAttribute;
  /**
   * KAG: NON, L45
   * CB: CB_O_NOT_AUS_TASTER_G150
   *
   * VT:
   * 	VT_G150_M00078	Gueltige Optionen Ausfuehrung III
   * 		IN_AUSFUEHRUNG_G150	O_MOTORSCHUTZ_G150	O_NOT_AUS_TASTER_G150
   */
  var O_MOTORSCHUTZ_G150 = ECL_GetValue("O_MOTORSCHUTZ_G150");

  var sTable = "VT_G150_M00078" + sDB_Suffix;
  var sWhere = "IN_AUSFUEHRUNG_G150 = '" + IN_AUSFUEHRUNG_G150 + "' AND " + "O_MOTORSCHUTZ_G150 = '" + O_MOTORSCHUTZ_G150 + "';";

  var sStatus = SetAttributeLogic_Checkbox(sTable, sDTKAttribute, sCB_Attribute, "L45", "NON", sWhere, false);

  if (sStatus == "Error") {
    strError = "DICT1_ERR_G150___PL_O_NOT_AUS_TASTER";
    return strError;
  }

  // ################################################################################################################

  // ################################################################################################################
  // O_THERMISTOR_L83_G150	Thermistor-Motorschutzgerät (Warnung)		NON, L83
  // ################################################################################################################
  var sDTKAttribute = "O_THERMISTOR_L83_G150";
  var sCB_Attribute = "CB_" + sDTKAttribute;
  /**
   * KAG: NON, L83
   * CB: CB_O_THERMISTOR_L83_G150
   * 
   * VT:
   * 	n.n. VT_G150_M00075	Verriegelung Optionen - Einbaugeraet V
    VT_G150_M00079	Gueltige Optionen Ausfuehrung IV
      IN_AUSFUEHRUNG_G150		O_THERMISTOR_L83_G150	O_THERMISTOR_L84_G150	O_PT100_L86_G150	O_ISO_WACH_L87_G150
  */
  var O_THERMISTOR_L84_G150 = "NON";
  if (ECL_ValueSelected("CB_O_THERMISTOR_L84_G150", "T")) {
    O_THERMISTOR_L84_G150 = "L84";
  }
  var O_PT100_L86_G150 = "STD";
  if (ECL_ValueSelected("CB_O_PT100_L86_G150", "T")) {
    O_PT100_L86_G150 = "L86";
  }
  var O_ISO_WACH_L87_G150 = "STD";
  if (ECL_ValueSelected("CB_O_ISO_WACH_L87_G150", "T")) {
    O_ISO_WACH_L87_G150 = "L87";
  }

  var sTable = "VT_G150_M00079" + sDB_Suffix;
  var sWhere =
    "IN_AUSFUEHRUNG_G150 = '" +
    IN_AUSFUEHRUNG_G150 +
    "' AND " +
    "O_THERMISTOR_L84_G150 = '" +
    O_THERMISTOR_L84_G150 +
    "' AND " +
    "O_PT100_L86_G150 = '" +
    O_PT100_L86_G150 +
    "' AND " +
    "O_ISO_WACH_L87_G150 = '" +
    O_ISO_WACH_L87_G150 +
    "';";

  var sStatus = SetAttributeLogic_Checkbox(sTable, sDTKAttribute, sCB_Attribute, "L83", "NON", sWhere, false);

  if (sStatus == "Error") {
    strError = "DICT1_ERR_G150___PL_L83";
    return strError;
  }
  // ################################################################################################################

  // ################################################################################################################
  // O_THERMISTOR_L84_G150	Thermistor-Motorschutzgerät (Abschaltung)	NON, L84
  // ################################################################################################################
  var sDTKAttribute = "O_THERMISTOR_L84_G150";
  var sCB_Attribute = "CB_" + sDTKAttribute;
  /**
   * KAG: NON, L84
   * CB: CB_O_THERMISTOR_L84_G150
   * 
   * VT:
   * 	n.n. VT_G150_M00075	Verriegelung Optionen - Einbaugeraet V
    VT_G150_M00079	Gueltige Optionen Ausfuehrung IV
      IN_AUSFUEHRUNG_G150		O_THERMISTOR_L83_G150	O_THERMISTOR_L84_G150	O_PT100_L86_G150	O_ISO_WACH_L87_G150
  */
  var O_THERMISTOR_L83_G150 = "NON";
  if (ECL_ValueSelected("CB_O_THERMISTOR_L83_G150", "T")) {
    O_THERMISTOR_L83_G150 = "L83";
  }

  var sTable = "VT_G150_M00079" + sDB_Suffix;
  var sWhere =
    "IN_AUSFUEHRUNG_G150 = '" +
    IN_AUSFUEHRUNG_G150 +
    "' AND " +
    "O_THERMISTOR_L83_G150 = '" +
    O_THERMISTOR_L83_G150 +
    "' AND " +
    "O_PT100_L86_G150 = '" +
    O_PT100_L86_G150 +
    "' AND " +
    "O_ISO_WACH_L87_G150 = '" +
    O_ISO_WACH_L87_G150 +
    "';";

  var sStatus = SetAttributeLogic_Checkbox(sTable, sDTKAttribute, sCB_Attribute, "L84", "NON", sWhere, false);

  if (sStatus == "Error") {
    strError = "DICT1_ERR_G150___PL_L84";
    return strError;
  }
  // ################################################################################################################

  // ################################################################################################################
  // O_TM150_G150			1x TM150 Temperatursensorauswerteeinheit	NON, G51
  // ################################################################################################################
  var sDTKAttribute = "O_TM150_G150";
  var sCB_Attribute = "CB_" + sDTKAttribute;
  /**
   * KAG: NON, G51
   * CB: CB_O_TM150_G150
   * 
   * VT:
   * 	VT_G150_M00082	gueltige Optionen L86/G51
   * 		O_PT100_L86_G150	O_TM150_G150
    n.n. VT_G150_M00083	Verriegelung Optionen - Einbaugeraet VII
  */
  var O_PT100_L86_G150 = "STD";
  if (ECL_ValueSelected("CB_O_PT100_L86_G150", "T")) {
    O_PT100_L86_G150 = "L86";
  }

  var sTable = "VT_G150_M00082" + sDB_Suffix;
  var sWhere = "O_PT100_L86_G150 = '" + O_PT100_L86_G150 + "';";

  var sStatus = SetAttributeLogic_Checkbox(sTable, sDTKAttribute, sCB_Attribute, "G51", "NON", sWhere, false);

  if (sStatus == "Error") {
    strError = "DICT1_ERR_G150___PL_G51";
    return strError;
  }
  // ################################################################################################################

  // ################################################################################################################
  // O_PT100_L86_G150		PT100-Auswertegerät				STD, L86
  // ################################################################################################################
  var sDTKAttribute = "O_PT100_L86_G150";
  var sCB_Attribute = "CB_" + sDTKAttribute;
  /**
   * KAG: STD, L86
   * CB: CB_O_PT100_L86_G150
   * 
   * VT:
   * 	VT_G150_M00079	Gueltige Optionen Ausfuehrung IV
   * 		IN_AUSFUEHRUNG_G150		O_THERMISTOR_L83_G150	O_THERMISTOR_L84_G150	O_PT100_L86_G150	O_ISO_WACH_L87_G150
    VT_G150_M00082	gueltige Optionen L86/G51
      O_PT100_L86_G150	O_TM150_G150
    n.n. VT_G150_M00123	Verriegelung Optionen - Einbaugeraet II
  */
  // --------------------------------------------------------------------------------------------
  var O_THERMISTOR_L83_G150 = "NON";
  if (ECL_ValueSelected("CB_O_THERMISTOR_L83_G150", "T")) {
    var O_THERMISTOR_L83_G150 = "L83";
  }
  var O_THERMISTOR_L84_G150 = "NON";
  if (ECL_ValueSelected("CB_O_THERMISTOR_L84_G150", "T")) {
    var O_THERMISTOR_L84_G150 = "L84";
  }
  var O_ISO_WACH_L87_G150 = "STD";
  if (ECL_ValueSelected("CB_O_ISO_WACH_L87_G150", "T")) {
    var O_ISO_WACH_L87_G150 = "L87";
  }

  var sTable = "VT_G150_M00079" + sDB_Suffix;
  var sWhere =
    "IN_AUSFUEHRUNG_G150 = '" +
    IN_AUSFUEHRUNG_G150 +
    "' AND " +
    "O_THERMISTOR_L83_G150 = '" +
    O_THERMISTOR_L83_G150 +
    "' AND " +
    "O_THERMISTOR_L84_G150 = '" +
    O_THERMISTOR_L84_G150 +
    "' AND " +
    "O_ISO_WACH_L87_G150 = '" +
    O_ISO_WACH_L87_G150 +
    "';";

  var sStatus = SetAttributeLogic_Checkbox(sTable, sDTKAttribute, sCB_Attribute, "L86", "STD", sWhere, false);

  if (sStatus == "Error") {
    strError = "DICT1_ERR_G150___PL_L86";
    return strError;
  }
  // --------------------------------------------------------------------------------------------
  var O_TM150_G150 = "NON";
  if (ECL_ValueSelected("CB_O_TM150_G150", "T")) {
    var O_TM150_G150 = "G51";
  }

  var sTable = "VT_G150_M00082" + sDB_Suffix;
  var sWhere = "O_TM150_G150 = '" + O_TM150_G150 + "';";

  var sStatus = SetAttributeLogic_Checkbox(sTable, sDTKAttribute, sCB_Attribute, "L86", "STD", sWhere, true);

  if (sStatus == "Error") {
    strError = "DICT1_ERR_G150___PL_L86";
    return strError;
  }
  // ################################################################################################################

  // ################################################################################################################
  // O_ISO_WACH_L87_G150		Isolationsüberwachung			STD, L87
  // ################################################################################################################
  var sDTKAttribute = "O_ISO_WACH_L87_G150";
  var sCB_Attribute = "CB_" + sDTKAttribute;
  /**
   * KAG: NON, L87
   * CB: CB_O_ISO_WACH_L87_G150
   * 
   * VT:
   * 	VT_G150_M00018	gueltige Optionen Umgebung
   * 		O_UMGEBUNG_L00_G150	O_ISO_WACH_L87_G150
    VT_G150_M00079	Gueltige Optionen Ausfuehrung IV
      IN_AUSFUEHRUNG_G150		O_THERMISTOR_L83_G150	O_THERMISTOR_L84_G150	O_PT100_L86_G150	O_ISO_WACH_L87_G150
    n.n. VT_G150_M00123	Verriegelung Optionen - Einbaugeraet II
  */
  // --------------------------------------------------------------------------------------------
  var O_THERMISTOR_L83_G150 = "NON";
  if (ECL_ValueSelected("CB_O_THERMISTOR_L83_G150", "T")) {
    var O_THERMISTOR_L83_G150 = "L83";
  }
  var O_THERMISTOR_L84_G150 = "NON";
  if (ECL_ValueSelected("CB_O_THERMISTOR_L84_G150", "T")) {
    var O_THERMISTOR_L84_G150 = "L84";
  }
  var O_PT100_L86_G150 = "STD";
  if (ECL_ValueSelected("CB_O_PT100_L86_G150", "T")) {
    var O_PT100_L86_G150 = "L86";
  }

  var sTable = "VT_G150_M00079" + sDB_Suffix;
  var sWhere =
    "IN_AUSFUEHRUNG_G150 = '" +
    IN_AUSFUEHRUNG_G150 +
    "' AND " +
    "O_THERMISTOR_L83_G150 = '" +
    O_THERMISTOR_L83_G150 +
    "' AND " +
    "O_THERMISTOR_L84_G150 = '" +
    O_THERMISTOR_L84_G150 +
    "' AND " +
    "O_PT100_L86_G150 = '" +
    O_PT100_L86_G150 +
    "';";

  var sStatus = SetAttributeLogic_Checkbox(sTable, sDTKAttribute, sCB_Attribute, "L87", "STD", sWhere, false);

  if (sStatus == "Error") {
    strError = "DICT1_ERR_G150___PL_L87";
    return strError;
  }
  // --------------------------------------------------------------------------------------------
  // VT_G150_M00018	gueltige Optionen Umgebung
  // 		O_UMGEBUNG_L00_G150	O_ISO_WACH_L87_G150
  var O_UMGEBUNG_L00_G150 = "STD";
  if (ECL_ValueSelected("CB_O_UMGEBUNG_L00_G150", "T")) {
    var O_UMGEBUNG_L00_G150 = "L00";
  }
  var sTable = "VT_G150_M00018" + sDB_Suffix;
  var sWhere = "O_UMGEBUNG_L00_G150 = '" + O_UMGEBUNG_L00_G150 + "';";

  var sStatus = SetAttributeLogic_Checkbox(sTable, sDTKAttribute, sCB_Attribute, "L87", "STD", sWhere, true);

  if (sStatus == "Error") {
    strError = "DICT1_ERR_G150___PL_L87";
    return strError;
  }
  // ################################################################################################################

  // ################################################################################################################
  // O_FUSSRAUM_G150			Sockel / Kabelrangierraum		M06, M07, STD
  // ################################################################################################################
  var sDTKAttribute = "O_FUSSRAUM_G150";

  /**
   * KAG: M06, M07, STD
   *
   * VT:
   * 	n.n. VT_G150_M00123	Verriegelung Optionen - Einbaugeraet II
   */
  // ################################################################################################################

  // ################################################################################################################
  // O_NETZANSCH_M13_G150	Netzanschluss von oben		M13, STD
  // ################################################################################################################
  var sDTKAttribute = "O_NETZANSCH_M13_G150";
  var sCB_Attribute = "CB_" + sDTKAttribute;
  /**
   * KAG: STD, M13
   * CB: CB_O_NETZANSCH_M13_G150
   * 
   * VT:
   * 	C VT_G150_M00024	gueltige Optionen Anschluesse/Schutzart
   * 		O_NETZANSCH_M13_G150	O_MOTORANSCHL_M78_G150	O_SCHUTZART_G150
    B VT_G150_M00077	Gueltige Optionen Ausfuehrung II
      IN_AUSFUEHRUNG_G150		O_OUTPUT_G150	O_NETZANSCH_M13_G150	O_MOTORANSCHL_M78_G150
    A VT_G150_M00115	Einschraenkungen_MLFB_M13
      HMK_FALLNUMMER_G150		MLFB11_G150		O_NETZANSCH_M13_G150
    n.n. VT_G150_M00123	Verriegelung Optionen - Einbaugeraet II
  */
  // --------------------------------------------------------------------------------------------
  // A VT_G150_M00115	Einschraenkungen_MLFB_M13
  //		HMK_FALLNUMMER_G150		MLFB11_G150		O_NETZANSCH_M13_G150
  var sTable = "VT_G150_M00115" + sDB_Suffix;
  var sWhere = "HMK_FALLNUMMER_G150 = '" + HMK_FALLNUMMER_G150 + "' AND " + "MLFB11_G150 = '" + MLFB11_G150 + "';";

  var sStatus = SetAttributeLogic_Checkbox(sTable, sDTKAttribute, sCB_Attribute, "M13", "STD", sWhere, false);

  if (sStatus == "Error") {
    strError = "DICT1_ERR_G150___PL_M13";
    return strError;
  }
  // --------------------------------------------------------------------------------------------
  // B VT_G150_M00077	Gueltige Optionen Ausfuehrung II
  //		IN_AUSFUEHRUNG_G150		O_OUTPUT_G150	O_NETZANSCH_M13_G150	O_MOTORANSCHL_M78_G150

  var O_OUTPUT_G150 = ECL_GetValue("O_OUTPUT_G150");

  var O_MOTORANSCHL_M78_G150 = "STD";
  if (ECL_ValueSelected("CB_O_MOTORANSCHL_M78_G150", "T")) {
    var O_MOTORANSCHL_M78_G150 = "M78";
  }
  var sTable = "VT_G150_M00077" + sDB_Suffix;
  var sWhere =
    "IN_AUSFUEHRUNG_G150 = '" +
    IN_AUSFUEHRUNG_G150 +
    "' AND " +
    "O_OUTPUT_G150 = '" +
    O_OUTPUT_G150 +
    "' AND " +
    "O_MOTORANSCHL_M78_G150 = '" +
    O_MOTORANSCHL_M78_G150 +
    "';";

  var sStatus = SetAttributeLogic_Checkbox(sTable, sDTKAttribute, sCB_Attribute, "M13", "STD", sWhere, true);

  if (sStatus == "Error") {
    strError = "DICT1_ERR_G150___PL_M13";
    return strError;
  }
  // --------------------------------------------------------------------------------------------
  // C VT_G150_M00024	gueltige Optionen Anschluesse/Schutzart
  // 		O_NETZANSCH_M13_G150	O_MOTORANSCHL_M78_G150	O_SCHUTZART_G150
  var O_SCHUTZART_G150 = ECL_GetValue("O_SCHUTZART_G150");

  var sTable = "VT_G150_M00024" + sDB_Suffix;
  var sWhere = "O_MOTORANSCHL_M78_G150 = '" + O_MOTORANSCHL_M78_G150 + "' AND " + "O_SCHUTZART_G150 = '" + O_SCHUTZART_G150 + "';";

  var sStatus = SetAttributeLogic_Checkbox(sTable, sDTKAttribute, sCB_Attribute, "M13", "STD", sWhere, true);

  if (sStatus == "Error") {
    strError = "DICT1_ERR_G150___PL_M13";
    return strError;
  }
  // ################################################################################################################

  // ################################################################################################################
  // O_KOMFORTGRIFF_M61_G150	(M61) Komfortgriff mit Verschlusseinsatz 3 mm Doppelbart		STD, M61
  // ################################################################################################################
  var sDTKAttribute = "O_KOMFORTGRIFF_M61_G150";
  var sCB_Attribute = "CB_" + sDTKAttribute;
  /** VT_G150_M00155	Option M61;M62;M63
   *    O_KOMFORTGRIFF_M61_G150  O_KOMFORTGRIFF_M62_G150 O_KOMFORTGRIFF_M63_G150 
   */
  var O_KOMFORTGRIFF_M62_G150 = "STD";
  if (ECL_ValueSelected("CB_O_KOMFORTGRIFF_M62_G150", "T")) {
    var O_KOMFORTGRIFF_M62_G150 = "M62";
  }
  var O_KOMFORTGRIFF_M63_G150 = "STD";
  if (ECL_ValueSelected("CB_O_KOMFORTGRIFF_M63_G150", "T")) {
    var O_KOMFORTGRIFF_M63_G150 = "M63";
  }
  var sTable = "VT_G150_M00155" + sDB_Suffix;
  var sWhere = "O_KOMFORTGRIFF_M62_G150 = '" + O_KOMFORTGRIFF_M62_G150 + "' AND " + "O_KOMFORTGRIFF_M63_G150 = '" + O_KOMFORTGRIFF_M63_G150 + "';";

  var sStatus = SetAttributeLogic_Checkbox(sTable, sDTKAttribute, sCB_Attribute, "M61", "STD", sWhere, false);

  if (sStatus == "Error") {
    strError = "DICT1_ERR_G150___PL_M61";
    return strError;
  }

  // ################################################################################################################

  // ################################################################################################################
  // O_KOMFORTGRIFF_M62_G150	(M62) Komfortgriff mit Verschlusseinsatz Druckknopf		STD, M62
  // ################################################################################################################
  var sDTKAttribute = "O_KOMFORTGRIFF_M62_G150";
  var sCB_Attribute = "CB_" + sDTKAttribute;
  /** VT_G150_M00155	Option M61;M62;M63
   *    O_KOMFORTGRIFF_M61_G150  O_KOMFORTGRIFF_M62_G150 O_KOMFORTGRIFF_M63_G150 
   */
  var O_KOMFORTGRIFF_M61_G150 = "STD";
  if (ECL_ValueSelected("CB_O_KOMFORTGRIFF_M61_G150", "T")) {
    var O_KOMFORTGRIFF_M61_G150 = "M61";
  }
  var O_KOMFORTGRIFF_M63_G150 = "STD";
  if (ECL_ValueSelected("CB_O_KOMFORTGRIFF_M63_G150", "T")) {
    var O_KOMFORTGRIFF_M63_G150 = "M63";
  }
  var sTable = "VT_G150_M00155" + sDB_Suffix;
  var sWhere = "O_KOMFORTGRIFF_M61_G150 = '" + O_KOMFORTGRIFF_M61_G150 + "' AND " + "O_KOMFORTGRIFF_M63_G150 = '" + O_KOMFORTGRIFF_M63_G150 + "';";

  var sStatus = SetAttributeLogic_Checkbox(sTable, sDTKAttribute, sCB_Attribute, "M62", "STD", sWhere, false);

  if (sStatus == "Error") {
    strError = "DICT1_ERR_G150___PL_M62";
    return strError;
  }

  // ################################################################################################################

  // ################################################################################################################
  // O_KOMFORTGRIFF_M63_G150	(M63) Komfortgriff für ein Vorhängeschloss mit Druckknopf als Verschlusseinsatz 	STD, M63
  // ################################################################################################################
  var sDTKAttribute = "O_KOMFORTGRIFF_M63_G150";
  var sCB_Attribute = "CB_" + sDTKAttribute;
  /** VT_G150_M00155	Option M61;M62;M63
    *    O_KOMFORTGRIFF_M61_G150  O_KOMFORTGRIFF_M62_G150 O_KOMFORTGRIFF_M63_G150 
    */
  var O_KOMFORTGRIFF_M61_G150 = "STD";
  if (ECL_ValueSelected("CB_O_KOMFORTGRIFF_M61_G150", "T")) {
    var O_KOMFORTGRIFF_M61_G150 = "M61";
  }
  var O_KOMFORTGRIFF_M62_G150 = "STD";
  if (ECL_ValueSelected("CB_O_KOMFORTGRIFF_M62_G150", "T")) {
    var O_KOMFORTGRIFF_M62_G150 = "M62";
  }

  var sTable = "VT_G150_M00155" + sDB_Suffix;
  var sWhere = "O_KOMFORTGRIFF_M61_G150 = '" + O_KOMFORTGRIFF_M61_G150 + "' AND " + "O_KOMFORTGRIFF_M62_G150 = '" + O_KOMFORTGRIFF_M62_G150 + "';";

  var sStatus = SetAttributeLogic_Checkbox(sTable, sDTKAttribute, sCB_Attribute, "M63", "STD", sWhere, false);

  if (sStatus == "Error") {
    strError = "DICT1_ERR_G150___PL_M63";
    return strError;
  }

  // ################################################################################################################

  // ################################################################################################################
  // O_MOTORANSCHL_M78_G150	Motoranschluss von oben		STD, M78
  // ################################################################################################################
  var sDTKAttribute = "O_MOTORANSCHL_M78_G150";
  var sCB_Attribute = "CB_" + sDTKAttribute;
  /**
   * KAG: STD, M78
   * CB: CB_O_MOTORANSCHL_M78_G150
   * 
   * VT:
  D 	VT_G150_M00024	gueltige Optionen Anschluesse/Schutzart
      O_NETZANSCH_M13_G150	O_MOTORANSCHL_M78_G150	O_SCHUTZART_G150
  C	VT_G150_M00027	gueltige Optionen Anschluss/Ausgang
      O_MOTORANSCHL_M78_G150	O_OUTPUT_G150
  B	VT_G150_M00077	Gueltige Optionen Ausfuehrung II
      IN_AUSFUEHRUNG_G150		O_OUTPUT_G150	O_NETZANSCH_M13_G150	O_MOTORANSCHL_M78_G150
  A	VT_G150_M00116	Einschraenkungen_MLFB_M78
      HMK_FALLNUMMER_G150		MLFB11_G150		O_MOTORANSCHL_M78_G150
    n.n. VT_G150_M00123	Verriegelung Optionen - Einbaugeraet II
  */
  // --------------------------------------------------------------------------------------------
  // A VT_G150_M00116	Einschraenkungen_MLFB_M78
  //		HMK_FALLNUMMER_G150		MLFB11_G150		O_MOTORANSCHL_M78_G150
  var sTable = "VT_G150_M00116" + sDB_Suffix;
  var sWhere = "HMK_FALLNUMMER_G150 = '" + HMK_FALLNUMMER_G150 + "' AND " + "MLFB11_G150 = '" + MLFB11_G150 + "';";

  var sStatus = SetAttributeLogic_Checkbox(sTable, sDTKAttribute, sCB_Attribute, "M78", "STD", sWhere, false);

  if (sStatus == "Error") {
    strError = "DICT1_ERR_G150___PL_M78";
    return strError;
  }
  // --------------------------------------------------------------------------------------------
  // B VT_G150_M00077	Gueltige Optionen Ausfuehrung II
  //		IN_AUSFUEHRUNG_G150		O_OUTPUT_G150	O_NETZANSCH_M13_G150	O_MOTORANSCHL_M78_G150

  var O_OUTPUT_G150 = ECL_GetValue("O_OUTPUT_G150");

  var O_NETZANSCH_M13_G150 = "STD";
  if (ECL_ValueSelected("CB_O_NETZANSCH_M13_G150", "T")) {
    var O_NETZANSCH_M13_G150 = "M13";
  }
  var sTable = "VT_G150_M00077" + sDB_Suffix;
  var sWhere =
    "IN_AUSFUEHRUNG_G150 = '" +
    IN_AUSFUEHRUNG_G150 +
    "' AND " +
    "O_OUTPUT_G150 = '" +
    O_OUTPUT_G150 +
    "' AND " +
    "O_NETZANSCH_M13_G150 = '" +
    O_NETZANSCH_M13_G150 +
    "';";

  var sStatus = SetAttributeLogic_Checkbox(sTable, sDTKAttribute, sCB_Attribute, "M78", "STD", sWhere, true);

  if (sStatus == "Error") {
    strError = "DICT1_ERR_G150___PL_M78";
    return strError;
  }
  // --------------------------------------------------------------------------------------------
  // C	VT_G150_M00027	gueltige Optionen Anschluss/Ausgang
  //		O_MOTORANSCHL_M78_G150	O_OUTPUT_G150

  var sTable = "VT_G150_M00027" + sDB_Suffix;
  var sWhere = "O_OUTPUT_G150 = '" + O_OUTPUT_G150 + "';";

  var sStatus = SetAttributeLogic_Checkbox(sTable, sDTKAttribute, sCB_Attribute, "M78", "STD", sWhere, true);

  if (sStatus == "Error") {
    strError = "DICT1_ERR_G150___PL_M78";
    return strError;
  }
  // --------------------------------------------------------------------------------------------
  // D VT_G150_M00024	gueltige Optionen Anschluesse/Schutzart
  // 		O_NETZANSCH_M13_G150	O_MOTORANSCHL_M78_G150	O_SCHUTZART_G150
  var O_SCHUTZART_G150 = ECL_GetValue("O_SCHUTZART_G150");

  var sTable = "VT_G150_M00024" + sDB_Suffix;
  var sWhere = "O_NETZANSCH_M13_G150 = '" + O_NETZANSCH_M13_G150 + "' AND " + "O_SCHUTZART_G150 = '" + O_SCHUTZART_G150 + "';";

  var sStatus = SetAttributeLogic_Checkbox(sTable, sDTKAttribute, sCB_Attribute, "M78", "STD", sWhere, true);

  if (sStatus == "Error") {
    strError = "DICT1_ERR_G150___PL_M78";
    return strError;
  }
  // ################################################################################################################

  // ################################################################################################################
  // O_KRAN_M90_G150	Krantransporthilfe		STD, M90
  // ################################################################################################################
  var sDTKAttribute = "O_KRAN_M90_G150";
  var sCB_Attribute = "CB_" + sDTKAttribute;
  /**
   * KAG: STD, M90
   * CB: CB_O_KRAN_M90_G150
   *
   * VT:
   * 	n.n. VT_G150_M00123	Verriegelung Optionen - Einbaugeraet II
   */
  // ################################################################################################################

  // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  // Optionen 2	Optionen 2	Optionen 2	Optionen 2	Optionen 2	Optionen 2	Optionen 2	Optionen 2	Optionen 2
  // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

  // ################################################################################################################
  // O_COMMUNICATION_G150	Communication Board				NON, G20, G33
  // ################################################################################################################
  var sDTKAttribute = "O_COMMUNICATION_G150";

  /**
   * KAG: NON, G20, G33
   * 
   * VT:
   * 	n.n. VT_G150_M00055	Verriegelung Optionen - Einbaugeraet III
    VT_G150_M00080	Gueltige Optionen G20, G33, G62
      O_COMMUNICATION_G150	O_TERMINAL_BOARD_G150
  */
  var O_TERMINAL_BOARD_G150 = "NON";
  if (ECL_ValueSelected("CB_O_TERMINAL_BOARD_G150", "T")) {
    var O_TERMINAL_BOARD_G150 = "G62";
  }

  var sTable = "VT_G150_M00080" + sDB_Suffix;
  var sWhere = "O_TERMINAL_BOARD_G150 = '" + O_TERMINAL_BOARD_G150 + "';";

  var sStatus = SetAttributeLogic1st(sTable, sDTKAttribute, sWhere);

  if (sStatus == "Error") {
    strError = "DICT1_ERR_G150___PL_O_COMMUNICATION";
    return strError;
  }
  // ################################################################################################################

  // ################################################################################################################
  // O_MODULE_G150	Module Cabinet-Mounted					NON, K50, K51
  // ################################################################################################################
  var sDTKAttribute = "O_MODULE_G150";

  /**
   * KAG: NON, K50, K51
   * 
   * VT:
   * 	n.n. VT_G150_M00055	Verriegelung Optionen - Einbaugeraet III
    VT_G150_M00084	gueltige Optionen Ausfuehrung II
      IN_AUSFUEHRUNG_G150	O_MODULE_G150	O_KLMOD_K82_G150	O_CU_K95_G150
    VT_G150_M00126	Verriegelung Optionen Module-K52
      O_MODULE_G150	O_ZUS_SMC30_K52_G150
  */
  // --------------------------------------------------------------------------------------------
  // VT_G150_M00084	gueltige Optionen Ausfuehrung II
  //		IN_AUSFUEHRUNG_G150	O_MODULE_G150	O_KLMOD_K82_G150	O_CU_K95_G150
  var O_KLMOD_K82_G150 = "NON";
  if (ECL_ValueSelected("CB_O_KLMOD_K82_G150", "T")) {
    var O_KLMOD_K82_G150 = "K82";
  }
  var O_CU_K95_G150 = "STD";
  if (ECL_ValueSelected("CB_O_CU_K95_G150", "T")) {
    var O_CU_K95_G150 = "K95";
  }

  var sTable = "VT_G150_M00084" + sDB_Suffix;
  var sWhere =
    "IN_AUSFUEHRUNG_G150 = '" +
    IN_AUSFUEHRUNG_G150 +
    "' AND " +
    "O_KLMOD_K82_G150 = '" +
    O_KLMOD_K82_G150 +
    "' AND " +
    "O_CU_K95_G150 = '" +
    O_CU_K95_G150 +
    "';";

  var sStatus = SetAttributeLogic1st(sTable, sDTKAttribute, sWhere);

  if (sStatus == "Error") {
    strError = "DICT1_ERR_G150___PL_O_MODULE";
    return strError;
  }
  // --------------------------------------------------------------------------------------------
  // VT_G150_M00126	Verriegelung Optionen Module-K52
  //		O_MODULE_G150	O_ZUS_SMC30_K52_G150
  var O_ZUS_SMC30_K52_G150 = "NON";
  if (ECL_ValueSelected("CB_O_ZUS_SMC30_K52_G150", "T")) {
    var O_ZUS_SMC30_K52_G150 = "K52";
  }

  var sTable = "VT_G150_M00126" + sDB_Suffix;
  var sWhere = "O_ZUS_SMC30_K52_G150 = '" + O_ZUS_SMC30_K52_G150 + "';";

  var sStatus = SetAttributeLogic2nd(sTable, sDTKAttribute, sWhere);

  if (sStatus == "Error") {
    strError = "DICT1_ERR_G150___PL_O_MODULE";
    return strError;
  }
  // ################################################################################################################

  // ################################################################################################################
  // O_BREMSEINHEIT_G150	Bremseinheit						NON, L61, L62
  // ################################################################################################################
  var sDTKAttribute = "O_BREMSEINHEIT_G150";

  /**
   * KAG: NON, L61, L62
   * 
   * VT:
   * 	VT_G150_M00064	gueltige Optionen Bremseinheit
   * 		HMK_FALLNUMMER_G150		MLFB11_G150		O_BREMSEINHEIT_G150
    VT_G150_M00086	gueltige Optionen Ausfuehrung IV
      IN_AUSFUEHRUNG_G150		O_BREMSEINHEIT_G150		O_NAMUR_B00_G150	O_USV_B02_G150	O_FREMD_B03_G150
    n.n. VT_G150_M00089	Verriegelung Optionen - Einbaugeraet VI
  */
  // --------------------------------------------------------------------------------------------
  // VT_G150_M00064	gueltige Optionen Bremseinheit
  // 		HMK_FALLNUMMER_G150		MLFB11_G150		O_BREMSEINHEIT_G150
  var sTable = "VT_G150_M00064" + sDB_Suffix;
  var sWhere = "HMK_FALLNUMMER_G150 = '" + HMK_FALLNUMMER_G150 + "' AND " + "MLFB11_G150 = '" + MLFB11_G150 + "';";

  var sStatus = SetAttributeLogic1st(sTable, sDTKAttribute, sWhere);

  if (sStatus == "Error") {
    strError = "DICT1_ERR_G150___PL_O_BREMSEINHEIT";
    return strError;
  }
  // --------------------------------------------------------------------------------------------
  // VT_G150_M00086	gueltige Optionen Ausfuehrung IV
  //		IN_AUSFUEHRUNG_G150		O_BREMSEINHEIT_G150		O_NAMUR_B00_G150	O_USV_B02_G150	O_FREMD_B03_G150
  var O_NAMUR_B00_G150 = "NON";
  if (ECL_ValueSelected("CB_O_NAMUR_B00_G150", "T")) {
    var O_NAMUR_B00_G150 = "B00";
  }
  var O_USV_B02_G150 = "NON";
  if (ECL_ValueSelected("CB_O_USV_B02_G150", "T")) {
    var O_USV_B02_G150 = "B02";
  }
  var O_FREMD_B03_G150 = "NON";
  if (ECL_ValueSelected("CB_O_FREMD_B03_G150", "T")) {
    var O_FREMD_B03_G150 = "B03";
  }

  var sTable = "VT_G150_M00086" + sDB_Suffix;
  var sWhere =
    "IN_AUSFUEHRUNG_G150 = '" +
    IN_AUSFUEHRUNG_G150 +
    "' AND " +
    "O_NAMUR_B00_G150 = '" +
    O_NAMUR_B00_G150 +
    "' AND " +
    "O_USV_B02_G150 = '" +
    O_USV_B02_G150 +
    "' AND " +
    "O_FREMD_B03_G150 = '" +
    O_FREMD_B03_G150 +
    "';";

  var sStatus = SetAttributeLogic2nd(sTable, sDTKAttribute, sWhere);

  if (sStatus == "Error") {
    strError = "DICT1_ERR_G150___PL_O_BREMSEINHEIT";
    return strError;
  }

  // ################################################################################################################

  // ################################################################################################################
  // O_GEWAEHR_G150	Gewährleistungsverlängerung				NON, Q80, Q81, Q82, Q83, Q84, Q85
  // ################################################################################################################
  var sDTKAttribute = "O_GEWAEHR_G150";

  /**
   * KAG: NON, Q80, Q81, Q82, Q83, Q84, Q85
   *
   * VT:
   * 	keine
   */

  // ################################################################################################################

  // ################################################################################################################
  // H_TRIGGER_AC230V_G150
  // ################################################################################################################
  /*BZ_G150_00187	Trigger Hilfsspannungsversorg.	
    OBJECTS: c is_a (300) skey 'G150'
    RESTRICTION:
      c.H_TRIGGER_AC230V_G150 = 'SPEC'
      if (c.MLFB08_G150 = '2' or
      (
      c.MLFB08_G150 eq '1' and
      c.IN_AUSFUEHRUNG_G150 eq 'A' and
      (
      (c.O_NAMUR_B00_G150 specified and
      c.O_NAMUR_B00_G150 eq 'B00') OR
      (c.O_KLEMMLEISTE_G61_G150 specified and
      c.O_KLEMMLEISTE_G61_G150 eq 'G61') OR
      (c.O_MODULE_G150 specified and
      c.O_MODULE_G150 eq 'K50') OR
      (c.O_SCHUETZ_L13_G150 specified and
      c.O_SCHUETZ_L13_G150 eq 'L13') OR
      (c.O_SCHALTER_L26_G150 specified and
      c.O_SCHALTER_L26_G150 eq 'L26') OR
      (c.O_MOTORSCHUTZ_G150 specified and
      c.O_MOTORSCHUTZ_G150 in ('L57','L59','L60')) OR
      (c.O_THERMISTOR_L83_G150 specified and
      c.O_THERMISTOR_L83_G150 eq 'L83') OR
      (c.O_THERMISTOR_L84_G150 specified and
      c.O_THERMISTOR_L84_G150 eq 'L84') OR
      (c.O_PT100_L86_G150 specified and
      c.O_PT100_L86_G150 eq 'L86') OR
      (c.O_ISO_WACH_L87_G150 specified and
      c.O_ISO_WACH_L87_G150 eq 'L87'))))
    INFERENCES:
      c.H_TRIGGER_AC230V_G150
      */

  var H_TRIGGER_AC230V_G150 = "NONSPEC";

  if (
    MLFB08_G150 == "2" ||
    (MLFB08_G150 == "1" &&
      IN_AUSFUEHRUNG_G150 == "A" &&
      (ECL_ValueSelected("CB_O_NAMUR_B00_G150", "T") ||
        ECL_ValueSelected("CB_O_KLEMMLEISTE_G61_G150", "T") ||
        ECL_GetValue("O_MODULE_G150" == "K50") ||
        ECL_ValueSelected("CB_O_SCHUETZ_L13_G150", "T") ||
        ECL_ValueSelected("CB_O_SCHALTER_L26_G150", "T") ||
        ECL_GetValue("O_MOTORSCHUTZ_G150" == "L57") ||
        ECL_GetValue("O_MOTORSCHUTZ_G150" == "L59") ||
        ECL_GetValue("O_MOTORSCHUTZ_G150" == "L60") ||
        ECL_ValueSelected("CB_O_THERMISTOR_L83_G150", "T") ||
        ECL_ValueSelected("CB_O_THERMISTOR_L84_G150", "T") ||
        ECL_ValueSelected("CB_O_PT100_L86_G150", "T") ||
        ECL_ValueSelected("CB_O_ISO_WACH_L87_G150", "T")))
  ) {
    H_TRIGGER_AC230V_G150 = "SPEC";
  }
  ECL_SelectValue("H_TRIGGER_AC230V_G150", H_TRIGGER_AC230V_G150);
  // ################################################################################################################

  // ################################################################################################################
  // O_HILFSSPG_INTERN_G150	Hilfsspannungsversorgung		NON, EXT, K74 (NON nur ohne L50, L55, M66)
  // ################################################################################################################
  var sDTKAttribute = "O_HILFSSPG_INTERN_G150";

  /**
   * KAG: NON, EXT, K74 (NON nur ohne L50, L55, M66)
   * 
   * VT:
   * 	VT_G150_M00140	Hilfsspannungsversorgung - M66
   * 		O_HILFSSPG_INTERN_G150	O_SCHIFF_M66_G150
    VT_G150_M00141	ZO Header Note K74 L50 L55
      O_HILFSSPG_INTERN_G150	O_BELEUCHT_L50_G150	O_STILLST_L55_G150	HMK_NOTE_K74_L50_L55_G150
	
  BZ_G150_00187	Trigger Hilfsspannungsversorg.	
    OBJECTS: c is_a (300) skey 'G150'
    RESTRICTION:
      c.H_TRIGGER_AC230V_G150 = 'SPEC'
      if (c.MLFB08_G150 = '2' or
      (
      c.MLFB08_G150 eq '1' and
      c.IN_AUSFUEHRUNG_G150 eq 'A' and
      (
      (c.O_NAMUR_B00_G150 specified and
      c.O_NAMUR_B00_G150 eq 'B00') OR
      (c.O_KLEMMLEISTE_G61_G150 specified and
      c.O_KLEMMLEISTE_G61_G150 eq 'G61') OR
      (c.O_MODULE_G150 specified and
      c.O_MODULE_G150 eq 'K50') OR
      (c.O_SCHUETZ_L13_G150 specified and
      c.O_SCHUETZ_L13_G150 eq 'L13') OR
      (c.O_SCHALTER_L26_G150 specified and
      c.O_SCHALTER_L26_G150 eq 'L26') OR
      (c.O_MOTORSCHUTZ_G150 specified and
      c.O_MOTORSCHUTZ_G150 in ('L57','L59','L60')) OR
      (c.O_THERMISTOR_L83_G150 specified and
      c.O_THERMISTOR_L83_G150 eq 'L83') OR
      (c.O_THERMISTOR_L84_G150 specified and
      c.O_THERMISTOR_L84_G150 eq 'L84') OR
      (c.O_PT100_L86_G150 specified and
      c.O_PT100_L86_G150 eq 'L86') OR
      (c.O_ISO_WACH_L87_G150 specified and
      c.O_ISO_WACH_L87_G150 eq 'L87'))))
    INFERENCES:
      c.H_TRIGGER_AC230V_G150
  	
    BZ_G150_00264	set_default_Hilfsspver_requird

    $del_default
    ($self,O_HILFSSPG_INTERN_G150,'K74')
    if O_BELEUCHT_L50_G150 eq 'L50' or
      O_STILLST_L55_G150 eq 'L55' or
      O_SCHIFF_M66_G150 eq 'M66' or
      not H_TRIGGER_AC230V_G150 specified or
      H_TRIGGER_AC230V_G150 ne 'SPEC',
    *
    $set_default ($self,O_HILFSSPG_INTERN_G150,'K74')
    if O_BELEUCHT_L50_G150 eq 'NON' and
      O_STILLST_L55_G150 eq 'NON' and
      O_SCHIFF_M66_G150 eq 'STD' and
      H_TRIGGER_AC230V_G150 eq 'SPEC' and
      (H_KONFIG_TYP_G150 = 'NEU' or
      (H_KONFIG_TYP_G150 = 'DI' and
      H_DI_FERTIG_G150 = 'T'))
    
    BZ_G150_00263	Hilfsspannungsversorgung mand.
    OBJECTS:
      c is_a (300) skey 'G150'
    CONDITION:
      c.H_TRIGGER_AC230V_G150 = 'SPEC'
     RESTRICTION:
      c.O_HILFSSPG_INTERN_G150 IN ('K74','EXT')
     INFERENCES:
      c.O_HILFSSPG_INTERN_G150
      */
  // --------------------------------------------------------------------------------------------
  ECL_ActivateAllAttributeValues(sDTKAttribute);
  if (H_TRIGGER_AC230V_G150 == "SPEC") {
    var aValidValues = ["K74", "EXT"];
    SetAttributeLogicFromCode(sDTKAttribute, aValidValues);
    if (sStatus == "Error") {
      strError = "DICT1_ERR_G150___PL_O_HILFSSPG_INTERN";
      return strError;
    }
  }

  // VT_G150_M00140	Hilfsspannungsversorgung - M66
  // 		O_HILFSSPG_INTERN_G150	O_SCHIFF_M66_G150
  var O_SCHIFF_M66_G150 = "STD";
  if (ECL_ValueSelected("CB_O_SCHIFF_M66_G150", "T")) {
    var O_SCHIFF_M66_G150 = "M66";
  }

  var sTable = "VT_G150_M00140" + sDB_Suffix;
  var sWhere = "O_SCHIFF_M66_G150 = '" + O_SCHIFF_M66_G150 + "';";

  var sStatus = SetAttributeLogic2nd(sTable, sDTKAttribute, sWhere);

  if (sStatus == "Error") {
    strError = "DICT1_ERR_G150___PL_O_HILFSSPG_INTERN";
    return strError;
  }
  // --------------------------------------------------------------------------------------------
  // VT_G150_M00141	ZO Header Note K74 L50 L55
  //		O_HILFSSPG_INTERN_G150	O_BELEUCHT_L50_G150	O_STILLST_L55_G150	HMK_NOTE_K74_L50_L55_G150

  var O_BELEUCHT_L50_G150 = "NON";
  if (ECL_ValueSelected("CB_O_BELEUCHT_L50_G150", "T")) {
    var O_BELEUCHT_L50_G150 = "L50";
  }
  var O_STILLST_L55_G150 = "NON";
  if (ECL_ValueSelected("CB_O_STILLST_L55_G150", "T")) {
    var O_STILLST_L55_G150 = "L55";
  }

  var sTable = "VT_G150_M00141" + sDB_Suffix;
  var sWhere = "O_BELEUCHT_L50_G150 = '" + O_BELEUCHT_L50_G150 + "' AND " + "O_STILLST_L55_G150 = '" + O_STILLST_L55_G150 + "';";

  var sStatus = SetAttributeLogic2nd(sTable, sDTKAttribute, sWhere);

  if (sStatus == "Error") {
    strError = "DICT1_ERR_G150___PL_O_HILFSSPG_INTERN";
    return strError;
  }
  // ################################################################################################################

  // ################################################################################################################
  // O_BESCHRIFTUNGSSCHIL_G150	Beschriftungsschild zur Anlagenkennzeichnung	NON, Y31, Y32, Y33
  // ################################################################################################################
  var sDTKAttribute = "O_BESCHRIFTUNGSSCHIL_G150";

  /**
   * KAG: NON, Y31, Y32, Y33
   *
   * VT:
   * 	keine
   */

  // ################################################################################################################

  // ################################################################################################################
  // O_KLEMMLEISTE_G60_G150	Kundenklemmleiste TM31					STD, G60
  // ################################################################################################################
  var sDTKAttribute = "O_KLEMMLEISTE_G60_G150";
  var sCB_Attribute = "CB_" + sDTKAttribute;
  /**
   * KAG: STD, G60
   * CB: CB_O_KLEMMLEISTE_G60_G150
   * 
   * VT:
   * 	n.n. VT_G150_M00055	Verriegelung Optionen - Einbaugeraet III
    VT_G150_M00058	gueltige Optionen Klemmleiste
      O_KLEMMLEISTE_G60_G150	O_KLEMMLEISTE_G61_G150
  */
  // --------------------------------------------------------------------------------------------
  // VT_G150_M00058	gueltige Optionen Klemmleiste
  //		O_KLEMMLEISTE_G60_G150	O_KLEMMLEISTE_G61_G150

  var O_KLEMMLEISTE_G61_G150 = "STD";
  if (ECL_ValueSelected("CB_O_KLEMMLEISTE_G61_G150", "T")) {
    var O_KLEMMLEISTE_G61_G150 = "G61";
  }
  var sTable = "VT_G150_M00058" + sDB_Suffix;
  var sWhere = "O_KLEMMLEISTE_G61_G150 = '" + O_KLEMMLEISTE_G61_G150 + "';";

  var sStatus = SetAttributeLogic_Checkbox(sTable, sDTKAttribute, sCB_Attribute, "G60", "STD", sWhere, false);

  if (sStatus == "Error") {
    strError = "DICT1_ERR_G150___PL_G60";
    return strError;
  }
  // --------------------------------------------------------------------------------------------

  // ################################################################################################################

  // ################################################################################################################
  // O_KLEMMLEISTE_G61_G150	zusätzliche Kundenklemmleiste TM31		STD, G61
  // ################################################################################################################
  var sDTKAttribute = "O_KLEMMLEISTE_G61_G150";
  var sCB_Attribute = "CB_" + sDTKAttribute;
  /**
   * KAG: STD, G61
   * CB: CB_O_KLEMMLEISTE_G61_G150
   * 
   * VT:
   * 	n.n. VT_G150_M00055	Verriegelung Optionen - Einbaugeraet III
  B	VT_G150_M00058	gueltige Optionen Klemmleiste
      O_KLEMMLEISTE_G60_G150	O_KLEMMLEISTE_G61_G150
  A	VT_G150_M00085	gueltige Optionen Ausfuehrung III
      IN_AUSFUEHRUNG_G150		O_KLEMMLEISTE_G61_G150	O_HILFSBETR_L19_G150	O_BELEUCHT_L50_G150
  C	VT_G150_M00136	Option G61<-->Option K87
      O_KLEMMLEISTE_G61_G150	O_TM54F_K87_G150
  */
  // --------------------------------------------------------------------------------------------
  // A	VT_G150_M00085	gueltige Optionen Ausfuehrung III
  //		IN_AUSFUEHRUNG_G150		O_KLEMMLEISTE_G61_G150	O_HILFSBETR_L19_G150	O_BELEUCHT_L50_G150
  var O_HILFSBETR_L19_G150 = "NON";
  if (ECL_ValueSelected("CB_O_HILFSBETR_L19_G150", "T")) {
    var O_HILFSBETR_L19_G150 = "L19";
  }
  var O_BELEUCHT_L50_G150 = "NON";
  if (ECL_ValueSelected("CB_O_BELEUCHT_L50_G150", "T")) {
    var O_BELEUCHT_L50_G150 = "L50";
  }
  var sTable = "VT_G150_M00085" + sDB_Suffix;
  var sWhere =
    "IN_AUSFUEHRUNG_G150 = '" +
    IN_AUSFUEHRUNG_G150 +
    "' AND " +
    "O_HILFSBETR_L19_G150 = '" +
    O_HILFSBETR_L19_G150 +
    "' AND " +
    "O_BELEUCHT_L50_G150 = '" +
    O_BELEUCHT_L50_G150 +
    "';";

  var sStatus = SetAttributeLogic_Checkbox(sTable, sDTKAttribute, sCB_Attribute, "G61", "STD", sWhere, false);

  if (sStatus == "Error") {
    strError = "DICT1_ERR_G150___PL_G61";
    return strError;
  }
  // --------------------------------------------------------------------------------------------
  // B VT_G150_M00058	gueltige Optionen Klemmleiste
  //		O_KLEMMLEISTE_G60_G150	O_KLEMMLEISTE_G61_G150
  var O_KLEMMLEISTE_G60_G150 = "STD";
  if (ECL_ValueSelected("CB_O_KLEMMLEISTE_G60_G150", "T")) {
    O_KLEMMLEISTE_G60_G150 = "G60";
  }
  var sTable = "VT_G150_M00058" + sDB_Suffix;
  var sWhere = "O_KLEMMLEISTE_G60_G150 = '" + O_KLEMMLEISTE_G60_G150 + "';";

  var sStatus = SetAttributeLogic_Checkbox(sTable, sDTKAttribute, sCB_Attribute, "G61", "STD", sWhere, true);

  if (sStatus == "Error") {
    strError = "DICT1_ERR_G150___PL_G61";
    return strError;
  }
  // --------------------------------------------------------------------------------------------
  // C VT_G150_M00136	Option G61<-->Option K87
  //		O_KLEMMLEISTE_G61_G150	O_TM54F_K87_G150

  var O_TM54F_K87_G150 = "F";
  if (ECL_ValueSelected("CB_O_TM54F_K87_G150", "T")) {
    O_TM54F_K87_G150 = "K87";
  }
  var sTable = "VT_G150_M00136" + sDB_Suffix;
  var sWhere = "O_TM54F_K87_G150 = '" + O_TM54F_K87_G150 + "';";

  var sStatus = SetAttributeLogic_Checkbox(sTable, sDTKAttribute, sCB_Attribute, "G61", "STD", sWhere, true);

  if (sStatus == "Error") {
    strError = "DICT1_ERR_G150___PL_G61";
    return strError;
  }

  // ################################################################################################################

  // ################################################################################################################
  // O_TERMINAL_BOARD_G150	Terminal Board TB30						NON, G62
  // ################################################################################################################
  var sDTKAttribute = "O_TERMINAL_BOARD_G150";
  var sCB_Attribute = "CB_" + sDTKAttribute;
  /**
   * KAG: NON, G62
   * CB: CB_O_TERMINAL_BOARD_G150
   *
   * VT:
   * 	VT_G150_M00080	Gueltige Optionen G20, G33, G62
   * 		O_COMMUNICATION_G150	O_TERMINAL_BOARD_G150
   */
  var O_COMMUNICATION_G150 = ECL_GetValue("O_COMMUNICATION_G150");

  var sTable = "VT_G150_M00080" + sDB_Suffix;
  var sWhere = "O_COMMUNICATION_G150 = '" + O_COMMUNICATION_G150 + "';";

  var sStatus = SetAttributeLogic_Checkbox(sTable, sDTKAttribute, sCB_Attribute, "G62", "NON", sWhere, false);

  if (sStatus == "Error") {
    strError = "DICT1_ERR_G150___PL_O_TERMINAL_BOARD";
    return strError;
  }
  // ################################################################################################################

  // ################################################################################################################
  // O_SAFETY_LIZENZ_K01__G150	Safety-Lizenz für eine Achse		STD, K01
  // ################################################################################################################
  var sDTKAttribute = "O_SAFETY_LIZENZ_K01__G150";
  var sCB_Attribute = "CB_" + sDTKAttribute;
  /**
   * KAG: STD, K01
   * CB: CB_O_SAFETY_LIZENZ_K01__G150
   * 
   * VT:
      A VT_G150_M00125	ZO Design - Safety
        IN_AUSFUEHRUNG_G150		O_SAFETY_LIZENZ_K01__G150
    B VT_G150_M00127	Verriegelung Optionen K52-K01
      O_ZUS_SMC30_K52_G150	O_SAFETY_LIZENZ_K01__G150
    C VT_G150_M00137	Option K01<--> Option K87
      O_SAFETY_LIZENZ_K01__G150	O_TM54F_K87_G150
  */
  // --------------------------------------------------------------------------------------------
  // A VT_G150_M00125	ZO Design - Safety
  // 		IN_AUSFUEHRUNG_G150		O_SAFETY_LIZENZ_K01__G150
  var sTable = "VT_G150_M00125" + sDB_Suffix;
  var sWhere = "IN_AUSFUEHRUNG_G150 = '" + IN_AUSFUEHRUNG_G150 + "';";

  var sStatus = SetAttributeLogic_Checkbox(sTable, sDTKAttribute, sCB_Attribute, "K01", "STD", sWhere, false);

  if (sStatus == "Error") {
    strError = "DICT1_ERR_G150___PL_K01";
    return strError;
  }
  // --------------------------------------------------------------------------------------------
  // B VT_G150_M00127	Verriegelung Optionen K52-K01
  //		O_ZUS_SMC30_K52_G150	O_SAFETY_LIZENZ_K01__G150

  var O_ZUS_SMC30_K52_G150 = "NON";
  if (ECL_ValueSelected("CB_O_ZUS_SMC30_K52_G150", "T")) {
    O_ZUS_SMC30_K52_G150 = "K52";
  }

  var sTable = "VT_G150_M00127" + sDB_Suffix;
  var sWhere = "O_ZUS_SMC30_K52_G150 = '" + O_ZUS_SMC30_K52_G150 + "';";

  var sStatus = SetAttributeLogic_Checkbox(sTable, sDTKAttribute, sCB_Attribute, "K01", "STD", sWhere, true);

  if (sStatus == "Error") {
    strError = "DICT1_ERR_G150___PL_K01";
    return strError;
  }
  // --------------------------------------------------------------------------------------------
  // C VT_G150_M00137	Option K01<--> Option K87
  //		O_SAFETY_LIZENZ_K01__G150	O_TM54F_K87_G150

  var O_TM54F_K87_G150 = "F";
  if (ECL_ValueSelected("CB_O_TM54F_K87_G150", "T")) {
    O_TM54F_K87_G150 = "K87";
  }

  var sTable = "VT_G150_M00137" + sDB_Suffix;
  var sWhere = "O_TM54F_K87_G150 = '" + O_TM54F_K87_G150 + "';";

  var sStatus = SetAttributeLogic_Checkbox(sTable, sDTKAttribute, sCB_Attribute, "K01", "STD", sWhere, true);

  if (sStatus == "Error") {
    strError = "DICT1_ERR_G150___PL_K01";
    return strError;
  }
  // ################################################################################################################

  // ################################################################################################################
  // O_ZUS_SMC30_K52_G150		Zusätzliches Sensor Module Cabinet-Mounted SMC30		NON, K52
  // ################################################################################################################
  var sDTKAttribute = "O_ZUS_SMC30_K52_G150";
  var sCB_Attribute = "CB_" + sDTKAttribute;
  /**
   * KAG: NON, K52
   * CB: CB_O_ZUS_SMC30_K52_G150
   * 
   * VT:
      B VT_G150_M00126	Verriegelung Optionen Module-K52
        O_MODULE_G150	O_ZUS_SMC30_K52_G150
    C VT_G150_M00127	Verriegelung Optionen K52-K01
      O_ZUS_SMC30_K52_G150	O_SAFETY_LIZENZ_K01__G150
    A VT_G150_M00128	Verriegelung Design-Opt K52
      IN_AUSFUEHRUNG_G150		O_ZUS_SMC30_K52_G150
  */
  // --------------------------------------------------------------------------------------------
  // A VT_G150_M00128	Verriegelung Design-Opt K52
  //		IN_AUSFUEHRUNG_G150		O_ZUS_SMC30_K52_G150
  var sTable = "VT_G150_M00128" + sDB_Suffix;
  var sWhere = "IN_AUSFUEHRUNG_G150 = '" + IN_AUSFUEHRUNG_G150 + "';";

  var sStatus = SetAttributeLogic_Checkbox(sTable, sDTKAttribute, sCB_Attribute, "K52", "NON", sWhere, false);

  if (sStatus == "Error") {
    strError = "DICT1_ERR_G150___PL_K52";
    return strError;
  }
  // --------------------------------------------------------------------------------------------
  // B VT_G150_M00126	Verriegelung Optionen Module-K52
  // 		O_MODULE_G150	O_ZUS_SMC30_K52_G150

  var O_MODULE_G150 = ECL_GetValue("O_MODULE_G150");

  var sTable = "VT_G150_M00126" + sDB_Suffix;
  var sWhere = "O_MODULE_G150 = '" + O_MODULE_G150 + "';";

  var sStatus = SetAttributeLogic_Checkbox(sTable, sDTKAttribute, sCB_Attribute, "K52", "NON", sWhere, true);

  if (sStatus == "Error") {
    strError = "DICT1_ERR_G150___PL_K52";
    return strError;
  }
  // --------------------------------------------------------------------------------------------
  // C VT_G150_M00127	Verriegelung Optionen K52-K01
  //		O_ZUS_SMC30_K52_G150	O_SAFETY_LIZENZ_K01__G150
  var O_SAFETY_LIZENZ_K01__G150 = "STD";
  if (ECL_ValueSelected("CB_O_SAFETY_LIZENZ_K01__G150", "T")) {
    O_SAFETY_LIZENZ_K01__G150 = "K01";
  }

  var sTable = "VT_G150_M00127" + sDB_Suffix;
  var sWhere = "O_SAFETY_LIZENZ_K01__G150 = '" + O_SAFETY_LIZENZ_K01__G150 + "';";

  var sStatus = SetAttributeLogic_Checkbox(sTable, sDTKAttribute, sCB_Attribute, "K52", "NON", sWhere, true);

  if (sStatus == "Error") {
    strError = "DICT1_ERR_G150___PL_K52";
    return strError;
  }

  // ################################################################################################################

  // ################################################################################################################
  // O_KLMOD_K82_G150	Klemmenmodul zur Ansteuerung der Sicherheitsfunktionen "Safe Torque Off" und "Safe Stop 1"		NON, K82
  // ################################################################################################################
  var sDTKAttribute = "O_KLMOD_K82_G150";
  var sCB_Attribute = "CB_" + sDTKAttribute;
  /**
   * KAG: NON, K82
   * CB: CB_O_KLMOD_K82_G150
   * 
   * VT:
   * 	n.n. VT_G150_M00055	Verriegelung Optionen - Einbaugeraet III
    VT_G150_M00084	gueltige Optionen Ausfuehrung II
      IN_AUSFUEHRUNG_G150		O_MODULE_G150	O_KLMOD_K82_G150	O_CU_K95_G150
  */
  // VT_G150_M00084	gueltige Optionen Ausfuehrung II
  //		IN_AUSFUEHRUNG_G150	O_MODULE_G150	O_KLMOD_K82_G150	O_CU_K95_G150
  var O_MODULE_G150 = ECL_GetValue("O_MODULE_G150");

  var O_CU_K95_G150 = "STD";
  if (ECL_ValueSelected("CB_O_CU_K95_G150", "T")) {
    O_CU_K95_G150 = "K95";
  }

  var sTable = "VT_G150_M00084" + sDB_Suffix;
  var sWhere =
    "IN_AUSFUEHRUNG_G150 = '" +
    IN_AUSFUEHRUNG_G150 +
    "' AND " +
    "O_MODULE_G150 = '" +
    O_MODULE_G150 +
    "' AND " +
    "O_CU_K95_G150 = '" +
    O_CU_K95_G150 +
    "';";

  var sStatus = SetAttributeLogic_Checkbox(sTable, sDTKAttribute, sCB_Attribute, "K82", "NON", sWhere, false);

  if (sStatus == "Error") {
    strError = "DICT1_ERR_G150___PL_K82";
    return strError;
  }
  // --------------------------------------------------------------------------------------------

  // ################################################################################################################

  // ################################################################################################################
  // O_TM54F_K87_G150		Terminal Module TM54F							F, K87
  // ################################################################################################################
  var sDTKAttribute = "O_TM54F_K87_G150";
  var sCB_Attribute = "CB_" + sDTKAttribute;
  /**
   * KAG: F, K87
   * CB: CB_O_TM54F_K87_G150
   * 
   * VT:
      A VT_G150_M00135	Design<--> option K87
        IN_AUSFUEHRUNG_G150		O_TM54F_K87_G150
    B VT_G150_M00136	Option G61<-->Option K87
      O_KLEMMLEISTE_G61_G150	O_TM54F_K87_G150
    C VT_G150_M00137	Option K01<--> Option K87
      O_SAFETY_LIZENZ_K01__G150	O_TM54F_K87_G150
  */
  // --------------------------------------------------------------------------------------------
  //A VT_G150_M00135	Design<--> option K87
  // 		IN_AUSFUEHRUNG_G150		O_TM54F_K87_G150
  var sTable = "VT_G150_M00135" + sDB_Suffix;
  var sWhere = "IN_AUSFUEHRUNG_G150 = '" + IN_AUSFUEHRUNG_G150 + "';";

  var sStatus = SetAttributeLogic_Checkbox(sTable, sDTKAttribute, sCB_Attribute, "K87", "F", sWhere, false);

  if (sStatus == "Error") {
    strError = "DICT1_ERR_G150___PL_K87";
    return strError;
  }
  // --------------------------------------------------------------------------------------------
  // B VT_G150_M00136	Option G61<-->Option K87
  // 		O_KLEMMLEISTE_G61_G150	O_TM54F_K87_G150

  var O_KLEMMLEISTE_G61_G150 = "STD";
  if (ECL_ValueSelected("CB_O_KLEMMLEISTE_G61_G150", "T")) {
    var O_KLEMMLEISTE_G61_G150 = "G61";
  }
  var sTable = "VT_G150_M00136" + sDB_Suffix;
  var sWhere = "O_KLEMMLEISTE_G61_G150 = '" + O_KLEMMLEISTE_G61_G150 + "';";

  var sStatus = SetAttributeLogic_Checkbox(sTable, sDTKAttribute, sCB_Attribute, "K87", "F", sWhere, true);

  if (sStatus == "Error") {
    strError = "DICT1_ERR_G150___PL_K87";
    return strError;
  }
  // --------------------------------------------------------------------------------------------
  // C VT_G150_M00137	Option K01<--> Option K87
  //		O_SAFETY_LIZENZ_K01__G150	O_TM54F_K87_G150

  var O_SAFETY_LIZENZ_K01__G150 = "STD";
  if (ECL_ValueSelected("CB_O_SAFETY_LIZENZ_K01__G150", "T")) {
    O_SAFETY_LIZENZ_K01__G150 = "K01";
  }

  var sTable = "VT_G150_M00137" + sDB_Suffix;
  var sWhere = "O_SAFETY_LIZENZ_K01__G150 = '" + O_SAFETY_LIZENZ_K01__G150 + "';";

  var sStatus = SetAttributeLogic_Checkbox(sTable, sDTKAttribute, sCB_Attribute, "K87", "F", sWhere, true);

  if (sStatus == "Error") {
    strError = "DICT1_ERR_G150___PL_K87";
    return strError;
  }
  // ################################################################################################################

  // ################################################################################################################
  // O_SAFETY_SBA_K88_G150	Safe Brake Adapter SBA AC 230 V				F, K88
  // ################################################################################################################
  var sDTKAttribute = "O_SAFETY_SBA_K88_G150";
  var sCB_Attribute = "CB_" + sDTKAttribute;
  /**
   * KAG: F, K88
   * CB: CB_O_SAFETY_SBA_K88_G150
   * 
   * VT:
   * 	VT_G150_M00138	Design <--> option K88
      IN_AUSFUEHRUNG_G150		O_SAFETY_SBA_K88_G150
  */

  var sTable = "VT_G150_M00138" + sDB_Suffix;
  var sWhere = "IN_AUSFUEHRUNG_G150 = '" + IN_AUSFUEHRUNG_G150 + "';";

  var sStatus = SetAttributeLogic_Checkbox(sTable, sDTKAttribute, sCB_Attribute, "K88", "F", sWhere, false);

  if (sStatus == "Error") {
    strError = "DICT1_ERR_G150___PL_K88";
    return strError;
  }
  // ################################################################################################################

  // ################################################################################################################
  // O_CU_K95_G150	Control Unit CU320-2 PN (PROFINET, EtherNet/IP)		STD, K95
  // ################################################################################################################
  var sDTKAttribute = "O_CU_K95_G150";
  var sCB_Attribute = "CB_" + sDTKAttribute;
  /**
   * KAG: STD, K95
   * CB: CB_O_CU_K95_G150
   * 
   * VT:
   * 	n.n. VT_G150_M00055	Verriegelung Optionen - Einbaugeraet III
    VT_G150_M00084	gueltige Optionen Ausfuehrung II
      IN_AUSFUEHRUNG_G150		O_MODULE_G150	O_KLMOD_K82_G150	O_CU_K95_G150
  */
  var O_MODULE_G150 = ECL_GetValue("O_MODULE_G150");

  var O_KLMOD_K82_G150 = "NON";
  if (ECL_ValueSelected("CB_O_KLMOD_K82_G150", "T")) {
    O_KLMOD_K82_G150 = "K82";
  }

  var sTable = "VT_G150_M00084" + sDB_Suffix;
  var sWhere =
    "IN_AUSFUEHRUNG_G150 = '" +
    IN_AUSFUEHRUNG_G150 +
    "' AND " +
    "O_MODULE_G150 = '" +
    O_MODULE_G150 +
    "' AND " +
    "O_KLMOD_K82_G150 = '" +
    O_KLMOD_K82_G150 +
    "';";

  var sStatus = SetAttributeLogic_Checkbox(sTable, sDTKAttribute, sCB_Attribute, "K95", "STD", sWhere, false);

  if (sStatus == "Error") {
    strError = "DICT1_ERR_G150___PL_K95";
    return strError;
  }
  // ################################################################################################################

  // ################################################################################################################
  // O_HILFSBETR_L19_G150	Anschluss für ext. Hilfsbetriebe			NON, L19
  // ################################################################################################################
  var sDTKAttribute = "O_HILFSBETR_L19_G150";
  var sCB_Attribute = "CB_" + sDTKAttribute;
  /**
   * KAG: NON, L19
   * CB: CB_O_HILFSBETR_L19_G150
   * 
   * VT:
   * 	n.n. VT_G150_M00055	Verriegelung Optionen - Einbaugeraet III
    VT_G150_M00085	gueltige Optionen Ausfuehrung III
      IN_AUSFUEHRUNG_G150		O_KLEMMLEISTE_G61_G150	O_HILFSBETR_L19_G150	O_BELEUCHT_L50_G150
  */
  var O_KLEMMLEISTE_G61_G150 = "STD";
  if (ECL_ValueSelected("CB_O_KLEMMLEISTE_G61_G150", "T")) {
    var O_KLEMMLEISTE_G61_G150 = "G61";
  }

  var O_BELEUCHT_L50_G150 = "NON";
  if (ECL_ValueSelected("CB_O_BELEUCHT_L50_G150", "T")) {
    O_BELEUCHT_L50_G150 = "L50";
  }

  var sTable = "VT_G150_M00085" + sDB_Suffix;
  var sWhere =
    "IN_AUSFUEHRUNG_G150 = '" +
    IN_AUSFUEHRUNG_G150 +
    "' AND " +
    "O_KLEMMLEISTE_G61_G150 = '" +
    O_KLEMMLEISTE_G61_G150 +
    "' AND " +
    "O_BELEUCHT_L50_G150 = '" +
    O_BELEUCHT_L50_G150 +
    "';";

  var sStatus = SetAttributeLogic_Checkbox(sTable, sDTKAttribute, sCB_Attribute, "L19", "NON", sWhere, false);

  if (sStatus == "Error") {
    strError = "DICT1_ERR_G150___PL_L19";
    return strError;
  }
  // ################################################################################################################

  // ################################################################################################################
  // O_BELEUCHT_L50_G150	Schrankbeleuchtung mit Service-Steckdose		NON, L50
  // ################################################################################################################
  var sDTKAttribute = "O_BELEUCHT_L50_G150";
  var sCB_Attribute = "CB_" + sDTKAttribute;
  /**
   * KAG: NON, L50
   * CB: CB_O_BELEUCHT_L50_G150
   * 
   * VT:
   * 	n.n. VT_G150_M00055	Verriegelung Optionen - Einbaugeraet III
    VT_G150_M00085	gueltige Optionen Ausfuehrung III
      IN_AUSFUEHRUNG_G150		O_KLEMMLEISTE_G61_G150	O_HILFSBETR_L19_G150	O_BELEUCHT_L50_G150
    VT_G150_M00141	ZO Header Note K74 L50 L55
      O_HILFSSPG_INTERN_G150	O_BELEUCHT_L50_G150		O_STILLST_L55_G150		HMK_NOTE_K74_L50_L55_G150
  */
  var O_KLEMMLEISTE_G61_G150 = "STD";
  if (ECL_ValueSelected("CB_O_KLEMMLEISTE_G61_G150", "T")) {
    O_KLEMMLEISTE_G61_G150 = "G61";
  }

  var O_HILFSBETR_L19_G150 = "NON";
  if (ECL_ValueSelected("CB_O_HILFSBETR_L19_G150", "T")) {
    O_HILFSBETR_L19_G150 = "L19";
  }

  var sTable = "VT_G150_M00085" + sDB_Suffix;
  var sWhere =
    "IN_AUSFUEHRUNG_G150 = '" +
    IN_AUSFUEHRUNG_G150 +
    "' AND " +
    "O_KLEMMLEISTE_G61_G150 = '" +
    O_KLEMMLEISTE_G61_G150 +
    "' AND " +
    "O_HILFSBETR_L19_G150 = '" +
    O_HILFSBETR_L19_G150 +
    "';";

  var sStatus = SetAttributeLogic_Checkbox(sTable, sDTKAttribute, sCB_Attribute, "L50", "NON", sWhere, false);

  if (sStatus == "Error") {
    strError = "DICT1_ERR_G150___PL_L50";
    return strError;
  }
  // --------------------------------------------------------------------------------------------
  // VT_G150_M00141	ZO Header Note K74 L50 L55
  //		O_HILFSSPG_INTERN_G150	O_BELEUCHT_L50_G150		O_STILLST_L55_G150		HMK_NOTE_K74_L50_L55_G150

  var O_HILFSSPG_INTERN_G150 = ECL_GetValue("O_HILFSSPG_INTERN_G150");

  var O_STILLST_L55_G150 = "NON";
  if (ECL_ValueSelected("CB_O_STILLST_L55_G150", "T")) {
    O_STILLST_L55_G150 = "L55";
  }
  var sTable = "VT_G150_M00141" + sDB_Suffix;
  var sWhere = "O_HILFSSPG_INTERN_G150 = '" + O_HILFSSPG_INTERN_G150 + "' AND " + "O_STILLST_L55_G150 = '" + O_STILLST_L55_G150 + "';";

  var sStatus = SetAttributeLogic_Checkbox(sTable, sDTKAttribute, sCB_Attribute, "L50", "NON", sWhere, true);

  if (sStatus == "Error") {
    strError = "DICT1_ERR_G150___PL_L50";
    return strError;
  }

  // ################################################################################################################

  // ################################################################################################################
  // O_STILLST_L55_G150	Schrank Stillstandsheizung						NON, L55
  // ################################################################################################################
  var sDTKAttribute = "O_STILLST_L55_G150";
  var sCB_Attribute = "CB_" + sDTKAttribute;
  /**
   * KAG: NON, L55
   * CB: CB_O_STILLST_L55_G150
   * 
   * VT:
      VT_G150_M00112	Einschraenkungen_M66_L55
        O_SCHIFF_M66_G150	O_STILLST_L55_G150
    VT_G150_M00141	ZO Header Note K74 L50 L55
      O_HILFSSPG_INTERN_G150	O_BELEUCHT_L50_G150		O_STILLST_L55_G150		HMK_NOTE_K74_L50_L55_G150
  */
  var O_SCHIFF_M66_G150 = "STD";
  if (ECL_ValueSelected("CB_O_SCHIFF_M66_G150", "T")) {
    var O_SCHIFF_M66_G150 = "M66";
  }

  var sTable = "VT_G150_M00112" + sDB_Suffix;
  var sWhere = "O_SCHIFF_M66_G150 = '" + O_SCHIFF_M66_G150 + "';";

  var sStatus = SetAttributeLogic_Checkbox(sTable, sDTKAttribute, sCB_Attribute, "L55", "NON", sWhere, false);

  if (sStatus == "Error") {
    strError = "DICT1_ERR_G150___PL_L55";
    return strError;
  }
  // --------------------------------------------------------------------------------------------
  // VT_G150_M00141	ZO Header Note K74 L50 L55
  //		O_HILFSSPG_INTERN_G150	O_BELEUCHT_L50_G150		O_STILLST_L55_G150		HMK_NOTE_K74_L50_L55_G150

  var O_HILFSSPG_INTERN_G150 = ECL_GetValue("O_HILFSSPG_INTERN_G150");

  var O_BELEUCHT_L50_G150 = "NON";
  if (ECL_ValueSelected("CB_O_BELEUCHT_L50_G150", "T")) {
    var O_BELEUCHT_L50_G150 = "L50";
  }
  var sTable = "VT_G150_M00141" + sDB_Suffix;
  var sWhere = "O_HILFSSPG_INTERN_G150 = '" + O_HILFSSPG_INTERN_G150 + "' AND " + "O_BELEUCHT_L50_G150 = '" + O_BELEUCHT_L50_G150 + "';";

  var sStatus = SetAttributeLogic_Checkbox(sTable, sDTKAttribute, sCB_Attribute, "L55", "NON", sWhere, true);

  if (sStatus == "Error") {
    strError = "DICT1_ERR_G150___PL_L55";
    return strError;
  }
  // ################################################################################################################

  // ################################################################################################################
  // O_ADEREND_M91_G150	Vollständige Aderendmarkierung der Steuerleitungen		STD, M91
  // ################################################################################################################
  var sDTKAttribute = "O_ADEREND_M91_G150";
  var sCB_Attribute = "CB_" + sDTKAttribute;
  /**
   * KAG: STD, M91
   * CB: CB_O_ADEREND_M91_G150
   *
   * VT:
   * 	n.n. VT_G150_M00123	Verriegelung Optionen - Einbaugeraet II
   */
  // ################################################################################################################

  // ################################################################################################################
  // O_SONDERLACK_Y09_G150	Schrank-Sonderlackierung					NON, Y09
  //	OE_LACK_G150	(Y09) Schrank-Sonderlackierung - RAL Farbe:
  // ################################################################################################################
  var sDTKAttribute = "O_SONDERLACK_Y09_G150";

  /**
   * KAG: NON, Y09
   *
   * VT:
   * 	n.n. VT_G150_M00088	Verriegelung Optionen - Einbaugeraet V
   */

  if (ECL_ValueEnabled("O_SONDERLACK_Y09_G150", "Y09")) {
    ECL_ActivateAttribute("OE_LACK_G150");
  } else {
    ECL_DeactivateAttribute("OE_LACK_G150");
  }

  if (strchangedAttribute == "OE_LACK_G150") {
    var sValueNorm = normalizeOE_Attribute("OE_LACK_G150");
    if (sValueNorm == "") {
      ECL_SetValue("O_SONDERLACK_Y09_G150", "NON");
    } else {
      ECL_SetValue("O_SONDERLACK_Y09_G150", "Y09");
    }
  }
  // ################################################################################################################

  // ################################################################################################################
  // O_NAMUR_B00_G150	Namur Klemmenleiste						NON, B00
  // ################################################################################################################
  var sDTKAttribute = "O_NAMUR_B00_G150";
  var sCB_Attribute = "CB_" + sDTKAttribute;
  /**
   * KAG: NON, B00
   * CB: CB_O_NAMUR_B00_G150
   * 
   * VT:
   * 	VT_G150_M00086	gueltige Optionen Ausfuehrung IV
   * 		IN_AUSFUEHRUNG_G150		O_BREMSEINHEIT_G150		O_NAMUR_B00_G150	O_USV_B02_G150		O_FREMD_B03_G150
    n.n. VT_G150_M00089	Verriegelung Optionen - Einbaugeraet VI
    VT_G150_M00107	Einschraenkungen_MLFB_B00_L13_L26
      HMK_FALLNUMMER_G150		MLFB11_G150		O_NAMUR_B00_G150	O_SCHUETZ_L13_G150	O_SCHALTER_L26_G150
  */
  // VT_G150_M00086	gueltige Optionen Ausfuehrung IV
  //		IN_AUSFUEHRUNG_G150		O_BREMSEINHEIT_G150		O_NAMUR_B00_G150	O_USV_B02_G150	O_FREMD_B03_G150
  var O_BREMSEINHEIT_G150 = ECL_GetValue("O_BREMSEINHEIT_G150");

  var O_USV_B02_G150 = "NON";
  if (ECL_ValueSelected("CB_O_USV_B02_G150", "T")) {
    var O_USV_B02_G150 = "B02";
  }
  var O_FREMD_B03_G150 = "NON";
  if (ECL_ValueSelected("CB_O_FREMD_B03_G150", "T")) {
    var O_FREMD_B03_G150 = "B03";
  }

  var sTable = "VT_G150_M00086" + sDB_Suffix;
  var sWhere =
    "IN_AUSFUEHRUNG_G150 = '" +
    IN_AUSFUEHRUNG_G150 +
    "' AND " +
    "O_BREMSEINHEIT_G150 = '" +
    O_BREMSEINHEIT_G150 +
    "' AND " +
    "O_USV_B02_G150 = '" +
    O_USV_B02_G150 +
    "' AND " +
    "O_FREMD_B03_G150 = '" +
    O_FREMD_B03_G150 +
    "';";

  var sStatus = SetAttributeLogic_Checkbox(sTable, sDTKAttribute, sCB_Attribute, "B00", "NON", sWhere, false);

  if (sStatus == "Error") {
    strError = "DICT1_ERR_G150___PL_B00";
    return strError;
  }
  // --------------------------------------------------------------------------------------------
  // VT_G150_M00107	Einschraenkungen_MLFB_B00_L13_L26
  //		HMK_FALLNUMMER_G150		MLFB11_G150		O_NAMUR_B00_G150	O_SCHUETZ_L13_G150	O_SCHALTER_L26_G150

  var O_SCHUETZ_L13_G150 = "STD";
  if (ECL_ValueSelected("CB_O_SCHUETZ_L13_G150", "T")) {
    O_SCHUETZ_L13_G150 = "L13";
  }
  var O_SCHALTER_L26_G150 = "STD";
  if (ECL_ValueSelected("CB_O_SCHALTER_L26_G150", "T")) {
    O_SCHALTER_L26_G150 = "L26";
  }

  var sTable = "VT_G150_M00107" + sDB_Suffix;
  var sWhere =
    "HMK_FALLNUMMER_G150 = '" +
    HMK_FALLNUMMER_G150 +
    "' AND " +
    "MLFB11_G150 = '" +
    MLFB11_G150 +
    "' AND " +
    "O_SCHALTER_L26_G150 = '" +
    O_SCHALTER_L26_G150 +
    "' AND " +
    "O_SCHUETZ_L13_G150 = '" +
    O_SCHUETZ_L13_G150 +
    "';";

  var sStatus = SetAttributeLogic_Checkbox(sTable, sDTKAttribute, sCB_Attribute, "B00", "NON", sWhere, true);

  if (sStatus == "Error") {
    strError = "DICT1_ERR_G150___PL_B00";
    return strError;
  }

  // ################################################################################################################

  // ################################################################################################################
  // O_USV_B02_G150	Sicher getrennte 24-V-Versorgung			NON, B02
  // ################################################################################################################
  var sDTKAttribute = "O_USV_B02_G150";
  var sCB_Attribute = "CB_" + sDTKAttribute;
  /**
   * KAG: NON, B02
   * CB: CB_O_USV_B02_G150
   * 
   * VT:
   * 	VT_G150_M00086	gueltige Optionen Ausfuehrung IV
   * 		IN_AUSFUEHRUNG_G150		O_BREMSEINHEIT_G150		O_NAMUR_B00_G150	O_USV_B02_G150		O_FREMD_B03_G150
    n.n. VT_G150_M00089	Verriegelung Optionen - Einbaugeraet VI
  */
  var O_NAMUR_B00_G150 = "NON";
  if (ECL_ValueSelected("CB_O_NAMUR_B00_G150", "T")) {
    O_NAMUR_B00_G150 = "B00";
  }
  var O_FREMD_B03_G150 = "NON";
  if (ECL_ValueSelected("CB_O_FREMD_B03_G150", "T")) {
    O_FREMD_B03_G150 = "B03";
  }

  var sTable = "VT_G150_M00086" + sDB_Suffix;
  var sWhere =
    "IN_AUSFUEHRUNG_G150 = '" +
    IN_AUSFUEHRUNG_G150 +
    "' AND " +
    "O_BREMSEINHEIT_G150 = '" +
    O_BREMSEINHEIT_G150 +
    "' AND " +
    "O_NAMUR_B00_G150 = '" +
    O_NAMUR_B00_G150 +
    "' AND " +
    "O_FREMD_B03_G150 = '" +
    O_FREMD_B03_G150 +
    "';";

  var sStatus = SetAttributeLogic_Checkbox(sTable, sDTKAttribute, sCB_Attribute, "B02", "NON", sWhere, false);

  if (sStatus == "Error") {
    strError = "DICT1_ERR_G150___PL_B02";
    return strError;
  }
  // ################################################################################################################

  // ################################################################################################################
  // O_FREMD_B03_G150	Fremdabgang externe Hilfsbetriebe		NON, B03
  // ################################################################################################################
  var sDTKAttribute = "O_FREMD_B03_G150";
  var sCB_Attribute = "CB_" + sDTKAttribute;
  /**
   * KAG: NON, B03
   * CB: CB_O_FREMD_B03_G150
   * 
   * VT:
      VT_G150_M00086	gueltige Optionen Ausfuehrung IV
        IN_AUSFUEHRUNG_G150		O_BREMSEINHEIT_G150		O_NAMUR_B00_G150	O_USV_B02_G150		O_FREMD_B03_G150
    n.n. VT_G150_M00089	Verriegelung Optionen - Einbaugeraet VI
  */
  var O_NAMUR_B00_G150 = "NON";
  if (ECL_ValueSelected("CB_O_NAMUR_B00_G150", "T")) {
    var O_NAMUR_B00_G150 = "B00";
  }
  var O_USV_B02_G150 = "NON";
  if (ECL_ValueSelected("CB_O_USV_B02_G150", "T")) {
    var O_USV_B02_G150 = "B02";
  }

  var sTable = "VT_G150_M00086" + sDB_Suffix;
  var sWhere =
    "IN_AUSFUEHRUNG_G150 = '" +
    IN_AUSFUEHRUNG_G150 +
    "' AND " +
    "O_BREMSEINHEIT_G150 = '" +
    O_BREMSEINHEIT_G150 +
    "' AND " +
    "O_NAMUR_B00_G150 = '" +
    O_NAMUR_B00_G150 +
    "' AND " +
    "O_USV_B02_G150 = '" +
    O_USV_B02_G150 +
    "';";

  var sStatus = SetAttributeLogic_Checkbox(sTable, sDTKAttribute, sCB_Attribute, "B03", "NON", sWhere, false);

  if (sStatus == "Error") {
    strError = "DICT1_ERR_G150___PL_B03";
    return strError;
  }

  // ################################################################################################################

  // ################################################################################################################
  // O_SCHIFF_M66_G150	Schiffsausführung						STD, M66
  // ################################################################################################################
  var sDTKAttribute = "O_SCHIFF_M66_G150";
  var sCB_Attribute = "CB_" + sDTKAttribute;
  /**
   * KAG: STD, M66
   * CB: CB_O_SCHIFF_M66_G150
   * 
   * VT:
   E 	VT_G150_M00059	gueltige Optionen Schiff/Zertifikat
        O_SCHIFF_M66_G150	O_ZERTIFITKAT_G150
    n.n. VT_G150_M00060	Verriegelung Anwendung - M66
      HMK_ANWENDUNG_G150	O_SCHIFF_M66_G150
  B	VT_G150_M00111	Einschraenkungen_M66_L01
      O_CLEAN_L01_G150	O_SCHIFF_M66_G150
  C	VT_G150_M00112	Einschraenkungen_M66_L55
      O_SCHIFF_M66_G150	O_STILLST_L55_G150
  A	VT_G150_M00113	Einschraenkungen_MLFB_M66
      HMK_FALLNUMMER_G150		MLFB11_G150		O_SCHIFF_M66_G150
  D	VT_G150_M00140	Hilfsspannungsversorgung - M66
      O_HILFSSPG_INTERN_G150		O_SCHIFF_M66_G150
  */
  // A VT_G150_M00113	Einschraenkungen_MLFB_M66
  //		HMK_FALLNUMMER_G150		MLFB11_G150		O_SCHIFF_M66_G150
  var sTable = "VT_G150_M00113" + sDB_Suffix;
  var sWhere = "HMK_FALLNUMMER_G150 = '" + HMK_FALLNUMMER_G150 + "' AND " + "MLFB11_G150 = '" + MLFB11_G150 + "';";

  var sStatus = SetAttributeLogic_Checkbox(sTable, sDTKAttribute, sCB_Attribute, "M66", "STD", sWhere, false);

  if (sStatus == "Error") {
    strError = "DICT1_ERR_G150___PL_M66";
    return strError;
  }
  // --------------------------------------------------------------------------------------------
  // B VT_G150_M00111	Einschraenkungen_M66_L01
  //		O_CLEAN_L01_G150	O_SCHIFF_M66_G150
  var O_CLEAN_L01_G150 = "STD";
  if (ECL_ValueSelected("CB_O_CLEAN_L01_G150", "T")) {
    O_CLEAN_L01_G150 = "L01";
  }

  var sTable = "VT_G150_M00111" + sDB_Suffix;
  var sWhere = "O_CLEAN_L01_G150 = '" + O_CLEAN_L01_G150 + "';";

  var sStatus = SetAttributeLogic_Checkbox(sTable, sDTKAttribute, sCB_Attribute, "M66", "STD", sWhere, true);

  if (sStatus == "Error") {
    strError = "DICT1_ERR_G150___PL_M66";
    return strError;
  }

  // --------------------------------------------------------------------------------------------
  // C VT_G150_M00112	Einschraenkungen_M66_L55
  //		O_SCHIFF_M66_G150	O_STILLST_L55_G150
  var O_STILLST_L55_G150 = "NON";
  if (ECL_ValueSelected("CB_O_STILLST_L55_G150", "T")) {
    O_STILLST_L55_G150 = "L55";
  }

  var sTable = "VT_G150_M00112" + sDB_Suffix;
  var sWhere = "O_STILLST_L55_G150 = '" + O_STILLST_L55_G150 + "';";

  var sStatus = SetAttributeLogic_Checkbox(sTable, sDTKAttribute, sCB_Attribute, "M66", "STD", sWhere, true);

  if (sStatus == "Error") {
    strError = "DICT1_ERR_G150___PL_M66";
    return strError;
  }

  // --------------------------------------------------------------------------------------------
  // D VT_G150_M00140	Hilfsspannungsversorgung - M66
  //		O_HILFSSPG_INTERN_G150		O_SCHIFF_M66_G150
  var O_HILFSSPG_INTERN_G150 = ECL_GetValue("O_HILFSSPG_INTERN_G150");

  var sTable = "VT_G150_M00140" + sDB_Suffix;
  var sWhere = "O_HILFSSPG_INTERN_G150 = '" + O_HILFSSPG_INTERN_G150 + "';";

  var sStatus = SetAttributeLogic_Checkbox(sTable, sDTKAttribute, sCB_Attribute, "M66", "STD", sWhere, true);

  if (sStatus == "Error") {
    strError = "DICT1_ERR_G150___PL_M66";
    return strError;
  }
  // --------------------------------------------------------------------------------------------
  // E VT_G150_M00059	gueltige Optionen Schiff/Zertifikat
  //		O_SCHIFF_M66_G150	O_ZERTIFITKAT_G150
  var O_ZERTIFITKAT_G150 = ECL_GetValue("O_ZERTIFITKAT_G150");

  var sTable = "VT_G150_M00059" + sDB_Suffix;
  var sWhere = "O_ZERTIFITKAT_G150 = '" + O_ZERTIFITKAT_G150 + "';";

  var sStatus = SetAttributeLogic_Checkbox(sTable, sDTKAttribute, sCB_Attribute, "M66", "STD", sWhere, true);

  if (sStatus == "Error") {
    strError = "DICT1_ERR_G150___PL_M66";
    return strError;
  }
  // ################################################################################################################

  // ################################################################################################################
  // O_ZERTIFITKAT_G150	Einzelzertifikat						NON, E21, E31, E51, E61, E71
  // ################################################################################################################
  var sDTKAttribute = "O_ZERTIFITKAT_G150";
  /**
   * KAG: NON, E21, E31, E51, E61, E71
   * 
   * VT:
   * 	VT_G150_M00022	gueltige Optionen CleanPower/Zertifikate
   * 		O_CLEAN_L01_G150	O_ZERTIFITKAT_G150	O_SCHUTZART_G150
    VT_G150_M00059	gueltige Optionen Schiff/Zertifikat
      O_SCHIFF_M66_G150	O_ZERTIFITKAT_G150
  */
  var O_CLEAN_L01_G150 = "STD";
  if (ECL_ValueSelected("CB_O_CLEAN_L01_G150", "T")) {
    var O_CLEAN_L01_G150 = "L01";
  }
  var O_SCHUTZART_G150 = ECL_GetValue("O_SCHUTZART_G150");

  var sTable = "VT_G150_M00022" + sDB_Suffix;
  var sWhere = "O_CLEAN_L01_G150 = '" + O_CLEAN_L01_G150 + "' AND " + "O_SCHUTZART_G150 = '" + O_SCHUTZART_G150 + "';";

  var sStatus = SetAttributeLogic1st(sTable, sDTKAttribute, sWhere);

  if (sStatus == "Error") {
    strError = "DICT1_ERR_G150___PL_O_ZERTIFITKAT";
    return strError;
  }
  // --------------------------------------------------------------------------------------------
  // VT_G150_M00059	gueltige Optionen Schiff/Zertifikat
  //		O_SCHIFF_M66_G150	O_ZERTIFITKAT_G150

  var O_SCHIFF_M66_G150 = "STD";
  if (ECL_ValueSelected("CB_O_SCHIFF_M66_G150", "T")) {
    var O_SCHIFF_M66_G150 = "M66";
  }

  var sTable = "VT_G150_M00059" + sDB_Suffix;
  var sWhere = "O_SCHIFF_M66_G150 = '" + O_SCHIFF_M66_G150 + "';";

  var sStatus = SetAttributeLogic2nd(sTable, sDTKAttribute, sWhere);

  if (sStatus == "Error") {
    strError = "DICT1_ERR_G150___PL_O_ZERTIFITKAT";
    return strError;
  }
  // ################################################################################################################

  // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  // Optionen 4	Optionen 4	Optionen 4	-	DOKUMENTATION / PRUEFUNG	-	Optionen 4	Optionen 4	Optionen 4
  // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

  // ################################################################################################################
  // O_SPRACHE_SCHILD_G150	Leistungsschildangaben			NON, T58, T60, T80, T85, T91
  // ################################################################################################################
  var sDTKAttribute = "O_SPRACHE_SCHILD_G150";
  /**
   * KAG: NON, T58, T60, T80, T85, T91
   *
   * VT:
   * 	n.n. VT_G150_M00124	Verriegelung Optionen - Einbaugeraet VII
   */

  // ################################################################################################################

  // ################################################################################################################
  // O_DOKU_SPRACHE_G150		Dokumentationssprache			NON, D58, D60, D80, D91, D94
  // ################################################################################################################
  var sDTKAttribute = "O_DOKU_SPRACHE_G150";
  /**
   * KAG: NON, D58, D60, D80, D91, D94
   *
   * VT:
   * 	n.n. VT_G150_M00124	Verriegelung Optionen - Einbaugeraet VII
   */

  // ################################################################################################################

  // ################################################################################################################
  // O_FLOWCHARTS_G150		Fertigungsablaufpläne			B43, B44, B45
  // ################################################################################################################
  var sDTKAttribute = "O_FLOWCHARTS_G150";
  /**
   * KAG: B43, B44, B45
   *
   * VT:
   * 	keine
   */

  // ################################################################################################################

  // ################################################################################################################
  // O_DOKU_D01_G150			Kundendokumentation im EPLAN-Format			STD, D01
  // ################################################################################################################
  var sDTKAttribute = "O_DOKU_D01_G150";
  var sCB_Attribute = "CB_" + sDTKAttribute;
  /**
   * KAG: STD, D01
   * CB: CB_O_DOKU_D01_G150
   *
   *
   */

  // ################################################################################################################

  // ################################################################################################################
  // O_DOKU_D02_G150			Kundendokumentation im DXF-Format			STD, D02
  // ################################################################################################################
  var sDTKAttribute = "O_DOKU_D02_G150";
  var sCB_Attribute = "CB_" + sDTKAttribute;
  /**
   * KAG: STD, D02
   * CB: CB_O_DOKU_D02_G150
   *
   * VT:
   * n.n. VT_G150_M00124	Verriegelung Optionen - Einbaugeraet VII
   */

  // ################################################################################################################

  // ################################################################################################################
  // O_DOKU_D14_G150			Vorab-Erstellung der Kundendokumentation	STD, D14
  // ################################################################################################################
  var sDTKAttribute = "O_DOKU_D14_G150";
  var sCB_Attribute = "CB_" + sDTKAttribute;
  /**
   * KAG: STD, D14
   * CB: CB_O_DOKU_D14_G150
   *
   * VT:
   * n.n. VT_G150_M00124	Verriegelung Optionen - Einbaugeraet VII
   */

  // ################################################################################################################

  // ################################################################################################################
  // O_DOKU_D00_G150			Dokumentation in Einzelsprache, Deutsch		STD, D00
  // ################################################################################################################
  var sDTKAttribute = "O_DOKU_D00_G150";
  var sCB_Attribute = "CB_" + sDTKAttribute;
  /**
   * KAG: STD, D00
   * CB: CB_O_DOKU_D00_G150
   *
   * VT:
   * n.n. VT_G150_M00124	Verriegelung Optionen - Einbaugeraet VII
   */

  // ################################################################################################################

  // ################################################################################################################
  // O_DOKU_D56_G150			Dokumentation in Einzelsprache, Russisch	STD, D56
  // ################################################################################################################
  var sDTKAttribute = "O_DOKU_D56_G150";
  var sCB_Attribute = "CB_" + sDTKAttribute;
  /**
   * KAG: STD, D56
   * CB: CB_O_DOKU_D56_G150
   *
   * VT:
   * n.n. VT_G150_M00124	Verriegelung Optionen - Einbaugeraet VII
   */

  // ################################################################################################################

  // ################################################################################################################
  // O_DOKU_D72_G150			Dokumentation in Einzelsprache, Italienisch	STD, D72
  // ################################################################################################################
  var sDTKAttribute = "O_DOKU_D72_G150";
  var sCB_Attribute = "CB_" + sDTKAttribute;
  /**
   * KAG: STD, D72
   * CB: CB_O_DOKU_D72_G150
   *
   * VT:
   * n.n. VT_G150_M00124	Verriegelung Optionen - Einbaugeraet VII
   */

  // ################################################################################################################

  // ################################################################################################################
  // O_DOKU_D76_G150			Dokumentation in Einzelsprache, Englisch	STD, D76
  // ################################################################################################################
  var sDTKAttribute = "O_DOKU_D76_G150";
  var sCB_Attribute = "CB_" + sDTKAttribute;
  /**
   * KAG: STD, D76
   * CB: CB_O_DOKU_D76_G150
   *
   * VT:
   * n.n. VT_G150_M00124	Verriegelung Optionen - Einbaugeraet VII
   */

  // ################################################################################################################

  // ################################################################################################################
  // O_DOKU_D77_G150			Dokumentation in Einzelsprache, Französisch	STD, D77
  // ################################################################################################################
  var sDTKAttribute = "O_DOKU_D77_G150";
  var sCB_Attribute = "CB_" + sDTKAttribute;
  /**
   * KAG: STD, D77
   * CB: CB_O_DOKU_D77_G150
   *
   * VT:
   * n.n. VT_G150_M00124	Verriegelung Optionen - Einbaugeraet VII
   */

  // ################################################################################################################

  // ################################################################################################################
  // O_DOKU_D78_G150			Dokumentation in Einzelsprache, Spanisch	STD, D78
  // ################################################################################################################
  var sDTKAttribute = "O_DOKU_D78_G150";
  var sCB_Attribute = "CB_" + sDTKAttribute;
  /**
   * KAG: STD, D78
   * CB: CB_O_DOKU_D78_G150
   *
   * VT:
   * n.n. VT_G150_M00124	Verriegelung Optionen - Einbaugeraet VII
   */

  // ################################################################################################################

  // ################################################################################################################
  // O_DOKU_D84_G150			Dokumentation in Einzelsprache, Chinesisch	STD, D84
  // ################################################################################################################
  var sDTKAttribute = "O_DOKU_D84_G150";
  var sCB_Attribute = "CB_" + sDTKAttribute;
  /**
   * KAG: STD, D84
   * CB: CB_O_DOKU_D84_G150
   *
   * VT:
   * n.n. VT_G150_M00124	Verriegelung Optionen - Einbaugeraet VII
   */

  // ################################################################################################################

  // ################################################################################################################
  // OZ_EPLAN_MLFB_G150		EPLAN Electric P8 Projekt-Dokumentation für SINAMICS Schrankgeräte		FALSE, 6SL3780-0AK00-0AA0
  // ################################################################################################################
  //var sDTKAttribute = "OZ_EPLAN_MLFB_G150";
  //var sCB_Attribute = "CB_" + sDTKAttribute;
  /**	EDIT 02/2024 ersetzt durch D01 KAG
   * KAG: FALSE, 6SL3780-0AK00-0AA0
   * CB: CB_OZ_EPLAN_MLFB_G150
   *
   * VT:
   * keine
   */

  // ################################################################################################################

  // ################################################################################################################
  // O_FUNCTION_TEST_G150	    Function test			              NON, F03, F71, F72, F74, F75
  // ################################################################################################################
  var sDTKAttribute = "O_FUNCTION_TEST_G150";
  var sCB_Attribute = "CB_" + sDTKAttribute;
  /**
   * KAG: NON, F03, F71, F72, F74, F75
   * CB: CB_O_FUNCTION_TEST_G150
   *
   * VT:
   * keine
   */

  // ################################################################################################################

  // ################################################################################################################
  // O_INSULATION_TEST_G150		Isolationsprüfung									NON, F77, F76
  // ################################################################################################################
  var sDTKAttribute = "O_INSULATION_TEST_G150";
  var sCB_Attribute = "CB_" + sDTKAttribute;
  /**
   * KAG: NON, F77, F76
   * CB: CB_O_INSULATION_TEST_G150
   * VT:
   * keine
   */

  // ################################################################################################################

  // ################################################################################################################
  // O_ABNAHME_F97_G150			Kundenspezifische Abnahme							NON, F97
  // ################################################################################################################
  var sDTKAttribute = "O_ABNAHME_F97_G150";
  var sCB_Attribute = "CB_" + sDTKAttribute;
  /**
   * KAG: NON, F97
   * CB: CB_O_ABNAHME_F97_G150
   *
   * VT:
   * keine
   */

  // ################################################################################################################

  // ################################################################################################################
  // HMK_DRV_SIM_DESIGNER_G150	DriveSim Designer Simulation		T,F     CB_DRV_SIM_DESIGNER_G150
  // ################################################################################################################
  // Sec-MLFB: 9SV11103AA000AA0 (VT_G150_M00154)
  /*VT_G150_M00154
    HMK_DRV_SIM_DESIGNER_G150 HMK_MLFB_DRV_SIM_DES_G150
  */


  // ################################################################################################################

  // !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
  /*
  n.n. HMK_ANWENDUNG_G150	Anwendung
  HMK_FALLNUMMER_G150	Fallnummer

  */

  // ################################################################################################################
  // Safety-context
  // ################################################################################################################
  /* if single-connection (MLFB08 ==1) K50+K52 is mandatory for
        SOS	    6
        SS2	    5
        SBT	    12
    if parallel connection MLFB08==2 K50+K52 is mandatory for
        SS1-a/SS1-r 	14
        SOS             6
        SS2	            5
        SLS	            2
        SSM	            4
        SDI	            3
        SBT	            12
    
  if SBC	11 K88 is mandatory
  */

  var ECSI_CX_SafetyFunctions = ECL_GetValue("ECSI_CX_SafetyFunctions");
  var aSafetyFunctions = ECSI_CX_SafetyFunctions.split(";");
  var bK50Mandatory = false;
  var bK51Mandatory = false;
  var bK52Mandatory = false;
  var bK88Mandatory = false;

  if (aSafetyFunctions && aSafetyFunctions.length > 0 && MLFB08_G150 == "1") {
    for (var i = 0; i < aSafetyFunctions.length; i++) {
      if (aSafetyFunctions[i] == "5" || aSafetyFunctions[i] == "6" || aSafetyFunctions[i] == "12") {
        bK50Mandatory = true;
        bK52Mandatory = true;
        break;
      }
    }
    for (var i = 0; i < aSafetyFunctions.length; i++) {
      if (
        aSafetyFunctions[i] == "2" ||
        aSafetyFunctions[i] == "3" ||
        aSafetyFunctions[i] == "4" ||
        aSafetyFunctions[i] == "5" ||
        aSafetyFunctions[i] == "6" ||
        aSafetyFunctions[i] == "12" ||
        aSafetyFunctions[i] == "14"
      ) {
        bK51Mandatory = true;
        break;
      }
    }
    for (var i = 0; i < aSafetyFunctions.length; i++) {
      if (aSafetyFunctions[i] == "11") {
        bK88Mandatory = true;
        break;
      }
    }
  } else if (aSafetyFunctions && aSafetyFunctions.length > 0 && MLFB08_G150 == "2") {
    for (var i = 0; i < aSafetyFunctions.length; i++) {
      if (
        aSafetyFunctions[i] == "2" ||
        aSafetyFunctions[i] == "3" ||
        aSafetyFunctions[i] == "4" ||
        aSafetyFunctions[i] == "5" ||
        aSafetyFunctions[i] == "6" ||
        aSafetyFunctions[i] == "12" ||
        aSafetyFunctions[i] == "14"
      ) {
        bK50Mandatory = true;
        bK51Mandatory = true;
        bK52Mandatory = true;
        break;
      }
    }
    for (var i = 0; i < aSafetyFunctions.length; i++) {
      if (aSafetyFunctions[i] == "11") {
        bK88Mandatory = true;
        break;
      }
    }
  }

  if (bK50Mandatory) {
    ECL_DisableAttribute("O_MODULE_G150");
  } else {
    ECL_EnableAttribute("O_MODULE_G150");
  }
  if (bK51Mandatory) {
    ECL_DisableAttribute("CB_O_SAFETY_LIZENZ_K01__G150");
  } else {
    ECL_EnableAttribute("CB_O_SAFETY_LIZENZ_K01__G150");
  }
  if (bK52Mandatory || O_MODULE_G150 != "K50") {
    ECL_DisableAttribute("CB_O_ZUS_SMC30_K52_G150");
  } else {
    ECL_EnableAttribute("CB_O_ZUS_SMC30_K52_G150");
  }
  if (bK88Mandatory) {
    ECL_DisableAttribute("CB_O_SAFETY_SBA_K88_G150");
  } else {
    ECL_EnableAttribute("CB_O_SAFETY_SBA_K88_G150");
  }

  // #############################################################################################################
  // #############################################################################################################

  return "OK";
}
