﻿//@legacy
//#mode(full-ecma)


// ---------------------------------------------------------
// Script for configuration object CFG_SIEMENS_G150
// 	Date: 2023-06-20
// 	User: Administrator
// ---------------------------------------------------------

//@import "CFG_G150_VT.js"

/**
	
*/

function SetOptionsSecMLFB_Init(oData) {
	if (oData && !isEmpty(oData)) {
		SetDrvSimDesigner(oData);
	} else {

		ECL_DeselectAttribute("CB_DRV_SIM_DESIGNER_G150");
	}
}

// ################################################################################################################
// HMK_DRV_SIM_DESIGNER_G150	DriveSim Designer Simulation		T,F     CB_DRV_SIM_DESIGNER_G150
// ################################################################################################################
// Sec-MLFB: 9SV11103AA000AA0 (VT_G150_M00154)
/*VT_G150_M00154
HMK_DRV_SIM_DESIGNER_G150 HMK_MLFB_DRV_SIM_DES_G150
*/
function SetDrvSimDesigner(oData) {
	ECL_DeselectAttribute("CB_DRV_SIM_DESIGNER_G150");

	var sECSI_MLFB_SEC = GetMlfbSec() || "";
	if (sECSI_MLFB_SEC !== "") {
		var sTableName = "VT_G150_M00154" + sDB_Suffix;
		var sSQL = "SELECT DISTINCT HMK_MLFB_DRV_SIM_DES_G150 FROM " + sTableName + " WHERE HMK_DRV_SIM_DESIGNER_G150 = 'T';";

		var aResult = GetDBDataSetEXT(sSQL);
		if (aResult.length > 0) {
			var HMK_MLFB_DRV_SIM_DES_G150 = aResult[0]["HMK_MLFB_DRV_SIM_DES_G150"];

			var secondaryMlfbArray = sECSI_MLFB_SEC.split(";");

			for (var i = 0; i < secondaryMlfbArray.length; i++) {
				if (secondaryMlfbArray[i] === HMK_MLFB_DRV_SIM_DES_G150) {
					ECL_SelectValue("CB_DRV_SIM_DESIGNER_G150", "T");
				}
			}
		} else {
			oData.strError = "DICT1_ERR_G150___SEC_MLFB_DRV_SIM";
			return oData;
		}
	}

}

// ################################################################################################################


// #########################################################################################################################

function genSecMLFB() {
	var sECSI_MLFB_SEC = "";

	var aResult = Object.fromDatabase("G150_ADD_DATA", "SELECT DISTINCT Attribute, Wert_ID, CB_Attribute FROM DATA WHERE IsSecMLFB = 'x';");
	for (var i = 0; i < aResult.length; i++) {
		var attrname = aResult[i]['ATTRIBUTE'];
		var attrnameCB = aResult[i]['CB_ATTRIBUTE'];
		if (ECL_ValueSelected(attrnameCB, "T")) {
			var sSecMLFB = aResult[i]['WERT_ID'];
			sSecMLFB = repalce(sSecMLFB, "-", "");

			if (sECSI_MLFB_SEC.length > 0) {
				sECSI_MLFB_SEC += ";" + sSecMLFB;
			} else {
				sECSI_MLFB_SEC = sSecMLFB;
			}
		}
	}
	// DriveSim Designer Simulation
	// MLFB from Database
	if (ECL_ValueSelected("CB_DRV_SIM_DESIGNER_G150", "T")) {
		var sTableName = "VT_G150_M00154" + sDB_Suffix;
		var sSQL = "SELECT DISTINCT HMK_MLFB_DRV_SIM_DES_G150 FROM " + sTableName + " WHERE HMK_DRV_SIM_DESIGNER_G150 = 'T';";

		var aResult = GetDBDataSetEXT(sSQL);
		if (aResult.length > 0) {
			var HMK_MLFB_DRV_SIM_DES_G150 = aResult[0]["HMK_MLFB_DRV_SIM_DES_G150"];
			if (sECSI_MLFB_SEC.length > 0) {
				sECSI_MLFB_SEC += ";" + HMK_MLFB_DRV_SIM_DES_G150;
			} else {
				sECSI_MLFB_SEC = HMK_MLFB_DRV_SIM_DES_G150;
			}
		} else {
			//oData.strError = "DICT1_ERR_G150___SEC_MLFB_DRV_SIM";
			return "ERROR";
		}

	}

	return sECSI_MLFB_SEC;

}