﻿//@legacy
//#mode(full-ecma)

//@import "StringHandler.js"
//@import "Parser.common.js"
//@import "Parser.tokenizer.js"

//@import "../G150_MLFB/Base.misc.js"
//@import "../G150_CONFIG/CFG_G150_VT.js"

/**
 * @category   G150 Parser
 * @package    Parser
 * @copyright  Copyright (c) 2023 Plan Software GmbH (http://www.plansoft.de)
 */
function parse_Init_G150(strMLFB) {
  var vtTimeStart = Date.getTime();

  var oParsing = {
    strBaseMLFB: "",
    strFullMLFB: "",
    strError: "",
    strWarning: "",
    aTokens: [],
    oFreetext: {},
  };

  var strBaseTypeMLFB = ECL_GetValue("ECSI_MLFB_BASE_TYPE");

  // if wrong product in strMLFB, set basetype to mlfb
  var strBaseTypeMLFB_Product = strBaseTypeMLFB.substring(0, 7);
  var strMLFB_Product = strMLFB.substring(0, 7);
  if (strMLFB_Product !== strBaseTypeMLFB_Product) {
    strMLFB = strBaseTypeMLFB;
  }

  var strSeriesID = ECL_GetValue("ECSI_CX_SeriesID");
  oParsing.SeriesID = strSeriesID;

  strMLFB = normalizeMLFB(strMLFB);
  strBaseTypeMLFB = normalizeMLFB(strBaseTypeMLFB);

  ECL_SetValue("ECSI_MLFB", strMLFB);

  var strStartConfiguration = ECL_GetValue("ECSI_IS_START_CONFIGURATION");

  if (strStartConfiguration == "" && find(strMLFB.left(16), ".") >= 0) {
    strStartConfiguration = "1";
  }

  // todo Es kann vorkommen, dass die MLFB fehlerhalt ist bei Keep Configuration, dann soll die BaseType MLFB genommen werden ohne Keep Configuration
  /*if (strStartConfiguration == "1" && find(strMLFB.left(16), ".") >= 0 && strBaseTypeMLFB != "") {
    strMLFB = strBaseTypeMLFB;
  }*/

  // supported safety functions:
  /** verschieben in MAIN-Skript
   * Basic functions
   * 	STO, SS1 (with K82 todo klären, ob immer K82 oder nur wenn nicht über CU oder PROFIsafe?)
   * 	SBC with K88
   *
   * Extended functions (license needed K01)
   *
   * for safety functions with encoder: +K50 +K52
   * */
  // SBC
  var sECSI_CX_SafetyFunctions = ECL_GetValue("ECSI_CX_SafetyFunctions");
  if (
    sECSI_CX_SafetyFunctions &&
    sECSI_CX_SafetyFunctions !== "" &&
    sECSI_CX_SafetyFunctions.indexOf("11") > -1
  ) {
    var bSBTmandatory = true;
    oParsing.SBTmandatory = "true";
    oParsing.K88_mandatory = "true";
  } else {
    oParsing.SBTmandatory = "false";
    oParsing.K88_mandatory = "false";
  }

  //Entweder kommt eine zur Haupt MLFB unterschiedliche Base Type MLFB aus dem SIZER.
  //Hier sollen dann möglichst viele Attribute beibehalten werden.
  //Die Basetype MLFB kann sich in MLFB und KAGs von der Haupt MLFB unterscheiden.
  if (strBaseTypeMLFB != "") {
    //--------------------------------------------------------------------------------------------------------
    // Base Type  MLFB aufbereiten
    //--------------------------------------------------------------------------------------------------------
    var nFreetextBT = find(strBaseTypeMLFB, "{");
    var strFreetextBT = "";
    if (nFreetextBT > 0) {
      strFreetextBT = strBaseTypeMLFB.right(
        strBaseTypeMLFB.length - nFreetextBT + 1
      );
    }
    var oFreetextBT = parseFreetext(strFreetextBT, true);
    strBaseTypeMLFB = replace(strBaseTypeMLFB, strFreetextBT, "");
    var strFullMLFB_BT = strBaseTypeMLFB;

    var aBTComponents = tokenize(strBaseTypeMLFB);
    if (aBTComponents.length > 1) {
      // some @%$§/%%§ deliver the MLFB with some space between the last digit and the -Z for short descriptions ->
      // eliminate the resulting invalid short description 'Z'
      if (aBTComponents[1] === "Z" || aBTComponents[1] === "-Z") {
        aBTComponents = removeElementsFromArray(aBTComponents, 1, 1);
      }
    }

    strBaseTypeMLFB = aBTComponents[0];

    if (strBaseTypeMLFB.length === 17) {
      // eliminate the -Z
      strBaseTypeMLFB = strBaseTypeMLFB.substring(0, 16);
    }

    var strBaseTypeMLFB_fix = strBaseTypeMLFB;
  }

  var oResult;

  var nFreetext = find(strMLFB, "{");
  var strFreetext = "";
  if (nFreetext > 0) {
    strFreetext = strMLFB.right(strMLFB.length - nFreetext + 1);
  }
  oParsing.oFreetext = parseFreetext(strFreetext, true);
  strMLFB = replace(strMLFB, strFreetext, "");
  oParsing.strFullMLFB = strMLFB;

  var aComponents = tokenize(strMLFB);
  if (!aComponents.length) {
    oParsing.strError = "ERRORMSG_MLFB_G150___INVALID_MLFB";
    return oParsing;
  } else if (aComponents.length > 1) {
    // some @%$§/%%§ deliver the MLFB with some space between the last digit and the -Z for short descriptions ->
    // eliminate the resulting invalid short description 'Z'
    if (aComponents[1] === "Z" || aComponents[1] === "-Z") {
      aComponents = removeElementsFromArray(aComponents, 1, 1);
    }
  }
  oParsing.strBaseMLFB = aComponents[0];
  oParsing.aTokens = aComponents;

  var strMLFB_fix = strMLFB.substring(0, 16);

  // Wildcards at MLFB09, MLFB10, MLFB13, MLFB14, MLFB15

  if (strBaseTypeMLFB.charAt(13) == ".") {
    strMLFB_fix = replaceAt(strMLFB_fix, 13, ".");
  }

  // EDIT RepairConfig added
  if (
    strStartConfiguration == "1" &&
    strBaseTypeMLFB_fix == strMLFB_fix &&
    strBaseTypeMLFB != "" &&
    find(strMLFB.left(16), ".") < 0 &&
    find(strBaseTypeMLFB.left(16), ".") > 0
  ) {
    // if same motor is selected again
    var bRepairConfig = true;
  }
  var IsKeepConfig = "0";
  if (
    (strStartConfiguration == "1" &&
      strBaseTypeMLFB_fix !== strMLFB_fix &&
      find(strMLFB.left(16), ".") < 0 &&
      strBaseTypeMLFB !== "") ||
    (strStartConfiguration == "1" && find(strMLFB, "-Z ") > 0)
  ) {
    IsKeepConfig = "1";
    var bKeepConfig = true;
  }
  // EDIT KEEP CONF
  // -----------------------------------------------------------------------------------------------
  // Überprüfung, ob sich die MLFB im Vergleich zur Base Type MLFB unterscheidet
  // -----------------------------------------------------------------------------------------------
  if (bKeepConfig || bRepairConfig) {
    // -----------------------------------------------------------------------------------------------
    // KAG abgleichen und ggf übernehmen/entfernen
    // -----------------------------------------------------------------------------------------------

    // -----------------------------------------------------------------------------------------------
    // Platzhalter aus MLFB in BT übernehmen
    // -----------------------------------------------------------------------------------------------
    // possible wildcards at MLFB14

    var sBT_MLFB08 = strBaseTypeMLFB.charAt(7);

    // MLFB14 design (Ausführung)
    var sMLFB14 = strMLFB.charAt(13);
    var sBT_MLFB14 = strBaseTypeMLFB.charAt(13);

    if (sBT_MLFB14 == ".") {
      // todo check-routine
      // A Std, C compact (only if MLFB08 == 1)
      // sMLFB14 = check_MLFB14(strBaseTypeMLFB, sMLFB14);
      if (sBT_MLFB08 == "2") {
        sMLFB14 = "A";
      } else {
        if (sMLFB14 == "C") {
          // check-routine?
        }
      }
      strBaseTypeMLFB = replaceAt(strBaseTypeMLFB, 13, sMLFB14);
    }

    // -----------------------------------------------------------------------------------------------
    // Zuweisen der neuen MLFB und KAG-Liste
    strMLFB = strBaseTypeMLFB.substring(0, 16) + strMLFB.substring(16);

    oParsing.strBaseMLFB = strBaseTypeMLFB.substring(0, 16);
    oParsing.strFullMLFB = strMLFB;
    aComponents[0] = oParsing.strBaseMLFB;
    oParsing.aTokens = aComponents;
    ECL_SetValue("ECSI_MLFB", strMLFB);
    // END KEEP CONF
  } else {
    // --------------------------------------------------------------------------------------
    // Wildcards füllen
    // --------------------------------------------------------------------------------------
    // Wildcards at MLFB09, MLFB10, MLFB13, MLFB14, MLFB15
    if (find(strMLFB.left(16), ".") >= 0) {
      //Unvollständige SIZER MLFB

      // Prüfen, ob '.' an festen Stellen, dann Fehler
      for (var i = 0; i < 16; i++) {
        if (i == 13) {
          continue;
        }
        if (strMLFB.charAt(i) == ".") {
          oParsing.strError = "DICT1_ERR_G150___INCOMPLETE_MLFB";
          return oParsing;
        }
      }

      // Wenn an Stelle 14 ein Wildcard, dann Default setzen
      // MLFB14 design (Ausführung)
      if (strMLFB.charAt(13) == ".") {
        strMLFB = replaceAt(strMLFB, 13, "A"); // A Std, C compact (only if MNLFB08 == 1)
      }
    }

    oParsing.strBaseMLFB = strMLFB.substring(0, 16);
    oParsing.strFullMLFB = strMLFB;
    aComponents[0] = oParsing.strBaseMLFB;
    oParsing.aTokens = aComponents;
    //oParsing.oFreetext =
    ECL_SetValue("ECSI_MLFB", strMLFB);
  }

  if (oParsing.strBaseMLFB.length !== 16) {
    // Prüfen, ob die Zeichenkette 16 Stellen hat
    oParsing.strError = "ERRORMSG_MLFB_G150___PARSE_WRONG_SIZE";
    return oParsing;
  }

  if (oParsing.strBaseMLFB.indexOf("6SL371") < 0) {
    // Falsches Produkt
    oParsing.strError = "ERRORMSG_MLFB_G150___PARSE_WRONG_PRODUCT";
    return oParsing;
  }

  var oResult;
  oResult = parse_G150(oParsing.aTokens);
  //	oResult = add_help_shortcuts(oResult);

  if (oResult) {
    if (oResult.oProduct) oParsing.oProduct = oResult.oProduct;
    if (oResult.oParsingData) oParsing.oParsingData = oResult.oParsingData;
    oParsing.strError += (oParsing.strError ? " " : "") + oResult.strError;
    oParsing.strWarning +=
      (oParsing.strWarning ? " " : "") + oResult.strWarning;

    oParsing.IsStartConfig = strStartConfiguration;
    oParsing.IsKeepConfig = IsKeepConfig;
  }

  var vtTimeStop = Date.getTime();
  var vtTime = (vtTimeStop - vtTimeStart) / 1000;
  logtraceln("******* Parse - Time: " + vtTime + " sec" + "\n");

  return oParsing;
}

function parse_G150(aTokens) {
  var oResult = {
    strError: "",
    strRegion: "",
    strWarning: "",
    oProduct: null,
    oParsingData: {},
  };
  // #####################################################################################################################
  /* MLFB-Struktur
	// #####################################################################################################################
	MLFB01: 6SL3
	MLFB05: 3
	MLFB06: 7	Bauart Schrankgerät
	MLFB07: 0
	MLFB08: 1,2 (1) Einzelschaltung, (2) Parallelschaltung
	MLFB09: G
	MLFB10: Spannungsbereich [E,F,H]
	MLFB11: Leistung 1 
	MLFB12: Leistung 2 
	MLFB13: Leistung 3 
	MLFB14: . Ausführung A (Standard) oder C (kompakt), wenn MLFB08 == 2 ==> nur A
	MLFB15:	A 
	MLFB16:	3 
	*/
  var strBaseMLFB = aTokens[0];
  oResult.oParsingData.MLFB = {};
  //oResult.oParsingData.MLFB.POS1 = strBaseMLFB.charAt( 0 );	// 6
  oResult.oParsingData.MLFB.POS1_4 = strBaseMLFB.substring(0, 4); // 6SL3
  //oResult.oParsingData.MLFB.POS2 = strBaseMLFB.charAt( 1 );	// S
  //oResult.oParsingData.MLFB.POS3 = strBaseMLFB.charAt( 2 );	// L
  //oResult.oParsingData.MLFB.POS4 = strBaseMLFB.charAt( 3 );	// 3
  oResult.oParsingData.MLFB.POS5 = strBaseMLFB.charAt(4); // 3
  oResult.oParsingData.MLFB.POS6 = strBaseMLFB.charAt(5); // 7 Bauart Schrankgerät
  oResult.oParsingData.MLFB.POS7 = strBaseMLFB.charAt(6); // 0
  oResult.oParsingData.MLFB.POS8 = strBaseMLFB.charAt(7); // 1,2 (1) Einzelschaltung, (2) Parallelschaltung
  oResult.oParsingData.MLFB.POS9 = strBaseMLFB.charAt(8); // G
  oResult.oParsingData.MLFB.POS10 = strBaseMLFB.charAt(9); // Spannungsbereich [E,F,H]
  oResult.oParsingData.MLFB.POS11_13 = strBaseMLFB.substring(10, 13); // Leistung 1
  //oResult.oParsingData.MLFB.POS12 = strBaseMLFB.charAt( 11 );	// Leistung 2
  //oResult.oParsingData.MLFB.POS13 = strBaseMLFB.charAt( 12 ); // Leistung 3
  oResult.oParsingData.MLFB.POS14 = strBaseMLFB.charAt(13); // . Ausführung A (Standard) oder C (kompakt), wenn MLFB08 == 2 ==> nur A
  oResult.oParsingData.MLFB.POS15 = strBaseMLFB.charAt(14); // A
  oResult.oParsingData.MLFB.POS16 = strBaseMLFB.charAt(15); // 3

  ECL_SelectValue("MLFB05_G150", oResult.oParsingData.MLFB.POS5);
  ECL_SelectValue("MLFB06_G150", oResult.oParsingData.MLFB.POS6);
  ECL_SelectValue("MLFB07_G150", oResult.oParsingData.MLFB.POS7);
  ECL_SelectValue("MLFB08_G150", oResult.oParsingData.MLFB.POS8);
  ECL_SelectValue("MLFB09_G150", oResult.oParsingData.MLFB.POS9);
  ECL_SelectValue("MLFB10_G150", oResult.oParsingData.MLFB.POS10);
  ECL_SelectValue("MLFB11_G150", oResult.oParsingData.MLFB.POS11_13);
  ECL_SelectValue("MLFB14_G150", oResult.oParsingData.MLFB.POS14);
  ECL_SelectValue("MLFB15_G150", oResult.oParsingData.MLFB.POS15);
  ECL_SelectValue("MLFB16_G150", oResult.oParsingData.MLFB.POS16);

  // Kurzangaben
  if (aTokens.length > 0) {
    if (aTokens[0] === strBaseMLFB) {
      aTokens = removeElementsFromArray(aTokens, 0, 1);
    }
    oResult.oParsingData.MLFB.KAG = aTokens;

    oResult.oParsingData.MLFB.KAG_LIST = getKAGAsList(aTokens);
  }

  return oResult;
}

/**
	Fügt weitere Produktinfos hinzu, die in der Datenbank häufiger genutzt werden.
*/
function add_help_shortcuts(oResult) {
  var mlfbObj = oResult.oParsingData.MLFB;

  return oResult;
}

/**
	Liefert Semicolon-getrennte Liste aller vorh. Kurzangaben
*/
function getKAGAsList(aTokens) {
  var kagString = "";
  for (var i = 0; i < aTokens.length; i++) {
    kagString += aTokens[i];
    if (i < aTokens.length - 1) {
      kagString += ";";
    }
  }
  return kagString;
}

function SetFreetextValue(field, value) {
  value = trimleft(value, "*");
  value = trimright(value, "*");

  ECL_SetValue(field, value);
}

function SetFREETEXTS(oParse) {
  /*	zur Info - oParse: 
	{
		strBaseMLFB : '',
		strFullMLFB
		strError : '',
		strWarning : '',
		aTokens : [],
		oFreetext : {}
	};
*/

  if (find(oParse.strFullMLFB, "Y09") >= 0) {
    if (oParse.oFreetext["Y09"])
      SetFreetextValue("OE_LACK_G150", oParse.oFreetext["Y09"]);
  }
}

function isKAGinMLFB(aArray, sKAG) {
  for (var i = 0; i < aArray.length; i++) {
    if (aArray[i] == sKAG) return true;
  }

  return false;
}
