﻿//@legacy
//#mode(full-ecma)

//@import "CFG_G220_VT.js"

// ---------------------------------------------------------------------------------
// Bestimme die Consequences aus einer gegebenen Konfiguration

// ###################################################################################################################################
// Consequence-Attributes
// ###################################################################################################################################
/**
 * ControlUnit
 * BrakingResistorID
 * SelectedCustomBrakingResistor
 * BrakeRelays
 * 
 * InputFilterType
 * ExternalFilterType
 * 
 * MaxOutputFrequencyLimit
 * MaxPulseFrequency
 * MinPulseFrequency
 * OutputReactorOrFilter
 * OutputReactorOrFilterType
 * 
 */

function determineConsequencesG220(sECSI_MLFB) {
	var strErr = "";

	var oConsequences = {
		ControlUnit: getControlUnit(sECSI_MLFB),
		InputFilterType: getInputFilterType(sECSI_MLFB),
		ExternalFilterType: getExternalFilterType(sECSI_MLFB),
		//MinPulseFrequency 			: getMinPulseFrequency(sECSI_MLFB),
		MaxOutputFrequencyLimit: getMaxOutputFrequencyLimit(sECSI_MLFB),
		MaxPulseFrequency: getMaxPulseFrequency(sECSI_MLFB),
		OutputReactorOrFilterType: getOutputReactorOrFilterType(sECSI_MLFB),
		OutputReactorOrFilter: getOutputReactorOrFilter(sECSI_MLFB),
		IpProtectionLevelFrequencyConverter: getIpProtectionLevelFrequencyConverter(sECSI_MLFB),
		BrakingResistorID: getBrakingResistorID(sECSI_MLFB),
		SelectedCustomBrakingResistor: getSelectedCustomBrakingResistor(sECSI_MLFB),
		//AllowedControlModes		: getAllowedControlModes,
		Error_Message: strErr
	}

	return oConsequences;
}



function getControlUnit(sECSI_MLFB) {
	return "";
}

function getInputFilterType(sECSI_MLFB) {
	switch (ECL_GetValue("HMK_EMC_TYPE_G220")) {
		case "00004": // ohne
			var InputFilterType = "0";
			break;
		case "00002": // C2
			var InputFilterType = "2";	// 
			break;
		case "00001": // C1
			var InputFilterType = "1";	//
			break;
		case "00003": // C3
			var InputFilterType = "3";	// 
			break;
		default:
			var InputFilterType = "0";
	}
	return InputFilterType;
}
function getExternalFilterType(sECSI_MLFB) {
	/*switch (HMK_EXT_NETZFILTER_G120X){
		case "00001": // ohne
			var ExternalFilterType = "0";
		break;
		case "00003":
			var ExternalFilterType = "3";// Klasse B Klren!!! todo
		break;
		case "00004":
			var ExternalFilterType = "2";// Klasse C2 
		break;
		default:
			var ExternalFilterType = "0";
	}
	*/

	return "0";
}
function getOutputReactorOrFilterType(sECSI_MLFB) {
	// OutputReactorOrFilterType
	/* Integer
	0	No output reactor or filter selected
	1	Single motor reactor selected
	2	Two motor reactor in series selected
	3	Sinus filter selected
	4	du/dt filter selected
*/
	return "0";
}

function getOutputReactorOrFilter(sECSI_MLFB) {
	/** OutputReactorOrFilter	
	String	
	This parameter defines the order number for a selected output reactor or filter.	
		String.Empty	No output reactor or filter selected
		String			Order number as MLFB without separating "-"

	  */
	return "";
}

function getIpProtectionLevelFrequencyConverter(sECSI_MLFB) {
	// PMD_ABJ176_001_000_1FK2  	Schutzart
	var IpProtectionLevelFrequencyConverter = "";
	/*
	Z0001	IP00
	Z0003	IP55
	Z0010	IP21
	Z0012	IP20

	*/
	var PMD_ABJ176_001_000_G220 = ECL_GetValue("PMD_ABJ176_001_000_G220");

	switch (PMD_ABJ176_001_000_G220) {
		case "Z0003":
			IpProtectionLevelFrequencyConverter = "55";
			break;
		case "Z0012":
			IpProtectionLevelFrequencyConverter = "20";
			break;
	}
	return IpProtectionLevelFrequencyConverter;
}

function getBrakingResistorID(sECSI_MLFB) {
	var sMLFB_BRAKERESISTOR = "";
	if (ECL_ValueSelected("HMK_BRAKERESISTOR_G220", "T")) {
		sMLFB_BRAKERESISTOR = ECL_GetValue("HMK_ACC_BRAKING_G220");
		var sTable = "BrakeID";

		var sSQL = "SELECT DISTINCT SZ_BR_ID FROM " + sTable + " WHERE " +
			"SZ_BR_Artnum = '" + sMLFB_BRAKERESISTOR + "';";

		var aResult = Object.fromDatabase("G220_ADD_DATA", sSQL);

		if (aResult.length > 0) {
			var brakingResistorId = aResult[0].SZ_BR_ID;
		} else {
			return "ERROR";
		}
	}
	else{
        if (ECL_GetValue("UI_HMK_BRAKERESISTOR_G220") == "CUSTOM") {
            var brakingResistorId = "Custom";
        }
		else {
			var brakingResistorId = "";
		}
    }
	return brakingResistorId;
}

function getSelectedCustomBrakingResistor(sECSI_MLFB) {
	if (ECL_ValueSelected("HMK_BRAKERESISTOR_G220", "T")) {
		var selectedCustomBrakingResistor = "False";
	}
	else if (ECL_GetValue("UI_HMK_BRAKERESISTOR_G220") == "CUSTOM"){
		var selectedCustomBrakingResistor = "True";
	}
	else {
		var selectedCustomBrakingResistor = "False";
    }

	return selectedCustomBrakingResistor;
}


function getMaxOutputFrequencyLimit(sECSI_MLFB) {
	// MLFB pattern 6SL41130???????0
	var SeriesID = ECL_GetValue("ECSI_CX_SeriesID");
	var sMLFBpattern = sECSI_MLFB.substring(0, 8) + "???????0";
	var sTable = "PulseFrequency";

	var sSQL = "SELECT DISTINCT SZ_UPF_MaxOutputFrequency FROM " + sTable + " WHERE " +
		"SZ_UPF_U_OrderNumber = '" + sMLFBpattern + "' AND " +
		"SZ_UPF_U_SeriesID = '" + SeriesID + "';";

	var aResult = Object.fromDatabase("G220_ADD_DATA", sSQL);

	if (aResult.length > 0) {
		var MaxOutputFrequencyLimit = aResult[0].SZ_UPF_MAXOUTPUTFREQUENCY;
	} else {
		return "ERROR";
	}
	return MaxOutputFrequencyLimit;
}
function getMaxPulseFrequency(sECSI_MLFB) {
	// MLFB pattern 6SL41130???????0
	var SeriesID = ECL_GetValue("ECSI_CX_SeriesID");
	var sMLFBpattern = sECSI_MLFB.substring(0, 8) + "???????0";
	var sTable = "PulseFrequency";

	var sSQL = "SELECT MAX(SZ_UPF_PulseFrequency) AS MAX_PULSEFREQUENCY FROM " + sTable + " WHERE " +
		"SZ_UPF_U_OrderNumber = '" + sMLFBpattern + "' AND " +
		"SZ_UPF_U_SeriesID = '" + SeriesID + "';";

	var aResult = Object.fromDatabase("G220_ADD_DATA", sSQL);

	if (aResult.length > 0) {
		var MaxPulseFrequency = aResult[0].MAX_PULSEFREQUENCY;
	} else {
		return "ERROR";
	}
	return MaxPulseFrequency;
}