//@legacy
//#mode(full-ecma)

//@import "CFG_G220_VT.js"

function isLetter(strValue) {
  var objRegExp = /^[a-zA-Z]$/;
  return objRegExp.test(strValue);
}

function isDigit(strValue) {
  var objRegExp = /^\d/;
  return objRegExp.test(strValue);
}

function formatFreetext(ka, ft) {
  // Keine Freitexte erzeugen, wenn Text leer ist; dies führt zu Problemen im Sizer
  if (!ft || ft == "") return "";

  // Filterung von Sonderzeichen im Freitext: {, }
  ft = replace(ft, "{", "");
  ft = replace(ft, "}", "");

  // var strRet = '{' + ka + ': *' + ft + '*}';
  var strRet = "{" + ka + ":" + ft + "}";
  return strRet;
}

// Siehe hierzu auch die korrespondierende Funktion zum Parsen von Freitextangaben und
// befüllen der Attribute
function getFreetextSD(attrValNetto) {
  var strRet = "";
  /** if (attrValNetto == 'Y84') {
    strRet = formatFreetext(attrValNetto, ECL_GetValue('O_Y84_TXT_1FK2'));
  }*/
  return strRet;
}

/*

>>>> Diese Merkmale können einen Wert annehmen, der bedeutet, dass eine Klartextangabe erforderlich wird:
O_Y84_1FK2	Kundenangabe auf dem Leistungsschild	Customer specification on rating plate	Y84	Ja		Yes
O_Y84_1FK2	Kundenangabe auf dem Leistungsschild	Customer specification on rating plate	F	Nein	No

>>>> Diese Merkmale enthalten dann die Klartexte:
O_Y84_TXT_1FK2	Kundenangabe auf dem Leistungsschild (Textfeld)	Customer specification on rating plate (text field)			

*/

/**
  Funktion zur Generierung der Kurzangaben anhand der gew�hlten Merkmale
  Beispiel f�r einen Fall mit Klartextangaben aus dem Bereich 2KJ:  
  2KJ3203-1BC21-4AK1-Z D01 +K01 +K08 +L02 +M55 +N38 +P91 +W21 +Y00 +Y80 {Y00: *LSK@myident*}{Y80: *RAL@5000*}
*/
function GenKAG_G220(sBaseTypeMLFB, sECSI_MLFB) {
  var newBaseMLFB = left(sECSI_MLFB, 16); //left(sBaseTypeMLFB, 16);
  // Für Transfer-Konfig:
  // Wir müssen in die Basteype-MLFB, die neu sein kann, die aktuell konfigurierten Stellen der bisherigen MLFB übernehmen			<==== Hier nicht! Wird im Parser behandelt!
  /*	newBaseMLFB = replaceAt(newBaseMLFB, 13, sECSI_MLFB.charAt( 13 ));
  newBaseMLFB = replaceAt(newBaseMLFB, 14, sECSI_MLFB.charAt( 14 ));
  newBaseMLFB = replaceAt(newBaseMLFB, 15, sECSI_MLFB.charAt( 15 ));
*/
  // In erster Näherung k�nnen wir in Datenbank "1FT2_ADD_DATA.db3" die "Tabelle1" durchlaufen und f�r alle Attribute
  // schauen, ob der gesetzte Wert eine Kurzangabe hergibt (3 Stellen, nicht STD oder NON, Format ANN). Die �bernehmen wir dann.
  // Zus�tzlich m�ssen wir ...
  // - Kurzangaben die sich aus mehreren Attributen ergeben bestimmen (spezielle Tabellen)
  // - Klartextangaben generieren
  var aKag = [];
  var aKagFt = []; // Free Texts

  // Wir gehen alle Attribute durch und schauen mal ob ein Wert mit Kurzangabe selektiert ist.
  // Bei Kurzangaben, die einen Klartext erfordern, bestimmen wir diesen auch
  var aResult = Object.fromDatabase("G220_ADD_DATA", "SELECT DISTINCT Attribute FROM DATA WHERE IsKAG = 'x' AND IsCheckBox <> 'x';");
  for (var i = 0; i < aResult.length; i++) {
    var attrname = aResult[i]["ATTRIBUTE"];
    var attrVal = ECL_GetValue(attrname);
    // Die Attributwerte enthalten wohl nicht den Attributnamen, wohl aber die Dict-Ids der Werte
    // Sicherheitshalber strippen wir hier aber auch
    var attrValNetto = replace(attrVal, attrname, "");
    attrValNetto = replace(attrValNetto, "___", "");

    if (attrValNetto.length == 3 && attrValNetto != "STD" && attrValNetto != "NON") {
      // != 'ALT', 'MOT'
      if (
        isLetter(attrValNetto.charAt(0)) &&
        isDigit(attrValNetto.charAt(1)) &&
        (isDigit(attrValNetto.charAt(2)) || isLetter(attrValNetto.charAt(2)))
      )
        aKag.push(attrValNetto);

      if (attrValNetto.charAt(0) == "Y") {
        // Es muss eine Klartextangabe generiert werden
        var ft = getFreetextSD(attrValNetto);
        if (ft && ft != "") aKagFt.push(ft);
      }
    }
  }
  // Checkbox-Attribute
  var aResult = Object.fromDatabase("G220_ADD_DATA", "select distinct CB_Attribute, Wert_ID from DATA where IsCheckBox = 'x' and IsKAG = 'x'");

  for (var i = 0; i < aResult.length; i++) {
    var attrname = aResult[i]["CB_ATTRIBUTE"];
    var attrKAG = aResult[i]["WERT_ID"];
    var bKAG = ECL_ValueSelected(attrname, "T");
    // no short-option for option modules (OM), if only one OM selected. Then MLFB14 == A
    if ((attrKAG == "T01" || attrKAG == "T04" || attrKAG == "T05") && bKAG && sECSI_MLFB.charAt(13) == "A") {
      aKag.push(attrKAG);

      if (attrKAG.charAt(0) == "Y") {
        // Es muss eine Klartextangabe generiert werden
        var ft = getFreetextSD(attrKAG);
        if (ft && ft != "") aKagFt.push(ft);
      }
    }
  }

  // Ab hier beginnt der Zusammenbau des fertigen MLFB - Strings:

  aKag.sort();
  var kag = ""; // Kurzangaben alphabetisch sortiert in einen String schreiben
  for (var j = 0; j < aKag.length; ++j) {
    kag += aKag[j] + "+";
  }
  kag = trimright(kag, "+");

  aKagFt.sort();
  var kagFT = ""; // Kurzangaben alphabetisch sortiert in einen String schreiben
  for (var j = 0; j < aKagFt.length; ++j) {
    kagFT += aKagFt[j];
  }

  // Einfache Regel: Wenn Kurzangaben, dann "-Z" als Marker an der Grund-MLFB
  // Wir ignorieren hier f�rs erste die Unterscheidung zwischen erg�nzenden Angaben und besonderen Ausf�hrungen
  var fullMLFB = newBaseMLFB + (kag != "" ? "-Z " + kag : "") + (kagFT != "" ? " " : "") + kagFT;

  return fullMLFB;
}

function genMlfbSec() {
  // SD_CARD with KAG!
  /*
  UI_MEMORYCARD_1011270	Speicherkarte /.../Software			HMK_SDCARD_FM_MLFB_1011270	HMK_SDCARD_FM_MLFB_G220
  HMK_MEMORYCARD_1011270	Speicherkarte
  HMK_F01_1011270	SINAMICS /.../Extended
  HMK_H01_1011270	SINAMICS /.../Extended
  BZ_G220_00411	Stückliste Speicherkarte	12	Proc	1	* Leer
  BZ_G220_00411	Stückliste Speicherkarte	12	Proc	2	$self.MLFB_G220 = '6SL59700AA000AA0' if
  BZ_G220_00411	Stückliste Speicherkarte	12	Proc	3	$root.HMK_MEMORYCARD_1011270 = '00002',
  BZ_G220_00411	Stückliste Speicherkarte	12	Proc	4	* mit Firmware
  BZ_G220_00411	Stückliste Speicherkarte	12	Proc	5	$self.MLFB_G220 = '6SL41701GC000AA0' if
  BZ_G220_00411	Stückliste Speicherkarte	12	Proc	6	$root.HMK_MEMORYCARD_1011270 = '00003',
  BZ_G220_00411	Stückliste Speicherkarte	12	Proc	7	* H01
  BZ_G220_00411	Stückliste Speicherkarte	12	Proc	8	$self.KAG_G220 = 'H01' if
  BZ_G220_00411	Stückliste Speicherkarte	12	Proc	9	$root.HMK_H01_1011270 = 'H01',
  BZ_G220_00411	Stückliste Speicherkarte	12	Proc	10	* F01
  BZ_G220_00411	Stückliste Speicherkarte	12	Proc	11	$self.KAG_G220 = 'F01' if
  BZ_G220_00411	Stückliste Speicherkarte	12	Proc	12	$root.HMK_F01_1011270 = 'F01'

	


  HMK_MS_IEC_MLFB_CPL_1011270	MLFB Motorschutzschalter IEC
  HMK_MS_UL_MLFB_CPL_1011270	MLFB Motorschutzschalter UL
  HMK_SCFUSE_IEC_MLFB_1011270	MLFB Halbleitersicherung IEC
  HMK_SCFUSE_UL_MLFB_1011270	MLFB Halbleitersicherung UL
  HMK_FUSE_IEC_MLFB_1011270	MLFB Standardsicherung
  HMK_ACC_BRAKING_G220		MLFB Bremswiderstand

  if HMK_DQ_SUPPORTED__G220 == T ==> DQ dust cover 6SL30664CA000AA0
  */

  var HMK_MOTORNORM_G220 = ECL_GetValue("HMK_MOTORNORM_G220");
  var sECSI_MLFB_SEC = "";

  //-----------------------------------------------------------------------------
  if (ECL_ValueSelected("CB_MEMORYCARD_G220", "T")) {
    var memoryCardEnabledOptions = [];

    var sMLFB_MemCard = "6SL41701GE000AA0";

    // Make sure the options are in alpabetical order
    if (ECL_ValueSelected("CB_E01_G220", "T")) {
      memoryCardEnabledOptions.push("E01");
    }
    if (ECL_ValueSelected("CB_F01_G220", "T")) {
      memoryCardEnabledOptions.push("F01");
    }
    if (ECL_ValueSelected("CB_H01_G220", "T")) {
      memoryCardEnabledOptions.push("H01");
    }
    if (ECL_ValueSelected("CB_H80_G220", "T")) {
      memoryCardEnabledOptions.push("H80");
    }
    if (ECL_ValueSelected("CB_J03_G220", "T")) {
      memoryCardEnabledOptions.push("J03");
    }
    if (ECL_ValueSelected("CB_J04_G220", "T")) {
      memoryCardEnabledOptions.push("J04");
    }

    if (memoryCardEnabledOptions.length > 0) {
      sMLFB_MemCard += "-Z " + memoryCardEnabledOptions.join("+");
    }

    if (sECSI_MLFB_SEC !== "") {
      sECSI_MLFB_SEC += ";" + sMLFB_MemCard;
    } else {
      sECSI_MLFB_SEC = sMLFB_MemCard;
    }
  }
  //-----------------------------------------------------------------------------

  // Handle Supplementary system components

  var supplementarySystemComponentsMFLBs = [];
  var sMLFB_SmartAdapt = "6SL49500AJ000AA0";
  var sMLFB_SDIPro = "6SL49500AH352AA0";
  var sMLFB_SDIProHandheld = "6SL49500AH650AA0";
  var sMLFB_SDIProDoor = "6SL49500AH550AA0";
  var sMLFB_SDIProPlusDoor = "6SL49500AH450AA0";
  var sMLFB_SDIProIP55 = "6SL49500AH750AA0";

  // SINAMICS Smart Adapter
  if (ECL_ValueSelected("CB_SMARTADP_G220", "T")) {
    supplementarySystemComponentsMFLBs.push(sMLFB_SmartAdapt);
  }
  // SINAMICS SDI Pro 5.5"
  if (ECL_ValueSelected("CB_PROPANEL_G220", "T")) {
    supplementarySystemComponentsMFLBs.push(sMLFB_SDIPro);
  }
  // SINAMICS SDI Pro 5.5" Handheld Kit
  if (ECL_ValueSelected("CB_PROPANELHANDHELD_G220", "T")) {
    supplementarySystemComponentsMFLBs.push(sMLFB_SDIProHandheld);
  }
  // SINAMICS SDI Pro 5.5" Door Mounting Kit
  if (ECL_ValueSelected("CB_PROPANELDOOR_G220", "T")) {
    supplementarySystemComponentsMFLBs.push(sMLFB_SDIProDoor);
  }
  // SINAMICS SDI Pro 5.5" + Door Mounting Kit
  if (ECL_ValueSelected("CB_PROPANELPLUSDOOR_G220", "T")) {
    supplementarySystemComponentsMFLBs.push(sMLFB_SDIProPlusDoor);
  }
  // SINAMICS SDI Pro 5.5" IP55 Panel mounting frame
  if (ECL_ValueSelected("CB_PROPANELIP55_G220", "T")) {
    supplementarySystemComponentsMFLBs.push(sMLFB_SDIProIP55);
  }

  sMLFB_SupplementarySystemComponents = "";

  // Add all supplementary system components to secondary MLFB
  if (supplementarySystemComponentsMFLBs.length > 0) {
    sMLFB_SupplementarySystemComponents = supplementarySystemComponentsMFLBs.join(";");
    
    if (sECSI_MLFB_SEC !== "") {
      sECSI_MLFB_SEC += ";" + sMLFB_SupplementarySystemComponents;
    } else {
      sECSI_MLFB_SEC = sMLFB_SupplementarySystemComponents;
    }
  }

  //-----------------------------------------------------------------------------
  /*HMK_SENSORMODULE_1011270
  HMK_SENSORMODUL_MLFB_1011270	Sensor Module Cabinet-Mounted MLFB
    6SL30550AA005BA3	SMC20	00002
    6SL30550AA005CA2	SMC30 	00003
  */
  var HMK_SENSORMODULE_1011270 = ECL_GetValue("HMK_SENSORMODULE_1011270");
  var sMLFB_SensoeModule = "";
  if (HMK_SENSORMODULE_1011270 !== "00001") {
    if (HMK_SENSORMODULE_1011270 == "00002") {
      sMLFB_SensoeModule = "6SL30550AA005BA3"; // SMC20
    }
    if (HMK_SENSORMODULE_1011270 == "00003") {
      sMLFB_SensoeModule = "6SL30550AA005CA2"; // SMC30
    }
    if (sECSI_MLFB_SEC !== "") {
      sECSI_MLFB_SEC += ";" + sMLFB_SensoeModule;
    } else {
      sECSI_MLFB_SEC = sMLFB_SensoeModule;
    }
  }
  //-----------------------------------------------------------------------------
  /*SINAMICS DRIVE-CLiQ Cable
    HMK_DQ_LEITUNG_1011270_X	HMK_DQ_LEITUNG_MLFB_1011270
    00001	6SL30604AA100AA0
    00002	6SL30604AW000AA0
    00003	6SL30604AF100AA0
  */
  var HMK_DQ_LEITUNG_1011270_X = ECL_GetValue("HMK_DQ_LEITUNG_1011270_X");
  var sMLFB_DQ_Cable = "";
  if (HMK_DQ_LEITUNG_1011270_X !== ".") {
    switch (HMK_DQ_LEITUNG_1011270_X) {
      case "00001":
        sMLFB_DQ_Cable = "6SL30604AA100AA0";
        break;
      case "00002":
        sMLFB_DQ_Cable = "6SL30604AW000AA0";
        break;
      case "00003":
        sMLFB_DQ_Cable = "6SL30604AF100AA0";
        break;
      default:
        sMLFB_DQ_Cable = "";
    }

    if (sECSI_MLFB_SEC !== "") {
      sECSI_MLFB_SEC += ";" + sMLFB_DQ_Cable;
    } else {
      sECSI_MLFB_SEC = sMLFB_DQ_Cable;
    }
  }
  //-----------------------------------------------------------------------------
  if (ECL_ValueSelected("CB_CIRCUIT_BREAKER_G220", "T")) {
    // todo ??? if (ECL_ValueSelected("CB_CIRCUIT_BREAKER_UL_G220", "T")) {
    /*
  	
  MLFB IEC: HMK_CB_IEC_MLFB_CPL_1011270
  MLFB UL:  HMK_CB_UL_MLFB_CPL_1011270
    */
    var sMLFB_CB = "";

    if (HMK_MOTORNORM_G220 == "00002") {
      // IEC
      sMLFB_CB = ECL_GetValue("HMK_CB_IEC_MLFB_CPL_1011270");
    } else {
      // UL
      sMLFB_CB = ECL_GetValue("HMK_CB_UL_MLFB_CPL_1011270");
    }
    if (sECSI_MLFB_SEC !== "") {
      sECSI_MLFB_SEC += ";" + sMLFB_CB;
    } else {
      sECSI_MLFB_SEC = sMLFB_CB;
    }
  }

  //-----------------------------------------------------------------------------
  // MS IEC
  if (HMK_MOTORNORM_G220 == "00002" && ECL_ValueSelected("CB_MS_G220", "T")) {
    /*
    HMK_MS_IEC_MLFB_CPL_1011270	MLFB Motorschutzschalter IEC
    */
    var sMLFB_MS = ECL_GetValue("HMK_MS_IEC_MLFB_CPL_1011270");

    if (sECSI_MLFB_SEC !== "") {
      sECSI_MLFB_SEC += ";" + sMLFB_MS;
    } else {
      sECSI_MLFB_SEC = sMLFB_MS;
    }
  }
  // MS UL
  if (HMK_MOTORNORM_G220 == "00001" && ECL_ValueSelected("CB_MS_UL_G220", "T")) {
    /*
    HMK_MS_UL_MLFB_CPL_1011270	MLFB Motorschutzschalter UL
    */
    var sMLFB_MS = ECL_GetValue("HMK_MS_UL_MLFB_CPL_1011270");

    if (sECSI_MLFB_SEC !== "") {
      sECSI_MLFB_SEC += ";" + sMLFB_MS;
    } else {
      sECSI_MLFB_SEC = sMLFB_MS;
    }
  }
  //-----------------------------------------------------------------------------
  if (ECL_ValueSelected("CB_SC_FUSE_G220", "T")) {
    /*
    HMK_SCFUSE_IEC_MLFB_1011270	MLFB Halbleitersicherung IEC
    HMK_SCFUSE_UL_MLFB_1011270	MLFB Halbleitersicherung UL
    */
    var sMLFB_SC_FUSE = "";

    if (HMK_MOTORNORM_G220 == "00002") {
      // IEC
      sMLFB_SC_FUSE = ECL_GetValue("HMK_SCFUSE_IEC_MLFB_1011270");
    } else {
      sMLFB_SC_FUSE = ECL_GetValue("HMK_SCFUSE_UL_MLFB_1011270");
    }
    if (sECSI_MLFB_SEC !== "") {
      sECSI_MLFB_SEC += ";" + sMLFB_SC_FUSE;
    } else {
      sECSI_MLFB_SEC = sMLFB_SC_FUSE;
    }
  }
  //-----------------------------------------------------------------------------
  if (ECL_ValueSelected("CB_STD_FUSE_G220", "T")) {
    //HMK_FUSE_IEC_MLFB_1011270	MLFB Standardsicherung

    var sMLFB_FUSE = ECL_GetValue("HMK_FUSE_IEC_MLFB_1011270");

    if (sECSI_MLFB_SEC !== "") {
      sECSI_MLFB_SEC += ";" + sMLFB_FUSE;
    } else {
      sECSI_MLFB_SEC = sMLFB_FUSE;
    }
  }
  //-----------------------------------------------------------------------------
  if (ECL_ValueSelected("HMK_BRAKERESISTOR_G220", "T")) {
    //HMK_ACC_BRAKING_G220		MLFB Bremswiderstand

    var sMLFB_BRAKERESISTOR = ECL_GetValue("HMK_ACC_BRAKING_G220");

    if (sECSI_MLFB_SEC !== "") {
      sECSI_MLFB_SEC += ";" + sMLFB_BRAKERESISTOR;
    } else {
      sECSI_MLFB_SEC = sMLFB_BRAKERESISTOR;
    }
  }
  //-----------------------------------------------------------------------------
  if (ECL_ValueSelected("HMK_DUDT_FILTER_G220", "T")) {

    var power = ECL_GetValue("HMK_RATED_POWER_G220");
    var valid = ECL_GetValue("HMK_VALUE_VALID_G220");
    var voltage = ECL_GetValue("HMK_VOLTAGE_G220");

    var sTable = "VT_G220_M00695" + sDB_Suffix;
    var sSQL_DUDT_FILTER_MLFB_G220 = "SELECT HMK_DUDT_FILTER_MLFB_G220 FROM " + sTable + " WHERE " + "HMK_RATED_POWER_G220 = '" + power + "'  AND HMK_VALUE_VALID_G220 = '" + valid + "' AND HMK_VOLTAGE_G220 = '" + voltage + "' AND HMK_DU_DT_FILTER_1011270 = 'T' ;";

    var aResult = GetDBDataSetEXT(sSQL_DUDT_FILTER_MLFB_G220);

    if (aResult.length !== 0) {
      if (sECSI_MLFB_SEC !== "") {
        sECSI_MLFB_SEC += ";" + aResult[0].HMK_DUDT_FILTER_MLFB_G220;
      } else {
        sECSI_MLFB_SEC = aResult[0].HMK_DUDT_FILTER_MLFB_G220;
      }
    }
  }
  //-----------------------------------------------------------------------------
  // if HMK_DQ_SUPPORTED__G220 == T ==> DQ dust cover 6SL30664CA000AA0
  if (ECL_ValueSelected("HMK_DQ_SUPPORTED__G220", "T")) {
    var sMLFB_DQ_DustCover = "6SL30664CA000AA0";

    if (sECSI_MLFB_SEC !== "") {
      sECSI_MLFB_SEC += ";" + sMLFB_DQ_DustCover;
    } else {
      sECSI_MLFB_SEC = sMLFB_DQ_DustCover;
    }
  }

  //-----------------------------------------------------------------------------
  // digitaler Zwilling
  /**
   * HMK_DRV_SIM_DESIGNER_1011270	  DriveSim Designer
   * HMK_MLFB_DRV_SIM_DES_1011270   MLFB DriveSim Designer
   *
   * HMK_DRV_SIM_ENGINEER_1011410	DriveSim Engineer
   * HMK_MLFB_DRV_SIM_ENG_1011410	MLFB DriveSim Engineer
   *
   *
   * VT_G220_M00631	MLFB DriveSim Designer
   *    HMK_DRV_SIM_DESIGNER_1011270	DriveSim Designer
   *    HMK_MLFB_DRV_SIM_DES_1011270	MLFB DriveSim Designer
   *
   * VT_G220_M00632	MLFB DriveSim Engineer
   *    HMK_DRV_SIM_ENGINEER_1011410	DriveSim Engineer
   *    HMK_MLFB_DRV_SIM_ENG_1011410	MLFB DriveSim Engineer
   */
  var HMK_DRV_SIM_DESIGNER_1011270 = ECL_GetValue("HMK_DRV_SIM_DESIGNER_1011270");
  if (HMK_DRV_SIM_DESIGNER_1011270 == "00002") {
    var sTable = "VT_G220_M00631" + sDB_Suffix;
    var sSQLDRV_SIM_DES = "SELECT * FROM " + sTable + " WHERE " + "HMK_DRV_SIM_DESIGNER_1011270 = '" + HMK_DRV_SIM_DESIGNER_1011270 + "';";

    var aResultDRV_SIM_DES = GetDBDataSetEXT(sSQLDRV_SIM_DES);
    if (aResultDRV_SIM_DES.length > 0) {
      var HMK_MLFB_DRV_SIM_DES_1011270 = aResultDRV_SIM_DES[0].HMK_MLFB_DRV_SIM_DES_1011270;
      if (sECSI_MLFB_SEC !== "") {
        sECSI_MLFB_SEC += ";" + HMK_MLFB_DRV_SIM_DES_1011270;
      } else {
        sECSI_MLFB_SEC = HMK_MLFB_DRV_SIM_DES_1011270;
      }
    } else {
      // Error
    }
  }
  //-----------------------------------------------------------------------------
  var HMK_DRV_SIM_ENGINEER_1011410 = ECL_GetValue("HMK_DRV_SIM_ENGINEER_1011410");
  if (HMK_DRV_SIM_ENGINEER_1011410 !== "00001" && HMK_DRV_SIM_ENGINEER_1011410 !== "") {
    var sTable = "VT_G220_M00632" + sDB_Suffix;
    var sSQLDRV_SIM_ENG = "SELECT * FROM " + sTable + " WHERE " + "HMK_DRV_SIM_ENGINEER_1011410 = '" + HMK_DRV_SIM_ENGINEER_1011410 + "';";

    var aResultDRV_SIM_ENG = GetDBDataSetEXT(sSQLDRV_SIM_ENG);
    if (aResultDRV_SIM_ENG.length > 0) {
      var HMK_MLFB_DRV_SIM_ENG_1011410 = aResultDRV_SIM_ENG[0].HMK_MLFB_DRV_SIM_ENG_1011410;
      if (sECSI_MLFB_SEC !== "") {
        sECSI_MLFB_SEC += ";" + HMK_MLFB_DRV_SIM_ENG_1011410;
      } else {
        sECSI_MLFB_SEC = HMK_MLFB_DRV_SIM_ENG_1011410;
      }
    } else {
      // Error
    }
  }
  //-----------------------------------------------------------------------------
  // Schutztür  SINAMICS SDI Standard Schutztür
  if (ECL_GetValue("HMK_IP55_PROT_DOOR_1011410") == "00001") {
    var HMK_IP55_PRDOOR_MLFB_1011410 = "6SL49500AH710AA0";

    if (sECSI_MLFB_SEC !== "") {
      sECSI_MLFB_SEC += ";" + HMK_IP55_PRDOOR_MLFB_1011410;
    } else {
      sECSI_MLFB_SEC = HMK_IP55_PRDOOR_MLFB_1011410;
    }
  }
  //-----------------------------------------------------------------------------
  // Service Protect: HMK_DSEE_G220
  var HMK_DSEE_G220 = ECL_GetValue("HMK_DSEE_G220");
  if (HMK_DSEE_G220 !== "OHNE") {
    var sECHI_MLFB = ECL_GetValue("ECSI_MLFB");
    var BaseMLFBForServiceProtection = sECHI_MLFB.substring(0, sECHI_MLFB.length - 2);


    var sTable = "VT_G220_M00633" + sDB_Suffix;
    var sSQL = "SELECT HMK_MLFB_DSEE_1011410 FROM " + sTable + " WHERE HMK_DSEE_1011410= '" + HMK_DSEE_G220 + "' AND HMK_BASE_MLFB_1011270 LIKE '%" + BaseMLFBForServiceProtection + "%';";

    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length > 0) {
      var HMK_MLFB_DSEE = aResult[0].HMK_MLFB_DSEE_1011410;

      if (sECSI_MLFB_SEC !== "") {
        sECSI_MLFB_SEC += ";" + HMK_MLFB_DSEE;
      } else {
        sECSI_MLFB_SEC = HMK_MLFB_DSEE;
      }
    }
  }
  //-----------------------------------------------------------------------------

  SetMlfbSec(sECSI_MLFB_SEC);

  return sECSI_MLFB_SEC;
}
