//@legacy
//#mode(full-ecma)

// ---------------------------------------------------------
// Script for configuration object CFG_SIEMENS_G220
// 	Date: 2023-04-26
// 	User: Administrator
// ---------------------------------------------------------

//@import "CFG_G220_VT.js"

/**
  Accessories

  UI_MEMORYCARD_1011270	Speicherkarte /.../Software			HMK_SDCARD_FM_MLFB_1011270	HMK_SDCARD_FM_MLFB_G220
  HMK_MEMORYCARD_1011270	Speicherkarte
HMK_F01_1011270	SINAMICS /.../Extended
HMK_H01_1011270	SINAMICS /.../Extended

HMK_SMARTADP_1011270	Smart Adapter für WLAN-Zugang			HMK_SMARTADP_MLFB_1011270	HMK_SMARTADP_MLFB
* HMK_SDI_PRO_HH_KIT_1011270	SINAMICS /.../enthalten)			HMK_SDI_PRO_HH_MLFB_1011270	HMK_SDI_PRO_HH_KIT_MLFB_G220
* HMK_SDI_PRO_DOOR_KIT_1011270	SINAMICS /.../enthalten)		HMK_SDI_PR_DOOR_MLFB_1011270	HMK_SDI_PRO_DOOR_KIT_MLFB_G220

* HMK_SC_SDI_PRO_IP55_1011270	SINAMICS /.../Kabel					KAG: NON, T43

* HMK_SDI_PRO_IP55_1011270	SINAMICS /.../Umrichter				HMK_SDI_PROIP55_MLFB_1011270	HMK_SDI_PRO_IP55_MLFB_G220

* HMK_SDI_PRO_IP55_KIT_1011270	Montagerahmen /.../IP55			HMK_SDI_PRO_KIT_MLFB_1011270	HMK_SDI_PRO_IP55_KIT_MLFB_G220

* HMK_CB_IEC_MLFB_TYPE_1011270	Ausführung des Anschlusses
* HMK_CB_IEC_OC_RELEAS_1011270	Ausführung /...romauslösers

neu: Leistungsschalter (IEC/oder UL)

Motorschutzschalter (IEC/oder UL)

Sicherung (IEC/oder UL)

Halbleitersicherung (IEC/oder UL)

neu: 
HMK_DRV_SIM_DESIGNER_1011270	DriveSim Designer		HMK_MLFB_DRV_SIM_DES_1011270	MLFB DriveSim Designer
  VT_G220_M00631	MLFB DriveSim Designer

HMK_DRV_SIM_ENGINEER_1011410	DriveSim Engineer		HMK_MLFB_DRV_SIM_ENG_1011410	MLFB DriveSim Engineer
  VT_G220_M00632	MLFB DriveSim Engineer

SINAMICS SDI Standard Schutztür
  HMK_IP55_PROT_DOOR_1011410	  HMK_SDI_PRO_IP55_PROT_DOOR_G220
  HMK_IP55_PRDOOR_MLFB_1011410	HMK_SDI_PRO_IP55_PROT_DOOR_MLFB_G220    6SL49500AH710AA0 ==> HMK_IP55_PROT_DOOR_1011410 = 00001, ohne: 00002


*/
function SetAccessories_Init(oData) {
  if (oData && !isEmpty(oData)) {
    SetMemCard(oData); //

    SetSmartAdapt(oData); // HMK_SMARTADP_1011270	Smart Adapter für WLAN-Zugang		CB_SMARTADP_G220
    SetProPanel(oData); // HMK_SDI_PRO_5_5_1011270	SINAMICS SDI Pro 5.5"		CB_PROPANEL_G220
    SetSDIProHandheldKit(oData); // HMK_SDI_PRO_HH_KIT_1011270	SINAMICS SDI Pro 5.5" Handheld Kit		CB_PROPANELHANDHELD_G220
    SetSDIProDoorKit(oData); // HMK_SDI_PRO_DOOR_KIT_1011270	SINAMICS SDI Pro 5.5" Door Mounting Kit		CB_PROPANELDOOR_G220
    SetSDIProPlusDoorKit(oData); // SINAMICS SDI Pro 5.5" + Door Mounting Kit		CB_PROPANELPLUSDOOR_G220
    SetSDIProIP55Frame(oData); // HMK_SDI_PRO_IP55_KIT_1011270	SINAMICS SDI Pro 5.5" IP55 Panel mounting frame		CB_PROPANELIP55_G220


    // No SMC for Release 11/23023
    //SetSensorModule(oData);		// HMK_SENSORMODULE_1011270	Sensor Module Cabinet-Mounted
    // No DQ_Cable for Release 08/23024 HMK_DQ_LEITUNG_1011270_X
    //SetDQ_Cable(oData);

    SetCB(oData); // Leistungsschalter
    SetMS(oData); //
    SetSCFUSE(oData); //
    SetFUSE(oData); //
    
    SetBrakeResistor(oData); //
    SetDuDtFilter(oData); // HMK_DUDT_FILTER_G220

    SetDRV_SIM_DESIGNER(oData);
    SetDRV_SIM_ENGINEER(oData);
    SetSDI_STD_IP55_PROT_DOOR(oData);

    SetServiceProtect(oData); // HMK_DSEE_G220 - Service Protect
    
  } else {
    // MemCard
    ECL_DeselectAttribute("CB_MEMORYCARD_G220");
    ECL_DeactivateAttribute("HMK_FIRMWARE_G220");
    ECL_DeselectAttribute("CB_H01_G220");
    ECL_DeselectAttribute("CB_F01_G220");
    ECL_DeselectAttribute("CB_H80_G220");
    ECL_DeselectAttribute("CB_J03_G220");
    ECL_DeselectAttribute("CB_J04_G220");
    ECL_DeselectAttribute("CB_E01_G220");

    
    ECL_DeselectAttribute("CB_SMARTADP_G220"); // Smart adapter
    ECL_DeselectAttribute("CB_PROPANEL_G220"); // Pro Panel
    ECL_DeselectAttribute("CB_PROPANELHANDHELD_G220"); // Pro Panel Handheld Kit
    ECL_DeselectAttribute("CB_PROPANELDOOR_G220"); // Pro Panel Door Mounting Kit
    ECL_DeselectAttribute("CB_PROPANELPLUSDOOR_G220"); // Pro Panel + Door Mounting Kit
    ECL_DeselectAttribute("CB_PROPANELIP55_G220"); // Pro Panel IP55 Frame


    // Sensor Module Cabinet-Mounted
    ExecSetStandardifValueEmpty("HMK_SENSORMODULE_1011270", "00001"); // ohne
    ExecSetStandardifValueEmpty("HMK_DQ_LEITUNG_1011270_X", "."); // ohne

    ExecSetStandardifValueEmpty("HMK_RUNTIME_VER_G220", "00004"); // HMK_RUNTIME_VER_G220

    ExecSetStandardifValueEmpty("TC_05_1011270", "00001"); // fix value for TC_05 / MLFB05
    ExecSetStandardifValueEmpty("HMK_DRV_SIM_DESIGNER_1011270", "00001"); // fix value for TC_05 / MLFB05
    ExecSetStandardifValueEmpty("HMK_DRV_SIM_ENGINEER_1011410", "00001"); // fix value for TC_05 / MLFB05

    ExecSetStandardifValueEmpty("HMK_DSEE_G220", "OHNE"); // Set Service Protect to "without" by default
  }
}

function SetAccessories(strchangedAttribute, oData) { }
// #########################################################################################################################
/**
UI_MEMORYCARD_1011270	Speicherkarte mit SINAMICS Drive Software		T, F
HMK_MEMORYCARD_1011270	Speicherkarte
HMK_F01_1011270	F01 SINAMICS Safety Integrated Extended					F01, NON
HMK_H01_1011270	H01 SINAMICS Motor Control Extended						H01, NON

HMK_SDCARD_FM_MLFB_1011270	HMK_SDCARD_FM_MLFB_G220

// Speicherkarte			CB_MEMORYCARD_G220

UI_MEMORYCARD_1011270	Speicherkarte mit SINAMICS Drive Software
  VT_G220_M00521	Speicherkarte einschraenken
    HMK_MEMORYCARD_1011270	UI_MEMORYCARD_1011270
	
HMK_MEMORYCARD_1011270	Speicherkarte
  VT_G220_M00457	MCARD_MEMORYCARD
    HMK_MCARD_FW_1011270	HMK_MEMORYCARD_1011270

  VT_G220_M00521	Speicherkarte einschraenken

HMK_MCARD_FW_1011270
  VT_G220_M00673	FW_AND_LICENSES
    HMK_SDCARD_FM_MLFB_1011270	HMK_FW_OPTION_1011270	HMK_MCARD_FW_1011270	HMK_LICENSE_DOWNLOAD_1011270	HMK_H01_1011270	HMK_F01_1011270
  VT_G220_M00457	MCARD_MEMORYCARD
	
HMK_F01_1011270	F01 SINAMICS Safety Integrated Extended					CB_F01_G220
  VT_G220_M00673	FW_AND_LICENSES
    HMK_SDCARD_FM_MLFB_1011270	HMK_FW_OPTION_1011270	HMK_MCARD_FW_1011270	HMK_LICENSE_DOWNLOAD_1011270	HMK_H01_1011270	HMK_F01_1011270

HMK_H01_1011270	H01 SINAMICS Motor Control Extended						CB_H01_G220
  VT_G220_M00673	FW_AND_LICENSES

HMK_SDCARD_FM_MLFB_1011270
  VT_G220_M00673	FW_AND_LICENSES

wenn F01 oder H01, anhaken

*6SL49700AA000AA0	jeweils optional mit F01, H01, F01+H01 -Z F01+H01
*6SL41700GC000AA0
6SL41701GC000AA0
6SL59700AA000AA0

*/
// #########################################################################################################################
function SetMemCard(oData) {
  // handled in PL-script // var ECSI_CX_SafetyFunctions	= ECL_GetValue("ECSI_CX_SafetyFunctions") || "";

  ECL_DeselectAttribute("CB_MEMORYCARD_G220");
  ECL_DeactivateAttribute("HMK_FIRMWARE_G220");
  ECL_DeselectAttribute("CB_H01_G220");
  ECL_DeselectAttribute("CB_F01_G220");
  ECL_DeselectAttribute("CB_H80_G220");
  ECL_DeselectAttribute("CB_J03_G220");
  ECL_DeselectAttribute("CB_J04_G220");
  ECL_DeselectAttribute("CB_E01_G220");
  var bSD_Card = false;
  var sECSI_MLFB_SEC = GetMlfbSec() || "";
  if (sECSI_MLFB_SEC !== "") {
    var secondaryMlfbArray = sECSI_MLFB_SEC.split(";");
    /*
    VT_G220_M00673	FW_AND_LICENSES
      HMK_SDCARD_FM_MLFB_1011270	HMK_FW_OPTION_1011270	HMK_MCARD_FW_1011270	HMK_LICENSE_DOWNLOAD_1011270	HMK_H01_1011270	HMK_F01_1011270
    */
    var sTable = "VT_G220_M00673" + sDB_Suffix;
    var sSQL =
      "SELECT DISTINCT HMK_SDCARD_FM_MLFB_1011270 FROM " +
      sTable +
      " WHERE " +
      "HMK_MCARD_FW_1011270 = 'T' AND " +
      "HMK_H01_1011270 = 'NON' AND " +
      "HMK_F01_1011270 = 'NON' AND " +
      "HMK_H80_G220 = 'NON' AND " +
      "HMK_J03_G220 = 'NON' AND " +
      "HMK_J04_G220 = 'NON' AND " +
      "HMK_E01_G220 = 'NON'" +
      ";";

    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length > 0) {
      for (var i = 0; i < secondaryMlfbArray.length; i++) {
        for (var j = 0; j < aResult.length; j++) {
          if (secondaryMlfbArray[i].indexOf(aResult[j].HMK_SDCARD_FM_MLFB_1011270) > -1) {
            ECL_SelectValue("CB_MEMORYCARD_G220", "T");
            ECL_ActivateAttribute("HMK_FIRMWARE_G220", "T");
            ECL_SelectValue("HMK_FIRMWARE_G220", "VERSION_6_4");

            if (secondaryMlfbArray[i].indexOf("F01") > -1) {
              ECL_SelectValue("CB_F01_G220", "T");
            }
            if (secondaryMlfbArray[i].indexOf("H01") > -1) {
              ECL_SelectValue("CB_H01_G220", "T");
            }
            if (secondaryMlfbArray[i].indexOf("H80") > -1) {
              ECL_SelectValue("CB_H80_G220", "T");
            }
            if (secondaryMlfbArray[i].indexOf("J03") > -1) {
              ECL_SelectValue("CB_J03_G220", "T");
              ECL_DisableAttribute("CB_J04_G220");
            }
            if (secondaryMlfbArray[i].indexOf("J04") > -1) {
              ECL_SelectValue("CB_J04_G220", "T");
              ECL_DisableAttribute("CB_J03_G220");
            }
            if (secondaryMlfbArray[i].indexOf("E01") > -1) {
              ECL_SelectValue("CB_E01_G220", "T");
            }
            bSD_Card = true;
            break;
          }
        }
        if (bSD_Card) {
          break;
        }
      }
    } else {
      oData.strError = "DICT1_ERR_G220___PARSER_MEM_CARD";
      return;
    }
  }
}

// #########################################################################################################################
/**
HMK_SMARTADP_1011270	Smart Adapter für WLAN-Zugang		00001, NONE

HMK_SMARTADP_MLFB_1011270	HMK_SMARTADP_MLFB	6SL49500AJ000AA0, OHNE

*/
// #########################################################################################################################
function SetSmartAdapt(oData) {
  var sMLFB_Sec = "6SL49500AJ000AA0";

  ECL_DeselectAttribute("CB_SMARTADP_G220");
  //ECL_SelectValue("HMK_SMARTADP_1011270", "NONE");

  var sECSI_MLFB_SEC = GetMlfbSec() || "";
  if (sECSI_MLFB_SEC !== "") {
    var secondaryMlfbArray = sECSI_MLFB_SEC.split(";");

    for (var i = 0; i < secondaryMlfbArray.length; i++) {
      if (secondaryMlfbArray[i] === sMLFB_Sec) {
        ECL_SelectValue("CB_SMARTADP_G220", "T");
        //ECL_SelectValue("HMK_SMARTADP_1011270", "00001");
        break;
      }
    }
  }
}


// #########################################################################################################################
/**
HMK_SDI_PRO_5_5_1011270	SINAMICS SDI Pro 5.5"		00001, NONE
*/
// #########################################################################################################################
function SetProPanel(oData) {
  var sMLFB_Sec = "6SL49500AH352AA0";

  ECL_DeselectAttribute("CB_PROPANEL_G220");

  var sECSI_MLFB_SEC = GetMlfbSec() || "";
  if (sECSI_MLFB_SEC !== "") {
    var secondaryMlfbArray = sECSI_MLFB_SEC.split(";");

    for (var i = 0; i < secondaryMlfbArray.length; i++) {
      if (secondaryMlfbArray[i] === sMLFB_Sec) {
        ECL_SelectValue("CB_PROPANEL_G220", "T");
        break;
      }
    }
  }
}

// #########################################################################################################################
/**
HMK_SDI_PRO_HH_KIT_1011270	SINAMICS SDI Pro 5.5" Handheld Kit		00001, NONE
*/
// #########################################################################################################################
function SetSDIProHandheldKit(oData) {
  var sMLFB_Sec = "6SL49500AH650AA0";

  ECL_DeselectAttribute("CB_PROPANELHANDHELD_G220");

  var sECSI_MLFB_SEC = GetMlfbSec() || "";
  if (sECSI_MLFB_SEC !== "" && sMLFB_Sec !== "") {
    var secondaryMlfbArray = sECSI_MLFB_SEC.split(";");

    for (var i = 0; i < secondaryMlfbArray.length; i++) {
      if (secondaryMlfbArray[i] === sMLFB_Sec) {
        ECL_SelectValue("CB_PROPANELHANDHELD_G220", "T");
        break;
      }
    }
  }
}

// #########################################################################################################################
/**
HMK_SDI_PRO_DOOR_KIT_1011270	SINAMICS SDI Pro 5.5" Door Mounting Kit		00001, NONE
*/
// #########################################################################################################################
function SetSDIProDoorKit(oData) {
  var sMLFB_Sec = "6SL49500AH550AA0";

  ECL_DeselectAttribute("CB_PROPANELDOOR_G220");

  var sECSI_MLFB_SEC = GetMlfbSec() || "";
  if (sECSI_MLFB_SEC !== "" && sMLFB_Sec !== "") {
    var secondaryMlfbArray = sECSI_MLFB_SEC.split(";");

    for (var i = 0; i < secondaryMlfbArray.length; i++) {
      if (secondaryMlfbArray[i] === sMLFB_Sec) {
        ECL_SelectValue("CB_PROPANELDOOR_G220", "T");
        break;
      }
    }
  }
}

// #########################################################################################################################
/**
SINAMICS SDI Pro 5.5" + Door Mounting Kit		00001, NONE
*/
// #########################################################################################################################
function SetSDIProPlusDoorKit(oData) {
  var sMLFB_Sec = "6SL49500AH450AA0";

  ECL_DeselectAttribute("CB_PROPANELPLUSDOOR_G220");

  var sECSI_MLFB_SEC = GetMlfbSec() || "";
  if (sECSI_MLFB_SEC !== "" && sMLFB_Sec !== "") {
    var secondaryMlfbArray = sECSI_MLFB_SEC.split(";");

    for (var i = 0; i < secondaryMlfbArray.length; i++) {
      if (secondaryMlfbArray[i] === sMLFB_Sec) {
        ECL_SelectValue("CB_PROPANELPLUSDOOR_G220", "T");
        break;
      }
    }
  }
}

// #########################################################################################################################
/**
HMK_SDI_PRO_IP55_KIT_1011270	SINAMICS SDI Pro 5.5" IP55 Panel mounting frame		00001, NONE
*/
// #########################################################################################################################
function SetSDIProIP55Frame(oData) {
  var sMLFB_Sec = "6SL49500AH750AA0";

  ECL_DeselectAttribute("CB_PROPANELIP55_G220");

  var sECSI_MLFB_SEC = GetMlfbSec() || "";
  if (sECSI_MLFB_SEC !== "" && sMLFB_Sec !== "") {
    var secondaryMlfbArray = sECSI_MLFB_SEC.split(";");

    for (var i = 0; i < secondaryMlfbArray.length; i++) {
      if (secondaryMlfbArray[i] === sMLFB_Sec) {
        ECL_SelectValue("CB_PROPANELIP55_G220", "T");
        break;
      }
    }
  }
}

// #########################################################################################################################
/**
Sensor Module Cabinet-Mounted
/*
  VT_G220_M00514	Sensor Module Cabinet-Mounted
    HMK_SENSORMODULE_1011270	HMK_SENSORMODUL_MLFB_1011270
	
  00001	ohne
  00002	SMC20 – Sensor Module Cabinet-Mounted für Sin/cos-Geber
  00003	SMC30 – Sensor Module Cabinet-Mounted SMC30 für HTL/TTL-Geber

  HMK_SENSORMODUL_MLFB_1011270	Sensor Module Cabinet-Mounted MLFB
    6SL30550AA005BA3	SMC20	00002
    6SL30550AA005CA2	SMC30 	00003
*/
// #########################################################################################################################
function SetSensorModule(oData) {
  var sMLFB_Sec_SMC20 = "6SL30550AA005BA3"; // 00002 SMC20 – Sensor Module Cabinet-Mounted für Sin/cos-Geber
  var sMLFB_Sec_SMC30 = "6SL30550AA005CA2"; // 00003 SMC30 – Sensor Module Cabinet-Mounted SMC30 für HTL/TTL-Geber

  ECL_SelectValue("HMK_SENSORMODULE_1011270", "00001"); // ohne

  var sECSI_MLFB_SEC = GetMlfbSec() || "";
  if (sECSI_MLFB_SEC !== "") {
    var secondaryMlfbArray = sECSI_MLFB_SEC.split(";");

    for (var i = 0; i < secondaryMlfbArray.length; i++) {
      if (secondaryMlfbArray[i] === sMLFB_Sec_SMC20) {
        ECL_SelectValue("HMK_SENSORMODULE_1011270", "00002");
        break;
      }
      if (secondaryMlfbArray[i] === sMLFB_Sec_SMC30) {
        ECL_SelectValue("HMK_SENSORMODULE_1011270", "00003");
        break;
      }
    }
  }
}

// #########################################################################################################################
/* SINAMICS DRIVE-CLiQ Cable
HMK_DQ_LEITUNG_1011270_X	HMK_DQ_LEITUNG_MLFB_1011270
00001	6SL30604AA100AA0
00002	6SL30604AW000AA0
00003	6SL30604AF100AA0
.	6SL30604AA100AA0
.	OHNE

*/
// #########################################################################################################################
function SetDQ_Cable(oData) {
  ECL_SelectValue("HMK_DQ_LEITUNG_1011270_X", "."); // ohne
  var bDQ_Cable = false;
  var sECSI_MLFB_SEC = GetMlfbSec() || "";
  if (sECSI_MLFB_SEC !== "") {
    var secondaryMlfbArray = sECSI_MLFB_SEC.split(";");

    var sTable = "VT_G220_M00534" + sDB_Suffix;
    var sSQL = "SELECT * FROM " + sTable + " WHERE " + "HMK_DQ_LEITUNG_1011270_X <> '.';";
    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length > 0) {
      for (var j = 0; j < aResult.length; j++) {
        var sMLFB_Sec_DQL = aResult[j].HMK_DQ_LEITUNG_MLFB_1011270;
        for (var i = 0; i < secondaryMlfbArray.length; i++) {
          if (secondaryMlfbArray[i] === sMLFB_Sec_DQL) {
            ECL_SelectValue("HMK_DQ_LEITUNG_1011270_X", aResult[j].HMK_DQ_LEITUNG_1011270_X);
            bDQ_Cable = true;
            break;
          }
        }
        if (bDQ_Cable) {
          break;
        }
      }
    } else {
      oData.strError = "DICT1_ERR_G220___PARSER_DQ_CABLE";
      return;
    }
  }
}

// #########################################################################################################################
/**
CB_CIRCUIT_BREAKER_G220		Leistungsschalter (Circuit breaker CB)	

IEC
SPC-Attribute:	 	HMK_CB_GROUP_CAPTION_1011270	Leistungsschalter
  VT_G220_M00614	IEC_CIRCUIT_BREAKER
    HMK_VALUE_VALID_G220		      Flag: Eintrag ist gültig
    HMK_CB_GROUP_CAPTION_1011270	Leistungsschalter
    HMK_MOTORNORM_G220			      Motornorm
    PMD_ABJ176_001_000_G220		    Schutzart IP
    HMK_CB_IEC_MEV_1011410_X	    HMK_CB_IEC_MEV_G220                       nicht "."
    HMK_CB_IEC_ICC_1011270_X	    Bedingter Kurzschlussstrom ICC
    HMK_CB_IEC_MEV_FT_1011410_X	  HMK_CB_IEC_MEV_FT_G220
    HMK_CB_IEC_MLFB_1011270		    HMK_CB_IEC_MLFB_G220			mit Platzhaltern
    HMK_VOLTAGE_PW_KEY_1011270	  Voltage_Power Key
    HMK_TOPOLOGY_G220			        HMK_TOPOLOGY_G220
    HMK_REP_SWITCH__G220		      Wartungsschalter
    HMK_CB_IEC_ICC_V_1011270	    HMK_CB_IEC_ICC_V_G220

  VT_G220_M00620	ONE_LINE_PW_COMPONENT						Netz-Komponenten-Verriegelung
    HMK_MOTORNORM_G220				Motornorm
    HMK_CB_GROUP_CAPTION_1011270	Leistungsschalter
    HMK_CB_UL_G_CAPTION_1011270		Leistungsschalter
    HMK_MS_IEC_G_CAPTION_1011270	Motorschutzschalter
    HMK_MS_UL_G_CAPTION_1011270		Kombinationsmot.../E
    HMK_SCFUSE_G_CAPTION_1011270	Halbleitersicherung
    HMK_SCF_UL_G_CAPTION_1011270	Halbleitersicherung
    HMK_FUSE_G_CAPTION_1011270		Standardsicherung

n.n.	VT_G220_M00624	VOLTAGE vs CB_IEC_ICC_V
    HMK_MOTORNORM_G220				    Motornorm
    HMK_CB_GROUP_CAPTION_1011270	Leistungsschalter
    HMK_DISCR_VOLTAGE_G220			  Netzspannung
    HMK_CB_IEC_ICC_V_1011270		  HMK_CB_IEC_ICC_V_G220

MLFB: HMK_CB_IEC_MLFB_CPL_1011270
  VT_G220_M00638	OCPD_IEC_CB_MLFB
    HMK_CB_IEC_ICPMR_REF_1011410	  HMK_CB_IEC_ICPMR_REF_G220
  neu HMK_CB_IEC_MAX_C_1011410	Bemessungsstrom, max.
    HMK_CB_IEC_MLFB_1011270			    HMK_CB_IEC_MLFB_G220			       <==     MLFB mit Platzhaltern
    HMK_CB_IEC_OC_RELEAS_1011270	  Ausführung des Überstromauslösers
==>		HMK_CB_IEC_MLFB_CPL_1011270		HMK_CB_IEC_MLFB_CPL_G220		     <==     End-MLFB
    HMK_CB_IEC_RATED_ICU_1011270_X	Ausschaltvermögen Grenzkurzschlussstrom (Icu) bei 400 V AC Bemessungswert
    HMK_CB_IEC_RC_1011510			      Bemessungsstrom
    HMK_CB_IEC_MLFB_TYPE_1011270	  Ausführung des Anschlusses

HMK_CB_IEC_RC_1011510			Bemessungsstrom
HMK_CB_IEC_ICC_1011270_X		Bedingter Kurzschlussstrom ICC
HMK_CB_IEC_RATED_ICU_1011270_X	Ausschaltvermögen Grenzkurzschlussstrom (Icu) bei 400 V AC Bemessungswert
HMK_CB_IEC_OC_RELEAS_1011270	Ausführung des Überstromauslösers
HMK_CB_IEC_MLFB_TYPE_1011270	Ausführung des Anschlusses


UL
SPC-Attribute:		HMK_CB_UL_G_CAPTION_1011270	Leistungsschalter
  VT_G220_M00615	UL_CSA_CIRCUIT_BREAKER
    HMK_CB_UL_G_CAPTION_1011270			Leistungsschalter
    HMK_MOTORNORM_G220					Motornorm
    HMK_VALUE_VALID_G220				Flag: Eintrag ist gültig
    PMD_ABJ176_001_000_G220				Schutzart IP
    HMK_CB_UL_SCCR_1011410_X			Bedingter Kurzschlussstrom SCCR
    HMK_CB_UL_MLFB_1011270				HMK_CB_UL_MLFB_G220
    HMK_CB_UL_MEV_FT_1011410_X			HMK_CB_UL_MEV_FT_G220
    HMK_CB_UL_MEV_1011410_X				HMK_CB_UL_MEV_G220              nicht "."
    HMK_VOLTAGE_PW_KEY_1011270			Voltage_Power Key
    HMK_TOPOLOGY_G220					HMK_TOPOLOGY_G220
    HMK_REP_SWITCH__G220				Wartungsschalter
    HMK_CB_UL_SCCR_V_1011270_X			HMK_CB_UL_SCCR_V_G220
    HMK_CB_UL_SCCR_V_SL_1011270			HMK_CB_UL_SCCR_V_SL_G220
    HMK_CB_UL_SCCR_SLASH_1011270_X		Bedingter Kurzschlussstrom SCCR (schräg-Spannung)
    HMK_CB_UL_VOLTAGE_R_1011270			Betriebsspannung

  VT_G220_M00620	ONE_LINE_PW_COMPONENT


MLFB:				HMK_CB_UL_MLFB_CPL_1011270
  VT_G220_M00601	UL_CB_MLFB_ASSIGNMENT
    HMK_CB_UL_OC_RELEASE_1011270	Ausführung des Überstromauslösers
    HMK_CB_UL_MLFB_CPL_1011270		HMK_CB_UL_MLFB_CPL_G220
    HMK_CB_UL_MLFB_TYPE_1011270		Ausführung des Anschlusses
    HMK_CB_UL_R_ICU_480V_1011270	Ausschaltvermögen Grenzkurzschlussstrom (Icu) bei 480 V AC Bemessungswert
    HMK_CB_UL_MLFB_C_1011270		HMK_CB_UL_MLFB_C_G220
    HMK_CB_UL_MLFB_1011270			HMK_CB_UL_MLFB_G220
    HMK_CB_UL_RC_1011270			Bemessungsstrom


HMK_CB_UL_RC_1011270			Bemessungsstrom
HMK_CB_UL_VOLTAGE_R_1011270		Betriebsspannung
HMK_CB_UL_SCCR_1011410_X		Bedingter Kurzschlussstrom SCCR
HMK_CB_UL_SCCR_SLASH_1011270_X	Bedingter Kurzschlussstrom SCCR (schräg-Spannung)
HMK_CB_UL_R_ICU_480V_1011270	Ausschaltvermögen Grenzkurzschlussstrom (Icu) bei 480 V AC Bemessungswert
HMK_CB_UL_OC_RELEASE_1011270	Ausführung des Überstromauslösers
HMK_CB_UL_MLFB_TYPE_1011270		Ausführung des Anschlusses



*/
// #########################################################################################################################
function SetCB(oData) {
  var HMK_MOTORNORM_G220 = ECL_GetValue("HMK_MOTORNORM_G220"); // 00002 IEC, 00001 NEMA/UL
  var HMK_TOPOLOGY_G220 = ECL_GetValue("HMK_TOPOLOGY_G220");
  var HMK_REP_SWITCH__G220 = "F";
  if (ECL_ValueSelected("CB_HMK_REP_SWITCH_G220", "T")) {
    HMK_REP_SWITCH__G220 = "T";
  }
  var PMD_ABJ176_001_000_G220 = ECL_GetValue("PMD_ABJ176_001_000_G220");
  var HMK_VOLTAGE_PW_KEY_1011270 = ECL_GetValue("HMK_VOLTAGE_PW_KEY_1011270");
  var HMK_CB_IEC_ICC_V_1011270 = ECL_GetValue("HMK_CB_IEC_ICC_V_1011270");
  // check if a circuit breaker is generally possible
  /*
  VT_G220_M00614	IEC_CIRCUIT_BREAKER
    HMK_VALUE_VALID_G220		Flag: Eintrag ist gültig
    HMK_CB_GROUP_CAPTION_1011270	Leistungsschalter
    HMK_MOTORNORM_G220			Motornorm
    PMD_ABJ176_001_000_G220		Schutzart IP
    HMK_CB_IEC_MEV_1011410_X	HMK_CB_IEC_MEV_G220
    HMK_CB_IEC_ICC_1011270_X	Bedingter Kurzschlussstrom ICC
    HMK_CB_IEC_MEV_FT_1011410_X	HMK_CB_IEC_MEV_FT_G220
    HMK_CB_IEC_MLFB_1011270		HMK_CB_IEC_MLFB_G220			mit Platzhaltern
    HMK_VOLTAGE_PW_KEY_1011270	Voltage_Power Key
    HMK_TOPOLOGY_G220			HMK_TOPOLOGY_G220
    HMK_REP_SWITCH__G220		Wartungsschalter
    HMK_CB_IEC_ICC_V_1011270	HMK_CB_IEC_ICC_V_G220
    */
  if (HMK_MOTORNORM_G220 == "00002") {
    // IEC
    var sTable = "VT_G220_M00614" + sDB_Suffix;
    var sSQL =
      "SELECT * FROM " + sTable + " WHERE " +
      "HMK_MOTORNORM_G220 = '" + HMK_MOTORNORM_G220 + "' AND " +
      "HMK_VOLTAGE_PW_KEY_1011270 = '" + HMK_VOLTAGE_PW_KEY_1011270 + "' AND " +
      HMK_CB_IEC_ICC_V_1011270 + " AND " +
      "HMK_TOPOLOGY_G220 = '" + HMK_TOPOLOGY_G220 + "' AND " +
      "PMD_ABJ176_001_000_G220 = '" + PMD_ABJ176_001_000_G220 + "' AND " +
      "HMK_CB_IEC_ICC_1011270_X <> '.' AND " +
      "HMK_CB_IEC_MLFB_1011270 <> '-' AND " +
      //"HMK_CB_IEC_MEV_1011410_X <> '.' AND " +
      "HMK_CB_GROUP_CAPTION_1011270 = 'T' AND " +
      "HMK_VALUE_VALID_G220 = 'T';";

    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length < 1) {
      ECL_DeselectAttribute("CB_CIRCUIT_BREAKER_G220");
      return;
    }
  } else {
    // NEMA
    var bStraight = false;
    var bSlash = false;

    var sTable = "VT_G220_M00615" + sDB_Suffix;
    var sSQL =
      "SELECT * FROM " + sTable + " WHERE " +
      "HMK_MOTORNORM_G220 = '" + HMK_MOTORNORM_G220 + "' AND " +
      "HMK_VOLTAGE_PW_KEY_1011270 = '" + HMK_VOLTAGE_PW_KEY_1011270 + "' AND " +
      "HMK_TOPOLOGY_G220 = '" + HMK_TOPOLOGY_G220 + "' AND " +
      "PMD_ABJ176_001_000_G220 = '" + PMD_ABJ176_001_000_G220 + "' AND " +
      "HMK_CB_UL_SCCR_1011410_X <> '.' AND " +
      "HMK_CB_UL_MLFB_1011270 <> 'NONE' AND " +
      "HMK_CB_UL_VOLTAGE_R_1011270 = '00002' AND " +
      //"HMK_CB_UL_MEV_1011410_X <> '.' AND " +
      "HMK_CB_UL_G_CAPTION_1011270 = 'T' AND " +
      "HMK_VALUE_VALID_G220 = 'T';";

    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length > 0) {
      bStraight = true;
    } else {
      bStraight = false;
      var sSQL =
        "SELECT * FROM " + sTable + " WHERE " +
        "HMK_MOTORNORM_G220 = '" + HMK_MOTORNORM_G220 + "' AND " +
        "HMK_VOLTAGE_PW_KEY_1011270 = '" + HMK_VOLTAGE_PW_KEY_1011270 + "' AND " +
        "HMK_TOPOLOGY_G220 = '" + HMK_TOPOLOGY_G220 + "' AND " +
        "PMD_ABJ176_001_000_G220 = '" + PMD_ABJ176_001_000_G220 + "' AND " +
        "HMK_CB_UL_SCCR_SLASH_1011270_X <> '.' AND " +
        "HMK_CB_UL_MLFB_1011270 <> 'NONE' AND " +
        "HMK_CB_UL_VOLTAGE_R_1011270 = '00003' AND " +
        //"HMK_CB_UL_MEV_1011410_X <> '.' AND " +
        "HMK_CB_UL_G_CAPTION_1011270 = 'T' AND " +
        "HMK_VALUE_VALID_G220 = 'T';";

      var aResult = GetDBDataSetEXT(sSQL);
      if (aResult.length > 0) {
        bSlash = true;
      } else {
        bSlash = false;
      }
    }
    /*VT_G220_M00615	UL_CSA_CIRCUIT_BREAKER
        HMK_CB_UL_G_CAPTION_1011270			Leistungsschalter
        HMK_MOTORNORM_G220					Motornorm
        HMK_VALUE_VALID_G220				Flag: Eintrag ist gültig
        PMD_ABJ176_001_000_G220				Schutzart IP
        HMK_CB_UL_SCCR_1011410_X			Bedingter Kurzschlussstrom SCCR
        HMK_CB_UL_MLFB_1011270				HMK_CB_UL_MLFB_G220
        HMK_CB_UL_MEV_FT_1011410_X			HMK_CB_UL_MEV_FT_G220
        HMK_CB_UL_MEV_1011410_X				HMK_CB_UL_MEV_G220
        HMK_VOLTAGE_PW_KEY_1011270			Voltage_Power Key
        HMK_TOPOLOGY_G220					HMK_TOPOLOGY_G220
        HMK_REP_SWITCH__G220				Wartungsschalter
        HMK_CB_UL_SCCR_V_1011270_X			HMK_CB_UL_SCCR_V_G220
        HMK_CB_UL_SCCR_V_SL_1011270			HMK_CB_UL_SCCR_V_SL_G220
        HMK_CB_UL_SCCR_SLASH_1011270_X		Bedingter Kurzschlussstrom SCCR (schräg-Spannung)
        HMK_CB_UL_VOLTAGE_R_1011270			Betriebsspannung
    */

    if (!bStraight && !bSlash) {
      ECL_DeselectAttribute("CB_CIRCUIT_BREAKER_G220");
      return;
    }
  }

  // get MLFB-list for compare to sec-mlfb
  // IEC:
  var sTable_IEC = "VT_G220_M00638" + sDB_Suffix;
  var sSQL_IEC = "SELECT DISTINCT HMK_CB_IEC_MLFB_CPL_1011270 AS VALUE FROM " + sTable_IEC + " WHERE HMK_CB_IEC_MLFB_CPL_1011270 <> '-';";

  var aResult_IEC = GetDBDataSetEXT(sSQL_IEC);

  if (!aResult_IEC || aResult_IEC.length < 1) {
    oData.strError = "DICT1_ERR_G220___PARSER_CB";
    return;
  }
  // UL:
  var sTable_UL = "VT_G220_M00601" + sDB_Suffix;
  var sSQL_UL = "SELECT DISTINCT HMK_CB_UL_MLFB_CPL_1011270 AS VALUE FROM " + sTable_UL + " WHERE HMK_CB_UL_MLFB_CPL_1011270 <> '-';";
  var aResult_UL = GetDBDataSetEXT(sSQL_UL);

  if (!aResult_UL || aResult_UL.length < 1) {
    oData.strError = "DICT1_ERR_G220___PARSER_CB";
    return;
  }

  var bCB = false;
  var bIEC = false;

  var sECSI_MLFB_SEC = GetMlfbSec() || "";
  if (sECSI_MLFB_SEC !== "") {
    var secondaryMlfbArray = sECSI_MLFB_SEC.split(";");

    for (var i = 0; i < secondaryMlfbArray.length; i++) {
      for (var j = 0; j < aResult_IEC.length; j++) {
        if (secondaryMlfbArray[i] === aResult_IEC[j].VALUE) {
          ECL_SelectValue("CB_CIRCUIT_BREAKER_G220", "T");

          bCB = true;
          bIEC = true;
          var sMLFB_CB = secondaryMlfbArray[i];
          // alte MLFB gefunden, Werte bestimmen
          break;
        }
      }
      if (bCB) {
        break;
      }
      // wenn kein Wert gefunden, UL prüfen:
      //if (!bCB) {
      for (var j = 0; j < aResult_UL.length; j++) {
        if (secondaryMlfbArray[i] === aResult_UL[j].VALUE) {
          ECL_SelectValue("CB_CIRCUIT_BREAKER_G220", "T");

          bCB = true;
          bIEC = false;
          var sMLFB_CB = secondaryMlfbArray[i];
          break;
        }
        if (bCB) {
          break;
        }
      }
    }
    if (!bCB) {
      // wenn nichts gefunden, kein Leistungsschalter konfiguriert
      ECL_DeselectAttribute("CB_CIRCUIT_BREAKER_G220");
      return;
    }

    // gefundene MLFB: sMLFB_CB
    // wenn IEC gefunden bIEC = true;
    if (sMLFB_CB && sMLFB_CB !== "" && bIEC) {
      /* alte MLFB gefunden, Werte bestimmen
      über VT638 und VT614
      
        HMK_CB_IEC_RC_1011510			      Bemessungsstrom
        HMK_CB_IEC_ICC_1011270_X		    Bedingter Kurzschlussstrom ICC
        HMK_CB_IEC_RATED_ICU_1011270_X	Ausschaltvermögen Grenzkurzschlussstrom (Icu) bei 400 V AC Bemessungswert
        HMK_CB_IEC_OC_RELEAS_1011270	  Ausführung des Überstromauslösers
        HMK_CB_IEC_MLFB_TYPE_1011270	  Ausführung des Anschlusses
  
      A  VT_G220_M00638	OCPD_IEC_CB_MLFB
          nn  HMK_CB_IEC_ICPMR_REF_1011410	  HMK_CB_IEC_ICPMR_REF_G220
          neu HMK_CB_IEC_MAX_C_1011410	Bemessungsstrom, max.
            HMK_CB_IEC_MLFB_1011270			    HMK_CB_IEC_MLFB_G220			       <==     MLFB mit Platzhaltern
            HMK_CB_IEC_OC_RELEAS_1011270	  Ausführung des Überstromauslösers
        ==>		HMK_CB_IEC_MLFB_CPL_1011270		HMK_CB_IEC_MLFB_CPL_G220		     <==     End-MLFB
            HMK_CB_IEC_RATED_ICU_1011270_X	Ausschaltvermögen Grenzkurzschlussstrom (Icu) bei 400 V AC Bemessungswert
            HMK_CB_IEC_RC_1011510			      Bemessungsstrom
            HMK_CB_IEC_MLFB_TYPE_1011270	  Ausführung des Anschlusses
      
      B  VT_G220_M00614	IEC_CIRCUIT_BREAKER
            HMK_VALUE_VALID_G220		      Flag: Eintrag ist gültig
            HMK_CB_GROUP_CAPTION_1011270	Leistungsschalter
            HMK_MOTORNORM_G220			      Motornorm
            PMD_ABJ176_001_000_G220		    Schutzart IP
          nicht '.'  HMK_CB_IEC_MEV_1011410_X	    HMK_CB_IEC_MEV_G220
            HMK_CB_IEC_ICC_1011270_X	    Bedingter Kurzschlussstrom ICC
          nn  HMK_CB_IEC_MEV_FT_1011410_X	  HMK_CB_IEC_MEV_FT_G220
            HMK_CB_IEC_MLFB_1011270		    HMK_CB_IEC_MLFB_G220			mit Platzhaltern
            HMK_VOLTAGE_PW_KEY_1011270	  Voltage_Power Key
            HMK_TOPOLOGY_G220			        HMK_TOPOLOGY_G220
            HMK_REP_SWITCH__G220		      Wartungsschalter
            HMK_CB_IEC_ICC_V_1011270	    HMK_CB_IEC_ICC_V_G220
  
        MLFB: HMK_CB_IEC_MLFB_CPL_1011270
    */
      var sTableA = "VT_G220_M00638" + sDB_Suffix;
      var sTableB = "VT_G220_M00614" + sDB_Suffix;
      var sSQL =
        "SELECT VT_TABLE_A.*, VT_TABLE_B.HMK_CB_IEC_ICC_1011270_X " +
        "FROM " + sTableA + " As VT_TABLE_A " +
        "INNER JOIN " + sTableB + " As VT_TABLE_B " +
        "ON VT_TABLE_A.HMK_CB_IEC_MLFB_1011270 = VT_TABLE_B.HMK_CB_IEC_MLFB_1011270 " +
        "WHERE " +
        //"VT_TABLE_B.HMK_MOTORNORM_G220 = '" + HMK_MOTORNORM_G220 + "' AND " +
        //"VT_TABLE_B.PMD_ABJ176_001_000_G220 = '" + PMD_ABJ176_001_000_G220 + "' AND " +
        "VT_TABLE_B.HMK_CB_GROUP_CAPTION_1011270 = 'T' AND " +
        //"VT_TABLE_B.HMK_CB_IEC_MEV_1011410_X <> '.' AND " +
        "VT_TABLE_A.HMK_CB_IEC_MLFB_CPL_1011270 = '" + sMLFB_CB + "' AND " +
        HMK_CB_IEC_ICC_V_1011270 + " AND " +
        "VT_TABLE_B.HMK_VALUE_VALID_G220 = 'T';";

      var aResult_old = GetDBDataSetEXT(sSQL);
      if (aResult_old.length > 0) {
        /**
         * HMK_CB_IEC_RC_1011510			    Bemessungsstrom
         * neu HMK_CB_IEC_MAX_C_1011410	Bemessungsstrom, max.
         * HMK_CB_IEC_ICC_1011270_X		    Bedingter Kurzschlussstrom ICC
         * HMK_CB_IEC_RATED_ICU_1011270_X	Ausschaltvermögen Grenzkurzschlussstrom (Icu) bei 400 V AC Bemessungswert
         * HMK_CB_IEC_OC_RELEAS_1011270	  Ausführung des Überstromauslösers
         * HMK_CB_IEC_MLFB_TYPE_1011270	  Ausführung des Anschlusses
         */
        var HMK_CB_IEC_RC_1011510 = aResult_old[0].HMK_CB_IEC_RC_1011510;
        var HMK_CB_IEC_MAX_C_1011410 = aResult_old[0].HMK_CB_IEC_MAX_C_1011410;
        var HMK_CB_IEC_ICC_1011270_X = aResult_old[0].HMK_CB_IEC_ICC_1011270_X; // nicht eindeutig, hier muss der Wert dem Wert von HMK_CB_IEC_RATED_ICU_1011270_X entsprechen?!?
        var HMK_CB_IEC_RATED_ICU_1011270_X = aResult_old[0].HMK_CB_IEC_RATED_ICU_1011270_X;
        var HMK_CB_IEC_OC_RELEAS_1011270 = aResult_old[0].HMK_CB_IEC_OC_RELEAS_1011270;
        var HMK_CB_IEC_MLFB_TYPE_1011270 = aResult_old[0].HMK_CB_IEC_MLFB_TYPE_1011270;
      } else {
        oData.strError = "DICT1_ERR_G220___PARSER_CB";
        return;
      }
      // IEC-MLFB für IEC-Norm, kann direkt gesetzt werden
      if (HMK_MOTORNORM_G220 == "00002") {
        // IEC, MLFB passt
        ECL_ActivateValue("HMK_CB_IEC_RC_1011510", HMK_CB_IEC_RC_1011510);
        ECL_SelectValue("HMK_CB_IEC_RC_1011510", HMK_CB_IEC_RC_1011510);
        ECL_ActivateValue("HMK_CB_IEC_MAX_C_1011410", HMK_CB_IEC_MAX_C_1011410);
        ECL_SelectValue("HMK_CB_IEC_MAX_C_1011410", HMK_CB_IEC_MAX_C_1011410);

        ECL_ActivateValue("HMK_CB_IEC_ICC_1011270_X", HMK_CB_IEC_ICC_1011270_X);
        ECL_SelectValue("HMK_CB_IEC_ICC_1011270_X", HMK_CB_IEC_ICC_1011270_X);
        ECL_ActivateValue("HMK_CB_IEC_RATED_ICU_1011270_X", HMK_CB_IEC_RATED_ICU_1011270_X);
        ECL_SelectValue("HMK_CB_IEC_RATED_ICU_1011270_X", HMK_CB_IEC_RATED_ICU_1011270_X);
        ECL_ActivateValue("HMK_CB_IEC_OC_RELEAS_1011270", HMK_CB_IEC_OC_RELEAS_1011270);
        ECL_SelectValue("HMK_CB_IEC_OC_RELEAS_1011270", HMK_CB_IEC_OC_RELEAS_1011270);
        ECL_ActivateValue("HMK_CB_IEC_MLFB_TYPE_1011270", HMK_CB_IEC_MLFB_TYPE_1011270);
        ECL_SelectValue("HMK_CB_IEC_MLFB_TYPE_1011270", HMK_CB_IEC_MLFB_TYPE_1011270);
      } else {
        //UL, MLFB uebersetzen (für KeepConfig)
        // Werte von IEC-MLFB abfragen und als UL setzen nicht ohne weiteres möglich
        /* todo  */
      }
    } else if (sMLFB_CB && sMLFB_CB !== "" && !bIEC) {
      /* UL-MLFB
          UL
          SPC-Attribute:		HMK_CB_UL_G_CAPTION_1011270	Leistungsschalter
         B   VT_G220_M00615	UL_CSA_CIRCUIT_BREAKER
              HMK_CB_UL_G_CAPTION_1011270			Leistungsschalter
              HMK_MOTORNORM_G220				    	Motornorm
              HMK_VALUE_VALID_G220			    	Flag: Eintrag ist gültig
              PMD_ABJ176_001_000_G220		  		Schutzart IP
              HMK_CB_UL_SCCR_1011410_X	  		Bedingter Kurzschlussstrom SCCR
              HMK_CB_UL_MLFB_1011270		  		HMK_CB_UL_MLFB_G220
              HMK_CB_UL_MEV_FT_1011410_X			HMK_CB_UL_MEV_FT_G220
              HMK_CB_UL_MEV_1011410_X			  	HMK_CB_UL_MEV_G220
              HMK_VOLTAGE_PW_KEY_1011270			Voltage_Power Key
              HMK_TOPOLOGY_G220				      	HMK_TOPOLOGY_G220
              HMK_REP_SWITCH__G220		    		Wartungsschalter
              HMK_CB_UL_SCCR_V_1011270_X			HMK_CB_UL_SCCR_V_G220
              HMK_CB_UL_SCCR_V_SL_1011270			HMK_CB_UL_SCCR_V_SL_G220
              HMK_CB_UL_SCCR_SLASH_1011270_X	Bedingter Kurzschlussstrom SCCR (schräg-Spannung)
              HMK_CB_UL_VOLTAGE_R_1011270			Betriebsspannung
  
            VT_G220_M00620	ONE_LINE_PW_COMPONENT
  
  
          MLFB:				HMK_CB_UL_MLFB_CPL_1011270
          A  VT_G220_M00601	UL_CB_MLFB_ASSIGNMENT
              HMK_CB_UL_OC_RELEASE_1011270	Ausführung des Überstromauslösers
              HMK_CB_UL_MLFB_CPL_1011270		HMK_CB_UL_MLFB_CPL_G220
              HMK_CB_UL_MLFB_TYPE_1011270		Ausführung des Anschlusses
              HMK_CB_UL_R_ICU_480V_1011270	Ausschaltvermögen Grenzkurzschlussstrom (Icu) bei 480 V AC Bemessungswert
              HMK_CB_UL_MLFB_C_1011270		HMK_CB_UL_MLFB_C_G220
              HMK_CB_UL_MLFB_1011270			HMK_CB_UL_MLFB_G220
              HMK_CB_UL_RC_1011270			Bemessungsstrom
  
  
          HMK_CB_UL_RC_1011270			Bemessungsstrom
          HMK_CB_UL_VOLTAGE_R_1011270		Betriebsspannung
          HMK_CB_UL_SCCR_1011410_X		Bedingter Kurzschlussstrom SCCR
          HMK_CB_UL_SCCR_SLASH_1011270_X	Bedingter Kurzschlussstrom SCCR (schräg-Spannung)
          HMK_CB_UL_R_ICU_480V_1011270	Ausschaltvermögen Grenzkurzschlussstrom (Icu) bei 480 V AC Bemessungswert
          HMK_CB_UL_OC_RELEASE_1011270	Ausführung des Überstromauslösers
          HMK_CB_UL_MLFB_TYPE_1011270		Ausführung des Anschlusses
    */
      if (bStraight) {
        var HMK_CB_UL_VOLTAGE_R_1011270 = "00002";
      } else if (bSlash) {
        var HMK_CB_UL_VOLTAGE_R_1011270 = "00003";
      }
      var sTableA = "VT_G220_M00601" + sDB_Suffix;
      var sTableB = "VT_G220_M00615" + sDB_Suffix;
      var sSQL =
        "SELECT * " +
        "FROM " + sTableA + " As VT_TABLE_A " +
        "INNER JOIN " + sTableB + " As VT_TABLE_B " +
        "ON VT_TABLE_A.HMK_CB_UL_MLFB_1011270 = VT_TABLE_B.HMK_CB_UL_MLFB_1011270 " +
        "WHERE " +
        "VT_TABLE_B.HMK_MOTORNORM_G220 = '" + HMK_MOTORNORM_G220 + "' AND " +
        "VT_TABLE_B.PMD_ABJ176_001_000_G220 = '" + PMD_ABJ176_001_000_G220 + "' AND " +
        "VT_TABLE_B.HMK_VOLTAGE_PW_KEY_1011270 = '" + HMK_VOLTAGE_PW_KEY_1011270 + "' AND " +
        "VT_TABLE_B.HMK_TOPOLOGY_G220 = '" + HMK_TOPOLOGY_G220 + "' AND " +
        "VT_TABLE_B.HMK_REP_SWITCH__G220 = '" + HMK_REP_SWITCH__G220 + "' AND " +
        "VT_TABLE_B.HMK_CB_UL_VOLTAGE_R_1011270 = '" + HMK_CB_UL_VOLTAGE_R_1011270 + "' AND " +
        "VT_TABLE_B.HMK_CB_UL_G_CAPTION_1011270 = 'T' AND " +
        //"VT_TABLE_B.HMK_CB_UL_SCCR_SLASH_1011270_X <> '.' AND " +
        //"VT_TABLE_B.HMK_CB_UL_MEV_1011410_X <> '.' AND " +
        "VT_TABLE_A.HMK_CB_UL_MLFB_CPL_1011270 = '" + sMLFB_CB + "' AND " +
        "VT_TABLE_B.HMK_VALUE_VALID_G220 = 'T';";

      var aResult_old = GetDBDataSetEXT(sSQL);
      if (aResult_old.length > 0) {
        /**
         * HMK_CB_UL_RC_1011270			Bemessungsstrom
         * HMK_CB_UL_VOLTAGE_R_1011270		Betriebsspannung
         * HMK_CB_UL_SCCR_1011410_X		    Bedingter Kurzschlussstrom SCCR
         * HMK_CB_UL_SCCR_SLASH_1011270_X	Bedingter Kurzschlussstrom SCCR (schräg-Spannung)
         * HMK_CB_UL_R_ICU_480V_1011270	  Ausschaltvermögen Grenzkurzschlussstrom (Icu) bei 480 V AC Bemessungswert
         * HMK_CB_UL_OC_RELEASE_1011270	  Ausführung des Überstromauslösers
         * HMK_CB_UL_MLFB_TYPE_1011270		Ausführung des Anschlusses
         */
        var HMK_CB_UL_RC_1011270 = aResult_old[0].HMK_CB_UL_RC_1011270;
        var HMK_CB_UL_SCCR_1011410_X = aResult_old[0].HMK_CB_UL_SCCR_1011410_X; // nicht eindeutig, hier muss der Wert dem Wert von HMK_CB_UL_R_ICU_480V_1011270 entsprechen?!?
        var HMK_CB_UL_SCCR_SLASH_1011270_X = aResult_old[0].HMK_CB_UL_SCCR_SLASH_1011270_X;
        var HMK_CB_UL_R_ICU_480V_1011270 = aResult_old[0].HMK_CB_UL_R_ICU_480V_1011270;
        var HMK_CB_UL_OC_RELEASE_1011270 = aResult_old[0].HMK_CB_UL_OC_RELEASE_1011270;
        var HMK_CB_UL_MLFB_TYPE_1011270 = aResult_old[0].HMK_CB_UL_MLFB_TYPE_1011270;
        //var HMK_CB_UL_VOLTAGE_R_1011270 = "00002"; // nicht reproduzierbar, immer Geradspannung!
      } else {
        oData.strError = "DICT1_ERR_G220___PARSER_CB";
        return;
      }
      // UL-MLFB für UL-Norm, kann direkt gesetzt werden
      if (HMK_MOTORNORM_G220 == "00001") {
        ECL_ActivateValue("HMK_CB_UL_RC_1011270", HMK_CB_UL_RC_1011270);
        ECL_SelectValue("HMK_CB_UL_RC_1011270", HMK_CB_UL_RC_1011270);
        ECL_ActivateValue("HMK_CB_UL_SCCR_1011410_X", HMK_CB_UL_SCCR_1011410_X);
        ECL_SelectValue("HMK_CB_UL_SCCR_1011410_X", HMK_CB_UL_SCCR_1011410_X);
        ECL_ActivateValue("HMK_CB_UL_SCCR_SLASH_1011270_X", HMK_CB_UL_SCCR_SLASH_1011270_X);
        ECL_SelectValue("HMK_CB_UL_SCCR_SLASH_1011270_X", HMK_CB_UL_SCCR_SLASH_1011270_X);
        ECL_ActivateValue("HMK_CB_UL_R_ICU_480V_1011270", HMK_CB_UL_R_ICU_480V_1011270);
        ECL_SelectValue("HMK_CB_UL_R_ICU_480V_1011270", HMK_CB_UL_R_ICU_480V_1011270);
        ECL_ActivateValue("HMK_CB_UL_OC_RELEASE_1011270", HMK_CB_UL_OC_RELEASE_1011270);
        ECL_SelectValue("HMK_CB_UL_OC_RELEASE_1011270", HMK_CB_UL_OC_RELEASE_1011270);
        ECL_ActivateValue("HMK_CB_UL_MLFB_TYPE_1011270", HMK_CB_UL_MLFB_TYPE_1011270);
        ECL_SelectValue("HMK_CB_UL_MLFB_TYPE_1011270", HMK_CB_UL_MLFB_TYPE_1011270);
        ECL_ActivateValue("HMK_CB_UL_VOLTAGE_R_1011270", HMK_CB_UL_VOLTAGE_R_1011270);
        ECL_SelectValue("HMK_CB_UL_VOLTAGE_R_1011270", HMK_CB_UL_VOLTAGE_R_1011270);
      } else {
        //UL, MLFB uebersetzen (für KeepConfig)
        // Werte von IEC-MLFB abfragen und als UL setzen nicht ohne weiteres möglich
        /* todo */
      }
    }
  }
}

// #########################################################################################################################
/**
CB_MS_G220	Motorschutzschalter
CB_MS_UL_G220	==>	für UL eigene Checkbox	HMK_MS_UL_G_CAPTION_1011270		Kombinationsmotorsteuerungen Typ E


IEC
SPC-Attribute:				HMK_MS_IEC_G_CAPTION_1011270	Motorschutzschalter

HMK_MS_IEC_MLFB_CPL_1011270		HMK_MS_IEC_MLFB_CPL_G220

HMK_MS_IEC_RC_1011270			Bemessungsstrom
HMK_MS_IEC_ICC_1011270_X		Bedingter Kurzschlussstrom ICC
HMK_MS_IEC_RATED_ICU_1011270_X	Ausschaltvermögen Grenzkurzschlussstrom (Icu) bei 400 V AC Bemessungswert
HMK_MS_IEC_FS_1011270			Baugröße des Schutzgerätes
HMK_MS_IEC_MLFB_TYPE_1011270	Ausführung des elektrischen Anschlusses

UL
SPC-Attribute:				HMK_MS_UL_G_CAPTION_1011270		Kombinationsmotorsteuerungen Typ E
HMK_MS_UL_MLFB_CPL_1011270	HMK_MS_UL_MLFB_CPL_G220

HMK_MS_UL_RC_1011270			Bemessungsstrom
HMK_MS_UL_VOLTAGE_R_1011270		Betriebsspannung
 HMK_MS_UL_SCCR_1011410_X		Kurzsschlussfestigkeit (SCCR)   gerade Spannung
 HMK_MS_UL_SCCR_SL_1011270_X	Kurzsschlussfestigkeit (SCCR)	Schrägspannung
HMK_MS_UL_RATED_ICU_1011270_X	Ausschaltvermögen Grenzkurzschlussstrom (Icu) des CMB bei 400 V
HMK_MS_UL_FS_1011270			Baugröße des CMB
HMK_MS_UL_MLFB_TYPE_1011270		Ausführung des elektrischen Anschlusses

VT_G220_M00645	IEC_MOTOR_STARTER_PROTECTORS
        HMK_MS_IEC_G_CAPTION_1011270	Motorschutzschalter
        HMK_MOTORNORM_G220	Motornorm
        HMK_MS_IEC_MEV_1011410_X	HMK_MS_IEC_MEV_G220
        HMK_MS_IEC_MEV_FT_1011410_X	HMK_MS_IEC_MEV_FT_G220
        HMK_MS_IEC_MLFB_1011270	HMK_MS_IEC_MLFB_G220
        HMK_VALUE_VALID_G220	Flag: Eintrag ist gültig
        PMD_ABJ176_001_000_G220	Schutzart IP
        HMK_MS_IEC_ICC_1011270_X	Bedingter Kurzschlussstrom ICC
        HMK_VOLTAGE_PW_KEY_1011270	Voltage_Power Key
        HMK_TOPOLOGY_G220	HMK_TOPOLOGY_G220
        HMK_REP_SWITCH__G220	Wartungsschalter
        HMK_MS_IEC_ICC_V_1011270_X	HMK_MS_IEC_ICC_V_G220
*/
// #########################################################################################################################
function SetMS(oData) {
  var HMK_MOTORNORM_G220 = ECL_GetValue("HMK_MOTORNORM_G220");
  var HMK_VOLTAGE_PW_KEY_1011270 = ECL_GetValue("HMK_VOLTAGE_PW_KEY_1011270");
  var HMK_MS_IEC_ICC_V_1011270_X = ECL_GetValue("HMK_MS_IEC_ICC_V_1011270_X");
  var HMK_TOPOLOGY_G220 = ECL_GetValue("HMK_TOPOLOGY_G220");
  var PMD_ABJ176_001_000_G220 = ECL_GetValue("PMD_ABJ176_001_000_G220");
  var HMK_REP_SWITCH__G220 = "F";
  if (ECL_ValueSelected("CB_HMK_REP_SWITCH_G220", "T")) {
    HMK_REP_SWITCH__G220 = "T";
  }

  // check if possible
  if (HMK_MOTORNORM_G220 == "00002") {
    ECL_ActivateAttribute("CB_MS_G220", "T");
    ECL_DeactivateAttribute("CB_MS_UL_G220", "T");

    var sTable = "VT_G220_M00645" + sDB_Suffix;
    var sSQL =
      "SELECT * FROM " + sTable + " WHERE " +
      "HMK_MOTORNORM_G220 = '" + HMK_MOTORNORM_G220 + "' AND " +
      "HMK_VOLTAGE_PW_KEY_1011270 = '" + HMK_VOLTAGE_PW_KEY_1011270 + "' AND " +
      HMK_MS_IEC_ICC_V_1011270_X + " AND " +
      "HMK_TOPOLOGY_G220 = '" + HMK_TOPOLOGY_G220 + "' AND " +
      "PMD_ABJ176_001_000_G220 = '" + PMD_ABJ176_001_000_G220 + "' AND " +
      // "HMK_MS_IEC_MEV_1011410_X <> '.' AND " +
      "HMK_MS_IEC_MLFB_1011270 <> '-' AND " +
      "HMK_MS_IEC_G_CAPTION_1011270 = 'T' AND " +
      "HMK_VALUE_VALID_G220 = 'T';";

    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length < 1) {
      return;
    }
  } else {
    ECL_DeactivateAttribute("CB_MS_G220", "T");
    ECL_ActivateAttribute("CB_MS_UL_G220", "T");
    /*
  VT_G220_M00646	UL_CSA_TYPE_E_CMC
    HMK_VALUE_VALID_G220	Flag: Eintrag ist gültig
    HMK_MS_UL_G_CAPTION_1011270	Kombinationsmot.../E
    HMK_MOTORNORM_G220	Motornorm
    PMD_ABJ176_001_000_G220	Schutzart IP
    HMK_VOLTAGE_PW_KEY_1011270	Voltage_Power Key
    HMK_TOPOLOGY_G220	HMK_TOPOLOGY_G220
    HMK_REP_SWITCH__G220	Wartungsschalter
    HMK_MS_UL_SCCR_1011410_X	Kurzsschlussfestigkeit (SCCR)
    HMK_MS_UL_MEV_1011410_X	HMK_MS_UL_MEV_G220
    HMK_MS_UL_SCCR_V_1011270	HMK_MS_UL_SCCR_V_G220
    HMK_MS_UL_MLFB_1011410	HMK_MS_UL_MLFB_G220
    HMK_MS_UL_MEV_FT_1011410_X	HMK_MS_UL_MEV_FT_G220
    HMK_MS_UL_SCCR_V_SL_G220	HMK_MS_UL_SCCR_V_SL_G220
    HMK_MS_UL_SCCR_SL_1011270_X	Kurzsschlussfestigkeit (SCCR) Schrägspannung
    HMK_MS_UL_VOLTAGE_R_1011270	Betriebsspannung
  */
    var bStraight = false;
    var bSlash = false;

    var sTable = "VT_G220_M00646" + sDB_Suffix;
    var sSQL_straight =
      "SELECT * FROM " + sTable + " WHERE " +
      "HMK_MOTORNORM_G220 = '" + HMK_MOTORNORM_G220 + "' AND " +
      "HMK_VOLTAGE_PW_KEY_1011270 = '" + HMK_VOLTAGE_PW_KEY_1011270 + "' AND " +
      "HMK_TOPOLOGY_G220 = '" + HMK_TOPOLOGY_G220 + "' AND " +
      "PMD_ABJ176_001_000_G220 = '" + PMD_ABJ176_001_000_G220 + "' AND " +
      "HMK_MS_UL_SCCR_1011410_X <> '.' AND " +
      "HMK_MS_UL_MLFB_1011410 <> '-' AND " +
      "HMK_MS_UL_VOLTAGE_R_1011270 = '00002' AND " +
      "HMK_MS_UL_G_CAPTION_1011270 = 'T' AND " +
      "HMK_VALUE_VALID_G220 = 'T';";

    var aResult = GetDBDataSetEXT(sSQL_straight);
    if (aResult.length < 1) {
      bStraight = false;
      var sSQL_slash =
        "SELECT * FROM " + sTable + " WHERE " +
        "HMK_MOTORNORM_G220 = '" + HMK_MOTORNORM_G220 + "' AND " +
        "HMK_VOLTAGE_PW_KEY_1011270 = '" + HMK_VOLTAGE_PW_KEY_1011270 + "' AND " +
        "HMK_TOPOLOGY_G220 = '" + HMK_TOPOLOGY_G220 + "' AND " +
        "PMD_ABJ176_001_000_G220 = '" + PMD_ABJ176_001_000_G220 + "' AND " +
        "HMK_MS_UL_SCCR_SL_1011270_X <> '.' AND " +
        "HMK_MS_UL_MLFB_1011410 <> '-' AND " +
        "HMK_MS_UL_VOLTAGE_R_1011270 = '00003' AND " +
        "HMK_MS_UL_G_CAPTION_1011270 = 'T' AND " +
        "HMK_VALUE_VALID_G220 = 'T';";
      var aResult = GetDBDataSetEXT(sSQL_slash);
      if (aResult.length < 1) {
        return;
      } else {
        bSlash = true;
      }
    } else {
      bStraight = true;
    }
  }

  // IEC:
  var aResult_IEC = [];
  if (HMK_MOTORNORM_G220 == "00002") {
    var sTable_IEC = "VT_G220_M00603" + sDB_Suffix;
    var sSQL_IEC = "SELECT DISTINCT HMK_MS_IEC_MLFB_CPL_1011270 AS VALUE FROM " + sTable_IEC + " WHERE " +
      "HMK_MS_IEC_MLFB_CPL_1011270 <> '-';";

    aResult_IEC = GetDBDataSetEXT(sSQL_IEC);

    if (!aResult_IEC || aResult_IEC.length < 1) {
      oData.strError = "DICT1_ERR_G220___PARSER_MS";
      return;
    }
  }

  // UL:
  var aResult_UL = [];
  if (HMK_MOTORNORM_G220 == "00001") {
    var sTable_UL = "VT_G220_M00602" + sDB_Suffix;
    var sSQL_UL = "SELECT DISTINCT HMK_MS_UL_MLFB_CPL_1011270 AS VALUE FROM " + sTable_UL + " WHERE " +
      "HMK_MS_UL_MLFB_CPL_1011270 <> '-';";

    aResult_UL = GetDBDataSetEXT(sSQL_UL);

    if (!aResult_UL || aResult_UL.length < 1) {
      oData.strError = "DICT1_ERR_G220___PARSER_MS";
      return;
    }
  }
  var bMS = false;

  var sECSI_MLFB_SEC = GetMlfbSec() || "";
  if (sECSI_MLFB_SEC !== "") {
    var secondaryMlfbArray = sECSI_MLFB_SEC.split(";");

    for (var i = 0; i < secondaryMlfbArray.length; i++) {
      for (var j = 0; j < aResult_IEC.length; j++) {
        if (secondaryMlfbArray[i] === aResult_IEC[j].VALUE) {
          if (HMK_MOTORNORM_G220 == "00002") {
            ECL_SelectValue("CB_MS_G220", "T");
          } else {
            ECL_SelectValue("CB_MS_UL_G220", "T");
          }
          bMS = true;

          var sMLFB_MS = secondaryMlfbArray[i];
          /*
            VT_G220_M00603	OCPD_IEC_MS_MLFB
              HMK_MS_IEC_ICPMR_REF_1011270	HMK_MS_IEC_ICPMR_REF_G220
              HMK_MS_IEC_RC_1011270			Bemessungsstrom
              HMK_MS_IEC_MLFB_1011270			HMK_MS_IEC_MLFB_G220
              HMK_MS_IEC_MLFB_TYPE_1011270	Ausführung /...Anschlusses
              HMK_MS_IEC_FS_1011270			Baugröße des Schutzgerätes
              HMK_MS_IEC_MLFB_CPL_1011270		HMK_MS_IEC_MLFB_CPL_G220
              HMK_MS_IEC_RATED_ICU_1011270_X	Ausschaltvermög...messungswert
          */
          var sTable = "VT_G220_M00603" + sDB_Suffix;
          var sSQL = "SELECT * FROM " + sTable + " WHERE " + "HMK_MS_IEC_MLFB_CPL_1011270 = '" + sMLFB_MS + "';";

          var aResult = GetDBDataSetEXT(sSQL);
          if (aResult.length > 0) {
            var HMK_MS_IEC_MLFB_TYPE_1011270 = aResult[0].HMK_MS_IEC_MLFB_TYPE_1011270; // Ausführung des elektrischen Anschlusses
            var HMK_MS_IEC_MLFB_1011270 = aResult[0].HMK_MS_IEC_MLFB_1011270; //
            var HMK_MS_IEC_FS_1011270 = aResult[0].HMK_MS_IEC_FS_1011270; // Baugröße des Schutzgerätes
            var HMK_MS_IEC_RATED_ICU_1011270_X = aResult[0].HMK_MS_IEC_RATED_ICU_1011270_X; // Ausschaltvermögen Grenzkurzschlussstrom (Icu) bei 400 V AC Bemessungswert
            var HMK_MS_IEC_RC_1011270 = aResult[0].HMK_MS_IEC_RC_1011270; // Bemessungsstrom

            /*VT_G220_M00645	IEC_MOTOR_STARTER_PROTECTORS
                HMK_MS_IEC_G_CAPTION_1011270	Motorschutzschalter
                HMK_MOTORNORM_G220	Motornorm
                HMK_MS_IEC_MEV_1011410_X	HMK_MS_IEC_MEV_G220
                HMK_MS_IEC_MEV_FT_1011410_X	HMK_MS_IEC_MEV_FT_G220
                HMK_MS_IEC_MLFB_1011270	HMK_MS_IEC_MLFB_G220
                HMK_VALUE_VALID_G220	Flag: Eintrag ist gültig
                PMD_ABJ176_001_000_G220	Schutzart IP
                HMK_MS_IEC_ICC_1011270_X	Bedingter Kurzschlussstrom ICC
                HMK_VOLTAGE_PW_KEY_1011270	Voltage_Power Key
                HMK_TOPOLOGY_G220	HMK_TOPOLOGY_G220
                HMK_REP_SWITCH__G220	Wartungsschalter
                HMK_MS_IEC_ICC_V_1011270_X	HMK_MS_IEC_ICC_V_G220
            */
            var sTable = "VT_G220_M00645" + sDB_Suffix;
            var sSQL =
              "SELECT * FROM " + sTable + " WHERE " +
              "HMK_MOTORNORM_G220 = '00002' AND " +
              "HMK_VOLTAGE_PW_KEY_1011270 = '" + HMK_VOLTAGE_PW_KEY_1011270 + "' AND " +
              HMK_MS_IEC_ICC_V_1011270_X + " AND " +
              "HMK_TOPOLOGY_G220 = '" + HMK_TOPOLOGY_G220 + "' AND " +
              "PMD_ABJ176_001_000_G220 = '" + PMD_ABJ176_001_000_G220 + "' AND " +
              "HMK_MS_IEC_MLFB_1011270 = '" + HMK_MS_IEC_MLFB_1011270 + "' AND " +
              "HMK_VALUE_VALID_G220 = 'T';";

            var aResult2 = GetDBDataSetEXT(sSQL);
            if (aResult2.length > 0) {

              var HMK_MS_IEC_ICC_1011270_X = aResult2[0].HMK_MS_IEC_ICC_1011270_X; // Bedingter Kurzschlussstrom ICC
            } else {
              // Keep-Config: Wenn keine Lösung, passen die Werte nicht, Default durch PL
              return;
            }
          } else {
            oData.strError = "DICT1_ERR_G220___PARSER_MS";
            return;
          }
          // IEC-MLFB für IEC-Norm, kann direkt gesetzt werden
          if (HMK_MOTORNORM_G220 == "00002") {
            // IEC, MLFB passt
            ECL_ActivateValue("HMK_MS_IEC_MLFB_TYPE_1011270", HMK_MS_IEC_MLFB_TYPE_1011270);
            ECL_SelectValue("HMK_MS_IEC_MLFB_TYPE_1011270", HMK_MS_IEC_MLFB_TYPE_1011270);
            ECL_ActivateValue("HMK_MS_IEC_FS_1011270", HMK_MS_IEC_FS_1011270);
            ECL_SelectValue("HMK_MS_IEC_FS_1011270", HMK_MS_IEC_FS_1011270);
            ECL_ActivateValue("HMK_MS_IEC_RATED_ICU_1011270_X", HMK_MS_IEC_RATED_ICU_1011270_X);
            ECL_SelectValue("HMK_MS_IEC_RATED_ICU_1011270_X", HMK_MS_IEC_RATED_ICU_1011270_X);
            ECL_ActivateValue("HMK_MS_IEC_RC_1011270", HMK_MS_IEC_RC_1011270);
            ECL_SelectValue("HMK_MS_IEC_RC_1011270", HMK_MS_IEC_RC_1011270);
            ECL_ActivateValue("HMK_MS_IEC_ICC_1011270_X", HMK_MS_IEC_ICC_1011270_X);
            ECL_SelectValue("HMK_MS_IEC_ICC_1011270_X", HMK_MS_IEC_ICC_1011270_X);
          } else {
            //UL, MLFB uebersetzen (für KeepConfig) ==> Default durch PL
          }
          break;
        }
      }
      if (!bMS) {
        for (var j = 0; j < aResult_UL.length; j++) {
          if (secondaryMlfbArray[i] === aResult_UL[j].VALUE) {
            if (HMK_MOTORNORM_G220 == "00002") {
              ECL_SelectValue("CB_MS_G220", "T");
            } else {
              ECL_SelectValue("CB_MS_UL_G220", "T");
            }
            bMS = true;

            var sMLFB_MS = secondaryMlfbArray[i];

            if (bStraight) {
              var HMK_MS_UL_VOLTAGE_R_1011270 = "00002";
            } else if (bSlash) {
              var HMK_MS_UL_VOLTAGE_R_1011270 = "00003";
            } else {
              //error
            }
            var sTableA = "VT_G220_M00602" + sDB_Suffix;
            var sTableB = "VT_G220_M00646" + sDB_Suffix;
            var sSQL_MS_JOIN_BASIC_UL =
              "SELECT * " + "FROM " + sTableA + " As VT_TABLE_A " +
              "INNER JOIN " + sTableB + " As VT_TABLE_B " +
              "ON VT_TABLE_A.HMK_MS_UL_MLFB_1011410 = VT_TABLE_B.HMK_MS_UL_MLFB_1011410 " +
              "WHERE " +
              "VT_TABLE_B.HMK_MOTORNORM_G220 = '" + HMK_MOTORNORM_G220 + "' AND " +
              "VT_TABLE_B.PMD_ABJ176_001_000_G220 = '" + PMD_ABJ176_001_000_G220 + "' AND " +
              "VT_TABLE_B.HMK_VOLTAGE_PW_KEY_1011270 = '" + HMK_VOLTAGE_PW_KEY_1011270 + "' AND " +
              "VT_TABLE_B.HMK_TOPOLOGY_G220 = '" + HMK_TOPOLOGY_G220 + "' AND " +
              "VT_TABLE_B.HMK_REP_SWITCH__G220 = '" + HMK_REP_SWITCH__G220 + "' AND " +
              "VT_TABLE_B.HMK_MS_UL_VOLTAGE_R_1011270 = '" + HMK_MS_UL_VOLTAGE_R_1011270 + "' AND " +
              "VT_TABLE_B.HMK_MS_UL_G_CAPTION_1011270 = 'T' AND " +
              "VT_TABLE_B.HMK_VALUE_VALID_G220 = 'T' AND " +
              "HMK_MS_UL_MLFB_CPL_1011270 = '" + sMLFB_MS + "' ";


            if (HMK_MS_UL_VOLTAGE_R_1011270 == "00002") { // Geradspannung
              sSQL_MS_JOIN_BASIC_UL += " AND VT_TABLE_B.HMK_MS_UL_SCCR_1011410_X <> '.' ";
            } else if (HMK_MS_UL_VOLTAGE_R_1011270 == "00003") { // Schrägspannung
              sSQL_MS_JOIN_BASIC_UL += " AND VT_TABLE_B.HMK_MS_UL_SCCR_SL_1011270_X <> '.' ";
            }

            var aResult = GetDBDataSetEXT(sSQL_MS_JOIN_BASIC_UL + ";");

            if (aResult.length > 0) {
              var HMK_MS_UL_RC_1011270 = aResult[0].HMK_MS_UL_RC_1011270; // Bemessungsstrom
              var HMK_MS_UL_VOLTAGE_R_1011270 = aResult[0].HMK_MS_UL_VOLTAGE_R_1011270; // Betriebsspannung
              var HMK_MS_UL_RATED_ICU_1011270_X = aResult[0].HMK_MS_UL_RATED_ICU_1011270_X; // Ausschaltvermögen Grenzkurzschlussstrom (Icu) bei 400 V AC Bemessungswert
              var HMK_MS_UL_FS_1011270 = aResult[0].HMK_MS_UL_FS_1011270; // Baugröße des Schutzgerätes
              var HMK_MS_UL_MLFB_TYPE_1011270 = aResult[0].HMK_MS_UL_MLFB_TYPE_1011270; // Ausführung des elektrischen Anschlusses
              var HMK_MS_UL_SCCR_1011410_X = aResult[0].HMK_MS_UL_SCCR_1011410_X; // Kurzsschlussfestigkeit (SCCR)
              var HMK_MS_UL_SCCR_SL_1011270_X = aResult[0].HMK_MS_UL_SCCR_SL_1011270_X; // Kurzsschlussfestigkeit (SCCR) Schrägspannung

            } else {
              oData.strError = "DICT1_ERR_G220___PARSER_MS";
              return;
            }
            // UL-MLFB für UL-Norm, kann direkt gesetzt werden
            if (HMK_MOTORNORM_G220 == "00001") {
              // IEC, MLFB passt
              ECL_ActivateValue("HMK_MS_UL_RC_1011270", HMK_MS_UL_RC_1011270);
              ECL_SelectValue("HMK_MS_UL_RC_1011270", HMK_MS_UL_RC_1011270);
              ECL_ActivateValue("HMK_MS_UL_RC_1011270", HMK_MS_UL_VOLTAGE_R_1011270);
              ECL_SelectValue("HMK_MS_UL_RC_1011270", HMK_MS_UL_VOLTAGE_R_1011270);
              ECL_ActivateValue("HMK_MS_UL_RATED_ICU_1011270_X", HMK_MS_UL_RATED_ICU_1011270_X);
              ECL_SelectValue("HMK_MS_UL_RATED_ICU_1011270_X", HMK_MS_UL_RATED_ICU_1011270_X);
              ECL_ActivateValue("HMK_MS_UL_SCCR_1011410_X", HMK_MS_UL_SCCR_1011410_X);
              ECL_SelectValue("HMK_MS_UL_SCCR_1011410_X", HMK_MS_UL_SCCR_1011410_X);
              ECL_ActivateValue("HMK_MS_UL_SCCR_SL_1011270_X", HMK_MS_UL_SCCR_SL_1011270_X);
              ECL_SelectValue("HMK_MS_UL_SCCR_SL_1011270_X", HMK_MS_UL_SCCR_SL_1011270_X);
              ECL_ActivateValue("HMK_MS_UL_FS_1011270", HMK_MS_UL_FS_1011270);
              ECL_SelectValue("HMK_MS_UL_FS_1011270", HMK_MS_UL_FS_1011270);
              ECL_ActivateValue("HMK_MS_UL_MLFB_TYPE_1011270", HMK_MS_UL_MLFB_TYPE_1011270);
              ECL_SelectValue("HMK_MS_UL_MLFB_TYPE_1011270", HMK_MS_UL_MLFB_TYPE_1011270);

            } else {
              //IEC, MLFB uebersetzen (für KeepConfig)  ==> Default durch PL
            }
            break;
          }
        }
      }
      if (bMS) {
        break;
      }
    }
  }
}

// #########################################################################################################################
/**
Halbleitersicherung				CB_SC_FUSE_G220
// #############################################################################################################
 
IEC:
HMK_SCFUSE_IEC_RC_1011270_X	Bemessungsstrom
HMK_SCFUSE_IEC_MLFB_1011270	HMK_SCFUSE_IEC_MLFB_1011270
 
HMK_SCFUSE_IEC_RC_1011270_X
  VT_G220_M00618	IEC_SEMICONDUCTOR_FUSES
      HMK_SCFUSE_G_CAPTION_1011270	Halbleitersicherung
      HMK_MOTORNORM_G220	Motornorm
      HMK_SFUSE_IEC_ICPMR_1011270	HMK_SFUSE_IEC_ICPMR_REF_G220
      HMK_SCFUSE_IEC_ICC_1011270	ICC Bemessungskurzschlussstrom
      HMK_SCFUSE_IEC_MEV_1011410	HMK_SCFUSE_IEC_MEV_G220
      HMK_SCFUSE_IEC_MEVFT_1011270	HMK_SCFUSE_IEC_MEV_FT_G220
      HMK_VALUE_VALID_G220	Flag: Eintrag ist gültig
      PMD_ABJ176_001_000_G220	Schutzart IP
      HMK_VOLTAGE_PW_KEY_1011270	Voltage_Power Key
      HMK_TOPOLOGY_G220	HMK_TOPOLOGY_G220
      HMK_REP_SWITCH__G220	Wartungsschalter
      HMK_SCFUSE_IEC_ICC_V_1011270	HMK_SCFUSE_IEC_ICC_V_G220
      HMK_SCFUSE_IEC_MLFB_1011270	HMK_SCFUSE_IEC_MLFB_G220
      HMK_SCFUSE_IEC_RC_1011270_X	Bemessungsstrom
 
  VT_G220_M00502	ONE_LINE_SIDE_PW_COMPONENT
 
UL/NEMA:
HMK_SCFUSE_UL_RC_1011270_X	Bemessungsstrom
HMK_SCFUSE_UL_MLFB_1011270	HMK_SCFUSE_UL_MLFB_G220
 
HMK_SCFUSE_UL_RC_1011270_X
  VT_G220_M00619	UL_CSA_SEMICONDUCTOR_FUSES
          HMK_SCF_UL_G_CAPTION_1011270	Halbleitersicherung
          HMK_MOTORNORM_G220	Motornorm
          PMD_ABJ176_001_000_G220	Schutzart IP
          HMK_SCFUSE_UL_MLFB_1011270	HMK_SCFUSE_UL_MLFB_G220
          HMK_SCFUSE_UL_MEV_FT_1011410	HMK_SCFUSE_UL_MEV_FT_G220
          HMK_SCFUSE_UL_MEV_1011410	HMK_SCFUSE_UL_MEV_G220
          HMK_SCFUSE_UL_SCCR_1011410	CMC /.../controller
          HMK_VOLTAGE_PW_KEY_1011270	Voltage_Power Key
          HMK_TOPOLOGY_G220	HMK_TOPOLOGY_G220
          HMK_REP_SWITCH__G220	Wartungsschalter
          HMK_SCFUSE_UL_SCCR_V_1011270	HMK_SCFUSE_UL_SCCR_V_G220
          HMK_SCFUSE_UL_RC_1011270_X	Bemessungsstrom
          HMK_VALUE_VALID_G220	Flag: Eintrag ist gültig
 
VT_G220_M00502	ONE_LINE_SIDE_PW_COMPONENT
	
*/
// #########################################################################################################################
function SetSCFUSE(oData) {
  // only one line side power component
  if (ECL_ValueSelected("CB_MS_G220", "T") || ECL_ValueSelected("CB_STD_FUSE_G220", "T")) {
    return;
  }

  // IEC:
  var aResult_IEC = Object.fromDatabase(
    "G220_ADD_DATA",
    "SELECT DISTINCT Wert_ID FROM DATA WHERE IsMLFB = 'x' AND Attribute = 'HMK_SCFUSE_IEC_MLFB_1011270';"
  );
  if (!aResult_IEC || aResult_IEC.length < 1) {
    oData.strError = "DICT1_ERR_G220___PARSER_SCFUSE";
    return;
  }
  // UL:
  var aResult_UL = Object.fromDatabase(
    "G220_ADD_DATA",
    "SELECT DISTINCT Wert_ID FROM DATA WHERE IsMLFB = 'x' AND Attribute = 'HMK_SCFUSE_UL_MLFB_1011270';"
  );
  if (!aResult_UL || aResult_UL.length < 1) {
    oData.strError = "DICT1_ERR_G220___PARSER_SCFUSE";
    return;
  }
  var HMK_MOTORNORM_G220 = ECL_GetValue("HMK_MOTORNORM_G220");
  var HMK_VOLTAGE_G220 = ECL_GetValue("HMK_VOLTAGE_G220");
  var HMK_VOLTAGE_PW_KEY_1011270 = ECL_GetValue("HMK_VOLTAGE_PW_KEY_1011270");
  var HMK_SCFUSE_IEC_ICC_V_1011270 = ECL_GetValue("HMK_SCFUSE_IEC_ICC_V_1011270");
  var HMK_RATED_POWER_G220 = ECL_GetValue("HMK_RATED_POWER_G220");
  var HMK_TOPOLOGY_G220 = ECL_GetValue("HMK_TOPOLOGY_G220");
  var PMD_ABJ176_001_000_G220 = ECL_GetValue("PMD_ABJ176_001_000_G220");

  var bSC_FUSE = false;

  var sECSI_MLFB_SEC = GetMlfbSec() || "";
  if (sECSI_MLFB_SEC !== "") {
    var secondaryMlfbArray = sECSI_MLFB_SEC.split(";");

    for (var i = 0; i < secondaryMlfbArray.length; i++) {
      for (var j = 0; j < aResult_IEC.length; j++) {
        if (secondaryMlfbArray[i] === aResult_IEC[j].WERT_ID) {
          ECL_SelectValue("CB_SC_FUSE_G220", "T");
          bSC_FUSE = true;

          var sMLFB_SC_FUSE = secondaryMlfbArray[i];

          /* HMK_SCFUSE_IEC_RC_1011270_X	Bemessungsstrom
            VT_G220_M00618	IEC_SEMICONDUCTOR_FUSES
              HMK_SCFUSE_G_CAPTION_1011270	Halbleitersicherung
              HMK_MOTORNORM_G220	Motornorm
              HMK_SFUSE_IEC_ICPMR_1011270	HMK_SFUSE_IEC_ICPMR_REF_G220
              HMK_SCFUSE_IEC_ICC_1011270	ICC Bemessungskurzschlussstrom
              HMK_SCFUSE_IEC_MEV_1011410	HMK_SCFUSE_IEC_MEV_G220
              HMK_SCFUSE_IEC_MEVFT_1011270	HMK_SCFUSE_IEC_MEV_FT_G220
              HMK_VALUE_VALID_G220	Flag: Eintrag ist gültig
              PMD_ABJ176_001_000_G220	Schutzart IP
              HMK_VOLTAGE_PW_KEY_1011270	Voltage_Power Key
              HMK_TOPOLOGY_G220	HMK_TOPOLOGY_G220
              HMK_REP_SWITCH__G220	Wartungsschalter
              HMK_SCFUSE_IEC_ICC_V_1011270	HMK_SCFUSE_IEC_ICC_V_G220
              HMK_SCFUSE_IEC_MLFB_1011270	HMK_SCFUSE_IEC_MLFB_G220
              HMK_SCFUSE_IEC_RC_1011270_X	Bemessungsstrom
          */
          var sTable = "VT_G220_M00618" + sDB_Suffix;
          var sSQL =
            "SELECT * FROM " + sTable + " WHERE " +
            "HMK_MOTORNORM_G220 = '" + HMK_MOTORNORM_G220 + "' AND " +
            "HMK_VOLTAGE_PW_KEY_1011270 = '" + HMK_VOLTAGE_PW_KEY_1011270 + "' AND " +
            HMK_SCFUSE_IEC_ICC_V_1011270 + " AND " +
            "HMK_TOPOLOGY_G220 = '" + HMK_TOPOLOGY_G220 + "' AND " +
            "PMD_ABJ176_001_000_G220 = '" + PMD_ABJ176_001_000_G220 + "' AND " +
            "HMK_SCFUSE_IEC_MLFB_1011270 = '" + sMLFB_SC_FUSE + "' AND " +
            // todo HMK_SCFUSE_G_CAPTION_1011270
            "HMK_VALUE_VALID_G220 = 'T';";

          var aResult = GetDBDataSetEXT(sSQL);
          if (aResult.length > 0) {
            var HMK_SCFUSE_IEC_RC_1011270_X = aResult[0].HMK_SCFUSE_IEC_RC_1011270_X; // Bemessungsstrom
          } else {
            return;
          }
          // IEC-MLFB für IEC-Norm, kann direkt gesetzt werden
          if (HMK_MOTORNORM_G220 == "00002") {
            // IEC, MLFB passt
            ECL_ActivateValue("HMK_SCFUSE_IEC_RC_1011270_X", HMK_SCFUSE_IEC_RC_1011270_X);
            ECL_SelectValue("HMK_SCFUSE_IEC_RC_1011270_X", HMK_SCFUSE_IEC_RC_1011270_X);
          } else {
            //UL, MLFB uebersetzen (für KeepConfig)
            // Werte von IEC-MLFB abfragen und als UL setzen
            /*
            HMK_SCFUSE_UL_RC_1011270_X	Bemessungsstrom
            HMK_SCFUSE_UL_MLFB_1011270	HMK_SCFUSE_UL_MLFB_G220
 
            HMK_SCFUSE_UL_RC_1011270_X
              VT_G220_M00619	UL_CSA_SEMICONDUCTOR_FUSES
                HMK_SCF_UL_G_CAPTION_1011270	Halbleitersicherung
                HMK_MOTORNORM_G220	Motornorm
                PMD_ABJ176_001_000_G220	Schutzart IP
                HMK_SCFUSE_UL_MLFB_1011270	HMK_SCFUSE_UL_MLFB_G220
                HMK_SCFUSE_UL_MEV_FT_1011410	HMK_SCFUSE_UL_MEV_FT_G220
                HMK_SCFUSE_UL_MEV_1011410	HMK_SCFUSE_UL_MEV_G220
                HMK_SCFUSE_UL_SCCR_1011410	CMC /.../controller
                HMK_VOLTAGE_PW_KEY_1011270	Voltage_Power Key
                HMK_TOPOLOGY_G220	HMK_TOPOLOGY_G220
                HMK_REP_SWITCH__G220	Wartungsschalter
                HMK_SCFUSE_UL_SCCR_V_1011270	HMK_SCFUSE_UL_SCCR_V_G220
                HMK_SCFUSE_UL_RC_1011270_X	Bemessungsstrom
                HMK_VALUE_VALID_G220	Flag: Eintrag ist gültig
            */
            var sTable = "VT_G220_M00619" + sDB_Suffix;
            var sSQL =
              "SELECT * FROM " +
              sTable +
              " WHERE " +
              "HMK_MOTORNORM_G220 = '" +
              HMK_MOTORNORM_G220 +
              "' AND " +
              "HMK_VOLTAGE_PW_KEY_1011270 = '" +
              HMK_VOLTAGE_PW_KEY_1011270 +
              "' AND " +
              "HMK_TOPOLOGY_G220 = '" +
              HMK_TOPOLOGY_G220 +
              "' AND " +
              "PMD_ABJ176_001_000_G220 = '" +
              PMD_ABJ176_001_000_G220 +
              "' AND " +
              //"HMK_SCFUSE_IEC_MLFB_1011270 = '" + sMLFB_SC_FUSE + "' AND " +
              "HMK_SCFUSE_UL_RC_1011270_X = '" +
              HMK_SCFUSE_IEC_RC_1011270_X +
              "' AND " +
              // todo "HMK_SCF_UL_G_CAPTION_1011270 = 'T' AND " +
              "HMK_VALUE_VALID_G220 = 'T';";

            var aResult = GetDBDataSetEXT(sSQL);
            if (aResult.length > 0) {
              var HMK_SCFUSE_UL_RC_1011270_X = aResult[0].HMK_SCFUSE_UL_RC_1011270_X; // Bemessungsstrom
              var HMK_SCFUSE_UL_MLFB_1011270 = aResult[0].HMK_SCFUSE_UL_MLFB_1011270; // MLFB
            } else {
              oData.strError = "DICT1_ERR_G220___PARSER_SCFUSE";
              return;
            }
            ECL_ActivateValue("HMK_SCFUSE_UL_RC_1011270_X", HMK_SCFUSE_UL_RC_1011270_X);
            ECL_SelectValue("HMK_SCFUSE_UL_RC_1011270_X", HMK_SCFUSE_UL_RC_1011270_X);
          }
          break;
        }
      }
      if (!bSC_FUSE) {
        for (var j = 0; j < aResult_UL.length; j++) {
          if (secondaryMlfbArray[i] === aResult_UL[j].WERT_ID) {
            ECL_SelectValue("CB_SC_FUSE_G220", "T");
            bSC_FUSE = true;

            var sMLFB_SC_FUSE = secondaryMlfbArray[i];
            /*
            HMK_SCFUSE_UL_RC_1011270_X	Bemessungsstrom
            HMK_SCFUSE_UL_MLFB_1011270	HMK_SCFUSE_UL_MLFB_G220
 
            HMK_SCFUSE_UL_RC_1011270_X
              VT_G220_M00619	UL_CSA_SEMICONDUCTOR_FUSES
                HMK_SCF_UL_G_CAPTION_1011270	Halbleitersicherung
                HMK_MOTORNORM_G220	Motornorm
                PMD_ABJ176_001_000_G220	Schutzart IP
                HMK_SCFUSE_UL_MLFB_1011270	HMK_SCFUSE_UL_MLFB_G220
                HMK_SCFUSE_UL_MEV_FT_1011410	HMK_SCFUSE_UL_MEV_FT_G220
                HMK_SCFUSE_UL_MEV_1011410	HMK_SCFUSE_UL_MEV_G220
                HMK_SCFUSE_UL_SCCR_1011410	CMC /.../controller
                HMK_VOLTAGE_PW_KEY_1011270	Voltage_Power Key
                HMK_TOPOLOGY_G220	HMK_TOPOLOGY_G220
                HMK_REP_SWITCH__G220	Wartungsschalter
                HMK_SCFUSE_UL_SCCR_V_1011270	HMK_SCFUSE_UL_SCCR_V_G220
                HMK_SCFUSE_UL_RC_1011270_X	Bemessungsstrom
                HMK_VALUE_VALID_G220	Flag: Eintrag ist gültig
            */
            var sTable = "VT_G220_M00619" + sDB_Suffix;
            var sSQL =
              "SELECT * FROM " + sTable + " WHERE " +
              "HMK_MOTORNORM_G220 = '" + HMK_MOTORNORM_G220 + "' AND " +
              "HMK_VOLTAGE_PW_KEY_1011270 = '" + HMK_VOLTAGE_PW_KEY_1011270 + "' AND " +
              "HMK_TOPOLOGY_G220 = '" + HMK_TOPOLOGY_G220 + "' AND " +
              "PMD_ABJ176_001_000_G220 = '" + PMD_ABJ176_001_000_G220 + "' AND " +
              "HMK_SCFUSE_UL_MLFB_1011270 = '" + sMLFB_SC_FUSE + "' AND " +
              "HMK_SCF_UL_G_CAPTION_1011270 = 'T' AND " +
              "HMK_VALUE_VALID_G220 = 'T';";

            var aResult = GetDBDataSetEXT(sSQL);
            if (aResult.length > 0) {
              var HMK_SCFUSE_UL_RC_1011270_X = aResult[0].HMK_SCFUSE_UL_RC_1011270_X; // Bemessungsstrom
            } else {
              //oData.strError = "DICT1_ERR_G220___PARSER_SCFUSE";
              return;
            }
            // UL-MLFB für UL-Norm, kann direkt gesetzt werden
            if (HMK_MOTORNORM_G220 == "00001") {
              // UL, MLFB passt
              ECL_ActivateValue("HMK_SCFUSE_IEC_RC_1011270_X", HMK_SCFUSE_IEC_RC_1011270_X);
              ECL_SelectValue("HMK_SCFUSE_IEC_RC_1011270_X", HMK_SCFUSE_IEC_RC_1011270_X);
            } else {
              //IEC, MLFB uebersetzen (für KeepConfig)
              // Werte von UL-MLFB abfragen und als IEC setzen
              /* HMK_SCFUSE_IEC_RC_1011270_X	Bemessungsstrom
          VT_G220_M00618	IEC_SEMICONDUCTOR_FUSES
            HMK_SCFUSE_G_CAPTION_1011270	Halbleitersicherung
            HMK_MOTORNORM_G220	Motornorm
            HMK_SFUSE_IEC_ICPMR_1011270	HMK_SFUSE_IEC_ICPMR_REF_G220
            HMK_SCFUSE_IEC_ICC_1011270	ICC Bemessungskurzschlussstrom
            HMK_SCFUSE_IEC_MEV_1011410	HMK_SCFUSE_IEC_MEV_G220
            HMK_SCFUSE_IEC_MEVFT_1011270	HMK_SCFUSE_IEC_MEV_FT_G220
            HMK_VALUE_VALID_G220	Flag: Eintrag ist gültig
            PMD_ABJ176_001_000_G220	Schutzart IP
            HMK_VOLTAGE_PW_KEY_1011270	Voltage_Power Key
            HMK_TOPOLOGY_G220	HMK_TOPOLOGY_G220
            HMK_REP_SWITCH__G220	Wartungsschalter
            HMK_SCFUSE_IEC_ICC_V_1011270	HMK_SCFUSE_IEC_ICC_V_G220
            HMK_SCFUSE_IEC_MLFB_1011270	HMK_SCFUSE_IEC_MLFB_G220
            HMK_SCFUSE_IEC_RC_1011270_X	Bemessungsstrom
              */
              var sTable = "VT_G220_M00618" + sDB_Suffix;
              var sSQL =
                "SELECT * FROM " +
                sTable +
                " WHERE " +
                "HMK_MOTORNORM_G220 = '" +
                HMK_MOTORNORM_G220 +
                "' AND " +
                "HMK_VOLTAGE_PW_KEY_1011270 = '" +
                HMK_VOLTAGE_PW_KEY_1011270 +
                "' AND " +
                //"HMK_SCFUSE_IEC_ICC_V_1011270 = '" +
                HMK_SCFUSE_IEC_ICC_V_1011270 +
                " AND " +
                "HMK_TOPOLOGY_G220 = '" +
                HMK_TOPOLOGY_G220 +
                "' AND " +
                "PMD_ABJ176_001_000_G220 = '" +
                PMD_ABJ176_001_000_G220 +
                "' AND " +
                //"HMK_SCFUSE_IEC_MLFB_1011270 = '" + sMLFB_SC_FUSE + "' AND " +
                "HMK_SCFUSE_IEC_RC_1011270_X = '" +
                HMK_SCFUSE_UL_RC_1011270_X +
                "' AND " +
                // todo HMK_SCFUSE_G_CAPTION_1011270
                "HMK_VALUE_VALID_G220 = 'T';";

              var aResult = GetDBDataSetEXT(sSQL);
              if (aResult.length > 0) {
                var HMK_SCFUSE_IEC_RC_1011270_X = aResult[0].HMK_SCFUSE_IEC_RC_1011270_X; // Bemessungsstrom
                var HMK_SCFUSE_IEC_MLFB_1011270 = aResult[0].HMK_SCFUSE_IEC_MLFB_1011270; // MLFB
              } else {
                oData.strError = "DICT1_ERR_G220___PARSER_SCFUSE";
                return;
              }
              ECL_ActivateValue("HMK_SCFUSE_IEC_RC_1011270_X", HMK_SCFUSE_IEC_RC_1011270_X);
              ECL_SelectValue("HMK_SCFUSE_IEC_RC_1011270_X", HMK_SCFUSE_IEC_RC_1011270_X);
            }
            break;
          }
        }
      }
      if (bSC_FUSE) {
        break;
      }
    }
  }
}

// #########################################################################################################################
/**
Standardsicherung			CB_STD_FUSE_G220
// ################################################################################################################
/*
HMK_FUSE_IEC_RC_1011270_X	Bemessungsstrom
HMK_FUSE_IEC_MLFB_1011270	HMK_FUSE_IEC_MLFB_G220
 
HMK_FUSE_IEC_RC_1011270_X
  VT_G220_M00613	IEC_STANDARD_FUSES
    HMK_FUSE_G_CAPTION_1011270	Standardsicherung
    HMK_MOTORNORM_G220	Motornorm
    HMK_FUSE_IEC_ICPMR_1011270	HMK_FUSE_IEC_ICPMR_REF_G220
    HMK_FUSE_IEC_ICC_1011270	HMK_FUSE_IEC_ICC_G220
    HMK_FUSE_IEC_MEV_1011410_X	HMK_FUSE_IEC_MEV_G220
    HMK_FUSE_IEC_MEV_FT_1011410_X	HMK_FUSE_IEC_MEV_FT_G220
    HMK_VALUE_VALID_G220	Flag: Eintrag ist gültig
    PMD_ABJ176_001_000_G220	Schutzart IP
    HMK_VOLTAGE_PW_KEY_1011270	Voltage_Power Key
    HMK_TOPOLOGY_G220	HMK_TOPOLOGY_G220
    HMK_REP_SWITCH__G220	Wartungsschalter
    HMK_FUSE_IEC_ICC_V_1011270	HMK_FUSE_IEC_ICC_V_G220
    HMK_FUSE_IEC_RC_1011270_X	Bemessungsstrom
    HMK_FUSE_IEC_MLFB_1011270	HMK_FUSE_IEC_MLFB_G220
 
	
  VT_G220_M00502	ONE_LINE_SIDE_PW_COMPONENT
*/
// #########################################################################################################################
function SetFUSE(oData) {
  // only one line side power component
  if (ECL_ValueSelected("CB_MS_G220", "T") || ECL_ValueSelected("CB_SC_FUSE_G220", "T")) {
    return;
  }
  // IEC/UL gemeinsam:
  var aResult_IEC_UL = Object.fromDatabase(
    "G220_ADD_DATA",
    "SELECT DISTINCT Wert_ID FROM DATA WHERE IsMLFB = 'x' AND Attribute = 'HMK_FUSE_IEC_MLFB_1011270';"
  );
  if (!aResult_IEC_UL || aResult_IEC_UL.length < 1) {
    oData.strError = "DICT1_ERR_G220___PARSER_FUSE";
    return;
  }

  var HMK_MOTORNORM_G220 = ECL_GetValue("HMK_MOTORNORM_G220");
  var HMK_VOLTAGE_G220 = ECL_GetValue("HMK_VOLTAGE_G220");
  var HMK_VOLTAGE_PW_KEY_1011270 = ECL_GetValue("HMK_VOLTAGE_PW_KEY_1011270");
  var HMK_FUSE_IEC_ICC_V_1011270 = ECL_GetValue("HMK_FUSE_IEC_ICC_V_1011270");
  var HMK_RATED_POWER_G220 = ECL_GetValue("HMK_RATED_POWER_G220");
  var HMK_TOPOLOGY_G220 = ECL_GetValue("HMK_TOPOLOGY_G220");
  var PMD_ABJ176_001_000_G220 = ECL_GetValue("PMD_ABJ176_001_000_G220");

  var bFUSE = false;

  var sECSI_MLFB_SEC = GetMlfbSec() || "";
  if (sECSI_MLFB_SEC !== "") {
    var secondaryMlfbArray = sECSI_MLFB_SEC.split(";");

    for (var i = 0; i < secondaryMlfbArray.length; i++) {
      for (var j = 0; j < aResult_IEC_UL.length; j++) {
        if (secondaryMlfbArray[i] === aResult_IEC_UL[j].WERT_ID) {
          ECL_SelectValue("CB_STD_FUSE_G220", "T");
          bFUSE = true;

          var sMLFB_FUSE = secondaryMlfbArray[i];

          /* VT_G220_M00613	IEC_STANDARD_FUSES
    	
      */
          var sTable = "VT_G220_M00613" + sDB_Suffix;
          var sSQL =
            "SELECT * FROM " +
            sTable +
            " WHERE " +
            "HMK_MOTORNORM_G220 = '" +
            HMK_MOTORNORM_G220 +
            "' AND " +
            "HMK_VOLTAGE_PW_KEY_1011270 = '" +
            HMK_VOLTAGE_PW_KEY_1011270 +
            "' AND " +
            //"HMK_FUSE_IEC_ICC_V_1011270 = '" +
            HMK_FUSE_IEC_ICC_V_1011270 +
            " AND " +
            "HMK_TOPOLOGY_G220 = '" +
            HMK_TOPOLOGY_G220 +
            "' AND " +
            "PMD_ABJ176_001_000_G220 = '" +
            PMD_ABJ176_001_000_G220 +
            "' AND " +
            "HMK_FUSE_IEC_MLFB_1011270 = '" +
            sMLFB_FUSE +
            "' AND " +
            "HMK_VALUE_VALID_G220 = 'T';";

          var aResult = GetDBDataSetEXT(sSQL);
          if (aResult.length > 0) {
            var HMK_FUSE_IEC_RC_1011270_X = aResult[0].HMK_FUSE_IEC_RC_1011270_X; // Bemessungsstrom
          } else {
            var sTable = "VT_G220_M00613" + sDB_Suffix;
            var sSQL =
              "SELECT * FROM " +
              sTable +
              " WHERE " +
              "HMK_MOTORNORM_G220 = '" +
              HMK_MOTORNORM_G220 +
              "' AND " +
              "HMK_VOLTAGE_PW_KEY_1011270 = '" +
              HMK_VOLTAGE_PW_KEY_1011270 +
              "' AND " +
              //"HMK_FUSE_IEC_ICC_V_1011270 = '" +
              HMK_FUSE_IEC_ICC_V_1011270 +
              " AND " +
              "HMK_TOPOLOGY_G220 = '" +
              HMK_TOPOLOGY_G220 +
              "' AND " +
              "PMD_ABJ176_001_000_G220 = '" +
              PMD_ABJ176_001_000_G220 +
              "' AND " +
              "HMK_FUSE_IEC_RC_1011270_X <> '.' AND " +
              "HMK_VALUE_VALID_G220 = 'T';";

            var aResult = GetDBDataSetEXT(sSQL);
            if (aResult.length < 1) {
              ECL_DeselectAttribute("CB_STD_FUSE_G220");
              //oData.strError = "DICT1_ERR_G220___PARSER_FUSE";
              return;
            }
          }

          // IEC/UL gemeinsam, MLFB passt
          ECL_ActivateValue("HMK_FUSE_IEC_RC_1011270_X", HMK_FUSE_IEC_RC_1011270_X);
          ECL_SelectValue("HMK_FUSE_IEC_RC_1011270_X", HMK_FUSE_IEC_RC_1011270_X);

          break;
        }
      }
      if (bFUSE) {
        break;
      }
    }
  }
}

// #########################################################################################################################
/**
Bremswiderstand			HMK_BRAKERESISTOR_G220
// ################################################################################################################
/*
Kein Bremswiderstand bei IP55
  BZ_G220_00624	VT_628 BRK_RES nicht bei IP55
    RESTRICTIONS: TABLE VT_G220_M00628 (
      HMK_CAN_CONCT_BR_G220 =c.HMK_CAN_CONCT_BR_G220 ,
      HMK_SCHUTZART_1011410 =d.HMK_SCHUTZART_1011410 )
    INFERENCES:
      c.HMK_CAN_CONCT_BR_G220,
      d.HMK_SCHUTZART_1011410
 
  HMK_CAN_CONCT_BR_G220	Bremswiderstand
      VT_G220_M00574	ACCESSORY_BRAKING_RESISTOR
      VT_G220_M00651	MLFB_8_DRIVE_TOPOLOGY
        HMK_V_OUT_W_FM_G220		HMK_V_OUT_W_FM_G220
        HMK_V_OUT_WO_FM_G220	HMK_V_OUT_WO_FM_G220
        PMD_ACU348_001_000_G220	Ausnahmegrund /...n-Richtlinie
        PMD_ACU798_001_000_G220	Produkteigensch...n-Richtlinie
        PMD_ABY282_001_000_1011270	prozentuale /.../maximal
        PMD_ABP325_001_000_G220	Produktbestandt...Bremschopper
        MLFB08_G220				Segment Merkmal MLFB08_G220
        HMK_CAN_CONCT_BR_G220	Bremswiderstand
        HMK_TOPOLOGY_G220		HMK_TOPOLOGY_G220
 
 
    HMK_ACC_BRAKING_G220	HMK_ACC_BRAKING_G220
 
    VT_G220_M00574	ACCESSORY_BRAKING_RESISTOR
      HMK_ACC_BRAKING_G220	HMK_ACC_BRAKING_G220
      PMD_ABJ176_001_000_G220	Schutzart IP
      HMK_CAN_CONCT_BR_G220	Bremswiderstand
      HMK_VOLTAGE_G220		HMK_VOLTAGE_G220
      HMK_RATED_POWER_G220	HMK_RATED_POWER_G220
 
*/
// #########################################################################################################################
function SetBrakeResistor(oData) {
  // IEC/UL gemeinsam:
  var aResult = Object.fromDatabase("G220_ADD_DATA", "SELECT DISTINCT Wert_ID FROM DATA WHERE IsMLFB = 'x' AND Attribute = 'HMK_ACC_BRAKING_G220';");
  if (!aResult || aResult.length < 1) {
    oData.strError = "DICT1_ERR_G220___PARSER_BRAKERESISTOR";
    return;
  }

  //var HMK_VOLTAGE_G220 = ECL_GetValue("HMK_VOLTAGE_G220");
  //var HMK_RATED_POWER_G220 = ECL_GetValue("HMK_RATED_POWER_G220");
  var HMK_TOPOLOGY_G220 = ECL_GetValue("HMK_TOPOLOGY_G220");
  //var PMD_ABJ176_001_000_G220 = ECL_GetValue("PMD_ABJ176_001_000_G220");

  var bBR = false;

  var sECSI_MLFB_SEC = GetMlfbSec() || "";
  if (sECSI_MLFB_SEC !== "") {
    var secondaryMlfbArray = sECSI_MLFB_SEC.split(";");

    for (var i = 0; i < secondaryMlfbArray.length; i++) {
      for (var j = 0; j < aResult.length; j++) {
        if (secondaryMlfbArray[i] === aResult[j].WERT_ID) {
          // check BR
          var sTable = "VT_G220_M00651" + sDB_Suffix;
          var sSQL = "SELECT * FROM " + sTable + " WHERE " + "HMK_TOPOLOGY_G220 = '" + HMK_TOPOLOGY_G220 + "' AND " + "HMK_CAN_CONCT_BR_G220 = 'T';";

          var aResult = GetDBDataSetEXT(sSQL);
          if (aResult.length > 0) {
            ECL_SelectValue("HMK_BRAKERESISTOR_G220", "T");
            ECL_SelectValue("UI_HMK_BRAKERESISTOR_G220", "T");
            bBR = true;

            break;
          }
        }
      }
      if (bBR) {
        break;
      }
    }
  }

  if (bBR === false) {
    var ECSI_CX_CustomBrakingResistor = ECL_GetValue("ECSI_CX_CustomBrakingResistor");
    var ECSI_CX_RegenerativeMode = ECL_GetValue("ECSI_CX_RegenerativeMode");

    if (ECSI_CX_CustomBrakingResistor == "1" || ECSI_CX_CustomBrakingResistor == "True") {
      ECL_SelectValue("HMK_BRAKERESISTOR_G220","F");
      ECL_SelectValue("UI_HMK_BRAKERESISTOR_G220","CUSTOM");
    }
    else if (ECSI_CX_RegenerativeMode == 2) {
      ECL_SelectValue("HMK_BRAKERESISTOR_G220", "T");
      ECL_SelectValue("UI_HMK_BRAKERESISTOR_G220", "T");
    }
    else {
      ECL_SelectValue("HMK_BRAKERESISTOR_G220","F");
      ECL_SelectValue("UI_HMK_BRAKERESISTOR_G220","F");
    }
  }
}

// digitaler Zwilling
/**
 * HMK_DRV_SIM_DESIGNER_1011270	  DriveSim Designer
 * HMK_MLFB_DRV_SIM_DES_1011270   MLFB DriveSim Designer
 *
 * HMK_DRV_SIM_ENGINEER_1011410	DriveSim Engineer
 * HMK_MLFB_DRV_SIM_ENG_1011410	MLFB DriveSim Engineer
 *
 *
 * VT_G220_M00631	MLFB DriveSim Designer
 *    HMK_DRV_SIM_DESIGNER_1011270	DriveSim Designer
 *    HMK_MLFB_DRV_SIM_DES_1011270	MLFB DriveSim Designer
 *
 * VT_G220_M00632	MLFB DriveSim Engineer
 *    HMK_DRV_SIM_ENGINEER_1011410	DriveSim Engineer
 *    HMK_MLFB_DRV_SIM_ENG_1011410	MLFB DriveSim Engineer
 */
function SetDRV_SIM_DESIGNER(oData) {
  var sTable = "VT_G220_M00631" + sDB_Suffix;
  var sSQLDRV_SIM_DES = "SELECT * FROM " + sTable + " WHERE HMK_DRV_SIM_DESIGNER_1011270 <> '00001';";

  var aResultDRV_SIM_DES = GetDBDataSetEXT(sSQLDRV_SIM_DES);
  var bDRVSIM_DES = false;
  if (aResultDRV_SIM_DES.length > 0) {
    var sECSI_MLFB_SEC = GetMlfbSec() || "";
    if (sECSI_MLFB_SEC !== "") {
      var secondaryMlfbArray = sECSI_MLFB_SEC.split(";");

      for (var i = 0; i < secondaryMlfbArray.length; i++) {
        for (var j = 0; j < aResultDRV_SIM_DES.length; j++) {
          if (secondaryMlfbArray[i] === aResultDRV_SIM_DES[j].HMK_MLFB_DRV_SIM_DES_1011270) {
            var HMK_DRV_SIM_DESIGNER_1011270 = aResultDRV_SIM_DES[j].HMK_DRV_SIM_DESIGNER_1011270;
            ECL_ActivateValue("HMK_DRV_SIM_DESIGNER_1011270", HMK_DRV_SIM_DESIGNER_1011270);
            ECL_SelectValue("HMK_DRV_SIM_DESIGNER_1011270", HMK_DRV_SIM_DESIGNER_1011270);
            bDRVSIM_DES = true;
            break;
          }
        }
        if (bDRVSIM_DES) {
          break;
        }
      }
    }
  } else {
    // Error
  }
  if (!bDRVSIM_DES) {
    ECL_ActivateValue("HMK_DRV_SIM_DESIGNER_1011270", "00001");
    ECL_SelectValue("HMK_DRV_SIM_DESIGNER_1011270", "00001");
  }
}
/*
  VT_G220_M00632	MLFB DriveSim Engineer
  *    HMK_DRV_SIM_ENGINEER_1011410	DriveSim Engineer
  *    HMK_MLFB_DRV_SIM_ENG_1011410	MLFB DriveSim Engineer
*/
function SetDRV_SIM_ENGINEER(oData) {
  var sTable = "VT_G220_M00632" + sDB_Suffix;
  var sSQLDRV_SIM_ENG = "SELECT * FROM " + sTable + " WHERE HMK_DRV_SIM_ENGINEER_1011410 <> '00001';";

  var aResultDRV_SIM_ENG = GetDBDataSetEXT(sSQLDRV_SIM_ENG);
  var bDRVSIM_ENG = false;
  if (aResultDRV_SIM_ENG.length > 0) {
    var sECSI_MLFB_SEC = GetMlfbSec() || "";
    if (sECSI_MLFB_SEC !== "") {
      var secondaryMlfbArray = sECSI_MLFB_SEC.split(";");

      for (var i = 0; i < secondaryMlfbArray.length; i++) {
        for (var j = 0; j < aResultDRV_SIM_ENG.length; j++) {
          if (secondaryMlfbArray[i] === aResultDRV_SIM_ENG[j].HMK_MLFB_DRV_SIM_ENG_1011410) {
            var HMK_DRV_SIM_ENGINEER_1011410 = aResultDRV_SIM_ENG[j].HMK_DRV_SIM_ENGINEER_1011410;

            ECL_ActivateValue("HMK_DRV_SIM_ENGINEER_1011410", HMK_DRV_SIM_ENGINEER_1011410);
            ECL_SelectValue("HMK_DRV_SIM_ENGINEER_1011410", HMK_DRV_SIM_ENGINEER_1011410);

            bDRVSIM_ENG = true;
            break;
          }
        }
        if (bDRVSIM_ENG) {
          break;
        }
      }
    }
  } else {
    // Error
  }
}

/**
 * SetSDI_STD_IP55_PROT_DOOR(oData);
    SINAMICS SDI Standard Schutztür
  HMK_IP55_PROT_DOOR_1011410	  HMK_SDI_PRO_IP55_PROT_DOOR_G220
  HMK_IP55_PRDOOR_MLFB_1011410	HMK_SDI_PRO_IP55_PROT_DOOR_MLFB_G220    6SL49500AH710AA0 ==> HMK_IP55_PROT_DOOR_1011410 = 00001, ohne: 00002
 
  VT_G220_M00644	SDI_STANDARD_SCHUTZTUER
    HMK_IP55_PRDOOR_MLFB_1011410	HMK_SDI_PRO_IP5...OR_MLFB_G220
    HMK_IP55_PROT_DOOR_1011410	HMK_SDI_PRO_IP5...OT_DOOR_G220
    PMD_ABJ176_001_000_G220	Schutzart IP
 */
function SetSDI_STD_IP55_PROT_DOOR(oData) {
  var sTable = "VT_G220_M00644" + sDB_Suffix;
  var sSQL = "SELECT * FROM " + sTable + " WHERE HMK_IP55_PROT_DOOR_1011410 = '00001' AND PMD_ABJ176_001_000_G220 = 'Z0003';";

  var aResult = GetDBDataSetEXT(sSQL);
  var bInMlfb = false;
  if (aResult.length > 0) {
    var sECSI_MLFB_SEC = GetMlfbSec() || "";
    if (sECSI_MLFB_SEC !== "") {
      var secondaryMlfbArray = sECSI_MLFB_SEC.split(";");

      for (var i = 0; i < secondaryMlfbArray.length; i++) {
        for (var j = 0; j < aResult.length; j++) {
          if (secondaryMlfbArray[i] === aResult[j].HMK_IP55_PRDOOR_MLFB_1011410) {
            var HMK_IP55_PROT_DOOR_1011410 = aResult[j].HMK_IP55_PROT_DOOR_1011410;

            ECL_ActivateValue("HMK_IP55_PROT_DOOR_1011410", HMK_IP55_PROT_DOOR_1011410);
            ECL_SelectValue("HMK_IP55_PROT_DOOR_1011410", HMK_IP55_PROT_DOOR_1011410);

            bInMlfb = true;
            break;
          }
        }
        if (bInMlfb) {
          break;
        }
      }
    }
  } else {
    // Error
  }
}

// HMK_DUDT_FILTER_G220
function SetDuDtFilter(oData) {
  var sECSI_MLFB_SEC = GetMlfbSec() || "";
  if (sECSI_MLFB_SEC === "") {
    return; // no secondary MLFBs, nothing to do
  }

  var secondaryMlfbArray = sECSI_MLFB_SEC.split(";");
  var power = ECL_GetValue("HMK_RATED_POWER_G220");
  var valid = ECL_GetValue("HMK_VALUE_VALID_G220");
  var voltage = ECL_GetValue("HMK_VOLTAGE_G220");
  var sTable = "VT_G220_M00695" + sDB_Suffix;
  var sSQL = "SELECT HMK_DUDT_FILTER_MLFB_G220 FROM " + sTable + " WHERE HMK_VALUE_VALID_G220 = 'T' GROUP BY HMK_DUDT_FILTER_MLFB_G220;";
  var aResult = GetDBDataSetEXT(sSQL);

  var foundDuDt = secondaryMlfbArray.some(function(mlfb) {
    return aResult.some(function(result) {
      return mlfb === result.HMK_DUDT_FILTER_MLFB_G220;
    });
  });
  
  if (foundDuDt) {
    ECL_SetValue("HMK_DUDT_FILTER_G220", 'T');
  }
}

// Service Protect: HMK_DSEE_G220, HMK_DSEE_1011410
function SetServiceProtect(oData) {
  var sECSI_MLFB_SEC = GetMlfbSec() || "";
  if (sECSI_MLFB_SEC === "") {
    return; // no secondary MLFBs, nothing to do
  }
  
  var secondaryMlfbArray = sECSI_MLFB_SEC.split(";");
  var sECHI_MLFB = ECL_GetValue("ECSI_MLFB");
  var BaseMLFBForServiceProtection = sECHI_MLFB.substring(0, sECHI_MLFB.length - 2);


  var sTable = "VT_G220_M00633" + sDB_Suffix;
  var sSQL = "SELECT HMK_DSEE_1011410, HMK_MLFB_DSEE_1011410 FROM " + sTable + " GROUP BY HMK_MLFB_DSEE_1011410;";
  var aResult = GetDBDataSetEXT(sSQL);
  if (aResult.length <= 0) {
    return; // error
  }

  var foundDSEE = false;
  for (var i = 0; i < secondaryMlfbArray.length; i++) {
    for (var j = 0; j < aResult.length; j++) {
      if (secondaryMlfbArray[i] === aResult[j].HMK_MLFB_DSEE_1011410) {
        ECL_SelectValue("HMK_DSEE_G220", aResult[j].HMK_DSEE_1011410);
        foundDSEE = true;
        break;
      }
    }
    if (foundDSEE) break;
  }

}