//@legacy
//#mode(full-ecma)

// ---------------------------------------------------------
// Script for configuration object CFG_SIEMENS_G220
// 	Date: 2023-04-26
// 	User: Administrator
// ---------------------------------------------------------

//@import "CFG_G220_VT.js"

/**
  MLFB07: Spannung	 				HMK_VOLTAGE_G220
  MLFB08: Topologie					HMK_TOPOLOGY_G220	[GPD, RGD, LHD, CPD] Werte 00001...00004
  MLFB09: (.) Schutzart IP				PMD_ABJ176_001_000_G220	Schutzart IP
    PMD_ABY931_001_000_G220 (old: PMD_ABU539_001_000_G220)	Widerstandsfähigkeit gegen chemisch aktive Stoffe
  MLFB10: . Hardware Option				HMK_HW_OPTION_G220 (J: J=Braking chopper internal 50%Ed-100% Pnenn, A: A=No configuration / Not used, P: P=IEC-Type Gland plate by IP21/IP55, Q: Q=NEC-Type Gland plate by UL type 1/12)
  MLFB11: Leistung 1 (0-5: 0,55kW)	HMK_RATED_POWER_G220	Bemessungsleistung
  MLFB12: Leistung 2 (0-5: 0,55kW)	
  MLFB13: . EMC-Filterklassee			HMK_EMC_TYPE_G220
    PMD_ABY445_001_000_G220		Ausführung des Netzfilters
  MLFB14: . Hardware options (A=No additional HW-options, B=DQ-Module, E=IOT-Module, F=Atex-Module)
  MLFB15:	. Feldbus						HMK_FIELDB_TYPE_G220	PMD_ABY317_001_000_G220
  MLFB16:	1 Version / Production release
*/

function SetInverter_Init(oData) {
  if (oData && !isEmpty(oData)) {
    SetVoltage(oData); // + HMK_MOTORNORM_G220
    SetTopology(oData); //
    SetProtection(oData); //
    SetHardwareOption(oData); //
    SetRatedPower(oData); //
    SetEMC_Filter(oData); //
    SetFrameSize(oData); // Framesize, HMK_FRAMESIZE_G220, NEU: HMK_VOLTAGE_PW_KEY_1011270
    SetAddHardwareOption(oData); //
    SetCommunication(oData); //
    SetProductVersion(oData); //
    // SetVoltage_PW_Key(oData); // integrated in SetFrameSize()
    SetHMK_Voltages(oData); // set additional voltages for line side components
  } else {
    // FC-Data
    ExecSetStandardifValueEmpty("HMK_MOTORNORM_G220", "00002"); // IEC
    ExecSetStandardifValueEmpty("HMK_NETZFREQUENZ_1011270", "50"); // IEC
    ExecSetStandardifValueEmpty("HMK_ANZAHL_PHASEN_1011270", "00001"); // 3AC
    ExecSetStandardifValueEmpty("HMK_VOLTAGE_G220", "00008");
    ExecSetStandardifValueEmpty("HMK_RATED_POWER_G220", "00001");

    ExecSetStandardifValueEmpty("HMK_TOPOLOGY_G220", "00001");
    ExecSetStandardifValueEmpty("PMD_ABJ177_001_000_G220", "00001"); // Gerätetyp

    ExecSetStandardifValueEmpty("PMD_ABJ176_001_000_G220", "Z0012"); // Schutzart IP
    ExecSetStandardifValueEmpty("PMD_ABM455_001_000_G220", "00003"); // Schutzart NEMA
    ExecSetStandardifValueEmpty("HMK_SCHUTZART_1011410", "00016"); //
    ExecSetStandardifValueEmpty("HMK_PROTECTION_G220", "00003"); //
    ExecSetStandardifValueEmpty("PMD_ABY931_001_000_G220", "00001"); // Standard für Umweltbedingungen / Standard für Lackierung		00001	"Klasse 3C2, nach IEC 60721-3-3: 2002"

    ExecSetStandardifValueEmpty("HMK_HW_OPTION_G220", "00003"); // w/o

    ExecSetStandardifValueEmpty("HMK_EMC_TYPE_G220", "00004"); // EMV Kategorie				unfiltered
    ExecSetStandardifValueEmpty("PMD_ABY445_001_000_G220", "Z0001"); // Ausführung des Netzfilters 	unfiltered

    ExecSetStandardifValueEmpty("PMD_ABY317_001_000_G220", "00003"); // Kommunikation

    ExecSetStandardifValueEmpty("HMK_OM_SMT_1011270", "00002"); // Option Modul SMT
    ExecSetStandardifValueEmpty("HMK_OM_DQ_1011270", "00002"); // Option Modul DRIVE-CLiQ
    ExecSetStandardifValueEmpty("HMK_OM_IIOT_1011270", "00002"); // Option Modul IIoT

    ExecSetStandardifValueEmpty("HMK_CU_TYPE_G220", "00004"); // 00004	G220
    ExecSetStandardifValueEmpty("HMK_CU_ID_G220", "00004"); // 00004	CU 4
    ExecSetStandardifValueEmpty("HMK_FIELDB_TYPE_G220", "00002"); // Feldbus

    ExecSetStandardifValueEmpty("PMD_ABW171_001_000_G220", "Z0001"); // Bauform des Umrichters
    ExecSetStandardifValueEmpty("PMD_ACJ913_001_000_G220", "00008"); // Baugröße des Umrichters
    ExecSetStandardifValueEmpty("HMK_FRAMESIZE_G220", "00001"); // HMK_FRAMESIZE_G220
    ExecSetStandardifValueEmpty("HMK_FS_HELPER_G220", "00001"); // HMK_FS_HELPER_G220
    ExecSetStandardifValueEmpty("HMK_FS_GROUP_G220", "00001"); // HMK_FS_GROUP_G220
    ExecSetStandardifValueEmpty("HMK_RUNTIME_VER_G220", "00004"); // HMK_RUNTIME_VER_G220

    ExecSetStandardifValueEmpty("TC_05_1011270", "00001"); // fix value for TC_05 / MLFB05
  }
}

function SetInverter(strchangedAttribute, oData) { }
// #########################################################################################################################
/**
MLFB07: Spannung	 				HMK_VOLTAGE_G220
ECSI_CX_StandardSupplySystem
// StandardSupplySystem
        /*	0	230V 1-phase AC, 50Hz 	IEC
            1	230V 3-phase AC, 50Hz   IEC
            2	380V 3-phase AC, 50Hz   IEC
            3	400V 3-phase AC, 50Hz   IEC
            4	415V 3-phase AC, 50Hz   IEC
            5	500V 3-phase AC, 50Hz   IEC
            6	690V 3-phase AC, 50Hz   IEC
            7	240V 1-phase AC, 60Hz   NEMA
            8	240V 3-phase AC, 60Hz   NEMA
            9	380V 3-phase AC, 60Hz   IEC
            10	400V 3-phase AC, 60Hz   IEC
            11	440V 3-phase AC, 60Hz   NEMA
            12	460V 3-phase AC, 60Hz   NEMA
            13	480V 3-phase AC, 60Hz   NEMA
            14	600V 3-phase AC, 60Hz   NEMA
            15	690V 3-phase AC, 60Hz   IEC
            18	480V 3-phase AC, 50Hz   NEMA
*/
// #########################################################################################################################
function SetVoltage(oData) {
  //var oParsingData = oData.oParsingData;
  var oMLFB = oData.oParsingData.MLFB;
  var MLFB07_G220 = oMLFB.POS7;

  // VT_G220_M00017	MLFB_7_VOLTAGE
  // 	MLFB07_G220		HMK_VOLTAGE_G220

  var sTable = "VT_G220_M00017" + sDB_Suffix;
  var sSQL = "SELECT * FROM " + sTable + " WHERE " + "MLFB07_G220 = '" + MLFB07_G220 + "';";

  var aResult = GetDBDataSetEXT(sSQL);
  if (aResult.length > 0) {
    var HMK_VOLTAGE_G220 = aResult[0].HMK_VOLTAGE_G220;

    ECL_DeactivateAllAttributeValues("HMK_VOLTAGE_G220");
    ECL_ActivateValue("HMK_VOLTAGE_G220", HMK_VOLTAGE_G220);
    ECL_SelectValue("HMK_VOLTAGE_G220", HMK_VOLTAGE_G220);
  } else {
    oData.strError = "DICT1_ERR_G220___PARSER_VOLTAGE";
    return;
  }

  var ECSI_CX_StandardSupplySystem = ECL_GetValue("ECSI_CX_StandardSupplySystem");
  var HMK_DISCR_VOLTAGE_G220 = 0;
  var HMK_MOTORNORM_G220 = "00002"; // IEC 
  var HMK_NETZFREQUENZ_1011270 = "50";

  switch (ECSI_CX_StandardSupplySystem) {
    case "0":
    case "1":
      HMK_DISCR_VOLTAGE_G220 = 230;
      HMK_MOTORNORM_G220 = "00002"; // IEC 
      HMK_NETZFREQUENZ_1011270 = "50";
      break;
    case "2":
      HMK_DISCR_VOLTAGE_G220 = 380;
      HMK_MOTORNORM_G220 = "00002"; // IEC 
      HMK_NETZFREQUENZ_1011270 = "50";
      break;
    case "3":
      HMK_DISCR_VOLTAGE_G220 = 400;
      HMK_MOTORNORM_G220 = "00002"; // IEC 
      HMK_NETZFREQUENZ_1011270 = "50";
      break;
    case "4":
      HMK_DISCR_VOLTAGE_G220 = 415;
      HMK_MOTORNORM_G220 = "00002"; // IEC 
      HMK_NETZFREQUENZ_1011270 = "50";
      break;
    case "5":
      HMK_DISCR_VOLTAGE_G220 = 500;
      HMK_MOTORNORM_G220 = "00002"; // IEC 
      HMK_NETZFREQUENZ_1011270 = "50";
      break;
    case "6":
      HMK_DISCR_VOLTAGE_G220 = 690;
      HMK_MOTORNORM_G220 = "00002"; // IEC 
      HMK_NETZFREQUENZ_1011270 = "50";
      break;
    case "7":
      HMK_DISCR_VOLTAGE_G220 = 240;
      HMK_MOTORNORM_G220 = "00001"; // NEMA
      HMK_NETZFREQUENZ_1011270 = "60";
      break;
    case "8":
      HMK_DISCR_VOLTAGE_G220 = 240;
      HMK_MOTORNORM_G220 = "00001"; // NEMA
      HMK_NETZFREQUENZ_1011270 = "60";
      break;
    case "9":
      HMK_DISCR_VOLTAGE_G220 = 380;
      HMK_MOTORNORM_G220 = "00002"; // IEC 
      HMK_NETZFREQUENZ_1011270 = "60";
      break;
    case "10":
      HMK_DISCR_VOLTAGE_G220 = 400;
      HMK_MOTORNORM_G220 = "00002"; // IEC 
      HMK_NETZFREQUENZ_1011270 = "60";
      break;
    case "11":
      HMK_DISCR_VOLTAGE_G220 = 440;
      HMK_MOTORNORM_G220 = "00001"; // NEMA
      HMK_NETZFREQUENZ_1011270 = "60";
      break;
    case "12":
      HMK_DISCR_VOLTAGE_G220 = 460;
      HMK_MOTORNORM_G220 = "00001"; // NEMA
      HMK_NETZFREQUENZ_1011270 = "60";
      break;
    case "13":
      HMK_DISCR_VOLTAGE_G220 = 480;
      HMK_MOTORNORM_G220 = "00001"; // NEMA
      HMK_NETZFREQUENZ_1011270 = "60";
      break;
    case "14":
      HMK_DISCR_VOLTAGE_G220 = 600;
      HMK_MOTORNORM_G220 = "00001"; // NEMA
      HMK_NETZFREQUENZ_1011270 = "60";
      break;
    case "15":
      HMK_DISCR_VOLTAGE_G220 = 690;
      HMK_MOTORNORM_G220 = "00002"; // IEC 
      HMK_NETZFREQUENZ_1011270 = "60";
      break;
    case "18":
      HMK_DISCR_VOLTAGE_G220 = 480;
      HMK_MOTORNORM_G220 = "00001"; // NEMA
      HMK_NETZFREQUENZ_1011270 = "50";
      break;
  }
  ECL_SetValue("HMK_DISCR_VOLTAGE_G220", HMK_DISCR_VOLTAGE_G220);

  ECL_DeactivateAllAttributeValues("HMK_MOTORNORM_G220");
  ECL_ActivateValue("HMK_MOTORNORM_G220", HMK_MOTORNORM_G220);
  ECL_SelectValue("HMK_MOTORNORM_G220", HMK_MOTORNORM_G220);

  ECL_DeactivateAllAttributeValues("HMK_NETZFREQUENZ_1011270");
  ECL_ActivateValue("HMK_NETZFREQUENZ_1011270", HMK_NETZFREQUENZ_1011270);
  ECL_SelectValue("HMK_NETZFREQUENZ_1011270", HMK_NETZFREQUENZ_1011270);

}
function SetHMK_Voltages(oData) {
  /* Übersetzung HMK_DISCR_VOLTAGE_G220 in 
  HMK_CB_IEC_ICC_V_1011270        VT_G220_M00624	VOLTAGE vs CB_IEC_ICC_V
    HMK_MOTORNORM_G220	Motornorm
    HMK_CB_GROUP_CAPTION_1011270	Leistungsschalter
    HMK_DISCR_VOLTAGE_G220	Netzspannung
    HMK_CB_IEC_ICC_V_1011270	HMK_CB_IEC_ICC_V_G220

  HMK_MS_IEC_ICC_V_1011270_X      VT_G220_M00625	VOLTAGE vs MS_IEC_ICC_V
    HMK_MOTORNORM_G220	Motornorm
    HMK_MS_IEC_G_CAPTION_1011270	Motorschutzschalter
    HMK_DISCR_VOLTAGE_G220	Netzspannung
    HMK_MS_IEC_ICC_V_1011270_X	HMK_MS_IEC_ICC_V_G220

  HMK_SCFUSE_IEC_ICC_V_1011270    VT_G220_M00626	VOLTAGE vs SCFUSE_IEC_ICC_V
    HMK_MOTORNORM_G220	Motornorm
    HMK_SCFUSE_G_CAPTION_1011270	Halbleitersicherung
    HMK_DISCR_VOLTAGE_G220	Netzspannung
    HMK_SCFUSE_IEC_ICC_V_1011270	HMK_SCFUSE_IEC_ICC_V_G220

  HMK_FUSE_IEC_ICC_V_1011270      VT_G220_M00627	VOLTAGE vs FUSE_IEC_ICC_V
    HMK_MOTORNORM_G220	Motornorm
    HMK_FUSE_G_CAPTION_1011270	Standardsicherung
    HMK_DISCR_VOLTAGE_G220	Netzspannung
    HMK_FUSE_IEC_ICC_V_1011270	HMK_FUSE_IEC_ICC_V_G220

  */
  var HMK_MOTORNORM_G220 = ECL_GetValue("HMK_MOTORNORM_G220");
  var HMK_DISCR_VOLTAGE_G220 = ECL_GetValue("HMK_DISCR_VOLTAGE_G220");
  if (HMK_MOTORNORM_G220 == "00001") {
    ECL_SetValue("HMK_CB_IEC_ICC_V_1011270", "HMK_CB_IEC_ICC_V_1011270 = 0");
    ECL_SetValue("HMK_MS_IEC_ICC_V_1011270_X", "HMK_MS_IEC_ICC_V_1011270_X = '.'");
    ECL_SetValue("HMK_SCFUSE_IEC_ICC_V_1011270", "HMK_SCFUSE_IEC_ICC_V_1011270 = 0");
    ECL_SetValue("HMK_FUSE_IEC_ICC_V_1011270", "HMK_FUSE_IEC_ICC_V_1011270 = 0");
    return;
  }
  var sSQL = "SELECT * FROM VT_G220_M00624" + sDB_Suffix + " WHERE " +
    "HMK_MOTORNORM_G220 = '" + HMK_MOTORNORM_G220 + "' AND " +
    "HMK_CB_GROUP_CAPTION_1011270 = 'T' AND " +
    "HMK_DISCR_VOLTAGE_G220 = '" + HMK_DISCR_VOLTAGE_G220 + "';";
  var aResult = GetDBDataSetEXT(sSQL);
  if (aResult.length > 0) {
    var sWhere = "HMK_CB_IEC_ICC_V_1011270 IN (" + aResult[0].HMK_CB_IEC_ICC_V_1011270;

    for (var i = 1; i < aResult.length; i++) {
      sWhere += "," + aResult[i].HMK_CB_IEC_ICC_V_1011270;
    }
    sWhere += ")";

    ECL_SetValue("HMK_CB_IEC_ICC_V_1011270", sWhere);
  } else {
    oData.strError = "DICT1_ERR_G220___PARSER_VOLTAGE";
    return;
  }

  /*  HMK_MS_IEC_ICC_V_1011270_X      VT_G220_M00625	VOLTAGE vs MS_IEC_ICC_V
    HMK_MOTORNORM_G220	Motornorm
    HMK_MS_IEC_G_CAPTION_1011270	Motorschutzschalter
    HMK_DISCR_VOLTAGE_G220	Netzspannung
    HMK_MS_IEC_ICC_V_1011270_X	HMK_MS_IEC_ICC_V_G220
  */

  var sSQL = "SELECT * FROM VT_G220_M00625" + sDB_Suffix + " WHERE " +
    "HMK_MOTORNORM_G220 = '" + HMK_MOTORNORM_G220 + "' AND " +
    "HMK_MS_IEC_G_CAPTION_1011270 = 'T' AND " +
    "HMK_DISCR_VOLTAGE_G220 = '" + HMK_DISCR_VOLTAGE_G220 + "';";
  var aResult = GetDBDataSetEXT(sSQL);
  if (aResult.length > 0) {

    var sWhere = "HMK_MS_IEC_ICC_V_1011270_X IN ('" + aResult[0].HMK_MS_IEC_ICC_V_1011270_X;
    for (var i = 1; i < aResult.length; i++) {
      sWhere += "','" + aResult[i].HMK_MS_IEC_ICC_V_1011270_X;
    }
    sWhere += "')";

    ECL_SetValue("HMK_MS_IEC_ICC_V_1011270_X", sWhere);
  } else {
    oData.strError = "DICT1_ERR_G220___PARSER_VOLTAGE";
    return;
  }
  /*  HMK_SCFUSE_IEC_ICC_V_1011270    VT_G220_M00626	VOLTAGE vs SCFUSE_IEC_ICC_V
    HMK_MOTORNORM_G220	Motornorm
    HMK_SCFUSE_G_CAPTION_1011270	Halbleitersicherung
    HMK_DISCR_VOLTAGE_G220	Netzspannung
    HMK_SCFUSE_IEC_ICC_V_1011270	HMK_SCFUSE_IEC_ICC_V_G220
  */
  var sSQL = "SELECT * FROM VT_G220_M00626" + sDB_Suffix + " WHERE " +
    "HMK_MOTORNORM_G220 = '" + HMK_MOTORNORM_G220 + "' AND " +
    "HMK_SCFUSE_G_CAPTION_1011270 = 'T' AND " +
    "HMK_DISCR_VOLTAGE_G220 = '" + HMK_DISCR_VOLTAGE_G220 + "';";
  var aResult = GetDBDataSetEXT(sSQL);
  if (aResult.length > 0) {
    var sWhere = "HMK_SCFUSE_IEC_ICC_V_1011270 IN (" + aResult[0].HMK_SCFUSE_IEC_ICC_V_1011270;
    for (var i = 1; i < aResult.length; i++) {
      sWhere += "," + aResult[i].HMK_SCFUSE_IEC_ICC_V_1011270;
    }
    sWhere += ")";

    ECL_SetValue("HMK_SCFUSE_IEC_ICC_V_1011270", sWhere);
  } else {
    oData.strError = "DICT1_ERR_G220___PARSER_VOLTAGE";
    return;
  }
  /*  HMK_FUSE_IEC_ICC_V_1011270      VT_G220_M00627	VOLTAGE vs FUSE_IEC_ICC_V
  HMK_MOTORNORM_G220	Motornorm
  HMK_FUSE_G_CAPTION_1011270	Standardsicherung
  HMK_DISCR_VOLTAGE_G220	Netzspannung
  HMK_FUSE_IEC_ICC_V_1011270	HMK_FUSE_IEC_ICC_V_G220
  */
  var sSQL = "SELECT * FROM VT_G220_M00627" + sDB_Suffix + " WHERE " +
    "HMK_MOTORNORM_G220 = '" + HMK_MOTORNORM_G220 + "' AND " +
    "HMK_FUSE_G_CAPTION_1011270 = 'T' AND " +
    "HMK_DISCR_VOLTAGE_G220 = '" + HMK_DISCR_VOLTAGE_G220 + "';";
  var aResult = GetDBDataSetEXT(sSQL);

  if (aResult.length > 0) {
    var sWhere = "HMK_FUSE_IEC_ICC_V_1011270 IN (" + aResult[0].HMK_FUSE_IEC_ICC_V_1011270;
    for (var i = 1; i < aResult.length; i++) {
      sWhere += "," + aResult[i].HMK_FUSE_IEC_ICC_V_1011270;
    }
    sWhere += ")";

    ECL_SetValue("HMK_FUSE_IEC_ICC_V_1011270", sWhere);
  } else {
    oData.strError = "DICT1_ERR_G220___PARSER_VOLTAGE";
    return;
  }
}

// #########################################################################################################################
/**
MLFB08: Topologie					HMK_TOPOLOGY_G220	[GPD, RGD, LHD, CPD] Werte 00001...00004
*/
// #########################################################################################################################
function SetTopology(oData) {
  //var oParsingData = oData.oParsingData;
  var oMLFB = oData.oParsingData.MLFB;
  var MLFB08_G220 = oMLFB.POS8;

  // VT_G220_M00651	MLFB_8_DRIVE_TOPOLOGY
  // 	HMK_V_OUT_W_FM_G220			HMK_V_OUT_WO_FM_G220	PMD_ACU348_001_000_G220	PMD_ACU798_001_000_G220	PMD_ABY282_001_000_1011270
  //	PMD_ABP325_001_000_G220		MLFB08_G220				HMK_CAN_CONCT_BR_G220	HMK_TOPOLOGY_G220

  var sTable = "VT_G220_M00651" + sDB_Suffix;
  var sSQL = "SELECT MLFB08_G220, HMK_TOPOLOGY_G220 FROM " + sTable + " WHERE " + "MLFB08_G220 = '" + MLFB08_G220 + "';";

  var aResult = GetDBDataSetEXT(sSQL);
  if (aResult.length > 0) {
    var HMK_TOPOLOGY_G220 = aResult[0].HMK_TOPOLOGY_G220;

    ECL_DeactivateAllAttributeValues("HMK_TOPOLOGY_G220");
    ECL_ActivateValue("HMK_TOPOLOGY_G220", HMK_TOPOLOGY_G220);
    ECL_SelectValue("HMK_TOPOLOGY_G220", HMK_TOPOLOGY_G220);
  } else {
    oData.strError = "DICT1_ERR_G220___PARSER_TOPOLOGY";
    return;
  }
}

// #########################################################################################################################
/**
MLFB09: (.) Schutzart IP				PMD_ABJ176_001_000_G220	Schutzart IP
*/
// #########################################################################################################################
function SetProtection(oData) {
  //var oParsingData = oData.oParsingData;
  var oMLFB = oData.oParsingData.MLFB;
  var MLFB09_G220 = oMLFB.POS9;

  // VT_G220_M00564	ENCLOSURE_VARIANTS
  //old 	HMK_SCHUTZART_1011410	PMD_ABJ176_001_000_G220	PMD_ABM455_001_000_G220	MLFB09_G220	PMD_ABU539_001_000_G220	HMK_REP_SWITCH__G220
  //new  HMK_SCHUTZART_1011410 PMD_ABJ176_001_000_G220 PMD_ABM455_001_000_G220 PMD_ABY931_001_000_G220 MLFB09_G220 HMK_PROTECTION_G220 HMK_REP_SWITCH__G220

  var sTable = "VT_G220_M00564" + sDB_Suffix;
  var sSQL = "SELECT * FROM " + sTable + " WHERE " + "MLFB09_G220 = '" + MLFB09_G220 + "';";

  var aResult = GetDBDataSetEXT(sSQL);
  if (aResult.length > 0) {
    var PMD_ABJ176_001_000_G220 = aResult[0].PMD_ABJ176_001_000_G220;
    var HMK_SCHUTZART_1011410 = aResult[0].HMK_SCHUTZART_1011410;
    var PMD_ABM455_001_000_G220 = aResult[0].PMD_ABM455_001_000_G220; // Schutzart NEMA
    var PMD_ABY931_001_000_G220 = aResult[0].PMD_ABY931_001_000_G220; // Widerstandsfähigkeit / gegen chemisch aktive Stoffe / während Betrieb
    var HMK_REP_SWITCH__G220 = aResult[0].HMK_REP_SWITCH__G220; // Flag: Reparaturschalter

    ECL_DeactivateAllAttributeValues("PMD_ABJ176_001_000_G220");
    ECL_ActivateValue("PMD_ABJ176_001_000_G220", PMD_ABJ176_001_000_G220);
    ECL_SelectValue("PMD_ABJ176_001_000_G220", PMD_ABJ176_001_000_G220);

    ECL_DeactivateAllAttributeValues("HMK_SCHUTZART_1011410");
    ECL_ActivateValue("HMK_SCHUTZART_1011410", HMK_SCHUTZART_1011410);
    ECL_SelectValue("HMK_SCHUTZART_1011410", HMK_SCHUTZART_1011410);

    ECL_DeactivateAllAttributeValues("PMD_ABM455_001_000_G220");
    ECL_ActivateValue("PMD_ABM455_001_000_G220", PMD_ABM455_001_000_G220);
    ECL_SelectValue("PMD_ABM455_001_000_G220", PMD_ABM455_001_000_G220);

    ECL_DeactivateAllAttributeValues("PMD_ABY931_001_000_G220");
    ECL_ActivateValue("PMD_ABY931_001_000_G220", PMD_ABY931_001_000_G220);
    ECL_SelectValue("PMD_ABY931_001_000_G220", PMD_ABY931_001_000_G220);

    if (HMK_REP_SWITCH__G220 == "T") {
      ECL_EnableAttribute("CB_HMK_REP_SWITCH_G220");
      ECL_SelectValue("CB_HMK_REP_SWITCH_G220", "T");
    } else {
      ECL_DeselectAttribute("CB_HMK_REP_SWITCH_G220");
    }
  } else {
    oData.strError = "DICT1_ERR_G220___PARSER_PROTECTION";
    return;
  }
}

// #########################################################################################################################
/**
MLFB10: . Hardware Option		HMK_HW_OPTION_G220 (J: J=Braking chopper internal 50%Ed-100% Pnenn, A: A=No configuration / Not used, P: P=IEC-Type Gland plate by IP21/IP55, Q: Q=NEC-Type Gland plate by UL type 1/12)
*/
// #########################################################################################################################
function SetHardwareOption(oData) {
  //var oParsingData = oData.oParsingData;
  var oMLFB = oData.oParsingData.MLFB;
  var MLFB10_G220 = oMLFB.POS10;

  // VT_G220_M00039	HW_CONFIGURATION_VARIANTS
  // 	MLFB10_G220	HMK_HW_OPTION_G220

  var sTable = "VT_G220_M00039" + sDB_Suffix;
  var sSQL = "SELECT * FROM " + sTable + " WHERE " + "MLFB10_G220 = '" + MLFB10_G220 + "';";

  var aResult = GetDBDataSetEXT(sSQL);
  if (aResult.length > 0) {
    var HMK_HW_OPTION_G220 = aResult[0].HMK_HW_OPTION_G220;

    //ECL_DeactivateAllAttributeValues("HMK_HW_OPTION_G220");
    ECL_ActivateValue("HMK_HW_OPTION_G220", HMK_HW_OPTION_G220);
    ECL_SelectValue("HMK_HW_OPTION_G220", HMK_HW_OPTION_G220);
  } else {
    oData.strError = "DICT1_ERR_G220___PARSER_HARDWARE_OPTION";
    return;
  }
}

// #########################################################################################################################
/**
MLFB11: Leistung 1 (0-5: 0,55kW)	HMK_RATED_POWER_G220	Bemessungsleistung
MLFB12: Leistung 2 (0-5: 0,55kW)	
*/
// #########################################################################################################################
function SetRatedPower(oData) {
  //var oParsingData = oData.oParsingData;
  var oMLFB = oData.oParsingData.MLFB;
  var MLFB11_G220 = oMLFB.POS11;
  var MLFB12_G220 = oMLFB.POS12;

  // VT_G220_M00563	MLFB_11_12_RATED_POWER
  // 	MLFB12_G220		MLFB11_G220		HMK_RATED_POWER_G220

  var sTable = "VT_G220_M00563" + sDB_Suffix;
  var sSQL = "SELECT * FROM " + sTable + " WHERE " + "MLFB11_G220 = '" + MLFB11_G220 + "' AND " + "MLFB12_G220 = '" + MLFB12_G220 + "';";

  var aResult = GetDBDataSetEXT(sSQL);
  if (aResult.length > 0) {
    var HMK_RATED_POWER_G220 = aResult[0].HMK_RATED_POWER_G220;

    ECL_DeactivateAllAttributeValues("HMK_RATED_POWER_G220");
    ECL_ActivateValue("HMK_RATED_POWER_G220", HMK_RATED_POWER_G220);
    ECL_SelectValue("HMK_RATED_POWER_G220", HMK_RATED_POWER_G220);
  } else {
    oData.strError = "DICT1_ERR_G220___PARSER_RATED_POWER";
    return;
  }
  // VT_G220_M00503	RATED_POWER_VOLTAGE_DEPENDENT_DATA_S
  /* 	PMD_ACS927_001_000_G220	Ausgangsstrom /...messungswert
    HMK_VOLTAGE_G220	HMK_VOLTAGE_G220
    HMK_RATED_POWER_G220	HMK_RATED_POWER_G220

    HMK_RATED_CURRENT_UI_1011270
    VT_G220_M00668	Strom LO-HO min-max
      HMK_VOLTAGE_G220	HMK_VOLTAGE_G220
      HMK_RATED_POWER_G220	HMK_RATED_POWER_G220
      HMK_DISCR_VOLTAGE_G220	Netzspannung
      HMK_RATED_CURRENT_UI_1011270	Ausgangsstrom
      HMK_STROM_MIN_G220	HMK_STROM_MIN_G220
      HMK_STROM_MAX_G220	HMK_STROM_MAX_G220
      HMK_UEBERLAST_1011270	Überlastfähigke.../Überlast
      HMK_LEIST_UMR_LO_HO_1011270	 Leistung Umrichter LO / HO
      HMK_MOTORNORM_G220	Motornorm
      HMK_VALUE_VALID_G220	Flag: Eintrag ist gültig

  */
  var HMK_VOLTAGE_G220 = ECL_GetValue("HMK_VOLTAGE_G220");
  var HMK_DISCR_VOLTAGE_G220 = ECL_GetValue("HMK_DISCR_VOLTAGE_G220");

  var sTable = "VT_G220_M00668" + sDB_Suffix;
  var sSQL = "SELECT * FROM " + sTable + " WHERE " +
    "HMK_RATED_POWER_G220 = '" + HMK_RATED_POWER_G220 + "' AND " +
    "HMK_VOLTAGE_G220 = '" + HMK_VOLTAGE_G220 + "' AND " +
    "HMK_DISCR_VOLTAGE_G220 = '" + HMK_DISCR_VOLTAGE_G220 + "' AND " +
    "HMK_VALUE_VALID_G220 = 'T';";

  var aResult = GetDBDataSetEXT(sSQL);
  if (aResult.length > 0) {
    var HMK_RATED_CURRENT_UI_1011270 = aResult[0].HMK_RATED_CURRENT_UI_1011270;
    HMK_RATED_CURRENT_UI_1011270 = replace(HMK_RATED_CURRENT_UI_1011270, ".", ",");
    ECL_DeactivateAllAttributeValues("HMK_RATED_CURRENT_UI_1011270");
    ECL_ActivateValue("HMK_RATED_CURRENT_UI_1011270", HMK_RATED_CURRENT_UI_1011270);
    ECL_SelectValue("HMK_RATED_CURRENT_UI_1011270", HMK_RATED_CURRENT_UI_1011270);
  } else {
    oData.strError = "DICT1_ERR_G220___PARSER_OUTPUT_CURRENT";
    return;
  }
}

// #########################################################################################################################
/**
MLFB13: . EMC-Filterklassee			HMK_EMC_TYPE_G220
  PMD_ABY445_001_000_G220		Ausführung des Netzfilters
*/
// #########################################################################################################################
function SetEMC_Filter(oData) {
  //var oParsingData = oData.oParsingData;
  var oMLFB = oData.oParsingData.MLFB;
  var MLFB13_G220 = oMLFB.POS13;

  // VT_G220_M00036	EMC_FILTER_VARIANTS
  // 	PMD_ABY445_001_000_G220		PMD_ABY444_001_000_G220		PMD_ABP321_001_000_G220		PMD_ABP322_001_000_G220		MLFB13_G220		HMK_EMC_TYPE_G220

  var sTable = "VT_G220_M00036" + sDB_Suffix;
  var sSQL = "SELECT * FROM " + sTable + " WHERE " + "MLFB13_G220 = '" + MLFB13_G220 + "';";

  var aResult = GetDBDataSetEXT(sSQL);
  if (aResult.length > 0) {
    var HMK_EMC_TYPE_G220 = aResult[0].HMK_EMC_TYPE_G220;
    var PMD_ABY445_001_000_G220 = aResult[0].PMD_ABY445_001_000_G220;

    //ECL_DeactivateAllAttributeValues("HMK_EMC_TYPE_G220");
    ECL_ActivateValue("HMK_EMC_TYPE_G220", HMK_EMC_TYPE_G220);
    ECL_SelectValue("HMK_EMC_TYPE_G220", HMK_EMC_TYPE_G220);

    // PMD_ABY445_001_000_G220		Ausführung des Netzfilters
    ECL_ActivateValue("PMD_ABY445_001_000_G220", PMD_ABY445_001_000_G220);
    ECL_SelectValue("PMD_ABY445_001_000_G220", PMD_ABY445_001_000_G220);
  } else {
    oData.strError = "DICT1_ERR_G220___PARSER_EMC_TYPE";
    return;
  }
}

// #########################################################################################################################
/**
MLFB14: . Hardware options (A=No additional HW-options, B=DQ-Module, E=IOT-Module, F=Atex-Module)
*/
// #########################################################################################################################
function SetAddHardwareOption(oData) {
  //var oParsingData = oData.oParsingData;
  var oMLFB = oData.oParsingData.MLFB;
  var MLFB14_G220 = oMLFB.POS14;

  //var HMK_MOD_CAPACITY__G220 = ECL_GetValue("HMK_MOD_CAPACITY__G220");

  // VT_G220_M00443	OPTION_MODULE_COMBINATIONS
  // 	HMK_OM_SMT_1011270		HMK_OM_DQ_1011270	HMK_OM_IIOT_1011270		HMK_SC_OM_SMT_1011270	HMK_SC_OM_DQ_G220	MLFB14_G220		HMK_SC_OM_IIOT_G220
  // 	HMK_OM_SMT_1011270		HMK_OM_DQ_1011270	HMK_OM_IIOT_1011270		HMK_SC_OM_SMT_1011270	HMK_SC_OM_DQ_G220	PMD_ACT536_001_000_1011410	MLFB14_G220	HMK_SC_OM_IIOT_G220

  var sTable = "VT_G220_M00443" + sDB_Suffix;
  var sSQL = "SELECT * FROM " + sTable + " WHERE " + "MLFB14_G220 = '" + MLFB14_G220 + "';";

  var aResult = GetDBDataSetEXT(sSQL);
  if (aResult.length > 0) {
    // if A, additional KAG could be set
    if (MLFB14_G220 !== "A") {
      var HMK_OM_IIOT_1011270 = aResult[0].HMK_OM_IIOT_1011270;
      //var HMK_SC_OM_IIOT_G220 	= aResult[0].HMK_SC_OM_IIOT_G220;

      var HMK_OM_DQ_1011270 = aResult[0].HMK_OM_DQ_1011270;
      //var HMK_SC_OM_DQ_G220 		= aResult[0].HMK_SC_OM_DQ_G220;

      var HMK_OM_SMT_1011270 = aResult[0].HMK_OM_SMT_1011270;
      //var HMK_SC_OM_SMT_1011270 	= aResult[0].HMK_SC_OM_SMT_1011270;

      // if Safty function SMT (15) is given as context, OM SMT is mandatory
      if (oData.SMTmandatory == "true") {
        // if HMK_MOD_CAPACITY__G220 < 3 not possible
        //if (HMK_MOD_CAPACITY__G220 >= 3){
        var bSMTmandatory = true;
        HMK_OM_SMT_1011270 = "00001";
        /*}else{
          oData.strError = "DICT1_ERR_G220___PARSER_ADD_SMT_MANDATORY_MOD_CAP";
          return;
        }*/
      }
      // SMT
      if (HMK_OM_SMT_1011270 == "00001") {
        ECL_ActivateValue("HMK_OM_SMT_1011270", "00001");
        ECL_SelectValue("HMK_OM_SMT_1011270", "00001");
        ECL_EnableAttribute("CB_HMK_SC_OM_SMT_G220");
        ECL_SelectValue("CB_HMK_SC_OM_SMT_G220", "T");
        if (bSMTmandatory) {
          ECL_DeactivateValue("HMK_OM_SMT_1011270", "00002");
          ECL_DisableAttribute("CB_HMK_SC_OM_SMT_G220");
        } else {
          ECL_ActivateValue("HMK_OM_SMT_1011270", "00002");
          ECL_EnableAttribute("CB_HMK_SC_OM_SMT_G220");
        }
      } else {
        ECL_ActivateValue("HMK_OM_SMT_1011270", "00002");
        ECL_SelectValue("HMK_OM_SMT_1011270", "00002");
        ECL_DeselectAttribute("CB_HMK_SC_OM_SMT_G220");
      }

      // IIOT
      if (HMK_OM_IIOT_1011270 == "00001") {
        ECL_ActivateValue("HMK_OM_IIOT_1011270", "00001");
        ECL_SelectValue("HMK_OM_IIOT_1011270", "00001");
        ECL_EnableAttribute("CB_HMK_SC_OM_IIOT_G220");
        ECL_SelectValue("CB_HMK_SC_OM_IIOT_G220", "T");
      } else {
        ECL_ActivateValue("HMK_OM_IIOT_1011270", "00002");
        ECL_SelectValue("HMK_OM_IIOT_1011270", "00002");
        ECL_DeselectAttribute("CB_HMK_SC_OM_IIOT_G220");
      }

      // DQ
      if (HMK_OM_DQ_1011270 == "00001") {
        ECL_ActivateValue("HMK_OM_DQ_1011270", "00001");
        ECL_SelectValue("HMK_OM_DQ_1011270", "00001");
        ECL_EnableAttribute("CB_HMK_SC_OM_DQ_G220");
        ECL_SelectValue("CB_HMK_SC_OM_DQ_G220", "T");
      } else {
        ECL_ActivateValue("HMK_OM_DQ_1011270", "00002");
        ECL_SelectValue("HMK_OM_DQ_1011270", "00002");
        ECL_DeselectAttribute("CB_HMK_SC_OM_DQ_G220");
      }
    } else {
      // if "A" and no short options (KAG),
      //check KAG
      // ------------------------------------------------------------------------------------
      //var sAttribute = "CB_HMK_SC_OM_DQ_G220";	// T01
      // ------------------------------------------------------------------------------------
      var sKAG = "T01";
      if (oMLFB.KAG.indexOf(sKAG) > -1) {
        // es gibt eine KAG, also setzen
        ECL_EnableAttribute("CB_HMK_SC_OM_DQ_G220");
        ECL_SelectValue("CB_HMK_SC_OM_DQ_G220", "T");
      } else {
        ECL_DeselectAttribute("CB_HMK_SC_OM_DQ_G220");
      }

      // ------------------------------------------------------------------------------------
      //var sAttribute = "CB_HMK_SC_OM_IIOT_G220";	// T04
      // ------------------------------------------------------------------------------------
      var sKAG = "T04";
      if (oMLFB.KAG.indexOf(sKAG) > -1) {
        // es gibt eine KAG, also setzen
        ECL_EnableAttribute("CB_HMK_SC_OM_IIOT_G220");
        ECL_SelectValue("CB_HMK_SC_OM_IIOT_G220", "T");
      } else {
        ECL_DeselectAttribute("CB_HMK_SC_OM_IIOT_G220");
      }

      // ------------------------------------------------------------------------------------
      //var sAttribute = "CB_HMK_SC_OM_SMT_G220";	// T05
      // ------------------------------------------------------------------------------------
      // if Safty function SMT (15) is given as context, OM SMT is mandatory
      if (oData.SMTmandatory == "true") {
        ECL_SelectValue("CB_HMK_SC_OM_SMT_G220", "T");
        ECL_DisableAttribute("CB_HMK_SC_OM_SMT_G220");
        if(ECL_ValueSelected("CB_HMK_SC_OM_IIOT_G220", "T") && ECL_ValueSelected("CB_HMK_SC_OM_DQ_G220", "T")){
          ECL_SelectValue("CB_HMK_SC_OM_DQ_G220", "");
          ECL_SelectValue("CB_HMK_SC_OM_IIOT_G220", "");
        }
      } else {
        var sKAG = "T05";
        if (oMLFB.KAG.indexOf(sKAG) > -1) {
          // es gibt eine KAG, also setzen
          ECL_EnableAttribute("CB_HMK_SC_OM_SMT_G220");
          ECL_SelectValue("CB_HMK_SC_OM_SMT_G220", "T");
        } else {
          ECL_DeselectAttribute("CB_HMK_SC_OM_SMT_G220");
        }
      }
    }
  } else {
    oData.strError = "DICT1_ERR_G220___PARSER_ADD_HARDWARE_OPTION";
    return;
  }
}

// #########################################################################################################################
/**
MLFB15:	. Feldbus						HMK_FIELDB_TYPE_G220		PMD_ABY317_001_000_G220
*/
// #########################################################################################################################
function SetCommunication(oData) {
  //var oParsingData = oData.oParsingData;
  var oMLFB = oData.oParsingData.MLFB;
  var MLFB15_G220 = oMLFB.POS15;

  // VT_G220_M00674	FIELDBUS_VARIANTS
  // 	PMD_AAC456_001_000_G220		PMD_AAC713_001_000_G220		PMD_ABP138_001_000_G220		PMD_AAC630_001_000_G220
  //	PMD_AAC175_001_000_G220		PMD_AAD192_001_000_G220		PMD_AAC925_001_000_G220		PMD_AAB265_001_000_G220_X
  //	MLFB15_G220		HMK_FIELDB_TYPE_G220

  // VT_G220_M00385	SUPPORTED_PROTOCOLS
  //	PMD_ABY317_001_000_G220
  //	PMD_ACW028_001_000_1011270	PMD_ACW031_001_000_1011270	HMK_RUNTIME_VER_G220	PMD_ABV096_001_000_G220	PMD_AAF885_001_000_G220
  //	PMD_ABS477_001_000_G220		PMD_ABS652_001_000_G220		PMD_ABJ989_001_000_G220	PMD_AAE487_001_000_G220	PMD_ABP144_001_000_G220
  //	PMD_ACA675_001_000_G220		PMD_ABY317_001_000_G220		PMD_ABP143_001_000_G220	PMD_ABP141_001_000_G220	HMK_FIELDB_TYPE_G220
  //	PMD_ACV484_001_000_G220

  var sTable = "VT_G220_M00674" + sDB_Suffix;
  var sSQL = "SELECT * FROM " + sTable + " WHERE " + "MLFB15_G220 = '" + MLFB15_G220 + "';";

  var aResult = GetDBDataSetEXT(sSQL);
  if (aResult.length > 0) {
    var HMK_FIELDB_TYPE_G220 = aResult[0].HMK_FIELDB_TYPE_G220;

    ECL_DeactivateAllAttributeValues("HMK_FIELDB_TYPE_G220");
    ECL_ActivateValue("HMK_FIELDB_TYPE_G220", HMK_FIELDB_TYPE_G220);
    ECL_SelectValue("HMK_FIELDB_TYPE_G220", HMK_FIELDB_TYPE_G220);

    var sTable = "VT_G220_M00385" + sDB_Suffix;
    var sSQL =
      "SELECT HMK_FIELDB_TYPE_G220, PMD_ABY317_001_000_G220 FROM " + sTable + " WHERE " + "HMK_FIELDB_TYPE_G220 = '" + HMK_FIELDB_TYPE_G220 + "';";

    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length > 0) {
      var HMK_FIELDB_TYPE_G220 = aResult[0].HMK_FIELDB_TYPE_G220;

      ECL_DeactivateAllAttributeValues("PMD_ABY317_001_000_G220");
      ECL_ActivateValue("PMD_ABY317_001_000_G220", "00003");
      ECL_SelectValue("PMD_ABY317_001_000_G220", "00003");
    }
  } else {
    oData.strError = "DICT1_ERR_G220___PARSER_FIELDBUS";
    return;
  }
}

// #########################################################################################################################
/**
MLFB16:	1 Version / Production release
*/
// #########################################################################################################################
function SetProductVersion(oData) {
  //var oParsingData = oData.oParsingData;
  var oMLFB = oData.oParsingData.MLFB;
  var MLFB16_G220 = oMLFB.POS16;

  // VT_G220_M00389	MLFB16_PRODUCT_VERSION
  // 	MLFB16_G220		HMK_PROD_VERSION_G220

  var sTable = "VT_G220_M00389" + sDB_Suffix;
  var sSQL = "SELECT * FROM " + sTable + " WHERE " + "MLFB16_G220 = '" + MLFB16_G220 + "';";

  var aResult = GetDBDataSetEXT(sSQL);
  if (aResult.length > 0) {
    var HMK_PROD_VERSION_G220 = aResult[0].HMK_PROD_VERSION_G220;

    ECL_DeactivateAllAttributeValues("HMK_PROD_VERSION_G220");
    ECL_ActivateValue("HMK_PROD_VERSION_G220", HMK_PROD_VERSION_G220);
    ECL_SelectValue("HMK_PROD_VERSION_G220", HMK_PROD_VERSION_G220);
  } else {
    oData.strError = "DICT1_ERR_G220___PARSER_PRODUCT_VERSION";
    return;
  }
}

/**
 * HMK_FRAMESIZE_G220		Baugräße
 * PMD_ACJ913_001_000_G220	Baugröße des Umrichters
 * HMK_VOLTAGE_PW_KEY_1011270
 */
function SetFrameSize(oData) {
  /*
  VT_G220_M00013	FRAMESIZE_GROUP_DEFINITION
    HMK_FRAMESIZE_G220	HMK_FRAMESIZE_G220
  nn	HMK_FS_GROUP_G220	HMK_FS_GROUP_G220		only for cable length

  VT_G220_M00417	FRAMESIZE_DEPENDENT_DATA

  VT_G220_M00345	DIMENSIONS

  VT_G220_M00361	DIMENSION_DEPTH_
    HMK_FRAMESIZE_G220			HMK_FRAMESIZE_G220
    PMD_ABJ176_001_000_G220		Schutzart IP
    PMD_ACF458_001_000_1011270	Tiefe [in]
    PMD_ABJ179_001_000_G220		Tiefe
    HMK_REP_SWITCH__G220		Flag: Reparaturschalter
  
  NEU: VT_G220_M00643	FS_VOLT_POW_IPX exteded
    HMK_FRAMESIZE_G220	HMK_FRAMESIZE_G220
    PMD_ABJ176_001_000_G220	Schutzart IP
    PMD_ACJ913_001_000_G220	Baugröße / des Umrichters
    HMK_VOLTAGE_G220	HMK_VOLTAGE_G220
    HMK_RATED_POWER_G220	HMK_RATED_POWER_G220
    HMK_VOLTAGE_PW_KEY_1011270	Voltage_Power Key
    HMK_TOPOLOGY_G220	HMK_TOPOLOGY_G220
  */

  // VT_G220_M00643	FS_VOLT_POW_IPX exteded

  var PMD_ABJ176_001_000_G220 = ECL_GetValue("PMD_ABJ176_001_000_G220");
  var HMK_VOLTAGE_G220 = ECL_GetValue("HMK_VOLTAGE_G220");
  var HMK_RATED_POWER_G220 = ECL_GetValue("HMK_RATED_POWER_G220");
  var HMK_TOPOLOGY_G220 = ECL_GetValue("HMK_TOPOLOGY_G220");

  var sTable = "VT_G220_M00643" + sDB_Suffix;
  var sSQL =
    "SELECT * FROM " +
    sTable +
    " WHERE " +
    "PMD_ABJ176_001_000_G220 = '" +
    PMD_ABJ176_001_000_G220 +
    "' AND " +
    "HMK_VOLTAGE_G220 = '" +
    HMK_VOLTAGE_G220 +
    "' AND " +
    "HMK_RATED_POWER_G220 = '" +
    HMK_RATED_POWER_G220 +
    "';";

  var aResult = GetDBDataSetEXT(sSQL);
  if (aResult.length > 0) {

    var HMK_FRAMESIZE_G220 = aResult[0].HMK_FRAMESIZE_G220;
    var PMD_ACJ913_001_000_G220 = aResult[0].PMD_ACJ913_001_000_G220;

    ECL_DeactivateAllAttributeValues("HMK_FRAMESIZE_G220");
    ECL_ActivateValue("HMK_FRAMESIZE_G220", HMK_FRAMESIZE_G220);
    ECL_SelectValue("HMK_FRAMESIZE_G220", HMK_FRAMESIZE_G220);

    ECL_DeactivateAllAttributeValues("PMD_ACJ913_001_000_G220");
    ECL_ActivateValue("PMD_ACJ913_001_000_G220", PMD_ACJ913_001_000_G220);
    ECL_SelectValue("PMD_ACJ913_001_000_G220", PMD_ACJ913_001_000_G220);

    // integrate HMK_VOLTAGE_PW_KEY_1011270
    var HMK_VOLTAGE_PW_KEY_1011270 = aResult[0].HMK_VOLTAGE_PW_KEY_1011270;
    ECL_SelectValue("HMK_VOLTAGE_PW_KEY_1011270", HMK_VOLTAGE_PW_KEY_1011270);

  } else {
    oData.strError = "DICT1_ERR_G220___PARSER_FRAMESIZE";
    return;
  }
}

/**
 * Bestimmen von HMK_VOLTAGE_PW_KEY_1011270
 * @param {oData} oData
 * /
function SetVoltage_PW_Key(oData) {
  /*
  VT_G220_M00607	FS_VOLT_POW_IPX exteded
    PMD_ABJ176_001_000_G220		Schutzart IP
    HMK_VOLTAGE_G220			HMK_VOLTAGE_G220
    HMK_RATED_POWER_G220		HMK_RATED_POWER_G220
    HMK_FS_HELPER_G220			HMK_FS_HELPER_G220
    HMK_VOLTAGE_PW_KEY_1011270	Voltage_Power Key

  * /
  var PMD_ABJ176_001_000_G220 = ECL_GetValue("PMD_ABJ176_001_000_G220");
  var HMK_VOLTAGE_G220 = ECL_GetValue("HMK_VOLTAGE_G220");
  var HMK_RATED_POWER_G220 = ECL_GetValue("HMK_RATED_POWER_G220");
  var HMK_FS_HELPER_G220 = ECL_GetValue("HMK_FS_HELPER_G220");

  var sTable = "VT_G220_M00607" + sDB_Suffix;
  var sSQL =
    "SELECT * FROM " +
    sTable +
    " WHERE " +
    "PMD_ABJ176_001_000_G220 = '" +
    PMD_ABJ176_001_000_G220 +
    "' AND " +
    "HMK_VOLTAGE_G220 = '" +
    HMK_VOLTAGE_G220 +
    "' AND " +
    "HMK_RATED_POWER_G220 = '" +
    HMK_RATED_POWER_G220 +
    "' AND " +
    "HMK_FS_HELPER_G220 = '" +
    HMK_FS_HELPER_G220 +
    "';";
  var aResult = GetDBDataSetEXT(sSQL);
  if (aResult.length > 0) {
    var HMK_VOLTAGE_PW_KEY_1011270 = aResult[0].HMK_VOLTAGE_PW_KEY_1011270;

    ECL_SelectValue("HMK_VOLTAGE_PW_KEY_1011270", HMK_VOLTAGE_PW_KEY_1011270);
  } else {
    oData.strError = "DICT1_ERR_G220___PARSER_VOLTAGE_PW_KEY";
    return;
  }
}
  */

