//@legacy
//#mode(full-ecma)

// ---------------------------------------------------------
// Script for configuration object CFG_SIEMENS_G220
// 	Date: 2023-04-26
// 	User: Administrator
// ---------------------------------------------------------

//@import "CFG_G220_VT.js"

/**
  Abbildung der Produktlogik aus Variantentabellen
*/
function ExecProductLogicG220(strchangedAttribute) {
  var strError = "";

  var sMLFB = ECL_GetValue("ECSI_MLFB");

  var MLFB06_G220 = sMLFB.charAt(5); //
  var MLFB07_G220 = sMLFB.charAt(6); // HMK_VOLTAGE_G220		Spannung
  var MLFB08_G220 = sMLFB.charAt(7); // HMK_TOPOLOGY_G220	Topologie 			[GPD, RGD, LHD, CPD] Werte 00001...00004
  var MLFB09_G220 = sMLFB.charAt(8); // Schutzart
  var MLFB10_G220 = sMLFB.charAt(9); // HMK_HW_OPTION_G220	Hardware Option		[P=IEC,Q=NEC,A=w/o]
  var MLFB11_G220 = sMLFB.charAt(10); // HMK_RATED_POWER_G220	Bemessungsleistung
  var MLFB12_G220 = sMLFB.charAt(11); // HMK_RATED_POWER_G220	Bemessungsleistung
  var sMLFB_RatedPower = MLFB11_G220 + MLFB12_G220; // HMK_RATED_POWER_G220	Bemessungsleistung
  var MLFB13_G220 = sMLFB.charAt(12); //
  var MLFB14_G220 = sMLFB.charAt(13); //
  var MLFB15_G220 = sMLFB.charAt(14); //
  var MLFB16_G220 = sMLFB.charAt(15); // Verion fix

  var PMD_ABJ176_001_000_G220 = ECL_GetValue("PMD_ABJ176_001_000_G220");
  var sECSI_CX_SafetyFunctions = ECL_GetValue("ECSI_CX_SafetyFunctions");
  var ECSI_CX_RegenerativeMode = ECL_GetValue("ECSI_CX_RegenerativeMode");
  var ECSI_CX_CustomBrakingResistor = ECL_GetValue("ECSI_CX_CustomBrakingResistor");
  
  var HMK_RATED_POWER_G220 = ECL_GetValue("HMK_RATED_POWER_G220");
  var HMK_VOLTAGE_G220 = ECL_GetValue("HMK_VOLTAGE_G220");
  var HMK_VOLTAGE_PW_KEY_1011270 = ECL_GetValue("HMK_VOLTAGE_PW_KEY_1011270");
  var sWhereHMK_CB_IEC_ICC_V_1011270 = ECL_GetValue("HMK_CB_IEC_ICC_V_1011270");
  var sWhereHMK_MS_IEC_ICC_V_1011270_X = ECL_GetValue("HMK_MS_IEC_ICC_V_1011270_X");
  var sWhereHMK_SCFUSE_IEC_ICC_V_1011270 = ECL_GetValue("HMK_SCFUSE_IEC_ICC_V_1011270");
  var sWhereHMK_FUSE_IEC_ICC_V_1011270 = ECL_GetValue("HMK_FUSE_IEC_ICC_V_1011270");
  var HMK_SCHUTZART_1011410 = ECL_GetValue("HMK_SCHUTZART_1011410");
  var HMK_TOPOLOGY_G220 = ECL_GetValue("HMK_TOPOLOGY_G220");
  
  var HMK_FRAMESIZE_G220 = ECL_GetValue("HMK_FRAMESIZE_G220");
  var PMD_ACJ913_001_000_G220 = ECL_GetValue("PMD_ACJ913_001_000_G220");
  // ################################################################################################################
  // Set TC-Attributes
  // ################################################################################################################
  /*
  TC_MAPPING_MLFB06	VT_G220_M00156	fix only one value
    TC_06_1011530	MLFB06_G220
  TC_MAPPING_MLFB07	VT_G220_M00151	SIZER setted
    TC_07_1011270	MLFB07_G220
  TC_MAPPING_MLFB08	VT_G220_M00157	user set?
    TC_08_1011270	MLFB08_G220
  TC_MAPPING_MLFB09	VT_G220_M00158	user set
    TC_09_1011270	MLFB09_G220
  TC_MAPPING_MLFB10	VT_G220_M00159	user set
    TC_10_1011270	MLFB10_G220
  TC_MAPPING_MLFB11_12	VT_G220_M00160	SIZER setted	
    TC_11_1011410	MLFB12_G220		MLFB11_G220			<== handled seperatly
  TC_MAPPING_MLFB13	VT_G220_M00161	user set
    TC_13_1011270	MLFB13_G220
  TC_MAPPING_MLFB14	VT_G220_M00162	user set	
    TC_14_1011270	MLFB14_G220
  TC_MAPPING_MLFB15	VT_G220_M00163	user set
    TC_15_1011270	MLFB15_G220
  TC_MAPPING_MLFB16	VT_G220_M00164	fix only one value
    TC_16_1011270	MLFB16_G220
  */

  // fix value for TC_05 / MLFB05
  ExecSetStandardifValueEmpty("TC_05_1011270", "00001");

  var aTC_MAPPING = [
    { VT: "VT_G220_M00158", TC: "TC_09_1011270", MLFB: "MLFB09_G220" },
    { VT: "VT_G220_M00159", TC: "TC_10_1011270", MLFB: "MLFB10_G220" },
    { VT: "VT_G220_M00161", TC: "TC_13_1011270", MLFB: "MLFB13_G220" },
    { VT: "VT_G220_M00162", TC: "TC_14_1011270", MLFB: "MLFB14_G220" },
    { VT: "VT_G220_M00163", TC: "TC_15_1011270", MLFB: "MLFB15_G220" },
  ];

  for (var i = 0; i < aTC_MAPPING.length; i++) {
    //var sName = aTC_MAPPING[i].TC;
    var VT_Ident = aTC_MAPPING[i].VT;
    var TC_Ident = aTC_MAPPING[i].TC;
    var MLFB_Ident = aTC_MAPPING[i].MLFB;

    var sTable = VT_Ident + sDB_Suffix;
    var sSQL = "SELECT * FROM " + sTable + " WHERE " + MLFB_Ident + " = '" + ECL_GetValue(MLFB_Ident) + "';";
    var aResult = GetDBDataSetEXT(sSQL);

    if (aResult.length > 0) {
      var sValue = aResult[0][TC_Ident];
      ECL_SelectValue(TC_Ident, sValue);
    } else {
      strError = "DICT1_ERR_G220___PL_TRANS_MLFB_TO_TC";
      return strError;
    }
  }
  // Translate AND restriction for fixed attributes
  var aTC_MapFixed = [
    { VT: "VT_G220_M00156", TC: "TC_06_1011530", MLFB: "MLFB06_G220" }, // fix, only one value
    { VT: "VT_G220_M00151", TC: "TC_07_1011270", MLFB: "MLFB07_G220" }, // fix SIZER setted
    { VT: "VT_G220_M00157", TC: "TC_08_1011270", MLFB: "MLFB08_G220" }, // fix SIZER setted / SeriesID depending
    { VT: "VT_G220_M00164", TC: "TC_16_1011270", MLFB: "MLFB16_G220" }, // fix, only one value
  ];
  for (var i = 0; i < aTC_MapFixed.length; i++) {
    //var sName = aTC_MAPPING[i].TC;
    var VT_Ident = aTC_MapFixed[i].VT;
    var TC_Ident = aTC_MapFixed[i].TC;
    var MLFB_Ident = aTC_MapFixed[i].MLFB;

    var sTable = VT_Ident + sDB_Suffix;
    var sSQL = "SELECT * FROM " + sTable + " WHERE " + MLFB_Ident + " = '" + ECL_GetValue(MLFB_Ident) + "';";
    var aResult = GetDBDataSetEXT(sSQL);

    if (aResult.length > 0) {
      var sValue = aResult[0][TC_Ident];
      ECL_DeactivateAllAttributeValues(TC_Ident);
      ECL_ActivateValue(TC_Ident, sValue);
      ECL_SelectValue(TC_Ident, sValue);
    } else {
      strError = "DICT1_ERR_G220___PL_TRANS_MLFB_TO_TC_FIXED";
      return strError;
    }
  }

  // VT_G220_M00160	TC_MAPPING_MLFB11_12
  //	TC_11_1011410	MLFB12_G220		MLFB11_G220			<== handled seperatly

  var sTable = "VT_G220_M00160" + sDB_Suffix;
  var sSQL =
    "SELECT * FROM " +
    sTable +
    " WHERE " +
    "MLFB11_G220 = '" +
    ECL_GetValue("MLFB11_G220") +
    "' AND " +
    "MLFB12_G220 = '" +
    ECL_GetValue("MLFB12_G220") +
    "';";

  var aResult = GetDBDataSetEXT(sSQL);

  if (aResult.length > 0) {
    var sValue = aResult[0].TC_11_1011410;
    ECL_DeactivateAllAttributeValues("TC_11_1011410");
    ECL_ActivateValue("TC_11_1011410", sValue);
    ECL_SelectValue("TC_11_1011410", sValue);
  } else {
    strError = "DICT1_ERR_G220___PL_TRANS_MLFB_TO_TC_RATED_POWER";
    return strError;
  }
  // ################################################################################################################

  // ################################################################################################################
  // run TC-logic
  // ################################################################################################################
  // VT_G220_M00165	TC_CONFIG
  /* 		TC_05_1011270	fix only one value 
      TC_06_1011530	fix only one value
      TC_07_1011270	fix SIZER setted
      TC_08_1011270	fix SIZER setted / SeriesID depending
      TC_09_1011270
      TC_10_1011270
      TC_11_1011410	fix	SIZER setted (MLFB11+12) rated power
      TC_13_1011270
      TC_14_1011270
      TC_15_1011270
      TC_16_1011270	fix only one value 
  */
  var TC_05_1011270 = ECL_GetValue("TC_05_1011270");
  var TC_06_1011530 = ECL_GetValue("TC_06_1011530");
  var TC_07_1011270 = ECL_GetValue("TC_07_1011270");
  var TC_08_1011270 = ECL_GetValue("TC_08_1011270");
  var TC_11_1011410 = ECL_GetValue("TC_11_1011410");
  var TC_16_1011270 = ECL_GetValue("TC_16_1011270");

  // ----------------------------------------------------------------------------------------------------------------
  // TC_09	IP class, 3Cx, repair switch
  // ----------------------------------------------------------------------------------------------------------------
  var sTargetAttribute = "TC_09_1011270";
  /**
   * previous restriction from IP class (SeriesID)
   */
  /*var sWhereMLFB09 = "";
  var aMLFB09_ValidValues = ECL_GetAllActiveAttributeValues("MLFB09_G220");
  if (aMLFB09_ValidValues && aMLFB09_ValidValues.length>0){
    sWhereMLFB09 = "MLFB09_G220 = '" + aMLFB09_ValidValues[0] + "'";

    if (aMLFB09_ValidValues.length > 1){
      sWhereMLFB09 = "(" + sWhereMLFB09;
      for (var i=1; i< aMLFB09_ValidValues.length; i++){
        sWhereMLFB09 += " OR MLFB09_G220 = '" + aMLFB09_ValidValues[i] + "'";
      }
      sWhereMLFB09 += ")";
    }
  }else{
    strError = "DICT1_ERR_G220___PL_TC_LOGIC";
    return strError;
  }
  var sWhereMLFB09 = "TC_07_1011270 = '" + TC_07_1011270 + "' AND ";
  */
  var sTable = "VT_G220_M00165" + sDB_Suffix;
  var sWhere =
    "TC_05_1011270 = '" +
    TC_05_1011270 +
    "' AND " +
    "TC_06_1011530 = '" +
    TC_06_1011530 +
    "' AND " +
    "TC_07_1011270 = '" +
    TC_07_1011270 +
    "' AND " +
    "TC_08_1011270 = '" +
    TC_08_1011270 +
    "' AND " +
    "TC_11_1011410 = '" +
    TC_11_1011410 +
    "' AND " +
    "TC_16_1011270 = '" +
    TC_16_1011270 +
    "';"; // AND " +
  //sWhereMLFB09 + ";";

  var sStatus = SetAttributeLogic1st(sTable, sTargetAttribute, sWhere);

  if (sStatus == "Error") {
    strError = "DICT1_ERR_G220___PL_TC_LOGIC";
    return strError;
  }
  // to do ??? var sWhereTC09 = ""

  // ----------------------------------------------------------------------------------------------------------------
  // TC_10	Hardware option
  // ----------------------------------------------------------------------------------------------------------------
  var sTargetAttribute = "TC_10_1011270";

  var sTable = "VT_G220_M00165" + sDB_Suffix;
  var sWhere =
    "TC_05_1011270 = '" +
    TC_05_1011270 +
    "' AND " +
    "TC_06_1011530 = '" +
    TC_06_1011530 +
    "' AND " +
    "TC_07_1011270 = '" +
    TC_07_1011270 +
    "' AND " +
    "TC_08_1011270 = '" +
    TC_08_1011270 +
    "' AND " +
    "TC_11_1011410 = '" +
    TC_11_1011410 +
    "' AND " +
    "TC_16_1011270 = '" +
    TC_16_1011270 +
    "';";

  var sStatus = SetAttributeLogic1st(sTable, sTargetAttribute, sWhere);

  if (sStatus == "Error") {
    strError = "DICT1_ERR_G220___PL_TC_LOGIC";
    return strError;
  }

  // ----------------------------------------------------------------------------------------------------------------
  // TC_13	EMC category
  // ----------------------------------------------------------------------------------------------------------------
  var sTargetAttribute = "TC_13_1011270";

  var sTable = "VT_G220_M00165" + sDB_Suffix;
  var sWhere =
    "TC_05_1011270 = '" +
    TC_05_1011270 +
    "' AND " +
    "TC_06_1011530 = '" +
    TC_06_1011530 +
    "' AND " +
    "TC_07_1011270 = '" +
    TC_07_1011270 +
    "' AND " +
    "TC_08_1011270 = '" +
    TC_08_1011270 +
    "' AND " +
    "TC_11_1011410 = '" +
    TC_11_1011410 +
    "' AND " +
    "TC_16_1011270 = '" +
    TC_16_1011270 +
    "';";

  var sStatus = SetAttributeLogic1st(sTable, sTargetAttribute, sWhere);

  if (sStatus == "Error") {
    strError = "DICT1_ERR_G220___PL_TC_LOGIC";
    return strError;
  }

  // ----------------------------------------------------------------------------------------------------------------
  // TC_14	additional hardware option modukes
  // ----------------------------------------------------------------------------------------------------------------
  var sTargetAttribute = "TC_14_1011270";

  var sTable = "VT_G220_M00165" + sDB_Suffix;
  var sWhere =
    "TC_05_1011270 = '" +
    TC_05_1011270 +
    "' AND " +
    "TC_06_1011530 = '" +
    TC_06_1011530 +
    "' AND " +
    "TC_07_1011270 = '" +
    TC_07_1011270 +
    "' AND " +
    "TC_08_1011270 = '" +
    TC_08_1011270 +
    "' AND " +
    "TC_11_1011410 = '" +
    TC_11_1011410 +
    "' AND " +
    "TC_16_1011270 = '" +
    TC_16_1011270 +
    "';";

  var sStatus = SetAttributeLogic1st(sTable, sTargetAttribute, sWhere);

  if (sStatus == "Error") {
    strError = "DICT1_ERR_G220___PL_TC_LOGIC";
    return strError;
  }

  // ----------------------------------------------------------------------------------------------------------------
  // TC_15	Communication / Fieldbus
  // ----------------------------------------------------------------------------------------------------------------
  var sTargetAttribute = "TC_15_1011270";

  var sTable = "VT_G220_M00165" + sDB_Suffix;
  var sWhere =
    "TC_05_1011270 = '" +
    TC_05_1011270 +
    "' AND " +
    "TC_06_1011530 = '" +
    TC_06_1011530 +
    "' AND " +
    "TC_07_1011270 = '" +
    TC_07_1011270 +
    "' AND " +
    "TC_08_1011270 = '" +
    TC_08_1011270 +
    "' AND " +
    "TC_11_1011410 = '" +
    TC_11_1011410 +
    "' AND " +
    "TC_16_1011270 = '" +
    TC_16_1011270 +
    "';";

  var sStatus = SetAttributeLogic1st(sTable, sTargetAttribute, sWhere);

  if (sStatus == "Error") {
    strError = "DICT1_ERR_G220___PL_TC_LOGIC";
    return strError;
  }
  // ################################################################################################################

  // ################################################################################################################
  // transfer TC-restrictions to MLFB-Attributes
  // ################################################################################################################

  var aTC_MAPPING = [
    { VT: "VT_G220_M00158", TC: "TC_09_1011270", MLFB: "MLFB09_G220" },
    { VT: "VT_G220_M00159", TC: "TC_10_1011270", MLFB: "MLFB10_G220" },
    { VT: "VT_G220_M00161", TC: "TC_13_1011270", MLFB: "MLFB13_G220" },
    { VT: "VT_G220_M00162", TC: "TC_14_1011270", MLFB: "MLFB14_G220" },
    { VT: "VT_G220_M00163", TC: "TC_15_1011270", MLFB: "MLFB15_G220" },
  ];

  for (var k = 0; k < aTC_MAPPING.length; k++) {
    var VT_Ident = aTC_MAPPING[k].VT;
    var TC_Ident = aTC_MAPPING[k].TC;
    var MLFB_Ident = aTC_MAPPING[k].MLFB;

    if (MLFB_Ident == "MLFB09_G220") {
      var sStatus = SetAttributeLogicFromMLFBIntersect(MLFB_Ident, TC_Ident, VT_Ident + sDB_Suffix);
    } else {
      var sStatus = SetAttributeLogicFromMLFB(MLFB_Ident, TC_Ident, VT_Ident + sDB_Suffix);
    }
    if (sStatus == "Error") {
      strError = "DICT1_ERR_G220___PL_TRANS_TC_BACK_TO_MLFB";
      return strError;
    }
  }
  // ################################################################################################################

  // ################################################################################################################
  // Fix Values
  // ################################################################################################################
  /**
  HMK_ANZAHL_PHASEN_1011270	Phasenzahl				00001	3AC
    VT_G220_M00661	VOLTAGE_DEPENDENT_DATA
	
  HMK_RUNTIME_VER_G220		Runtime version			00004	6.2
    VT_G220_M00091	SOFTWARE_FUNCTIONS
    VT_G220_M00240	CU_VARIANTS
    VT_G220_M00648	SAFETY_OPTIONS
    VT_G220_M00385	SUPPORTED_PROTOCOLS


  */

  // ################################################################################################################
  // Fix Values from SIZER
  // ################################################################################################################
  /**
  HMK_VOLTAGE_G220	HMK_VOLTAGE_G220		MLFB07
    VT_G220_M00014	FS_VOLT_POW_IPX
  x	VT_G220_M00017	MLFB_7_VOLTAGE
    VT_G220_M00123	POWER_STACK_RATED_DATA
    VT_G220_M00150	RATED_INPUT_POWER
    VT_G220_M00238	TOPOLOGY_VOLTAGE
    VT_G220_M00661	VOLTAGE_DEPENDENT_DATA
    VT_G220_M00248	TOPOLOGY_VOLTAGE_RATED_POWER
    VT_G220_M00325	MOTOR_CABLE_LENGTH
    VT_G220_M00574	ACCESSORY_BRAKING_RESISTOR
    VT_G220_M00695	ACCESSORY_DU_DT_FILTER
    VT_G220_M00503/504	RATED_POWER_VOLTAGE_DEPENDENT_DATA
    VT_G220_M00496	IEC_CIRCUIT_BREAKER
    VT_G220_M00383	ENERGY_EFFICIENCY_DATA
    VT_G220_M00645	IEC_MOTOR_STARTER_PROTECTORS
    VT_G220_M00618	IEC_SEMICONDUCTOR_FUSES
    VT_G220_M00613	IEC_STANDARD_FUSES
    VT_G220_M00395	VOLTAGE_BY_MOTOR_STANDARD
    VT_G220_M00400	UL_CSA_SEMICONDUCTOR_FUSES
    VT_G220_M00401	UL_CSA_TYPE_E_COMBINATION_MOTOR_CONTROLL
    VT_G220_M00403	UL_CSA_CIRCUIT_BREAKER
    VT_G220_M00404	UL_CSA_NON_SEMICONDUCTOR_FUSES

  HMK_RATED_POWER_G220		Bemessungsleistung		MLFB11+12
    VT_G220_M00014	FS_VOLT_POW_IPX
    VT_G220_M00123	POWER_STACK_RATED_DATA
    VT_G220_M00150	RATED_INPUT_POWER
    VT_G220_M00248	TOPOLOGY_VOLTAGE_RATED_POWER
    VT_G220_M00574	ACCESSORY_BRAKING_RESISTOR
    VT_G220_M00695	ACCESSORY_DU_DT_FILTER
  x	VT_G220_M00563	MLFB_11_12_RATED_POWER
    VT_G220_M00373	RATED_POWER_VOLTAGE_DEPENDENT_DATA
    VT_G220_M00378	IEC_CIRCUIT_BREAKER
    VT_G220_M00383	ENERGY_EFFICIENCY_DATA
    VT_G220_M00645	IEC_MOTOR_STARTER_PROTECTORS
    VT_G220_M00618	IEC_SEMICONDUCTOR_FUSES
    VT_G220_M00613	IEC_STANDARD_FUSES
    VT_G220_M00400	UL_CSA_SEMICONDUCTOR_FUSES
    VT_G220_M00401	UL_CSA_TYPE_E_COMBINATION_MOTOR_CONTROLL
    VT_G220_M00403	UL_CSA_CIRCUIT_BREAKER
    VT_G220_M00404	UL_CSA_NON_SEMICONDUCTOR_FUSES

  HMK_TOPOLOGY_G220			Topologie				MLFB08
    VT_G220_M00025	PRODUCT_TYPE
    VT_G220_M00123	POWER_STACK_RATED_DATA
    VT_G220_M00238	TOPOLOGY_VOLTAGE
    VT_G220_M00248	TOPOLOGY_VOLTAGE_RATED_POWER
    VT_G220_M00643	FS_VOLT_POW_IPX exteded
    VT_G220_M00357	HARMONIC_COMPONENTS
  x	VT_G220_M00651	MLFB_8_DRIVE_TOPOLOGY
    VT_G220_M00383	ENERGY_EFFICIENCY_DATA
	
  PMD_ACJ913_001_000_G220		Baugröße des Umrichters
    VT_G220_M00643	FS_VOLT_POW_IPX exteded
	
  HMK_FRAMESIZE_G220			HMK_FRAMESIZE_G220
    VT_G220_M00013	FRAMESIZE_GROUP_DEFINITION
    VT_G220_M00417	FRAMESIZE_DEPENDENT_DATA
    VT_G220_M00345	DIMENSIONS
    VT_G220_M00361	DIMENSION_DEPTH_
    VT_G220_M00643	FS_VOLT_POW_IPX exteded
    
  */
  // ################################################################################################################
  // Motornorm	HMK_MOTORNORM_G220
  // ################################################################################################################
  /*
	
  */
  var HMK_MOTORNORM_G220 = ECL_GetValue("HMK_MOTORNORM_G220");

  if (HMK_MOTORNORM_G220 == "00002") {
    // IEC
    ECL_ActivateAttribute("HMK_RATED_POWER_G220");
    ECL_DeactivateAttribute("PMD_ACU384_001_000_G220_X");
  } else {
    ECL_DeactivateAttribute("HMK_RATED_POWER_G220");
    ECL_ActivateAttribute("PMD_ACU384_001_000_G220_X");
  }

  // ################################################################################################################
  // HMK_UEBERLAST_1011270	Überlastfähigkeit hohe Überlast
  // ################################################################################################################
  /**	
  Rated power is passed by SIZER, without context parameter a reconstruction of overload is not possible
  */
  ECL_DisableAttribute("HMK_UEBERLAST_1011270");
  ECL_DisableAttribute("CB_HMK_UEBERLAST_1011270");
  ECL_HideAttribute("HMK_UEBERLAST_1011270");
  ECL_HideAttribute("CB_HMK_UEBERLAST_1011270");
  // ################################################################################################################

  // ################################################################################################################
  // PMD_ABJ176_001_000_G220	Schutzart IP				MLFB09
  // ################################################################################################################
  /**	
  PMD_ABM455_001_000_G220	Schutzart NEMA
    VT_G220_M00564	ENCLOSURE_VARIANTS
	
  HMK_SCHUTZART_1011410	Schutzart			fix from SIZER / SeriesID
    VT_G220_M00564	ENCLOSURE_VARIANTS
	
  PMD_ABJ176_001_000_G220	Schutzart IP
    VT_G220_M00014	FS_VOLT_POW_IPX
    VT_G220_M00026	PROTECTION_TYPE_DEPENDENT_DATA
    VT_G220_M00100	COOLING
    VT_G220_M00417	FRAMESIZE_DEPENDENT_DATA
    VT_G220_M00345	DIMENSIONS
    VT_G220_M00680	ENVIRONMENTAL_CONDITIONS
    VT_G220_M00574	ACCESSORY_BRAKING_RESISTOR
    VT_G220_M00358	LINE_CABLE_DATA
    VT_G220_M00361	DIMENSION_DEPTH_
    VT_G220_M00564	ENCLOSURE_VARIANTS
    VT_G220_M00363	MOTOR_CABLE_DATA
    VT_G220_M00383	ENERGY_EFFICIENCY_DATA
    VT_G220_M00388	IP55_PANEL_MOUNTING_FRAME_5.5“
    VT_G220_M00393	SDIPRO_IP55
	
  MLFB09
    VT_G220_M00158	TC_MAPPING_MLFB09
    VT_G220_M00564	ENCLOSURE_VARIANTS

  */
  // ################################################################################################################

  // ################################################################################################################
  // HMK_REP_SWITCH__G220  Reparaturschalter / repair switch				MLFB09
  // ################################################################################################################
  /* VT_G220_M00564	ENCLOSURE_VARIANTS
  //old 	HMK_SCHUTZART_1011410	PMD_ABJ176_001_000_G220	PMD_ABM455_001_000_G220	MLFB09_G220	PMD_ABU539_001_000_G220	HMK_REP_SWITCH__G220
  //new  HMK_SCHUTZART_1011410 PMD_ABJ176_001_000_G220 PMD_ABM455_001_000_G220 PMD_ABY931_001_000_G220 MLFB09_G220 HMK_PROTECTION_G220 HMK_REP_SWITCH__G220

  // HMK_PROTECTION kein Vorkommen außerhalb
*/
  var PMD_ABJ176_001_000_G220 = ECL_GetValue("PMD_ABJ176_001_000_G220");
  var PMD_ABM455_001_000_G220 = ECL_GetValue("PMD_ABM455_001_000_G220");

  var sTable = "VT_G220_M00564" + sDB_Suffix;
  var sSQL =
    "SELECT DISTINCT HMK_REP_SWITCH__G220 FROM " +
    sTable +
    " WHERE " +
    "HMK_SCHUTZART_1011410 = '" +
    HMK_SCHUTZART_1011410 +
    "' AND " +
    "PMD_ABJ176_001_000_G220 = '" +
    PMD_ABJ176_001_000_G220 +
    "' AND " +
    "PMD_ABM455_001_000_G220 = '" +
    PMD_ABM455_001_000_G220 +
    "' AND " +
    "HMK_REP_SWITCH__G220 = 'T';";

  var aResult = GetDBDataSetEXT(sSQL);

  if (aResult && aResult.length > 0) {
    ECL_EnableAttribute("CB_HMK_REP_SWITCH_G220");
  } else {
    ECL_DeselectAttribute("CB_HMK_REP_SWITCH_G220");
    ECL_DisableAttribute("CB_HMK_REP_SWITCH_G220");
  }

  //VT_G220_M00481	MTBF			todo?
  /*
    PMD_ABJ176_001_000_G220	Schutzart IP
    PMD_ACM763_001_000_1011530	MTBF / bei 55 °C
    PMD_ACJ913_001_000_G220	Baugröße / des Umrichters
    HMK_VOLTAGE_G220	HMK_VOLTAGE_G220
    HMK_TOPOLOGY_G220	HMK_TOPOLOGY_G220
    HMK_REP_SWITCH__G220	Wartungsschalter
    HMK_EMC_TYPE_G220	EMC Class
  */
  // ################################################################################################################

  // ################################################################################################################
  // PMD_ABY931_001_000_G220	Widerstandsfähigkeit / gegen chemisch aktive Stoffe / während Betrieb
  // ################################################################################################################
  /**	Edit 06/2024 replaced with PMD_ABY931_001_000_G220
   * 
  IP20 AND IP55 ==> 3C2 only (VT599)

  VT_G220_M00564	ENCLOSURE_VARIANTS
  //old 	HMK_SCHUTZART_1011410	PMD_ABJ176_001_000_G220	PMD_ABM455_001_000_G220	MLFB09_G220	PMD_ABU539_001_000_G220	HMK_REP_SWITCH__G220
  //new  HMK_SCHUTZART_1011410 PMD_ABJ176_001_000_G220 PMD_ABM455_001_000_G220 PMD_ABY931_001_000_G220 MLFB09_G220 HMK_PROTECTION_G220 HMK_REP_SWITCH__G220
*/
  var sTargetAttribute = "PMD_ABY931_001_000_G220";

  var HMK_REP_SWITCH__G220 = "F";
  if (ECL_ValueSelected("CB_HMK_REP_SWITCH_G220", "T")) {
    HMK_REP_SWITCH__G220 = "T";
  }
  
  var sTable = "VT_G220_M00564" + sDB_Suffix;
  var sWhere =
    "HMK_SCHUTZART_1011410 = '" +
    HMK_SCHUTZART_1011410 +
    "' AND " +
    "PMD_ABJ176_001_000_G220 = '" +
    PMD_ABJ176_001_000_G220 +
    "' AND " +
    "PMD_ABM455_001_000_G220 = '" +
    PMD_ABM455_001_000_G220 +
    "' AND " +
    "HMK_REP_SWITCH__G220 = '" +
    HMK_REP_SWITCH__G220 +
    "';";

  var sStatus = SetAttributeLogic1st(sTable, sTargetAttribute, sWhere);

  if (sStatus == "Error") {
    strError = "DICT1_ERR_G220___PL_STD_ENVIRONMENT_COND";
    return strError;
  }
  // ################################################################################################################

  // Set MLFB09

  var PMD_ABY931_001_000_G220 = ECL_GetValue("PMD_ABY931_001_000_G220");

  var sTable = "VT_G220_M00564" + sDB_Suffix;
  var sSQL =
    "SELECT MLFB09_G220 FROM " +
    sTable +
    " WHERE " +
    "PMD_ABJ176_001_000_G220 = '" +
    PMD_ABJ176_001_000_G220 +
    "' AND " +
    "PMD_ABY931_001_000_G220 = '" +
    PMD_ABY931_001_000_G220 +
    "' AND " +
    "HMK_REP_SWITCH__G220 = '" +
    HMK_REP_SWITCH__G220 +
    "';";

  var aResult = GetDBDataSetEXT(sSQL);
  if (aResult.length > 0) {
    MLFB09_G220 = aResult[0].MLFB09_G220;

    sMLFB = replaceAt(sMLFB, 8, MLFB09_G220);
    ECL_SetValue("ECSI_MLFB", sMLFB);
  } else {
    strError = "DICT1_ERR_G220___PL_MLFB09";
    return strError;
  }
  // ################################################################################################################

  // ################################################################################################################
  // HMK_HW_OPTION_G220	Hardware Option				MLFB10
  // ################################################################################################################
  //var sTargetAttribute = "HMK_HW_OPTION_G220";
  /**
  HMK_HW_OPTION_G220
  VT_G220_M00039	HW_CONFIGURATION_VARIANTS
    MLFB10_G220	Segment Merkmal MLFB10_G220
    HMK_HW_OPTION_G220	HMK_HW_OPTION_G220

  Logic is missing

  */
  //var test = ECL_GetAllActiveAttributeValues("HMK_HW_OPTION_G220");

  // work around manual logic
  // if IP 55 selectable (todo w/o also???)
  // if IP20 w/o only
  if (PMD_ABJ176_001_000_G220 == "Z0012") {
    //IP20
    ECL_DeactivateAllAttributeValues("HMK_HW_OPTION_G220");
    ECL_ActivateValue("HMK_HW_OPTION_G220", "00003"); //w/o
    ECL_SelectValue("HMK_HW_OPTION_G220", "00003"); //w/o
  } else if (PMD_ABJ176_001_000_G220 == "Z0003") {
    //IP55
    ECL_ActivateAllAttributeValues("HMK_HW_OPTION_G220");
  }
  var HMK_HW_OPTION_G220 = ECL_GetValue("HMK_HW_OPTION_G220");

  var sTable = "VT_G220_M00039" + sDB_Suffix;
  var sSQL = "SELECT MLFB10_G220 FROM " + sTable + " WHERE " + "HMK_HW_OPTION_G220 = '" + HMK_HW_OPTION_G220 + "';";

  var aResult = GetDBDataSetEXT(sSQL);
  if (aResult.length > 0) {
    MLFB10_G220 = aResult[0].MLFB10_G220;
    sMLFB = replaceAt(sMLFB, 9, MLFB10_G220);
    ECL_SetValue("ECSI_MLFB", sMLFB);
  } else {
    strError = "DICT1_ERR_G220___PL_MLFB10";
    return strError;
  }
  // ################################################################################################################

  // ################################################################################################################
  // HMK_EMC_TYPE_G220	HMK_EMC_TYPE_G220				MLFB13
  // ################################################################################################################
  var sTargetAttribute = "HMK_EMC_TYPE_G220";
  /**
  HMK_EMC_TYPE_G220		HMK_EMC_TYPE_G220				MLFB13
	
  nn PMD_ABY445_001_000_G220	Ausführung des Netzfilters

  VT_G220_M00036	EMC_FILTER_VARIANTS
    PMD_ABY445_001_000_G220	Ausführung des Netzfilters
    PMD_ABY444_001_000_G220	Produktbestandt.../Netzfilter
    PMD_ABP321_001_000_G220	Installationsum.../A
    PMD_ABP322_001_000_G220	Installationsum.../B
    MLFB13_G220	Segment Merkmal MLFB13_G220
    HMK_EMC_TYPE_G220	HMK_EMC_TYPE_G220

  nn VT_G220_M00325	MOTOR_CABLE_LENGTH
  nn VT_G220_M00383	ENERGY_EFFICIENCY_DATA

  //VT_G220_M00481	MTBF			todo
    PMD_ABJ176_001_000_G220	Schutzart IP
    PMD_ACM763_001_000_1011530	MTBF / bei 55 °C
    PMD_ACJ913_001_000_G220	Baugröße / des Umrichters
    HMK_VOLTAGE_G220	HMK_VOLTAGE_G220
    HMK_TOPOLOGY_G220	HMK_TOPOLOGY_G220
    HMK_REP_SWITCH__G220	Wartungsschalter
    HMK_EMC_TYPE_G220	EMC Class
  */

  // Übertrag MLFB13-Condition to HMK_EMC_TYPE_G220
  var sTargetAttribute = "HMK_EMC_TYPE_G220";
  var sRefAttribute = "MLFB13_G220";

  var sStatus = SetAttributeLogicFromMLFB(sTargetAttribute, sRefAttribute, "VT_G220_M00036" + sDB_Suffix);

  if (sStatus == "Error") {
    strError = "DICT1_ERR_G220___PL_MLFB13_TO_EMC_TYPE";
    return strError;
  }

  // ################################################################################################################
  // Update MLFB13
  var HMK_EMC_TYPE_G220 = ECL_GetValue("HMK_EMC_TYPE_G220");

  var sTable = "VT_G220_M00036" + sDB_Suffix;
  var sSQL = "SELECT * FROM " + sTable + " WHERE " + "HMK_EMC_TYPE_G220 = '" + HMK_EMC_TYPE_G220 + "';";

  var aResult = GetDBDataSetEXT(sSQL);
  if (aResult.length > 0) {
    MLFB13_G220 = aResult[0].MLFB13_G220;
    var PMD_ABY445_001_000_G220 = aResult[0].PMD_ABY445_001_000_G220;

    ECL_DeactivateAllAttributeValues("PMD_ABY445_001_000_G220");
    ECL_ActivateValue("PMD_ABY445_001_000_G220", PMD_ABY445_001_000_G220);
    ECL_SelectValue("PMD_ABY445_001_000_G220", PMD_ABY445_001_000_G220);

    sMLFB = replaceAt(sMLFB, 12, MLFB13_G220);
    ECL_SetValue("ECSI_MLFB", sMLFB);
  } else {
    strError = "DICT1_ERR_G220___PL_MLFB13";
    return strError;
  }

  // ################################################################################################################

  // CU
  // ################################################################################################################
  // PMD_ABY321_001_000_G220	Protokoll / für Bussystem / für integrierte Schnittstelle
  // ################################################################################################################
  //var sTargetAttribute = "PMD_ABY321_001_000_G220";
  /**

  */

  // ################################################################################################################

  // ################################################################################################################
  // VT_G220_M00422	HEIGHT			HMK_HEIGHT_EXT_1011270
  // ################################################################################################################
  /* 
  VT_G220_M00422	HEIGHT
    * PMD_ABW185_001_000_G220	einzuhaltender Abstand / oben
    * PMD_ACT524_001_000_G220_X	Höhe /...Schirmblech
    * PMD_ABJ182_001_000_G220	Höhe
    PMD_ABJ176_001_000_G220	Schutzart IP
    * PMD_ACT523_001_000_G220_X	Höhe /...Schirmblech
    * PMD_ACT526_001_000_1011270	einzuhaltender.../oben
    PMD_ACJ913_001_000_G220	Baugröße / des Umrichters
    * PMD_ACT552_001_000_1011270	einzuhaltender.../unten
    * PMD_ABW188_001_000_G220	einzuhaltender Abstand / unten
    * PMD_ACF456_001_000_1011270	Höhe [in]
    HMK_HEIGHT_EXT_1011270	HMK_HEIGHT_EXT_G220
  */
  var bHeightExtendPossible = false;

  var sTargetAttribute = "HMK_HEIGHT_EXT_1011270";
  var sTable = "VT_G220_M00422" + sDB_Suffix;
  var sSQL =
    "SELECT HMK_HEIGHT_EXT_1011270 FROM " +
    sTable +
    " WHERE " +
    "HMK_HEIGHT_EXT_1011270 = 'T' AND " +
    "PMD_ABJ176_001_000_G220 = '" +
    PMD_ABJ176_001_000_G220 +
    "' AND " +
    "PMD_ACJ913_001_000_G220 = '" +
    PMD_ACJ913_001_000_G220 +
    "';";

  var aResult = GetDBDataSetEXT(sSQL);
  if (aResult.length > 0) {
    bHeightExtendPossible = true;
    var sWhereHeightExt = "(HMK_HEIGHT_EXT_1011270 = 'T' OR HMK_HEIGHT_EXT_1011270 = 'F')";
  } else {
    var sWhereHeightExt = "HMK_HEIGHT_EXT_1011270 = 'F'";
  }
  // ################################################################################################################

  // ################################################################################################################
  // VT_G220_M00443	OPTION_MODULE_COMBINATIONS
  // ################################################################################################################
  /* combination of option modules (OM)
    if no OM is selected, MLFB14 = A 
    if more the one OM is selected, MLFB14 = A + short option KAG T01 (DQ), T04 (IIOT), T05 (SMT)
    if exact one OM is selected:
      MLFB14 = B	DQ
      MLFB14 = E	IIOT
      MLFB14 = F	SMT
  VT_G220_M00443	OPTION_MODULE_COMBINATIONS
    HMK_OM_SMT_1011270		HMK_OM_SMT_G220
    HMK_OM_DQ_1011270		HMK_OM_DQ_G220
    HMK_OM_IIOT_1011270		HMK_OM_IIOT_G220
    HMK_SC_OM_SMT_1011270	HMK_SC_OM_SMT_G220
    HMK_SC_OM_DQ_G220		HMK_SC_OM_DQ_G220
    HMK_SC_OM_IIOT_G220		HMK_SC_OM_IIOT_G220
    MLFB14_G220				Segment Merkmal MLFB14_G220

  HMK_MOD_CAPACITY__G220 Modulkapazität (PU)	(Edit)
 */

   var iModulCapacityFree = 2;

  if(iModulCapacityFree >= 0){
    if (ECL_ValueSelected("CB_HMK_SC_OM_DQ_G220", "T")) {
      iModulCapacityFree = iModulCapacityFree - 1;
    }
    if (ECL_ValueSelected("CB_HMK_SC_OM_SMT_G220", "T")) {
      iModulCapacityFree = iModulCapacityFree - 1;
    }
    if (ECL_ValueSelected("CB_HMK_SC_OM_IIOT_G220", "T")) {
      iModulCapacityFree = iModulCapacityFree - 1;
    }
  }

  if(iModulCapacityFree == 0) {
    if(!ECL_ValueSelected("CB_HMK_SC_OM_SMT_G220", "T")){
      ECL_DisableAttribute("CB_HMK_SC_OM_SMT_G220");
    }
    if(!ECL_ValueSelected("CB_HMK_SC_OM_DQ_G220", "T")){
      ECL_DisableAttribute("CB_HMK_SC_OM_DQ_G220");
    }
    if(!ECL_ValueSelected("CB_HMK_SC_OM_IIOT_G220", "T")){
      ECL_DisableAttribute("CB_HMK_SC_OM_IIOT_G220");
    }
  }

  // ################################################################################################################
  // HMK_OM_SMT_1011270	Optionsmodul SMT						isCheckbox		CB_HMK_SC_OM_SMT_G220
  // ################################################################################################################
  var sTargetAttribute = "HMK_OM_SMT_1011270";
  /** KAG T05 or MLFB14 = F
  HMK_OM_SMT_1011270		Optionsmodul SMT
  00001	T01 Optionsmodul DRIVE-CLiQ
  00002	-


  KAG T05

  HMK_SC_OM_SMT_1011270	T05 Optionsmodul SMT		(CB) CB_HMK_SC_OM_SMT_G220
	
  VT_G220_M00443	OPTION_MODULE_COMBINATIONS
    HMK_OM_SMT_1011270	Option Module SMT
    HMK_OM_DQ_1011270	Option Module DRIVE-CLiQ
    HMK_OM_IIOT_1011270	Option Module IIoT
    HMK_SC_OM_SMT_1011270	HMK_SC_OM_SMT_G220
    HMK_SC_OM_DQ_G220	HMK_SC_OM_DQ_G220
    PMD_ACT536_001_000_1011410	aufgenommener Strom / aus externer Versorgungsspannung / maximal
    MLFB14_G220	Segment Merkmal MLFB14_G220
    HMK_SC_OM_IIOT_G220	HMK_SC_OM_IIOT_G220

  VT_G220_M00647	ATEX_EXTENSION_MODULE
    HMK_OM_SMT_1011270	HMK_OM_SMT_G220
    PMD_ACV386_001_000_1011270	Produktfunktion / Safe Motor Temperature (SMT)
    HMK_MH_OM_ATEX_1011270_X	HMK_MH_OM_ATEX_G220
    PMD_ACU730_001_000_1011270	Eignungsnachwei...osionsschutz
    PMD_ACT469_001_000_1011270	Ausführung /.../Anmerkung

  VT_G220_M00488	OPTMOD_MECH_COMP
    HMK_OM_SMT_1011270	OM-SMT /...rtemperatur)
    HMK_FRAMESIZE_G220	HMK_FRAMESIZE_G220
    HMK_OM_DQ_1011270	OM-DQ (Drive CLiQ)
    HMK_OM_IIOT_1011270	Option Module IIoT
    TC_WEIGHT_OPTIONEN_1011410	TC_WEIGHT_OPTIONEN_G220
    HMK_HEIGHT_EXT_1011270	HMK_HEIGHT_EXT_G220
  	
  HMK_MH_OM_ATEX_1011270_X ==> VT_G220_S00175	HMK_MH_OM_ATEX_1011270
    HMK_MH_OM_ATEX_1011270		HMK_MH_OM_ATEX_G220						
    HMK_MH_OM_ATEX_1011270_X	HMK_MH_OM_ATEX_G220
	
  ==> module height = 3
  */
  if (sECSI_CX_SafetyFunctions && sECSI_CX_SafetyFunctions !== "" && sECSI_CX_SafetyFunctions.indexOf("15") > -1) {
    //|| (!ECL_AttributeEnabled("CB_HMK_SC_OM_SMT_G220"))

    ECL_SelectValue("CB_HMK_SC_OM_SMT_G220", "T");
    ECL_DisableAttribute("CB_HMK_SC_OM_SMT_G220");
  } else {
    // VT 488
    var HMK_OM_DQ_1011270 = ECL_GetValue("HMK_OM_DQ_1011270");
    var HMK_OM_IIOT_1011270 = "00002"; //ECL_GetValue("HMK_OM_IIOT_1011270");
    var sTable = "VT_G220_M00488" + sDB_Suffix;
    var sWhere =
      "HMK_FRAMESIZE_G220 = '" +
      HMK_FRAMESIZE_G220 +
      "' AND " +
      "HMK_OM_DQ_1011270 = '" +
      HMK_OM_DQ_1011270 +
      "' AND " +
      "HMK_OM_IIOT_1011270 = '" +
      HMK_OM_IIOT_1011270 +
      "' AND " +
      sWhereHeightExt +
      ";";

    var sStatus = SetAttributeLogic1st(sTable, sTargetAttribute, sWhere);

    if (sStatus == "Error") {
      strError = "DICT1_ERR_G220___PL_OM_SMT";
      return strError;
    }

    /*if (bT05 || iModulCapacityFree >= 3) {
      ECL_EnableAttribute("CB_HMK_SC_OM_SMT_G220");
    } else {
      ECL_DeselectAttribute("CB_HMK_SC_OM_SMT_G220");
      ECL_DisableAttribute("CB_HMK_SC_OM_SMT_G220");
    }*/
  }
  var HMK_OM_SMT_1011270 = "00002";
  if (ECL_ValueSelected("CB_HMK_SC_OM_SMT_G220", "T")) {
    var HMK_OM_SMT_1011270 = "00001";
  }
  ECL_SelectValue("HMK_OM_SMT_1011270", HMK_OM_SMT_1011270);

  // ################################################################################################################

  // ################################################################################################################
  // HMK_OM_DQ_1011270	Optionsmodul DRIVE-CLiQ					isCheckbox		CB_HMK_SC_OM_DQ_G220
  // ################################################################################################################
  var sTargetAttribute = "HMK_OM_DQ_1011270";
  /**	KAG T01 or MLFB14 = B
  HMK_OM_DQ_1011270	Optionsmodul DRIVE-CLiQ
	
  T01

  HMK_SC_OM_DQ_G220	T01 Optionsmodul DRIVE-CLiQ		(CB) CB_HMK_SC_OM_DQ_G220

  VT_G220_M00443	OPTION_MODULE_COMBINATIONS
  VT_G220_M00355	DRIVE_CLIQ_EXTENSION_MODULE
    HMK_OM_DQ_1011270		HMK_OM_DQ_G220
    HMK_DQ_SUPPORTED__G220	Flag: DQ unterstützt
    HMK_MH_OM_DC_1011270_X	HMK_MH_OM_DC_G220
    PMD_ACJ914_001_000_G220	Protokoll /...ommunikation

  HMK_MH_OM_DC_1011270_X:
  VT_G220_S00192	HMK_MH_OM_DC_1011270
    HMK_MH_OM_DC_1011270	HMK_MH_OM_DC_G220
    HMK_MH_OM_DC_1011270_X	HMK_MH_OM_DC_G220

  module height = 2

  Flag 
  HMK_DQ_SUPPORTED__G220	Flag: DQ unterstützt

  */
  // VT 488
  var HMK_OM_SMT_1011270 = ECL_GetValue("HMK_OM_SMT_1011270");
  var HMK_OM_IIOT_1011270 = "00002"; //ECL_GetValue("HMK_OM_IIOT_1011270");
  var sTable = "VT_G220_M00488" + sDB_Suffix;
  var sWhere =
    "HMK_FRAMESIZE_G220 = '" +
    HMK_FRAMESIZE_G220 +
    "' AND " +
    "HMK_OM_SMT_1011270 = '" +
    HMK_OM_SMT_1011270 +
    "' AND " +
    "HMK_OM_IIOT_1011270 = '" +
    HMK_OM_IIOT_1011270 +
    "' AND " +
    sWhereHeightExt +
    ";";

  var sStatus = SetAttributeLogic1st(sTable, sTargetAttribute, sWhere);

  if (sStatus == "Error") {
    strError = "DICT1_ERR_G220___PL_OM_DQ";
    return strError;
  }

  /*if (bT01 || iModulCapacityFree >= 2) {
    ECL_EnableAttribute("CB_HMK_SC_OM_DQ_G220");
  } else {
    ECL_DeselectAttribute("CB_HMK_SC_OM_DQ_G220");
    ECL_DisableAttribute("CB_HMK_SC_OM_DQ_G220");
  }*/

  var HMK_OM_DQ_1011270 = "00002";
  if (ECL_ValueSelected("CB_HMK_SC_OM_DQ_G220", "T")) {
    var HMK_OM_DQ_1011270 = "00001";
    ECL_SelectValue("HMK_DQ_SUPPORTED__G220", "T");
  } else {
    ECL_SelectValue("HMK_DQ_SUPPORTED__G220", "F");
  }
  ECL_SelectValue("HMK_OM_DQ_1011270", HMK_OM_DQ_1011270);
  // ################################################################################################################

  // ################################################################################################################
  // HMK_OM_IIOT_1011270	Optionsmodul IIoT						isCheckbox		CB_HMK_SC_OM_IIOT_G220
  // ################################################################################################################
  // In Update 10/2023 nicht mehr eingeblendet!
  var sTargetAttribute = "HMK_OM_IIOT_1011270";
  /**	KAG T04 or MLFB14 = E
  HMK_OM_IIOT_1011270	Optionsmodul IIoT
	
  HMK_SC_OM_IIOT_G220	T04 Optionsmodul IIoT			(CB) CB_HMK_SC_OM_IIOT_G220

  VT_G220_M00443	OPTION_MODULE_COMBINATIONS
	
  VT_G220_M00167	IIOT_EXTENSION_MODULE
    HMK_OM_IIOT_1011270	HMK_OM_IIOT_G220
    HMK_MH_OM_IIOT_G220_X	IIoT module height

  HMK_OM_IIOT_1011270 ==> VT_G220_S00166	HMK_MH_OM_IIOT_G220
    HMK_MH_OM_IIOT_G220		IIoT module height
    HMK_MH_OM_IIOT_G220_X	IIoT module height

  ==> module height = 3
  */
  // VT 488
  var HMK_OM_SMT_1011270 = ECL_GetValue("HMK_OM_SMT_1011270");
  var HMK_OM_DQ_1011270 = ECL_GetValue("HMK_OM_DQ_1011270");
  var sTable = "VT_G220_M00488" + sDB_Suffix;
  var sWhere =
    "HMK_FRAMESIZE_G220 = '" +
    HMK_FRAMESIZE_G220 +
    "' AND " +
    "HMK_OM_SMT_1011270 = '" +
    HMK_OM_SMT_1011270 +
    "' AND " +
    "HMK_OM_DQ_1011270 = '" +
    HMK_OM_DQ_1011270 +
    "' AND " +
    sWhereHeightExt +
    ";";

  var sStatus = SetAttributeLogic1st(sTable, sTargetAttribute, sWhere);

  if (sStatus == "Error") {
    strError = "DICT1_ERR_G220___PL_OM_IIOT";
    return strError;
  }

  /*if (bT04 || iModulCapacityFree >= 3) {
    ECL_EnableAttribute("CB_HMK_SC_OM_IIOT_G220");
  } else {
    ECL_DeselectAttribute("CB_HMK_SC_OM_IIOT_G220");
    ECL_DisableAttribute("CB_HMK_SC_OM_IIOT_G220");
  }*/

  var HMK_OM_IIOT_1011270 = "00002";
  if (ECL_ValueSelected("CB_HMK_SC_OM_IIOT_G220", "T")) {
    var HMK_OM_IIOT_1011270 = "00001";
  }
  ECL_SelectValue("HMK_OM_IIOT_1011270", HMK_OM_IIOT_1011270);
  // ################################################################################################################
  // Set MLFB14
  /*VT_G220_M00443	OPTION_MODULE_COMBINATIONS
    HMK_OM_SMT_1011270		HMK_OM_SMT_G220
    HMK_OM_DQ_1011270		HMK_OM_DQ_G220
    HMK_OM_IIOT_1011270		HMK_OM_IIOT_G220
    HMK_SC_OM_SMT_1011270	HMK_SC_OM_SMT_G220
    HMK_SC_OM_DQ_G220		HMK_SC_OM_DQ_G220
    HMK_SC_OM_IIOT_G220		HMK_SC_OM_IIOT_G220
    MLFB14_G220				Segment Merkmal MLFB14_G220
  */
  var sTable = "VT_G220_M00443" + sDB_Suffix;
  var sSQL =
    "SELECT MLFB14_G220 FROM " +
    sTable +
    " WHERE " +
    "HMK_OM_SMT_1011270 = '" +
    HMK_OM_SMT_1011270 +
    "' AND " +
    "HMK_OM_DQ_1011270 = '" +
    HMK_OM_DQ_1011270 +
    "' AND " +
    "HMK_OM_IIOT_1011270 = '" +
    HMK_OM_IIOT_1011270 +
    "';";

  var aResult = GetDBDataSetEXT(sSQL);
  if (aResult.length > 0) {
    var MLFB14_G220 = aResult[0].MLFB14_G220;

    sMLFB = replaceAt(sMLFB, 13, MLFB14_G220);
    ECL_SetValue("ECSI_MLFB", sMLFB);
  } else {
    strError = "DICT1_ERR_G220___PL_MLFB14";
    return strError;
  }

  // ################################################################################################################
  // HMK_SAFETY_EXT_G220	HMK_SAFETY_EXT_G220
  // ################################################################################################################
  //var sTargetAttribute = "HMK_SAFETY_EXT_G220";
  /**

  */

  // ################################################################################################################

  // ZUBEHOER ZUBEHOER ZUBEHOER ZUBEHOER ZUBEHOER ZUBEHOER ZUBEHOER ZUBEHOER ZUBEHOER ZUBEHOER ZUBEHOER ZUBEHOER ZUBEHOER
  // ZUBEHOER ZUBEHOER ZUBEHOER ZUBEHOER ZUBEHOER ZUBEHOER ZUBEHOER ZUBEHOER ZUBEHOER ZUBEHOER ZUBEHOER ZUBEHOER ZUBEHOER
  // ZUBEHOER ZUBEHOER ZUBEHOER ZUBEHOER ZUBEHOER ZUBEHOER ZUBEHOER ZUBEHOER ZUBEHOER ZUBEHOER ZUBEHOER ZUBEHOER ZUBEHOER

  // ################################################################################################################
  // Speicherkarte			CB_MEMORYCARD_G220
  // ################################################################################################################
  /* 
  UI_MEMORYCARD_1011270	Speicherkarte mit SINAMICS Drive Software
    VT_G220_M00521	Speicherkarte einschraenken
      HMK_MEMORYCARD_1011270	UI_MEMORYCARD_1011270
  	
  HMK_MEMORYCARD_1011270	Speicherkarte
    VT_G220_M00457	MCARD_MEMORYCARD
      HMK_MCARD_FW_1011270	HMK_MEMORYCARD_1011270

    VT_G220_M00521	Speicherkarte einschraenken
	
  HMK_MCARD_FW_1011270
    VT_G220_M00673	FW_AND_LICENSES
      HMK_SDCARD_FM_MLFB_1011270	HMK_FW_OPTION_1011270	HMK_MCARD_FW_1011270	HMK_LICENSE_DOWNLOAD_1011270	HMK_H01_1011270	HMK_F01_1011270
    VT_G220_M00457	MCARD_MEMORYCARD
  	
  HMK_F01_1011270	F01 SINAMICS Safety Integrated Extended					CB_F01_G220
    VT_G220_M00673	FW_AND_LICENSES
      HMK_SDCARD_FM_MLFB_1011270	HMK_FW_OPTION_1011270	HMK_MCARD_FW_1011270	HMK_LICENSE_DOWNLOAD_1011270	HMK_H01_1011270	HMK_F01_1011270

  HMK_H01_1011270	H01 SINAMICS Motor Control Extended						CB_H01_G220
    VT_G220_M00673	FW_AND_LICENSES

  HMK_SDCARD_FM_MLFB_1011270
    VT_G220_M00673	FW_AND_LICENSES

  wenn F01 oder H01, anhaken

  6SL49700AA000AA0	jeweils optional mit F01, H01, F01+H01 -Z F01+H01
  6SL41700GC000AA0
  6SL41701GC000AA0
  6SL59700AA000AA0



  */
  ECL_EnableAttribute("CB_MEMORYCARD_G220");
  ECL_EnableAttribute("HMK_FIRMWARE_G220");
  ECL_EnableAttribute("CB_F01_G220");
  //ECL_EnableAttribute("CB_H01_G220");

  if (sECSI_CX_SafetyFunctions && sECSI_CX_SafetyFunctions !== "") {
    var aECSI_CX_SafetyFunctions = sECSI_CX_SafetyFunctions.split(";");

    var bExtendedRequired = false;

    // Context Satefy extended (F01) if SS1, SLS, SDI, SSM, SS1-a/SS1-r || no license nessesery for SS1-t (13)
    for (var i = 0; i < aECSI_CX_SafetyFunctions.length; i++) {
      if (
        aECSI_CX_SafetyFunctions[i] == "1" ||
        aECSI_CX_SafetyFunctions[i] == "2" ||
        aECSI_CX_SafetyFunctions[i] == "3" ||
        aECSI_CX_SafetyFunctions[i] == "4" ||
        aECSI_CX_SafetyFunctions[i] == "14"
      ) {
        bExtendedRequired = true;
        break;
      }
    }
    if (bExtendedRequired) {
      ECL_SelectValue("CB_F01_G220", "T");
      ECL_DisableAttribute("CB_F01_G220");
    } else {
      ECL_EnableAttribute("CB_F01_G220");
    }
  }

  if (ECL_ValueSelected("CB_F01_G220", "T") 
    || ECL_ValueSelected("CB_H01_G220", "T")
    || ECL_ValueSelected("CB_H80_G220", "T")
    || ECL_ValueSelected("CB_J03_G220", "T")
    || ECL_ValueSelected("CB_J04_G220", "T")
    || ECL_ValueSelected("CB_E01_G220", "T"))
  {
    ECL_SelectValue("CB_MEMORYCARD_G220", "T");
    ECL_SelectValue("HMK_FIRMWARE_G220", "VERSION_6_2");
    ECL_DisableAttribute("CB_MEMORYCARD_G220");
    ECL_DisableAttribute("HMK_FIRMWARE_G220");
  }

  // ################################################################################################################

  // ################################################################################################################
  // HMK_SMARTADP_1011270	Smart Adapter für WLAN-Zugang		CB_SMARTADP_G220
  // ################################################################################################################
  /*
  HMK_SMARTADP_1011270
    VT_G220_M00459	SMART_ADAPTER
      HMK_SMARTADP_1011270	HMK_SMARTADP_MLFB_1011270

  HMK_SMARTADP_MLFB_1011270		6SL49500AJ000AA0

  */

  // Disable SDI Pro 5.5 + door mounting kit when SDI Pro 5.5 selected
  if (ECL_ValueSelected("CB_PROPANEL_G220", "T")) {
    ECL_DeselectAttribute("CB_PROPANELPLUSDOOR_G220");
    ECL_DisableAttribute("CB_PROPANELPLUSDOOR_G220");
  }

   // Disable door mounting kit when handheld kit is selected
  if (ECL_ValueSelected("CB_PROPANELHANDHELD_G220", "T")) {
    ECL_DeselectAttribute("CB_PROPANELDOOR_G220");
    ECL_DisableAttribute("CB_PROPANELDOOR_G220");
  }

  // Disable handheld kit, SDI Pro 5.5 + Door and panel mounting frame when door mounting kit is selected
  if (ECL_ValueSelected("CB_PROPANELDOOR_G220", "T")) {
    ECL_DeselectAttribute("CB_PROPANELHANDHELD_G220");
    ECL_DisableAttribute("CB_PROPANELHANDHELD_G220");

    ECL_DeselectAttribute("CB_PROPANELPLUSDOOR_G220");
    ECL_DisableAttribute("CB_PROPANELPLUSDOOR_G220");

    ECL_DeselectAttribute("CB_PROPANELIP55_G220");
    ECL_DisableAttribute("CB_PROPANELIP55_G220");
  }

  // Disable everything else, when SDI Pro 5.5 + Door is selected
  if (ECL_ValueSelected("CB_PROPANELPLUSDOOR_G220", "T")) {
    ECL_DeselectAttribute("CB_PROPANEL_G220");
    ECL_DisableAttribute("CB_PROPANEL_G220");

    ECL_DeselectAttribute("CB_PROPANELHANDHELD_G220");
    ECL_DisableAttribute("CB_PROPANELHANDHELD_G220");

    ECL_DeselectAttribute("CB_PROPANELDOOR_G220");
    ECL_DisableAttribute("CB_PROPANELDOOR_G220");

    ECL_DeselectAttribute("CB_PROPANELIP55_G220");
    ECL_DisableAttribute("CB_PROPANELIP55_G220");
  }

  // Disable door mounting kit and SDI Pro 5.5 + Door when panel mounting frame is selected
  if (ECL_ValueSelected("CB_PROPANELIP55_G220", "T")) {
    ECL_DeselectAttribute("CB_PROPANELDOOR_G220");
    ECL_DisableAttribute("CB_PROPANELDOOR_G220");

    ECL_DeselectAttribute("CB_PROPANELPLUSDOOR_G220");
    ECL_DisableAttribute("CB_PROPANELPLUSDOOR_G220");
  }

  // Disable Panel mounting frame when not IP55 selected
  var PMD_ABJ176_001_000_G220 = ECL_GetValue("PMD_ABJ176_001_000_G220");
  if  (PMD_ABJ176_001_000_G220 !== "Z0003") {
    ECL_DeselectAttribute("CB_PROPANELIP55_G220");
    ECL_DisableAttribute("CB_PROPANELIP55_G220");
  }


  // ################################################################################################################

  // ################################################################################################################
  // HMK_SENSORMODULE_1011270	Sensor Module Cabinet-Mounted
  // ################################################################################################################
  /*
  VT_G220_M00514	Sensor Module Cabinet-Mounted
    HMK_SENSORMODULE_1011270	HMK_SENSORMODUL_MLFB_1011270
	
  00001	ohne
  00002	SMC20 – Sensor Module Cabinet-Mounted für Sin/cos-Geber
  00003	SMC30 – Sensor Module Cabinet-Mounted SMC30 für HTL/TTL-Geber

  HMK_SENSORMODUL_MLFB_1011270	Sensor Module Cabinet-Mounted MLFB
    6SL30550AA005BA3	SMC20	00002
    6SL30550AA005CA2	SMC30 	00003


  */

  // ################################################################################################################

  // ################################################################################################################
  // SINAMICS DRIVE-CLiQ Cable IP20	HMK_DQ_LEITUNG_1011270_X
  // ################################################################################################################
  /*  No DQ_Cable for Release 08/23024
  VT_G220_M00534	SINAMICS DRIVE-CLiQ Leitung IP20/IP20
    HMK_DQ_LEITUNG_1011270_X	HMK_DQ_LEITUNG_MLFB_1011270
    00001					          	6SL30604AA100AA0
    00002				          		6SL30604AW000AA0
    00003				          		6SL30604AF100AA0
    (.				          			6SL30604AA100AA0)
    .					            		OHNE		


  */

  // ################################################################################################################

  // ################################################################################################################
  // Verriegelung VT620: nur eine Netz-Komponente
  // ################################################################################################################
  // wenn eine Netzkomponente ausgewählt ist, werden die anderen disabled
  /*
  VT_G220_M00620	ONE_LINE_PW_COMPONENT
    HMK_MOTORNORM_G220	Motornorm
    A HMK_CB_GROUP_CAPTION_1011270	Leistungsschalter     IEC
    B HMK_CB_UL_G_CAPTION_1011270	Leistungsschalter       UL
    C HMK_MS_IEC_G_CAPTION_1011270	Motorschutzschalter   IEC
    D HMK_MS_UL_G_CAPTION_1011270	Kombinationsmot.../E    UL
    E HMK_SCFUSE_G_CAPTION_1011270	Halbleitersicherung   IEC
    F HMK_SCF_UL_G_CAPTION_1011270	Halbleitersicherung   UL
    G HMK_FUSE_G_CAPTION_1011270	Standardsicherung       nur IEC

  */
  var bAtLeastOneSelected = false;
  // A
  var HMK_CB_GROUP_CAPTION_1011270 = "F";
  var HMK_CB_UL_G_CAPTION_1011270 = "F";
  if (ECL_ValueSelected("CB_CIRCUIT_BREAKER_G220", "T") && HMK_MOTORNORM_G220 == "00002") {
    HMK_CB_GROUP_CAPTION_1011270 = "T";
    bAtLeastOneSelected = true;
  }
  // B
  else if (ECL_ValueSelected("CB_CIRCUIT_BREAKER_G220", "T") && HMK_MOTORNORM_G220 == "00001") {
    HMK_CB_UL_G_CAPTION_1011270 = "T";
    bAtLeastOneSelected = true;
  }
  //C
  var HMK_MS_IEC_G_CAPTION_1011270 = "F";
  if (ECL_ValueSelected("CB_MS_G220", "T")) {
    HMK_MS_IEC_G_CAPTION_1011270 = "T";
    bAtLeastOneSelected = true;
  }
  // D
  var HMK_MS_UL_G_CAPTION_1011270 = "F";
  if (ECL_ValueSelected("CB_MS_UL_G220", "T")) {
    HMK_MS_UL_G_CAPTION_1011270 = "T";
    bAtLeastOneSelected = true;
  }
  // E
  var HMK_SCFUSE_G_CAPTION_1011270 = "F";
  if (ECL_ValueSelected("CB_SC_FUSE_G220", "T") && HMK_MOTORNORM_G220 == "00002") {
    HMK_SCFUSE_G_CAPTION_1011270 = "T";
    bAtLeastOneSelected = true;
  }
  // F
  var HMK_SCF_UL_G_CAPTION_1011270 = "F";
  if (ECL_ValueSelected("CB_SC_FUSE_G220", "T") && HMK_MOTORNORM_G220 == "00001") {
    HMK_SCF_UL_G_CAPTION_1011270 = "T";
    bAtLeastOneSelected = true;
  }
  // G
  var HMK_FUSE_G_CAPTION_1011270 = "F";
  if (ECL_ValueSelected("CB_STD_FUSE_G220", "T")) {
    HMK_FUSE_G_CAPTION_1011270 = "T";
    bAtLeastOneSelected = true;
  }
  if (bAtLeastOneSelected) {
    var sTable = "VT_G220_M00620" + sDB_Suffix;
    var sSQL_ONE_LINE_PW_COMPONENT =
      "SELECT * FROM " +
      sTable +
      " WHERE " +
      "HMK_CB_GROUP_CAPTION_1011270 = '" +
      HMK_CB_GROUP_CAPTION_1011270 +
      "' AND " +
      "HMK_CB_UL_G_CAPTION_1011270 = '" +
      HMK_CB_UL_G_CAPTION_1011270 +
      "' AND " +
      "HMK_MS_IEC_G_CAPTION_1011270 = '" +
      HMK_MS_IEC_G_CAPTION_1011270 +
      "' AND " +
      "HMK_MS_UL_G_CAPTION_1011270 = '" +
      HMK_MS_UL_G_CAPTION_1011270 +
      "' AND " +
      "HMK_SCFUSE_G_CAPTION_1011270 = '" +
      HMK_SCFUSE_G_CAPTION_1011270 +
      "' AND " +
      "HMK_SCF_UL_G_CAPTION_1011270 = '" +
      HMK_SCF_UL_G_CAPTION_1011270 +
      "' AND " +
      "HMK_FUSE_G_CAPTION_1011270 = '" +
      HMK_FUSE_G_CAPTION_1011270 +
      "' AND " +
      "HMK_MOTORNORM_G220 = '" +
      HMK_MOTORNORM_G220 +
      "';";
    var aResult = GetDBDataSetEXT(sSQL_ONE_LINE_PW_COMPONENT);

    var bHMK_CB_GROUP_CAPTION_1011270 = false;
    var bHMK_CB_UL_G_CAPTION_1011270 = false;
    var bHMK_MS_IEC_G_CAPTION_1011270 = false;
    var bHMK_MS_UL_G_CAPTION_1011270 = false;
    var bHMK_SCFUSE_G_CAPTION_1011270 = false;
    var bHMK_SCF_UL_G_CAPTION_1011270 = false;
    var bHMK_FUSE_G_CAPTION_1011270 = false;

    if (aResult && aResult.length > 0) {
      //for (var i = 0; i < aResult.length; i++) {
      var i = 0;
      if (aResult[i].HMK_CB_GROUP_CAPTION_1011270 == "T") {
        bHMK_CB_GROUP_CAPTION_1011270 = true;
      }
      if (aResult[i].HMK_CB_UL_G_CAPTION_1011270 == "T") {
        bHMK_CB_UL_G_CAPTION_1011270 = true;
      }
      if (aResult[i].HMK_MS_IEC_G_CAPTION_1011270 == "T") {
        bHMK_MS_IEC_G_CAPTION_1011270 = true;
      }
      if (aResult[i].HMK_MS_UL_G_CAPTION_1011270 == "T") {
        bHMK_MS_UL_G_CAPTION_1011270 = true;
      }
      if (aResult[i].HMK_SCFUSE_G_CAPTION_1011270 == "T") {
        bHMK_SCFUSE_G_CAPTION_1011270 = true;
      }
      if (aResult[i].HMK_SCF_UL_G_CAPTION_1011270 == "T") {
        bHMK_SCF_UL_G_CAPTION_1011270 = true;
      }
      if (aResult[i].HMK_FUSE_G_CAPTION_1011270 == "T") {
        bHMK_FUSE_G_CAPTION_1011270 = true;
      }
      //}
    }
  } else {
    var bHMK_CB_GROUP_CAPTION_1011270 = true;
    var bHMK_CB_UL_G_CAPTION_1011270 = true;
    var bHMK_MS_IEC_G_CAPTION_1011270 = true;
    var bHMK_MS_UL_G_CAPTION_1011270 = true;
    var bHMK_SCFUSE_G_CAPTION_1011270 = true;
    var bHMK_SCF_UL_G_CAPTION_1011270 = true;
    var bHMK_FUSE_G_CAPTION_1011270 = true;
  }
  if ((bHMK_CB_GROUP_CAPTION_1011270 && HMK_MOTORNORM_G220 == "00002") || (bHMK_CB_UL_G_CAPTION_1011270 && HMK_MOTORNORM_G220 == "00001")) {
    ECL_EnableAttribute("CB_CIRCUIT_BREAKER_G220");
  } else {
    ECL_DisableAttribute("CB_CIRCUIT_BREAKER_G220");
  }

  if (bHMK_MS_IEC_G_CAPTION_1011270 && HMK_MOTORNORM_G220 == "00002") {
    ECL_EnableAttribute("CB_MS_G220");
  } else {
    ECL_DisableAttribute("CB_MS_G220");
  }
  if (bHMK_MS_UL_G_CAPTION_1011270 && HMK_MOTORNORM_G220 == "00001") {
    ECL_EnableAttribute("CB_MS_UL_G220");
  } else {
    ECL_DisableAttribute("CB_MS_UL_G220");
  }
  if ((bHMK_SCFUSE_G_CAPTION_1011270 && HMK_MOTORNORM_G220 == "00002") || (bHMK_SCF_UL_G_CAPTION_1011270 && HMK_MOTORNORM_G220 == "00001")) {
    ECL_EnableAttribute("CB_SC_FUSE_G220");
  } else {
    ECL_DisableAttribute("CB_SC_FUSE_G220");
  }

  if (bHMK_FUSE_G_CAPTION_1011270 && HMK_MOTORNORM_G220 == "00002") {
    ECL_EnableAttribute("CB_STD_FUSE_G220");
  } else {
    ECL_DisableAttribute("CB_STD_FUSE_G220");
  }

  // ################################################################################################################

  // ################################################################################################################
  // Leistungsschalter		CB_CIRCUIT_BREAKER_G220
  // ################################################################################################################
  /* 
  CB_CIRCUIT_BREAKER_G220		Leistungsschalter (Circuit breaker CB)	

  IEC
  SPC-Attribute:	 	HMK_CB_GROUP_CAPTION_1011270	Leistungsschalter
    VT_G220_M00614	IEC_CIRCUIT_BREAKER
      HMK_VALUE_VALID_G220		Flag: Eintrag ist gültig
      HMK_CB_GROUP_CAPTION_1011270	Leistungsschalter
      HMK_MOTORNORM_G220			Motornorm
      PMD_ABJ176_001_000_G220		Schutzart IP
      HMK_CB_IEC_MEV_1011410_X	HMK_CB_IEC_MEV_G220
      HMK_CB_IEC_ICC_1011270_X	Bedingter Kurzschlussstrom ICC
      HMK_CB_IEC_MEV_FT_1011410_X	HMK_CB_IEC_MEV_FT_G220
      HMK_CB_IEC_MLFB_1011270		HMK_CB_IEC_MLFB_G220			mit Platzhaltern
      HMK_VOLTAGE_PW_KEY_1011270	Voltage_Power Key
      HMK_TOPOLOGY_G220			HMK_TOPOLOGY_G220
      HMK_REP_SWITCH__G220		Wartungsschalter
      HMK_CB_IEC_ICC_V_1011270	HMK_CB_IEC_ICC_V_G220

    VT_G220_M00620	ONE_LINE_PW_COMPONENT						Netz-Komponenten-Verriegelung
      HMK_MOTORNORM_G220				Motornorm
      HMK_CB_GROUP_CAPTION_1011270	Leistungsschalter
      HMK_CB_UL_G_CAPTION_1011270		Leistungsschalter
      HMK_MS_IEC_G_CAPTION_1011270	Motorschutzschalter
      HMK_MS_UL_G_CAPTION_1011270		Kombinationsmot.../E
      HMK_SCFUSE_G_CAPTION_1011270	Halbleitersicherung
      HMK_SCF_UL_G_CAPTION_1011270	Halbleitersicherung
      HMK_FUSE_G_CAPTION_1011270		Standardsicherung

    VT_G220_M00624	VOLTAGE vs CB_IEC_ICC_V
      HMK_MOTORNORM_G220				Motornorm
      HMK_CB_GROUP_CAPTION_1011270	Leistungsschalter
      HMK_DISCR_VOLTAGE_G220			Netzspannung
      HMK_CB_IEC_ICC_V_1011270		HMK_CB_IEC_ICC_V_G220

  MLFB: HMK_CB_IEC_MLFB_CPL_1011270
  
    VT_G220_M00638	OCPD_IEC_CB_MLFB
      HMK_CB_IEC_ICPMR_REF_1011410	HMK_CB_IEC_ICPMR_REF_G220
    neu HMK_CB_IEC_MAX_C_1011410	Bemessungsstrom, max.
      HMK_CB_IEC_MLFB_1011270			HMK_CB_IEC_MLFB_G220			MLFB mit Platzhaltern
      HMK_CB_IEC_OC_RELEAS_1011270	Ausführung des Überstromauslösers
  ==>		HMK_CB_IEC_MLFB_CPL_1011270		HMK_CB_IEC_MLFB_CPL_G220		End-MLFB
      HMK_CB_IEC_RATED_ICU_1011270_X	Ausschaltvermögen Grenzkurzschlussstrom (Icu) bei 400 V AC Bemessungswert
      HMK_CB_IEC_RC_1011510			Bemessungsstrom
      HMK_CB_IEC_MLFB_TYPE_1011270	Ausführung des Anschlusses

  HMK_CB_IEC_RC_1011510			Bemessungsstrom
  HMK_CB_IEC_ICC_1011270_X		Bedingter Kurzschlussstrom ICC
  HMK_CB_IEC_RATED_ICU_1011270_X	Ausschaltvermögen Grenzkurzschlussstrom (Icu) bei 400 V AC Bemessungswert
  HMK_CB_IEC_OC_RELEAS_1011270	Ausführung des Überstromauslösers
  HMK_CB_IEC_MLFB_TYPE_1011270	Ausführung des Anschlusses


  UL
  SPC-Attribute:		HMK_CB_UL_G_CAPTION_1011270	Leistungsschalter
    VT_G220_M00615	UL_CSA_CIRCUIT_BREAKER
      HMK_CB_UL_G_CAPTION_1011270			Leistungsschalter
      HMK_MOTORNORM_G220					Motornorm
      HMK_VALUE_VALID_G220				Flag: Eintrag ist gültig
      PMD_ABJ176_001_000_G220				Schutzart IP
      HMK_CB_UL_SCCR_1011410_X			Bedingter Kurzschlussstrom SCCR
      HMK_CB_UL_MLFB_1011270				HMK_CB_UL_MLFB_G220
      HMK_CB_UL_MEV_FT_1011410_X			HMK_CB_UL_MEV_FT_G220
      HMK_CB_UL_MEV_1011410_X				HMK_CB_UL_MEV_G220
      HMK_VOLTAGE_PW_KEY_1011270			Voltage_Power Key
      HMK_TOPOLOGY_G220					HMK_TOPOLOGY_G220
      HMK_REP_SWITCH__G220				Wartungsschalter
      HMK_CB_UL_SCCR_V_1011270_X			HMK_CB_UL_SCCR_V_G220
      HMK_CB_UL_SCCR_V_SL_1011270			HMK_CB_UL_SCCR_V_SL_G220
      HMK_CB_UL_SCCR_SLASH_1011270_X		Bedingter Kurzschlussstrom SCCR (schräg-Spannung)
      HMK_CB_UL_VOLTAGE_R_1011270			Betriebsspannung

    VT_G220_M00620	ONE_LINE_PW_COMPONENT


  MLFB:				HMK_CB_UL_MLFB_CPL_1011270
    VT_G220_M00601	UL_CB_MLFB_ASSIGNMENT
      HMK_CB_UL_OC_RELEASE_1011270	Ausführung des Überstromauslösers
      HMK_CB_UL_MLFB_CPL_1011270		HMK_CB_UL_MLFB_CPL_G220
      HMK_CB_UL_MLFB_TYPE_1011270		Ausführung des Anschlusses
      HMK_CB_UL_R_ICU_480V_1011270	Ausschaltvermögen Grenzkurzschlussstrom (Icu) bei 480 V AC Bemessungswert
      HMK_CB_UL_MLFB_C_1011270		HMK_CB_UL_MLFB_C_G220
      HMK_CB_UL_MLFB_1011270			HMK_CB_UL_MLFB_G220
      HMK_CB_UL_RC_1011270			Bemessungsstrom


  HMK_CB_UL_RC_1011270			Bemessungsstrom
  HMK_CB_UL_VOLTAGE_R_1011270		Betriebsspannung
  HMK_CB_UL_SCCR_1011410_X		Bedingter Kurzschlussstrom SCCR
  HMK_CB_UL_SCCR_SLASH_1011270_X	Bedingter Kurzschlussstrom SCCR (schräg-Spannung)
  HMK_CB_UL_R_ICU_480V_1011270	Ausschaltvermögen Grenzkurzschlussstrom (Icu) bei 480 V AC Bemessungswert
  HMK_CB_UL_OC_RELEASE_1011270	Ausführung des Überstromauslösers
  HMK_CB_UL_MLFB_TYPE_1011270		Ausführung des Anschlusses



  */
  // ##############################################################################################
  var bCB_possible = false;
  var HMK_REP_SWITCH__G220 = "F";
  if (ECL_ValueSelected("CB_HMK_REP_SWITCH_G220", "T")) {
    HMK_REP_SWITCH__G220 = "T";
  }

  if (bHMK_CB_GROUP_CAPTION_1011270 && HMK_MOTORNORM_G220 == "00002") {
    /*
      VT_G220_M00614	IEC_CIRCUIT_BREAKER
        HMK_VALUE_VALID_G220		      Flag: Eintrag ist gültig
        HMK_CB_GROUP_CAPTION_1011270	Leistungsschalter
        HMK_MOTORNORM_G220			      Motornorm
        PMD_ABJ176_001_000_G220	    	Schutzart IP
        HMK_CB_IEC_MEV_1011410_X    	HMK_CB_IEC_MEV_G220
        HMK_CB_IEC_ICC_1011270_X	    Bedingter Kurzschlussstrom ICC
        HMK_CB_IEC_MEV_FT_1011410_X	  HMK_CB_IEC_MEV_FT_G220
        HMK_CB_IEC_MLFB_1011270		    HMK_CB_IEC_MLFB_G220			mit Platzhaltern
        HMK_VOLTAGE_PW_KEY_1011270  	Voltage_Power Key
        HMK_TOPOLOGY_G220			        HMK_TOPOLOGY_G220
        HMK_REP_SWITCH__G220	       	Wartungsschalter
        HMK_CB_IEC_ICC_V_1011270	    HMK_CB_IEC_ICC_V_G220
        */

    var sTable = "VT_G220_M00614" + sDB_Suffix;
    var sSQL =
      "SELECT * FROM " +
      sTable +
      " WHERE " +
      "HMK_MOTORNORM_G220 = '" +
      HMK_MOTORNORM_G220 +
      "' AND " +
      "HMK_VOLTAGE_PW_KEY_1011270 = '" +
      HMK_VOLTAGE_PW_KEY_1011270 +
      "' AND " +
      sWhereHMK_CB_IEC_ICC_V_1011270 +
      " AND " +
      "HMK_TOPOLOGY_G220 = '" +
      HMK_TOPOLOGY_G220 +
      "' AND " +
      "PMD_ABJ176_001_000_G220 = '" +
      PMD_ABJ176_001_000_G220 +
      "' AND " +
      "HMK_REP_SWITCH__G220 = '" +
      HMK_REP_SWITCH__G220 +
      "' AND " +
      //"HMK_MS_IEC_RC_1011270 > 0 AND " +
      //"HMK_CB_IEC_MLFB_1011270 <> '-' AND " +
      "HMK_CB_GROUP_CAPTION_1011270 = 'T' AND " +
      "HMK_VALUE_VALID_G220 = 'T';";
    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length > 0) {
      bCB_possible = true;
    }
  } else if (bHMK_CB_UL_G_CAPTION_1011270 && HMK_MOTORNORM_G220 == "00001") {
    /*VT_G220_M00615	UL_CSA_CIRCUIT_BREAKER
          HMK_CB_UL_G_CAPTION_1011270		Leistungsschalter
          HMK_MOTORNORM_G220					  Motornorm
          HMK_VALUE_VALID_G220				  Flag: Eintrag ist gültig
          PMD_ABJ176_001_000_G220				Schutzart IP
          HMK_CB_UL_SCCR_1011410_X			Bedingter Kurzschlussstrom SCCR
          HMK_CB_UL_MLFB_1011270				HMK_CB_UL_MLFB_G220
          HMK_CB_UL_MEV_FT_1011410_X		HMK_CB_UL_MEV_FT_G220
          HMK_CB_UL_MEV_1011410_X				HMK_CB_UL_MEV_G220
          HMK_VOLTAGE_PW_KEY_1011270		Voltage_Power Key
          HMK_TOPOLOGY_G220					    HMK_TOPOLOGY_G220
          HMK_REP_SWITCH__G220			  	Wartungsschalter
          HMK_CB_UL_SCCR_V_1011270_X		HMK_CB_UL_SCCR_V_G220
          HMK_CB_UL_SCCR_V_SL_1011270		HMK_CB_UL_SCCR_V_SL_G220
          HMK_CB_UL_SCCR_SLASH_1011270_X		Bedingter Kurzschlussstrom SCCR (schräg-Spannung)
          HMK_CB_UL_VOLTAGE_R_1011270		Betriebsspannung
    */
    var bStraightCB = false;
    var bSlashCB = false;
    var sTable = "VT_G220_M00615" + sDB_Suffix;
    var sSQL =
      "SELECT * FROM " +
      sTable +
      " WHERE " +
      "HMK_MOTORNORM_G220 = '" +
      HMK_MOTORNORM_G220 +
      "' AND " +
      "HMK_VOLTAGE_PW_KEY_1011270 = '" +
      HMK_VOLTAGE_PW_KEY_1011270 +
      "' AND " +
      "HMK_TOPOLOGY_G220 = '" +
      HMK_TOPOLOGY_G220 +
      "' AND " +
      "PMD_ABJ176_001_000_G220 = '" +
      PMD_ABJ176_001_000_G220 +
      "' AND " +
      "HMK_REP_SWITCH__G220 = '" +
      HMK_REP_SWITCH__G220 +
      "' AND " +
      "HMK_CB_UL_SCCR_1011410_X <> '.' AND " +
      "HMK_CB_UL_VOLTAGE_R_1011270 = '00002' AND " +
      "HMK_CB_UL_MLFB_1011270 <> '-' AND " +
      "HMK_CB_UL_G_CAPTION_1011270 = 'T' AND " +
      "HMK_VALUE_VALID_G220 = 'T';";
    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length > 0) {
      bCB_possible = true;
      bStraightCB = true;
    } else {
      var sSQL =
        "SELECT * FROM " +
        sTable +
        " WHERE " +
        "HMK_MOTORNORM_G220 = '" +
        HMK_MOTORNORM_G220 +
        "' AND " +
        "HMK_VOLTAGE_PW_KEY_1011270 = '" +
        HMK_VOLTAGE_PW_KEY_1011270 +
        "' AND " +
        "HMK_TOPOLOGY_G220 = '" +
        HMK_TOPOLOGY_G220 +
        "' AND " +
        "PMD_ABJ176_001_000_G220 = '" +
        PMD_ABJ176_001_000_G220 +
        "' AND " +
        "HMK_REP_SWITCH__G220 = '" +
        HMK_REP_SWITCH__G220 +
        "' AND " +
        "HMK_CB_UL_SCCR_SLASH_1011270_X <> '.' AND " +
        "HMK_CB_UL_VOLTAGE_R_1011270 = '00003' AND " +
        "HMK_CB_UL_MLFB_G220 <> '-' AND " +
        "HMK_CB_UL_G_CAPTION_1011270 = 'T' AND " +
        "HMK_VALUE_VALID_G220 = 'T';";
      var aResult = GetDBDataSetEXT(sSQL);
      if (aResult.length > 0) {
        bCB_possible = true;
        bSlashCB = true;
      }
    }
  }
  // Verriegelung VT620: nur eine Netz-Komponente (siehe oben)

  if (!bCB_possible) {
    ECL_DisableAttribute("CB_CIRCUIT_BREAKER_G220");
  }
  if (ECL_ValueSelected("CB_CIRCUIT_BREAKER_G220", "T")) {
    // nur eine netzseitige Leistungskomponente (LineSidePwComp) zulaessig
    // s.o.

    if (HMK_MOTORNORM_G220 == "00002") {
      // IEC
      /* UL deaktivieren:
        HMK_CB_UL_RC_1011270			Bemessungsstrom
        HMK_CB_UL_VOLTAGE_R_1011270		Betriebsspannung
        HMK_CB_UL_SCCR_1011410_X		Bedingter Kurzschlussstrom SCCR
        HMK_CB_UL_SCCR_SLASH_1011270_X	Bedingter Kurzschlussstrom SCCR (schräg-Spannung)
        HMK_CB_UL_R_ICU_480V_1011270	Ausschaltvermögen Grenzkurzschlussstrom (Icu) bei 480 V AC Bemessungswert
        HMK_CB_UL_OC_RELEASE_1011270	Ausführung des Überstromauslösers
        HMK_CB_UL_MLFB_TYPE_1011270		Ausführung des Anschlusses
      */
      ECL_DeactivateAttribute("HMK_CB_UL_RC_1011270");
      ECL_DeactivateAttribute("HMK_CB_UL_VOLTAGE_R_1011270");
      ECL_DeactivateAttribute("HMK_CB_UL_SCCR_1011410_X");
      ECL_DeactivateAttribute("HMK_CB_UL_SCCR_SLASH_1011270_X");
      ECL_DeactivateAttribute("HMK_CB_UL_R_ICU_480V_1011270");
      ECL_DeactivateAttribute("HMK_CB_UL_OC_RELEASE_1011270");
      ECL_DeactivateAttribute("HMK_CB_UL_MLFB_TYPE_1011270");
      ECL_SetValue("HMK_CB_UL_MLFB_CPL_1011270", "");
      // IEC aktivieren
      /*
        HMK_CB_IEC_RC_1011510			Bemessungsstrom
        HMK_CB_IEC_ICC_1011270_X		Bedingter Kurzschlussstrom ICC
        HMK_CB_IEC_RATED_ICU_1011270_X	Ausschaltvermögen Grenzkurzschlussstrom (Icu) bei 400 V AC Bemessungswert
        HMK_CB_IEC_OC_RELEAS_1011270	Ausführung des Überstromauslösers
        HMK_CB_IEC_MLFB_TYPE_1011270	Ausführung des Anschlusses    
      */
      ECL_ActivateAttribute("HMK_CB_IEC_RC_1011510");
      ECL_ActivateAttribute("HMK_CB_IEC_MAX_C_1011410");
      ECL_ActivateAttribute("HMK_CB_IEC_ICC_1011270_X");
      ECL_ActivateAttribute("HMK_CB_IEC_RATED_ICU_1011270_X");
      ECL_ActivateAttribute("HMK_CB_IEC_OC_RELEAS_1011270");
      ECL_ActivateAttribute("HMK_CB_IEC_MLFB_TYPE_1011270");

      ECL_ActivateAllAttributeValues("HMK_CB_IEC_RC_1011510");
      ECL_ActivateAllAttributeValues("HMK_CB_IEC_MAX_C_1011410");
      ECL_ActivateAllAttributeValues("HMK_CB_IEC_ICC_1011270_X");
      ECL_ActivateAllAttributeValues("HMK_CB_IEC_RATED_ICU_1011270_X");
      ECL_ActivateAllAttributeValues("HMK_CB_IEC_OC_RELEAS_1011270");
      ECL_ActivateAllAttributeValues("HMK_CB_IEC_MLFB_TYPE_1011270");

      ECL_DeactivateValue("HMK_CB_IEC_RC_1011510", 0);
      ECL_DeactivateValue("HMK_CB_IEC_MAX_C_1011410", 0);
      ECL_DeactivateValue("HMK_CB_IEC_ICC_1011270_X", ".");
      ECL_DeactivateValue("HMK_CB_IEC_RATED_ICU_1011270_X", ".");
      ECL_DeactivateValue("HMK_CB_IEC_OC_RELEAS_1011270", "00001");
      ECL_DeactivateValue("HMK_CB_IEC_MLFB_TYPE_1011270", "00001");

      //ExecSetStandardifValueEmpty("HMK_MS_IEC_MLFB_TYPE_1011270", "00001");
      // ------------------------------------------------------------------------------------
      /*
      über VT_G220_M00638 und VT_G220_M00614
      
      HMK_CB_IEC_RC_1011510			      Bemessungsstrom
      HMK_CB_IEC_ICC_1011270_X		    Bedingter Kurzschlussstrom ICC
      HMK_CB_IEC_RATED_ICU_1011270_X	Ausschaltvermögen Grenzkurzschlussstrom (Icu) bei 400 V AC Bemessungswert
      HMK_CB_IEC_OC_RELEAS_1011270	  Ausführung des Überstromauslösers
      HMK_CB_IEC_MLFB_TYPE_1011270	  Ausführung des Anschlusses

      A VT_G220_M00638	OCPD_IEC_CB_MLFB
        nn  HMK_CB_IEC_ICPMR_REF_1011410	HMK_CB_IEC_ICPMR_REF_G220
            HMK_CB_IEC_MAX_C_1011410	Bemessungsstrom, max.
            HMK_CB_IEC_MLFB_1011270	HMK_CB_IEC_MLFB_G220                      <==     MLFB mit Platzhaltern
            HMK_CB_IEC_OC_RELEAS_1011270	Ausführung /...romauslösers
            HMK_CB_IEC_MLFB_CPL_1011270	HMK_CB_IEC_MLFB_CPL_G220		          <==     End-MLFB
            HMK_CB_IEC_RATED_ICU_1011270_X	Ausschaltvermög...messungswert
            HMK_CB_IEC_RC_1011510	Bemessungsstrom
            HMK_CB_IEC_MLFB_TYPE_1011270	Ausführung des Anschlusses

      B  VT_G220_M00614	IEC_CIRCUIT_BREAKER
          HMK_VALUE_VALID_G220		      Flag: Eintrag ist gültig
          HMK_CB_GROUP_CAPTION_1011270	Leistungsschalter
          HMK_MOTORNORM_G220			      Motornorm
          PMD_ABJ176_001_000_G220		    Schutzart IP
        nn  HMK_CB_IEC_MEV_1011410_X	    HMK_CB_IEC_MEV_G220
          HMK_CB_IEC_ICC_1011270_X	    Bedingter Kurzschlussstrom ICC
        nn  HMK_CB_IEC_MEV_FT_1011410_X	  HMK_CB_IEC_MEV_FT_G220
          HMK_CB_IEC_MLFB_1011270		    HMK_CB_IEC_MLFB_G220			mit Platzhaltern
          HMK_VOLTAGE_PW_KEY_1011270	  Voltage_Power Key
          HMK_TOPOLOGY_G220			        HMK_TOPOLOGY_G220
          HMK_REP_SWITCH__G220		      Wartungsschalter
          HMK_CB_IEC_ICC_V_1011270	    HMK_CB_IEC_ICC_V_G220

      MLFB: HMK_CB_IEC_MLFB_CPL_1011270
      */

      var sTableA = "VT_G220_M00638" + sDB_Suffix;
      var sTableB = "VT_G220_M00614" + sDB_Suffix;
      var sSQL =
        "SELECT VT_TABLE_A.*, VT_TABLE_B.HMK_CB_IEC_ICC_1011270_X " +
        "FROM " + sTableA + " As VT_TABLE_A " +
        "INNER JOIN " + sTableB + " As VT_TABLE_B " +
        "ON VT_TABLE_A.HMK_CB_IEC_MLFB_1011270 = VT_TABLE_B.HMK_CB_IEC_MLFB_1011270 " +
        "WHERE " +
        "VT_TABLE_B.HMK_MOTORNORM_G220 = '" + HMK_MOTORNORM_G220 + "' AND " +
        "VT_TABLE_B.PMD_ABJ176_001_000_G220 = '" + PMD_ABJ176_001_000_G220 + "' AND " +
        "VT_TABLE_B.HMK_VOLTAGE_PW_KEY_1011270 = '" + HMK_VOLTAGE_PW_KEY_1011270 + "' AND " +
        sWhereHMK_CB_IEC_ICC_V_1011270 + " AND " +
        "VT_TABLE_B.HMK_TOPOLOGY_G220 = '" + HMK_TOPOLOGY_G220 + "' AND " +
        "VT_TABLE_B.HMK_REP_SWITCH__G220 = '" + HMK_REP_SWITCH__G220 + "' AND " +
        "VT_TABLE_A.HMK_CB_IEC_MAX_C_1011410 > 0 AND " +
        "VT_TABLE_B.HMK_CB_GROUP_CAPTION_1011270 = 'T' AND " +
        //"VT_TABLE_B.HMK_CB_IEC_MEV_1011410_X <> '.' AND " +
        "VT_TABLE_B.HMK_VALUE_VALID_G220 = 'T';";

      var aResult = GetDBDataSetEXT(sSQL);
      if (aResult && aResult.length > 0) {
        // mögliche Werte für
        /*HMK_CB_IEC_RC_1011510			      Bemessungsstrom
          HMK_CB_IEC_ICC_1011270_X		    Bedingter Kurzschlussstrom ICC
          HMK_CB_IEC_RATED_ICU_1011270_X	Ausschaltvermögen Grenzkurzschlussstrom (Icu) bei 400 V AC Bemessungswert
          HMK_CB_IEC_OC_RELEAS_1011270	  Ausführung des Überstromauslösers
          HMK_CB_IEC_MLFB_TYPE_1011270	  Ausführung des Anschlusses
        */
        ECL_DeactivateAllAttributeValues("HMK_CB_IEC_RC_1011510");

        var aCB_MLFB_HELPER = [];

        for (var i = 0; i < aResult.length; i++) {
          var HMK_CB_IEC_MLFB_1011270 = aResult[i].HMK_CB_IEC_MLFB_1011270;
          if (aCB_MLFB_HELPER.indexOf(HMK_CB_IEC_MLFB_1011270) < 0) {
            aCB_MLFB_HELPER.push(HMK_CB_IEC_MLFB_1011270);
          }
          ECL_ActivateValue("HMK_CB_IEC_RC_1011510", aResult[i].HMK_CB_IEC_RC_1011510);
        }
        ExecSetStandardifValueEmpty("HMK_CB_IEC_RC_1011510", "");

        var sWhereCB_MLFB_HELPER = "HMK_CB_IEC_MLFB_1011270 = '" + aCB_MLFB_HELPER[0] + "'";

        if (aCB_MLFB_HELPER.length > 1) {
          for (var i = 1; i < aCB_MLFB_HELPER.length; i++) {
            sWhereCB_MLFB_HELPER += " OR HMK_CB_IEC_MLFB_1011270 = '" + aCB_MLFB_HELPER[i] + "'";
          }
          sWhereCB_MLFB_HELPER = "(" + sWhereCB_MLFB_HELPER + ")";
        }
      } else {
        strError = "DICT1_ERR_G220___PL_CB_IEC";
        return strError;
      }

      // ------------------------------------------------------------------------------------
      // weitere Eingrenzungen
      /* A
        VT_G220_M00614	IEC_CIRCUIT_BREAKER
          HMK_VALUE_VALID_G220		      Flag: Eintrag ist gültig
          HMK_CB_GROUP_CAPTION_1011270	Leistungsschalter
          HMK_MOTORNORM_G220			      Motornorm
          PMD_ABJ176_001_000_G220		    Schutzart IP
        nn  HMK_CB_IEC_MEV_1011410_X	    HMK_CB_IEC_MEV_G220
          HMK_CB_IEC_ICC_1011270_X	    Bedingter Kurzschlussstrom ICC
        nn  HMK_CB_IEC_MEV_FT_1011410_X	  HMK_CB_IEC_MEV_FT_G220
          HMK_CB_IEC_MLFB_1011270		    HMK_CB_IEC_MLFB_G220			mit Platzhaltern
          HMK_VOLTAGE_PW_KEY_1011270	  Voltage_Power Key
          HMK_TOPOLOGY_G220			        HMK_TOPOLOGY_G220
          HMK_REP_SWITCH__G220		      Wartungsschalter
          HMK_CB_IEC_ICC_V_1011270	    HMK_CB_IEC_ICC_V_G220
      
     B  VT_G220_M00638	OCPD_IEC_CB_MLFB
        nn  HMK_CB_IEC_ICPMR_REF_1011410	  HMK_CB_IEC_ICPMR_REF_G220
          HMK_CB_IEC_MAX_C_1011410	    Bemessungsstrom, max.
          HMK_CB_IEC_MLFB_1011270			    HMK_CB_IEC_MLFB_G220			       <==     MLFB mit Platzhaltern
          HMK_CB_IEC_OC_RELEAS_1011270	  Ausführung des Überstromauslösers
      ==>		HMK_CB_IEC_MLFB_CPL_1011270		HMK_CB_IEC_MLFB_CPL_G220		     <==     End-MLFB
          HMK_CB_IEC_RATED_ICU_1011270_X	Ausschaltvermögen Grenzkurzschlussstrom (Icu) bei 400 V AC Bemessungswert
          HMK_CB_IEC_RC_1011510			      Bemessungsstrom
          HMK_CB_IEC_MLFB_TYPE_1011270	  Ausführung des Anschlusses
        
          sWhereCB_MLFB_HELPER
      */
      // Basis-SQL-String für JOIN-Query
      var sTableA = "VT_G220_M00638" + sDB_Suffix;
      var sTableB = "VT_G220_M00614" + sDB_Suffix;
      var sSQL_CB_JOIN_BASIC =
        "SELECT VT_TABLE_A.*, VT_TABLE_B.HMK_CB_IEC_ICC_1011270_X " +
        "FROM " + sTableA + " As VT_TABLE_A " +
        "INNER JOIN " + sTableB + " As VT_TABLE_B " +
        "ON VT_TABLE_A.HMK_CB_IEC_MLFB_1011270 = VT_TABLE_B.HMK_CB_IEC_MLFB_1011270 " +
        "WHERE " +
        "VT_TABLE_B.HMK_MOTORNORM_G220 = '" + HMK_MOTORNORM_G220 + "' AND " +
        "VT_TABLE_B.PMD_ABJ176_001_000_G220 = '" + PMD_ABJ176_001_000_G220 + "' AND " +
        "VT_TABLE_B.HMK_VOLTAGE_PW_KEY_1011270 = '" + HMK_VOLTAGE_PW_KEY_1011270 + "' AND " +
        sWhereHMK_CB_IEC_ICC_V_1011270 + " AND " +
        "VT_TABLE_B.HMK_TOPOLOGY_G220 = '" + HMK_TOPOLOGY_G220 + "' AND " +
        "VT_TABLE_B.HMK_REP_SWITCH__G220 = '" + HMK_REP_SWITCH__G220 + "' AND " +
        "VT_TABLE_B.HMK_CB_GROUP_CAPTION_1011270 = 'T' AND " +
        //"VT_TABLE_B.HMK_CB_IEC_MEV_1011410_X <> '.' AND " +
        "VT_TABLE_B.HMK_VALUE_VALID_G220 = 'T' ";
      // ------------------------------------------------------------------------------------
      // HMK_CB_IEC_MAX_C_1011410	    Bemessungsstrom, max.
      // ------------------------------------------------------------------------------------
      var sTargetAttribute = "HMK_CB_IEC_MAX_C_1011410";

      var HMK_CB_IEC_RC_1011510 = ECL_GetValue("HMK_CB_IEC_RC_1011510");

      var sSQL = sSQL_CB_JOIN_BASIC + "AND HMK_CB_IEC_RC_1011510 = " + HMK_CB_IEC_RC_1011510 + ";";

      var aResult = GetDBDataSetEXT(sSQL);
      if (aResult && aResult.length > 0) {
        // mögliche Werte für HMK_CB_IEC_MAX_C_1011410    Bemessungsstrom, max.

        ECL_DeactivateAllAttributeValues(sTargetAttribute);

        for (var i = 0; i < aResult.length; i++) {
          var sValue = aResult[i][sTargetAttribute];
          ECL_ActivateValue(sTargetAttribute, sValue);
        }
        ExecSetStandardifValueEmpty(sTargetAttribute, "");
      } else {
        strError = "DICT1_ERR_G220___PL_CB_IEC";
        return strError;
      }
      // ------------------------------------------------------------------------------------

      // ------------------------------------------------------------------------------------
      // HMK_CB_IEC_ICC_1011270_X	    Bedingter Kurzschlussstrom ICC
      // ------------------------------------------------------------------------------------
      var sTargetAttribute = "HMK_CB_IEC_ICC_1011270_X";

      var HMK_CB_IEC_MAX_C_1011410 = ECL_GetValue("HMK_CB_IEC_MAX_C_1011410");

      var sSQL = sSQL_CB_JOIN_BASIC + "AND " +
        "HMK_CB_IEC_MAX_C_1011410 = " + HMK_CB_IEC_MAX_C_1011410 + " AND " +
        "HMK_CB_IEC_RC_1011510 = " + HMK_CB_IEC_RC_1011510 + ";";

      var aResult = GetDBDataSetEXT(sSQL);
      if (aResult && aResult.length > 0) {
        // mögliche Werte für
        /*HMK_CB_IEC_RC_1011510			      Bemessungsstrom
          HMK_CB_IEC_ICC_1011270_X		    Bedingter Kurzschlussstrom ICC
          HMK_CB_IEC_RATED_ICU_1011270_X	Ausschaltvermögen Grenzkurzschlussstrom (Icu) bei 400 V AC Bemessungswert
          HMK_CB_IEC_OC_RELEAS_1011270	  Ausführung des Überstromauslösers
          HMK_CB_IEC_MLFB_TYPE_1011270	  Ausführung des Anschlusses
        */
        ECL_DeactivateAllAttributeValues(sTargetAttribute);

        for (var i = 0; i < aResult.length; i++) {
          var sValue = aResult[i][sTargetAttribute];
          ECL_ActivateValue(sTargetAttribute, sValue);
        }
        ExecSetStandardifValueEmpty(sTargetAttribute, "");
      } else {
        // error
        strError = "DICT1_ERR_G220___PL_CB_IEC";
        return strError;
      }
      // ------------------------------------------------------------------------------------
      // HMK_CB_IEC_RATED_ICU_1011270_X Ausschaltvermögen Grenzkurzschlussstrom (Icu) bei 400 V AC Bemessungswert
      // ------------------------------------------------------------------------------------
      var HMK_CB_IEC_ICC_1011270_X = ECL_GetValue("HMK_CB_IEC_ICC_1011270_X");

      var sTargetAttribute = "HMK_CB_IEC_RATED_ICU_1011270_X";

      var HMK_CB_IEC_RC_1011510 = ECL_GetValue("HMK_CB_IEC_RC_1011510");

      var sSQL = sSQL_CB_JOIN_BASIC + "AND " +
        "HMK_CB_IEC_RC_1011510 = " + HMK_CB_IEC_RC_1011510 + " AND " +
        "HMK_CB_IEC_MAX_C_1011410 = " + HMK_CB_IEC_MAX_C_1011410 + " AND " +
        "HMK_CB_IEC_ICC_1011270_X = '" + HMK_CB_IEC_ICC_1011270_X + "';";

      var aResult = GetDBDataSetEXT(sSQL);
      if (aResult && aResult.length > 0) {
        ECL_DeactivateAllAttributeValues(sTargetAttribute);

        for (var i = 0; i < aResult.length; i++) {
          var sValue = aResult[i][sTargetAttribute];
          ECL_ActivateValue(sTargetAttribute, sValue);
        }
        ExecSetStandardifValueEmpty(sTargetAttribute, "");
      } else {
        strError = "DICT1_ERR_G220___PL_CB_IEC";
        return strError;
      }
      // ------------------------------------------------------------------------------------
      // HMK_CB_IEC_OC_RELEAS_1011270	  Ausführung des Überstromauslösers
      // ------------------------------------------------------------------------------------
      var HMK_CB_IEC_RATED_ICU_1011270_X = ECL_GetValue("HMK_CB_IEC_RATED_ICU_1011270_X");

      var sTargetAttribute = "HMK_CB_IEC_OC_RELEAS_1011270";

      var sSQL = sSQL_CB_JOIN_BASIC + "AND " +
        "HMK_CB_IEC_RC_1011510 = " + HMK_CB_IEC_RC_1011510 + " AND " +
        "HMK_CB_IEC_MAX_C_1011410 = " + HMK_CB_IEC_MAX_C_1011410 + " AND " +
        "HMK_CB_IEC_ICC_1011270_X = '" + HMK_CB_IEC_ICC_1011270_X + "' AND " +
        "HMK_CB_IEC_RATED_ICU_1011270_X = '" + HMK_CB_IEC_RATED_ICU_1011270_X + "';";

      var aResult = GetDBDataSetEXT(sSQL);
      if (aResult && aResult.length > 0) {
        ECL_DeactivateAllAttributeValues(sTargetAttribute);

        for (var i = 0; i < aResult.length; i++) {
          var sValue = aResult[i][sTargetAttribute];
          ECL_ActivateValue(sTargetAttribute, sValue);
        }
        ExecSetStandardifValueEmpty(sTargetAttribute, "");
      } else {
        strError = "DICT1_ERR_G220___PL_CB_IEC";
        return strError;
      }
      // ------------------------------------------------------------------------------------
      // HMK_CB_IEC_MLFB_TYPE_1011270	  Ausführung des Anschlusses
      // ------------------------------------------------------------------------------------
      var HMK_CB_IEC_OC_RELEAS_1011270 = ECL_GetValue("HMK_CB_IEC_OC_RELEAS_1011270");

      var sTargetAttribute = "HMK_CB_IEC_MLFB_TYPE_1011270";
      var sSQL = sSQL_CB_JOIN_BASIC + "AND " +
        "HMK_CB_IEC_RC_1011510 = " + HMK_CB_IEC_RC_1011510 + " AND " +
        "HMK_CB_IEC_MAX_C_1011410 = " + HMK_CB_IEC_MAX_C_1011410 + " AND " +
        "HMK_CB_IEC_ICC_1011270_X = '" + HMK_CB_IEC_ICC_1011270_X + "' AND " +
        "HMK_CB_IEC_OC_RELEAS_1011270 = '" + HMK_CB_IEC_OC_RELEAS_1011270 + "' AND " +
        "HMK_CB_IEC_RATED_ICU_1011270_X = '" + HMK_CB_IEC_RATED_ICU_1011270_X + "';";

      var aResult = GetDBDataSetEXT(sSQL);
      if (aResult && aResult.length > 0) {
        ECL_DeactivateAllAttributeValues(sTargetAttribute);

        for (var i = 0; i < aResult.length; i++) {
          var sValue = aResult[i][sTargetAttribute];
          ECL_ActivateValue(sTargetAttribute, sValue);
        }
        ExecSetStandardifValueEmpty(sTargetAttribute, "");
      } else {
        strError = "DICT1_ERR_G220___PL_CB_IEC";
        return strError;
      }

      // ------------------------------------------------------------------------------------
      // MLFB CB IEC bestimmen
      // ------------------------------------------------------------------------------------

      var HMK_CB_IEC_RC_1011510 = ECL_GetValue("HMK_CB_IEC_RC_1011510");
      var HMK_CB_IEC_MAX_C_1011410 = ECL_GetValue("HMK_CB_IEC_MAX_C_1011410");
      var HMK_CB_IEC_ICC_1011270_X = ECL_GetValue("HMK_CB_IEC_ICC_1011270_X");
      var HMK_CB_IEC_RATED_ICU_1011270_X = ECL_GetValue("HMK_CB_IEC_RATED_ICU_1011270_X");
      var HMK_CB_IEC_OC_RELEAS_1011270 = ECL_GetValue("HMK_CB_IEC_OC_RELEAS_1011270");
      var HMK_CB_IEC_MLFB_TYPE_1011270 = ECL_GetValue("HMK_CB_IEC_MLFB_TYPE_1011270");

      var sTableA = "VT_G220_M00638" + sDB_Suffix;
      var sTableB = "VT_G220_M00614" + sDB_Suffix;
      var sSQL =
        "SELECT DISTINCT VT_TABLE_A.HMK_CB_IEC_MLFB_CPL_1011270 " +
        "FROM " + sTableA + " As VT_TABLE_A " +
        "INNER JOIN " + sTableB + " As VT_TABLE_B " +
        "ON VT_TABLE_A.HMK_CB_IEC_MLFB_1011270 = VT_TABLE_B.HMK_CB_IEC_MLFB_1011270 " +
        "WHERE " +
        "VT_TABLE_B.HMK_MOTORNORM_G220 = '" + HMK_MOTORNORM_G220 + "' AND " +
        "VT_TABLE_B.PMD_ABJ176_001_000_G220 = '" + PMD_ABJ176_001_000_G220 + "' AND " +
        "VT_TABLE_B.HMK_VOLTAGE_PW_KEY_1011270 = '" + HMK_VOLTAGE_PW_KEY_1011270 + "' AND " +
        sWhereHMK_CB_IEC_ICC_V_1011270 + " AND " +
        "VT_TABLE_B.HMK_TOPOLOGY_G220 = '" + HMK_TOPOLOGY_G220 + "' AND " +
        "VT_TABLE_B.HMK_REP_SWITCH__G220 = '" + HMK_REP_SWITCH__G220 + "' AND " +
        "VT_TABLE_A.HMK_CB_IEC_RC_1011510 = " + HMK_CB_IEC_RC_1011510 + " AND " +
        "VT_TABLE_A.HMK_CB_IEC_MAX_C_1011410 = " + HMK_CB_IEC_MAX_C_1011410 + " AND " +
        "VT_TABLE_B.HMK_CB_IEC_ICC_1011270_X = '" + HMK_CB_IEC_ICC_1011270_X + "' AND " +
        "VT_TABLE_A.HMK_CB_IEC_RATED_ICU_1011270_X = '" + HMK_CB_IEC_RATED_ICU_1011270_X + "' AND " +
        "VT_TABLE_A.HMK_CB_IEC_OC_RELEAS_1011270 = '" + HMK_CB_IEC_OC_RELEAS_1011270 + "' AND " +
        "VT_TABLE_A.HMK_CB_IEC_MLFB_TYPE_1011270 = '" + HMK_CB_IEC_MLFB_TYPE_1011270 + "' AND " +
        "VT_TABLE_B.HMK_CB_GROUP_CAPTION_1011270 = 'T' AND " +
        //"VT_TABLE_B.HMK_CB_IEC_MEV_1011410_X <> '.' AND " +
        "VT_TABLE_B.HMK_VALUE_VALID_G220 = 'T' ORDER BY HMK_CB_IEC_MLFB_CPL_1011270 DESC;";

      var aResult = GetDBDataSetEXT(sSQL);
      if (aResult && aResult.length > 0) {
        var HMK_CB_IEC_MLFB_CPL_1011270 = aResult[0].HMK_CB_IEC_MLFB_CPL_1011270;
        ECL_SetValue("HMK_CB_IEC_MLFB_CPL_1011270", HMK_CB_IEC_MLFB_CPL_1011270);
      } else {
        strError = "DICT1_ERR_G220___PL_CB_MLFB_IEC";
        return strError;
      }
    } else {
      // (HMK_MOTORNORM_G220 == "00001") // NEMA
      // IEC deaktivieren
      ECL_DeactivateAttribute("HMK_CB_IEC_RC_1011510");
      ECL_DeactivateAttribute("HMK_CB_IEC_MAX_C_1011410");
      ECL_DeactivateAttribute("HMK_CB_IEC_ICC_1011270_X");
      ECL_DeactivateAttribute("HMK_CB_IEC_RATED_ICU_1011270_X");
      ECL_DeactivateAttribute("HMK_CB_IEC_OC_RELEAS_1011270");
      ECL_DeactivateAttribute("HMK_CB_IEC_MLFB_TYPE_1011270");
      ECL_SetValue("HMK_CB_IEC_MLFB_CPL_1011270", ""); // MLFB löschen
      /* UL aktivieren
        HMK_CB_UL_RC_1011270			Bemessungsstrom
        HMK_CB_UL_VOLTAGE_R_1011270		Betriebsspannung
        HMK_CB_UL_SCCR_1011410_X		Bedingter Kurzschlussstrom SCCR
        HMK_CB_UL_SCCR_SLASH_1011270_X	Bedingter Kurzschlussstrom SCCR (schräg-Spannung)
        HMK_CB_UL_R_ICU_480V_1011270	Ausschaltvermögen Grenzkurzschlussstrom (Icu) bei 480 V AC Bemessungswert
        HMK_CB_UL_OC_RELEASE_1011270	Ausführung des Überstromauslösers
        HMK_CB_UL_MLFB_TYPE_1011270		Ausführung des Anschlusses
      */
      ECL_ActivateAttribute("HMK_CB_UL_RC_1011270");
      ECL_ActivateAttribute("HMK_CB_UL_VOLTAGE_R_1011270");
      // in Abh. von Betriebsspannung (gerade/ Schrägspannung)
      if (bStraightCB) {
        var HMK_CB_UL_VOLTAGE_R_1011270 = "00002";
      } else if (bSlashCB) {
        var HMK_CB_UL_VOLTAGE_R_1011270 = "00003";
      }

      ECL_DeactivateAllAttributeValues("HMK_CB_UL_VOLTAGE_R_1011270");
      ECL_ActivateValue("HMK_CB_UL_VOLTAGE_R_1011270", HMK_CB_UL_VOLTAGE_R_1011270);
      ECL_SelectValue("HMK_CB_UL_VOLTAGE_R_1011270", HMK_CB_UL_VOLTAGE_R_1011270);
      if (HMK_CB_UL_VOLTAGE_R_1011270 == "00002") {
        // gerade
        ECL_ActivateAttribute("HMK_CB_UL_SCCR_1011410_X"); // HMK_CB_UL_SCCR_1011410_X		Bedingter Kurzschlussstrom SCCR
        ECL_DeactivateAttribute("HMK_CB_UL_SCCR_SLASH_1011270_X"); // Bedingter Kurzschlussstrom SCCR (schräg-Spannung)
      } else if (HMK_CB_UL_VOLTAGE_R_1011270 == "00003") {
        // schräg
        ECL_ActivateAttribute("HMK_CB_UL_SCCR_SLASH_1011270_X"); // Bedingter Kurzschlussstrom SCCR (schräg-Spannung)
        ECL_DeactivateAttribute("HMK_CB_UL_SCCR_1011410_X");
      }
      ECL_ActivateAttribute("HMK_CB_UL_R_ICU_480V_1011270");
      ECL_ActivateAttribute("HMK_CB_UL_OC_RELEASE_1011270");
      ECL_ActivateAttribute("HMK_CB_UL_MLFB_TYPE_1011270");

      ECL_ActivateAllAttributeValues("HMK_CB_UL_RC_1011270");
      ECL_ActivateAllAttributeValues("HMK_CB_UL_SCCR_1011410_X");
      ECL_ActivateAllAttributeValues("HMK_CB_UL_SCCR_SLASH_1011270_X");
      ECL_ActivateAllAttributeValues("HMK_CB_UL_R_ICU_480V_1011270");
      ECL_ActivateAllAttributeValues("HMK_CB_UL_OC_RELEASE_1011270");
      ECL_ActivateAllAttributeValues("HMK_CB_UL_MLFB_TYPE_1011270");

      ECL_DeactivateValue("HMK_CB_UL_RC_1011270", 0);
      ECL_DeactivateValue("HMK_CB_UL_SCCR_1011410_X", ".");
      ECL_DeactivateValue("HMK_CB_UL_SCCR_SLASH_1011270_X", ".");
      ECL_DeactivateValue("HMK_CB_UL_R_ICU_480V_1011270", 0);
      ECL_DeactivateValue("HMK_CB_UL_OC_RELEASE_1011270", "00001");
      ECL_DeactivateValue("HMK_CB_UL_MLFB_TYPE_1011270", "00001");

      /*
      UL
        SPC-Attribute:		HMK_CB_UL_G_CAPTION_1011270	Leistungsschalter
        
        HMK_CB_UL_RC_1011270			    Bemessungsstrom
        HMK_CB_UL_VOLTAGE_R_1011270		Betriebsspannung
        HMK_CB_UL_SCCR_1011410_X		  Bedingter Kurzschlussstrom SCCR
        HMK_CB_UL_SCCR_SLASH_1011270_X	Bedingter Kurzschlussstrom SCCR (schräg-Spannung)
        HMK_CB_UL_R_ICU_480V_1011270	Ausschaltvermögen Grenzkurzschlussstrom (Icu) bei 480 V AC Bemessungswert
        HMK_CB_UL_OC_RELEASE_1011270	Ausführung des Überstromauslösers
        HMK_CB_UL_MLFB_TYPE_1011270		Ausführung des Anschlusses
        
        MLFB:				HMK_CB_UL_MLFB_CPL_1011270
      
        A  VT_G220_M00601	UL_CB_MLFB_ASSIGNMENT
            HMK_CB_UL_OC_RELEASE_1011270	Ausführung des Überstromauslösers
            HMK_CB_UL_MLFB_CPL_1011270		HMK_CB_UL_MLFB_CPL_G220             <== End-MLFB
            HMK_CB_UL_MLFB_TYPE_1011270		Ausführung des Anschlusses
            HMK_CB_UL_R_ICU_480V_1011270	Ausschaltvermögen Grenzkurzschlussstrom (Icu) bei 480 V AC Bemessungswert
             nn HMK_CB_UL_MLFB_C_1011270		  HMK_CB_UL_MLFB_C_G220
            HMK_CB_UL_MLFB_1011270			  HMK_CB_UL_MLFB_G220                 <== Platzhalter-MLFB
            HMK_CB_UL_RC_1011270			    Bemessungsstrom

        B  VT_G220_M00615	UL_CSA_CIRCUIT_BREAKER
            HMK_CB_UL_G_CAPTION_1011270	Leistungsschalter
            HMK_MOTORNORM_G220					Motornorm
            HMK_VALUE_VALID_G220				Flag: Eintrag ist gültig
            PMD_ABJ176_001_000_G220			Schutzart IP
            HMK_CB_UL_SCCR_1011410_X		Bedingter Kurzschlussstrom SCCR
            HMK_CB_UL_MLFB_1011270			HMK_CB_UL_MLFB_G220                   <== Platzhalter-MLFB
             nn HMK_CB_UL_MEV_FT_1011410_X	HMK_CB_UL_MEV_FT_G220
             nn HMK_CB_UL_MEV_1011410_X			HMK_CB_UL_MEV_G220
            HMK_VOLTAGE_PW_KEY_1011270	Voltage_Power Key
            HMK_TOPOLOGY_G220					  HMK_TOPOLOGY_G220
            HMK_REP_SWITCH__G220				Wartungsschalter
             nn HMK_CB_UL_SCCR_V_1011270_X	    HMK_CB_UL_SCCR_V_G220
             nn HMK_CB_UL_SCCR_V_SL_1011270	    HMK_CB_UL_SCCR_V_SL_G220
            HMK_CB_UL_SCCR_SLASH_1011270_X	Bedingter Kurzschlussstrom SCCR (schräg-Spannung)
            HMK_CB_UL_VOLTAGE_R_1011270		  Betriebsspannung
      */

      // Basis-SQL-String für JOIN-Query

      var HMK_CB_UL_VOLTAGE_R_1011270 = ECL_GetValue("HMK_CB_UL_VOLTAGE_R_1011270");

      var sTableA = "VT_G220_M00601" + sDB_Suffix;
      var sTableB = "VT_G220_M00615" + sDB_Suffix;
      var sSQL_CB_BASIS_UL =
        "SELECT " +
        "VT_TABLE_A.*, " +
        "VT_TABLE_B.HMK_CB_UL_SCCR_1011410_X, " +
        "VT_TABLE_B.HMK_CB_UL_SCCR_SLASH_1011270_X, " +
        "VT_TABLE_B.HMK_CB_UL_VOLTAGE_R_1011270 " +
        "FROM " + sTableA + " As VT_TABLE_A " +
        "INNER JOIN " + sTableB + " As VT_TABLE_B " +
        "ON VT_TABLE_A.HMK_CB_UL_MLFB_1011270 = VT_TABLE_B.HMK_CB_UL_MLFB_1011270 " +
        "WHERE " +
        "VT_TABLE_B.HMK_MOTORNORM_G220 = '" + HMK_MOTORNORM_G220 + "' AND " +
        "VT_TABLE_B.PMD_ABJ176_001_000_G220 = '" + PMD_ABJ176_001_000_G220 + "' AND " +
        "VT_TABLE_B.HMK_VOLTAGE_PW_KEY_1011270 = '" + HMK_VOLTAGE_PW_KEY_1011270 + "' AND " +
        "VT_TABLE_B.HMK_TOPOLOGY_G220 = '" + HMK_TOPOLOGY_G220 + "' AND " +
        "VT_TABLE_B.HMK_REP_SWITCH__G220 = '" + HMK_REP_SWITCH__G220 + "' AND " +
        "VT_TABLE_B.HMK_CB_UL_VOLTAGE_R_1011270 = '" + HMK_CB_UL_VOLTAGE_R_1011270 + "' AND " +
        "VT_TABLE_B.HMK_CB_UL_G_CAPTION_1011270 = 'T' AND " +
        "VT_TABLE_B.HMK_VALUE_VALID_G220 = 'T' ";

      var sSQL = sSQL_CB_BASIS_UL + ";";
      var aResult = GetDBDataSetEXT(sSQL);
      if (aResult && aResult.length > 0) {
        // mögliche Werte für  HMK_CB_UL_RC_1011270			    Bemessungsstrom 
        ECL_DeactivateAllAttributeValues("HMK_CB_UL_RC_1011270");

        for (var i = 0; i < aResult.length; i++) {
          ECL_ActivateValue("HMK_CB_UL_RC_1011270", aResult[i].HMK_CB_UL_RC_1011270);
        }
        ExecSetStandardifValueEmpty("HMK_CB_UL_RC_1011270", "");
      } else {
        strError = "DICT1_ERR_G220___PL_CB_UL";
        return strError;
      }

      // weitere Eingrenzungen
      /*    HMK_CB_UL_VOLTAGE_R_1011270		Betriebsspannung                      <==== nicht einschränken
            HMK_CB_UL_SCCR_1011410_X		  Bedingter Kurzschlussstrom SCCR
            HMK_CB_UL_SCCR_SLASH_1011270_X	Bedingter Kurzschlussstrom SCCR (schräg-Spannung)
            HMK_CB_UL_R_ICU_480V_1011270	Ausschaltvermögen Grenzkurzschlussstrom (Icu) bei 480 V AC Bemessungswert
            HMK_CB_UL_OC_RELEASE_1011270	Ausführung des Überstromauslösers
            HMK_CB_UL_MLFB_TYPE_1011270		Ausführung des Anschlusses
      */
      // ------------------------------------------------------------------------------------
      // HMK_CB_UL_SCCR_1011410_X		  Bedingter Kurzschlussstrom SCCR
      // ------------------------------------------------------------------------------------
      if (HMK_CB_UL_VOLTAGE_R_1011270 == "00002") {
        var sTargetAttribute = "HMK_CB_UL_SCCR_1011410_X";

        var HMK_CB_UL_RC_1011270 = ECL_GetValue("HMK_CB_UL_RC_1011270");

        var sSQL = sSQL_CB_BASIS_UL + "AND HMK_CB_UL_RC_1011270 = " + HMK_CB_UL_RC_1011270 + ";";

        var aResult = GetDBDataSetEXT(sSQL);
        if (aResult && aResult.length > 0) {
          // mögliche Werte für
          /*  HMK_CB_UL_RC_1011270			    Bemessungsstrom
              HMK_CB_UL_VOLTAGE_R_1011270		Betriebsspannung                      <==== nicht einschränken
            x HMK_CB_UL_SCCR_1011410_X		  Bedingter Kurzschlussstrom SCCR
              HMK_CB_UL_SCCR_SLASH_1011270_X	Bedingter Kurzschlussstrom SCCR (schräg-Spannung)
              HMK_CB_UL_R_ICU_480V_1011270	Ausschaltvermögen Grenzkurzschlussstrom (Icu) bei 480 V AC Bemessungswert
              HMK_CB_UL_OC_RELEASE_1011270	Ausführung des Überstromauslösers
              HMK_CB_UL_MLFB_TYPE_1011270		Ausführung des Anschlusses
          */

          ECL_DeactivateAllAttributeValues(sTargetAttribute);

          for (var i = 0; i < aResult.length; i++) {
            var sValue = aResult[i][sTargetAttribute];
            ECL_ActivateValue(sTargetAttribute, sValue);
          }
          ExecSetStandardifValueEmpty(sTargetAttribute, "");
        } else {
          strError = "DICT1_ERR_G220___PL_CB_UL";
          return strError;
        }
      } else if (HMK_CB_UL_VOLTAGE_R_1011270 == "00003") {
        var sTargetAttribute = "HMK_CB_UL_SCCR_SLASH_1011270_X";

        var HMK_CB_UL_RC_1011270 = ECL_GetValue("HMK_CB_UL_RC_1011270");

        var sSQL = sSQL_CB_BASIS_UL + "AND HMK_CB_UL_RC_1011270 = " + HMK_CB_UL_RC_1011270 + ";";

        var aResult = GetDBDataSetEXT(sSQL);
        if (aResult && aResult.length > 0) {
          // mögliche Werte für
          /*  HMK_CB_UL_RC_1011270			    Bemessungsstrom
              HMK_CB_UL_VOLTAGE_R_1011270		Betriebsspannung                      <==== nicht einschränken
              HMK_CB_UL_SCCR_1011410_X		  Bedingter Kurzschlussstrom SCCR
            x HMK_CB_UL_SCCR_SLASH_1011270_X	Bedingter Kurzschlussstrom SCCR (schräg-Spannung)
              HMK_CB_UL_R_ICU_480V_1011270	Ausschaltvermögen Grenzkurzschlussstrom (Icu) bei 480 V AC Bemessungswert
              HMK_CB_UL_OC_RELEASE_1011270	Ausführung des Überstromauslösers
              HMK_CB_UL_MLFB_TYPE_1011270		Ausführung des Anschlusses
          */

          ECL_DeactivateAllAttributeValues(sTargetAttribute);

          for (var i = 0; i < aResult.length; i++) {
            var sValue = aResult[i][sTargetAttribute];
            ECL_ActivateValue(sTargetAttribute, sValue);
          }
          ExecSetStandardifValueEmpty(sTargetAttribute, "");
        } else {
          strError = "DICT1_ERR_G220___PL_CB_UL";
          return strError;
        }
      }
      // ------------------------------------------------------------------------------------
      // HMK_CB_UL_R_ICU_480V_1011270	Ausschaltvermögen Grenzkurzschlussstrom (Icu) bei 480 V AC Bemessungswert
      // ------------------------------------------------------------------------------------
      var sTargetAttribute = "HMK_CB_UL_R_ICU_480V_1011270";

      var HMK_CB_UL_SCCR_1011410_X = ECL_GetValue("HMK_CB_UL_SCCR_1011410_X");
      var HMK_CB_UL_SCCR_SLASH_1011270_X = ECL_GetValue("HMK_CB_UL_SCCR_SLASH_1011270_X");

      var sSQL = sSQL_CB_BASIS_UL + "AND HMK_CB_UL_RC_1011270 = " + HMK_CB_UL_RC_1011270 + " AND ";
      if (HMK_CB_UL_VOLTAGE_R_1011270 == "00002") {
        sSQL += "HMK_CB_UL_SCCR_1011410_X = '" + HMK_CB_UL_SCCR_1011410_X + "';";
      } else {
        sSQL += "HMK_CB_UL_SCCR_SLASH_1011270_X = '" + HMK_CB_UL_SCCR_SLASH_1011270_X + "';";
      }

      var aResult = GetDBDataSetEXT(sSQL);
      if (aResult && aResult.length > 0) {
        // mögliche Werte für
        /*  HMK_CB_UL_RC_1011270			    Bemessungsstrom
            HMK_CB_UL_VOLTAGE_R_1011270		Betriebsspannung                      <==== nicht einschränken
            HMK_CB_UL_SCCR_1011410_X		  Bedingter Kurzschlussstrom SCCR
            HMK_CB_UL_SCCR_SLASH_1011270_X	Bedingter Kurzschlussstrom SCCR (schräg-Spannung)
          x  HMK_CB_UL_R_ICU_480V_1011270	Ausschaltvermögen Grenzkurzschlussstrom (Icu) bei 480 V AC Bemessungswert
            HMK_CB_UL_OC_RELEASE_1011270	Ausführung des Überstromauslösers
            HMK_CB_UL_MLFB_TYPE_1011270		Ausführung des Anschlusses
        */

        ECL_DeactivateAllAttributeValues(sTargetAttribute);

        for (var i = 0; i < aResult.length; i++) {
          var sValue = aResult[i][sTargetAttribute];
          ECL_ActivateValue(sTargetAttribute, sValue);
        }
        ExecSetStandardifValueEmpty(sTargetAttribute, "");
      } else {
        strError = "DICT1_ERR_G220___PL_CB_UL";
        return strError;
      }

      // ------------------------------------------------------------------------------------
      // HMK_CB_UL_OC_RELEASE_1011270
      // ------------------------------------------------------------------------------------
      var sTargetAttribute = "HMK_CB_UL_OC_RELEASE_1011270";

      var HMK_CB_UL_R_ICU_480V_1011270 = ECL_GetValue("HMK_CB_UL_R_ICU_480V_1011270");

      var sSQL =
        sSQL_CB_BASIS_UL +
        "AND HMK_CB_UL_RC_1011270 = " + HMK_CB_UL_RC_1011270 + " AND " +
        "HMK_CB_UL_R_ICU_480V_1011270 = '" + HMK_CB_UL_R_ICU_480V_1011270 + "' AND ";

      if (HMK_CB_UL_VOLTAGE_R_1011270 == "00002") {
        sSQL += "HMK_CB_UL_SCCR_1011410_X = '" + HMK_CB_UL_SCCR_1011410_X + "';";
      } else {
        sSQL += "HMK_CB_UL_SCCR_SLASH_1011270_X = '" + HMK_CB_UL_SCCR_SLASH_1011270_X + "';";
      }

      var aResult = GetDBDataSetEXT(sSQL);
      if (aResult && aResult.length > 0) {
        // mögliche Werte für
        /*  HMK_CB_UL_RC_1011270			    Bemessungsstrom
            HMK_CB_UL_VOLTAGE_R_1011270		Betriebsspannung                      <==== nicht einschränken
            HMK_CB_UL_SCCR_1011410_X		  Bedingter Kurzschlussstrom SCCR
            HMK_CB_UL_SCCR_SLASH_1011270_X	Bedingter Kurzschlussstrom SCCR (schräg-Spannung)
            HMK_CB_UL_R_ICU_480V_1011270	Ausschaltvermögen Grenzkurzschlussstrom (Icu) bei 480 V AC Bemessungswert
          x HMK_CB_UL_OC_RELEASE_1011270	Ausführung des Überstromauslösers
            HMK_CB_UL_MLFB_TYPE_1011270		Ausführung des Anschlusses
        */

        ECL_DeactivateAllAttributeValues(sTargetAttribute);

        for (var i = 0; i < aResult.length; i++) {
          var sValue = aResult[i][sTargetAttribute];
          ECL_ActivateValue(sTargetAttribute, sValue);
        }
        ExecSetStandardifValueEmpty(sTargetAttribute, "");
      } else {
        strError = "DICT1_ERR_G220___PL_CB_UL";
        return strError;
      }
      // ------------------------------------------------------------------------------------
      // HMK_CB_UL_MLFB_TYPE_1011270		Ausführung des Anschlusses
      // ------------------------------------------------------------------------------------
      var sTargetAttribute = "HMK_CB_UL_MLFB_TYPE_1011270";

      var HMK_CB_UL_OC_RELEASE_1011270 = ECL_GetValue("HMK_CB_UL_OC_RELEASE_1011270");

      var sSQL =
        sSQL_CB_BASIS_UL +
        "AND HMK_CB_UL_RC_1011270 = " + HMK_CB_UL_RC_1011270 + " AND " +
        "HMK_CB_UL_R_ICU_480V_1011270 = '" + HMK_CB_UL_R_ICU_480V_1011270 + "' AND " +
        "HMK_CB_UL_OC_RELEASE_1011270 = '" + HMK_CB_UL_OC_RELEASE_1011270 + "' AND ";

      if (HMK_CB_UL_VOLTAGE_R_1011270 == "00002") {
        sSQL += "HMK_CB_UL_SCCR_1011410_X = '" + HMK_CB_UL_SCCR_1011410_X + "';";
      } else {
        sSQL += "HMK_CB_UL_SCCR_SLASH_1011270_X = '" + HMK_CB_UL_SCCR_SLASH_1011270_X + "';";
      }

      var aResult = GetDBDataSetEXT(sSQL);
      if (aResult && aResult.length > 0) {
        // mögliche Werte für
        /*  HMK_CB_UL_RC_1011270			    Bemessungsstrom
            HMK_CB_UL_VOLTAGE_R_1011270		Betriebsspannung                      <==== nicht einschränken
            HMK_CB_UL_SCCR_1011410_X		  Bedingter Kurzschlussstrom SCCR
            HMK_CB_UL_SCCR_SLASH_1011270_X	Bedingter Kurzschlussstrom SCCR (schräg-Spannung)
            HMK_CB_UL_R_ICU_480V_1011270	Ausschaltvermögen Grenzkurzschlussstrom (Icu) bei 480 V AC Bemessungswert
            HMK_CB_UL_OC_RELEASE_1011270	Ausführung des Überstromauslösers
          x HMK_CB_UL_MLFB_TYPE_1011270		Ausführung des Anschlusses
        */

        ECL_DeactivateAllAttributeValues(sTargetAttribute);

        for (var i = 0; i < aResult.length; i++) {
          var sValue = aResult[i][sTargetAttribute];
          ECL_ActivateValue(sTargetAttribute, sValue);
        }
        ExecSetStandardifValueEmpty(sTargetAttribute, "");
      } else {
        strError = "DICT1_ERR_G220___PL_CB_UL";
        return strError;
      }

      // ------------------------------------------------------------------------------------
      // HMK_CB_UL_SCCR_SLASH_1011270_X Bedingter Kurzschlussstrom SCCR (schräg-Spannung) nur Info! 
      // ------------------------------------------------------------------------------------
      /** / nur info, da gerad/schräg-Spannung nicht reproduzierbar!
      
      // ------------------------------------------------------------------------------------
      // MLFB CB UL bestimmen
      // ------------------------------------------------------------------------------------
      /*
        HMK_CB_UL_RC_1011270			    Bemessungsstrom
        HMK_CB_UL_VOLTAGE_R_1011270		Betriebsspannung                      <==== nicht einschränken
        HMK_CB_UL_SCCR_1011410_X		  Bedingter Kurzschlussstrom SCCR
        HMK_CB_UL_SCCR_SLASH_1011270_X	Bedingter Kurzschlussstrom SCCR (schräg-Spannung)
        HMK_CB_UL_R_ICU_480V_1011270	Ausschaltvermögen Grenzkurzschlussstrom (Icu) bei 480 V AC Bemessungswert
        HMK_CB_UL_OC_RELEASE_1011270	Ausführung des Überstromauslösers
        HMK_CB_UL_MLFB_TYPE_1011270		Ausführung des Anschlusses
      */
      var HMK_CB_UL_RC_1011270 = ECL_GetValue("HMK_CB_UL_RC_1011270");
      var HMK_CB_UL_VOLTAGE_R_1011270 = ECL_GetValue("HMK_CB_UL_VOLTAGE_R_1011270");
      var HMK_CB_UL_SCCR_1011410_X = ECL_GetValue("HMK_CB_UL_SCCR_1011410_X");
      var HMK_CB_UL_SCCR_SLASH_1011270_X = ECL_GetValue("HMK_CB_UL_SCCR_SLASH_1011270_X");
      var HMK_CB_UL_R_ICU_480V_1011270 = ECL_GetValue("HMK_CB_UL_R_ICU_480V_1011270");
      var HMK_CB_UL_OC_RELEASE_1011270 = ECL_GetValue("HMK_CB_UL_OC_RELEASE_1011270");
      var HMK_CB_UL_MLFB_TYPE_1011270 = ECL_GetValue("HMK_CB_UL_MLFB_TYPE_1011270");

      var sTableA = "VT_G220_M00601" + sDB_Suffix;
      var sTableB = "VT_G220_M00615" + sDB_Suffix;
      var sSQL =
        "SELECT " +
        "VT_TABLE_A.HMK_CB_UL_MLFB_CPL_1011270 FROM " + sTableA + " As VT_TABLE_A " +
        "INNER JOIN " + sTableB + " As VT_TABLE_B " +
        "ON VT_TABLE_A.HMK_CB_UL_MLFB_1011270 = VT_TABLE_B.HMK_CB_UL_MLFB_1011270 " +
        "WHERE " +
        "VT_TABLE_B.HMK_MOTORNORM_G220 = '" + HMK_MOTORNORM_G220 + "' AND " +
        "VT_TABLE_B.PMD_ABJ176_001_000_G220 = '" + PMD_ABJ176_001_000_G220 + "' AND " +
        "VT_TABLE_B.HMK_VOLTAGE_PW_KEY_1011270 = '" + HMK_VOLTAGE_PW_KEY_1011270 + "' AND " +
        "VT_TABLE_B.HMK_TOPOLOGY_G220 = '" + HMK_TOPOLOGY_G220 + "' AND " +
        "VT_TABLE_B.HMK_REP_SWITCH__G220 = '" + HMK_REP_SWITCH__G220 + "' AND " +
        "VT_TABLE_A.HMK_CB_UL_RC_1011270 = '" + HMK_CB_UL_RC_1011270 + "' AND " +
        "VT_TABLE_B.HMK_CB_UL_VOLTAGE_R_1011270 = '" + HMK_CB_UL_VOLTAGE_R_1011270 + "' AND " +
        "VT_TABLE_A.HMK_CB_UL_R_ICU_480V_1011270 = '" + HMK_CB_UL_R_ICU_480V_1011270 + "' AND " +
        "VT_TABLE_A.HMK_CB_UL_OC_RELEASE_1011270 = '" + HMK_CB_UL_OC_RELEASE_1011270 + "' AND " +
        "VT_TABLE_A.HMK_CB_UL_MLFB_TYPE_1011270 = '" + HMK_CB_UL_MLFB_TYPE_1011270 + "' AND " +
        "VT_TABLE_B.HMK_CB_UL_G_CAPTION_1011270 = 'T' AND " +
        "VT_TABLE_B.HMK_VALUE_VALID_G220 = 'T' ";

      if (HMK_CB_UL_VOLTAGE_R_1011270 == "00002") {
        sSQL += "AND " + "VT_TABLE_B.HMK_CB_UL_SCCR_1011410_X = '" + HMK_CB_UL_SCCR_1011410_X + "' ";
      } else {
        sSQL += "AND " + "VT_TABLE_B.HMK_CB_UL_SCCR_SLASH_1011270_X = '" + HMK_CB_UL_SCCR_SLASH_1011270_X + "' ";
      }
      sSQL += "ORDER BY VT_TABLE_A.HMK_CB_UL_MLFB_CPL_1011270 DESC;";

      var aResult = GetDBDataSetEXT(sSQL);
      if (aResult && aResult.length > 0) {
        var HMK_CB_UL_MLFB_CPL_1011270 = aResult[0].HMK_CB_UL_MLFB_CPL_1011270;
        ECL_SetValue("HMK_CB_UL_MLFB_CPL_1011270", HMK_CB_UL_MLFB_CPL_1011270);
      } else {
        strError = "DICT1_ERR_G220___PL_CB_MLFB_UL";
        return strError;
      }
    }
  } else {
    /* UL deaktivieren:
        HMK_CB_UL_RC_1011270			Bemessungsstrom
        HMK_CB_UL_VOLTAGE_R_1011270		Betriebsspannung
        HMK_CB_UL_SCCR_1011410_X		Bedingter Kurzschlussstrom SCCR
        HMK_CB_UL_SCCR_SLASH_1011270_X	Bedingter Kurzschlussstrom SCCR (schräg-Spannung)
        HMK_CB_UL_R_ICU_480V_1011270	Ausschaltvermögen Grenzkurzschlussstrom (Icu) bei 480 V AC Bemessungswert
        HMK_CB_UL_OC_RELEASE_1011270	Ausführung des Überstromauslösers
        HMK_CB_UL_MLFB_TYPE_1011270		Ausführung des Anschlusses
    */
    ECL_DeactivateAttribute("HMK_CB_UL_RC_1011270");
    ECL_DeactivateAttribute("HMK_CB_UL_VOLTAGE_R_1011270");
    ECL_DeactivateAttribute("HMK_CB_UL_SCCR_1011410_X");
    ECL_DeactivateAttribute("HMK_CB_UL_SCCR_SLASH_1011270_X");
    ECL_DeactivateAttribute("HMK_CB_UL_R_ICU_480V_1011270");
    ECL_DeactivateAttribute("HMK_CB_UL_OC_RELEASE_1011270");
    ECL_DeactivateAttribute("HMK_CB_UL_MLFB_TYPE_1011270");
    ECL_SetValue("HMK_CB_UL_MLFB_CPL_1011270", "");

    ECL_ActivateValue("HMK_CB_UL_RC_1011270", 0);
    ECL_ActivateValue("HMK_CB_UL_VOLTAGE_R_1011270", "00001");
    ECL_ActivateValue("HMK_CB_UL_SCCR_1011410_X", ".");
    ECL_ActivateValue("HMK_CB_UL_SCCR_SLASH_1011270_X", ".");
    ECL_ActivateValue("HMK_CB_UL_R_ICU_480V_1011270", 0);
    ECL_ActivateValue("HMK_CB_UL_OC_RELEASE_1011270", "00001");
    ECL_ActivateValue("HMK_CB_UL_MLFB_TYPE_1011270", "00001");

    ECL_SelectValue("HMK_CB_UL_RC_1011270", 0);
    ECL_SelectValue("HMK_CB_UL_VOLTAGE_R_1011270", "00001");
    ECL_SelectValue("HMK_CB_UL_SCCR_1011410_X", ".");
    ECL_SelectValue("HMK_CB_UL_SCCR_SLASH_1011270_X", ".");
    ECL_SelectValue("HMK_CB_UL_R_ICU_480V_1011270", 0);
    ECL_SelectValue("HMK_CB_UL_OC_RELEASE_1011270", "00001");
    ECL_SelectValue("HMK_CB_UL_MLFB_TYPE_1011270", "00001");
    // IEC deaktivieren
    /*
      HMK_CB_IEC_RC_1011510			Bemessungsstrom
      HMK_CB_IEC_ICC_1011270_X		Bedingter Kurzschlussstrom ICC
      HMK_CB_IEC_RATED_ICU_1011270_X	Ausschaltvermögen Grenzkurzschlussstrom (Icu) bei 400 V AC Bemessungswert
      HMK_CB_IEC_OC_RELEAS_1011270	Ausführung des Überstromauslösers
      HMK_CB_IEC_MLFB_TYPE_1011270	Ausführung des Anschlusses    
    */
    ECL_DeactivateAttribute("HMK_CB_IEC_RC_1011510");
    ECL_DeactivateAttribute("HMK_CB_IEC_MAX_C_1011410");
    ECL_DeactivateAttribute("HMK_CB_IEC_ICC_1011270_X");
    ECL_DeactivateAttribute("HMK_CB_IEC_RATED_ICU_1011270_X");
    ECL_DeactivateAttribute("HMK_CB_IEC_OC_RELEAS_1011270");
    ECL_DeactivateAttribute("HMK_CB_IEC_MLFB_TYPE_1011270");

    ECL_SetValue("HMK_CB_IEC_MLFB_CPL_1011270", "");

    ECL_ActivateValue("HMK_CB_IEC_RC_1011510", 0);
    ECL_ActivateValue("HMK_CB_IEC_MAX_C_1011410", 0);
    ECL_ActivateValue("HMK_CB_IEC_ICC_1011270_X", ".");
    ECL_ActivateValue("HMK_CB_IEC_RATED_ICU_1011270_X", ".");
    ECL_ActivateValue("HMK_CB_IEC_OC_RELEAS_1011270", "00001");
    ECL_ActivateValue("HMK_CB_IEC_MLFB_TYPE_1011270", "00001");

    ECL_SelectValue("HMK_CB_IEC_RC_1011510", 0);
    ECL_SelectValue("HMK_CB_IEC_MAX_C_1011410", 0);
    ECL_SelectValue("HMK_CB_IEC_ICC_1011270_X", ".");
    ECL_SelectValue("HMK_CB_IEC_RATED_ICU_1011270_X", ".");
    ECL_SelectValue("HMK_CB_IEC_OC_RELEAS_1011270", "00001");
    ECL_SelectValue("HMK_CB_IEC_MLFB_TYPE_1011270", "00001");
  }
  // ################################################################################################################   ENDE CB
  // ################################################################################################################   ENDE CB
  // ################################################################################################################   ENDE CB

  // ################################################################################################################
  // Motorschutzschalter		CB_MS_G220, CB_MS_UL_G220
  // ################################################################################################################
  /* 
  IEC:
  D	HMK_MS_IEC_MLFB_TYPE_1011270	Ausführung des elektrischen Anschlusses
  A	HMK_MS_IEC_ICC_1011270_X		Bedingter Kurzschlussstrom ICC
  E	HMK_MS_IEC_FS_1011270			Baugröße des Schutzgerätes
  F	HMK_MS_IEC_RATED_ICU_1011270_X	Ausschaltvermögen Grenzkurzschlussstrom (Icu) bei 400 V AC Bemessungswert

  B	HMK_MS_IEC_RC_1011270			Bemessungsstrom
    Hilfs-mlfb: 
  C	HMK_MS_IEC_MLFB_1011270
	
  G	==> HMK_MS_IEC_MLFB_CPL_1011270

    HMK_MS_IEC_MLFB_TYPE_1011270	Ausführung des elektrischen Anschlusses
      VT_G220_M00603	OCPD_IEC_MS_MLFB
          HMK_MS_IEC_ICPMR_REF_1011270	HMK_MS_IEC_ICPMR_REF_G220
          HMK_MS_IEC_RC_1011270			Bemessungsstrom
          HMK_MS_IEC_MLFB_1011270			HMK_MS_IEC_MLFB_G220
          HMK_MS_IEC_MLFB_TYPE_1011270	Ausführung /...Anschlusses
          HMK_MS_IEC_FS_1011270			Baugröße des Schutzgerätes
          HMK_MS_IEC_MLFB_CPL_1011270		HMK_MS_IEC_MLFB_CPL_G220
          HMK_MS_IEC_RATED_ICU_1011270_X	Ausschaltvermög...messungswert

      VT_G220_M00502	ONE_LINE_SIDE_PW_COMPONENT
        HMK_CB_IEC_MLFB_TYPE_1011270	HMK_MS_IEC_MLFB_TYPE_1011270	HMK_MS_UL_MLFB_TYPE_1011270	HMK_FUSE_IEC_RC_1011270_X	HMK_SCFUSE_IEC_RC_1011270_X	HMK_SCFUSE_UL_RC_1011270_X

    HMK_MS_IEC_ICC_1011270_X		Bedingter Kurzschlussstrom ICC
      VT_G220_M00645	IEC_MOTOR_STARTER_PROTECTORS
        HMK_MS_IEC_G_CAPTION_1011270	Motorschutzschalter
        HMK_MOTORNORM_G220	Motornorm
        HMK_MS_IEC_MEV_1011410_X	HMK_MS_IEC_MEV_G220
        HMK_MS_IEC_MEV_FT_1011410_X	HMK_MS_IEC_MEV_FT_G220
        HMK_MS_IEC_MLFB_1011270	HMK_MS_IEC_MLFB_G220
        HMK_VALUE_VALID_G220	Flag: Eintrag ist gültig
        PMD_ABJ176_001_000_G220	Schutzart IP
        HMK_MS_IEC_ICC_1011270_X	Bedingter Kurzschlussstrom ICC
        HMK_VOLTAGE_PW_KEY_1011270	Voltage_Power Key
        HMK_TOPOLOGY_G220	HMK_TOPOLOGY_G220
        HMK_REP_SWITCH__G220	Wartungsschalter
        HMK_MS_IEC_ICC_V_1011270_X	HMK_MS_IEC_ICC_V_G220

      n.n. VT_G220_S00381	HMK_MS_IEC_ICC_1011270
  	
    HMK_MS_IEC_FS_1011270			Baugröße des Schutzgerätes
      VT_G220_M00603	OCPD_IEC_MS_MLFB
          HMK_MS_IEC_ICPMR_REF_1011270	HMK_MS_IEC_ICPMR_REF_G220
          HMK_MS_IEC_RC_1011270			Bemessungsstrom
          HMK_MS_IEC_MLFB_1011270			HMK_MS_IEC_MLFB_G220
          HMK_MS_IEC_MLFB_TYPE_1011270	Ausführung /...Anschlusses
          HMK_MS_IEC_FS_1011270			Baugröße des Schutzgerätes
          HMK_MS_IEC_MLFB_CPL_1011270		HMK_MS_IEC_MLFB_CPL_G220
          HMK_MS_IEC_RATED_ICU_1011270_X	Ausschaltvermög...messungswert
  	
    HMK_MS_IEC_RATED_ICU_1011270_X	Ausschaltvermögen Grenzkurzschlussstrom (Icu) bei 400 V AC Bemessungswert
      VT_G220_M00603	OCPD_IEC_MS_MLFB
      n.n. VT_G220_S00494	HMK_MS_IEC_RATED_ICU_1011270

  UL:
  D	HMK_MS_UL_MLFB_TYPE_1011270		Ausführung des elektrischen Anschlusses
  A	HMK_MS_UL_SCCR_1011410_X		Kurzsschlussfestigkeit (SCCR)
  E	HMK_MS_UL_FS_1011270			Baugröße des CMB	
  F	HMK_MS_UL_RATED_ICU_1011270_X	Ausschaltvermögen Grenzkurzschlussstrom (Icu) des CMB bei 400 V
  C	HMK_MS_UL_RC_1011270			Bemessungsstrom
  new: 
  HMK_MS_UL_VOLTAGE_R_1011270	Betriebsspannung  set fix to 00002
  HMK_MS_UL_SCCR_SL_1011270_X	Kurzsschlussfestigkeit (SCCR) (Schrägspannung), nicht reproduzierbar

  B	HMK_MS_UL_MLFB_1011410 als MS_UL_MLFB_HELPER

  G	==> HMK_MS_UL_MLFB_CPL_1011270

    A	HMK_MS_UL_SCCR_1011410_X		Kurzsschlussfestigkeit (SCCR)
      VT_G220_M00646	UL_CSA_TYPE_E_CMC
          HMK_VALUE_VALID_G220	Flag: Eintrag ist gültig
          HMK_MS_UL_G_CAPTION_1011270	Kombinationsmot.../E
          HMK_MOTORNORM_G220	Motornorm
          PMD_ABJ176_001_000_G220	Schutzart IP
          HMK_VOLTAGE_PW_KEY_1011270	Voltage_Power Key
          HMK_TOPOLOGY_G220	HMK_TOPOLOGY_G220
          HMK_REP_SWITCH__G220	Wartungsschalter
          HMK_MS_UL_SCCR_1011410_X	Kurzsschlussfestigkeit (SCCR)
          HMK_MS_UL_MEV_1011410_X	HMK_MS_UL_MEV_G220
          HMK_MS_UL_SCCR_V_1011270	HMK_MS_UL_SCCR_V_G220
          HMK_MS_UL_MLFB_1011410	HMK_MS_UL_MLFB_G220
          HMK_MS_UL_MEV_FT_1011410_X	HMK_MS_UL_MEV_FT_G220
          HMK_MS_UL_SCCR_V_SL_G220	HMK_MS_UL_SCCR_V_SL_G220
          HMK_MS_UL_SCCR_SL_1011270_X	Kurzsschlussfestigkeit (SCCR)
          HMK_MS_UL_VOLTAGE_R_1011270	Betriebsspannung

    C 	HMK_MS_UL_RC_1011270			Bemessungsstrom
          VT_G220_M00602	OCPD_UL_MS_MLFB
            HMK_MS_UL_MLFB_1011410	HMK_MS_UL_MLFB_G220
            HMK_MS_UL_FS_1011270	Baugröße des CMB
            HMK_MS_UL_RATED_ICU_1011270_X	Ausschaltvermög.../V
            HMK_MS_UL_RC_1011270	Bemessungsstrom
            HMK_MS_UL_MOTPWR_1011270	HMK_MS_UL_MOTPWR_G220
            HMK_MS_UL_MLFB_CPL_1011270	HMK_MS_UL_MLFB_CPL_G220
            HMK_MS_UL_MLFB_TYPE_1011270	Ausführung /...Anschlusses
    
    HMK_MS_UL_MLFB_TYPE_1011270		Ausführung des elektrischen Anschlusses
      VT_G220_M00602	OCPD_UL_MS_MLFB

      VT_G220_M00502	ONE_LINE_SIDE_PW_COMPONENT

  */
  bMS_possible = false;
  if (HMK_MOTORNORM_G220 == "00002") {
    ECL_ActivateAttribute("CB_MS_G220");
    if (ECL_ValueSelected("CB_MS_UL_G220", "T")) {
      ECL_SelectValue("CB_MS_G220", "T");
    }
    ECL_DeselectAttribute("CB_MS_UL_G220");
    ECL_DeactivateAttribute("CB_MS_UL_G220");
    /* VT_G220_M00645	IEC_MOTOR_STARTER_PROTECTORS
        HMK_MS_IEC_G_CAPTION_1011270	Motorschutzschalter
        HMK_MOTORNORM_G220	Motornorm
        HMK_MS_IEC_MEV_1011410_X	HMK_MS_IEC_MEV_G220
        HMK_MS_IEC_MEV_FT_1011410_X	HMK_MS_IEC_MEV_FT_G220
        HMK_MS_IEC_MLFB_1011270	HMK_MS_IEC_MLFB_G220
        HMK_VALUE_VALID_G220	Flag: Eintrag ist gültig
        PMD_ABJ176_001_000_G220	Schutzart IP
        HMK_MS_IEC_ICC_1011270_X	Bedingter Kurzschlussstrom ICC
        HMK_VOLTAGE_PW_KEY_1011270	Voltage_Power Key
        HMK_TOPOLOGY_G220	HMK_TOPOLOGY_G220
        HMK_REP_SWITCH__G220	Wartungsschalter
        HMK_MS_IEC_ICC_V_1011270_X	HMK_MS_IEC_ICC_V_G220
    */
    var sTable = "VT_G220_M00645" + sDB_Suffix;
    var sSQL =
      "SELECT * FROM " + sTable + " WHERE " +
      "HMK_MOTORNORM_G220 = '" + HMK_MOTORNORM_G220 + "' AND " +
      "HMK_VOLTAGE_PW_KEY_1011270 = '" + HMK_VOLTAGE_PW_KEY_1011270 + "' AND " +
      sWhereHMK_MS_IEC_ICC_V_1011270_X + " AND " +
      "HMK_TOPOLOGY_G220 = '" + HMK_TOPOLOGY_G220 + "' AND " +
      "PMD_ABJ176_001_000_G220 = '" + PMD_ABJ176_001_000_G220 + "' AND " +
      "HMK_MS_IEC_MLFB_1011270 <> '-' AND " +
      "HMK_VALUE_VALID_G220 = 'T';";

    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length > 0) {
      bMS_possible = true;
    }
  } else {
    /*VT_G220_M00646	UL_CSA_TYPE_E_CMC
          HMK_VALUE_VALID_G220	Flag: Eintrag ist gültig
          HMK_MS_UL_G_CAPTION_1011270	Kombinationsmot.../E
          HMK_MOTORNORM_G220	Motornorm
          PMD_ABJ176_001_000_G220	Schutzart IP
          HMK_VOLTAGE_PW_KEY_1011270	Voltage_Power Key
          HMK_TOPOLOGY_G220	HMK_TOPOLOGY_G220
          HMK_REP_SWITCH__G220	Wartungsschalter
          HMK_MS_UL_SCCR_1011410_X	Kurzsschlussfestigkeit (SCCR)
          HMK_MS_UL_MEV_1011410_X	HMK_MS_UL_MEV_G220
          HMK_MS_UL_SCCR_V_1011270	HMK_MS_UL_SCCR_V_G220
          HMK_MS_UL_MLFB_1011410	HMK_MS_UL_MLFB_G220
          HMK_MS_UL_MEV_FT_1011410_X	HMK_MS_UL_MEV_FT_G220
          HMK_MS_UL_SCCR_V_SL_G220	HMK_MS_UL_SCCR_V_SL_G220
          HMK_MS_UL_SCCR_SL_1011270_X	Kurzsschlussfestigkeit (SCCR)
          HMK_MS_UL_VOLTAGE_R_1011270	Betriebsspannung
    */
    ECL_ActivateAttribute("CB_MS_UL_G220");
    if (ECL_ValueSelected("CB_MS_G220", "T")) {
      ECL_SelectValue("CB_MS_UL_G220", "T");
    }
    ECL_DeselectAttribute("CB_MS_G220");
    ECL_DeactivateAttribute("CB_MS_G220");
    var sTable = "VT_G220_M00646" + sDB_Suffix;
    var sSQL =
      "SELECT * FROM " + sTable + " WHERE " +
      "HMK_MOTORNORM_G220 = '" + HMK_MOTORNORM_G220 + "' AND " +
      "HMK_VOLTAGE_PW_KEY_1011270 = '" + HMK_VOLTAGE_PW_KEY_1011270 + "' AND " +
      "HMK_TOPOLOGY_G220 = '" + HMK_TOPOLOGY_G220 + "' AND " +
      "PMD_ABJ176_001_000_G220 = '" + PMD_ABJ176_001_000_G220 + "' AND " +
      //"HMK_MS_UL_SCCR_1011410_X <> '.' AND " +
      "HMK_MS_UL_MLFB_1011410 <> '-' AND " +
      "HMK_VALUE_VALID_G220 = 'T';";

    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length > 0) {
      bMS_possible = true;
    }
  }
  if (!bMS_possible) {
    ECL_DisableAttribute("CB_MS_G220");
  }
  if (ECL_ValueSelected("CB_MS_G220", "T") || ECL_ValueSelected("CB_MS_UL_G220", "T")) {
    // nur eine netzseitige Leistungskomponente (LineSidePwComp) zulaessig
    // s.u.

    if (HMK_MOTORNORM_G220 == "00002") {
      // IEC
      ECL_DeactivateAttribute("HMK_MS_UL_MLFB_TYPE_1011270");
      ECL_DeactivateAttribute("HMK_MS_UL_VOLTAGE_R_1011270");
      ECL_DeactivateAttribute("HMK_MS_UL_SCCR_1011410_X");
      ECL_DeactivateAttribute("HMK_MS_UL_SCCR_SL_1011270_X");
      ECL_DeactivateAttribute("HMK_MS_UL_FS_1011270");
      ECL_DeactivateAttribute("HMK_MS_UL_RATED_ICU_1011270_X");
      ECL_DeactivateAttribute("HMK_MS_UL_RC_1011270");
      ECL_SetValue("HMK_MS_UL_MLFB_CPL_1011270", "");

      ECL_ActivateAttribute("HMK_MS_IEC_MLFB_TYPE_1011270");
      ECL_ActivateAttribute("HMK_MS_IEC_ICC_1011270_X");
      ECL_ActivateAttribute("HMK_MS_IEC_FS_1011270");
      ECL_ActivateAttribute("HMK_MS_IEC_RATED_ICU_1011270_X");
      ECL_ActivateAttribute("HMK_MS_IEC_RC_1011270");

      ECL_ActivateAllAttributeValues("HMK_MS_IEC_MLFB_TYPE_1011270");
      ECL_ActivateAllAttributeValues("HMK_MS_IEC_ICC_1011270_X");
      ECL_ActivateAllAttributeValues("HMK_MS_IEC_FS_1011270");
      ECL_ActivateAllAttributeValues("HMK_MS_IEC_RATED_ICU_1011270_X");
      ECL_ActivateAllAttributeValues("HMK_MS_IEC_RC_1011270");

      ECL_DeactivateValue("HMK_MS_IEC_MLFB_TYPE_1011270", "00003");
      ECL_DeactivateValue("HMK_MS_IEC_ICC_1011270_X", ".");
      ECL_DeactivateValue("HMK_MS_IEC_FS_1011270", "00001");
      ECL_DeactivateValue("HMK_MS_IEC_RATED_ICU_1011270_X", ".");
      ECL_DeactivateValue("HMK_MS_IEC_RC_1011270", 0);

      ExecSetStandardifValueEmpty("HMK_MS_IEC_MLFB_TYPE_1011270", "00001");
      // ------------------------------------------------------------------------------------
      var sTableA = "VT_G220_M00645" + sDB_Suffix;
      var sTableB = "VT_G220_M00603" + sDB_Suffix;
      var sSQL_JOIN_Basic_MS_IEC =
        "SELECT " + sTableA + ".* , " + sTableB + ".* FROM " + sTableA +
        " INNER JOIN " + sTableB +
        " ON " + sTableA + ".HMK_MS_IEC_MLFB_1011270 = " + sTableB + ".HMK_MS_IEC_MLFB_1011270" +
        " WHERE " +
        sTableB + ".HMK_MS_IEC_MLFB_TYPE_1011270 <> '00003' AND " +
        sTableA + ".HMK_MOTORNORM_G220 = '" + HMK_MOTORNORM_G220 + "' AND " +
        sTableA + ".HMK_VOLTAGE_PW_KEY_1011270 = '" + HMK_VOLTAGE_PW_KEY_1011270 + "' AND " +
        sWhereHMK_MS_IEC_ICC_V_1011270_X + " AND " +
        sTableA + ".HMK_TOPOLOGY_G220 = '" + HMK_TOPOLOGY_G220 + "' AND " +
        sTableA + ".HMK_REP_SWITCH__G220 = '" + HMK_REP_SWITCH__G220 + "' AND " +
        sTableA + ".PMD_ABJ176_001_000_G220 = '" + PMD_ABJ176_001_000_G220 + "' AND " +
        sTableA + ".HMK_MS_IEC_G_CAPTION_1011270 = 'T' AND " +
        sTableA + ".HMK_VALUE_VALID_G220 = 'T' ";

      // -------------------------------------------------------------------------------------------
      // 1. rated current HMK_MS_IEC_RC_1011270
      // -------------------------------------------------------------------------------------------
      var sTargetAttribute = "HMK_MS_IEC_RC_1011270";

      var aResult = GetDBDataSetEXT(sSQL_JOIN_Basic_MS_IEC + ";");
      if (aResult.length > 0) {
        ECL_DeactivateAllAttributeValues(sTargetAttribute);
        for (var i = 0; i < aResult.length; i++) {
          ECL_ActivateValue(sTargetAttribute, aResult[i][sTargetAttribute]);
        }
      } else {
        //if (sStatus == "Error") {
        strError = "DICT1_ERR_G220___PL_MS_IEC_RC";
        return strError;
      }
      ExecSetStandardifValueEmpty(sTargetAttribute, "");
      var HMK_MS_IEC_RC_1011270 = ECL_GetValue("HMK_MS_IEC_RC_1011270");
      // -------------------------------------------------------------------------------------------
      // 2. HMK_MS_IEC_ICC_1011270_X	Bedingter Kurzschlussstrom ICC	Conditional short-circuit current ICC
      // -------------------------------------------------------------------------------------------
      var sTargetAttribute = "HMK_MS_IEC_ICC_1011270_X";

      var sSQL = sSQL_JOIN_Basic_MS_IEC + " AND " +
        "HMK_MS_IEC_RC_1011270 = " + HMK_MS_IEC_RC_1011270 + ";";

      var aResult = GetDBDataSetEXT(sSQL);
      if (aResult.length > 0) {
        ECL_DeactivateAllAttributeValues(sTargetAttribute);
        for (var i = 0; i < aResult.length; i++) {
          ECL_ActivateValue(sTargetAttribute, aResult[i][sTargetAttribute]);
        }
      } else {
        strError = "DICT1_ERR_G220___PL_MS_IEC_ICC";
        return strError;
      }
      // ------------------------------------------------------------------------------------
      ExecSetStandardifValueEmpty(sTargetAttribute, "");
      var HMK_MS_IEC_ICC_1011270_X = ECL_GetValue("HMK_MS_IEC_ICC_1011270_X");

      // ------------------------------------------------------------------------------------
      // 3. HMK_MS_IEC_RATED_ICU_1011270_X	Ausschaltvermögen Grenzkurzschlussstrom (Icu) bei 400 V AC Bemessungswert	
      //    Breaking capacity maximum short-circuit current (Icu) at 400 V AC rated value
      // ------------------------------------------------------------------------------------
      // ------------------------------------------------------------------------------------
      // F HMK_MS_IEC_RATED_ICU_1011270_X	Ausschaltvermögen Grenzkurzschlussstrom (Icu) bei 400 V AC Bemessungswert
      // ------------------------------------------------------------------------------------
      var sTargetAttribute = "HMK_MS_IEC_RATED_ICU_1011270_X";

      var sSQL = sSQL_JOIN_Basic_MS_IEC + " AND " +
        "HMK_MS_IEC_RC_1011270 = " + HMK_MS_IEC_RC_1011270 + " AND " +
        "HMK_MS_IEC_ICC_1011270_X = '" + HMK_MS_IEC_ICC_1011270_X + "';";

      var aResult = GetDBDataSetEXT(sSQL);
      if (aResult.length > 0) {
        ECL_DeactivateAllAttributeValues(sTargetAttribute);
        for (var i = 0; i < aResult.length; i++) {
          ECL_ActivateValue(sTargetAttribute, aResult[i][sTargetAttribute]);
        }
      } else {
        strError = "DICT1_ERR_G220___PL_MS_IEC_RATED_ICU";
        return strError;
      }
      ExecSetStandardifValueEmpty(sTargetAttribute, "");
      var HMK_MS_IEC_RATED_ICU_1011270_X = ECL_GetValue("HMK_MS_IEC_RATED_ICU_1011270_X");
      // ------------------------------------------------------------------------------------

      // ------------------------------------------------------------------------------------
      // 4. E HMK_MS_IEC_FS_1011270			Baugröße des Schutzgerätes
      // ------------------------------------------------------------------------------------
      var sTargetAttribute = "HMK_MS_IEC_FS_1011270";

      var sSQL = sSQL_JOIN_Basic_MS_IEC + " AND " +
        "HMK_MS_IEC_RC_1011270 = " + HMK_MS_IEC_RC_1011270 + " AND " +
        "HMK_MS_IEC_ICC_1011270_X = '" + HMK_MS_IEC_ICC_1011270_X + "' AND " +
        "HMK_MS_IEC_RATED_ICU_1011270_X = '" + HMK_MS_IEC_RATED_ICU_1011270_X + "';";

      var aResult = GetDBDataSetEXT(sSQL);
      if (aResult.length > 0) {
        ECL_DeactivateAllAttributeValues(sTargetAttribute);
        for (var i = 0; i < aResult.length; i++) {
          ECL_ActivateValue(sTargetAttribute, aResult[i][sTargetAttribute]);
        }
      } else {
        strError = "DICT1_ERR_G220___PL_MS_IEC_FS";
        return strError;
      }
      ExecSetStandardifValueEmpty(sTargetAttribute, "");
      var HMK_MS_IEC_FS_1011270 = ECL_GetValue("HMK_MS_IEC_FS_1011270");
      // -------------------------------------------------------------------------------------------


      // ------------------------------------------------------------------------------------
      // D HMK_MS_IEC_MLFB_TYPE_1011270	Ausführung des elektrischen Anschlusses
      // ------------------------------------------------------------------------------------
      var sTargetAttribute = "HMK_MS_IEC_MLFB_TYPE_1011270";

      var sSQL = sSQL_JOIN_Basic_MS_IEC + " AND " +
        "HMK_MS_IEC_RC_1011270 = " + HMK_MS_IEC_RC_1011270 + " AND " +
        "HMK_MS_IEC_ICC_1011270_X = '" + HMK_MS_IEC_ICC_1011270_X + "' AND " +
        "HMK_MS_IEC_RATED_ICU_1011270_X = '" + HMK_MS_IEC_RATED_ICU_1011270_X + "' AND " +
        "HMK_MS_IEC_FS_1011270 = '" + HMK_MS_IEC_FS_1011270 + "';";

      var aResult = GetDBDataSetEXT(sSQL);
      if (aResult.length > 0) {
        ECL_DeactivateAllAttributeValues(sTargetAttribute);
        for (var i = 0; i < aResult.length; i++) {
          ECL_ActivateValue(sTargetAttribute, aResult[i][sTargetAttribute]);
        }
      } else {
        strError = "DICT1_ERR_G220___PL_MS_IEC_MLFB_TYPE";
        return strError;
      }
      ExecSetStandardifValueEmpty(sTargetAttribute, "");
      var HMK_MS_IEC_MLFB_TYPE_1011270 = ECL_GetValue("HMK_MS_IEC_MLFB_TYPE_1011270");
      // -------------------------------------------------------------------------------------------

      // ------------------------------------------------------------------------------------
      // G Bestimme SEC-MLFB HMK_MS_IEC_MLFB_CPL_1011270
      // ------------------------------------------------------------------------------------

      var sSQL = sSQL_JOIN_Basic_MS_IEC + " AND " +
        "HMK_MS_IEC_RC_1011270 = " + HMK_MS_IEC_RC_1011270 + " AND " +
        "HMK_MS_IEC_ICC_1011270_X = '" + HMK_MS_IEC_ICC_1011270_X + "' AND " +
        "HMK_MS_IEC_RATED_ICU_1011270_X = '" + HMK_MS_IEC_RATED_ICU_1011270_X + "' AND " +
        "HMK_MS_IEC_FS_1011270 = '" + HMK_MS_IEC_FS_1011270 + "' AND " +
        "HMK_MS_IEC_MLFB_TYPE_1011270 = '" + HMK_MS_IEC_MLFB_TYPE_1011270 + "';";

      var aResult = GetDBDataSetEXT(sSQL);
      if (aResult.length > 0) {
        var HMK_MS_IEC_MLFB_CPL_1011270 = aResult[0].HMK_MS_IEC_MLFB_CPL_1011270;
        ECL_SetValue("HMK_MS_IEC_MLFB_CPL_1011270", HMK_MS_IEC_MLFB_CPL_1011270);
      } else {
        strError = "DICT1_ERR_G220___PL_GET_MS_MLFB";
        return strError;
      }
    } else {
      // ################################################################################################################
      // (HMK_MOTORNORM_G220 == "00001") // NEMA
      // ################################################################################################################
      ECL_ActivateAttribute("HMK_MS_UL_MLFB_TYPE_1011270");
      ECL_ActivateAttribute("HMK_MS_UL_VOLTAGE_R_1011270");
      ECL_ActivateAttribute("HMK_MS_UL_SCCR_1011410_X");
      ECL_ActivateAttribute("HMK_MS_UL_SCCR_SL_1011270_X");
      ECL_ActivateAttribute("HMK_MS_UL_FS_1011270");
      ECL_ActivateAttribute("HMK_MS_UL_RATED_ICU_1011270_X");
      ECL_ActivateAttribute("HMK_MS_UL_RC_1011270");

      ECL_ActivateAllAttributeValues("HMK_MS_UL_MLFB_TYPE_1011270");
      ECL_ActivateAllAttributeValues("HMK_MS_UL_SCCR_1011410_X");
      ECL_ActivateAllAttributeValues("HMK_MS_UL_FS_1011270");
      ECL_ActivateAllAttributeValues("HMK_MS_UL_RATED_ICU_1011270_X");
      ECL_ActivateAllAttributeValues("HMK_MS_UL_RC_1011270");
      ECL_ActivateAllAttributeValues("HMK_MS_UL_VOLTAGE_R_1011270");

      ECL_DeactivateValue("HMK_MS_UL_MLFB_TYPE_1011270", "00003");
      ECL_DeactivateValue("HMK_MS_UL_SCCR_1011410_X", ".");
      ECL_DeactivateValue("HMK_MS_UL_FS_1011270", "00001");
      ECL_DeactivateValue("HMK_MS_UL_RATED_ICU_1011270_X", ".");
      ECL_DeactivateValue("HMK_MS_UL_RC_1011270", 0);
      ECL_DeactivateValue("HMK_MS_UL_VOLTAGE_R_1011270", "00001");

      ECL_DeactivateAttribute("HMK_MS_IEC_MLFB_TYPE_1011270");
      ECL_DeactivateAttribute("HMK_MS_IEC_ICC_1011270_X");
      ECL_DeactivateAttribute("HMK_MS_IEC_FS_1011270");
      ECL_DeactivateAttribute("HMK_MS_IEC_RATED_ICU_1011270_X");
      ECL_DeactivateAttribute("HMK_MS_IEC_RC_1011270");

      // check for straight and/or slash voltage
      // HMK_MS_UL_VOLTAGE_R_1011270
      var sTargetAttribute = "HMK_MS_UL_VOLTAGE_R_1011270";

      var sTable = "VT_G220_M00646" + sDB_Suffix;
      var sWhere =
        "HMK_MOTORNORM_G220 = '" + HMK_MOTORNORM_G220 + "' AND " +
        "HMK_VOLTAGE_PW_KEY_1011270 = '" + HMK_VOLTAGE_PW_KEY_1011270 + "' AND " +
        "HMK_TOPOLOGY_G220 = '" + HMK_TOPOLOGY_G220 + "' AND " +
        "PMD_ABJ176_001_000_G220 = '" + PMD_ABJ176_001_000_G220 + "' AND " +
        //"HMK_MS_UL_SCCR_1011410_X <> '.' AND " +
        "HMK_VALUE_VALID_G220 = 'T';";

      var sStatus = SetAttributeLogic2nd(sTable, sTargetAttribute, sWhere);

      if (sStatus == "Error") {
        strError = "DICT1_ERR_G220___PL_MS_UL_VOLTAGE_R";
        return strError;
      }
      var aValidValues_VOLTAGE_R = ECL_GetAllActiveAttributeValues(sTargetAttribute);

      if (aValidValues_VOLTAGE_R && aValidValues_VOLTAGE_R.indexOf("00002") > -1 && aValidValues_VOLTAGE_R.indexOf("00003") > -1) {
        // wenn gerad und schrägspannung erlaubt, nur gerad
        ECL_DeactivateValue(sTargetAttribute, "00003");
        ECL_SelectValue(sTargetAttribute, "00002");
      }
      var HMK_MS_UL_VOLTAGE_R_1011270 = ECL_GetValue("HMK_MS_UL_VOLTAGE_R_1011270");

      if (HMK_MS_UL_VOLTAGE_R_1011270 == "00002") {
        // Geradspannung
        ECL_ActivateAttribute("HMK_MS_UL_SCCR_1011410_X");
        ECL_DeactivateAttribute("HMK_MS_UL_SCCR_SL_1011270_X");
      } else {
        // Schrägspannung
        ECL_DeactivateAttribute("HMK_MS_UL_SCCR_1011410_X");
        ECL_ActivateAttribute("HMK_MS_UL_SCCR_SL_1011270_X");
      }

      // neue Lösung JOIN
      /*  VT_G220_M00602	OCPD_UL_MS_MLFB
            HMK_MS_UL_MLFB_1011410	        HMK_MS_UL_MLFB_G220
            HMK_MS_UL_FS_1011270	          Baugröße des CMB
            HMK_MS_UL_RATED_ICU_1011270_X 	Ausschaltvermög.../V
            HMK_MS_UL_RC_1011270	          Bemessungsstrom
            HMK_MS_UL_MOTPWR_1011270	      HMK_MS_UL_MOTPWR_G220
            HMK_MS_UL_MLFB_CPL_1011270	    HMK_MS_UL_MLFB_CPL_G220
            HMK_MS_UL_MLFB_TYPE_1011270	    Ausführung /...Anschlusses
            
          VT_G220_M00646	UL_CSA_TYPE_E_CMC
            HMK_VALUE_VALID_G220	          Flag: Eintrag ist gültig
            HMK_MS_UL_G_CAPTION_1011270	    Kombinationsmot.../E
            HMK_MOTORNORM_G220	            Motornorm
            PMD_ABJ176_001_000_G220	        Schutzart IP
            HMK_VOLTAGE_PW_KEY_1011270	    Voltage_Power Key
            HMK_TOPOLOGY_G220	              HMK_TOPOLOGY_G220
            HMK_REP_SWITCH__G220	          Wartungsschalter
            HMK_MS_UL_SCCR_1011410_X	      Kurzsschlussfestigkeit (SCCR) gerade
          nn  HMK_MS_UL_MEV_1011410_X	        HMK_MS_UL_MEV_G220
            HMK_MS_UL_SCCR_V_1011270	      HMK_MS_UL_SCCR_V_G220
            HMK_MS_UL_MLFB_1011410	        HMK_MS_UL_MLFB_G220
          nn  HMK_MS_UL_MEV_FT_1011410_X	    HMK_MS_UL_MEV_FT_G220
            HMK_MS_UL_SCCR_V_SL_G220	      HMK_MS_UL_SCCR_V_SL_G220
            HMK_MS_UL_SCCR_SL_1011270_X	    Kurzsschlussfestigkeit (SCCR) schräg
            HMK_MS_UL_VOLTAGE_R_1011270	    Betriebsspannung
      */
      var sTableA = "VT_G220_M00602" + sDB_Suffix;
      var sTableB = "VT_G220_M00646" + sDB_Suffix;
      var sSQL_MS_JOIN_BASIC_UL =
        "SELECT * " + "FROM " + sTableA + " As VT_TABLE_A " +
        "INNER JOIN " + sTableB + " As VT_TABLE_B " +
        "ON VT_TABLE_A.HMK_MS_UL_MLFB_1011410 = VT_TABLE_B.HMK_MS_UL_MLFB_1011410 " +
        "WHERE " +
        "VT_TABLE_B.HMK_MOTORNORM_G220 = '" + HMK_MOTORNORM_G220 + "' AND " +
        "VT_TABLE_B.PMD_ABJ176_001_000_G220 = '" + PMD_ABJ176_001_000_G220 + "' AND " +
        "VT_TABLE_B.HMK_VOLTAGE_PW_KEY_1011270 = '" + HMK_VOLTAGE_PW_KEY_1011270 + "' AND " +
        "VT_TABLE_B.HMK_TOPOLOGY_G220 = '" + HMK_TOPOLOGY_G220 + "' AND " +
        "VT_TABLE_B.HMK_REP_SWITCH__G220 = '" + HMK_REP_SWITCH__G220 + "' AND " +
        "VT_TABLE_B.HMK_MS_UL_VOLTAGE_R_1011270 = '" + HMK_MS_UL_VOLTAGE_R_1011270 + "' AND " +
        "VT_TABLE_B.HMK_MS_UL_G_CAPTION_1011270 = 'T' AND " +
        "VT_TABLE_B.HMK_VALUE_VALID_G220 = 'T' ";

      //"VT_TABLE_B.HMK_CB_UL_SCCR_SLASH_1011270_X <> '.' AND " +
      //"VT_TABLE_B.HMK_CB_UL_MEV_1011410_X <> '.' AND " +
      if (HMK_MS_UL_VOLTAGE_R_1011270 == "00002") { // Geradspannung
        sSQL_MS_JOIN_BASIC_UL += " AND VT_TABLE_B.HMK_MS_UL_SCCR_1011410_X <> '.' ";
      } else if (HMK_MS_UL_VOLTAGE_R_1011270 == "00003") { // Schrägspannung
        sSQL_MS_JOIN_BASIC_UL += " AND VT_TABLE_B.HMK_MS_UL_SCCR_SL_1011270_X <> '.' ";
      }

      // ------------------------------------------------------------------------------------
      // 1. HMK_MS_UL_RC_1011270  Bemessungsstrom
      // ------------------------------------------------------------------------------------
      var sSQL = sSQL_MS_JOIN_BASIC_UL + ";";
      var aResult = GetDBDataSetEXT(sSQL);
      if (aResult && aResult.length > 0) {
        // mögliche Werte für  HMK_MS_UL_RC_1011270			    Bemessungsstrom 
        ECL_DeactivateAllAttributeValues("HMK_MS_UL_RC_1011270");

        for (var i = 0; i < aResult.length; i++) {
          ECL_ActivateValue("HMK_MS_UL_RC_1011270", aResult[i].HMK_MS_UL_RC_1011270);
        }
        ExecSetStandardifValueEmpty("HMK_MS_UL_RC_1011270", "");
      } else {
        strError = "DICT1_ERR_G220___PL_MS_UL_RC";
        return strError;
      }
      var HMK_MS_UL_RC_1011270 = ECL_GetValue("HMK_MS_UL_RC_1011270");

      // ------------------------------------------------------------------------------------
      // 2. HMK_MS_UL_VOLTAGE_R_1011270  Betriebsspannung
      // ------------------------------------------------------------------------------------

      // ------------------------------------------------------------------------------------
      // 3.a HMK_MS_UL_SCCR_1011410_X  Kurzsschlussfestigkeit (SCCR) gerade
      // 3.b HMK_MS_UL_SCCR_SL_1011270_X  Kurzsschlussfestigkeit (SCCR) schräg
      // ------------------------------------------------------------------------------------
      var sSQL = sSQL_MS_JOIN_BASIC_UL + " AND " +
        "HMK_MS_UL_RC_1011270 = " + HMK_MS_UL_RC_1011270 + " AND " +
        "HMK_MS_UL_VOLTAGE_R_1011270 = '" + HMK_MS_UL_VOLTAGE_R_1011270 + "';";
      var aResult = GetDBDataSetEXT(sSQL);
      if (HMK_MS_UL_VOLTAGE_R_1011270 == "00002") {
        // Geradspannung
        if (aResult && aResult.length > 0) {
          ECL_DeactivateAllAttributeValues("HMK_MS_UL_SCCR_1011410_X");

          for (var i = 0; i < aResult.length; i++) {
            ECL_ActivateValue("HMK_MS_UL_SCCR_1011410_X", aResult[i].HMK_MS_UL_SCCR_1011410_X);
          }
          ExecSetStandardifValueEmpty("HMK_MS_UL_SCCR_1011410_X", "");
        } else {
          strError = "DICT1_ERR_G220___PL_MS_UL_SCCR";
          return strError;
        }
        var HMK_MS_UL_SCCR_1011410_X = ECL_GetValue("HMK_MS_UL_SCCR_1011410_X");
        var sWhere_SCCR = "HMK_MS_UL_SCCR_1011410_X = '" + HMK_MS_UL_SCCR_1011410_X + "'";
      } else {
        // Schrägspannung
        if (aResult && aResult.length > 0) {
          ECL_DeactivateAllAttributeValues("HMK_MS_UL_SCCR_SL_1011270_X");

          for (var i = 0; i < aResult.length; i++) {
            ECL_ActivateValue("HMK_MS_UL_SCCR_SL_1011270_X", aResult[i].HMK_MS_UL_SCCR_SL_1011270_X);
          }
          ExecSetStandardifValueEmpty("HMK_MS_UL_SCCR_SL_1011270_X", "");
        } else {
          strError = "DICT1_ERR_G220___PL_MS_UL_SCCR";
          return strError;
        }
        var HMK_MS_UL_SCCR_SL_1011270_X = ECL_GetValue("HMK_MS_UL_SCCR_SL_1011270_X");
        var sWhere_SCCR = "HMK_MS_UL_SCCR_SL_1011270_X = '" + HMK_MS_UL_SCCR_SL_1011270_X + "'";
      }
      // ------------------------------------------------------------------------------------
      // 4. HMK_MS_UL_RATED_ICU_1011270_X Ausschaltvermögen Grenzkurzschlussstrom (Icu) bei 400 V AC Bemessungswert
      // ------------------------------------------------------------------------------------
      var sSQL = sSQL_MS_JOIN_BASIC_UL + " AND " +
        "HMK_MS_UL_RC_1011270 = " + HMK_MS_UL_RC_1011270 + " AND " +
        "HMK_MS_UL_VOLTAGE_R_1011270 = '" + HMK_MS_UL_VOLTAGE_R_1011270 + "' AND " +
        sWhere_SCCR + ";";
      var aResult = GetDBDataSetEXT(sSQL);
      if (aResult && aResult.length > 0) {
        ECL_DeactivateAllAttributeValues("HMK_MS_UL_RATED_ICU_1011270_X");

        for (var i = 0; i < aResult.length; i++) {
          ECL_ActivateValue("HMK_MS_UL_RATED_ICU_1011270_X", aResult[i].HMK_MS_UL_RATED_ICU_1011270_X);
        }
        ExecSetStandardifValueEmpty("HMK_MS_UL_RATED_ICU_1011270_X", "");
      } else {
        strError = "DICT1_ERR_G220___PL_MS_UL_RATED_ICU";
        return strError;
      }
      var HMK_MS_UL_RATED_ICU_1011270_X = ECL_GetValue("HMK_MS_UL_RATED_ICU_1011270_X");
      // ------------------------------------------------------------------------------------
      // 5. HMK_MS_UL_FS_1011270  Baugröße des CMB
      // ------------------------------------------------------------------------------------
      var sSQL = sSQL_MS_JOIN_BASIC_UL + " AND " +
        "HMK_MS_UL_RC_1011270 = " + HMK_MS_UL_RC_1011270 + " AND " +
        "HMK_MS_UL_VOLTAGE_R_1011270 = '" + HMK_MS_UL_VOLTAGE_R_1011270 + "' AND " +
        sWhere_SCCR + " AND " +
        "HMK_MS_UL_RATED_ICU_1011270_X = '" + HMK_MS_UL_RATED_ICU_1011270_X + "';";

      var aResult = GetDBDataSetEXT(sSQL);
      if (aResult && aResult.length > 0) {
        ECL_DeactivateAllAttributeValues("HMK_MS_UL_FS_1011270");

        for (var i = 0; i < aResult.length; i++) {
          ECL_ActivateValue("HMK_MS_UL_FS_1011270", aResult[i].HMK_MS_UL_FS_1011270);
        }
        ExecSetStandardifValueEmpty("HMK_MS_UL_FS_1011270", "");
      } else {
        strError = "DICT1_ERR_G220___PL_MS_UL_FS";
        return strError;
      }
      var HMK_MS_UL_FS_1011270 = ECL_GetValue("HMK_MS_UL_FS_1011270");
      // ------------------------------------------------------------------------------------
      // 6. HMK_MS_UL_MLFB_TYPE_1011270  Ausführung des elektrischen Anschlusses
      // ------------------------------------------------------------------------------------
      var sSQL = sSQL_MS_JOIN_BASIC_UL + " AND " +
        "HMK_MS_UL_RC_1011270 = " + HMK_MS_UL_RC_1011270 + " AND " +
        "HMK_MS_UL_VOLTAGE_R_1011270 = '" + HMK_MS_UL_VOLTAGE_R_1011270 + "' AND " +
        sWhere_SCCR + " AND " +
        "HMK_MS_UL_RATED_ICU_1011270_X = '" + HMK_MS_UL_RATED_ICU_1011270_X + "' AND " +
        "HMK_MS_UL_FS_1011270 = '" + HMK_MS_UL_FS_1011270 + "';";

      var aResult = GetDBDataSetEXT(sSQL);
      if (aResult && aResult.length > 0) {
        ECL_DeactivateAllAttributeValues("HMK_MS_UL_MLFB_TYPE_1011270");

        for (var i = 0; i < aResult.length; i++) {
          ECL_ActivateValue("HMK_MS_UL_MLFB_TYPE_1011270", aResult[i].HMK_MS_UL_MLFB_TYPE_1011270);
        }
        ExecSetStandardifValueEmpty("HMK_MS_UL_MLFB_TYPE_1011270", "");
      } else {
        strError = "DICT1_ERR_G220___PL_MS_UL_MLFB_TYPE";
        return strError;
      }
      var HMK_MS_UL_MLFB_TYPE_1011270 = ECL_GetValue("HMK_MS_UL_MLFB_TYPE_1011270");
      // ------------------------------------------------------------------------------------
      // 7. HMK_MS_UL_MLFB_CPL_1011270  SEC-MLFB bestimmen
      // ------------------------------------------------------------------------------------
      var sSQL = sSQL_MS_JOIN_BASIC_UL + " AND " +
        "HMK_MS_UL_RC_1011270 = " + HMK_MS_UL_RC_1011270 + " AND " +
        "HMK_MS_UL_VOLTAGE_R_1011270 = '" + HMK_MS_UL_VOLTAGE_R_1011270 + "' AND " +
        sWhere_SCCR + " AND " +
        "HMK_MS_UL_RATED_ICU_1011270_X = '" + HMK_MS_UL_RATED_ICU_1011270_X + "' AND " +
        "HMK_MS_UL_FS_1011270 = '" + HMK_MS_UL_FS_1011270 + "' AND " +
        "HMK_MS_UL_MLFB_TYPE_1011270 = '" + HMK_MS_UL_MLFB_TYPE_1011270 + "';";

      var aResult = GetDBDataSetEXT(sSQL);
      if (aResult.length > 0) {
        var HMK_MS_UL_MLFB_CPL_1011270 = aResult[0].HMK_MS_UL_MLFB_CPL_1011270;
        ECL_SetValue("HMK_MS_UL_MLFB_CPL_1011270", HMK_MS_UL_MLFB_CPL_1011270);
      } else {
        strError = "DICT1_ERR_G220___PL_GET_MS_MLFB_UL";
        return strError;
      }
    }
  } else {
    ECL_DeactivateAllAttributeValues("HMK_MS_IEC_MLFB_TYPE_1011270");
    ECL_DeactivateAllAttributeValues("HMK_MS_IEC_ICC_1011270_X");
    ECL_DeactivateAllAttributeValues("HMK_MS_IEC_FS_1011270");
    ECL_DeactivateAllAttributeValues("HMK_MS_IEC_RATED_ICU_1011270_X");
    ECL_DeactivateAllAttributeValues("HMK_MS_IEC_RC_1011270");

    ECL_ActivateValue("HMK_MS_IEC_MLFB_TYPE_1011270", "00003");
    ECL_ActivateValue("HMK_MS_IEC_ICC_1011270_X", ".");
    ECL_ActivateValue("HMK_MS_IEC_FS_1011270", "00001");
    ECL_ActivateValue("HMK_MS_IEC_RATED_ICU_1011270_X", ".");
    ECL_ActivateValue("HMK_MS_IEC_RC_1011270", "0");

    ECL_SelectValue("HMK_MS_IEC_MLFB_TYPE_1011270", "00003");
    ECL_SelectValue("HMK_MS_IEC_ICC_1011270_X", ".");
    ECL_SelectValue("HMK_MS_IEC_FS_1011270", "00001");
    ECL_SelectValue("HMK_MS_IEC_RATED_ICU_1011270_X", ".");
    ECL_SelectValue("HMK_MS_IEC_RC_1011270", "0");

    ECL_DeactivateAttribute("HMK_MS_IEC_MLFB_TYPE_1011270");
    ECL_DeactivateAttribute("HMK_MS_IEC_ICC_1011270_X");
    ECL_DeactivateAttribute("HMK_MS_IEC_FS_1011270");
    ECL_DeactivateAttribute("HMK_MS_IEC_RATED_ICU_1011270_X");
    ECL_DeactivateAttribute("HMK_MS_IEC_RC_1011270");
    ECL_SetValue("HMK_MS_IEC_MLFB_CPL_1011270", "");

    ECL_DeactivateAllAttributeValues("HMK_MS_UL_MLFB_TYPE_1011270");
    ECL_DeactivateAllAttributeValues("HMK_MS_UL_VOLTAGE_R_1011270");
    ECL_DeactivateAllAttributeValues("HMK_MS_UL_SCCR_1011410_X");
    ECL_DeactivateAllAttributeValues("HMK_MS_UL_SCCR_SL_1011270_X");
    ECL_DeactivateAllAttributeValues("HMK_MS_UL_FS_1011270");
    ECL_DeactivateAllAttributeValues("HMK_MS_UL_RATED_ICU_1011270_X");
    ECL_DeactivateAllAttributeValues("HMK_MS_UL_RC_1011270");

    ECL_ActivateValue("HMK_MS_UL_MLFB_TYPE_1011270", "00003");
    ECL_ActivateValue("HMK_MS_UL_VOLTAGE_R_1011270", "00001");
    ECL_ActivateValue("HMK_MS_UL_SCCR_1011410_X", ".");
    ECL_ActivateValue("HMK_MS_UL_SCCR_SL_1011270_X", ".");
    ECL_ActivateValue("HMK_MS_UL_FS_1011270", "00001");
    ECL_ActivateValue("HMK_MS_UL_RATED_ICU_1011270_X", ".");
    ECL_ActivateValue("HMK_MS_UL_RC_1011270", 0);

    ECL_SelectValue("HMK_MS_UL_MLFB_TYPE_1011270", "00003");
    ECL_SelectValue("HMK_MS_UL_VOLTAGE_R_1011270", "00001");
    ECL_SelectValue("HMK_MS_UL_SCCR_1011410_X", ".");
    ECL_SelectValue("HMK_MS_UL_SCCR_SL_1011270_X", ".");
    ECL_SelectValue("HMK_MS_UL_FS_1011270", "00001");
    ECL_SelectValue("HMK_MS_UL_RATED_ICU_1011270_X", ".");
    ECL_SelectValue("HMK_MS_UL_RC_1011270", 0);

    ECL_DeactivateAttribute("HMK_MS_UL_MLFB_TYPE_1011270");
    ECL_DeactivateAttribute("HMK_MS_UL_VOLTAGE_R_1011270");
    ECL_DeactivateAttribute("HMK_MS_UL_SCCR_1011410_X");
    ECL_DeactivateAttribute("HMK_MS_UL_SCCR_SL_1011270_X");
    ECL_DeactivateAttribute("HMK_MS_UL_FS_1011270");
    ECL_DeactivateAttribute("HMK_MS_UL_RATED_ICU_1011270_X");
    ECL_DeactivateAttribute("HMK_MS_UL_RC_1011270");
    ECL_SetValue("HMK_MS_UL_MLFB_CPL_1011270", "");
  }
  // ################################################################################################################

  // #############################################################################################################
  // Halbleitersicherung				CB_SC_FUSE_G220
  // #############################################################################################################
  /*
  IEC:
  HMK_SCFUSE_IEC_RC_1011270_X	Bemessungsstrom
  HMK_SCFUSE_IEC_MLFB_1011270	HMK_SCFUSE_IEC_MLFB_1011270
   
  HMK_SCFUSE_IEC_RC_1011270_X
    VT_G220_M00618	IEC_SEMICONDUCTOR_FUSES
      HMK_SCFUSE_G_CAPTION_1011270	Halbleitersicherung
      HMK_MOTORNORM_G220	Motornorm
      HMK_SFUSE_IEC_ICPMR_1011270	HMK_SFUSE_IEC_ICPMR_REF_G220
      HMK_SCFUSE_IEC_ICC_1011270	ICC Bemessungskurzschlussstrom
      HMK_SCFUSE_IEC_MEV_1011410	HMK_SCFUSE_IEC_MEV_G220
      HMK_SCFUSE_IEC_MEVFT_1011270	HMK_SCFUSE_IEC_MEV_FT_G220
      HMK_VALUE_VALID_G220	Flag: Eintrag ist gültig
      PMD_ABJ176_001_000_G220	Schutzart IP
      HMK_VOLTAGE_PW_KEY_1011270	Voltage_Power Key
      HMK_TOPOLOGY_G220	HMK_TOPOLOGY_G220
      HMK_REP_SWITCH__G220	Wartungsschalter
      HMK_SCFUSE_IEC_ICC_V_1011270	HMK_SCFUSE_IEC_ICC_V_G220
      HMK_SCFUSE_IEC_MLFB_1011270	HMK_SCFUSE_IEC_MLFB_G220
      HMK_SCFUSE_IEC_RC_1011270_X	Bemessungsstrom
   
    VT_G220_M00502	ONE_LINE_SIDE_PW_COMPONENT
   
  UL/NEMA:
  HMK_SCFUSE_UL_RC_1011270_X	Bemessungsstrom
  HMK_SCFUSE_UL_MLFB_1011270	HMK_SCFUSE_UL_MLFB_G220
   
  HMK_SCFUSE_UL_RC_1011270_X
    VT_G220_M00619	UL_CSA_SEMICONDUCTOR_FUSES
      HMK_SCF_UL_G_CAPTION_1011270	Halbleitersicherung
      HMK_MOTORNORM_G220	Motornorm
      PMD_ABJ176_001_000_G220	Schutzart IP
      HMK_SCFUSE_UL_MLFB_1011270	HMK_SCFUSE_UL_MLFB_G220
      HMK_SCFUSE_UL_MEV_FT_1011410	HMK_SCFUSE_UL_MEV_FT_G220
      HMK_SCFUSE_UL_MEV_1011410	HMK_SCFUSE_UL_MEV_G220
      HMK_SCFUSE_UL_SCCR_1011410	CMC /.../controller
      HMK_VOLTAGE_PW_KEY_1011270	Voltage_Power Key
      HMK_TOPOLOGY_G220	HMK_TOPOLOGY_G220
      HMK_REP_SWITCH__G220	Wartungsschalter
      HMK_SCFUSE_UL_SCCR_V_1011270	HMK_SCFUSE_UL_SCCR_V_G220
      HMK_SCFUSE_UL_RC_1011270_X	Bemessungsstrom
      HMK_VALUE_VALID_G220	Flag: Eintrag ist gültig
   
   
  VT_G220_M00502	ONE_LINE_SIDE_PW_COMPONENT
  */
  var bSC_FUSE_possible = false;
  if (HMK_MOTORNORM_G220 == "00002") {
    // IEC
    var sTable = "VT_G220_M00618" + sDB_Suffix;
    var sSQL =
      "SELECT HMK_SCFUSE_IEC_MLFB_1011270 FROM " +
      sTable +
      " WHERE " +
      "HMK_MOTORNORM_G220 = '" +
      HMK_MOTORNORM_G220 +
      "' AND " +
      "HMK_VOLTAGE_PW_KEY_1011270 = '" +
      HMK_VOLTAGE_PW_KEY_1011270 +
      "' AND " +
      sWhereHMK_SCFUSE_IEC_ICC_V_1011270 +
      " AND " +
      "HMK_TOPOLOGY_G220 = '" +
      HMK_TOPOLOGY_G220 +
      "' AND " +
      "PMD_ABJ176_001_000_G220 = '" +
      PMD_ABJ176_001_000_G220 +
      "' AND " +
      "HMK_SCFUSE_IEC_RC_1011270_X <> '.' AND " +
      "HMK_VALUE_VALID_G220 = 'T';";
    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length > 0) {
      bSC_FUSE_possible = true;
    }
  } else {
    var sTable = "VT_G220_M00619" + sDB_Suffix;
    var sSQL =
      "SELECT HMK_SCFUSE_IEC_MLFB_1011270 FROM " +
      sTable +
      " WHERE " +
      "HMK_MOTORNORM_G220 = '" +
      HMK_MOTORNORM_G220 +
      "' AND " +
      "HMK_VOLTAGE_PW_KEY_1011270 = '" +
      HMK_VOLTAGE_PW_KEY_1011270 +
      "' AND " +
      "HMK_TOPOLOGY_G220 = '" +
      HMK_TOPOLOGY_G220 +
      "' AND " +
      "PMD_ABJ176_001_000_G220 = '" +
      PMD_ABJ176_001_000_G220 +
      "' AND " +
      "HMK_SCFUSE_UL_RC_1011270_X <> '.' AND " +
      "HMK_VALUE_VALID_G220 = 'T';";
    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length > 0) {
      bSC_FUSE_possible = true;
    }
  }
  if (!bSC_FUSE_possible) {
    ECL_DisableAttribute("CB_SC_FUSE_G220");
  }

  if (ECL_ValueSelected("CB_SC_FUSE_G220", "T")) {
    // Unterscheidung IEC/UL
    if (HMK_MOTORNORM_G220 == "00002") {
      // IEC
      ECL_ActivateAttribute("HMK_SCFUSE_IEC_RC_1011270_X");
      ECL_ActivateAllAttributeValues("HMK_SCFUSE_IEC_RC_1011270_X");
      ECL_DeactivateValue("HMK_SCFUSE_IEC_RC_1011270_X", ".");

      ECL_DeactivateAttribute("HMK_SCFUSE_UL_RC_1011270_X");
      ECL_SetValue("HMK_SCFUSE_UL_MLFB_1011270", "");

      var sTargetAttribute = "HMK_SCFUSE_IEC_RC_1011270_X";

      var sTable = "VT_G220_M00618" + sDB_Suffix;
      var sWhere =
        "HMK_MOTORNORM_G220 = '" +
        HMK_MOTORNORM_G220 +
        "' AND " +
        "HMK_VOLTAGE_PW_KEY_1011270 = '" +
        HMK_VOLTAGE_PW_KEY_1011270 +
        "' AND " +
        sWhereHMK_SCFUSE_IEC_ICC_V_1011270 +
        " AND " +
        "HMK_TOPOLOGY_G220 = '" +
        HMK_TOPOLOGY_G220 +
        "' AND " +
        "PMD_ABJ176_001_000_G220 = '" +
        PMD_ABJ176_001_000_G220 +
        "' AND " +
        "HMK_SCFUSE_G_CAPTION_1011270 = 'T' AND " +
        "HMK_VALUE_VALID_G220 = 'T';";

      var sStatus = SetAttributeLogic2nd(sTable, sTargetAttribute, sWhere);

      if (sStatus == "Error") {
        strError = "DICT1_ERR_G220___PL_SCFUSE_IEC_RC";
        return strError;
      }

      // get MLFB-Sec
      var HMK_SCFUSE_IEC_RC_1011270_X = ECL_GetValue("HMK_SCFUSE_IEC_RC_1011270_X");
      var sTable = "VT_G220_M00618" + sDB_Suffix;
      var sSQL =
        "SELECT HMK_SCFUSE_IEC_MLFB_1011270 FROM " +
        sTable +
        " WHERE " +
        "HMK_SCFUSE_IEC_RC_1011270_X = '" +
        HMK_SCFUSE_IEC_RC_1011270_X +
        "' AND " +
        "HMK_MOTORNORM_G220 = '" +
        HMK_MOTORNORM_G220 +
        "' AND " +
        "HMK_VOLTAGE_PW_KEY_1011270 = '" +
        HMK_VOLTAGE_PW_KEY_1011270 +
        "' AND " +
        sWhereHMK_SCFUSE_IEC_ICC_V_1011270 +
        " AND " + "HMK_TOPOLOGY_G220 = '" +
        HMK_TOPOLOGY_G220 +
        "' AND " +
        "PMD_ABJ176_001_000_G220 = '" +
        PMD_ABJ176_001_000_G220 +
        "' AND " +
        "HMK_SCFUSE_G_CAPTION_1011270 = 'T' AND " +
        "HMK_VALUE_VALID_G220 = 'T';";

      var aResult = GetDBDataSetEXT(sSQL);
      if (aResult.length > 0) {
        var HMK_SCFUSE_IEC_MLFB_1011270 = aResult[0].HMK_SCFUSE_IEC_MLFB_1011270;
        ECL_SetValue("HMK_SCFUSE_IEC_MLFB_1011270", HMK_SCFUSE_IEC_MLFB_1011270);
      } else {
        strError = "DICT1_ERR_G220___PL_GET_SCFUSE_MLFB";
        return strError;
      }
    } else {
      //(HMK_MOTORNORM_G220 == "00001")	// NEMA/UL
      /*
      HMK_SCFUSE_UL_RC_1011270_X	Bemessungsstrom
      HMK_SCFUSE_UL_MLFB_1011270	HMK_SCFUSE_UL_MLFB_G220
        VT_G220_M00619	UL_CSA_SEMICONDUCTOR_FUSES
          HMK_SCF_UL_G_CAPTION_1011270	Halbleitersicherung
          HMK_MOTORNORM_G220	Motornorm
          PMD_ABJ176_001_000_G220	Schutzart IP
          HMK_SCFUSE_UL_MLFB_1011270	HMK_SCFUSE_UL_MLFB_G220
          HMK_SCFUSE_UL_MEV_FT_1011410	HMK_SCFUSE_UL_MEV_FT_G220
          HMK_SCFUSE_UL_MEV_1011410	HMK_SCFUSE_UL_MEV_G220
          HMK_SCFUSE_UL_SCCR_1011410	CMC /.../controller
          HMK_VOLTAGE_PW_KEY_1011270	Voltage_Power Key
          HMK_TOPOLOGY_G220	HMK_TOPOLOGY_G220
          HMK_REP_SWITCH__G220	Wartungsschalter
          HMK_SCFUSE_UL_SCCR_V_1011270	HMK_SCFUSE_UL_SCCR_V_G220
          HMK_SCFUSE_UL_RC_1011270_X	Bemessungsstrom
          HMK_VALUE_VALID_G220	Flag: Eintrag ist gültig
      */
      ECL_ActivateAttribute("HMK_SCFUSE_UL_RC_1011270_X");
      ECL_ActivateAllAttributeValues("HMK_SCFUSE_UL_RC_1011270_X");
      ECL_DeactivateValue("HMK_SCFUSE_UL_RC_1011270_X", ".");

      ECL_DeactivateAttribute("HMK_SCFUSE_IEC_RC_1011270_X");
      ECL_SetValue("HMK_SCFUSE_IEC_MLFB_1011270", "");

      var sTargetAttribute = "HMK_SCFUSE_UL_RC_1011270_X";

      var sTable = "VT_G220_M00619" + sDB_Suffix;
      var sWhere =
        "HMK_MOTORNORM_G220 = '" +
        HMK_MOTORNORM_G220 +
        "' AND " +
        "HMK_VOLTAGE_PW_KEY_1011270 = '" +
        HMK_VOLTAGE_PW_KEY_1011270 +
        "' AND " +
        "HMK_TOPOLOGY_G220 = '" +
        HMK_TOPOLOGY_G220 +
        "' AND " +
        "PMD_ABJ176_001_000_G220 = '" +
        PMD_ABJ176_001_000_G220 +
        "' AND " +
        "HMK_SCF_UL_G_CAPTION_1011270 = 'T' AND " +
        "HMK_VALUE_VALID_G220 = 'T';";

      var sStatus = SetAttributeLogic2nd(sTable, sTargetAttribute, sWhere);

      if (sStatus == "Error") {
        strError = "DICT1_ERR_G220___PL_SCFUSE_UL_RC";
        return strError;
      }

      // get MLFB-Sec
      var HMK_SCFUSE_UL_RC_1011270_X = ECL_GetValue("HMK_SCFUSE_UL_RC_1011270_X");

      var sTable = "VT_G220_M00619" + sDB_Suffix;
      var sSQL =
        "SELECT HMK_SCFUSE_UL_MLFB_1011270 FROM " +
        sTable +
        " WHERE " +
        "HMK_SCFUSE_UL_RC_1011270_X = '" +
        HMK_SCFUSE_UL_RC_1011270_X +
        "' AND " +
        "HMK_MOTORNORM_G220 = '" +
        HMK_MOTORNORM_G220 +
        "' AND " +
        "HMK_VOLTAGE_PW_KEY_1011270 = '" +
        HMK_VOLTAGE_PW_KEY_1011270 +
        "' AND " +
        "HMK_TOPOLOGY_G220 = '" +
        HMK_TOPOLOGY_G220 +
        "' AND " +
        "PMD_ABJ176_001_000_G220 = '" +
        PMD_ABJ176_001_000_G220 +
        "' AND " +
        "HMK_SCF_UL_G_CAPTION_1011270 = 'T' AND " +
        "HMK_VALUE_VALID_G220 = 'T';";

      var aResult = GetDBDataSetEXT(sSQL);
      if (aResult.length > 0) {
        var HMK_SCFUSE_UL_MLFB_1011270 = aResult[0].HMK_SCFUSE_UL_MLFB_1011270;
        ECL_SetValue("HMK_SCFUSE_UL_MLFB_1011270", HMK_SCFUSE_UL_MLFB_1011270);
      } else {
        strError = "DICT1_ERR_G220___PL_GET_SCFUSE_MLFB_UL";
        return strError;
      }
    }
  } else {
    ECL_ActivateValue("HMK_SCFUSE_IEC_RC_1011270_X", ".");
    ECL_SelectValue("HMK_SCFUSE_IEC_RC_1011270_X", ".");
    ECL_ActivateValue("HMK_SCFUSE_UL_RC_1011270_X", ".");
    ECL_SelectValue("HMK_SCFUSE_UL_RC_1011270_X", ".");
    ECL_DeactivateAttribute("HMK_SCFUSE_IEC_RC_1011270_X");
    ECL_DeactivateAttribute("HMK_SCFUSE_UL_RC_1011270_X");
    ECL_SetValue("HMK_SCFUSE_IEC_MLFB_1011270", "");
    ECL_SetValue("HMK_SCFUSE_UL_MLFB_1011270", "");
  }

  // ################################################################################################################

  // ################################################################################################################
  // 	Standardsicherung			CB_STD_FUSE_G220
  // ################################################################################################################
  /*
  HMK_FUSE_IEC_RC_1011270_X	Bemessungsstrom
  HMK_FUSE_IEC_MLFB_1011270	HMK_FUSE_IEC_MLFB_G220
   
  HMK_FUSE_IEC_RC_1011270_X
    VT_G220_M00613	IEC_STANDARD_FUSES
      HMK_FUSE_G_CAPTION_1011270	Standardsicherung
      HMK_MOTORNORM_G220	Motornorm
      HMK_FUSE_IEC_ICPMR_1011270	HMK_FUSE_IEC_ICPMR_REF_G220
      HMK_FUSE_IEC_ICC_1011270	HMK_FUSE_IEC_ICC_G220
      HMK_FUSE_IEC_MEV_1011410_X	HMK_FUSE_IEC_MEV_G220
      HMK_FUSE_IEC_MEV_FT_1011410_X	HMK_FUSE_IEC_MEV_FT_G220
      HMK_VALUE_VALID_G220	Flag: Eintrag ist gültig
      PMD_ABJ176_001_000_G220	Schutzart IP
      HMK_VOLTAGE_PW_KEY_1011270	Voltage_Power Key
      HMK_TOPOLOGY_G220	HMK_TOPOLOGY_G220
      HMK_REP_SWITCH__G220	Wartungsschalter
      HMK_FUSE_IEC_ICC_V_1011270	HMK_FUSE_IEC_ICC_V_G220
      HMK_FUSE_IEC_RC_1011270_X	Bemessungsstrom
      HMK_FUSE_IEC_MLFB_1011270	HMK_FUSE_IEC_MLFB_G220
    VT_G220_M00502	ONE_LINE_SIDE_PW_COMPONENT
  */
  var bSTD_FUSE = true;

  var sTable = "VT_G220_M00613" + sDB_Suffix;
  var sSQL =
    "SELECT * FROM " +
    sTable +
    " WHERE " +
    "HMK_MOTORNORM_G220 = '" +
    HMK_MOTORNORM_G220 +
    "' AND " +
    "HMK_VOLTAGE_PW_KEY_1011270 = '" +
    HMK_VOLTAGE_PW_KEY_1011270 +
    "' AND " +
    sWhereHMK_FUSE_IEC_ICC_V_1011270 +
    " AND " +
    "HMK_TOPOLOGY_G220 = '" +
    HMK_TOPOLOGY_G220 +
    "' AND " +
    "PMD_ABJ176_001_000_G220 = '" +
    PMD_ABJ176_001_000_G220 +
    "' AND " +
    "HMK_FUSE_IEC_RC_1011270_X <> '.' AND " +
    "HMK_VALUE_VALID_G220 = 'T';";

  var aResult = GetDBDataSetEXT(sSQL);
  if (aResult.length > 0) {
    ECL_EnableAttribute("CB_STD_FUSE_G220");
    bSTD_FUSE = true;
  } else {
    ECL_DeselectAttribute("CB_STD_FUSE_G220");
    ECL_DisableAttribute("CB_STD_FUSE_G220");
    bSTD_FUSE = false;
  }

  if (ECL_ValueSelected("CB_STD_FUSE_G220", "T")) {
    // IEC/UL gemeinsam in VT483
    ECL_ActivateAllAttributeValues("HMK_FUSE_IEC_RC_1011270_X");
    ECL_ActivateAttribute("HMK_FUSE_IEC_RC_1011270_X");
    ECL_DeactivateValue("HMK_FUSE_IEC_RC_1011270_X", ".");

    var sTargetAttribute = "HMK_FUSE_IEC_RC_1011270_X";

    var sTable = "VT_G220_M00613" + sDB_Suffix;
    var sWhere =
      "HMK_MOTORNORM_G220 = '" +
      HMK_MOTORNORM_G220 +
      "' AND " +
      "HMK_VOLTAGE_PW_KEY_1011270 = '" +
      HMK_VOLTAGE_PW_KEY_1011270 +
      "' AND " +
      sWhereHMK_FUSE_IEC_ICC_V_1011270 +
      " AND " +
      "HMK_TOPOLOGY_G220 = '" +
      HMK_TOPOLOGY_G220 +
      "' AND " +
      "PMD_ABJ176_001_000_G220 = '" +
      PMD_ABJ176_001_000_G220 +
      "' AND " +
      "HMK_FUSE_G_CAPTION_1011270 = 'T' AND " +
      "HMK_VALUE_VALID_G220 = 'T';";

    var sStatus = SetAttributeLogic2nd(sTable, sTargetAttribute, sWhere);

    if (sStatus == "Error") {
      strError = "DICT1_ERR_G220___PL_FUSE_IEC_RC";
      return strError;
    }

    // get MLFB-Sec
    var HMK_FUSE_IEC_RC_1011270_X = ECL_GetValue("HMK_FUSE_IEC_RC_1011270_X");
    var sTable = "VT_G220_M00613" + sDB_Suffix;
    var sSQL =
      "SELECT HMK_FUSE_IEC_MLFB_1011270 FROM " +
      sTable +
      " WHERE " +
      "HMK_FUSE_IEC_RC_1011270_X = '" +
      HMK_FUSE_IEC_RC_1011270_X +
      "' AND " +
      "HMK_MOTORNORM_G220 = '" +
      HMK_MOTORNORM_G220 +
      "' AND " +
      "HMK_VOLTAGE_PW_KEY_1011270 = '" +
      HMK_VOLTAGE_PW_KEY_1011270 +
      "' AND " +
      sWhereHMK_FUSE_IEC_ICC_V_1011270 +
      " AND " +
      "HMK_TOPOLOGY_G220 = '" +
      HMK_TOPOLOGY_G220 +
      "' AND " +
      "PMD_ABJ176_001_000_G220 = '" +
      PMD_ABJ176_001_000_G220 +
      "' AND " +
      "HMK_FUSE_G_CAPTION_1011270 = 'T' AND " +
      "HMK_VALUE_VALID_G220 = 'T';";

    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length > 0) {
      var HMK_FUSE_IEC_MLFB_1011270 = aResult[0].HMK_FUSE_IEC_MLFB_1011270;
      ECL_SetValue("HMK_FUSE_IEC_MLFB_1011270", HMK_FUSE_IEC_MLFB_1011270);
    } else {
      strError = "DICT1_ERR_G220___PL_GET_FUSE_MLFB";
      return strError;
    }
  } else {
    ECL_DeactivateAllAttributeValues("HMK_FUSE_IEC_RC_1011270_X");
    ECL_ActivateValue("HMK_FUSE_IEC_RC_1011270_X", ".");
    ECL_SelectValue("HMK_FUSE_IEC_RC_1011270_X", ".");
    ECL_DeactivateAttribute("HMK_FUSE_IEC_RC_1011270_X");
  }
  // #############################################################################################################

  // #############################################################################################################
  // Bremswiderstand			HMK_BRAKERESISTOR_G220
  // #############################################################################################################
  /* Kein Bremswiderstand bei IP55 
  BZ_G220_00624	VT_628 BRK_RES nicht bei IP55
    RESTRICTIONS: TABLE VT_G220_M00628 (
      HMK_CAN_CONCT_BR_G220 =c.HMK_CAN_CONCT_BR_G220 ,
      HMK_SCHUTZART_1011410 =d.HMK_SCHUTZART_1011410 )
    INFERENCES:
      c.HMK_CAN_CONCT_BR_G220,
      d.HMK_SCHUTZART_1011410
   
   
    HMK_CAN_CONCT_BR_G220	Bremswiderstand
      VT_G220_M00574 ACCESSORY_BRAKING_RESISTOR
   
      VT_G220_M00651	MLFB_8_DRIVE_TOPOLOGY
        HMK_V_OUT_W_FM_G220		HMK_V_OUT_W_FM_G220
        HMK_V_OUT_WO_FM_G220	HMK_V_OUT_WO_FM_G220
        PMD_ACU348_001_000_G220	Ausnahmegrund /...n-Richtlinie
        PMD_ACU798_001_000_G220	Produkteigensch...n-Richtlinie
        PMD_ABY282_001_000_1011270	prozentuale /.../maximal
        PMD_ABP325_001_000_G220	Produktbestandt...Bremschopper
        MLFB08_G220				Segment Merkmal MLFB08_G220
        HMK_CAN_CONCT_BR_G220	Bremswiderstand
        HMK_TOPOLOGY_G220		HMK_TOPOLOGY_G220
   
   
    HMK_ACC_BRAKING_G220	HMK_ACC_BRAKING_G220
   
    VT_G220_M00574	ACCESSORY_BRAKING_RESISTOR
      HMK_SSA_BR_PMAX_1011270	HMK_SSA_BR_PMAX_G220
      HMK_SSA_BR_RESISTOR_1011270	HMK_SSA_BR_RESISTOR_G220
      HMK_SSA_BR_PRATED_1011270	HMK_SSA_BR_PRATED_G220
      HMK_BR_WEIGHT_G220	HMK_BR_WEIGHT_G220
      HMK_ACC_BRAKING_G220	HMK_ACC_BRAKING_G220
      PMD_ABJ176_001_000_G220	Schutzart IP
      HMK_CAN_CONCT_BR_G220	Bremswiderstand
      HMK_VOLTAGE_G220	HMK_VOLTAGE_G220
      HMK_RATED_POWER_G220	HMK_RATED_POWER_G220
  */
  // VT_G220_M00628
  // HMK_CAN_CONCT_BR_G220  HMK_SCHUTZART_1011410
  
  // Restricting Braking Resistor value options based on regenerative mode
  var UI_HMK_BRAKERESISTOR_G220 = ECL_GetValue("UI_HMK_BRAKERESISTOR_G220");
  
  var bValue_T_valid = HMK_SCHUTZART_1011410 != "00005"; // Disable "Yes" on IP55
  var bValue_F_valid = ECSI_CX_RegenerativeMode != 2; // Disable "No" when Dynamic braking is set
    
  if (bValue_T_valid) {
    ECL_ActivateValue("UI_HMK_BRAKERESISTOR_G220", "T");
  }
  else {
    ECL_DeactivateValue("UI_HMK_BRAKERESISTOR_G220", "T");

    if (UI_HMK_BRAKERESISTOR_G220 == "T") {
      if (bValue_F_valid) {
        ECL_SetValue("UI_HMK_BRAKERESISTOR_G220", "F");
      }
      else {
        ECL_SetValue("UI_HMK_BRAKERESISTOR_G220", "CUSTOM");
      }
    }
  }

  if (bValue_F_valid) {
    ECL_ActivateValue("UI_HMK_BRAKERESISTOR_G220", "F");
  }
  else {
    ECL_DeactivateValue("UI_HMK_BRAKERESISTOR_G220", "F");

    if (UI_HMK_BRAKERESISTOR_G220 == "F") {
      if (bValue_T_valid) {
        ECL_SetValue("UI_HMK_BRAKERESISTOR_G220", "T");
      }
      else {
        ECL_SetValue("UI_HMK_BRAKERESISTOR_G220", "CUSTOM");
      }
    }
  }
  
  // Setting value option based on UI option
  var UI_HMK_BRAKERESISTOR_G220 = ECL_GetValue("UI_HMK_BRAKERESISTOR_G220");
  if (UI_HMK_BRAKERESISTOR_G220 == "T") {
    ECL_SetValue("HMK_BRAKERESISTOR_G220", "T");
  }
  else {
    ECL_SetValue("HMK_BRAKERESISTOR_G220", "F");
  }

  var sDTKAttribute = "HMK_CAN_CONCT_BR_G220";
  var sCB_Attribute = "HMK_BRAKERESISTOR_G220";

  var HMK_SCHUTZART_1011410 = ECL_GetValue("HMK_SCHUTZART_1011410");

  var sTable = "VT_G220_M00628" + sDB_Suffix;
  var sWhere = "HMK_SCHUTZART_1011410 = '" + HMK_SCHUTZART_1011410 + "';";

  var sStatus = SetAttributeLogic_Checkbox(sTable, sDTKAttribute, sCB_Attribute, "T", "F", sWhere, false); // = true weiter einschränken n. Lauf, bei false, erster Lauf,

  if (sStatus == "Error") {
    strError = "DICT1_ERR_G220___PL_BR_RESISTOR";
    return strError;
  }
  // -----------------------------------------------------------------------------
  var sDTKAttribute = "HMK_CAN_CONCT_BR_G220";
  var sCB_Attribute = "HMK_BRAKERESISTOR_G220";

  var sTable = "VT_G220_M00651" + sDB_Suffix;
  var sWhere = "HMK_TOPOLOGY_G220 = '" + HMK_TOPOLOGY_G220 + "';";

  var sStatus = SetAttributeLogic_Checkbox(sTable, sDTKAttribute, sCB_Attribute, "T", "F", sWhere, true); // = true weiter einschränken n. Lauf, bei false, erster Lauf,
  
  if (sStatus == "Error") {
    strError = "DICT1_ERR_G220___PL_BR_RESISTOR";
    return strError;
  }
  // -----------------------------------------------------------------------------
  var sTable = "VT_G220_M00574" + sDB_Suffix;
  var sWhere =
    "HMK_VOLTAGE_G220 = '" +
    HMK_VOLTAGE_G220 +
    "' AND " +
    "HMK_RATED_POWER_G220 = '" +
    HMK_RATED_POWER_G220 +
    "' AND " +
    "PMD_ABJ176_001_000_G220 = '" +
    PMD_ABJ176_001_000_G220 +
    "';";

  var sStatus = SetAttributeLogic_Checkbox(sTable, sDTKAttribute, sCB_Attribute, "T", "F", sWhere, true); // = true weiter einschränken n. Lauf, bei false, erster Lauf,
  
  if (sStatus == "Error") {
    strError = "DICT1_ERR_G220___PL_BR_RESISTOR";
    return strError;
  }

  if (ECL_ValueSelected("HMK_BRAKERESISTOR_G220", "T")) {
    var sTable = "VT_G220_M00574" + sDB_Suffix;
    var sSQL =
      "SELECT HMK_ACC_BRAKING_G220 FROM " +
      sTable +
      " WHERE " +
      "HMK_VOLTAGE_G220 = '" +
      HMK_VOLTAGE_G220 +
      "' AND " +
      "HMK_RATED_POWER_G220 = '" +
      HMK_RATED_POWER_G220 +
      "' AND " +
      "PMD_ABJ176_001_000_G220 = '" +
      PMD_ABJ176_001_000_G220 +
      "' AND " +
      "HMK_CAN_CONCT_BR_G220 = 'T';";

    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length > 0) {
      var HMK_ACC_BRAKING_G220 = aResult[0].HMK_ACC_BRAKING_G220;
      ECL_SetValue("HMK_ACC_BRAKING_G220", HMK_ACC_BRAKING_G220);
    } else {
      strError = "DICT1_ERR_G220___PL_BR_RESISTOR_MLFB";
      return strError;
    }
  } else {
    ECL_SetValue("HMK_ACC_BRAKING_G220", "");
  }

  // #############################################################################################################
  // nur eine netzseitige Leistungskomponente (LineSidePwComp) zulaessig
  // #############################################################################################################
  // CB_MS_G220, CB_STD_FUSE_G220, CB_SC_FUSE_G220
  // Abbildung über VT620

  if (((bHMK_CB_GROUP_CAPTION_1011270 && HMK_MOTORNORM_G220 == "00002") || (bHMK_CB_UL_G_CAPTION_1011270 && HMK_MOTORNORM_G220 == "00001")) && bCB_possible) {
    ECL_EnableAttribute("CB_CIRCUIT_BREAKER_G220");
  } else {
    ECL_DisableAttribute("CB_CIRCUIT_BREAKER_G220");
  }

  if (bHMK_MS_IEC_G_CAPTION_1011270 && HMK_MOTORNORM_G220 == "00002" && bMS_possible) {
    ECL_EnableAttribute("CB_MS_G220");
  } else {
    ECL_DisableAttribute("CB_MS_G220");
  }
  if (bHMK_MS_UL_G_CAPTION_1011270 && HMK_MOTORNORM_G220 == "00001" && bMS_possible) {
    ECL_EnableAttribute("CB_MS_UL_G220");
  } else {
    ECL_DisableAttribute("CB_MS_UL_G220");
  }
  if (((bHMK_SCFUSE_G_CAPTION_1011270 && HMK_MOTORNORM_G220 == "00002") || (bHMK_SCF_UL_G_CAPTION_1011270 && HMK_MOTORNORM_G220 == "00001")) && bSC_FUSE_possible) {
    ECL_EnableAttribute("CB_SC_FUSE_G220");
  } else {
    ECL_DisableAttribute("CB_SC_FUSE_G220");
  }

  if (bHMK_FUSE_G_CAPTION_1011270 && HMK_MOTORNORM_G220 == "00002" && bSTD_FUSE) {
    ECL_EnableAttribute("CB_STD_FUSE_G220");
  } else {
    ECL_DisableAttribute("CB_STD_FUSE_G220");
  }
  // #############################################################################################################

  // #############################################################################################################
  // digitaler Zwilling
  // #############################################################################################################
  /**
   * HMK_DRV_SIM_DESIGNER_1011270	  DriveSim Designer
   * HMK_MLFB_DRV_SIM_DES_1011270   MLFB DriveSim Designer
   *
   * HMK_DRV_SIM_ENGINEER_1011410	DriveSim Engineer
   * HMK_MLFB_DRV_SIM_ENG_1011410	MLFB DriveSim Engineer
   *
   *
   * VT_G220_M00631	MLFB DriveSim Designer
   *    HMK_DRV_SIM_DESIGNER_1011270	DriveSim Designer
   *    HMK_MLFB_DRV_SIM_DES_1011270	MLFB DriveSim Designer
   *
   * VT_G220_M00632	MLFB DriveSim Engineer
   *    HMK_DRV_SIM_ENGINEER_1011410	DriveSim Engineer
   *    HMK_MLFB_DRV_SIM_ENG_1011410	MLFB DriveSim Engineer
   */
  var HMK_DRV_SIM_DESIGNER_1011270 = ECL_GetValue("HMK_DRV_SIM_DESIGNER_1011270");
  var HMK_DRV_SIM_ENGINEER_1011410 = ECL_GetValue("HMK_DRV_SIM_ENGINEER_1011410");

  // #############################################################################################################


  // #############################################################################################################
  // SINAMICS SDI Standard Schutztür     HMK_IP55_PROT_DOOR_1011410
  // #############################################################################################################

  ECL_SelectValue("HMK_IP55_PROT_DOOR_1011410", "00002");
  ECL_DeactivateAttribute("HMK_IP55_PROT_DOOR_1011410");

  // #############################################################################################################


  // #############################################################################################################
  // Auswahl CO2 Certification
  // #############################################################################################################
  /** BZ_G220_00641	Auswahl CO2 Certification	10	SelCon	1	$root.HMK_CO2_FOOTPRINT_1011410 = 'T'
   * BZ_G220_00642	Stueckliste CO2 Certification	12	Proc	1	$self.MLFB_G220 = $root.HMK_CO2_CERT_MLFB_1011410
   * 
   * Aktuell keine Zuordnung abgebildet
  */

  // #############################################################################################################

  
  // #############################################################################################################
  // dV/dt filter plus VPL
  // #############################################################################################################
    var power = ECL_GetValue("HMK_RATED_POWER_G220");
    var valid = ECL_GetValue("HMK_VALUE_VALID_G220");
    var voltage = ECL_GetValue("HMK_VOLTAGE_G220");

    var sTable = "VT_G220_M00695" + sDB_Suffix;
    var sSQL_DUDT_FILTER_MLFB_G220 = "SELECT HMK_DUDT_FILTER_MLFB_G220 FROM " + sTable + " WHERE " + "HMK_RATED_POWER_G220 = '" + power + "'  AND HMK_VALUE_VALID_G220 = '" + valid + "' AND HMK_VOLTAGE_G220 = '" + voltage + "' AND HMK_DU_DT_FILTER_1011270 = 'T' ;";

    var aResult = GetDBDataSetEXT(sSQL_DUDT_FILTER_MLFB_G220);

    // If there is no compatible dV/dt filter, disable the attribute
    if (aResult.length === 0) {
      ECL_SelectValue("HMK_DUDT_FILTER_G220", "");
      ECL_DisableAttribute("HMK_DUDT_FILTER_G220");
    }

  // #############################################################################################################
  // #############################################################################################################

  return "OK";
}



