//@legacy
//#mode(full-ecma)


/**
Wertet eine Variantentabelle für das Zielattribut aus und deaktiviert die nicht gültigen Werte. 
Gültig für die erste Einschränkung des Merkmals, weitere Einschränkungen mit der unteren Funktion.
*/
function SetAttributeLogic1st(sTable, sTargetAttribute, sWhere, sDefault_x)
{
	return SetAttributeLogic_gen(sTable, sTargetAttribute, sWhere, sDefault_x, false);
}
/**
Wertet eine Variantentabelle für das Zielattribut aus und deaktiviert die nicht gültigen Werte. 
Gültig für weitere Einschränkungen des Merkmals, wenn bereits eine Einschränkung stattgefunden hat.
*/
function SetAttributeLogic2nd(sTable, sTargetAttribute, sWhere, sDefault_x) // bIntersect = true
{
	return SetAttributeLogic_gen(sTable, sTargetAttribute, sWhere, sDefault_x, true);
}

function SetAttributeLogic_gen(sTable, sTargetAttribute, sWhere, sDefault_x, bIntersect)// = true weiter einschränken n. Lauf, bei false, erster Lauf,
{
	var sDefault = sDefault_x || "";
	var sSQL = 	"SELECT DISTINCT " + sTargetAttribute + " FROM " + sTable + " WHERE " + sWhere;
	
	var aResult = GetDBDataSetEXT(sSQL);
	
	if (aResult.length > 0){
		if (bIntersect){
			var aValidValues = ECL_GetAllActiveAttributeValues(sTargetAttribute);
		}
		ECL_DeactivateAllAttributeValues(sTargetAttribute);
		//var test = ECL_GetAllActiveAttributeValues(sTargetAttribute);
		for (var i = 0; i < aResult.length; i++){
			if (bIntersect){
				if (aValidValues.indexOf(aResult[i][sTargetAttribute]) > -1){
					ECL_ActivateValue(sTargetAttribute, aResult[i][sTargetAttribute]);
				}
			}else{
				ECL_ActivateValue(sTargetAttribute, aResult[i][sTargetAttribute]);
			}
		} 
		//var test = ECL_GetAllActiveAttributeValues(sTargetAttribute);
		if (aResult.length == 1){
			ECL_SelectValue(sTargetAttribute, aResult[0][sTargetAttribute]);
		}
		else
		{
			ExecSetStandardifValueEmpty(sTargetAttribute, sDefault);
		}
	}
	else{
		// Fehler;
		return "Error";
	}
	return ECL_GetAllActiveAttributeValues(sTargetAttribute);
}

function SetAttributeLogicFromCode(sTargetAttribute, aValidValues)
{
	var aValidValues_old = ECL_GetAllActiveAttributeValues(sTargetAttribute);
	var aValidValues_new = new Array();
	
	ECL_DeactivateAllAttributeValues(sTargetAttribute);
	
	for (var i = 0; i < aValidValues.length; i++){
		if (aValidValues_old.length > 0)
		{
			var iIndex = aValidValues_old.indexOf(aValidValues[i]);
			if (aValidValues_old.indexOf(aValidValues[i]) > -1){
				var sValue = aValidValues[i];
				ECL_ActivateValue(sTargetAttribute, aValidValues[i]);
				aValidValues_new.push(sValue);
			}
		}
		else
		{
			// ist das so korrekt? Wenn vorher keine gültigen Werte mehr da waren, kann nicht einfach eins aktiviert werden?!?
			var sValue = aValidValues[i];
			ECL_ActivateValue(sTargetAttribute, aValidValues[i]);
			aValidValues_new.push(sValue);
		}
	} 	
	
	if (aValidValues_new.length == 1){
		ECL_SelectValue(sTargetAttribute, aValidValues_new[0]);
	}
	else
	{
		ExecSetStandardifValueEmpty(sTargetAttribute, "");
	}
	if (aValidValues_new.length == 0){
		// Fehler;
		return "Error";
	}
	return ECL_GetAllActiveAttributeValues(sTargetAttribute);
}


function SetAttributeLogicFromCodeOverwrite(sTargetAttribute, aValidValues)
{
	ECL_DeactivateAllAttributeValues(sTargetAttribute);
	
	for (var i = 0; i < aValidValues.length; i++){
		var sValue = aValidValues[i];
		ECL_ActivateValue(sTargetAttribute, aValidValues[i]);
	} 	
	
	if (aValidValues.length == 1){
		ECL_SelectValue(sTargetAttribute, aValidValues[0]);
	}
	else
	{
		ExecSetStandardifValueEmpty(sTargetAttribute, "");
	}
	
	return ECL_GetAllActiveAttributeValues(sTargetAttribute);
}

/**
Funktion zur Einschränkung eines Attributes in Abhängigkeit der MLFB 
MLFB-Attribut wird von Produktlogik eingeschränkt. 
Der verbleibende Wertepool wird dann genutzt, um das Zielattribut einzuschränken mit einer Übersetzung über eine Übersetzungstabelle

sTargetAttribute: 	Zielattribut, welches eingeschränkt werden soll
sMLFB_NAME: ID des MLFB-Attributs
sTable: 	Übersetzungstabelle in der MLFB und Zielattribut enthalten sind.
*/

function SetAttributeLogicFromMLFB(sTargetAttribute, sMLFB_NAME, sTable)
{
	return SetAttributeLogicFromMLFB(sTargetAttribute, sMLFB_NAME, sTable, "");
}

function SetAttributeLogicFromMLFB(sTargetAttribute, sMLFB_NAME, sTable, addWhere)
{
	var aValidValuesMLFB = ECL_GetAllActiveAttributeValues(sMLFB_NAME);
	
	addWhere = addWhere || "";
	if (addWhere != ""){
		addWhere = addWhere + " AND ";
	}
	ECL_DeactivateAllAttributeValues(sTargetAttribute);
	
	var sWhere = sMLFB_NAME + " = '" + aValidValuesMLFB[0] + "'";
	
	if (aValidValuesMLFB.length > 1){
		
		for (var i = 1; i < aValidValuesMLFB.length; i++){
			
			sWhere = sWhere + " OR " + sMLFB_NAME + " = '" + aValidValuesMLFB[i] + "'";
			
		}
	}
	
	var sSQL = "SELECT DISTINCT * FROM " + sTable + " WHERE " + addWhere + "(" + sWhere + ");";
	
	var aResult = GetDBDataSetEXT(sSQL);
	
	if (aResult.length > 0){
		for (var j = 0; j < aResult.length; j++){
			ECL_ActivateValue(sTargetAttribute, aResult[j][sTargetAttribute]);
		}
	}else{
		return "Error";
	}
	
	if (aResult.length == 1){
		ECL_SelectValue(sTargetAttribute, aResult[0][sTargetAttribute]);
	}
	else
	{
		ExecSetStandardifValueEmpty(sTargetAttribute, "");
	}
	
	return ECL_GetAllActiveAttributeValues(sTargetAttribute);
}
function SetAttributeLogicFromMLFBIntersect(sTargetAttribute, sMLFB_NAME, sTable)
{
	var aValidValuesMLFB = ECL_GetAllActiveAttributeValues(sMLFB_NAME);
	
	var aValidValues = ECL_GetAllActiveAttributeValues(sTargetAttribute);
	
	ECL_DeactivateAllAttributeValues(sTargetAttribute);
	
	var sWhere = sMLFB_NAME + " = '" + aValidValuesMLFB[0] + "'";
	
	if (aValidValuesMLFB.length > 1){
		
		for (var i = 1; i < aValidValuesMLFB.length; i++){
			
			sWhere = sWhere + " OR " + sMLFB_NAME + " = '" + aValidValuesMLFB[i] + "'";
			
		}
	}
	
	var sSQL = "SELECT DISTINCT * FROM " + sTable + " WHERE (" + sWhere + ");";
	
	var aResult = GetDBDataSetEXT(sSQL);
	
	if (aResult.length > 0){
		for (var j = 0; j < aResult.length; j++){
			if (aValidValues.indexOf(aResult[j][sTargetAttribute]) > -1){
				ECL_ActivateValue(sTargetAttribute, aResult[j][sTargetAttribute]);
			}
		}
	}else{
		return "Error";
	}
	
	if (aResult.length == 1){
		ECL_SelectValue(sTargetAttribute, aResult[0][sTargetAttribute]);
	}
	else
	{
		ExecSetStandardifValueEmpty(sTargetAttribute, "");
	}
	
	return ECL_GetAllActiveAttributeValues(sTargetAttribute);
}
function SetAttributeLogic_Checkbox(sTable, sDTKAttribute, sCB_Attribute, sKAG, sFalse, sWhere, bIntersect)// = true weiter einschränken n. Lauf, bei false, erster Lauf,
{
	//var sDefault = sDefault_x || "";
	var sSQL = 	"SELECT DISTINCT " + sDTKAttribute + " FROM " + sTable + " WHERE " + sWhere;
	
	var aResult = GetDBDataSetEXT(sSQL);
	
	if (aResult.length > 0){
		if (bIntersect){
			var bEnabled = ECL_AttributeEnabled(sCB_Attribute);		// wenn true, dann kann noch gewählt werden, wenn false, dann ist schon auf KAG oder F eingeschränkt
			var bChecked = ECL_ValueSelected(sCB_Attribute, "T");	// KAG gesetzt?
		}
		
		var bValueTrueAviable = false;
		var bValueFalseAviable = false;
		// Prüfen, ob in der VT noch beide Werte erlaubt sind 
		for (var i = 0; i < aResult.length; i++){
			if (aResult[i][sDTKAttribute] == sKAG){
					var bValueTrueAviable = true;
			}
			if (aResult[i][sDTKAttribute] == sFalse){
					var bValueFalseAviable = true;
			}
		} 
		
		if (!bIntersect){ // Wenn vorbelegung relevant
			ECL_EnableAttribute(sCB_Attribute);
			bEnabled = true;
		}
		
		
		if (bEnabled && bValueTrueAviable && bValueFalseAviable)// wenn noch nicht eingeschränkt und beides möglich, tue nichts
		{
			// alles ok, nichts ändern
		}
		else if (bEnabled && bValueTrueAviable && !bValueFalseAviable)// wenn noch nicht eingeschränkt aber nur KAG erlaubt
		{
			ECL_SelectValue(sCB_Attribute, "T");
			ECL_DisableAttribute(sCB_Attribute);
		}
		else if (bEnabled && !bValueTrueAviable && bValueFalseAviable)// wenn noch nicht eingeschränkt aber nur F erlaubt
		{
			ECL_DeselectAttribute(sCB_Attribute);
			ECL_DisableAttribute(sCB_Attribute);
		}
		else{
			// nicht enabled, also schon eingeschränkt
			if (bChecked && !bValueTrueAviable){
				// Fehler, nur noch KAG erlaubt, aber "F" gefordert
				return "Error";
			}
			if (!bChecked && !bValueFalseAviable){
				// Fehler, nur noch "F" erlaubt, aber KAG gefordert
				return "Error";
			}
		}
		// unbewertet ist automatisch default "F" also unchecked
	}
	else{
		// Fehler;
		return "Error";
	}
	return 0;
}

function GetDBDataSetEXT(sSQL)
{
	var aResult = [];
	aResult = Object.fromDatabase("EXTERNAL_DATA", sSQL);
	
	return aResult;
}


/**
	Setzt einen Merkmalswert auf Default, falls der Wert leer war.
	param Attribute: das Merkmal
	param strDefault: der Defaultwert 
*/
function ExecSetStandardifValueEmpty(Attribute, strDefault)
{
	var strValue = ECL_GetValue(Attribute);
	var aselection = ECL_GetAllActiveAttributeValues(Attribute);
	
	if (strDefault == "")
	{
		if (aselection.length > 0 && aselection.indexOf("STD") > -1)
		{
			strDefault = "STD";
		}
		if (aselection.length > 0 && aselection.indexOf("NON") > -1)
		{
			strDefault = "NON";
		}
		if (aselection.length > 0 && aselection.indexOf("F") > -1)
		{
			strDefault = "F";
		}
	}
	if(strValue == "")
	{
		if(ECL_ValueActive(Attribute, strDefault))
		{
			ECL_SelectValue(Attribute, strDefault);
			return true;
		}
		else
		{
			var aselection = ECL_GetAllActiveAttributeValues(Attribute);
			if(aselection.length > 0 )
			{
				ECL_SelectValue(Attribute, aselection[0]);
				return true;
			}
		}
	}
	else
	{
		var aselection = ECL_GetAllActiveAttributeValues(Attribute);
		
		if(aselection.length > 0)
		{
			for(var i=0;i<aselection.length;i++)
			{	
				if(strValue == aselection[i])
					return true;
			}
		}
		
		if(ECL_ValueActive(Attribute, strDefault))
		{
			ECL_SelectValue(Attribute, strDefault);
			return true;
		}
		else
		{
			var aselection = ECL_GetAllActiveAttributeValues(Attribute);
			if(aselection.length > 0)
			{
				ECL_SelectValue(Attribute, aselection[0]);
				return true;
			}
		}
		
	}
}

function isEmpty(obj) { 
   for (var x in obj) { return false; }
   return true;
}



/** 
entfernt ungültige Zeichen aus Textfeldern für KAG
*/
function normalizeOE_Attribute(sAttribute){
	var sValue = ECL_GetValue(sAttribute);

	sValue = sValue.replace("{", "(");
	sValue = sValue.replace("}", ")");
	sValue = sValue.trimLeft();
	sValue = sValue.trimRight();
	sValue = sValue.left(20);
	//sValue = sValue.replace("\\", "/");
	/*
	sValue = sValue.replace("Y50:", "");
	sValue = sValue.replace("Y52:", "");
	sValue = sValue.replace("Y58:", "");
	sValue = sValue.replace("Y59:", "");
	sValue = sValue.replace("Y60:", "");
	sValue = sValue.replace("Y61:", "");
	sValue = sValue.replace("Y68:", "");
	sValue = sValue.replace("Y74:", "");
	sValue = sValue.replace("Y75:", "");
	sValue = sValue.replace("Y76:", "");
	sValue = sValue.replace("Y79:", "");
	sValue = sValue.replace("Y80:", "");
	sValue = sValue.replace("Y81:", "");
	sValue = sValue.replace("Y82:", "");
	sValue = sValue.replace("Y84:", "");
	sValue = sValue.replace("Y85:", "");
	sValue = sValue.replace("Y88:", "");
	
	sValue = sValue.replace(/[&#+$~%'":*?<>]/g, '');
	sValue = toupper(sValue);
	*/
	ECL_SetValue(sAttribute, sValue);
	return sValue;

}

/**
Die folgende Funktion gibt die in der MLFB ggf. vorhandene KAG zu einem gegebenen Attribut zurück
*/
function getKAGforAttribute(sAttributeName, aKAG_List)
{
	var sValue = "NON";
	var aResult = Object.fromDatabase("G220_ADD_DATA", "select distinct Wert_ID from DATA WHERE IsKAG = 'x' AND Attribute = '" + sAttributeName + "'");
	
	if (aResult.length > 0 && !isEmpty(aKAG_List) ){
		for(var i=0;i<aResult.length;i++)
		{
			var sKAG = aResult[i].WERT_ID;
			if (aKAG_List.indexOf(sKAG) > -1){
				sValue = sKAG;
				break;
			}
		}
	}
	return sValue;
}

function isValueInArray(value, array)
{
	for(var i=0; i < array.length; i++)
	{
		if(array[i] == value)
		{
			return true;
		}
	}
	return false;
}

function replaceAt(string, index, replace) {
  return string.substring(0, index) + replace + string.substring(index + 1);
}

// n_pos startet bei 0				aus 1FK2
function replaceChar(s_src, s_char, n_pos)
{
  if(s_src.length() < n_pos)
	return s_src;
  var s=s_src.left(n_pos) + s_char + s_src.substring(n_pos + 1);
  return s;
}

function isKAGinMLFB(aArray, sKAG)
{
    for(var i=0;i<aArray.length;i++)
    {
        if(aArray[i]==sKAG)
            return true;
    }
    
    return false;	
}