﻿//@legacy
//#mode(full-ecma)


//@import "StringHandler.js"
//@import "Parser.common.js"
//@import "Parser.tokenizer.js"

//@import "../G220_MLFB/Base.misc.js"
//@import "../G220_CONFIG/CFG_G220_VT.js"

/**
 * @category   G220 Parser
 * @package    Parser
 * @copyright  Copyright (c) 2023 Plan Software GmbH (http://www.plansoft.de)
 */
function parse_Init_G220( strMLFB )
{
	var vtTimeStart	= Date.getTime();
	
	var oParsing = {
		strBaseMLFB : '',
		strFullMLFB : '',
		strError    : '',
		strWarning  : '',
		aTokens     : [],
		oFreetext   : {}
	};
	
	var strBaseTypeMLFB = ECL_GetValue("ECSI_MLFB_BASE_TYPE");
	var strSeriesID 	= ECL_GetValue("ECSI_CX_SeriesID");
	oParsing.SeriesID = strSeriesID;

	strMLFB = normalizeMLFB( strMLFB );
	strBaseTypeMLFB = normalizeMLFB( strBaseTypeMLFB );
	
	ECL_SetValue("ECSI_MLFB", strMLFB);
	
	var strStartConfiguration=ECL_GetValue("ECSI_IS_START_CONFIGURATION");
	
	if(strStartConfiguration=="" && find(strMLFB.left(16), ".") >= 0){
		strStartConfiguration= "1";
	}
	
	//Es kann vorkommen, dass die MLFB fehlerhalt ist bei Keep Configuration, dann soll die BaseType MLFB genommen werden ohne Keep Configuration
	if(strStartConfiguration== "1" && find(strMLFB.left(16), ".") >= 0 && strBaseTypeMLFB!="")
	{
		strMLFB=strBaseTypeMLFB;
	}
	
	var sECSI_CX_SafetyFunctions = ECL_GetValue("ECSI_CX_SafetyFunctions");
	if (sECSI_CX_SafetyFunctions && sECSI_CX_SafetyFunctions !== "" && sECSI_CX_SafetyFunctions.indexOf("15") > -1){
		var bSMTmandatory = true;
		oParsing.SMTmandatory = "true";
	}else{
		oParsing.SMTmandatory = "false";
	}

	//Entweder kommt eine zur Haupt MLFB unterschiedliche Base Type MLFB aus dem SIZER.
	//Hier sollen dann möglichst viele Attribute beibehalten werden.
	//Die Basetype MLFB kann sich in MLFB und KAGs von der Haupt MLFB unterscheiden.
	if(strBaseTypeMLFB != "")
	{
		
		//--------------------------------------------------------------------------------------------------------
		// Base Type  MLFB aufbereiten
		//--------------------------------------------------------------------------------------------------------
		var nFreetextBT = find(strBaseTypeMLFB,'{');
		var strFreetextBT = '';
		if (nFreetextBT > 0){
			strFreetextBT = strBaseTypeMLFB.right(strBaseTypeMLFB.length-nFreetextBT+1);
		}
		var oFreetextBT = parseFreetext( strFreetextBT, true );
		strBaseTypeMLFB = replace(strBaseTypeMLFB,strFreetextBT,"");
		var strFullMLFB_BT = strBaseTypeMLFB;
		
		var aBTComponents = tokenize( strBaseTypeMLFB );
		if ( aBTComponents.length > 1 )
		{
			// some @%$§/%%§ deliver the MLFB with some space between the last digit and the -Z for short descriptions ->
			// eliminate the resulting invalid short description 'Z'
			if ( ( aBTComponents[1] === 'Z' ) || ( aBTComponents[1] === '-Z' ) ){
				aBTComponents = removeElementsFromArray( aBTComponents, 1, 1 );
			}
		}
		
		strBaseTypeMLFB = aBTComponents[0];
		
		if ( strBaseTypeMLFB.length === 17 ){
			// eliminate the -Z 
			strBaseTypeMLFB = strBaseTypeMLFB.substring( 0, 16 );
		}
		
		
		/* Wildcards at MLFB09, MLFB10, MLFB13, MLFB14, MLFB15
		*/
		
		var strBaseTypeMLFB_fix = strBaseTypeMLFB;
	}
	
	
	var oResult;
	
	var nFreetext = find(strMLFB,'{');
	var strFreetext = '';
	if (nFreetext > 0){
		strFreetext = strMLFB.right(strMLFB.length-nFreetext+1);
	}
	oParsing.oFreetext = parseFreetext( strFreetext, true );
	strMLFB = replace(strMLFB,strFreetext,"");
	oParsing.strFullMLFB = strMLFB;
	
	var aComponents = tokenize( strMLFB );
	if ( !aComponents.length ){
		oParsing.strError = 'ERRORMSG_MLFB_G220___INVALID_MLFB';
		return( oParsing )
	} else if ( aComponents.length > 1 ){
		// some @%$§/%%§ deliver the MLFB with some space between the last digit and the -Z for short descriptions ->
		// eliminate the resulting invalid short description 'Z'
		if ( ( aComponents[1] === 'Z' ) || ( aComponents[1] === '-Z' ) ){
			aComponents = removeElementsFromArray( aComponents, 1, 1 );
		}
	}
	oParsing.strBaseMLFB = aComponents[0];
	oParsing.aTokens = aComponents;
	
	var strMLFB_fix = strMLFB.substring( 0, 16 );
	
	// Wildcards at MLFB09, MLFB10, MLFB13, MLFB14, MLFB15
	if (strBaseTypeMLFB.charAt(8) == "."){
		strMLFB_fix = replaceAt(strMLFB_fix, 8, ".");
	}
	if (strBaseTypeMLFB.charAt(9) == "."){
		strMLFB_fix = replaceAt(strMLFB_fix, 9, ".");
	}
	if (strBaseTypeMLFB.charAt(12) == "."){
		strMLFB_fix = replaceAt(strMLFB_fix, 12, ".");
	}
	if (strBaseTypeMLFB.charAt(13) == "."){
		strMLFB_fix = replaceAt(strMLFB_fix, 13, ".");
	}
	if (strBaseTypeMLFB.charAt(14) == "."){
		strMLFB_fix = replaceAt(strMLFB_fix, 14, ".");
	}
	
	// EDIT KEEP CONF
	var isKeepConfig = false;
	var ECSI_CX_Ip = ECL_GetValue("ECSI_CX_FrequencyConverterDefaultIpProtectionLevel") || "";

	if (((strSeriesID == "72020" || strSeriesID == "72220") && (strMLFB.charAt(8) == "K" || strMLFB.charAt(8) == "M" )) ||
		((ECSI_CX_Ip == "20") && (strMLFB.charAt(8) == "K" || strMLFB.charAt(8) == "M" )) ||
		((strSeriesID == "72050" || strSeriesID == "72250") && (strMLFB.charAt(8) == "C" || strMLFB.charAt(8) == "D" )) ||
		((ECSI_CX_Ip == "55") && (strMLFB.charAt(8) == "C" || strMLFB.charAt(8) == "D" ))
	){
		isKeepConfig = true;
	}
	// EDIT RepairConfig added
	if(strStartConfiguration=="1" && strBaseTypeMLFB_fix==strMLFB_fix && strBaseTypeMLFB != "" && find(strMLFB.left(16), ".") < 0)   // if same motor is selected again
	{
		var bRepairConfig = true;
	}
	// -----------------------------------------------------------------------------------------------
	// Überprüfung, ob sich die MLFB im Vergleich zur Base Type MLFB unterscheidet
	// -----------------------------------------------------------------------------------------------
	if( (strBaseTypeMLFB_fix !== strMLFB_fix) && (find(strMLFB.left(16), ".") < 0 && (strBaseTypeMLFB !== "")) || isKeepConfig || bRepairConfig)
	{
		// -----------------------------------------------------------------------------------------------
		// KAG abgleichen und ggf übernehmen/entfernen
		// -----------------------------------------------------------------------------------------------
		
		// -----------------------------------------------------------------------------------------------
		// Platzhalter aus MLFB in BT übernehmen
		// -----------------------------------------------------------------------------------------------
		// Wildcards at MLFB09, MLFB10, MLFB13, MLFB14, MLFB15
		// Stelle 9
		var sMLFB09 = strMLFB.charAt(8);
		var sBT_MLFB09 = strBaseTypeMLFB.charAt(8);

		if (sBT_MLFB09 == "."){
			ECL_ActivateAllAttributeValues("MLFB09_G220");

			if (strSeriesID == "72020" || strSeriesID == "72220")
			{
				// IP20, 3C2 or 3C3, no repair switch	EDIT_02/2024: 3C2 only
				// sMLFB09 = "C" // 3C2 || sMLFB09 = "D" // 3C3
				
				ECL_DeactivateValue("MLFB09_G220", "K");
				ECL_DeactivateValue("MLFB09_G220", "M");
				
				//if (sMLFB09 !== "C" /*&& sMLFB09 !== "D"*/){
					var sMLFB09 = "C"; 
				//}
				
			}else if (strSeriesID == "72050" || strSeriesID == "72250"){
				// IP 55, 3C3 only, with ("M") or without repair switch ("K")
				ECL_DeactivateValue("MLFB09_G220", "C");
				ECL_DeactivateValue("MLFB09_G220", "D");

				if (sMLFB09 !== "K" && sMLFB09 !== "M"){
					var sMLFB09 = "K"; 
				}
			}
			strBaseTypeMLFB = replaceAt(strBaseTypeMLFB, 8, sMLFB09);
		}else{
			ECL_DeactivateAllAttributeValues("MLFB09_G220");
			ECL_ActivateValue("MLFB09_G220", sBT_MLFB09);
			ECL_SelectValue("MLFB09_G220", sBT_MLFB09);
		}
		
		
		// Stelle 10
		var sMLFB10 = strMLFB.charAt(9);
		var sBT_MLFB10 = strBaseTypeMLFB.charAt(9);
		
		if (sBT_MLFB10 == "."){
			// todo check-routine
			if (strSeriesID == "72020" || strSeriesID == "72220"){
				// IP 20 00003: w/o only
				sMLFB10 = "A";
			}else if (strSeriesID == "72050" || strSeriesID == "72250"){
				// IP 55 todo w/o available???
			}
			// sMLFB10 = check_MLFB10(strBaseTypeMLFB, sMLFB10);
			strBaseTypeMLFB = replaceAt(strBaseTypeMLFB, 9, sMLFB10);
		}
		// Stelle 13	EMC Filter
		var sMLFB13 = strMLFB.charAt(12);
		var sBT_MLFB13 = strBaseTypeMLFB.charAt(12);
		
		if (sBT_MLFB13 == "."){
			// todo check-routine
			// sMLFB13 = check_MLFB13(strBaseTypeMLFB, sMLFB13);
			strBaseTypeMLFB = replaceAt(strBaseTypeMLFB, 12, sMLFB13);
		}
		// Stelle 14
		var sMLFB14 = strMLFB.charAt(13);
		var sBT_MLFB14 = strBaseTypeMLFB.charAt(13);
		
		if (sBT_MLFB14 == "."){
			// todo check-routine
			// sMLFB14 = check_MLFB14(strBaseTypeMLFB, sMLFB14);
			if (bSMTmandatory){
				var bT01 = isKAGinMLFB(aComponents, "T01");
				var bT04 = isKAGinMLFB(aComponents, "T04");
				var bT05 = isKAGinMLFB(aComponents, "T05");
				if (sMLFB14 == "A" && (bT01 || bT04 || bT05)){
					sMLFB14 = "A";
				}else if (sMLFB14 == "A" && (!bT01 && !bT04 && !bT05)){
					sMLFB14 = "F";
				}else{
					sMLFB14 = "A";
				}
			}
			strBaseTypeMLFB = replaceAt(strBaseTypeMLFB, 13, sMLFB14);
		}
		
		// Stelle 15 
		var sMLFB15 = strMLFB.charAt(14);
		var sBT_MLFB15 = strBaseTypeMLFB.charAt(14);
		
		if (sBT_MLFB15 == "."){
			// todo check-routine in STEP 2
			// sMLFB15 = check_MLFB15(strBaseTypeMLFB, sMLFB15);
			strBaseTypeMLFB = replaceAt(strBaseTypeMLFB, 14, sMLFB15); // allways "F" in step 1
		}
		
		// -----------------------------------------------------------------------------------------------
		// Zuweisen der neuen MLFB und KAG-Liste
		strMLFB = strBaseTypeMLFB.substring( 0, 16 ) + strMLFB.substring(16);
		
		oParsing.strBaseMLFB = strBaseTypeMLFB.substring( 0, 16 );
		oParsing.strFullMLFB = strMLFB;
		aComponents[0]=oParsing.strBaseMLFB;
		oParsing.aTokens = aComponents;
		ECL_SetValue("ECSI_MLFB", strMLFB);
		// END KEEP CONF
	}
	else{
		// --------------------------------------------------------------------------------------
		// Wildcards füllen
		// --------------------------------------------------------------------------------------
		// Wildcards at MLFB09, MLFB10, MLFB13, MLFB14, MLFB15
		if(find(strMLFB.left(16), ".") >= 0){
			//Unvollständige SIZER MLFB
			
			// Prüfen, ob '.' an festen Stellen, dann Fehler
			for (var i = 0; i < 16; i++){
				if ( i == 8 || i == 9 || i == 12  || i == 13 || i == 14){
					continue;
				}
				if (strMLFB.charAt(i) == "."){
					oParsing.strError = 'DICT1_ERR_G220___INCOMPLETE_MLFB';
					return( oParsing );
				}
			}
			
			// Wenn an Stelle (09), 10, 13, 14 oder 15 ein Wildcard, dann Default setzen
			
			// MLFB09	Protection (Abhängig von SeriesID, 3C2 and 3C3 selectable.
			var sMLFB09 = strMLFB.charAt(8)
			ECL_DeactivateAllAttributeValues("MLFB09_G220");
			if (sMLFB09 == "."){
				
				if (strSeriesID == "72020" || strSeriesID == "72220"){
					// IP20, 3C2 or 3C3, no repair switch				EDIT_02/2024: 3C2 only
					// sMLFB09 = "C" // 3C2 || sMLFB09 = "D" // 3C3
					ECL_ActivateValue("MLFB09_G220", "C");
					//ECL_ActivateValue("MLFB09_G220", "D");

					sMLFB09 = "C";  
				}else if (strSeriesID == "72050" || strSeriesID == "72250"){
					// IP 55, 3C3 only, with ("M") or without repair switch ("K")
					ECL_ActivateValue("MLFB09_G220", "K");
					ECL_ActivateValue("MLFB09_G220", "M");
					sMLFB09 = "K";  
				}
				strMLFB = replaceAt(strMLFB, 8, sMLFB09);
			}else{
				ECL_ActivateValue("MLFB09_G220", sMLFB09);
				ECL_SelectValue("MLFB09_G220", sMLFB09);
			}
			
			
			// MLFB10 Hardware option
			if (strMLFB.charAt(9) == "."){
				strMLFB = replaceAt(strMLFB, 9, "A"); 
				// todo, if IP55: is w/o available???
				/**if (strSeriesID == "72020" || strSeriesID == "72220"){
					// IP 20 00003: w/o only
					sMLFB10 = "A";
				}else if (strSeriesID == "72050" || strSeriesID == "72250"){
					// IP 55 todo w/o available???
				} */
			}
			// MLFB13 EMC-Filter
			if (strMLFB.charAt(12) == "."){
				strMLFB = replaceAt(strMLFB, 12, "0"); // unfiltered
			}
			
			// MLFB14 additional hardware options
			if (strMLFB.charAt(13) == "."){
				if (bSMTmandatory){
					strMLFB = replaceAt(strMLFB, 13, "F");
				}else{
					strMLFB = replaceAt(strMLFB, 13, "A");
				}
			}
			// MLFB15	Fieldbus F: F=Profinet / Ethernet IP 		default / single option in step 1 
			if (strMLFB.charAt(14) == "."){
				
				strMLFB = replaceAt(strMLFB, 14, "F");
			}
		}
		
		oParsing.strBaseMLFB = strMLFB.substring( 0, 16 );
		oParsing.strFullMLFB = strMLFB;
		aComponents[0]=oParsing.strBaseMLFB;
		oParsing.aTokens = aComponents;
		//oParsing.oFreetext = 
		ECL_SetValue("ECSI_MLFB", strMLFB);
		
	}
	
	
	
	if ( oParsing.strBaseMLFB.length !== 16 ){
		// Prüfen, ob die Zeichenkette 16 Stellen hat
		oParsing.strError = 'ERRORMSG_MLFB_G220___PARSE_WRONG_SIZE';
		return( oParsing );
	}
	
	if ( oParsing.strBaseMLFB.indexOf("6SL411") < 0){
		// Falsches Produkt
		oParsing.strError = 'ERRORMSG_MLFB_G220___PARSE_WRONG_PRODUCT';
		return( oParsing );
	}
	
	var oResult;
	oResult = parse_G220(oParsing.aTokens);
//	oResult = add_help_shortcuts(oResult);
	
	if ( oResult ) {
		if ( oResult.oProduct )
			oParsing.oProduct = oResult.oProduct;
		if ( oResult.oParsingData )
			oParsing.oParsingData = oResult.oParsingData;
		oParsing.strError += ( ( oParsing.strError ? ' ' : '' ) + oResult.strError );
		oParsing.strWarning += ( ( oParsing.strWarning ? ' ' : '' ) + oResult.strWarning );
		
		oParsing.IsStartConfig = strStartConfiguration;
	}
	
	var vtTimeStop	= Date.getTime();
	var vtTime		= (vtTimeStop - vtTimeStart) / 1000;
	logtraceln("******* Parse - Time: "+vtTime+" sec"+"\n");

	return( oParsing );
}

function parse_G220( aTokens ) {
	var oResult = {
		strError: '',
		strRegion: '',
		strWarning: '',
		oProduct: null,
		oParsingData: {}
	};
	
	var strBaseMLFB = aTokens[0];
	oResult.oParsingData.MLFB = {};
	oResult.oParsingData.MLFB.POS1 = strBaseMLFB.charAt( 0 );	// 6
	oResult.oParsingData.MLFB.POS2 = strBaseMLFB.charAt( 1 );	// S
	oResult.oParsingData.MLFB.POS3 = strBaseMLFB.charAt( 2 );	// L
	oResult.oParsingData.MLFB.POS4 = strBaseMLFB.charAt( 3 );	// 4
	oResult.oParsingData.MLFB.POS5 = strBaseMLFB.charAt( 4 );	// 1
	oResult.oParsingData.MLFB.POS6 = strBaseMLFB.charAt( 5 );	// 1 CU-Type
	oResult.oParsingData.MLFB.POS7 = strBaseMLFB.charAt( 6 );	// Line voltage
	oResult.oParsingData.MLFB.POS8 = strBaseMLFB.charAt( 7 );	// Topology (HW option) (0 - Standard, 2 - Clean Power, 1 - Regenerative)
	oResult.oParsingData.MLFB.POS9 = strBaseMLFB.charAt( 8 );	// . Protection class (C/D - IP20, K - IP55/UL-type 12, M - rep. switch, 3C2/3C3)
	oResult.oParsingData.MLFB.POS10 = strBaseMLFB.charAt( 9 ); 	// . HW-configuration (Glandplate P - IEC / Q - NEC @IP55, ...)
	oResult.oParsingData.MLFB.POS11 = strBaseMLFB.charAt( 10 );	// Leistung 1 (0,55 – 55kW) Step1 till 55kW, 
	oResult.oParsingData.MLFB.POS12 = strBaseMLFB.charAt( 11 );	// Leistung 1
	oResult.oParsingData.MLFB.POS13 = strBaseMLFB.charAt( 12 ); // . Platzhalter EMC-Filter (1 - C1, 2 - C2, 3 - C3, 0 - UF)
	oResult.oParsingData.MLFB.POS14 = strBaseMLFB.charAt( 13 ); // . Platzhalter additional HW option (F – OM-SMT, B – OM-DQ, E – OM-IIoT, SDI pro, ...)
	oResult.oParsingData.MLFB.POS15 = strBaseMLFB.charAt( 14 ); // . Platzhalter fieldbus (F - PN, D - DP, B - RS485, A - No Fielbus)
	oResult.oParsingData.MLFB.POS16 = strBaseMLFB.charAt( 15 ); // 0 Version
	
	ECL_SelectValue("MLFB05_G220", oResult.oParsingData.MLFB.POS5 );
	ECL_SelectValue("MLFB06_G220", oResult.oParsingData.MLFB.POS6 );
	ECL_SelectValue("MLFB07_G220", oResult.oParsingData.MLFB.POS7 );
	ECL_SelectValue("MLFB08_G220", oResult.oParsingData.MLFB.POS8 );
	ECL_SelectValue("MLFB09_G220", oResult.oParsingData.MLFB.POS9 );
	ECL_SelectValue("MLFB10_G220", oResult.oParsingData.MLFB.POS10 );
	ECL_SelectValue("MLFB11_G220", oResult.oParsingData.MLFB.POS11 );
	ECL_SelectValue("MLFB12_G220", oResult.oParsingData.MLFB.POS12 );
	ECL_SelectValue("MLFB13_G220", oResult.oParsingData.MLFB.POS13 );
	ECL_SelectValue("MLFB14_G220", oResult.oParsingData.MLFB.POS14 );
	ECL_SelectValue("MLFB15_G220", oResult.oParsingData.MLFB.POS15 );
	ECL_SelectValue("MLFB16_G220", oResult.oParsingData.MLFB.POS16 );

	// -Z HW options & licenses
	/* Z-Option Name 	MLFB14
		T01 OM-DQ 		B
		T04 OM-IIoT 	E
		T05 OM-SMT 		F
		T06 OM-ENC1 	G
		T07 OM-ENC2 	H
		T10 OM-DIO1 	L
		T11 OM-AIO1 	K
		*/
	oResult.oParsingData.MLFB.POS1_5 	= strBaseMLFB.substring(0, 5); // 6SL41
	oResult.oParsingData.RatedPower 	= strBaseMLFB.charAt( 10 ) + strBaseMLFB.charAt( 11 ); // Leistung aus MLFB 11+12
	
	// Kurzangaben
	if (aTokens.length > 0){
		if (aTokens[0] === strBaseMLFB){
			aTokens = removeElementsFromArray( aTokens, 0, 1 );
		}
		oResult.oParsingData.MLFB.KAG = aTokens;
		
		oResult.oParsingData.MLFB.KAG_LIST = getKAGAsList(aTokens);
	}
	
	return oResult;
}

/**
	Fügt weitere Produktinfos hinzu, die in der Datenbank häufiger genutzt werden.
*/
function add_help_shortcuts(oResult)
{
	var mlfbObj = oResult.oParsingData.MLFB;
	
	return oResult;
}

/**
	Liefert Semicolon-getrennte Liste aller vorh. Kurzangaben
*/
function getKAGAsList(aTokens){
	var kagString = "";
	for (var i = 0; i < aTokens.length; i++) {
		kagString += aTokens[i];
		if (i < aTokens.length - 1){
			kagString += ";";
		}
	}
	return kagString;
}

function SetFreetextValue(field, value) {
	
	value = trimleft(value, '*');
	value = trimright(value, '*');
	
	ECL_SetValue(field, value);
}

function SetFreetextValueY61(field, value) {
	
	value = trimleft(value, '*');
	value = trimright(value, '*');
	// Freitext bereinigen
	value = replace(value, " ", "");
	ECL_SetValue(field, value);
}


function SetFREETEXTS(oParse) {

/*	zur Info - oParse: 
	{
		strBaseMLFB : '',
		strFullMLFB
		strError : '',
		strWarning : '',
		aTokens : [],
		oFreetext : {}
	};
*/
/*	
	if (find(oParse.strFullMLFB , 'Y84') >= 0) {
		if (oParse.oFreetext['Y84']) SetFreetextValue('OE_ZEICHEN_L_SCHILD_1LE1X', oParse.oFreetext['Y84']);
	}
*/
}

function isKAGinMLFB(aArray, sKAG)
{
	for(var i=0;i<aArray.length;i++)
	{
		if(aArray[i]==sKAG)
			return true;
	}
	
	return false;	
}
