﻿//@legacy
//#mode(full-ecma)


//@import "CFG_S150_VT.js"

// ---------------------------------------------------------------------------------
// Bestimme die Consequences aus einer gegebenen Konfiguration

// ###################################################################################################################################
// Consequence-Attributes
// ###################################################################################################################################
/**
* ControlUnit
* FieldbusInterface
* BrakingResistorID
* SelectedCustomBrakingResistor
* BrakeRelays
* BrakingModuleID
* 
* DQ Endpoint - true
*
* FieldbusInterface - PROFINET / PROFIBUS
*
* IpProtectionLevelFrequencyConverter - Based on the selection
*
* IsProtectedDevice - If L26 selected
* OutputReactorOrFilter ???
* OutputReactorOrFilterType - 1,3,4,5 - Based on the selection
* 
* InputFilterType			- If Line Filter selected 0, by default 3		LineFilter L00
* ExternalFilterType	- If Line Filter selected 2, by default 0		LineFilter L00
* 
* MaxOutputFrequencyLimit	
* 	- Sine-wave filter: The output frequency is limited to max. 150 Hz
*		- dv/dt filter: max 150 Hz
* MaxPulseFrequency
* 	- Sine-wave filter: Double of the default pulse frequency
*  	- dv/dt filter: 380-480V  && "<= 250 kW", 4kHz; other cases: 2,5 kHz
* MinPulseFrequency
* 	- Sine-wave filter: Double of the default pulse frequency [Add image]
* 		kW	  			default pulse freq [kHz]	MLFB10_S150
* 		110...250		3AC 380...480V: 2			  	E
* 		315...800		3AC 380...480V: 1.25			E
* 		 75...1200	3AC 500...690V: 1.25	  	G
*
* ECSI_CC_Selected_PMs
*/

function determineConsequencesS150(sECSI_MLFB) {
  var strErr = "";

  var oConsequences = {
    ControlUnit: getControlUnit_S150(),
    FieldbusInterface: getFieldbusInterface_S150(),
    InputFilterType: getInputFilterType_S150(),
    ExternalFilterType: getExternalFilterType_S150(),
    MinPulseFrequency: getMinPulseFrequency_S150(),
    MaxOutputFrequencyLimit: getMaxOutputFrequencyLimit_S150(),
    MaxPulseFrequency: getMaxPulseFrequency_S150(),
    OutputReactorOrFilterType: getOutputReactorOrFilterType_S150(),
    OutputReactorOrFilter: getOutputReactorOrFilter_S150(),
    IpProtectionLevelFrequencyConverter: getIpProtectionLevelFrequencyConverter_S150(),
    BrakingResistorID: getBrakingResistorID_S150(),
    //BrakingModuleID				: getBrakingModuleID_S150(),
    //AllowedControlModes		: getAllowedControlModes_S150(),
    IsProtectiveDevice: getIsProtectiveDevice_S150(),
    DQEndpoint: true, //getDQEndpoint_S150(),
    Selected_CU: "S150",
    Selected_PMs: "ALM_1|MoMo_1", //getSelected_PMs(),
    VSM4Motor: getVSM4Motor_S150(),
    Selected_TM31_1: getTM31_1_S150(),
    Selected_TM31_2: getTM31_2_S150(),
    Selected_TM150_1: getTM150_1_S150(),
    Selected_TM54F: getTM54F_S150(),
    Selected_SMC10: getSMC10_S150(),
    Selected_SMC20: getSMC20_S150(),
    Selected_SMC30_1: getSMC30_1_S150(),
    Selected_SMC30_2: getSMC30_2_S150(),
    Error_Message: strErr,
  };

  return oConsequences;
}

function getControlUnit_S150() {
  return "";
}

function getFieldbusInterface_S150() {
  if (ECL_ValueSelected("CB_O_CU3202_S150", "T")) {
    // if K95: 0, Profinet, else Profibus:1
    return "0";
  } else {
    return "1";
  }
}
/**
 * O_UMGEBUNG_L00_S150 ==> LineFilter
 * 	ExternalFilterType - If Line Filter selected 2, by default 0
 * 	InputFilterType - If Line Filter selected 0, by default 3
 */
function getInputFilterType_S150() {
  var O_UMGEBUNG_L00_S150 = "NON";
  if (ECL_ValueSelected("CB_O_UMGEBUNG_L00_S150", "T")) {
    O_UMGEBUNG_L00_S150 = "L00";
  }

  switch (O_UMGEBUNG_L00_S150) {
    case "NON": // ohne C3
      var InputFilterType = "3";
      break;
    case "L00":
      var InputFilterType = "0";
      break;
    default:
      var InputFilterType = "3";
  }
  return InputFilterType;
}

function getExternalFilterType_S150() {
  var O_UMGEBUNG_L00_S150 = "NON";
  if (ECL_ValueSelected("CB_O_UMGEBUNG_L00_S150", "T")) {
    O_UMGEBUNG_L00_S150 = "L00";
  }

  switch (O_UMGEBUNG_L00_S150) {
    case "NON": // ohne C3
      var ExternalFilterType = "0";
      break;
    case "L00":
      var ExternalFilterType = "2";
      break;
    default:
      var ExternalFilterType = "0";
  }
  return ExternalFilterType;
}
function getOutputReactorOrFilterType_S150() {
  // OutputReactorOrFilterType
  /* Integer
    0	No output reactor or filter selected
    1	Single motor reactor selected
    2	Two motor reactor in series selected
    3	Sinus filter selected
    4	du/dt filter selected
    5	du/dt filter compact selected
  */
  var OutputReactorOrFilterType = 0;

  var O_AUSGANG_S150 = ECL_GetValue("O_AUSGANG_S150");
  switch (O_AUSGANG_S150) {
    case "NON":
      OutputReactorOrFilterType = 0;
      break;
    case "L07": //dv/dt compact
      OutputReactorOrFilterType = 5;
      break;
    case "L08": // motor reactor
      OutputReactorOrFilterType = 1;
      break;
    case "L10": //dv/dt
      OutputReactorOrFilterType = 4;
      break;
    case "L15": // sine-wave
      OutputReactorOrFilterType = 3;
      break;
    default:
      OutputReactorOrFilterType = 0;
  }

  return OutputReactorOrFilterType;
}

function getOutputReactorOrFilter_S150() {
  /** OutputReactorOrFilter	
    String	
    This parameter defines the order number for a selected output reactor or filter.	
        String.Empty	No output reactor or filter selected
        String			Order number as MLFB without separating "-"

    */
  return "";
}

function getIpProtectionLevelFrequencyConverter_S150() {
  // O_SCHUTZART_S150  	Schutzart
  var IpProtectionLevelFrequencyConverter = "";
  /*O_SCHUTZART_S150
  NON	Standard
  STD	IP20
  M21	IP21 (M21)
  M23	IP23 (M23)
  23STD	IP23 (Standard)
  M43	IP43 (M43)
  M54	IP54 (M54)
  */
  var O_SCHUTZART_S150 = ECL_GetValue("O_SCHUTZART_S150");

  switch (O_SCHUTZART_S150) {
    case "NON":
    case "STD":
      IpProtectionLevelFrequencyConverter = "20";
      break;
    case "M21":
      IpProtectionLevelFrequencyConverter = "21";
      break;
    case "M23":
    case "23STD":
      IpProtectionLevelFrequencyConverter = "23";
      break;
    case "M43":
      IpProtectionLevelFrequencyConverter = "43";
      break;
    case "M54":
      IpProtectionLevelFrequencyConverter = "54";
      break;
  }
  return IpProtectionLevelFrequencyConverter;
}

function getBrakingResistorID_S150() {
  var O_BREMSEINHEIT_S150 = ECL_GetValue("O_BREMSEINHEIT_S150");
  var MLFB10_S150 = ECL_GetValue("MLFB10_S150");

  /*var HMK_SPANNUNG_BEREICH_S150 = "400";
  /* HMK_SPANNUNG_BEREICH_S150 IN_SPANNUNG_S150 MLFB10_S150
      400	                     380…480 V         E
      600	                     500…600 V         G
      690	                     660…690 V         G
  * /
  var IN_SPANNUNG_S150 = parseInt(ECL_GetValue("IN_SPANNUNG_S150"));
  if (IN_SPANNUNG_S150 <= 480) {
    HMK_SPANNUNG_BEREICH_S150 = "400";
  } else if (IN_SPANNUNG_S150 <= 600) {
    HMK_SPANNUNG_BEREICH_S150 = "600";
  } else if (IN_SPANNUNG_S150 > 600) {
    HMK_SPANNUNG_BEREICH_S150 = "690";
  } else {
    return "ERROR";
  }
  */

  if (O_BREMSEINHEIT_S150 == "NON") {
    return "";
  }

  var sTable = "BrakeID";
  var sSQL = "SELECT DISTINCT SZ_BR_ID FROM " + sTable + " WHERE " +
    "O_BREMSEINHEIT_S150 = '" + O_BREMSEINHEIT_S150 + "' AND " +
    "MLFB10_S150 = '" + MLFB10_S150 + "';";

  var aResult = Object.fromDatabase("S150_ADD_DATA", sSQL);

  if (aResult.length > 0) {
    var BrakingResistorID = aResult[0].SZ_BR_ID;
  } else {
    return "ERROR";
  }
  return BrakingResistorID;
}
function getBrakingModuleID_S150() {
  var O_BREMSEINHEIT_S150 = ECL_GetValue("O_BREMSEINHEIT_S150");
  var MLFB10_S150 = ECL_GetValue("MLFB10_S150");

  if (O_BREMSEINHEIT_S150 == "NON") {
    return "";
  }

  /*var HMK_SPANNUNG_BEREICH_S150 = "400";
  /*IN_SPANNUNG_S150  HMK_SPANNUNG_BEREICH_S150 MLFB10_S150
    400	              380…480 V                 E
    600	              500…600 V                 G
    690	              660…690 V                 E
  * /
  var IN_SPANNUNG_S150 = parseInt(ECL_GetValue("IN_SPANNUNG_S150"));
  if (IN_SPANNUNG_S150 <= 480) {
    HMK_SPANNUNG_BEREICH_S150 = "400";
  } else if (IN_SPANNUNG_S150 <= 600) {
    HMK_SPANNUNG_BEREICH_S150 = "600";
  } else if (IN_SPANNUNG_S150 > 600) {
    HMK_SPANNUNG_BEREICH_S150 = "690";
  } else {
    return "ERROR";
  }
  */

  var sTable = "BrakeID";
  var sSQL = "SELECT DISTINCT SZ_BR_ID FROM " + sTable + " WHERE " +
    "O_BREMSEINHEIT_S150 = '" + O_BREMSEINHEIT_S150 + "' AND " +
    "MLFB10_S150 = '" + MLFB10_S150 + "';";

  var aResult = Object.fromDatabase("S150_ADD_DATA", sSQL);

  if (aResult.length > 0) {
    var BrakingModuleID = aResult[0].SZ_BR_ID;
  } else {
    return "ERROR";
  }
  return BrakingModuleID;
}

function getMaxOutputFrequencyLimit_S150() {
  var ConverterRatedPower = parseFloat(ECL_GetValue("ECSI_CX_ConverterRatedPower"));
  var MLFB10_S150 = ECL_GetValue("MLFB10_S150");

  var sWhereConverterRating = "";

  if (MLFB10_S150 == "E") {
    if (ConverterRatedPower <= 250) {
      var ConverterRating = "110_250";
    } else {
      var ConverterRating = "315_800";
    }
    sWhereConverterRating = "ConverterRating = '" + ConverterRating + "' AND ";
  }

  var sTable = "PulseFrequency";

  var sSQL = "SELECT * FROM " + sTable + " WHERE " + sWhereConverterRating + "MLFB10_S150 = '" + MLFB10_S150 + "';";

  var aResult = Object.fromDatabase("S150_ADD_DATA", sSQL);

  if (aResult.length > 0) {
    var MaxOutputFrequencyLimit = ""; //without Line-side comps, no derating! aResult[0].MAXOUTPUTFREQUENCY_DEFAULT;
    // if dv/dt-filter or motor reactor selected
    var O_AUSGANG_S150 = ECL_GetValue("O_AUSGANG_S150");
    if (O_AUSGANG_S150 == "L07" || O_AUSGANG_S150 == "L08" || O_AUSGANG_S150 == "L10") {
      // dv/dt-filter
      MaxOutputFrequencyLimit = aResult[0].MAXOUTPUTFREQUENCY_DV_DT;
    }
    // if sine-wave-filter selected
    if (O_AUSGANG_S150 == "L15") {
      // sine-wave-filter
      MaxOutputFrequencyLimit = aResult[0].MAXOUTPUTFREQUENCY_SINE_WAVE;
    }
  } else {
    return "ERROR";
  }
  return MaxOutputFrequencyLimit;
}
function getMaxPulseFrequency_S150() {
  var ConverterRatedPower = parseFloat(ECL_GetValue("ECSI_CX_ConverterRatedPower"));
  var MLFB10_S150 = ECL_GetValue("MLFB10_S150");

  var sWhereConverterRating = "";

  if (MLFB10_S150 == "E") {
    if (ConverterRatedPower <= 250) {
      var ConverterRating = "110_250";
    } else {
      var ConverterRating = "315_800";
    }
    sWhereConverterRating = "ConverterRating = '" + ConverterRating + "' AND ";
  }

  var sTable = "PulseFrequency";

  var sSQL = "SELECT * FROM " + sTable + " WHERE " + sWhereConverterRating + "MLFB10_S150 = '" + MLFB10_S150 + "';";

  var aResult = Object.fromDatabase("S150_ADD_DATA", sSQL);

  if (aResult.length > 0) {
    var MaxPulseFrequency = ""; //aResult[0].PULSEFREQUENCY_DEFAULT;
    // if dv/dt-filter or motor-reactor selected
    var O_AUSGANG_S150 = ECL_GetValue("O_AUSGANG_S150");
    if (O_AUSGANG_S150 == "L07" || O_AUSGANG_S150 == "L08" || O_AUSGANG_S150 == "L10") {
      // dv/dt-filter
      MaxPulseFrequency = aResult[0].MAXPULSEFREQUENCY_DV_DT;
    }
    // if sine-wave-filter selected
    if (O_AUSGANG_S150 == "L15") {
      // sine-wave-filter
      MaxPulseFrequency = aResult[0].MAXPULSEFREQUENCY_SINE_WAVE;
    }
  } else {
    return "ERROR";
  }
  return MaxPulseFrequency;
}

function getMinPulseFrequency_S150() {
  var ConverterRatedPower = parseFloat(ECL_GetValue("ECSI_CX_ConverterRatedPower"));
  var MLFB10_S150 = ECL_GetValue("MLFB10_S150");

  var sWhereConverterRating = "";

  if (MLFB10_S150 == "E") {
    if (ConverterRatedPower <= 250) {
      var ConverterRating = "110_250";
    } else {
      var ConverterRating = "315_800";
    }
    sWhereConverterRating = "ConverterRating = '" + ConverterRating + "' AND ";
  }

  var sTable = "PulseFrequency";
  var sSQL = "SELECT * FROM " + sTable + " WHERE " + sWhereConverterRating + "MLFB10_S150 = '" + MLFB10_S150 + "';";

  var aResult = Object.fromDatabase("S150_ADD_DATA", sSQL);

  if (aResult.length > 0) {
    var MinPulseFrequency = ""; //aResult[0].PULSEFREQUENCY_DEFAULT;

    var O_AUSGANG_S150 = ECL_GetValue("O_AUSGANG_S150");
    // if sine-wave-filter selected
    if (O_AUSGANG_S150 == "L15") {
      // sine-wave-filter
      MinPulseFrequency = aResult[0].MINPULSEFREQUENCY_SINE_WAVE;
    }
  } else {
    return "ERROR";
  }
  return MinPulseFrequency;
}

// IsProtectedDevice - If L26 selected
function getIsProtectiveDevice_S150() {
  /** IsProtectiveDevice
   */

  if (ECL_ValueSelected("CB_O_HAUPTSCHALTER_S150", "T")) {
    return "true";
  }
  return "false";
}

function getSelected_PMs() {
  var mlfb = ECL_GetValue("ECSI_MLFB");
  var sSelected_PMs = "";
  /* Realisation by evosoft - todo
  if (mlfb.match(/6SL37101GE(321|326|331|338|350|361|375|384|410)(C|A)/)) {
    sSelected_PMs = "CIM_1";
  }
  else if (mlfb.match(/6SL37101GF(318|322|326|333|341|347|358|374|381)(C|A)/)) {
    sSelected_PMs = "CIM_1";
  }
  else if (mlfb.match(/6SL37101GH(285|310|312|315|318|322|326|333|341|347|358|374|381)(C|A)/)) {
    sSelected_PMs = "CIM_1";
  }
  else if (mlfb.match(/6SL37102GE(411|414|416)A/)) {
    sSelected_PMs = "CIM_1|CIM_2";
  }
  else if (mlfb.match(/6SL37102GF(386|411|414)A/)) {
    sSelected_PMs = "CIM_1|CIM_2";
  }
  else if (mlfb.match(/6SL37102GH(411|414|415)A/)) {
    sSelected_PMs = "CIM_1|CIM_2";
  }
  else if (mlfb.match(/6SL37102GH(418|420|422|424)E/)) {
    sSelected_PMs = "BLM_1|BLM_2|MoMo_1|Momo_2";
  }
  else if (mlfb.match(/6SL37102GH427E/)) {
    sSelected_PMs = "BLM_1|BLM_2|MoMo_1|Momo_2|MoMo_3";
  }
  */
  return sSelected_PMs;
}

function getVSM4Motor_S150() {
  var o_module = ECL_GetValue("O_MODULE_S150");

  if (o_module === "K51")
    return "VSM10";

  return "";
}

function getTM31_1_S150() {

  var tm31_1 = ECL_ValueSelected("CB_O_KUND_KL_LEISTE_S150", "T");
  var tm31_2 = ECL_ValueSelected("CB_O_ZUS_KUND_KL_LEISTE_S150", "T");

  if (tm31_1 || tm31_2)
    return "TM31_1";

  return "";
}

function getTM31_2_S150() {
  var tm31_2 = ECL_ValueSelected("CB_O_ZUS_KUND_KL_LEISTE_S150", "T");

  if (tm31_2)
    return "TM31_2";

  return "";
}

function getTM150_1_S150() {
  // O_TM150_S150	TM150 Temperatursensorauswerteeinheit
  /*
    NON	without
    G51	(G51) 1x Stück	
    G52	(G52) 2x Stück	
    G53	(G53) 3x Stück	
    G54	(G54) 4x Stück	
  */
  var O_TM150_S150 = ECL_GetValue("O_TM150_S150");
  switch (O_TM150_S150) {
    case "NON":
      return "";
    case "G51":
      return "TM150_1";
    case "G52":
      return "TM150_2";
    case "G53":
      return "TM150_3";
    case "G54":
      return "TM150_4";
    default:
      return "";
  }
}

function getTM54F_S150() {
  var tm54f = ECL_ValueSelected("CB_O_TM54F_S150", "T");

  if (tm54f)
    return "TM54F";

  return "";
}

function getSMC10_S150() {
  // if O_MODULE_S150	Module Cabinet-Mounted == K46 Zusätzliches Sensor Module Cabinet-Mounted SMC10

  var smc10 = ECL_ValueSelected("O_MODULE_S150", "K46");

  if (smc10)
    return "SMC10";

  return "";
}

function getSMC20_S150() {
  // if O_MODULE_S150	Module Cabinet-Mounted == K48 Zusätzliches Sensor Module Cabinet-Mounted SMC30

  var smc20 = ECL_ValueSelected("O_MODULE_S150", "K48");

  if (smc20)
    return "SMC20";

  return "";
}

function getSMC30_1_S150() {
  // if O_MODULE_S150	Module Cabinet-Mounted == K50 OR O_K52_S150	(K52) Zusätzliches Sensor Module Cabinet-Mounted SMC30

  var smc30_1 = ECL_ValueSelected("O_MODULE_S150", "K50");
  var smc30_2 = ECL_ValueSelected("CB_O_K52_S150", "T");

  if (smc30_1 || smc30_2)
    return "SMC30_1";

  return "";
}

function getSMC30_2_S150() {
  var smc30_2 = ECL_ValueSelected("CB_O_K52_S150", "T");

  if (smc30_2)
    return "SMC30_2";

  return "";
}