﻿//@legacy
//#mode(full-ecma)

// ---------------------------------------------------------
// Script for configuration object CFG_SIEMENS_S150
// 	Date: 2024-07-21
// 	User: Administrator
// ---------------------------------------------------------

//@import "CFG_S150_VT.js"

/**
  zu bestimmen: 
    Spannung, MLFB10, IN_FREQUENZ_S150
    ggf. Leistung
    IP Schutzklasse KAG bzw STD, 23STD bei Marine   O_SCHUTZART_S150

  MLFB01: 6SL3
  MLFB05: 7
  MLFB06: 1
  MLFB07: 0
  MLFB08: 7 
  MLFB09: L
  MLFB10: Spannungsbereich [E,G]
  MLFB11: Leistung 123 	HMK_MLFB10_13_S150 4 digits! (MLFB10...13)
  MLFB12: Leistung 2 
  MLFB13: Leistung 3 
  MLFB14: A
  MLFB15:	A 
  MLFB16:	3 
	
  HMK_MLFB10_13_S150 

*/

function SetInverter_Init_S150(oData) {
  if (oData && !isEmpty(oData)) {
    SetVoltage_S150(oData); //
    SetProtection_S150(oData); // O_SCHUTZART_S150

  } else {
    // FC-Data
    ExecSetStandardifValueEmpty("IN_SPANNUNG_S150", "400");
    ExecSetStandardifValueEmpty("IN_FREQUENZ_S150", "50");

    ExecSetStandardifValueEmpty("PMD_ABJ176_001_000_S150", "IP20");	// Schutzart IP
    ExecSetStandardifValueEmpty("O_SCHUTZART_S150", "NON"); //
  }
}

function SetInverter_S150(strchangedAttribute, oData) { }
// #########################################################################################################################
/**
MLFB10: Spannungsbereich [E,G]	==>	IN_SPANNUNG_S150, HMK_SPANNUNG_BEREICH_S150
*/
// #########################################################################################################################
function SetVoltage_S150(oData) {
  //var oParsingData = oData.oParsingData;
  var oMLFB = oData.oParsingData.MLFB;
  var MLFB10_S150 = oMLFB.POS10;

  var ECSI_CX_StandardSupplySystem = ECL_GetValue("ECSI_CX_StandardSupplySystem");
  var IN_SPANNUNG_S150 = "400";
  var IN_FREQUENZ_S150 = "50";

  switch (ECSI_CX_StandardSupplySystem) {
    case "0":
    case "1":
      IN_SPANNUNG_S150 = "230";
      IN_FREQUENZ_S150 = "50";
      break;
    case "2":
      IN_SPANNUNG_S150 = "380";
      IN_FREQUENZ_S150 = "50";
      break;
    case "3":
      IN_SPANNUNG_S150 = "400";
      IN_FREQUENZ_S150 = "50";
      break;
    case "4":
      IN_SPANNUNG_S150 = "415";
      IN_FREQUENZ_S150 = "50";
      break;
    case "5":
      IN_SPANNUNG_S150 = "500";
      IN_FREQUENZ_S150 = "50";
      break;
    case "6":
      IN_SPANNUNG_S150 = "690";
      IN_FREQUENZ_S150 = "50";
      break;
    case "7":
      IN_SPANNUNG_S150 = "240";
      IN_FREQUENZ_S150 = "60";
      break;
    case "8":
      IN_SPANNUNG_S150 = "240";
      IN_FREQUENZ_S150 = "60";
      break;
    case "9":
      IN_SPANNUNG_S150 = "380";
      IN_FREQUENZ_S150 = "60";
      break;
    case "10":
      IN_SPANNUNG_S150 = "400";
      IN_FREQUENZ_S150 = "60";
      break;
    case "11":
      IN_SPANNUNG_S150 = "440";
      IN_FREQUENZ_S150 = "60";
      break;
    case "12":
      IN_SPANNUNG_S150 = "460";
      IN_FREQUENZ_S150 = "60";
      break;
    case "13":
      IN_SPANNUNG_S150 = "480";
      IN_FREQUENZ_S150 = "60";
      break;
    case "14":
      IN_SPANNUNG_S150 = "600";
      IN_FREQUENZ_S150 = "60";
      break;
    case "15":
      IN_SPANNUNG_S150 = "690";
      IN_FREQUENZ_S150 = "60";
      break;
    case "18":
      IN_SPANNUNG_S150 = "480";
      IN_FREQUENZ_S150 = "50";
      break;
  }

  // VT_S150_M00028 Mapping Spannungsbereich	
  // 	MLFB10_S150 PMD_ABV753_001_000_S150 PMD_ABV754_001_000_S150
  // E von 380-480V, G von 500-690V
  if (MLFB10_S150 == "E" && (parseFloat(IN_SPANNUNG_S150) > 480 || parseFloat(IN_SPANNUNG_S150) < 380)) {
    //Error
    oData.strError = "DICT1_ERR_S150___PARSER_VOLTAGE";
    return;
  } else if (MLFB10_S150 == "G" && (parseFloat(IN_SPANNUNG_S150) > 690 || parseFloat(IN_SPANNUNG_S150) < 500)) {
    //Error
    oData.strError = "DICT1_ERR_S150___PARSER_VOLTAGE";
    return;
  }

  ECL_DeactivateAllAttributeValues("IN_SPANNUNG_S150");
  ECL_ActivateValue("IN_SPANNUNG_S150", IN_SPANNUNG_S150);
  ECL_SelectValue("IN_SPANNUNG_S150", IN_SPANNUNG_S150);

  ECL_DeactivateAllAttributeValues("IN_FREQUENZ_S150");
  ECL_ActivateValue("IN_FREQUENZ_S150", IN_FREQUENZ_S150);
  ECL_SelectValue("IN_FREQUENZ_S150", IN_FREQUENZ_S150);

}


// #########################################################################################################################
/**
IP Schutzklasse KAG bzw STD, STM bei Marine O_SCHUTZART_S150

BZ_S150_00120	Einschränken Schutzart_M66
$self.H_TRIGGER_IP_M66_S150 ?= 'F'
  if not O_SCHIFFSAUSFUEHRUNG_S150 specified or O_SCHIFFSAUSFUEHRUNG_S150 eq 'NON',
$self.H_TRIGGER_IP_M66_S150 ?= 'T'
  if O_SCHIFFSAUSFUEHRUNG_S150 specified and O_SCHIFFSAUSFUEHRUNG_S150 eq 'M66'


BZ_S150_00121	Einschränken Schutzart_M66
RESTRICTIONS:
  c.O_SCHUTZART_S150 in ('NON','M21','M23','M43','M54')
    if c.H_TRIGGER_IP_M66_S150 eq 'F' or  c.O_SCHIFFSAUSFUEHRUNG_S150 eq 'NON',
  c.O_SCHUTZART_S150 in ('23STD','M43','M54')
    if c.H_TRIGGER_IP_M66_S150 eq 'T'
INFERENCES:
  c.O_SCHUTZART_S150

BZ_S150_00002	set default
$self.O_SCHUTZART_S150 ?= '23STD'
if H_TRIGGER_IP_M66_S150 eq 'T',
*/
// #########################################################################################################################
function SetProtection_S150(oData) {
  // O_SCHUTZART_S150
  var sDTKAttribute = "O_SCHUTZART_S150";

  // KAGs  NON  M21 M23 M43 M54 23STD
  var aKAG = oData.oParsingData.MLFB.KAG || [];

  var sKAG = getKAGforAttribute(sDTKAttribute, aKAG);
  var bCheck = false;
  if (sKAG == "M21") {
    var stpp;
  }
  /**
   * Series IDs:
   * 	IP 20-43: 32150
   * 	Config context: FrequencyConverterDefaultIpProtectionLevel - 43
   * 	Behavior: Default IP Protection level is 20, max 43
   *
   * IP 54 : 32150
   * 	Config context: FrequencyConverterDefaultIpProtectionLevel - 54
   * 	Behavior: IP Protection level 54
   */
  var strSeriesID = ECL_GetValue("ECSI_CX_SeriesID");
  var strFrequencyConverterDefaultIpProtectionLevel = ECL_GetValue("ECSI_CX_FrequencyConverterDefaultIpProtectionLevel");
  if (/*strSeriesID == "31155" || */ strFrequencyConverterDefaultIpProtectionLevel == "54") {
    sKAG = "M54";
  }

  if (sKAG != "NON") {
    bCheck = Check_O_SCHUTZART_S150(oData, sDTKAttribute, sKAG);
  }

  if (bCheck) {
    ECL_ActivateValue(sDTKAttribute, sKAG);
    ECL_SelectValue(sDTKAttribute, sKAG);
  } else {
    if (strFrequencyConverterDefaultIpProtectionLevel == "54") {
      oData.strError = "DICT1_ERR_S150___PARSER_IP_PROTECTION_M54";
      return;
    }
    if (aKAG.indexOf("M66") >= 0) {
      ECL_ActivateValue(sDTKAttribute, "23STD");
      ECL_SelectValue(sDTKAttribute, "23STD");
    } else {
      ECL_ActivateValue(sDTKAttribute, "NON");
      ECL_SelectValue(sDTKAttribute, "NON");
    }
  }
}
function Check_O_SCHUTZART_S150(oData, sDTKAttribute, sKAG) {
  if (oData.IsStartConfig == "0") return 1;
  // -----------------------------------------------------------------------------------------
  /* Marineoption:
  c.O_SCHUTZART_S150 in ('NON','M21','M23','M43','M54')
    if c.H_TRIGGER_IP_M66_S150 eq 'F' or  c.O_SCHIFFSAUSFUEHRUNG_S150 eq 'NON',
  c.O_SCHUTZART_S150 in ('23STD','M43','M54')
    if c.H_TRIGGER_IP_M66_S150 eq 'T'
  */
  var aKAG = oData.oParsingData.MLFB.KAG || [];

  if (aKAG.indexOf("M66") >= 0) {
    //var H_TRIGGER_IP_M66_S150 = ECL_GetValue("H_TRIGGER_IP_M66_S150");
    //var O_SCHIFFSAUSFUEHRUNG_S150 = ECL_GetValue("O_SCHIFFSAUSFUEHRUNG_S150");
    if (sKAG == "M21" || sKAG == "M23") {
      return 0;
    }
  }
  /*
  VT_S150_M00004	Derating Faktor  Schutzart+AH+KMT
    O_SCHUTZART_S150	Schutzart
    IN_AUSTELLHOEHE_S150	Aufstellhöhe
    IN_UMGEB_TEMP_S150	Umgebungstemperatur
    H_DERATING_FAKTOR_S150	Derating Faktor
  
  VT_S150_M00024	Optionen M60+Schutzart
    HMK_MLFB10_13_S150	HMK MLFB10-13
    O_SCHUTZART_S150	Schutzart
    OHMK_BERUEHR_SCHUTZ_S150	(M60) /...hrungsschutz
    O_BERUEHR_SCHUTZ_S150	Zusätzlicher Berührungsschutz
  */
  var IN_AUSTELLHOEHE_S150 = ECL_GetValue("IN_AUSTELLHOEHE_S150");
  var IN_UMGEB_TEMP_S150 = ECL_GetValue("IN_UMGEB_TEMP_S150");

  var sTable = "VT_S150_M00004" + sDB_Suffix;
  var sSQL = "SELECT " + sDTKAttribute + " FROM " + sTable + " WHERE " +
    "IN_AUSTELLHOEHE_S150 = '" + IN_AUSTELLHOEHE_S150 + "' AND " +
    "IN_UMGEB_TEMP_S150 = '" + IN_UMGEB_TEMP_S150 + "' AND " +
    sDTKAttribute + " = '" + sKAG + "';";

  var aResult = GetDBDataSetEXT(sSQL);
  if (aResult.length < 1) {
    return 0;
  }
  // -----------------------------------------------------------------------------------------
  var HMK_MLFB10_13_S150 = ECL_GetValue("HMK_MLFB10_13_S150");

  var sTable = "VT_S150_M00024" + sDB_Suffix;
  var sSQL = "SELECT " + sDTKAttribute + " FROM " + sTable + " WHERE " +
    "HMK_MLFB10_13_S150 = '" + HMK_MLFB10_13_S150 + "' AND " +
    sDTKAttribute + " = '" + sKAG + "';";

  var aResult = GetDBDataSetEXT(sSQL);
  if (aResult.length < 1) {
    return 0;
  }
  // -----------------------------------------------------------------------------------------
  return 1;
}
// #############################################################################################
