//@legacy
//#mode(full-ecma)

//@import "CFG_S150_VT.js"

function SetOptions1_Init_S150(oData) {
  /*
  Eingansseitige Optionen
    O_UMGEBUNG_L00_S150	      CB_O_UMGEBUNG_L00_S150          (L00) Einsatz in der ersten Umgebung nach EN 61800-3, Kategorie C2
    O_UEBERSPGSBGZ_L21_S150	  CB_O_UEBERSPGSBGZ_L21_S150      (L21) Überspannungsbegrenzung
    O_HAUPTSCHALTER_S150	    CB_O_HAUPTSCHALTER_S150         (L26) Hauptschalter inkl. Sicherungen bzw. Leistungsschalter
  Ausgangsseitige Optionen
    O_AUSGANG_S150	          Ausgangsseitige Optionen        (NON, L07, L10, L08, L15)
    O_EMV_SCHIRMSCHIENE_S150	CB_O_EMV_SCHIRMSCHIENE_S150     (M70) EMV-Schirmschiene (Kabelanschluss von unten)
  Motorschutz und Sicherheitsfunktionen 
    O_TM150_S150            	TM150 Temperatursensorauswerteeinheit (NON, G51, G52, G53, G54)
    O_NOT_AUS_HALT_S150	      Not-Aus / Not-Halt              (NON, L57, L59, L60)
    O_NOT_AUS_TASTER_S150	    CB_O_NOT_AUS_TASTER_S150        (L45) NOT-AUS-Taster, eingebaut in der Schranktür
    O_FILTERUEBERWAC_L40_S150	CB_O_FILTERUEBERWAC_L40_S150    (L40) Filterüberwachung
    O_THERMISTOR_S150	        CB_O_THERMISTOR_S150            (L83) Thermistor-Motorschutzgerät (Warnung)
    O_THERMISTOR_L84_S150	    CB_O_THERMISTOR_L84_S150        (L84) Thermistor-Motorschutzgerät (Abschaltung)
    O_PT100_S150	            CB_O_PT100_S150                 (L86) PT100-Auswertegerät
    O_ISOLAT_UEBERWACH_S150	  CB_O_ISOLAT_UEBERWACH_S150      (L87) Isolationsüberwachung
    OHMK_BERUEHR_SCHUTZ_S150	CB_OHMK_BERUEHR_SCHUTZ_S150     Zusätzlicher Berührungsschutz KAG, NON ==> M60
      O_BERUEHR_SCHUTZ_S150	    (M60) Zusätzlicher Berührungsschutz
  Mechanische Optionen
    O_SOCKEL_100MM_S150	      CB_O_SOCKEL_100MM_S150          (M06) Sockel 100 mm hoch, RAL 7022
    O_KABELRANGIERRAUM_S150	  CB_O_KABELRANGIERRAUM_S150      (M07) Kabelrangierraum 200 mm hoch, RAL 7035
    O_NETZANSCHLUSS_S150	    CB_O_NETZANSCHLUSS_S150         (M13) Netzanschluss von oben
    O_MOTORANSCHLUSS_S150	    CB_O_MOTORANSCHLUSS_S150        (M78) Motoranschluss von oben
    O_KRANTRANSPORTHILFE_S150	CB_O_KRANTRANSPORTHILFE_S150    (M90) Krantransporthilfe für Schränke (oben montiert)
    */

  if (oData && !isEmpty(oData)) {
    Bestimme_L00_S150(oData); //
    Bestimme_L21_S150(oData); //
    Bestimme_L26_S150(oData); //

    Bestimme_O_AUSGANG_S150(oData); //
    Bestimme_M70_S150(oData); //

    Bestimme_O_TM150_S150(oData); //

    Bestimme_O_NOT_AUS_HALT_S150(oData); //
    Bestimme_L45_S150(oData); //
    Bestimme_L40_S150(oData); //
    Bestimme_L83_S150(oData); //
    Bestimme_L84_S150(oData); //
    Bestimme_L86_S150(oData); //
    Bestimme_L87_S150(oData); //
    Bestimme_M60_S150(oData); //

    Bestimme_M06_S150(oData); //
    Bestimme_M07_S150(oData); //
    Bestimme_M13_S150(oData); //
    Bestimme_M61_S150(oData); //
    Bestimme_M62_S150(oData); //
    Bestimme_M63_S150(oData); //
    Bestimme_M78_S150(oData); //
    Bestimme_M90_S150(oData); //
  } else {
    ExecSetStandardifValueEmpty("O_AUSGANG_S150", "NON");
    ExecSetStandardifValueEmpty("O_TM150_S150", "NON");
    ExecSetStandardifValueEmpty("O_NOT_AUS_HALT_S150", "NON");
  }
}

// #############################################################################################
// O_UMGEBUNG_L00_S150	      CB_O_UMGEBUNG_L00_S150          (L00) Einsatz in der ersten Umgebung nach EN 61800-3, Kategorie C2
function Bestimme_L00_S150(oData) {
  // O_UMGEBUNG_L00_S150
  var sDTKAttribute = "O_UMGEBUNG_L00_S150";
  var sCB_Attribute = "CB_" + sDTKAttribute;

  var sKAG = "L00";

  var bCheck = false;
  var aKAG = oData.oParsingData.MLFB.KAG || [];

  if (aKAG.indexOf(sKAG) >= 0) {
    bCheck = Check_L00_S150(oData, sDTKAttribute, sKAG);
  }
  if (bCheck) {
    ECL_EnableAttribute(sCB_Attribute);
    ECL_SelectValue(sCB_Attribute, "T");
  } else {
    ECL_DeselectAttribute(sCB_Attribute);
  }
}

function Check_L00_S150(oData, sDTKAttribute, sKAG) {
  if (oData.IsStartConfig == "0") return 1;
  // -----------------------------------------------------------------------------------------
  /* keine */
  // -----------------------------------------------------------------------------------------
  return 1;
}

// #############################################################################################
// O_UEBERSPGSBGZ_L21_S150	  CB_O_UEBERSPGSBGZ_L21_S150      (L21) Überspannungsbegrenzung
function Bestimme_L21_S150(oData) {
  // O_UEBERSPGSBGZ_L21_S150
  var sDTKAttribute = "O_UEBERSPGSBGZ_L21_S150";
  var sCB_Attribute = "CB_" + sDTKAttribute;

  var sKAG = "L21";

  var bCheck = false;
  var aKAG = oData.oParsingData.MLFB.KAG || [];

  if (aKAG.indexOf(sKAG) >= 0) {
    bCheck = Check_L21_S150(oData, sDTKAttribute, sKAG);
  }
  if (bCheck) {
    ECL_EnableAttribute(sCB_Attribute);
    ECL_SelectValue(sCB_Attribute, "T");
  } else {
    ECL_DeselectAttribute(sCB_Attribute);
  }
}
function Check_L21_S150(oData, sDTKAttribute, sKAG) {
  if (oData.IsStartConfig == "0") return 1;
  // -----------------------------------------------------------------------------------------
  /* keine */
  // -----------------------------------------------------------------------------------------
  return 1;
}

// #############################################################################################
// O_HAUPTSCHALTER_S150	    CB_O_HAUPTSCHALTER_S150         (L26) Hauptschalter inkl. Sicherungen bzw. Leistungsschalter
function Bestimme_L26_S150(oData) {
  // O_HAUPTSCHALTER_S150
  var sDTKAttribute = "O_HAUPTSCHALTER_S150";
  var sCB_Attribute = "CB_" + sDTKAttribute;

  var sKAG = "L26";

  var bCheck = false;
  var aKAG = oData.oParsingData.MLFB.KAG || [];

  if (aKAG.indexOf(sKAG) >= 0) {
    bCheck = Check_L26_S150(oData, sDTKAttribute, sKAG);
  }
  if (bCheck) {
    ECL_EnableAttribute(sCB_Attribute);
    ECL_SelectValue(sCB_Attribute, "T");
  } else {
    ECL_DeselectAttribute(sCB_Attribute);
  }
}
function Check_L26_S150(oData, sDTKAttribute, sKAG) {
  if (oData.IsStartConfig == "0") return 1;
  // -----------------------------------------------------------------------------------------
  /** VT_S150_M00037	Option_L26
   *     MLFB11_S150	  MLFB12_S150   O_HAUPTSCHALTER_S150	
   */
  var MLFB11_S150 = oData.oParsingData.MLFB.POS11;
  var MLFB12_S150 = oData.oParsingData.MLFB.POS12;

  var sTable = "VT_S150_M00037" + sDB_Suffix;
  var sSQL = "SELECT " + sDTKAttribute + " FROM " + sTable + " WHERE " +
    "MLFB11_S150 = '" + MLFB11_S150 + "' AND " +
    "MLFB11_S150 = '" + MLFB11_S150 + "' AND " +
    sDTKAttribute + " = '" + sKAG + "';";

  var aResult = GetDBDataSetEXT(sSQL);
  if (aResult.length < 1) {
    return 0;
  }
  // -----------------------------------------------------------------------------------------
  return 1;
}

// Ausgangsseitige Optionen

// #############################################################################################
// O_AUSGANG_S150	          Ausgangsseitige Optionen        (NON, L07, L10, L08, L15)
function Bestimme_O_AUSGANG_S150(oData) {
  // O_AUSGANG_S150
  var sDTKAttribute = "O_AUSGANG_S150";

  // KAGs  NON, L07, L10, L08, L15
  var aKAG = oData.oParsingData.MLFB.KAG || [];

  var sKAG = getKAGforAttribute(sDTKAttribute, aKAG);
  var bCheck = false;
  if (sKAG != "NON") {
    bCheck = Check_O_AUSGANG_S150(oData, sDTKAttribute, sKAG);
  }
  if (bCheck) {
    ECL_ActivateValue(sDTKAttribute, sKAG);
    ECL_SelectValue(sDTKAttribute, sKAG);
  } else {
    ECL_ActivateValue(sDTKAttribute, "NON");
    ECL_SelectValue(sDTKAttribute, "NON");
  }
}
function Check_O_AUSGANG_S150(oData, sDTKAttribute, sKAG) {
  if (oData.IsStartConfig == "0") return 1;
  // -----------------------------------------------------------------------------------------
  /* VT_S150_M00033	Optionen L07+L08+L10+L15+M78  
   *   O_AUSGANG_S150	  O_MOTORANSCHLUSS_S150   <== untergeordnet
   */
  // -----------------------------------------------------------------------------------------
  return 1;
}
// #############################################################################################
// O_EMV_SCHIRMSCHIENE_S150	CB_O_EMV_SCHIRMSCHIENE_S150     (M70) EMV-Schirmschiene (Kabelanschluss von unten)
function Bestimme_M70_S150(oData) {
  // O_EMV_SCHIRMSCHIENE_S150
  var sDTKAttribute = "O_EMV_SCHIRMSCHIENE_S150";
  var sCB_Attribute = "CB_" + sDTKAttribute;

  var sKAG = "M70";

  var bCheck = false;
  var aKAG = oData.oParsingData.MLFB.KAG || [];

  if (aKAG.indexOf(sKAG) >= 0) {
    bCheck = Check_M70_S150(oData, sDTKAttribute, sKAG);
  }
  if (bCheck) {
    ECL_EnableAttribute(sCB_Attribute);
    ECL_SelectValue(sCB_Attribute, "T");
  } else {
    ECL_DeselectAttribute(sCB_Attribute);
  }
}
function Check_M70_S150(oData, sDTKAttribute, sKAG) {
  if (oData.IsStartConfig == "0") return 1;
  // -----------------------------------------------------------------------------------------
  /* keine */
  // -----------------------------------------------------------------------------------------
  return 1;
}

// Motorschutz und Sicherheitsfunktionen 

// #############################################################################################
// O_TM150_S150            	TM150 Temperatursensorauswerteeinheit (NON, G51, G52, G53, G54)
function Bestimme_O_TM150_S150(oData) {
  // O_TM150_S150
  var sDTKAttribute = "O_TM150_S150";
  // KAGs  NON, G51, G52, G53, G54
  var aKAG = oData.oParsingData.MLFB.KAG || [];

  var sKAG = getKAGforAttribute(sDTKAttribute, aKAG);
  var bCheck = false;
  if (sKAG != "NON") {
    bCheck = Check_O_TM150_S150(oData, sDTKAttribute, sKAG);
  }
  if (bCheck) {
    ECL_ActivateValue(sDTKAttribute, sKAG);
    ECL_SelectValue(sDTKAttribute, sKAG);
  } else {
    ECL_ActivateValue(sDTKAttribute, "NON");
    ECL_SelectValue(sDTKAttribute, "NON");
  }
}
function Check_O_TM150_S150(oData, sDTKAttribute, sKAG) {
  if (oData.IsStartConfig == "0") return 1;
  // -----------------------------------------------------------------------------------------
  /*
  VT_S150_M00027	gültige Optionen L86/G51
   *  O_PT100_S150	Pt100-Auswertegerät (L86)
   *  O_TM150_S150	TM150 Temperatursensorauswerteeinheit
   */
  var sTable = "VT_S150_M00027" + sDB_Suffix;
  var sSQL = "SELECT " + sDTKAttribute + " FROM " + sTable + " WHERE " +
    sDTKAttribute + " = '" + sKAG + "';";

  var aResult = GetDBDataSetEXT(sSQL);
  if (aResult.length < 1) {
    return 0;
  }
  // -----------------------------------------------------------------------------------------
  return 1;
}

// #############################################################################################
// O_NOT_AUS_HALT_S150	      Not-Aus / Not-Halt              (NON, L57, L59, L60)
function Bestimme_O_NOT_AUS_HALT_S150(oData) {
  // O_NOT_AUS_HALT_S150
  var sDTKAttribute = "O_NOT_AUS_HALT_S150";
  // KAGs  NON, L57, L59, L60
  var aKAG = oData.oParsingData.MLFB.KAG || [];

  var sKAG = getKAGforAttribute(sDTKAttribute, aKAG);
  var bCheck = false;
  if (sKAG != "NON") {
    bCheck = Check_O_NOT_AUS_HALT_S150(oData, sDTKAttribute, sKAG);
  }
  if (bCheck) {
    ECL_ActivateValue(sDTKAttribute, sKAG);
    ECL_SelectValue(sDTKAttribute, sKAG);
  } else {
    ECL_ActivateValue(sDTKAttribute, "NON");
    ECL_SelectValue(sDTKAttribute, "NON");
  }
}
function Check_O_NOT_AUS_HALT_S150(oData, sDTKAttribute, sKAG) {
  if (oData.IsStartConfig == "0") return 1;
  // -----------------------------------------------------------------------------------------
  /* keine */
  // -----------------------------------------------------------------------------------------
  return 1;
}

// #############################################################################################
// O_NOT_AUS_TASTER_S150	    CB_O_NOT_AUS_TASTER_S150(L45) NOT - AUS - Taster, eingebaut in der Schranktür
function Bestimme_L45_S150(oData) {
  // O_NOT_AUS_TASTER_S150
  var sDTKAttribute = "O_NOT_AUS_TASTER_S150";
  var sCB_Attribute = "CB_" + sDTKAttribute;

  var sKAG = "L45";

  var bCheck = false;
  var aKAG = oData.oParsingData.MLFB.KAG || [];

  if (aKAG.indexOf(sKAG) >= 0) {
    bCheck = Check_L45_S150(oData, sDTKAttribute, sKAG);
  }
  if (bCheck) {
    ECL_EnableAttribute(sCB_Attribute);
    ECL_SelectValue(sCB_Attribute, "T");
  } else {
    ECL_DeselectAttribute(sCB_Attribute);
  }
}
function Check_L45_S150(oData, sDTKAttribute, sKAG) {
  if (oData.IsStartConfig == "0") return 1;
  // -----------------------------------------------------------------------------------------
  /* keine */
  // -----------------------------------------------------------------------------------------
  return 1;
}

// #############################################################################################
// O_FILTERUEBERWAC_L40_S150	CB_O_FILTERUEBERWAC_L40_S150(L40) Filterüberwachung
function Bestimme_L40_S150(oData) {
  // O_FILTERUEBERWAC_L40_S150
  var sDTKAttribute = "O_FILTERUEBERWAC_L40_S150";
  var sCB_Attribute = "CB_" + sDTKAttribute;

  var sKAG = "L40";

  var bCheck = false;
  var aKAG = oData.oParsingData.MLFB.KAG || [];

  if (aKAG.indexOf(sKAG) >= 0) {
    bCheck = Check_L40_S150(oData, sDTKAttribute, sKAG);
  }
  if (bCheck) {
    ECL_EnableAttribute(sCB_Attribute);
    ECL_SelectValue(sCB_Attribute, "T");
  } else {
    ECL_DeselectAttribute(sCB_Attribute);
  }
}
function Check_L40_S150(oData, sDTKAttribute, sKAG) {
  if (oData.IsStartConfig == "0") return 1;
  // -----------------------------------------------------------------------------------------
  /* keine */
  // -----------------------------------------------------------------------------------------
  return 1;
}

// #############################################################################################
// O_THERMISTOR_S150	        CB_O_THERMISTOR_S150(L83) Thermistor - Motorschutzgerät(Warnung)
function Bestimme_L83_S150(oData) {
  // O_THERMISTOR_S150
  var sDTKAttribute = "O_THERMISTOR_S150";
  var sCB_Attribute = "CB_" + sDTKAttribute;

  var sKAG = "L83";

  var bCheck = false;
  var aKAG = oData.oParsingData.MLFB.KAG || [];

  if (aKAG.indexOf(sKAG) >= 0) {
    bCheck = Check_L83_S150(oData, sDTKAttribute, sKAG);
  }
  if (bCheck) {
    ECL_EnableAttribute(sCB_Attribute);
    ECL_SelectValue(sCB_Attribute, "T");
  } else {
    ECL_DeselectAttribute(sCB_Attribute);
  }
}
function Check_L83_S150(oData, sDTKAttribute, sKAG) {
  if (oData.IsStartConfig == "0") return 1;
  // -----------------------------------------------------------------------------------------
  /* keine */
  // -----------------------------------------------------------------------------------------
  return 1;
}

// #############################################################################################
// O_THERMISTOR_L84_S150	    CB_O_THERMISTOR_L84_S150(L84) Thermistor - Motorschutzgerät(Abschaltung)
function Bestimme_L84_S150(oData) {
  // O_THERMISTOR_L84_S150
  var sDTKAttribute = "O_THERMISTOR_L84_S150";
  var sCB_Attribute = "CB_" + sDTKAttribute;

  var sKAG = "L84";

  var bCheck = false;
  var aKAG = oData.oParsingData.MLFB.KAG || [];

  if (aKAG.indexOf(sKAG) >= 0) {
    bCheck = Check_L84_S150(oData, sDTKAttribute, sKAG);
  }
  if (bCheck) {
    ECL_EnableAttribute(sCB_Attribute);
    ECL_SelectValue(sCB_Attribute, "T");
  } else {
    ECL_DeselectAttribute(sCB_Attribute);
  }
}
function Check_L84_S150(oData, sDTKAttribute, sKAG) {
  if (oData.IsStartConfig == "0") return 1;
  // -----------------------------------------------------------------------------------------
  /* keine */
  // -----------------------------------------------------------------------------------------
  return 1;
}

// #############################################################################################
// O_PT100_S150	            CB_O_PT100_S150 (L86) PT100 - Auswertegerät
function Bestimme_L86_S150(oData) {
  // O_PT100_S150
  var sDTKAttribute = "O_PT100_S150";
  var sCB_Attribute = "CB_" + sDTKAttribute;

  var sKAG = "L86";

  var bCheck = false;
  var aKAG = oData.oParsingData.MLFB.KAG || [];

  if (aKAG.indexOf(sKAG) >= 0) {
    bCheck = Check_L86_S150(oData, sDTKAttribute, sKAG);
  }
  if (bCheck) {
    ECL_EnableAttribute(sCB_Attribute);
    ECL_SelectValue(sCB_Attribute, "T");
  } else {
    ECL_DeselectAttribute(sCB_Attribute);
  }
}
function Check_L86_S150(oData, sDTKAttribute, sKAG) {
  if (oData.IsStartConfig == "0") return 1;
  // -----------------------------------------------------------------------------------------
  /*VT_S150_M00027	gültige Optionen L86/G51
   *  O_PT100_S150	Pt100-Auswertegerät
   *  O_TM150_S150	TM150 Temperatursensorauswerteeinheit
   */
  var O_TM150_S150 = ECL_GetValue("O_TM150_S150");

  var sTable = "VT_S150_M00027" + sDB_Suffix;
  var sSQL = "SELECT " + sDTKAttribute + " FROM " + sTable + " WHERE " +
    "O_TM150_S150 = '" + O_TM150_S150 + "' AND " +
    sDTKAttribute + " = '" + sKAG + "';";

  var aResult = GetDBDataSetEXT(sSQL);
  if (aResult.length < 1) {
    return 0;
  }
  // -----------------------------------------------------------------------------------------
  return 1;
}

// #############################################################################################
// O_ISOLAT_UEBERWACH_S150	  CB_O_ISOLAT_UEBERWACH_S150 (L87) Isolationsüberwachung
function Bestimme_L87_S150(oData) {
  // O_ISOLAT_UEBERWACH_S150
  var sDTKAttribute = "O_ISOLAT_UEBERWACH_S150";
  var sCB_Attribute = "CB_" + sDTKAttribute;

  var sKAG = "L87";

  var bCheck = false;
  var aKAG = oData.oParsingData.MLFB.KAG || [];

  if (aKAG.indexOf(sKAG) >= 0) {
    bCheck = Check_L87_S150(oData, sDTKAttribute, sKAG);
  }
  if (bCheck) {
    ECL_EnableAttribute(sCB_Attribute);
    ECL_SelectValue(sCB_Attribute, "T");
  } else {
    ECL_DeselectAttribute(sCB_Attribute);
  }
}
function Check_L87_S150(oData, sDTKAttribute, sKAG) {
  if (oData.IsStartConfig == "0") return 1;
  // -----------------------------------------------------------------------------------------
  /* keine */
  // -----------------------------------------------------------------------------------------
  return 1;
}

// #############################################################################################
// OHMK_BERUEHR_SCHUTZ_S150	CB_OHMK_BERUEHR_SCHUTZ_S150     Zusätzlicher Berührungsschutz KAG, NON ==> M60
//  O_BERUEHR_SCHUTZ_S150(M60) Zusätzlicher Berührungsschutz
function Bestimme_M60_S150(oData) {
  // O_BERUEHR_SCHUTZ_S150
  var sDTKAttribute = "O_BERUEHR_SCHUTZ_S150";
  var sCB_Attribute = "CB_O_BERUEHR_SCHUTZ_S150";
  /* O_BERUEHR_SCHUTZ_S150: 
   * KAG: NON, M60
  */
  //var sCB_Attribute = "CB_OHMK_BERUEHR_SCHUTZ_S150";

  var sKAG = "M60";

  var bCheck = false;
  var aKAG = oData.oParsingData.MLFB.KAG || [];

  if (aKAG.indexOf(sKAG) >= 0) {
    bCheck = Check_M60_S150(oData, sDTKAttribute, sKAG);
  }
  if (bCheck) {
    ECL_EnableAttribute(sCB_Attribute);
    ECL_SelectValue(sCB_Attribute, "T");
  } else {
    ECL_DeselectAttribute(sCB_Attribute);
  }

}
function Check_M60_S150(oData, sDTKAttribute, sKAG) {
  if (oData.IsStartConfig == "0") return 1;
  // -----------------------------------------------------------------------------------------
  /* O_BERUEHR_SCHUTZ_S150: (Combo, invisible)
   * KAG: NON, M60
   * VT:
   * VT_S150_M00012	Optionen M60+M66+M78
   *  O_BERUEHR_SCHUTZ_S150 O_SCHIFFSAUSFUEHRUNG_S150 O_MOTORANSCHLUSS_S150
   * VT_S150_M00024	Optionen M60+Schutzart
   * VT_S150_M00025	Optionen M13+M60
   */
  var HMK_MLFB10_13_S150 = ECL_GetValue("HMK_MLFB10_13_S150");
  var O_SCHUTZART_S150 = ECL_GetValue("O_SCHUTZART_S150");

  var sSQL = "SELECT * FROM VT_S150_M00024" + sDB_Suffix + " WHERE " +
    "HMK_MLFB10_13_S150 = '" + HMK_MLFB10_13_S150 + "' AND O_SCHUTZART_S150 = '" + O_SCHUTZART_S150 + "' AND " +
    "O_BERUEHR_SCHUTZ_S150 = 'M60';";
  var aResult = GetDBDataSetEXT(sSQL);
  if (aResult.length < 1) {
    return 0;
  }
  // todo todo todo todo todo todo todo todo todo todo todo todo todo todo todo todo todo
  // todo todo todo todo todo todo todo todo todo todo todo todo todo todo todo todo todo
  // todo todo todo todo todo todo todo todo todo todo todo todo todo todo todo todo todo
  // todo todo todo todo todo todo todo todo todo todo todo todo todo todo todo todo todo

  // -----------------------------------------------------------------------------------------
  return 1;
}


// Mechanische Optionen

// ################################################################################################
// O_SOCKEL_100MM_S150	      CB_O_SOCKEL_100MM_S150          (M06) Sockel 100 mm hoch, RAL 7022
function Bestimme_M06_S150(oData) {
  // O_SOCKEL_100MM_S150
  var sDTKAttribute = "O_SOCKEL_100MM_S150";
  var sCB_Attribute = "CB_" + sDTKAttribute;

  var sKAG = "M06";

  var bCheck = false;
  var aKAG = oData.oParsingData.MLFB.KAG || [];

  if (aKAG.indexOf(sKAG) >= 0) {
    bCheck = Check_M06_S150(oData, sDTKAttribute, sKAG);
  }
  if (bCheck) {
    ECL_EnableAttribute(sCB_Attribute);
    ECL_SelectValue(sCB_Attribute, "T");
  } else {
    ECL_DeselectAttribute(sCB_Attribute);
  }
}
function Check_M06_S150(oData, sDTKAttribute, sKAG) {
  if (oData.IsStartConfig == "0") return 1;
  // -----------------------------------------------------------------------------------------
  /* VT_S150_M00009	Optionen M06+M07
   *  O_SOCKEL_100MM_S150   O_KABELRANGIERRAUM_S150
   */
  // -----------------------------------------------------------------------------------------
  return 1;
}

// ################################################################################################
// O_KABELRANGIERRAUM_S150	  CB_O_KABELRANGIERRAUM_S150      (M07) Kabelrangierraum 200 mm hoch, RAL 7035
function Bestimme_M07_S150(oData) {
  // O_KABELRANGIERRAUM_S150
  var sDTKAttribute = "O_KABELRANGIERRAUM_S150";
  var sCB_Attribute = "CB_" + sDTKAttribute;

  var sKAG = "M07";

  var bCheck = false;
  var aKAG = oData.oParsingData.MLFB.KAG || [];

  if (aKAG.indexOf(sKAG) >= 0) {
    bCheck = Check_M07_S150(oData, sDTKAttribute, sKAG);
  }
  if (bCheck) {
    ECL_EnableAttribute(sCB_Attribute);
    ECL_SelectValue(sCB_Attribute, "T");
  } else {
    ECL_DeselectAttribute(sCB_Attribute);
  }
}
function Check_M07_S150(oData, sDTKAttribute, sKAG) {
  if (oData.IsStartConfig == "0") return 1;
  // -----------------------------------------------------------------------------------------
  /* VT_S150_M00009	Optionen M06+M07
   *  O_SOCKEL_100MM_S150   O_KABELRANGIERRAUM_S150
   */
  var O_SOCKEL_100MM_S150 = "NON";
  if (ECL_GetValue("O_SOCKEL_100MM_S150") == "T") {
    O_SOCKEL_100MM_S150 = "M06";
  }

  var sTable = "VT_S150_M00009" + sDB_Suffix;
  var sSQL = "SELECT " + sDTKAttribute + " FROM " + sTable + " WHERE " +
    "O_SOCKEL_100MM_S150 = '" + O_SOCKEL_100MM_S150 + "' AND " +
    sDTKAttribute + " = '" + sKAG + "';";

  var aResult = GetDBDataSetEXT(sSQL);
  if (aResult.length < 1) {
    return 0;
  }
  // -----------------------------------------------------------------------------------------
  return 1;
}

//todo

// #############################################################################################
// O_NETZANSCHLUSS_S150	    CB_O_NETZANSCHLUSS_S150         (M13) Netzanschluss von oben
function Bestimme_M13_S150(oData) {
  // O_NETZANSCHLUSS_S150
  var sDTKAttribute = "O_NETZANSCHLUSS_S150";
  var sCB_Attribute = "CB_" + sDTKAttribute;

  var sKAG = "M13";

  var bCheck = false;
  var aKAG = oData.oParsingData.MLFB.KAG || [];

  if (aKAG.indexOf(sKAG) >= 0) {
    bCheck = Check_M13_S150(oData, sDTKAttribute, sKAG);
  }
  if (bCheck) {
    ECL_EnableAttribute(sCB_Attribute);
    ECL_SelectValue(sCB_Attribute, "T");
  } else {
    ECL_DeselectAttribute(sCB_Attribute);
  }
}
function Check_M13_S150(oData, sDTKAttribute, sKAG) {
  if (oData.IsStartConfig == "0") return 1;
  // --------------------------------------------------------------------------------------------
  /* VT_S150_M00013	Optionen M13+Schutzart
   *  O_NETZANSCHLUSS_S150 O_SCHUTZART_S150
   * VT_S150_M00025	Optionen M13+M60
   *  O_NETZANSCHLUSS_S150 OHMK_BERUEHR_SCHUTZ_S150  O_BERUEHR_SCHUTZ_S150
  */
  var O_SCHUTZART_S150 = ECL_GetValue("O_SCHUTZART_S150");

  var sTable = "VT_S150_M00013" + sDB_Suffix;
  var sSQL = "SELECT " + sDTKAttribute + " FROM " + sTable + " WHERE " +
    "O_SCHUTZART_S150 = '" + O_SCHUTZART_S150 + "' AND " +
    sDTKAttribute + " = '" + sKAG + "';";

  var aResult = GetDBDataSetEXT(sSQL);
  if (aResult.length < 1) {
    return 0;
  }
  // --------------------------------------------------------------------------------------------
  // B VT_S150_M00025	Optionen M13+M60
  //    O_NETZANSCHLUSS_S150 OHMK_BERUEHR_SCHUTZ_S150  O_BERUEHR_SCHUTZ_S150
  var O_BERUEHR_SCHUTZ_S150 = "NON";
  if (ECL_ValueSelected("CB_O_BERUEHR_SCHUTZ_S150", "T")) {
    O_BERUEHR_SCHUTZ_S150 = "M60";
  }

  var sTable = "VT_S150_M00025" + sDB_Suffix;
  var sSQL = "SELECT " + sDTKAttribute + " FROM " + sTable + " WHERE " +
    "O_BERUEHR_SCHUTZ_S150 = '" + O_BERUEHR_SCHUTZ_S150 + "' AND " +
    //"OHMK_BERUEHR_SCHUTZ_S150 = '" + OHMK_BERUEHR_SCHUTZ_S150 + "' AND " +    // don't use here
    sDTKAttribute + " = '" + sKAG + "';";

  var aResult = GetDBDataSetEXT(sSQL);
  if (aResult.length < 1) {
    return 0;
  }
  // --------------------------------------------------------------------------------------------
  return 1;
}

// #############################################################################################
// O_KOMFORTGRIFF_M61_S150	(M61) Komfortgriff mit Verschlusseinsatz 3 mm Doppelbart  CB_O_KOMFORTGRIFF_M61_S150
function Bestimme_M61_S150(oData) {
  // O_KOMFORTGRIFF_M61_S150
  var sDTKAttribute = "O_KOMFORTGRIFF_M61_S150";
  var sCB_Attribute = "CB_" + sDTKAttribute;

  var sKAG = "M61";

  var bCheck = false;
  var aKAG = oData.oParsingData.MLFB.KAG || [];

  if (aKAG.indexOf(sKAG) >= 0) {
    bCheck = Check_M61_S150(oData, sDTKAttribute, sKAG);
  }
  if (bCheck) {
    ECL_EnableAttribute(sCB_Attribute);
    ECL_SelectValue(sCB_Attribute, "T");
  } else {
    ECL_DeselectAttribute(sCB_Attribute);
  }
}
function Check_M61_S150(oData, sDTKAttribute, sKAG) {
  if (oData.IsStartConfig == "0") return 1;
  // -----------------------------------------------------------------------------------------
  // VT_S150_M00045 (only one Option M61, M62, M63)
  return 1;
}

// #############################################################################################
// O_KOMFORTGRIFF_M62_S150	(M62) Komfortgriff mit Verschlusseinsatz Druckknopf  CB_O_KOMFORTGRIFF_M62_S150 
function Bestimme_M62_S150(oData) {
  // O_KOMFORTGRIFF_M62_S150
  var sDTKAttribute = "O_KOMFORTGRIFF_M62_S150";
  var sCB_Attribute = "CB_" + sDTKAttribute;

  var sKAG = "M62";

  var bCheck = false;
  var aKAG = oData.oParsingData.MLFB.KAG || [];

  if (aKAG.indexOf(sKAG) >= 0) {
    bCheck = Check_M62_S150(oData, sDTKAttribute, sKAG);
  }
  if (bCheck) {
    ECL_EnableAttribute(sCB_Attribute);
    ECL_SelectValue(sCB_Attribute, "T");
  } else {
    ECL_DeselectAttribute(sCB_Attribute);
  }
}
function Check_M62_S150(oData, sDTKAttribute, sKAG) {
  if (oData.IsStartConfig == "0") return 1;
  // -----------------------------------------------------------------------------------------
  // VT_S150_M00045 (only one Option M61, M62, M63)
  if (ECL_ValueSelected("CB_O_KOMFORTGRIFF_M61_S150", "T")) {
    return 0;
  }
  return 1;
}

// #############################################################################################
// O_KOMFORTGRIFF_M63_S150	(M63) Komfortgriff für ein Vorhängeschloss mit Druckknopf als Verschlusseinsatz  CB_O_KOMFORTGRIFF_M63_S150
function Bestimme_M63_S150(oData) {
  // O_KOMFORTGRIFF_M63_S150
  var sDTKAttribute = "O_KOMFORTGRIFF_M63_S150";
  var sCB_Attribute = "CB_" + sDTKAttribute;

  var sKAG = "M63";

  var bCheck = false;
  var aKAG = oData.oParsingData.MLFB.KAG || [];

  if (aKAG.indexOf(sKAG) >= 0) {
    bCheck = Check_M63_S150(oData, sDTKAttribute, sKAG);
  }
  if (bCheck) {
    ECL_EnableAttribute(sCB_Attribute);
    ECL_SelectValue(sCB_Attribute, "T");
  } else {
    ECL_DeselectAttribute(sCB_Attribute);
  }
}
function Check_M63_S150(oData, sDTKAttribute, sKAG) {
  if (oData.IsStartConfig == "0") return 1;
  // -----------------------------------------------------------------------------------------
  // VT_S150_M00045 (only one Option M61, M62, M63)
  if (ECL_ValueSelected("CB_O_KOMFORTGRIFF_M61_S150", "T")) {
    return 0;
  }
  if (ECL_ValueSelected("CB_O_KOMFORTGRIFF_M62_S150", "T")) {
    return 0;
  }
  return 1;
}


// #############################################################################################
// O_MOTORANSCHLUSS_S150	    CB_O_MOTORANSCHLUSS_S150        (M78) Motoranschluss von oben
function Bestimme_M78_S150(oData) {
  // O_MOTORANSCHLUSS_S150
  var sDTKAttribute = "O_MOTORANSCHLUSS_S150";
  var sCB_Attribute = "CB_" + sDTKAttribute;

  var sKAG = "M78";

  var bCheck = false;
  var aKAG = oData.oParsingData.MLFB.KAG || [];

  if (aKAG.indexOf(sKAG) >= 0) {
    bCheck = Check_M78_S150(oData, sDTKAttribute, sKAG);
  }
  if (bCheck) {
    ECL_EnableAttribute(sCB_Attribute);
    ECL_SelectValue(sCB_Attribute, "T");
  } else {
    ECL_DeselectAttribute(sCB_Attribute);
  }
}
function Check_M78_S150(oData, sDTKAttribute, sKAG) {
  if (oData.IsStartConfig == "0") return 1;
  // -----------------------------------------------------------------------------------------
  /* VT_S150_M00012	Optionen M60+M66+M78
   *  O_BERUEHR_SCHUTZ_S150  O_SCHIFFSAUSFUEHRUNG_S150 O_MOTORANSCHLUSS_S150
   * VT_S150_M00018	Optionen M78+Schutzart
   *  O_MOTORANSCHLUSS_S150 O_SCHUTZART_S150
   * VT_S150_M00033	Optionen L07+L08+L10+L15+M78
   *  O_AUSGANG_S150  O_MOTORANSCHLUSS_S150
  */
  // --------------------------------------------------------------------------------------------
  /* 
  todo
  var HMK_FALLNUMMER_S150 = ECL_GetValue("HMK_FALLNUMMER_S150");
  var MLFB11_S150 = oData.oParsingData.MLFB.POS11_13;
  // A VT_S150_M00116	Einschraenkungen_MLFB_M78
  //		HMK_FALLNUMMER_S150		MLFB11_S150		O_MOTORANSCHL_M78_S150
  var sTable = "VT_S150_M00116" + sDB_Suffix;
  var sSQL =    "SELECT " +    sDTKAttribute +    " FROM " +    sTable +    " WHERE " +
    "HMK_FALLNUMMER_S150 = '" +    HMK_FALLNUMMER_S150 +    "' AND " +
    "MLFB11_S150 = '" +    MLFB11_S150 +    "' AND " +
    sDTKAttribute +    " = '" +    sKAG +    "';";
 
  var aResult = GetDBDataSetEXT(sSQL);
  if (aResult.length < 1) {
    return 0;
  }
  // --------------------------------------------------------------------------------------------
  // B VT_S150_M00077	Gueltige Optionen Ausfuehrung II
  //		IN_AUSFUEHRUNG_S150		O_OUTPUT_S150	O_NETZANSCH_M13_S150	O_MOTORANSCHL_M78_S150
  var IN_AUSFUEHRUNG_S150 = ECL_GetValue("IN_AUSFUEHRUNG_S150");
  var O_OUTPUT_S150 = ECL_GetValue("O_OUTPUT_S150");
 
  var O_NETZANSCH_M13_S150 = "STD";
  if (ECL_ValueSelected("CB_O_NETZANSCH_M13_S150", "T")) {
    var O_NETZANSCH_M13_S150 = "M13";
  }
  var sTable = "VT_S150_M00077" + sDB_Suffix;
  var sSQL =    "SELECT " +    sDTKAttribute +    " FROM " +    sTable +    " WHERE " +
    "IN_AUSFUEHRUNG_S150 = '" +    IN_AUSFUEHRUNG_S150 +    "' AND " +
    "O_OUTPUT_S150 = '" +    O_OUTPUT_S150 +    "' AND " +
    "O_NETZANSCH_M13_S150 = '" +    O_NETZANSCH_M13_S150 +    "' AND " +
    sDTKAttribute +    " = '" +    sKAG +    "';";
 
  var aResult = GetDBDataSetEXT(sSQL);
  if (aResult.length < 1) {
    return 0;
  }
  
  */
  // -----------------------------------------------------------------------------------------
  return 1;
}

// #############################################################################################
// O_KRANTRANSPORTHILFE_S150	CB_O_KRANTRANSPORTHILFE_S150    (M90) Krantransporthilfe für Schränke (oben montiert)
function Bestimme_M90_S150(oData) {
  // O_KRANTRANSPORTHILFE_S150
  var sDTKAttribute = "O_KRANTRANSPORTHILFE_S150";
  var sCB_Attribute = "CB_" + sDTKAttribute;

  var sKAG = "M90";

  var bCheck = false;
  var aKAG = oData.oParsingData.MLFB.KAG || [];

  if (aKAG.indexOf(sKAG) >= 0) {
    bCheck = Check_M90_S150(oData, sDTKAttribute, sKAG);
  }
  if (bCheck) {
    ECL_EnableAttribute(sCB_Attribute);
    ECL_SelectValue(sCB_Attribute, "T");
  } else {
    ECL_DeselectAttribute(sCB_Attribute);
  }
}
function Check_M90_S150(oData, sDTKAttribute, sKAG) {
  if (oData.IsStartConfig == "0") return 1;
  // -----------------------------------------------------------------------------------------
  /* keine */
  // -----------------------------------------------------------------------------------------
  return 1;
}
// #############################################################################################
