//@legacy
//#mode(full-ecma)

//@import "CFG_S150_VT.js"

function SetOptions2_Init_S150(oData) {
  /* 
  Sonstige Optionen
    O_MODULE_S150	                    Module Cabinet-Mounted          (NON, K46, K48, K50, K51)
    O_COMMUNICATIONBOARD_S150	        Communication Board             (NON, G20, G33)
    O_BREMSEINHEIT_S150	              Bremseinheit                    (NON, L61, L62, L64, L65)
    O_GEWAEHR_S150	                  Gewährleistungsverlängerung     (NON, Q80, Q81, Q82, Q83, Q84, Q85)
    O_BESCHRIFTUNGSSCHIL_S150	        Beschriftungsschild zur Anlagenkennzeichnung   (NON, Y31, Y32, Y33)
    
    O_KUND_KL_LEISTE_S150	            CB_O_KUND_KL_LEISTE_S150        (G60) Kundenklemmleiste TM31
    O_ZUS_KUND_KL_LEISTE_S150	        CB_O_ZUS_KUND_KL_LEISTE_S150    (G61) zusätzliche Kundenklemmleiste TM31
    O_TERMINAL_BOARD_S150	(G62)       CB_O_TERMINAL_BOARD_S150        (G62) Terminal Board TB30
    O_SAFETY_LIZENZ_S150        	    CB_O_SAFETY_LIZENZ_S150         (K01) Safety-Lizenz für eine Achse
    O_K52_S150	                      CB_O_K52_S150                   (K52) Zusätzliches Sensor Module Cabinet-Mounted SMC30
    O_KLEMMENMODUL_S150	              CB_O_KLEMMENMODUL_S150          (K82) Klemmenmodul zur Ansteuerung der Sicherheitsfunktionen "Safe Torque Off" und "Safe Stop 1"
    O_TM54F_S150	                    CB_O_TM54F_S150                 (K87) Terminal Module TM54F
    O_SAFETY_SBA_K88_S150	            CB_O_SAFETY_SBA_K88_S150        (K88) Safe Brake Adapter SBA AC 230 V
    O_CU3202_S150	                    CB_O_CU3202_S150                (K95) Control Unit CU320-2 PN (PROFINET, EtherNet/IP)
    O_HILFSBETRIEBE_S150	            CB_O_HILFSBETRIEBE_S150         (L19) Anschluss für ext. Hilfsbetriebe
    O_SCHRANKBELEUCHTUNG_S150	        CB_O_SCHRANKBELEUCHTUNG_S150    (L50) Schrankbeleuchtung mit Service-Steckdose
    O_STILLSTANDSHEIZUNG_S150	        CB_O_STILLSTANDSHEIZUNG_S150    (L55) Schrank Stillstandsheizung
    O_ADEREND_M91_S150	              CB_O_ADEREND_M91_S150           (M91) Vollständige Aderendmarkierung der Steuerleitungen
    O_SONDERLACKIERUNG_S150	          (Y09) Schrank-Sonderlackierung  (Y09, NON)
      O_FARBE_S150	                  (Y09) Schrank-Sonderlackierung - RAL Farbe:

  Fertigungsablaufpläne
    O_FLOWCHARTS_S150	Dokument Fertigungsablaufplan   (NON, B43, B44, B45)

  Verpackungsoptionen
    O_PACKING_LIST_B55_S150	            CB_O_PACKING_LIST_B55_S150      (B55) Erstellung einer vorläufigen und einer finalen Packliste (Versand)
    O_LABEL_PACKAGE_B56_S150	          CB_O_LABEL_PACKAGE_B56_S150     (B56) Etikettierung der Packstücke mit kundenspezifischem Label
    O_PHOTO_DOCU_B57_S150	              CB_O_PHOTO_DOCU_B57_S150        (B57) Foto-Dokumentation der bestellten Einheiten

  Branchenspezifische Optionen Chemie
    O_NAMUR_B00_S150	                  CB_O_NAMUR_B00_S150             (B00) Namur Klemmenleiste
    O_PELV_B02_S150	                    CB_O_PELV_B02_S150              (B02) Sicher getrennte 24-V-Versorgung (PELV)
    O_FREMDABGANG_S150	                CB_O_FREMDABGANG_S150           (B03) Fremdabgang externe Hilfsbetriebe (ungesteuert)

  Branchenspezifische Optionen Schiffbau
    O_SCHIFFSAUSFUEHRUNG_S150	      CB_O_SCHIFFSAUSFUEHRUNG_S150        (M66) Schiffsausführung
      H_TRIGGER_IP_M66_S150           (M66) Schiffsausführung - Trigger IP        (T, F)  
    O_EINZELZERTIFIKAT_S150	        Einzelzertifikat  (NON, E11, E21, E31, E51, E61, E71)
  */

  if (oData && !isEmpty(oData)) {

    Bestimme_O_MODULE_S150(oData); //
    Bestimme_O_COMMUNICATIONBOARD_S150(oData); //
    Bestimme_O_BREMSEINHEIT_S150(oData); //
    Bestimme_O_GEWAEHR_S150(oData); //
    Bestimme_O_BESCHRIFTUNGSSCHILD_S150(oData); //
    Bestimme_G60_S150(oData); //
    Bestimme_G61_S150(oData); //
    Bestimme_G62_S150(oData); //
    Bestimme_K52_S150(oData); //
    Bestimme_K01_S150(oData); // is mandatory if K52 is selected
    Bestimme_K82_S150(oData); //
    Bestimme_K87_S150(oData); //
    Bestimme_K88_S150(oData); //
    Bestimme_K95_S150(oData); //
    Bestimme_L19_S150(oData); //
    Bestimme_L50_S150(oData); //
    Bestimme_L55_S150(oData); //
    Bestimme_M91_S150(oData); //
    Bestimme_Y09_S150(oData); //

    Bestimme_O_FLOWCHARTS_S150(oData); //

    Bestimme_B55_S150(oData); //
    Bestimme_B56_S150(oData); //
    Bestimme_B57_S150(oData); //

    Bestimme_B00_S150(oData); //
    Bestimme_B02_S150(oData); //
    Bestimme_B03_S150(oData); //

    Bestimme_M66_S150(oData); //
    Bestimme_O_ZERTIFITKAT_S150(oData);
  } else {
    ExecSetStandardifValueEmpty("O_MODULE_S150", "NON");
    ExecSetStandardifValueEmpty("O_COMMUNICATIONBOARD_S150", "NON");
    ExecSetStandardifValueEmpty("O_BREMSEINHEIT_S150", "NON");
    ExecSetStandardifValueEmpty("O_GEWAEHR_S150", "NON");
    ExecSetStandardifValueEmpty("O_BESCHRIFTUNGSSCHIL_S150", "NON");

    ECL_DeselectAttribute("CB_O_KUND_KL_LEISTE_S150");
    ECL_DeselectAttribute("CB_O_ZUS_KUND_KL_LEISTE_S150");
    ECL_DeselectAttribute("CB_O_TERMINAL_BOARD_S150");
    ECL_DeselectAttribute("CB_O_SAFETY_LIZENZ_S150");
    ECL_DeselectAttribute("CB_O_K52_S150");
    ECL_DeselectAttribute("CB_O_KLEMMENMODUL_S150");
    ECL_DeselectAttribute("CB_O_TM54F_S150");
    ECL_DeselectAttribute("CB_O_SAFETY_SBA_K88_S150");
    ECL_DeselectAttribute("CB_O_CU3202_S150");
    ECL_DeselectAttribute("CB_O_HILFSBETRIEBE_S150");
    ECL_DeselectAttribute("CB_O_SCHRANKBELEUCHTUNG_S150");
    ECL_DeselectAttribute("CB_O_STILLSTANDSHEIZUNG_S150");
    ECL_DeselectAttribute("CB_O_ADEREND_M91_S150");
    ExecSetStandardifValueEmpty("O_SONDERLACKIERUNG_S150", "NON");
    ECL_SetValue("O_FARBE_S150", "");

    ExecSetStandardifValueEmpty("O_FLOWCHARTS_S150", "NON");

    ECL_DeselectAttribute("CB_O_PACKING_LIST_B55_S150");
    ECL_DeselectAttribute("CB_O_LABEL_PACKAGE_B56_S150");
    ECL_DeselectAttribute("CB_O_PHOTO_DOCU_B57_S150");

    ECL_DeselectAttribute("CB_O_NAMUR_B00_S150");
    ECL_DeselectAttribute("CB_O_PELV_B02_S150");
    ECL_DeselectAttribute("CB_O_FREMDABGANG_S150");

    ECL_DeselectAttribute("CB_O_SCHIFFSAUSFUEHRUNG_S150");
    ExecSetStandardifValueEmpty("O_EINZELZERTIFIKAT_S150", "NON");
  }
}
// #############################################################################################
// O_MODULE_S150	                    Module Cabinet-Mounted          (NON, K46, K48, K50, K51)
function Bestimme_O_MODULE_S150(oData) {
  // O_MODULE_S150
  var sDTKAttribute = "O_MODULE_S150";
  // KAGs  NON, K46, K48, K50, K51


  // Safety-context
  /* if single-connection (MLFB08 ==1) K50+K52 is mandatory for
        SOS	    6
        SS2	    5
        SBT	    12
    if parallel connection MLFB08==2 K50+K52 is mandatory for
        SS1-a/SS1-r 	14
        SOS             6
        SS2	            5
        SLS	            2
        SSM	            4
        SDI	            3
        SBT	            12
    */
  var MLFB08_S150 = oData.oParsingData.MLFB.POS8;
  var ECSI_CX_SafetyFunctions = ECL_GetValue("ECSI_CX_SafetyFunctions");
  var aSafetyFunctions = ECSI_CX_SafetyFunctions.split(";");
  var bK50Mandatory = false;

  if (aSafetyFunctions && aSafetyFunctions.length > 0 && MLFB08_S150 == "1") {
    for (var i = 0; i < aSafetyFunctions.length; i++) {
      if (aSafetyFunctions[i] == "5" || aSafetyFunctions[i] == "6" || aSafetyFunctions[i] == "12") {
        bK50Mandatory = true;
        break;
      }
    }
  } else if (aSafetyFunctions && aSafetyFunctions.length > 0 && MLFB08_S150 == "2") {
    for (var i = 0; i < aSafetyFunctions.length; i++) {
      if (
        aSafetyFunctions[i] == "2" ||
        aSafetyFunctions[i] == "3" ||
        aSafetyFunctions[i] == "4" ||
        aSafetyFunctions[i] == "5" ||
        aSafetyFunctions[i] == "6" ||
        aSafetyFunctions[i] == "12" ||
        aSafetyFunctions[i] == "14"
      ) {
        bK50Mandatory = true;
        break;
      }
    }
  }

  if (bK50Mandatory) {
    var sKAG = "K50";

    ECL_DeactivateAllAttributeValues(sDTKAttribute);
    ECL_ActivateValue(sDTKAttribute, sKAG);
    ECL_SelectValue(sDTKAttribute, sKAG);
  } else {
    var aKAG = oData.oParsingData.MLFB.KAG || [];

    var sKAG = getKAGforAttribute(sDTKAttribute, aKAG);
    var bCheck = false;
    if (sKAG != "NON") {
      bCheck = Check_O_MODULE_S150(oData, sDTKAttribute, sKAG);
    }
    if (bCheck) {
      ECL_ActivateValue(sDTKAttribute, sKAG);
      ECL_SelectValue(sDTKAttribute, sKAG);
    } else {
      ECL_ActivateValue(sDTKAttribute, "NON");
      ECL_SelectValue(sDTKAttribute, "NON");
    }
  }
}

function Check_O_MODULE_S150(oData, sDTKAttribute, sKAG) {
  if (oData.IsStartConfig == "0") return 1;
  // -----------------------------------------------------------------------------------------
  /*
   * VT_S150_M00041	Opt K46, K48, K50, K51<-->Opt K52
   *  O_MODULE_S150 O_K52_S150
   * 
   * DICT1_ERR_S150___PL_O_MODULE
  * / K52 nachrangig? todo
  var O_K52_S150 = "NON";
  if (ECL_ValueSelected("CB_O_K52_S150", "T")) {
    O_K52_S150 = "K52";
  }

  var sTable = "VT_S150_M00041" + sDB_Suffix;
  var sSQL = "SELECT " + sDTKAttribute + " FROM " + sTable + " WHERE " +
    "O_K52_S150 = '" + O_K52_S150 + "' AND " +
    sDTKAttribute + " = '" + sKAG + "';";

  var aResult = GetDBDataSetEXT(sSQL);
  if (aResult.length < 1) {
    return 0;
  }*/
  // -----------------------------------------------------------------------------------------
  return 1;
}
// #############################################################################################
// O_COMMUNICATIONBOARD_S150	        Communication Board             (NON, G20, G33)
function Bestimme_O_COMMUNICATIONBOARD_S150(oData) {
  // O_COMMUNICATION_S150
  var sDTKAttribute = "O_COMMUNICATIONBOARD_S150";

  // KAGs  G20, G33, NON
  var aKAG = oData.oParsingData.MLFB.KAG || [];

  var sKAG = getKAGforAttribute(sDTKAttribute, aKAG);
  var bCheck = false;
  if (sKAG != "NON") {
    bCheck = Check_O_COMMUNICATION_S150(oData, sDTKAttribute, sKAG);
  }
  if (bCheck) {
    ECL_ActivateValue(sDTKAttribute, sKAG);
    ECL_SelectValue(sDTKAttribute, sKAG);
  } else {
    ECL_ActivateValue(sDTKAttribute, "NON");
    ECL_SelectValue(sDTKAttribute, "NON");
  }
}
function Check_O_COMMUNICATION_S150(oData, sDTKAttribute, sKAG) {
  if (oData.IsStartConfig == "0") return 1;
  // -----------------------------------------------------------------------------------------
  /*
   * 	VT_S150_M00042	Options G62 <--> G20, G33
   *   O_COMMUNICATIONBOARD_S150  O_TERMINAL_BOARD_S150
  */

  // -----------------------------------------------------------------------------------------
  return 1;
}

// #############################################################################################
// O_BREMSEINHEIT_S150	              Bremseinheit                    (NON, L61, L62, L64, L65)
function Bestimme_O_BREMSEINHEIT_S150(oData) {
  // O_BREMSEINHEIT_S150
  var sDTKAttribute = "O_BREMSEINHEIT_S150";

  // KAGs  NON, L61, L62, L64, L65
  var aKAG = oData.oParsingData.MLFB.KAG || [];

  var sKAG = getKAGforAttribute(sDTKAttribute, aKAG);
  var bCheck = false;
  if (sKAG != "NON") {
    bCheck = Check_O_BREMSEINHEIT_S150(oData, sDTKAttribute, sKAG);
  }
  if (bCheck) {
    ECL_ActivateValue(sDTKAttribute, sKAG);
    ECL_SelectValue(sDTKAttribute, sKAG);
  } else {
    ECL_ActivateValue(sDTKAttribute, "NON");
    ECL_SelectValue(sDTKAttribute, "NON");
  }
}
function Check_O_BREMSEINHEIT_S150(oData, sDTKAttribute, sKAG) {
  if (oData.IsStartConfig == "0") return 1;
  // -----------------------------------------------------------------------------------------
  /*
   * 	VT_S150_M00026	Optionen L61-L65
   * 		IN_SPANNUNG_S150  HMK_MLFB10_13_S150  O_BREMSEINHEIT_S150
  */
  var IN_SPANNUNG_S150 = ECL_GetValue("IN_SPANNUNG_S150");
  var HMK_MLFB10_13_S150 = ECL_GetValue("HMK_MLFB10_13_S150");

  var sTable = "VT_S150_M00026" + sDB_Suffix;
  var sSQL = "SELECT " + sDTKAttribute + " FROM " + sTable + " WHERE " +
    "IN_SPANNUNG_S150 = '" + IN_SPANNUNG_S150 + "' AND " +
    "HMK_MLFB10_13_S150 = '" + HMK_MLFB10_13_S150 + "' AND " +
    sDTKAttribute + " = '" + sKAG + "';";

  var aResult = GetDBDataSetEXT(sSQL);
  if (aResult.length < 1) {
    return 0;
  }
  // -----------------------------------------------------------------------------------------
  return 1;
}

// #############################################################################################
// O_GEWAEHR_S150	                  Gewährleistungsverlängerung     (NON, Q80, Q81, Q82, Q83, Q84, Q85)
function Bestimme_O_GEWAEHR_S150(oData) {
  // O_GEWAEHR_S150
  var sDTKAttribute = "O_GEWAEHR_S150";

  // KAGs  Q80, Q81, Q82, Q83, Q84, Q85, NON
  var aKAG = oData.oParsingData.MLFB.KAG || [];

  var sKAG = getKAGforAttribute(sDTKAttribute, aKAG);
  var bCheck = false;
  if (sKAG != "NON") {
    bCheck = Check_O_GEWAEHR_S150(oData, sDTKAttribute, sKAG);
  }
  if (bCheck) {
    ECL_ActivateValue(sDTKAttribute, sKAG);
    ECL_SelectValue(sDTKAttribute, sKAG);
  } else {
    ECL_ActivateValue(sDTKAttribute, "NON");
    ECL_SelectValue(sDTKAttribute, "NON");
  }
}
function Check_O_GEWAEHR_S150(oData, sDTKAttribute, sKAG) {
  if (oData.IsStartConfig == "0") return 1;
  // -----------------------------------------------------------------------------------------
  /* keine */
  // -----------------------------------------------------------------------------------------
  return 1;
}

// #############################################################################################
// O_BESCHRIFTUNGSSCHIL_S150	        Beschriftungsschild zur Anlagenkennzeichnung   (NON, Y31, Y32, Y33)
function Bestimme_O_BESCHRIFTUNGSSCHILD_S150(oData) {
  // O_BESCHRIFTUNGSSCHIL_S150
  var sDTKAttribute = "O_BESCHRIFTUNGSSCHIL_S150";

  // KAGs  Y31, Y32, Y33, NON
  var aKAG = oData.oParsingData.MLFB.KAG || [];

  var sKAG = getKAGforAttribute(sDTKAttribute, aKAG);
  var bCheck = false;
  if (sKAG != "NON") {
    bCheck = Check_O_BESCHRIFTUNGSSCHILD_S150(oData, sDTKAttribute, sKAG);
  }
  if (bCheck) {
    ECL_ActivateValue(sDTKAttribute, sKAG);
    ECL_SelectValue(sDTKAttribute, sKAG);
  } else {
    ECL_ActivateValue(sDTKAttribute, "NON");
    ECL_SelectValue(sDTKAttribute, "NON");
  }
}
function Check_O_BESCHRIFTUNGSSCHILD_S150(oData, sDTKAttribute, sKAG) {
  if (oData.IsStartConfig == "0") return 1;
  // -----------------------------------------------------------------------------------------
  /* keine */
  // -----------------------------------------------------------------------------------------
  return 1;
}

// #############################################################################################
// O_KUND_KL_LEISTE_S150	            CB_O_KUND_KL_LEISTE_S150        (G60) Kundenklemmleiste TM31
function Bestimme_G60_S150(oData) {
  // O_KUND_KL_LEISTE_S150
  var sDTKAttribute = "O_KUND_KL_LEISTE_S150";
  var sCB_Attribute = "CB_" + sDTKAttribute;

  var sKAG = "G60";

  var bCheck = false;
  var aKAG = oData.oParsingData.MLFB.KAG || [];

  if (aKAG.indexOf(sKAG) >= 0) {
    bCheck = Check_G60_S150(oData, sDTKAttribute, sKAG);
  }
  if (bCheck) {
    ECL_EnableAttribute(sCB_Attribute);
    ECL_SelectValue(sCB_Attribute, "T");
  } else {
    ECL_DeselectAttribute(sCB_Attribute);
  }
}

function Check_G60_S150(oData, sDTKAttribute, sKAG) {
  if (oData.IsStartConfig == "0") return 1;
  // -----------------------------------------------------------------------------------------
  /* VT_S150_M00017	Optionen G60+G61
   *    O_KUND_KL_LEISTE_S150 O_ZUS_KUND_KL_LEISTE_S150
   */
  // -----------------------------------------------------------------------------------------
  return 1;
}
// #############################################################################################
// O_ZUS_KUND_KL_LEISTE_S150	        CB_O_ZUS_KUND_KL_LEISTE_S150    (G61) zusätzliche Kundenklemmleiste TM31
function Bestimme_G61_S150(oData) {
  // O_ZUS_KUND_KL_LEISTE_S150
  var sDTKAttribute = "O_ZUS_KUND_KL_LEISTE_S150";
  var sCB_Attribute = "CB_" + sDTKAttribute;

  var sKAG = "G61";

  var bCheck = false;
  var aKAG = oData.oParsingData.MLFB.KAG || [];

  if (aKAG.indexOf(sKAG) >= 0) {
    bCheck = Check_G61_S150(oData, sDTKAttribute, sKAG);
  }
  if (bCheck) {
    ECL_EnableAttribute(sCB_Attribute);
    ECL_SelectValue(sCB_Attribute, "T");
  } else {
    ECL_DeselectAttribute(sCB_Attribute);
  }
}

function Check_G61_S150(oData, sDTKAttribute, sKAG) {
  if (oData.IsStartConfig == "0") return 1;
  // -----------------------------------------------------------------------------------------
  /*
    VT_S150_M00017	Optionen G60+G61
   *    O_KUND_KL_LEISTE_S150 O_ZUS_KUND_KL_LEISTE_S150
  */
  // --------------------------------------------------------------------------------------------
  var O_KUND_KL_LEISTE_S150 = "NON";
  if (ECL_ValueSelected("CB_O_KUND_KL_LEISTE_S150", "T")) {
    var O_KUND_KL_LEISTE_S150 = "G60";
  }

  var sTable = "VT_S150_M00017" + sDB_Suffix;
  var sSQL = "SELECT " + sDTKAttribute + " FROM " + sTable + " WHERE " +
    "O_KUND_KL_LEISTE_S150 = '" + O_KUND_KL_LEISTE_S150 + "' AND " +
    sDTKAttribute + " = '" + sKAG + "';";

  var aResult = GetDBDataSetEXT(sSQL);
  if (aResult.length < 1) {
    return 0;
  }
  // -----------------------------------------------------------------------------------------
  return 1;
}
// #############################################################################################
// O_TERMINAL_BOARD_S150	(G62)       CB_O_TERMINAL_BOARD_S150        (G62) Terminal Board TB30
function Bestimme_G62_S150(oData) {
  // O_TERMINAL_BOARD_S150
  var sDTKAttribute = "O_TERMINAL_BOARD_S150";
  var sCB_Attribute = "CB_" + sDTKAttribute;

  var sKAG = "G62";

  var bCheck = false;
  var aKAG = oData.oParsingData.MLFB.KAG || [];

  if (aKAG.indexOf(sKAG) >= 0) {
    bCheck = Check_G62_S150(oData, sDTKAttribute, sKAG);
  }
  if (bCheck) {
    ECL_EnableAttribute(sCB_Attribute);
    ECL_SelectValue(sCB_Attribute, "T");
  } else {
    ECL_DeselectAttribute(sCB_Attribute);
  }
}
function Check_G62_S150(oData, sDTKAttribute, sKAG) {
  if (oData.IsStartConfig == "0") return 1;
  // -----------------------------------------------------------------------------------------
  /*  VT_S150_M00042	Options G62 <--> G20, G33
   *   O_COMMUNICATIONBOARD_S150  O_TERMINAL_BOARD_S150
   */
  var O_COMMUNICATIONBOARD_S150 = ECL_GetValue("O_COMMUNICATIONBOARD_S150");

  var sTable = "VT_S150_M00080" + sDB_Suffix;
  var sSQL = "SELECT " + sDTKAttribute + " FROM " + sTable + " WHERE " +
    "O_COMMUNICATIONBOARD_S150 = '" + O_COMMUNICATIONBOARD_S150 + "' AND " +
    sDTKAttribute + " = '" + sKAG + "';";

  var aResult = GetDBDataSetEXT(sSQL);
  if (aResult.length < 1) {
    return 0;
  }
  // -----------------------------------------------------------------------------------------
  return 1;
}
// #############################################################################################
// O_SAFETY_LIZENZ_S150        	    CB_O_SAFETY_LIZENZ_S150         (K01) Safety-Lizenz für eine Achse
function Bestimme_K01_S150(oData) {
  // O_SAFETY_LIZENZ_S150
  var sDTKAttribute = "O_SAFETY_LIZENZ_S150";
  var sCB_Attribute = "CB_" + sDTKAttribute;

  var sKAG = "K01";

  // K01 mandatory from context Safetyfunctions
  var ECSI_CX_SafetyFunctions = ECL_GetValue("ECSI_CX_SafetyFunctions");
  var aSafetyFunctions = ECSI_CX_SafetyFunctions.split(";");
  var bK01Mandatory = false;

  if (aSafetyFunctions && aSafetyFunctions.length > 0) {
    for (var i = 0; i < aSafetyFunctions.length; i++) {
      if (
        aSafetyFunctions[i] == "2" ||
        aSafetyFunctions[i] == "3" ||
        aSafetyFunctions[i] == "4" ||
        aSafetyFunctions[i] == "5" ||
        aSafetyFunctions[i] == "6" ||
        aSafetyFunctions[i] == "12" ||
        aSafetyFunctions[i] == "14" ||
        ECL_ValueSelected("CB_O_K52_S150", "T")
      ) {
        bK01Mandatory = true;
        break;
      }
    }
  }

  if (bK01Mandatory) {
    ECL_SelectValue(sCB_Attribute, "T");
    ECL_DisableAttribute(sCB_Attribute);
  } else {
    var bCheck = false;
    var aKAG = oData.oParsingData.MLFB.KAG || [];

    if (aKAG.indexOf(sKAG) >= 0) {
      bCheck = Check_K01_S150(oData, sDTKAttribute, sKAG);
    }
    if (bCheck) {
      ECL_EnableAttribute(sCB_Attribute);
      ECL_SelectValue(sCB_Attribute, "T");
    } else {
      ECL_DeselectAttribute(sCB_Attribute);
    }
  }
}
function Check_K01_S150(oData, sDTKAttribute, sKAG) {
  if (oData.IsStartConfig == "0") return 1;
  // -----------------------------------------------------------------------------------------
  /*  VT_S150_M00040	Option K01<--> Option K52
   *   O_SAFETY_LIZENZ_S150  O_K52_S150
  * /

  var O_K52_S150 = "NON";
  if (ECL_ValueSelected("CB_O_K52_S150", "T")) {
    O_K52_S150 = "K52";
  }

  var sTable = "VT_S150_M00040" + sDB_Suffix;
  var sSQL = "SELECT " + sDTKAttribute + " FROM " + sTable + " WHERE " +
    "O_K52_S150 = '" + O_K52_S150 + "' AND " +
    sDTKAttribute + " = '" + sKAG + "';";

  var aResult = GetDBDataSetEXT(sSQL);
  if (aResult.length < 1) {
    return 0;
  }*/
  // -----------------------------------------------------------------------------------------
  return 1;
}

// #############################################################################################
// O_K52_S150	      CB_O_K52_S150      (K52) Zusätzliches Sensor Module Cabinet-Mounted SMC30
function Bestimme_K52_S150(oData) {
  // O_K52_S150
  var sDTKAttribute = "O_K52_S150";
  var sCB_Attribute = "CB_" + sDTKAttribute;

  var sKAG = "K52";

  // Safety-context
  /* if single-connection (MLFB08 ==1) K50+K52 is mandatory for
        SOS	    6
        SS2	    5
        SBT	    12
    if parallel connection MLFB08==2 K50+K52 is mandatory for
        SS1-a/SS1-r 	  14
        SOS             6
        SS2	            5
        SLS	            2
        SSM	            4
        SDI	            3
        SBT	            12
    */
  var MLFB08_S150 = oData.oParsingData.MLFB.POS8;
  var ECSI_CX_SafetyFunctions = ECL_GetValue("ECSI_CX_SafetyFunctions");
  var aSafetyFunctions = ECSI_CX_SafetyFunctions.split(";");
  var bK52Mandatory = false;

  if (aSafetyFunctions && aSafetyFunctions.length > 0 && MLFB08_S150 == "1") {
    for (var i = 0; i < aSafetyFunctions.length; i++) {
      if (aSafetyFunctions[i] == "5" || aSafetyFunctions[i] == "6" || aSafetyFunctions[i] == "12") {
        bK52Mandatory = true;
        break;
      }
    }
  } else if (aSafetyFunctions && aSafetyFunctions.length > 0 && MLFB08_S150 == "2") {
    for (var i = 0; i < aSafetyFunctions.length; i++) {
      if (
        aSafetyFunctions[i] == "2" ||
        aSafetyFunctions[i] == "3" ||
        aSafetyFunctions[i] == "4" ||
        aSafetyFunctions[i] == "5" ||
        aSafetyFunctions[i] == "6" ||
        aSafetyFunctions[i] == "12" ||
        aSafetyFunctions[i] == "14"
      ) {
        bK52Mandatory = true;
        break;
      }
    }
  }

  if (bK52Mandatory) {
    ECL_SelectValue(sCB_Attribute, "T");
    ECL_DisableAttribute(sCB_Attribute);
  } else {
    var bCheck = false;
    var aKAG = oData.oParsingData.MLFB.KAG || [];

    if (aKAG.indexOf(sKAG) >= 0) {
      bCheck = Check_K52_S150(oData, sDTKAttribute, sKAG);
    }
    if (bCheck) {
      ECL_EnableAttribute(sCB_Attribute);
      ECL_SelectValue(sCB_Attribute, "T");
    } else {
      ECL_DeselectAttribute(sCB_Attribute);
    }
  }
}
function Check_K52_S150(oData, sDTKAttribute, sKAG) {
  if (oData.IsStartConfig == "0") return 1;
  // -----------------------------------------------------------------------------------------
  /* VT_S150_M00040	Option K01<--> Option K52
   *  O_SAFETY_LIZENZ_S150  O_K52_S150
   * VT_S150_M00041	Opt K46, K48, K50, K51<-->Opt K52
   *  O_MODULE_S150 O_K52_S150
   */
  // -----------------------------------------------------------------------------------------
  /*var O_SAFETY_LIZENZ_S150 = "NON";
  if (ECL_ValueSelected("CB_O_SAFETY_LIZENZ_S150", "T")) {
    O_SAFETY_LIZENZ_S150 = "K01";
  }
  var sTable = "VT_S150_M00040" + sDB_Suffix;
  var sSQL = "SELECT " + sDTKAttribute + " FROM " + sTable + " WHERE " +
    "O_SAFETY_LIZENZ_S150 = '" + O_SAFETY_LIZENZ_S150 + "' AND " +
    sDTKAttribute + " = '" + sKAG + "';";

  var aResult = GetDBDataSetEXT(sSQL);
  if (aResult.length < 1) {
    return 0;
  }*/
  // -----------------------------------------------------------------------------------------
  // VT_S150_M00041	Opt K46, K48, K50, K51<-->Opt K52
  //    O_MODULE_S150 O_K52_S150
  var O_MODULE_S150 = ECL_GetValue("O_MODULE_S150");

  var sTable = "VT_S150_M00041" + sDB_Suffix;
  var sSQL = "SELECT " + sDTKAttribute + " FROM " + sTable + " WHERE " +
    "O_MODULE_S150 = '" + O_MODULE_S150 + "' AND " +
    sDTKAttribute + " = '" + sKAG + "';";

  var aResult = GetDBDataSetEXT(sSQL);
  if (aResult.length < 1) {
    return 0;
  }
  // -----------------------------------------------------------------------------------------
  return 1;
}
// #############################################################################################
// O_KLEMMENMODUL_S150	       CB_O_KLEMMENMODUL_S150     (K82) Klemmenmodul zur Ansteuerung der Sicherheitsfunktionen "Safe Torque Off" und "Safe Stop 1"
function Bestimme_K82_S150(oData) {
  // O_KLEMMENMODUL_S150
  var sDTKAttribute = "O_KLEMMENMODUL_S150";
  var sCB_Attribute = "CB_" + sDTKAttribute;

  var sKAG = "K82";

  var bCheck = false;
  var aKAG = oData.oParsingData.MLFB.KAG || [];

  // if STO, SS1 K82 select todo ??? G150 analog
  if (aKAG.indexOf(sKAG) >= 0) {
    bCheck = Check_K82_S150(oData, sDTKAttribute, sKAG);
  }
  if (bCheck) {
    ECL_EnableAttribute(sCB_Attribute);
    ECL_SelectValue(sCB_Attribute, "T");
  } else {
    ECL_DeselectAttribute(sCB_Attribute);
  }
}
function Check_K82_S150(oData, sDTKAttribute, sKAG) {
  if (oData.IsStartConfig == "0") return 1;
  // -----------------------------------------------------------------------------------------
  /* keine */
  // -----------------------------------------------------------------------------------------
  return 1;
}
// #############################################################################################
// O_TM54F_S150	                    CB_O_TM54F_S150                 (K87) Terminal Module TM54F
function Bestimme_K87_S150(oData) {
  // O_TM54F_S150
  var sDTKAttribute = "O_TM54F_S150";
  var sCB_Attribute = "CB_" + sDTKAttribute;

  var sKAG = "K87";

  var bCheck = false;
  var aKAG = oData.oParsingData.MLFB.KAG || [];

  if (aKAG.indexOf(sKAG) >= 0) {
    bCheck = Check_K87_S150(oData, sDTKAttribute, sKAG);
  }
  if (bCheck) {
    ECL_EnableAttribute(sCB_Attribute);
    ECL_SelectValue(sCB_Attribute, "T");
  } else {
    ECL_DeselectAttribute(sCB_Attribute);
  }
}
function Check_K87_S150(oData, sDTKAttribute, sKAG) {
  if (oData.IsStartConfig == "0") return 1;
  // -----------------------------------------------------------------------------------------
  /* keine */
  // -----------------------------------------------------------------------------------------
  return 1;
}
// #############################################################################################
//  O_SAFETY_SBA_K88_S150	            CB_O_SAFETY_SBA_K88_S150        (K88) Safe Brake Adapter SBA AC 230 V
function Bestimme_K88_S150(oData) {
  // O_SAFETY_SBA_K88_S150
  var sDTKAttribute = "O_SAFETY_SBA_K88_S150";
  var sCB_Attribute = "CB_" + sDTKAttribute;

  var sKAG = "K88";

  // K88 mandatory from context Safetyfunctions, if SBC (11)
  var ECSI_CX_SafetyFunctions = ECL_GetValue("ECSI_CX_SafetyFunctions");
  var aSafetyFunctions = ECSI_CX_SafetyFunctions.split(";");
  var bK88Mandatory = false;

  if (aSafetyFunctions && aSafetyFunctions.length > 0) {
    for (var i = 0; i < aSafetyFunctions.length; i++) {
      if (aSafetyFunctions[i] == "11") {
        bK88Mandatory = true;
        break;
      }
    }
  }

  if (bK88Mandatory) {
    ECL_SelectValue(sCB_Attribute, "T");
    ECL_DisableAttribute(sCB_Attribute);
  } else {
    var bCheck = false;
    var aKAG = oData.oParsingData.MLFB.KAG || [];

    if (aKAG.indexOf(sKAG) >= 0) {
      bCheck = Check_K88_S150(oData, sDTKAttribute, sKAG);
    }
    if (bCheck) {
      ECL_EnableAttribute(sCB_Attribute);
      ECL_SelectValue(sCB_Attribute, "T");
    } else {
      ECL_DeselectAttribute(sCB_Attribute);
    }
  }
}
function Check_K88_S150(oData, sDTKAttribute, sKAG) {
  if (oData.IsStartConfig == "0") return 1;
  // -----------------------------------------------------------------------------------------
  /* keine */
  // -----------------------------------------------------------------------------------------
  return 1;
}
// #############################################################################################
// O_CU3202_S150	                    CB_O_CU3202_S150                (K95) Control Unit CU320-2 PN (PROFINET, EtherNet/IP)
function Bestimme_K95_S150(oData) {
  // O_CU3202_S150
  var sDTKAttribute = "O_CU3202_S150";
  var sCB_Attribute = "CB_" + sDTKAttribute;

  var sKAG = "K95";

  var bCheck = false;
  var aKAG = oData.oParsingData.MLFB.KAG || [];

  if (aKAG.indexOf(sKAG) >= 0) {
    bCheck = Check_K95_S150(oData, sDTKAttribute, sKAG);
  }
  if (bCheck) {
    ECL_EnableAttribute(sCB_Attribute);
    ECL_SelectValue(sCB_Attribute, "T");
  } else {
    ECL_DeselectAttribute(sCB_Attribute);
  }
}
function Check_K95_S150(oData, sDTKAttribute, sKAG) {
  if (oData.IsStartConfig == "0") return 1;
  // -----------------------------------------------------------------------------------------
  /* keine */
  // -----------------------------------------------------------------------------------------
  return 1;
}
// #############################################################################################
//  O_HILFSBETRIEBE_S150	            CB_O_HILFSBETRIEBE_S150         (L19) Anschluss für ext. Hilfsbetriebe
function Bestimme_L19_S150(oData) {
  // O_HILFSBETRIEBE_S150
  var sDTKAttribute = "O_HILFSBETRIEBE_S150";
  var sCB_Attribute = "CB_" + sDTKAttribute;

  var sKAG = "L19";

  var bCheck = false;
  var aKAG = oData.oParsingData.MLFB.KAG || [];

  if (aKAG.indexOf(sKAG) >= 0) {
    bCheck = Check_L19_S150(oData, sDTKAttribute, sKAG);
  }
  if (bCheck) {
    ECL_EnableAttribute(sCB_Attribute);
    ECL_SelectValue(sCB_Attribute, "T");
  } else {
    ECL_DeselectAttribute(sCB_Attribute);
  }
}
function Check_L19_S150(oData, sDTKAttribute, sKAG) {
  if (oData.IsStartConfig == "0") return 1;
  // -----------------------------------------------------------------------------------------
  /* keine */
  // -----------------------------------------------------------------------------------------
  return 1;
}
// #############################################################################################
// O_SCHRANKBELEUCHTUNG_S150	        CB_O_SCHRANKBELEUCHTUNG_S150    (L50) Schrankbeleuchtung mit Service-Steckdose
function Bestimme_L50_S150(oData) {
  // O_SCHRANKBELEUCHTUNG_S150
  var sDTKAttribute = "O_SCHRANKBELEUCHTUNG_S150";
  var sCB_Attribute = "CB_" + sDTKAttribute;

  var sKAG = "L50";

  var bCheck = false;
  var aKAG = oData.oParsingData.MLFB.KAG || [];

  if (aKAG.indexOf(sKAG) >= 0) {
    bCheck = Check_L50_S150(oData, sDTKAttribute, sKAG);
  }
  if (bCheck) {
    ECL_EnableAttribute(sCB_Attribute);
    ECL_SelectValue(sCB_Attribute, "T");
  } else {
    ECL_DeselectAttribute(sCB_Attribute);
  }
}
function Check_L50_S150(oData, sDTKAttribute, sKAG) {
  if (oData.IsStartConfig == "0") return 1;
  // -----------------------------------------------------------------------------------------
  /* keine */
  // -----------------------------------------------------------------------------------------
  return 1;
}
// #############################################################################################
// O_STILLSTANDSHEIZUNG_S150	        CB_O_STILLSTANDSHEIZUNG_S150    (L55) Schrank Stillstandsheizung
function Bestimme_L55_S150(oData) {
  // O_STILLSTANDSHEIZUNG_S150
  var sDTKAttribute = "O_STILLSTANDSHEIZUNG_S150";
  var sCB_Attribute = "CB_" + sDTKAttribute;

  var sKAG = "L55";

  var bCheck = false;
  var aKAG = oData.oParsingData.MLFB.KAG || [];

  if (aKAG.indexOf(sKAG) >= 0) {
    bCheck = Check_L55_S150(oData, sDTKAttribute, sKAG);
  }
  if (bCheck) {
    ECL_EnableAttribute(sCB_Attribute);
    ECL_SelectValue(sCB_Attribute, "T");
  } else {
    ECL_DeselectAttribute(sCB_Attribute);
  }
}
function Check_L55_S150(oData, sDTKAttribute, sKAG) {
  if (oData.IsStartConfig == "0") return 1;
  // -----------------------------------------------------------------------------------------
  /* VT_S150_M00016	Optionen M66+L55
   *   O_SCHIFFSAUSFUEHRUNG_S150  O_STILLSTANDSHEIZUNG_S150
   * /
  var O_SCHIFFSAUSFUEHRUNG_S150 = "NON";
  if (ECL_ValueSelected("CB_O_SCHIFFSAUSFUEHRUNG_S150", "T")) {
    var O_SCHIFFSAUSFUEHRUNG_S150 = "M66";
  }

  var sTable = "VT_S150_M00016" + sDB_Suffix;
  var sSQL = "SELECT " + sDTKAttribute + " FROM " + sTable + " WHERE " +
    "O_SCHIFFSAUSFUEHRUNG_S150 = '" + O_SCHIFFSAUSFUEHRUNG_S150 + "' AND " +
    sDTKAttribute + " = '" + sKAG + "';";

  var aResult = GetDBDataSetEXT(sSQL);
  if (aResult.length < 1) {
    return 0;
  }*/
  // -----------------------------------------------------------------------------------------
  return 1;
}
// #############################################################################################
// O_ADEREND_M91_S150	              CB_O_ADEREND_M91_S150           (M91) Vollständige Aderendmarkierung der Steuerleitungen
function Bestimme_M91_S150(oData) {
  // O_ADEREND_M91_S150
  var sDTKAttribute = "O_ADEREND_M91_S150";
  var sCB_Attribute = "CB_" + sDTKAttribute;

  var sKAG = "M91";

  var bCheck = false;
  var aKAG = oData.oParsingData.MLFB.KAG || [];

  if (aKAG.indexOf(sKAG) >= 0) {
    bCheck = Check_M91_S150(oData, sDTKAttribute, sKAG);
  }
  if (bCheck) {
    ECL_EnableAttribute(sCB_Attribute);
    ECL_SelectValue(sCB_Attribute, "T");
  } else {
    ECL_DeselectAttribute(sCB_Attribute);
  }
}
function Check_M91_S150(oData, sDTKAttribute, sKAG) {
  if (oData.IsStartConfig == "0") return 1;
  // -----------------------------------------------------------------------------------------
  /* keine */
  // -----------------------------------------------------------------------------------------
  return 1;
}
// #############################################################################################
// O_SONDERLACKIERUNG_S150	          (Y09) Schrank-Sonderlackierung  (Y09, NON)
//    O_FARBE_S150	                  (Y09) Schrank-Sonderlackierung - RAL Farbe:
function Bestimme_Y09_S150(oData) {
  // O_SONDERLACKIERUNG_S150
  var sDTKAttribute = "O_SONDERLACKIERUNG_S150";
  // KAGs  NON, Y09
  var aKAG = oData.oParsingData.MLFB.KAG || [];

  var sKAG = getKAGforAttribute(sDTKAttribute, aKAG);
  var bCheck = false;
  if (sKAG != "NON") {
    bCheck = Check_Y09_S150(oData, sDTKAttribute, sKAG);
  }
  if (bCheck) {
    ECL_ActivateValue(sDTKAttribute, sKAG);
    ECL_SelectValue(sDTKAttribute, sKAG);
  } else {
    ECL_ActivateValue(sDTKAttribute, "NON");
    ECL_SelectValue(sDTKAttribute, "NON");
    ECL_ResetAttribute("OE_LACK_S150");
  }
}

function Check_Y09_S150(oData, sDTKAttribute, sKAG) {
  if (oData.IsStartConfig == "0") return 1;
  // -----------------------------------------------------------------------------------------
  /* keine */
  // -----------------------------------------------------------------------------------------
  return 1;
}

// #############################################################################################
// Fertigungsablaufpläne
// #############################################################################################

// #############################################################################################
//  O_FLOWCHARTS_S150	Dokument Fertigungsablaufplan   (NON, B43, B44, B45)
function Bestimme_O_FLOWCHARTS_S150(oData) {
  // O_BESCHRIFTUNGSSCHIL_S150
  var sDTKAttribute = "O_FLOWCHARTS_S150";

  // KAGs  NON, B43, B44, B45
  var aKAG = oData.oParsingData.MLFB.KAG || [];

  var sKAG = getKAGforAttribute(sDTKAttribute, aKAG);
  var bCheck = false;
  if (sKAG != "NON") {
    bCheck = Check_O_FLOWCHARTS_S150(oData, sDTKAttribute, sKAG);
  }
  if (bCheck) {
    ECL_ActivateValue(sDTKAttribute, sKAG);
    ECL_SelectValue(sDTKAttribute, sKAG);
  } else {
    ECL_ActivateValue(sDTKAttribute, "NON");
    ECL_SelectValue(sDTKAttribute, "NON");
  }
}
function Check_O_FLOWCHARTS_S150(oData, sDTKAttribute, sKAG) {
  if (oData.IsStartConfig == "0") return 1;
  // -----------------------------------------------------------------------------------------
  /* keine */
  // -----------------------------------------------------------------------------------------
  return 1;
}
// #############################################################################################
// Verpackungsoptionen
// #############################################################################################

// #############################################################################################
// O_PACKING_LIST_B55_S150	            CB_O_PACKING_LIST_B55_S150      (B55) Erstellung einer vorläufigen und einer finalen Packliste (Versand)
function Bestimme_B55_S150(oData) {
  // O_PACKING_LIST_B55_S150
  var sDTKAttribute = "O_PACKING_LIST_B55_S150";
  var sCB_Attribute = "CB_" + sDTKAttribute;

  var sKAG = "B55";

  var bCheck = false;
  var aKAG = oData.oParsingData.MLFB.KAG || [];

  if (aKAG.indexOf(sKAG) >= 0) {
    bCheck = Check_B55_S150(oData, sDTKAttribute, sKAG);
  }
  if (bCheck) {
    ECL_EnableAttribute(sCB_Attribute);
    ECL_SelectValue(sCB_Attribute, "T");
  } else {
    ECL_DeselectAttribute(sCB_Attribute);
  }
}
function Check_B55_S150(oData, sDTKAttribute, sKAG) {
  if (oData.IsStartConfig == "0") return 1;
  // -----------------------------------------------------------------------------------------
  /* keine */
  // -----------------------------------------------------------------------------------------
  return 1;
}

// #############################################################################################
// O_LABEL_PACKAGE_B56_S150	          CB_O_LABEL_PACKAGE_B56_S150     (B56) Etikettierung der Packstücke mit kundenspezifischem Label
function Bestimme_B56_S150(oData) {
  // O_LABEL_PACKAGE_B56_S150
  var sDTKAttribute = "O_LABEL_PACKAGE_B56_S150";
  var sCB_Attribute = "CB_" + sDTKAttribute;

  var sKAG = "B56";

  var bCheck = false;
  var aKAG = oData.oParsingData.MLFB.KAG || [];

  if (aKAG.indexOf(sKAG) >= 0) {
    bCheck = Check_B56_S150(oData, sDTKAttribute, sKAG);
  }
  if (bCheck) {
    ECL_EnableAttribute(sCB_Attribute);
    ECL_SelectValue(sCB_Attribute, "T");
  } else {
    ECL_DeselectAttribute(sCB_Attribute);
  }
}
function Check_B56_S150(oData, sDTKAttribute, sKAG) {
  if (oData.IsStartConfig == "0") return 1;
  // -----------------------------------------------------------------------------------------
  /* keine */
  // -----------------------------------------------------------------------------------------
  return 1;
}

// #############################################################################################
// O_PHOTO_DOCU_B57_S150	              CB_O_PHOTO_DOCU_B57_S150        (B57) Foto-Dokumentation der bestellten Einheiten
function Bestimme_B57_S150(oData) {
  // O_PHOTO_DOCU_B57_S150
  var sDTKAttribute = "O_PHOTO_DOCU_B57_S150";
  var sCB_Attribute = "CB_" + sDTKAttribute;

  var sKAG = "B57";

  var bCheck = false;
  var aKAG = oData.oParsingData.MLFB.KAG || [];

  if (aKAG.indexOf(sKAG) >= 0) {
    bCheck = Check_B57_S150(oData, sDTKAttribute, sKAG);
  }
  if (bCheck) {
    ECL_EnableAttribute(sCB_Attribute);
    ECL_SelectValue(sCB_Attribute, "T");
  } else {
    ECL_DeselectAttribute(sCB_Attribute);
  }
}
function Check_B57_S150(oData, sDTKAttribute, sKAG) {
  if (oData.IsStartConfig == "0") return 1;
  // -----------------------------------------------------------------------------------------
  /* keine */
  // -----------------------------------------------------------------------------------------
  return 1;
}
// #############################################################################################
// Branchenspezifische Optionen Chemie
// #############################################################################################

// #############################################################################################
// O_NAMUR_B00_S150	                  CB_O_NAMUR_B00_S150             (B00) Namur Klemmenleiste
function Bestimme_B00_S150(oData) {
  // O_NAMUR_B00_S150
  var sDTKAttribute = "O_NAMUR_B00_S150";
  var sCB_Attribute = "CB_" + sDTKAttribute;

  var sKAG = "B00";

  var bCheck = false;
  var aKAG = oData.oParsingData.MLFB.KAG || [];

  if (aKAG.indexOf(sKAG) >= 0) {
    bCheck = Check_B00_S150(oData, sDTKAttribute, sKAG);
  }
  if (bCheck) {
    ECL_EnableAttribute(sCB_Attribute);
    ECL_SelectValue(sCB_Attribute, "T");
  } else {
    ECL_DeselectAttribute(sCB_Attribute);
  }
}
function Check_B00_S150(oData, sDTKAttribute, sKAG) {
  if (oData.IsStartConfig == "0") return 1;
  // -----------------------------------------------------------------------------------------
  /* VT_S150_M00047	Optionen B00+B02+B03
   *    O_NAMUR_B00_S150  O_PELV_B02_S150 O_FREMDABGANG_S150
   */
  // -----------------------------------------------------------------------------------------
  return 1;
}
// #############################################################################################
// O_PELV_B02_S150	                    CB_O_PELV_B02_S150              (B02) Sicher getrennte 24-V-Versorgung (PELV)
function Bestimme_B02_S150(oData) {
  // O_PELV_B02_S150
  var sDTKAttribute = "O_PELV_B02_S150";
  var sCB_Attribute = "CB_" + sDTKAttribute;

  var sKAG = "B02";

  var bCheck = false;
  var aKAG = oData.oParsingData.MLFB.KAG || [];

  if (aKAG.indexOf(sKAG) >= 0) {
    bCheck = Check_B02_S150(oData, sDTKAttribute, sKAG);
  }
  if (bCheck) {
    ECL_EnableAttribute(sCB_Attribute);
    ECL_SelectValue(sCB_Attribute, "T");
  } else {
    ECL_DeselectAttribute(sCB_Attribute);
  }
}
function Check_B02_S150(oData, sDTKAttribute, sKAG) {
  if (oData.IsStartConfig == "0") return 1;
  // -----------------------------------------------------------------------------------------
  /* VT_S150_M00047	Optionen B00+B02+B03
   *    O_NAMUR_B00_S150  O_PELV_B02_S150 O_FREMDABGANG_S150
   */
  var O_NAMUR_B00_S150 = "NON";
  if (ECL_ValueSelected("CB_O_NAMUR_B00_S150", "T")) {
    O_NAMUR_B00_S150 = "B00";
  }

  var sTable = "VT_S150_M00047" + sDB_Suffix;
  var sSQL = "SELECT " + sDTKAttribute + " FROM " + sTable + " WHERE " +
    "O_NAMUR_B00_S150 = '" + O_NAMUR_B00_S150 + "' AND " +
    sDTKAttribute + " = '" + sKAG + "';";

  var aResult = GetDBDataSetEXT(sSQL);
  if (aResult.length < 1) {
    return 0;
  }
  // -----------------------------------------------------------------------------------------
  return 1;
}
// #############################################################################################
// O_FREMDABGANG_S150	                CB_O_FREMDABGANG_S150           (B03) Fremdabgang externe Hilfsbetriebe (ungesteuert)
function Bestimme_B03_S150(oData) {
  // O_FREMDABGANG_S150
  var sDTKAttribute = "O_FREMDABGANG_S150";
  var sCB_Attribute = "CB_" + sDTKAttribute;

  var sKAG = "B03";

  var bCheck = false;
  var aKAG = oData.oParsingData.MLFB.KAG || [];

  if (aKAG.indexOf(sKAG) >= 0) {
    bCheck = Check_B03_S150(oData, sDTKAttribute, sKAG);
  }
  if (bCheck) {
    ECL_EnableAttribute(sCB_Attribute);
    ECL_SelectValue(sCB_Attribute, "T");
  } else {
    ECL_DeselectAttribute(sCB_Attribute);
  }
}
function Check_B03_S150(oData, sDTKAttribute, sKAG) {
  if (oData.IsStartConfig == "0") return 1;
  // -----------------------------------------------------------------------------------------
  /* VT_S150_M00047	Optionen B00+B02+B03
   *    O_NAMUR_B00_S150  O_PELV_B02_S150 O_FREMDABGANG_S150
   */
  var O_NAMUR_B00_S150 = "NON";
  if (ECL_ValueSelected("CB_O_NAMUR_B00_S150", "T")) {
    O_NAMUR_B00_S150 = "B00";
  }
  var O_PELV_B02_S150 = "NON";
  if (ECL_ValueSelected("CB_O_PELV_B02_S150", "T")) {
    O_PELV_B02_S150 = "B02";
  }
  var sTable = "VT_S150_M00047" + sDB_Suffix;
  var sSQL = "SELECT " + sDTKAttribute + " FROM " + sTable + " WHERE " +
    "O_NAMUR_B00_S150 = '" + O_NAMUR_B00_S150 + "' AND " +
    "O_PELV_B02_S150 = '" + O_PELV_B02_S150 + "' AND " +
    sDTKAttribute + " = '" + sKAG + "';";

  var aResult = GetDBDataSetEXT(sSQL);
  if (aResult.length < 1) {
    return 0;
  }
  // -----------------------------------------------------------------------------------------
  return 1;
}

// #############################################################################################
// Branchenspezifische Optionen Schiffbau
// #############################################################################################

// #############################################################################################
// O_SCHIFFSAUSFUEHRUNG_S150	      CB_O_SCHIFFSAUSFUEHRUNG_S150        (M66) Schiffsausführung
//    H_TRIGGER_IP_M66_S150           (M66) Schiffsausführung - Trigger IP        (T, F)
function Bestimme_M66_S150(oData) {
  // O_SCHIFFSAUSFUEHRUNG_S150
  var sDTKAttribute = "O_SCHIFFSAUSFUEHRUNG_S150";
  var sCB_Attribute = "CB_" + sDTKAttribute;

  var sKAG = "M66";

  var bCheck = false;
  var aKAG = oData.oParsingData.MLFB.KAG || [];

  if (aKAG.indexOf(sKAG) >= 0) {
    bCheck = Check_M66_S150(oData, sDTKAttribute, sKAG);
  }
  var H_TRIGGER_IP_M66_S150 = "F";
  if (bCheck) {
    ECL_EnableAttribute(sCB_Attribute);
    ECL_SelectValue(sCB_Attribute, "T");
    H_TRIGGER_IP_M66_S150 = "T";
  } else {
    ECL_DeselectAttribute(sCB_Attribute);
  }
  ECL_SelectValue("H_TRIGGER_IP_M66_S150", H_TRIGGER_IP_M66_S150);
}
function Check_M66_S150(oData, sDTKAttribute, sKAG) {
  if (oData.IsStartConfig == "0") return 1;
  // -----------------------------------------------------------------------------------------
  /* B VT_S150_M00012	Optionen M60+M66+M78
   *  O_BERUEHR_SCHUTZ_S150  O_SCHIFFSAUSFUEHRUNG_S150 O_MOTORANSCHLUSS_S150
   * A VT_S150_M00014	Optionen M66+Schutzart
   *  O_SCHIFFSAUSFUEHRUNG_S150 O_SCHUTZART_S150
   * C VT_S150_M00016	Optionen M66+L55
   *  O_SCHIFFSAUSFUEHRUNG_S150  O_STILLSTANDSHEIZUNG_S150
   * n.n. VT_S150_M00023	Optionen M66 + E11-E71
   *  O_SCHIFFSAUSFUEHRUNG_S150  O_EINZELZERTIFIKAT_S150
   */
  // A VT_S150_M00014	Optionen M66+Schutzart
  //  O_SCHIFFSAUSFUEHRUNG_S150 O_SCHUTZART_S150
  var O_SCHUTZART_S150 = ECL_GetValue("O_SCHUTZART_S150");

  var sTable = "VT_S150_M00014" + sDB_Suffix;

  var sSQL = "SELECT " + sDTKAttribute + " FROM " + sTable + " WHERE " +
    "O_SCHUTZART_S150 = '" + O_SCHUTZART_S150 + "' AND " +
    sDTKAttribute + " = '" + sKAG + "';";

  var aResult = GetDBDataSetEXT(sSQL);
  if (aResult.length < 1) {
    return 0;
  }
  // -----------------------------------------------------------------------------------------
  // B VT_S150_M00012	Optionen M60+M66+M78
  //  O_BERUEHR_SCHUTZ_S150  O_SCHIFFSAUSFUEHRUNG_S150 O_MOTORANSCHLUSS_S150
  var O_BERUEHR_SCHUTZ_S150 = "NON";
  if (ECL_ValueSelected("CB_O_BERUEHR_SCHUTZ_S150", "T")) {
    O_BERUEHR_SCHUTZ_S150 = "M60";
  }
  var O_MOTORANSCHLUSS_S150 = "NON";
  if (ECL_ValueSelected("CB_O_MOTORANSCHLUSS_S150", "T")) {
    O_MOTORANSCHLUSS_S150 = "M78";
  }

  var sTable = "VT_S150_M00012" + sDB_Suffix;
  var sSQL = "SELECT " + sDTKAttribute + " FROM " + sTable + " WHERE " +
    "O_BERUEHR_SCHUTZ_S150 = '" + O_BERUEHR_SCHUTZ_S150 + "' AND " +
    "O_MOTORANSCHLUSS_S150 = '" + O_MOTORANSCHLUSS_S150 + "' AND " +
    sDTKAttribute + " = '" + sKAG + "';";

  var aResult = GetDBDataSetEXT(sSQL);
  if (aResult.length < 1) {
    return 0;
  }
  // -----------------------------------------------------------------------------------------
  // C VT_S150_M00016	Optionen M66+L55
  //  O_SCHIFFSAUSFUEHRUNG_S150  O_STILLSTANDSHEIZUNG_S150
  var O_STILLSTANDSHEIZUNG_S150 = "NON";
  if (ECL_ValueSelected("CB_O_STILLSTANDSHEIZUNG_S150", "T")) {
    O_STILLSTANDSHEIZUNG_S150 = "L55";
  }

  var sTable = "VT_S150_M00112" + sDB_Suffix;
  var sSQL = "SELECT " + sDTKAttribute + " FROM " + sTable + " WHERE " +
    "O_STILLSTANDSHEIZUNG_S150 = '" + O_STILLSTANDSHEIZUNG_S150 + "' AND " +
    sDTKAttribute + " = '" + sKAG + "';";

  var aResult = GetDBDataSetEXT(sSQL);
  if (aResult.length < 1) {
    return 0;
  }
  // -----------------------------------------------------------------------------------------
  return 1;
}
// #############################################################################################
// O_EINZELZERTIFIKAT_S150	        Einzelzertifikat  (NON, E11, E21, E31, E51, E61, E71)
function Bestimme_O_ZERTIFITKAT_S150(oData) {
  // O_EINZELZERTIFIKAT_S150
  var sDTKAttribute = "O_EINZELZERTIFIKAT_S150";

  // KAGs  [E11, E21, E31, E51, E61, E71, NON]
  var aKAG = oData.oParsingData.MLFB.KAG || [];

  var sKAG = getKAGforAttribute(sDTKAttribute, aKAG);
  var bCheck = false;
  if (sKAG != "NON") {
    bCheck = Check_O_ZERTIFITKAT_S150(oData, sDTKAttribute, sKAG);
  }
  if (bCheck) {
    ECL_ActivateValue(sDTKAttribute, sKAG);
    ECL_SelectValue(sDTKAttribute, sKAG);
  } else {
    ECL_ActivateValue(sDTKAttribute, "NON");
    ECL_SelectValue(sDTKAttribute, "NON");
  }
}
function Check_O_ZERTIFITKAT_S150(oData, sDTKAttribute, sKAG) {
  if (oData.IsStartConfig == "0") return 1;

  /** 	VT_S150_M00023	Optionen M66 + E11-E71
   *   O_SCHIFFSAUSFUEHRUNG_S150  O_EINZELZERTIFIKAT_S150
  */
  var O_SCHIFFSAUSFUEHRUNG_S150 = "NON";
  if (ECL_ValueSelected("CB_O_SCHIFFSAUSFUEHRUNG_S150", "T")) {
    var O_SCHIFFSAUSFUEHRUNG_S150 = "M66";
  }

  var sTable = "VT_S150_M00023" + sDB_Suffix;

  var sSQL = "SELECT " + sDTKAttribute + " FROM " + sTable + " WHERE " +
    "O_SCHIFFSAUSFUEHRUNG_S150 = '" + O_SCHIFFSAUSFUEHRUNG_S150 + "' AND " +
    sDTKAttribute + " = '" + sKAG + "';";

  var aResult = GetDBDataSetEXT(sSQL);
  if (aResult.length < 1) {
    return 0;
  }
  // -----------------------------------------------------------------------------------------
  return 1;
}

