//@legacy
//#mode(full-ecma)

//@import "CFG_S150_VT.js"

function SetOptions4_Init_S150(oData) {
  /* Dokumentation und Prüfung
  Dokumentation (Standard: Englisch/Deutsch)
    O_LEIST_SCHILDANGAB_S150		Leistungsschildangaben        (NON, T58, T60, T80, T83, T85, T91)
    O_DOKU_SPRACHE_S150		      Dokumentationssprache         (NON, D58, D60, D80, D91, D93, D94)
    O_DOKU_EPLAN_S150	          CB_O_DOKU_EPLAN_S150	        (D01) Kundendokumentation im EPLAN-Format
    O_DOKU_DXF_S150	            CB_O_DOKU_DXF_S150	          (D02) Kundendokumentation (Stromlauf-, Klemmen-, Anordnungsplan) im DXF-Format
    O_DOKU_VORAB_S150	          CB_O_DOKU_VORAB_S150	        (D14) Vorab-Erstellung der Kundendokumentation
    O_DOKU_SPRACHED00_S1_S150	  CB_O_DOKU_SPRACHED00_S1_S150	(D00) Dokumentation in Einzelsprache, Deutsch
    O_DOKU_SPRACHED56_S1_S150	  CB_O_DOKU_SPRACHED56_S1_S150	(D56) Dokumentation in Einzelsprache, Russisch
    O_DOKU_SPRACHED72_S1_S150	  CB_O_DOKU_SPRACHED72_S1_S150	(D72) Dokumentation in Einzelsprache, Italienisch
    O_DOKU_SPRACHED76_S1_S150	  CB_O_DOKU_SPRACHED76_S1_S150	(D76) Dokumentation in Einzelsprache, Englisch
    O_DOKU_SPRACHED77_S1_S150	  CB_O_DOKU_SPRACHED77_S1_S150	(D77) Dokumentation in Einzelsprache, Französisch
    O_DOKU_SPRACHED78_S1_S150	  CB_O_DOKU_SPRACHED78_S1_S150	(D78) Dokumentation in Einzelsprache, Spanisch
    O_DOKU_SPRACHED84_S1_S150	  CB_O_DOKU_SPRACHED84_S1_S150	(D84) Dokumentation in Einzelsprache, Chinesisch


  Umrichterabnahme bei Kundenanwesenheit
    O_FUNKTIONSPRUEF_F71_S150	  CB_O_FUNKTIONSPRUEF_F71_S150	Funktionsprüfung ohne angeschlossenen Motor
    O_FUNKTIONSPRUEF_F75_S150	  CB_O_FUNKTIONSPRUEF_F75_S150	Funktionsprüfung mit Prüffeldmotor im Leerlauf
    O_ISOLATIONSPRUEFUNG_S150	  CB_O_ISOLATIONSPRUEFUNG_S150	Isolationsprüfung
    O_SICHTABNAHME_S150	        CB_O_SICHTABNAHME_S150	      (F03) Sichtabnahme
    O_KUNDENSPEZ_ABNAHME_S150	  CB_O_KUNDENSPEZ_ABNAHME_S150	(F97) Kundenspezifische Abnahme

  */

  if (oData && !isEmpty(oData)) {
    Bestimme_O_LEIST_SCHILDANGAB_S150(oData); //
    Bestimme_O_DOKU_SPRACHE_S150(oData); //

    Bestimme_D01_S150(oData); //
    Bestimme_D02_S150(oData); //
    Bestimme_D14_S150(oData); //
    Bestimme_D00_S150(oData); //
    Bestimme_D56_S150(oData); //
    Bestimme_D72_S150(oData); //
    Bestimme_D76_S150(oData); //
    Bestimme_D77_S150(oData); //
    Bestimme_D78_S150(oData); //
    Bestimme_D84_S150(oData); //

    Bestimme_F71_S150(oData); //
    Bestimme_F75_S150(oData); //
    Bestimme_F77_S150(oData); //
    Bestimme_F03_S150(oData); //
    Bestimme_F97_S150(oData); //

  } else {
    ExecSetStandardifValueEmpty("O_LEIST_SCHILDANGAB_S150", "NON");
    ExecSetStandardifValueEmpty("O_DOKU_SPRACHE_S150", "NON");
    ExecSetStandardifValueEmpty("O_FUNKTIONSPRUEF_F71_S150", "NON");
    ExecSetStandardifValueEmpty("O_FUNKTIONSPRUEF_F75_S150", "NON");
    ExecSetStandardifValueEmpty("O_ISOLATIONSPRUEFUNG_S150", "NON");
  }
}

// #############################################################################################
//  O_LEIST_SCHILDANGAB_S150		Leistungsschildangaben        (NON, T58, T60, T80, T83, T85, T91)
function Bestimme_O_LEIST_SCHILDANGAB_S150(oData) {
  var sDTKAttribute = "O_LEIST_SCHILDANGAB_S150";

  // KAGs  NON, T58, T60, T80, T83, T85, T91
  var aKAG = oData.oParsingData.MLFB.KAG || [];

  var sKAG = getKAGforAttribute(sDTKAttribute, aKAG);

  if (sKAG != "NON") {
    ECL_ActivateValue(sDTKAttribute, sKAG);
    ECL_SelectValue(sDTKAttribute, sKAG);
  } else {
    ECL_ActivateValue(sDTKAttribute, "NON");
    ECL_SelectValue(sDTKAttribute, "NON");
  }
}

// #############################################################################################
// O_DOKU_SPRACHE_S150		      Dokumentationssprache         (NON, D58, D60, D80, D91, D93, D94)
function Bestimme_O_DOKU_SPRACHE_S150(oData) {
  var sDTKAttribute = "O_DOKU_SPRACHE_S150";

  // KAGs  NON, D58, D60, D80, D91, D93, D94
  var aKAG = oData.oParsingData.MLFB.KAG || [];

  var sKAG = getKAGforAttribute(sDTKAttribute, aKAG);

  if (sKAG != "NON") {
    ECL_ActivateValue(sDTKAttribute, sKAG);
    ECL_SelectValue(sDTKAttribute, sKAG);
  } else {
    ECL_ActivateValue(sDTKAttribute, "NON");
    ECL_SelectValue(sDTKAttribute, "NON");
  }
}

// #############################################################################################
// O_DOKU_EPLAN_S150	          CB_O_DOKU_EPLAN_S150	        (D01) Kundendokumentation im EPLAN-Format
function Bestimme_D01_S150(oData) {
  // O_DOKU_EPLAN_S150
  var sDTKAttribute = "O_DOKU_EPLAN_S150";
  var sCB_Attribute = "CB_" + sDTKAttribute;

  var sKAG = "D01";

  var aKAG = oData.oParsingData.MLFB.KAG || [];

  if (aKAG.indexOf(sKAG) >= 0) {
    ECL_EnableAttribute(sCB_Attribute);
    ECL_SelectValue(sCB_Attribute, "T");
  } else {
    ECL_DeselectAttribute(sCB_Attribute);
  }
}

// #############################################################################################
// O_DOKU_DXF_S150	            CB_O_DOKU_DXF_S150	          (D02) Kundendokumentation (Stromlauf-, Klemmen-, Anordnungsplan) im DXF-Format
function Bestimme_D02_S150(oData) {

  var sDTKAttribute = "O_DOKU_DXF_S150";
  var sCB_Attribute = "CB_" + sDTKAttribute;

  var sKAG = "D02";

  var aKAG = oData.oParsingData.MLFB.KAG || [];

  if (aKAG.indexOf(sKAG) >= 0) {
    ECL_EnableAttribute(sCB_Attribute);
    ECL_SelectValue(sCB_Attribute, "T");
  } else {
    ECL_DeselectAttribute(sCB_Attribute);
  }
}

// #############################################################################################
// O_DOKU_VORAB_S150	          CB_O_DOKU_VORAB_S150	        (D14) Vorab-Erstellung der Kundendokumentation
function Bestimme_D14_S150(oData) {

  var sDTKAttribute = "O_DOKU_VORAB_S150";
  var sCB_Attribute = "CB_" + sDTKAttribute;

  var sKAG = "D14";

  var aKAG = oData.oParsingData.MLFB.KAG || [];

  if (aKAG.indexOf(sKAG) >= 0) {
    ECL_EnableAttribute(sCB_Attribute);
    ECL_SelectValue(sCB_Attribute, "T");
  } else {
    ECL_DeselectAttribute(sCB_Attribute);
  }
}

// #############################################################################################
// O_DOKU_SPRACHED00_S1_S150	  CB_O_DOKU_SPRACHED00_S1_S150	(D00) Dokumentation in Einzelsprache, Deutsch
function Bestimme_D00_S150(oData) {

  var sDTKAttribute = "O_DOKU_SPRACHED00_S1_S150";
  var sCB_Attribute = "CB_" + sDTKAttribute;

  var sKAG = "D00";

  var aKAG = oData.oParsingData.MLFB.KAG || [];

  if (aKAG.indexOf(sKAG) >= 0) {
    ECL_EnableAttribute(sCB_Attribute);
    ECL_SelectValue(sCB_Attribute, "T");
  } else {
    ECL_DeselectAttribute(sCB_Attribute);
  }
}

// #############################################################################################
// O_DOKU_SPRACHED56_S1_S150	  CB_O_DOKU_SPRACHED56_S1_S150	(D56) Dokumentation in Einzelsprache, Russisch
function Bestimme_D56_S150(oData) {

  var sDTKAttribute = "O_DOKU_SPRACHED56_S1_S150";
  var sCB_Attribute = "CB_" + sDTKAttribute;

  var sKAG = "D56";

  var aKAG = oData.oParsingData.MLFB.KAG || [];

  if (aKAG.indexOf(sKAG) >= 0) {
    ECL_EnableAttribute(sCB_Attribute);
    ECL_SelectValue(sCB_Attribute, "T");
  } else {
    ECL_DeselectAttribute(sCB_Attribute);
  }
}

// #############################################################################################
// O_DOKU_SPRACHED72_S1_S150	  CB_O_DOKU_SPRACHED72_S1_S150	(D72) Dokumentation in Einzelsprache, Italienisch
function Bestimme_D72_S150(oData) {
  var sDTKAttribute = "O_DOKU_SPRACHED72_S1_S150";
  var sCB_Attribute = "CB_" + sDTKAttribute;

  var sKAG = "D72";

  var aKAG = oData.oParsingData.MLFB.KAG || [];

  if (aKAG.indexOf(sKAG) >= 0) {
    ECL_EnableAttribute(sCB_Attribute);
    ECL_SelectValue(sCB_Attribute, "T");
  } else {
    ECL_DeselectAttribute(sCB_Attribute);
  }
}

// #############################################################################################
// O_DOKU_SPRACHED76_S1_S150	  CB_O_DOKU_SPRACHED76_S1_S150	(D76) Dokumentation in Einzelsprache, Englisch
function Bestimme_D76_S150(oData) {

  var sDTKAttribute = "O_DOKU_SPRACHED76_S1_S150";
  var sCB_Attribute = "CB_" + sDTKAttribute;

  var sKAG = "D76";

  var aKAG = oData.oParsingData.MLFB.KAG || [];

  if (aKAG.indexOf(sKAG) >= 0) {
    ECL_EnableAttribute(sCB_Attribute);
    ECL_SelectValue(sCB_Attribute, "T");
  } else {
    ECL_DeselectAttribute(sCB_Attribute);
  }
}

// #############################################################################################
// O_DOKU_SPRACHED77_S1_S150	  CB_O_DOKU_SPRACHED77_S1_S150	(D77) Dokumentation in Einzelsprache, Französisch
function Bestimme_D77_S150(oData) {

  var sDTKAttribute = "O_DOKU_SPRACHED77_S1_S150";
  var sCB_Attribute = "CB_" + sDTKAttribute;

  var sKAG = "D77";

  var aKAG = oData.oParsingData.MLFB.KAG || [];

  if (aKAG.indexOf(sKAG) >= 0) {
    ECL_EnableAttribute(sCB_Attribute);
    ECL_SelectValue(sCB_Attribute, "T");
  } else {
    ECL_DeselectAttribute(sCB_Attribute);
  }
}

// #############################################################################################
// O_DOKU_SPRACHED78_S1_S150	  CB_O_DOKU_SPRACHED78_S1_S150	(D78) Dokumentation in Einzelsprache, Spanisch
function Bestimme_D78_S150(oData) {

  var sDTKAttribute = "O_DOKU_SPRACHED78_S1_S150";
  var sCB_Attribute = "CB_" + sDTKAttribute;

  var sKAG = "D78";

  var aKAG = oData.oParsingData.MLFB.KAG || [];

  if (aKAG.indexOf(sKAG) >= 0) {
    ECL_EnableAttribute(sCB_Attribute);
    ECL_SelectValue(sCB_Attribute, "T");
  } else {
    ECL_DeselectAttribute(sCB_Attribute);
  }
}

// #############################################################################################
// O_DOKU_SPRACHED84_S1_S150	  CB_O_DOKU_SPRACHED84_S1_S150	(D84) Dokumentation in Einzelsprache, Chinesisch
function Bestimme_D84_S150(oData) {

  var sDTKAttribute = "O_DOKU_SPRACHED84_S1_S150";
  var sCB_Attribute = "CB_" + sDTKAttribute;

  var sKAG = "D84";

  var aKAG = oData.oParsingData.MLFB.KAG || [];

  if (aKAG.indexOf(sKAG) >= 0) {
    ECL_EnableAttribute(sCB_Attribute);
    ECL_SelectValue(sCB_Attribute, "T");
  } else {
    ECL_DeselectAttribute(sCB_Attribute);
  }
}


// #############################################################################################
// O_FUNKTIONSPRUEF_F71_S150	  Funktionsprüfung ohne angeschlossenen Motor
function Bestimme_F71_S150(oData) {
  var sDTKAttribute = "O_FUNKTIONSPRUEF_F71_S150";
  // KAGs  NON, F71, F72

  var aKAG = oData.oParsingData.MLFB.KAG || [];

  var sKAG = getKAGforAttribute(sDTKAttribute, aKAG);
  var bCheck = false;
  if (sKAG != "NON") {
    bCheck = Check_F71_S150(oData, sDTKAttribute, sKAG);
  }
  if (bCheck) {
    ECL_ActivateValue(sDTKAttribute, sKAG);
    ECL_SelectValue(sDTKAttribute, sKAG);
  } else {
    ECL_ActivateValue(sDTKAttribute, "NON");
    ECL_SelectValue(sDTKAttribute, "NON");
  }
}
function Check_F71_S150(oData, sDTKAttribute, sKAG) {
  if (oData.IsStartConfig == "0") return 1;
  // -----------------------------------------------------------------------------------------
  /* VT_S150_M00046	Dep test options F71 .. F77, F03
   * O_FUNKTIONSPRUEF_F71_S150  O_FUNKTIONSPRUEF_F75_S150 O_ISOLATIONSPRUEFUNG_S150 O_SICHTABNAHME_S150
   */
  var sTable = "VT_S150_M00046" + sDB_Suffix;
  var sSQL = "SELECT " + sDTKAttribute + " FROM " + sTable + " WHERE " +
    sDTKAttribute + " = '" + sKAG + "';";

  var aResult = GetDBDataSetEXT(sSQL);
  if (aResult.length < 1) {
    return 0;
  }
  // -----------------------------------------------------------------------------------------
  return 1;
}

// #############################################################################################
// O_FUNKTIONSPRUEF_F75_S150	  CB_O_FUNKTIONSPRUEF_F75_S150	(F75) Funktionsprüfung mit Prüffeldmotor im Leerlauf
function Bestimme_F75_S150(oData) {
  var sDTKAttribute = "O_FUNKTIONSPRUEF_F75_S150";
  // KAGs  NON, F75, F74

  var aKAG = oData.oParsingData.MLFB.KAG || [];

  var sKAG = getKAGforAttribute(sDTKAttribute, aKAG);
  var bCheck = false;
  if (sKAG != "NON") {
    bCheck = Check_F75_S150(oData, sDTKAttribute, sKAG);
  }
  if (bCheck) {
    ECL_ActivateValue(sDTKAttribute, sKAG);
    ECL_SelectValue(sDTKAttribute, sKAG);
  } else {
    ECL_ActivateValue(sDTKAttribute, "NON");
    ECL_SelectValue(sDTKAttribute, "NON");
  }
}
function Check_F75_S150(oData, sDTKAttribute, sKAG) {
  if (oData.IsStartConfig == "0") return 1;
  // -----------------------------------------------------------------------------------------
  /* VT_S150_M00046	Dep test options F71 .. F77, F03
   * O_FUNKTIONSPRUEF_F71_S150  O_FUNKTIONSPRUEF_F75_S150 O_ISOLATIONSPRUEFUNG_S150 O_SICHTABNAHME_S150
   */
  var O_FUNKTIONSPRUEF_F71_S150 = ECL_GetValue("O_FUNKTIONSPRUEF_F71_S150");

  var sTable = "VT_S150_M00046" + sDB_Suffix;
  var sSQL = "SELECT " + sDTKAttribute + " FROM " + sTable + " WHERE " +
    "O_FUNKTIONSPRUEF_F71_S150 = '" + O_FUNKTIONSPRUEF_F71_S150 + "' AND " +
    sDTKAttribute + " = '" + sKAG + "';";

  var aResult = GetDBDataSetEXT(sSQL);
  if (aResult.length < 1) {
    return 0;
  }
  // -----------------------------------------------------------------------------------------
  return 1;
}

// #############################################################################################
// O_ISOLATIONSPRUEFUNG_S150	  CB_O_ISOLATIONSPRUEFUNG_S150	(F77) Isolationsprüfung
function Bestimme_F77_S150(oData) {
  var sDTKAttribute = "O_ISOLATIONSPRUEFUNG_S150";
  // KAGs  NON, F77, F76

  var aKAG = oData.oParsingData.MLFB.KAG || [];

  var sKAG = getKAGforAttribute(sDTKAttribute, aKAG);
  var bCheck = false;
  if (sKAG != "NON") {
    bCheck = Check_F77_S150(oData, sDTKAttribute, sKAG);
  }
  if (bCheck) {
    ECL_ActivateValue(sDTKAttribute, sKAG);
    ECL_SelectValue(sDTKAttribute, sKAG);
  } else {
    ECL_ActivateValue(sDTKAttribute, "NON");
    ECL_SelectValue(sDTKAttribute, "NON");
  }
}
function Check_F77_S150(oData, sDTKAttribute, sKAG) {
  if (oData.IsStartConfig == "0") return 1;
  // -----------------------------------------------------------------------------------------
  /* VT_S150_M00046	Dep test options F71 .. F77, F03
   * O_FUNKTIONSPRUEF_F71_S150  O_FUNKTIONSPRUEF_F75_S150 O_ISOLATIONSPRUEFUNG_S150 O_SICHTABNAHME_S150
   */
  var O_FUNKTIONSPRUEF_F71_S150 = ECL_GetValue("O_FUNKTIONSPRUEF_F71_S150");
  var O_FUNKTIONSPRUEF_F75_S150 = ECL_GetValue("O_FUNKTIONSPRUEF_F75_S150");

  var sTable = "VT_S150_M00046" + sDB_Suffix;
  var sSQL = "SELECT " + sDTKAttribute + " FROM " + sTable + " WHERE " +
    "O_FUNKTIONSPRUEF_F71_S150 = '" + O_FUNKTIONSPRUEF_F71_S150 + "' AND " +
    "O_FUNKTIONSPRUEF_F75_S150 = '" + O_FUNKTIONSPRUEF_F75_S150 + "' AND " +
    sDTKAttribute + " = '" + sKAG + "';";

  var aResult = GetDBDataSetEXT(sSQL);
  if (aResult.length < 1) {
    return 0;
  }
  // -----------------------------------------------------------------------------------------
  return 1;
}

// #############################################################################################
// O_SICHTABNAHME_S150	        CB_O_SICHTABNAHME_S150	      (F03) Sichtabnahme
function Bestimme_F03_S150(oData) {
  var sDTKAttribute = "O_SICHTABNAHME_S150";
  var sCB_Attribute = "CB_" + sDTKAttribute;

  var sKAG = "F03";

  var bCheck = false;
  var aKAG = oData.oParsingData.MLFB.KAG || [];

  if (aKAG.indexOf(sKAG) >= 0) {
    bCheck = Check_F03_S150(oData, sDTKAttribute, sKAG);
  }
  if (bCheck) {
    ECL_EnableAttribute(sCB_Attribute);
    ECL_SelectValue(sCB_Attribute, "T");
  } else {
    ECL_DeselectAttribute(sCB_Attribute);
  }
}
function Check_F03_S150(oData, sDTKAttribute, sKAG) {
  if (oData.IsStartConfig == "0") return 1;
  // -----------------------------------------------------------------------------------------
  /* VT_S150_M00046	Dep test options F71 .. F77, F03
   * O_FUNKTIONSPRUEF_F71_S150  O_FUNKTIONSPRUEF_F75_S150 O_ISOLATIONSPRUEFUNG_S150 O_SICHTABNAHME_S150
   */
  var O_FUNKTIONSPRUEF_F71_S150 = ECL_GetValue("O_FUNKTIONSPRUEF_F71_S150");
  var O_FUNKTIONSPRUEF_F75_S150 = ECL_GetValue("O_FUNKTIONSPRUEF_F75_S150");
  var O_ISOLATIONSPRUEFUNG_S150 = ECL_GetValue("O_ISOLATIONSPRUEFUNG_S150");

  var sTable = "VT_S150_M00046" + sDB_Suffix;
  var sSQL = "SELECT " + sDTKAttribute + " FROM " + sTable + " WHERE " +
    "O_FUNKTIONSPRUEF_F71_S150 = '" + O_FUNKTIONSPRUEF_F71_S150 + "' AND " +
    "O_FUNKTIONSPRUEF_F75_S150 = '" + O_FUNKTIONSPRUEF_F75_S150 + "' AND " +
    "O_ISOLATIONSPRUEFUNG_S150 = '" + O_ISOLATIONSPRUEFUNG_S150 + "' AND " +
    sDTKAttribute + " = '" + sKAG + "';";

  var aResult = GetDBDataSetEXT(sSQL);
  if (aResult.length < 1) {
    return 0;
  }
  // -----------------------------------------------------------------------------------------
  return 1;
}


// #############################################################################################
// O_KUNDENSPEZ_ABNAHME_S150	  CB_O_KUNDENSPEZ_ABNAHME_S150	(F97) Kundenspezifische Abnahme
function Bestimme_F97_S150(oData) {
  var sDTKAttribute = "O_KUNDENSPEZ_ABNAHME_S150";
  var sCB_Attribute = "CB_" + sDTKAttribute;

  var sKAG = "F97";

  var aKAG = oData.oParsingData.MLFB.KAG || [];

  if (aKAG.indexOf(sKAG) >= 0) {
    ECL_EnableAttribute(sCB_Attribute);
    ECL_SelectValue(sCB_Attribute, "T");
  } else {
    ECL_DeselectAttribute(sCB_Attribute);
  }
}
// #############################################################################################

