//@legacy
//#mode(full-ecma)

// ---------------------------------------------------------
// Script for configuration object CFG_SIEMENS_S150
// 	Date: 2024-11-12
// 	User: Administrator
// ---------------------------------------------------------

//@import "CFG_S150_VT.js"

/**
  Abbildung der Produktlogik aus Variantentabellen
*/
function ExecProductLogicS150(strchangedAttribute) {
  var strError = "";
  var sStatus = "";

  var sMLFB = ECL_GetValue("ECSI_MLFB");
  var strBaseTypeMLFB = ECL_GetValue("ECSI_MLFB_BASE_TYPE");
  var strSeriesID = ECL_GetValue("ECSI_CX_SeriesID");
  var strFrequencyConverterDefaultIpProtectionLevel = ECL_GetValue("ECSI_CX_FrequencyConverterDefaultIpProtectionLevel");
  /**
    MLFB01: 6SL3
    MLFB05: 7
    MLFB06: 1
    MLFB07: 0
    MLFB08: 7 
    MLFB09: L
    MLFB10: Spannungsbereich [E,G]
    MLFB11: Leistung 123 	HMK_MLFB10_13_S150 4 digits! (MLFB10...13)
    MLFB12: Leistung 2 
    MLFB13: Leistung 3 
    MLFB14: A
    MLFB15:	A 
    MLFB16:	3 
	
    HMK_MLFB10_13_S150 
  */

  var MLFB01_S150 = ECL_GetValue("MLFB01_S150");
  var MLFB05_S150 = ECL_GetValue("MLFB05_S150");
  var MLFB06_S150 = ECL_GetValue("MLFB06_S150");
  var MLFB07_S150 = ECL_GetValue("MLFB07_S150");
  var MLFB08_S150 = ECL_GetValue("MLFB08_S150");
  var MLFB09_S150 = ECL_GetValue("MLFB09_S150");
  var MLFB10_S150 = ECL_GetValue("MLFB10_S150");
  var MLFB11_S150 = ECL_GetValue("MLFB11_S150");
  var MLFB12_S150 = ECL_GetValue("MLFB12_S150");
  var MLFB13_S150 = ECL_GetValue("MLFB13_S150");
  var MLFB14_S150 = ECL_GetValue("MLFB14_S150");
  var MLFB15_S150 = ECL_GetValue("MLFB15_S150");
  var MLFB16_S150 = ECL_GetValue("MLFB16_S150");


  var sECSI_CX_SafetyFunctions = ECL_GetValue("sECSI_CX_SafetyFunctions");

  var HMK_MLFB10_13_S150 = ECL_GetValue("HMK_MLFB10_13_S150");

  var IN_AUSTELLHOEHE_S150 = ECL_GetValue("IN_AUSTELLHOEHE_S150");
  var IN_UMGEB_TEMP_S150 = ECL_GetValue("IN_UMGEB_TEMP_S150");
  var IN_SPANNUNG_S150 = ECL_GetValue("IN_SPANNUNG_S150");
  // ################################################################################################################
  // Fix Values from SIZER
  // ################################################################################################################
  /**
  all
  */

  // ################################################################################################################
  // H_TRIGGER_IP_M66_S150
  // ################################################################################################################
  /**
  BZ_S150_00120	Einschränken Schutzart_M66
  H_TRIGGER_IP_M66_S150 == 'F'
    if not O_SCHIFFSAUSFUEHRUNG_S150 specified or
      O_SCHIFFSAUSFUEHRUNG_S150 eq 'NON',
  H_TRIGGER_IP_M66_S150 == 'T'
    if O_SCHIFFSAUSFUEHRUNG_S150 specified and
      O_SCHIFFSAUSFUEHRUNG_S150 eq 'M66'

  */
  if (ECL_ValueSelected("CB_O_SCHIFFSAUSFUEHRUNG_S150", "T")) {
    var H_TRIGGER_IP_M66_S150 = "T";
  } else {
    var H_TRIGGER_IP_M66_S150 = "F";
  }
  ECL_SelectValue("H_TRIGGER_IP_M66_S150", H_TRIGGER_IP_M66_S150);
  // ################################################################################################################



  // ################################################################################################################
  // O_SCHUTZART_S150	Schutzart
  // ################################################################################################################
  var sDTKAttribute = "O_SCHUTZART_S150";
  /**
   * c.O_SCHUTZART_S150 in ('M21' ,'M23' ,'M43' ,'M54' )
    NON	IP20 (Standard) DEFAULT if strFrequencyConverterDefaultIpProtectionLevel == "", IP20, IP00
    M21	IP21            DEFAULT if strFrequencyConverterDefaultIpProtectionLevel == IP21
    M23	IP23            DEFAULT if strFrequencyConverterDefaultIpProtectionLevel == IP22,23
    M43	IP43            DEFAULT if strFrequencyConverterDefaultIpProtectionLevel == IP41,42,43
    M54	IP54            DEFAULT if strFrequencyConverterDefaultIpProtectionLevel == IP54
    23STD	IP23 (Standard) DEFAULT if H_TRIGGER_IP_M66_S150 eq 'T'

  VT_S150_M00002	DB/PSM Schutzart
    n.n. PSM_SCHUTZART_S150	PSM Schutzart
    O_SCHUTZART_S150	Schutzart
    PMD_ABJ176_001_000_S150	Schutzart IP

  VT_S150_M00004	Derating Faktor  Schutzart+AH+KMT
    O_SCHUTZART_S150	Schutzart
    IN_AUSTELLHOEHE_S150	Aufstellhöhe
    IN_UMGEB_TEMP_S150	Umgebungstemperatur
    n.n. H_DERATING_FAKTOR_S150	Derating Faktor

  VT_S150_M00013	Optionen M13+Schutzart
    O_NETZANSCHLUSS_S150	Netzanschluss von oben
    O_SCHUTZART_S150	Schutzart

  VT_S150_M00014	Optionen M66+Schutzart
    O_SCHIFFSAUSFUEHRUNG_S150	Schiffsausführung
    O_SCHUTZART_S150	Schutzart

  VT_S150_M00018	Optionen M78+Schutzart
    O_MOTORANSCHLUSS_S150	Motoranschluss von oben
    O_SCHUTZART_S150	Schutzart

  VT_S150_M00024	Optionen M60+Schutzart
    HMK_MLFB10_13_S150	HMK MLFB10-13
    O_SCHUTZART_S150	Schutzart
    OHMK_BERUEHR_SCHUTZ_S150	(M60) /...hrungsschutz
    O_BERUEHR_SCHUTZ_S150	Zusätzlicher Berührungsschutz

  * VT_S150_M00002	DB/PSM Schutzart
  *  ignor: PSM_SCHUTZART_S150

  BZ_S150_00121	Einschränken Schutzart_M66
    OBJECTS:
      c is_a (300) skey  'S150'
    RESTRICTIONS:
      c.O_SCHUTZART_S150 in ('NON','M21','M23','M43','M54')
      if c.H_TRIGGER_IP_M66_S150 eq 'F' or
      c.O_SCHIFFSAUSFUEHRUNG_S150 eq 'NON',

      c.O_SCHUTZART_S150 in ('23STD','M43','M54')
      if c.H_TRIGGER_IP_M66_S150 eq 'T'
    INFERENCES:
    c.O_SCHUTZART_S150

  */
  // --------------------------------------------------------------------------------------------
  if (strFrequencyConverterDefaultIpProtectionLevel == "54") {
    // IP54 only  /* ??? strSeriesID == "32155" || */
    ECL_DeactivateAllAttributeValues(sDTKAttribute);
    ECL_ActivateValue(sDTKAttribute, "M54");
    ECL_SelectValue(sDTKAttribute, "M54");
  } else {

    // --------------------------------------------------------------------------------------------
    if (H_TRIGGER_IP_M66_S150 == "F" /*|| O_SCHIFFSAUSFUEHRUNG_S150 == "NON"*/) {
      var aValidValues = ["NON", "M21", "M23", "M43"];
      SetAttributeLogicFromCode(sDTKAttribute, aValidValues)
    } else if (H_TRIGGER_IP_M66_S150 == "T") {
      var aValidValues = ["23STD", "M43"];
      SetAttributeLogicFromCode(sDTKAttribute, aValidValues)
    }
  }
  // --------------------------------------------------------------------------------------------
  // VT_S150_M00004	Derating Faktor  Schutzart+AH+KMT
  //  O_SCHUTZART_S150	Schutzart      IN_AUSTELLHOEHE_S150	Aufstellhöhe      IN_UMGEB_TEMP_S150	Umgebungstemperatur
  var sTable = "VT_S150_M00004" + sDB_Suffix;
  var sWhere = "IN_AUSTELLHOEHE_S150 = '" + IN_AUSTELLHOEHE_S150 + "' AND " +
    "IN_UMGEB_TEMP_S150 = '" + IN_UMGEB_TEMP_S150 + "';";

  var sStatus = SetAttributeLogic2nd(sTable, sDTKAttribute, sWhere);

  if (sStatus == "Error") {
    strError = "DICT1_ERR_S150___PL_O_SCHUTZART";
    return strError;
  }
  var O_SCHUTZART_S150 = ECL_GetValue("O_SCHUTZART_S150");
  var O_SCHUTZART_S1501 = ECL_GetValue("O_SCHUTZART_S150");
  // strFrequencyConverterDefaultIpProtectionLevel 
  // --------------------------------------------------------------------------------------------
  // defaults: NON	IP20 (Standard) if strFrequencyConverterDefaultIpProtectionLevel == "", IP20, IP00

  // ################################################################################################################
  // ################################################################################################################

  // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  // Optionen 1	Optionen 1	Optionen 1	Optionen 1	Optionen 1	Optionen 1	Optionen 1	Optionen 1	Optionen 1
  // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

  // ################################################################################################################
  // O_UMGEBUNG_L00_S150	(L00) Einsatz in der ersten Umgebung nach EN 61800-3, Kategorie C2
  // ################################################################################################################
  /**var sDTKAttribute = "O_UMGEBUNG_L00_S150";
  var sCB_Attribute = "CB_" + sDTKAttribute; //var sCB_Attribute = "CB_O_UMGEBUNG_L00_S150";
  /**
   * KAG: NON, L00
   * CB: CB_O_UMGEBUNG_L00_S150
   */
  // ################################################################################################################

  // ################################################################################################################
  // O_UEBERSPGSBGZ_L21_S150	Überspannungsbegrenzung
  // ################################################################################################################
  /**var sDTKAttribute = "O_UEBERSPGSBGZ_L21_S150";
  var sCB_Attribute = "CB_" + sDTKAttribute;
  /**
   * KAG: STD, L21
   * CB: CB_O_UEBERSPGSBGZ_L21_S150
   */
  // ################################################################################################################

  // ################################################################################################################
  // O_HAUPTSCHALTER_S150	Hauptschalter inkl. Sicherungen bzw. Leistungsschalter
  // ################################################################################################################
  var sDTKAttribute = "O_HAUPTSCHALTER_S150";
  var sCB_Attribute = "CB_" + sDTKAttribute;
  /**
   * KAG: NON, L26
   * CB: CB_O_HAUPTSCHALTER_S150
   * 
   * VT_S150_M00037	Option_L26
      MLFB11_S150	          Segment Merkmal MLFB11_S150
      MLFB12_S150	          Segment Merkmal MLFB12_S150
      O_HAUPTSCHALTER_S150	Hauptschalter inkl. Sicherungen bzw. Leistungsschalter
   */
  var sTable = "VT_S150_M00037" + sDB_Suffix;
  var sWhere = "MLFB11_S150 = '" + MLFB11_S150 + "' AND " +
    "MLFB12_S150 = '" + MLFB12_S150 + "';";

  var sStatus = SetAttributeLogic_Checkbox(sTable, sDTKAttribute, sCB_Attribute, "L26", "NON", sWhere, false);

  if (sStatus == "Error") {
    strError = "DICT1_ERR_S150___PL_L26";
    return strError;
  }
  // ################################################################################################################

  // ################################################################################################################
  // O_AUSGANG_S150	Ausgangsseitige Optionen
  // ################################################################################################################
  /**var sDTKAttribute = "O_AUSGANG_S150";
  /**
   * KAG: NON, L07, L10, L08, L15
   * 
   * NON	ohne
   * L07	(L07) du/dt-Filter compact plus Voltage Peak Limiter
   * L10	(L10) du/dt-Filter plus Voltage Peak Limiter
   * L08	(L08) Motordrossel
   * L15	(L15) Sinusfilter
   * 
   * VT_S150_M00033	Optionen L07+L08+L10+L15+M78
   *   O_AUSGANG_S150	Ausgangsseitige Optionen
   *   O_MOTORANSCHLUSS_S150	Motoranschluss von oben
   */
  // ################################################################################################################

  // ################################################################################################################
  // O_EMV_SCHIRMSCHIENE_S150	(M70) EMV-Schirmschiene (Kabelanschluss von unten)
  // ################################################################################################################
  /**var sDTKAttribute = "O_EMV_SCHIRMSCHIENE_S150";
  var sCB_Attribute = "CB_" + sDTKAttribute; // CB_O_EMV_SCHIRMSCHIENE_S150";
  /**
   * KAG: STD, M70
   * CB: CB_O_EMV_SCHIRMSCHIENE_S150
   */

  // ################################################################################################################


  // ################################################################################################################
  //  O_TM150_S150	TM150 Temperatursensorauswerteeinheit
  // ################################################################################################################
  var sDTKAttribute = "O_TM150_S150";
  /**
   * KAG: NON, G51, G52, G53, G54
   * 
   * NON	keine
   * G51	(G51) 1x Stück
   * G52	(G52) 2x Stück
   * G53	(G53) 3x Stück
   * G54	(G54) 4x Stück
   * 
   * VT_S150_M00027	gültige Optionen L86/G51
   *  O_PT100_S150	Pt100-Auswertegerät
   *  O_TM150_S150	TM150 Temperatursensorauswerteeinheit
   */
  /* solution with retroactive restrictions of L86:
  var O_PT100_S150 = "NON";
  if (ECL_ValueSelected("CB_O_PT100_S150", "T")) {
    O_PT100_S150 = "L86";
  }

  var sTable = "VT_S150_M00027" + sDB_Suffix;
  var sWhere = "O_PT100_S150 = '" + O_PT100_S150 + "';";

  var sStatus = SetAttributeLogic1st(sTable, sDTKAttribute, sWhere);

  if (sStatus == "Error") {
    strError = "DICT1_ERR_S150___PL_O_TM150";
    return strError;
  }
  */
  // without retroactive restrictions of L86:
  var sTable = "VT_S150_M00027" + sDB_Suffix;
  var sSQL = "SELECT DISTINCT O_TM150_S150 FROM " + sTable + ";";

  var aResultO_TM150 = GetDBDataSetEXT(sSQL);
  ECL_DeactivateAllAttributeValues("O_TM150_S150");
  if (aResultO_TM150 && aResultO_TM150.length > 1) {
    for (var i = 0; i < aResultO_TM150.length; i++) {
      ECL_ActivateValue("O_TM150_S150", aResultO_TM150[i].O_TM150_S150);
    }
  } else {
    strError = "DICT1_ERR_S150___PL_O_TM150";
    return strError;
  }
  // ################################################################################################################


  // ################################################################################################################
  // O_NOT_AUS_HALT_S150	Not-Aus / Not-Halt
  // ################################################################################################################
  /**var sDTKAttribute = "O_NOT_AUS_HALT_S150";
  /**
   * KAG: NON, L57, L59, L60
   * 
   * NON	ohne
   * L57	(L57) NOT-AUS, Kategorie 0, unkontrollierter Stop
   * L59	(L59) NOT-HALT, Kategorie 1 AC 230 V
   * L60	(L60) NOT-HALT, Kategorie 1 DC 24 V
   */

  // ################################################################################################################


  // ################################################################################################################
  // O_NOT_AUS_TASTER_S150	NOT-AUS-Taster, eingebaut in der Schranktür
  // ################################################################################################################
  /**var sDTKAttribute = "O_NOT_AUS_TASTER_S150";
  var sCB_Attribute = "CB_" + sDTKAttribute; //CB_O_NOT_AUS_TASTER_S150";
  /**
   * KAG: NON, L45
   * CB: CB_O_NOT_AUS_TASTER_S150
   */
  // ################################################################################################################

  // ################################################################################################################
  // O_FILTERUEBERWAC_L40_S150	Filterüberwachung
  // ################################################################################################################
  /**var sDTKAttribute = "O_FILTERUEBERWAC_L40_S150";
  var sCB_Attribute = "CB_" + sDTKAttribute; //CB_O_FILTERUEBERWAC_L40_S150
  /**
   * KAG: NON, L40
   * CB: CB_O_FILTERUEBERWAC_L40_S150
  */
  // ################################################################################################################

  // ################################################################################################################
  // O_THERMISTOR_S150	Thermistor-Motorschutzgerät (Warnung)
  // ################################################################################################################
  /**var sDTKAttribute = "O_THERMISTOR_S150";
  var sCB_Attribute = "CB_" + sDTKAttribute; //CB_O_THERMISTOR_S150
  /**
   * KAG: NON, L83
   * CB: CB_O_THERMISTOR_S150
  */
  // ################################################################################################################

  // ################################################################################################################
  // O_THERMISTOR_L84_S150	Thermistor-Motorschutzgerät (Abschaltung)
  // ################################################################################################################
  /**var sDTKAttribute = "O_THERMISTOR_L84_S150";
  var sCB_Attribute = "CB_" + sDTKAttribute; //CB_O_THERMISTOR_L84_S150
  /**
   * KAG: NON, L84
   * CB:  CB_O_THERMISTOR_L84_S150
  */
  // ################################################################################################################

  // ################################################################################################################
  // O_PT100_S150	Pt100-Auswertegerät
  // ################################################################################################################
  var sDTKAttribute = "O_PT100_S150";
  var sCB_Attribute = "CB_" + sDTKAttribute;
  /**
   * KAG: NON, L86
   * CB: CB_O_PT100_S150
   * 
   * VT:
   * VT_S150_M00027	gültige Optionen L86/G51
   *  O_PT100_S150	Pt100-Auswertegerät
   *  O_TM150_S150	TM150 Temperatursensorauswerteeinheit
  */

  var O_TM150_S150 = ECL_GetValue("O_TM150_S150");

  var sTable = "VT_S150_M00027" + sDB_Suffix;
  var sWhere = "O_TM150_S150 = '" + O_TM150_S150 + "';";

  var sStatus = SetAttributeLogic_Checkbox(sTable, sDTKAttribute, sCB_Attribute, "L86", "NON", sWhere, false);

  if (sStatus == "Error") {
    strError = "DICT1_ERR_S150___PL_L86";
    return strError;
  }
  // ################################################################################################################


  // ################################################################################################################
  // O_ISOLAT_UEBERWACH_S150	Isolationsüberwachung
  // ################################################################################################################
  /**var sDTKAttribute = "O_ISOLAT_UEBERWACH_S150";
  var sCB_Attribute = "CB_" + sDTKAttribute;
  /**
   * KAG: NON, L87
   * CB: CB_O_ISOLAT_UEBERWACH_S150
  */
  // ################################################################################################################

  // ################################################################################################################
  // OHMK_BERUEHR_SCHUTZ_S150	(M60) Zusätzlicher Berührungsschutz Hilfsattribut UI
  // O_BERUEHR_SCHUTZ_S150	(M60) Zusätzlicher Berührungsschutz 
  // ################################################################################################################

  /**
   * OHMK_BERUEHR_SCHUTZ_S150:  CB_OHMK_BERUEHR_SCHUTZ_S150
   * KAG: NON, KAG
   * 
   * VT_S150_M00024	Optionen M60+Schutzart
   *  HMK_MLFB10_13_S150  O_SCHUTZART_S150  OHMK_BERUEHR_SCHUTZ_S150  O_BERUEHR_SCHUTZ_S150
   * VT_S150_M00025	Optionen M13+M60  <== not used at this time
   *  O_NETZANSCHLUSS_S150  OHMK_BERUEHR_SCHUTZ_S150  O_BERUEHR_SCHUTZ_S150 
   * 
   * O_BERUEHR_SCHUTZ_S150: CB_O_BERUEHR_SCHUTZ_S150  
   * KAG: NON, M60
   * VT:
   * VT_S150_M00012	Optionen M60+M66+M78
   *  O_BERUEHR_SCHUTZ_S150 O_SCHIFFSAUSFUEHRUNG_S150 O_MOTORANSCHLUSS_S150
   * VT_S150_M00024	Optionen M60+Schutzart
   * VT_S150_M00025	Optionen M13+M60
   * 
   * wenn VT 24 O_BERUEHR_SCHUTZ_S150 == M60 möglich, dann CB_O_BERUEHR_SCHUTZ_S150 visible
   * wenn VT 24 O_BERUEHR_SCHUTZ_S150 == NON und OHMK_BERUEHR_SCHUTZ_S150 == KAG möglich, dann OHMK_BERUEHR_SCHUTZ_S150 visible disabled and checked
   * sonst disabled and unchecked
   */
  var O_SCHUTZART_S150 = ECL_GetValue("O_SCHUTZART_S150");

  var sSQL = "SELECT * FROM VT_S150_M00024" + sDB_Suffix + " WHERE " +
    "HMK_MLFB10_13_S150 = '" + HMK_MLFB10_13_S150 + "' AND O_SCHUTZART_S150 = '" + O_SCHUTZART_S150 + "' AND " +
    "O_BERUEHR_SCHUTZ_S150 = 'M60';";
  var aResult = GetDBDataSetEXT(sSQL);
  if (aResult.length > 0) {
    ECL_ActivateAttribute("CB_O_BERUEHR_SCHUTZ_S150");
    ECL_DeactivateAttribute("CB_OHMK_BERUEHR_SCHUTZ_S150");
  } else {
    sSQL = "SELECT * FROM VT_S150_M00024" + sDB_Suffix + " WHERE " +
      "HMK_MLFB10_13_S150 = '" + HMK_MLFB10_13_S150 + "' AND O_SCHUTZART_S150 = '" + O_SCHUTZART_S150 + "' AND " +
      "O_BERUEHR_SCHUTZ_S150 = 'NON' AND OHMK_BERUEHR_SCHUTZ_S150 = 'KAG';";
    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length > 0) {
      ECL_DeselectAttribute("CB_O_BERUEHR_SCHUTZ_S150");
      ECL_DeactivateAttribute("CB_O_BERUEHR_SCHUTZ_S150");

      ECL_ActivateAttribute("CB_OHMK_BERUEHR_SCHUTZ_S150");
      ECL_SelectValue("CB_OHMK_BERUEHR_SCHUTZ_S150", "T");
      ECL_DisableAttribute("CB_OHMK_BERUEHR_SCHUTZ_S150");
    } else {
      ECL_DeselectAttribute("CB_O_BERUEHR_SCHUTZ_S150");
      ECL_DeactivateAttribute("CB_O_BERUEHR_SCHUTZ_S150");

      ECL_ActivateAttribute("CB_OHMK_BERUEHR_SCHUTZ_S150");
      ECL_DeselectAttribute("CB_OHMK_BERUEHR_SCHUTZ_S150");
      ECL_DisableAttribute("CB_OHMK_BERUEHR_SCHUTZ_S150");
    }
  }

  var sDTKAttribute = "O_BERUEHR_SCHUTZ_S150";
  var sCB_Attribute = "CB_" + sDTKAttribute;

  if (strchangedAttribute == sCB_Attribute) {
    if (ECL_ValueSelected(sCB_Attribute, "T")) {
      ECL_SelectValue("CB_OHMK_BERUEHR_SCHUTZ_S150", "T");
    }
  }
  /*
    // A VT_S150_M00024	Optionen M60+Schutzart
    //  HMK_MLFB10_13_S150  O_SCHUTZART_S150  OHMK_BERUEHR_SCHUTZ_S150  O_BERUEHR_SCHUTZ_S150
    var O_SCHUTZART_S150 = ECL_GetValue("O_SCHUTZART_S150");
    var O_SCHIFFSAUSFUEHRUNG_S150 = "NON";
    if (ECL_ValueSelected("H_TRIGGER_IP_M66_S150", "T")) {
      O_SCHIFFSAUSFUEHRUNG_S150 = "M66";
    }
    var sTable = "VT_S150_M00024" + sDB_Suffix;
    var sWhere = "HMK_MLFB10_13_S150 = '" + HMK_MLFB10_13_S150 + "' AND " +
      "O_SCHUTZART_S150 = '" + O_SCHUTZART_S150 + "';";
  
    var sStatus = SetAttributeLogic1st(sTable, sDTKAttribute, sWhere);
  
    if (sStatus == "Error") {
      strError = "DICT1_ERR_S150___PL_M60";
      return strError;
    }
    // --------------------------------------------------------------------------------------------
    var sTable = "VT_S150_M00012" + sDB_Suffix;
    var sWhere = "O_SCHIFFSAUSFUEHRUNG_S150 = '" + O_SCHIFFSAUSFUEHRUNG_S150 + "';";
    //"O_MOTORANSCHLUSS_S150 = '" + O_MOTORANSCHLUSS_S150 + "' AND " +
  
    var sStatus = SetAttributeLogic2nd(sTable, sDTKAttribute, sWhere);
  
    if (sStatus == "Error") {
      strError = "DICT1_ERR_S150___PL_M60";
      return strError;
    }
  */
  // ###############################################
  // OHMK_BERUEHR_SCHUTZ_S150	(M60) Zusätzlicher Berührungsschutz Hilfsattribut UI  CB_OHMK_BERUEHR_SCHUTZ_S150
  var sDTKAttribute = "OHMK_BERUEHR_SCHUTZ_S150";
  var sCB_Attribute = "CB_" + sDTKAttribute;
  /*
   * VT_S150_M00024	Optionen M60+Schutzart
   *  HMK_MLFB10_13_S150  O_SCHUTZART_S150  OHMK_BERUEHR_SCHUTZ_S150  O_BERUEHR_SCHUTZ_S150
   * VT_S150_M00025	Optionen M13+M60  <== not used at this time
   *  O_NETZANSCHLUSS_S150  OHMK_BERUEHR_SCHUTZ_S150  O_BERUEHR_SCHUTZ_S150 
   * /
  var aValidValues = ECL_GetAllActiveAttributeValues("O_BERUEHR_SCHUTZ_S150");
  var sValues = "'" + aValidValues.join("','") + "'";

  var sTable = "VT_S150_M00024" + sDB_Suffix;
  var sWhere = "HMK_MLFB10_13_S150 = '" + HMK_MLFB10_13_S150 + "' AND " +
    "O_SCHUTZART_S150 = '" + O_SCHUTZART_S150 + "' AND " +
    "O_BERUEHR_SCHUTZ_S150 IN (" + sValues + ");";

  var sStatus = SetAttributeLogic_Checkbox(sTable, sDTKAttribute, sCB_Attribute, "M60", "NON", sWhere, false);

  if (sStatus == "Error") {
    strError = "DICT1_ERR_S150___PL_M60";
    return strError;
  }*/
  // ################################################################################################################


  // ################################################################################################################
  // O_SOCKEL_100MM_S150	(M06) Sockel 100 mm hoch, RAL 7022      CB_O_SOCKEL_100MM_S150
  // ################################################################################################################
  /**var sDTKAttribute = "O_SOCKEL_100MM_S150";
  var sCB_Attribute = "CB_" + sDTKAttribute;
  /**
   * KAG: NON, M06
   * CB: CB_O_SOCKEL_100MM_S150
   * 
   * VT_S150_M00009	Optionen M06+M07
   *  O_SOCKEL_100MM_S150   O_KABELRANGIERRAUM_S150
  */
  // ################################################################################################################


  // ################################################################################################################
  // O_KABELRANGIERRAUM_S150	(M07) Kabelrangierraum 200 mm hoch, RAL 7035
  // ################################################################################################################
  var sDTKAttribute = "O_KABELRANGIERRAUM_S150";
  var sCB_Attribute = "CB_" + sDTKAttribute;
  /**
   * KAG: NON, M07
   * CB: CB_O_KABELRANGIERRAUM_S150
   *
   * VT_S150_M00009	Optionen M06+M07
   *  O_SOCKEL_100MM_S150   O_KABELRANGIERRAUM_S150
   */
  var O_SOCKEL_100MM_S150 = "NON";
  if (ECL_ValueSelected("CB_O_SOCKEL_100MM_S150", "T")) {
    O_SOCKEL_100MM_S150 = "M06";
  }

  var sTable = "VT_S150_M00009" + sDB_Suffix;
  var sWhere = "O_SOCKEL_100MM_S150 = '" + O_SOCKEL_100MM_S150 + "';";

  var sStatus = SetAttributeLogic_Checkbox(sTable, sDTKAttribute, sCB_Attribute, "M07", "NON", sWhere, false);

  if (sStatus == "Error") {
    strError = "DICT1_ERR_S150___PL_M07";
    return strError;
  }

  // ################################################################################################################

  // ################################################################################################################
  // O_NETZANSCHLUSS_S150	(M13) Netzanschluss von oben
  // ################################################################################################################
  var sDTKAttribute = "O_NETZANSCHLUSS_S150";
  var sCB_Attribute = "CB_" + sDTKAttribute;
  /**
   * KAG: NON, M13
   * CB: CB_O_NETZANSCHLUSS_S150
   * 
   * VT_S150_M00013	Optionen M13+Schutzart
   *  O_NETZANSCHLUSS_S150 O_SCHUTZART_S150
   * VT_S150_M00025	Optionen M13+M60
   *  O_NETZANSCHLUSS_S150 OHMK_BERUEHR_SCHUTZ_S150  O_BERUEHR_SCHUTZ_S150
  */
  var O_SCHUTZART_S150 = ECL_GetValue("O_SCHUTZART_S150");

  var sTable = "VT_S150_M00013" + sDB_Suffix;
  var sWhere = "O_SCHUTZART_S150 = '" + O_SCHUTZART_S150 + "';";

  var sStatus = SetAttributeLogic_Checkbox(sTable, sDTKAttribute, sCB_Attribute, "M13", "NON", sWhere, false);

  if (sStatus == "Error") {
    strError = "DICT1_ERR_S150___PL_M13";
    return strError;
  }
  // ----------------------------------------------------------------------------------------------------------------
  var OHMK_BERUEHR_SCHUTZ_S150 = "NON";
  if (ECL_ValueSelected("CB_OHMK_BERUEHR_SCHUTZ_S150", "T")) {
    OHMK_BERUEHR_SCHUTZ_S150 = "KAG";
  }
  var O_BERUEHR_SCHUTZ_S150 = "NON";
  if (ECL_ValueSelected("CB_O_BERUEHR_SCHUTZ_S150", "T")) {
    O_BERUEHR_SCHUTZ_S150 = "M60";
    OHMK_BERUEHR_SCHUTZ_S150 = "KAG";
  }
  var sTable = "VT_S150_M00025" + sDB_Suffix;
  var sWhere = "OHMK_BERUEHR_SCHUTZ_S150 = '" + OHMK_BERUEHR_SCHUTZ_S150 + "' AND " + // to check 
    "O_BERUEHR_SCHUTZ_S150 = '" + O_BERUEHR_SCHUTZ_S150 + "';";

  var sStatus = SetAttributeLogic_Checkbox(sTable, sDTKAttribute, sCB_Attribute, "M13", "NON", sWhere, true);

  if (sStatus == "Error") {
    strError = "DICT1_ERR_S150___PL_M13";
    return strError;
  }
  // ################################################################################################################


  // ################################################################################################################
  // O_KOMFORTGRIFF_M61_S150	(M61) Komfortgriff mit Verschlusseinsatz 3 mm Doppelbart		STD, M61
  // ################################################################################################################
  var sDTKAttribute = "O_KOMFORTGRIFF_M61_S150";
  var sCB_Attribute = "CB_" + sDTKAttribute;
  /** VT_S150_M00045	Option M61;M62;M63
   *    O_KOMFORTGRIFF_M61_S150  O_KOMFORTGRIFF_M62_S150 O_KOMFORTGRIFF_M63_S150 
   */
  var O_KOMFORTGRIFF_M62_S150 = "STD";
  if (ECL_ValueSelected("CB_O_KOMFORTGRIFF_M62_S150", "T")) {
    var O_KOMFORTGRIFF_M62_S150 = "M62";
  }
  var O_KOMFORTGRIFF_M63_S150 = "STD";
  if (ECL_ValueSelected("CB_O_KOMFORTGRIFF_M63_S150", "T")) {
    var O_KOMFORTGRIFF_M63_S150 = "M63";
  }
  var sTable = "VT_S150_M00045" + sDB_Suffix;
  var sWhere = "O_KOMFORTGRIFF_M62_S150 = '" + O_KOMFORTGRIFF_M62_S150 + "' AND " + "O_KOMFORTGRIFF_M63_S150 = '" + O_KOMFORTGRIFF_M63_S150 + "';";

  var sStatus = SetAttributeLogic_Checkbox(sTable, sDTKAttribute, sCB_Attribute, "M61", "STD", sWhere, false);

  if (sStatus == "Error") {
    strError = "DICT1_ERR_S150___PL_M61";
    return strError;
  }

  // ################################################################################################################

  // ################################################################################################################
  // O_KOMFORTGRIFF_M62_S150	(M62) Komfortgriff mit Verschlusseinsatz Druckknopf		STD, M62
  // ################################################################################################################
  var sDTKAttribute = "O_KOMFORTGRIFF_M62_S150";
  var sCB_Attribute = "CB_" + sDTKAttribute;
  /** VT_S150_M00045	Option M61;M62;M63
   *    O_KOMFORTGRIFF_M61_S150  O_KOMFORTGRIFF_M62_S150 O_KOMFORTGRIFF_M63_S150 
   */
  var O_KOMFORTGRIFF_M61_S150 = "STD";
  if (ECL_ValueSelected("CB_O_KOMFORTGRIFF_M61_S150", "T")) {
    var O_KOMFORTGRIFF_M61_S150 = "M61";
  }
  var O_KOMFORTGRIFF_M63_S150 = "STD";
  if (ECL_ValueSelected("CB_O_KOMFORTGRIFF_M63_S150", "T")) {
    var O_KOMFORTGRIFF_M63_S150 = "M63";
  }
  var sTable = "VT_S150_M00045" + sDB_Suffix;
  var sWhere = "O_KOMFORTGRIFF_M61_S150 = '" + O_KOMFORTGRIFF_M61_S150 + "' AND " + "O_KOMFORTGRIFF_M63_S150 = '" + O_KOMFORTGRIFF_M63_S150 + "';";

  var sStatus = SetAttributeLogic_Checkbox(sTable, sDTKAttribute, sCB_Attribute, "M62", "STD", sWhere, false);

  if (sStatus == "Error") {
    strError = "DICT1_ERR_S150___PL_M62";
    return strError;
  }

  // ################################################################################################################

  // ################################################################################################################
  // O_KOMFORTGRIFF_M63_S150	(M63) Komfortgriff für ein Vorhängeschloss mit Druckknopf als Verschlusseinsatz 	STD, M63
  // ################################################################################################################
  var sDTKAttribute = "O_KOMFORTGRIFF_M63_S150";
  var sCB_Attribute = "CB_" + sDTKAttribute;
  /** VT_S150_M00045	Option M61;M62;M63
    *    O_KOMFORTGRIFF_M61_S150  O_KOMFORTGRIFF_M62_S150 O_KOMFORTGRIFF_M63_S150 
    */
  var O_KOMFORTGRIFF_M61_S150 = "STD";
  if (ECL_ValueSelected("CB_O_KOMFORTGRIFF_M61_S150", "T")) {
    var O_KOMFORTGRIFF_M61_S150 = "M61";
  }
  var O_KOMFORTGRIFF_M62_S150 = "STD";
  if (ECL_ValueSelected("CB_O_KOMFORTGRIFF_M62_S150", "T")) {
    var O_KOMFORTGRIFF_M62_S150 = "M62";
  }

  var sTable = "VT_S150_M00045" + sDB_Suffix;
  var sWhere = "O_KOMFORTGRIFF_M61_S150 = '" + O_KOMFORTGRIFF_M61_S150 + "' AND " + "O_KOMFORTGRIFF_M62_S150 = '" + O_KOMFORTGRIFF_M62_S150 + "';";

  var sStatus = SetAttributeLogic_Checkbox(sTable, sDTKAttribute, sCB_Attribute, "M63", "STD", sWhere, false);

  if (sStatus == "Error") {
    strError = "DICT1_ERR_S150___PL_M63";
    return strError;
  }

  // ################################################################################################################



  // ################################################################################################################
  // O_MOTORANSCHLUSS_S150	(M78) Motoranschluss von oben
  // ################################################################################################################
  var sDTKAttribute = "O_MOTORANSCHLUSS_S150";
  var sCB_Attribute = "CB_" + sDTKAttribute;
  /**
   * KAG: NON, M78
   * CB: CB_O_MOTORANSCHLUSS_S150
   * 
   * VT_S150_M00012	Optionen M60+M66+M78
   *  O_BERUEHR_SCHUTZ_S150  O_SCHIFFSAUSFUEHRUNG_S150 O_MOTORANSCHLUSS_S150
   * VT_S150_M00018	Optionen M78+Schutzart
   *  O_MOTORANSCHLUSS_S150 O_SCHUTZART_S150
   * VT_S150_M00033	Optionen L07+L08+L10+L15+M78
   *  O_AUSGANG_S150  O_MOTORANSCHLUSS_S150
  */
  var O_SCHUTZART_S150 = ECL_GetValue("O_SCHUTZART_S150");
  var O_SCHIFFSAUSFUEHRUNG_S150 = "NON";
  if (ECL_ValueSelected("H_TRIGGER_IP_M66_S150", "T")) {
    O_SCHIFFSAUSFUEHRUNG_S150 = "M66";
  }

  var sTable = "VT_S150_M00018" + sDB_Suffix;
  var sWhere = "O_SCHUTZART_S150 = '" + O_SCHUTZART_S150 + "';";

  var sStatus = SetAttributeLogic_Checkbox(sTable, sDTKAttribute, sCB_Attribute, "M78", "NON", sWhere, false);

  if (sStatus == "Error") {
    strError = "DICT1_ERR_S150___PL_M78";
    return strError;
  }
  // ----------------------------------------------------------------------------------------------------------------
  var sTable = "VT_S150_M00012" + sDB_Suffix;
  var sWhere = "O_BERUEHR_SCHUTZ_S150 = '" + O_BERUEHR_SCHUTZ_S150 + "' AND " +
    "O_SCHIFFSAUSFUEHRUNG_S150 = '" + O_SCHIFFSAUSFUEHRUNG_S150 + "';";

  var sStatus = SetAttributeLogic_Checkbox(sTable, sDTKAttribute, sCB_Attribute, "M78", "NON", sWhere, true);

  if (sStatus == "Error") {
    strError = "DICT1_ERR_S150___PL_M78";
    return strError;
  }
  // ################################################################################################################


  // ################################################################################################################
  // O_KRANTRANSPORTHILFE_S150	(M90) Krantransporthilfe für Schränke (oben montiert)
  // ################################################################################################################
  /**var sDTKAttribute = "O_KRANTRANSPORTHILFE_S150";
  var sCB_Attribute = "CB_" + sDTKAttribute;
  /**
   * KAG: NON, M90
   * CB: CB_O_KRANTRANSPORTHILFE_S150 
  */
  // ################################################################################################################

  // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  // Optionen 2	Optionen 2	Optionen 2	Optionen 2	Optionen 2	Optionen 2	Optionen 2	Optionen 2	Optionen 2
  // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

  // ################################################################################################################
  // O_MODULE_S150	Module Cabinet-Mounted
  // ################################################################################################################
  /**var sDTKAttribute = "O_MODULE_S150";

  /**
   * KAG: NON, K46, K48, K50, K51
   * 
   * VT_S150_M00041	Opt K46, K48, K50, K51<-->Opt K52
   *  O_MODULE_S150 O_K52_S150
   * 
   * DICT1_ERR_S150___PL_O_MODULE
  */
  // ################################################################################################################


  // ################################################################################################################
  // O_COMMUNICATIONBOARD_S150	Communication Board
  // ################################################################################################################
  /**var sDTKAttribute = "O_COMMUNICATIONBOARD_S150";

  /**
   * KAG: NON, G20, G33
   * 
   * VT:
   * 	VT_S150_M00042	Options G62 <--> G20, G33
   *   O_COMMUNICATIONBOARD_S150  O_TERMINAL_BOARD_S150
  */
  /* var O_TERMINAL_BOARD_S150 = "NON";
   if (ECL_ValueSelected("CB_O_TERMINAL_BOARD_S150", "T")) {
     var O_TERMINAL_BOARD_S150 = "G62";
   }
 
   var sTable = "VT_S150_M00080" + sDB_Suffix;
   var sWhere = "O_TERMINAL_BOARD_S150 = '" + O_TERMINAL_BOARD_S150 + "';";
 
   var sStatus = SetAttributeLogic1st(sTable, sDTKAttribute, sWhere);
 
   if (sStatus == "Error") {
     strError = "DICT1_ERR_S150___PL_O_COMMUNICATION";
     return strError;
   }*/
  // ################################################################################################################



  // ################################################################################################################
  // O_BREMSEINHEIT_S150	Bremseinheit  NON, L61, L62, L64, L65
  // ################################################################################################################
  var sDTKAttribute = "O_BREMSEINHEIT_S150";

  /**
   * KAG: NON, L61, L62, L64, L65
   * 
   * VT:
   * 	VT_S150_M00026	Optionen L61-L65
   * 		IN_SPANNUNG_S150  HMK_MLFB10_13_S150  O_BREMSEINHEIT_S150
  */

  var sTable = "VT_S150_M00026" + sDB_Suffix;
  var sWhere = "IN_SPANNUNG_S150 = '" + IN_SPANNUNG_S150 + "' AND " +
    "HMK_MLFB10_13_S150 = '" + HMK_MLFB10_13_S150 + "';";

  var sStatus = SetAttributeLogic1st(sTable, sDTKAttribute, sWhere);

  if (sStatus == "Error") {
    strError = "DICT1_ERR_S150___PL_O_BREMSEINHEIT";
    return strError;
  }
  // ################################################################################################################

  // ################################################################################################################
  // O_GEWAEHR_S150	Gewährleistungsverlängerung			NON, Q80, Q81, Q82, Q83, Q84, Q85
  // ################################################################################################################
  /**var sDTKAttribute = "O_GEWAEHR_S150";

  /**
   * KAG: NON, Q80, Q81, Q82, Q83, Q84, Q85
   *
   * VT:
   * 	keine
   */

  // ################################################################################################################


  // ################################################################################################################
  // O_BESCHRIFTUNGSSCHIL_S150	Beschriftungsschild zur AnlagenkennzeichnungNON, Y31, Y32, Y33
  // ################################################################################################################
  /**var sDTKAttribute = "O_BESCHRIFTUNGSSCHIL_S150";

  /**
   * KAG: NON, Y31, Y32, Y33
   *
   * VT:
   * 	keine
   */

  // ################################################################################################################

  // ################################################################################################################
  // O_KUND_KL_LEISTE_S150	(G60) Kundenklemmleiste TM31			STD, G60
  // ################################################################################################################
  /**var sDTKAttribute = "O_KUND_KL_LEISTE_S150";
  var sCB_Attribute = "CB_" + sDTKAttribute;
  /**
   * KAG: NON, G60
   * CB: CB_O_KUND_KL_LEISTE_S150
   * 
   * VT:
   * 	VT_S150_M00017	Optionen G60+G61
   *    O_KUND_KL_LEISTE_S150 O_ZUS_KUND_KL_LEISTE_S150
  */

  // ################################################################################################################

  // ################################################################################################################
  // O_ZUS_KUND_KL_LEISTE_S150	(G61) zusätzliche Kundenklemmleiste TM31  STD, G61
  // ################################################################################################################
  var sDTKAttribute = "O_ZUS_KUND_KL_LEISTE_S150";
  var sCB_Attribute = "CB_" + sDTKAttribute;
  /**
   * KAG: NON, G61
   * CB: CB_O_ZUS_KUND_KL_LEISTE_S150
   * 
   * VT:
   * 	VT_S150_M00017	Optionen G60+G61
   *    O_KUND_KL_LEISTE_S150 O_ZUS_KUND_KL_LEISTE_S150
  */
  // --------------------------------------------------------------------------------------------
  var O_KUND_KL_LEISTE_S150 = "NON";
  if (ECL_ValueSelected("CB_O_KUND_KL_LEISTE_S150", "T")) {
    var O_KUND_KL_LEISTE_S150 = "G60";
  }

  var sTable = "VT_S150_M00017" + sDB_Suffix;
  var sWhere = "O_KUND_KL_LEISTE_S150 = '" + O_KUND_KL_LEISTE_S150 + "';";

  var sStatus = SetAttributeLogic_Checkbox(sTable, sDTKAttribute, sCB_Attribute, "G61", "NON", sWhere, false);

  if (sStatus == "Error") {
    strError = "DICT1_ERR_S150___PL_G61";
    return strError;
  }
  // ################################################################################################################

  // ################################################################################################################
  // O_TERMINAL_BOARD_S150	(G62) Terminal Board TB30  F, G62
  // ################################################################################################################
  var sDTKAttribute = "O_TERMINAL_BOARD_S150";
  var sCB_Attribute = "CB_" + sDTKAttribute;
  /**
   * KAG: F, G62
   * CB: CB_O_TERMINAL_BOARD_S150
   *
   * VT:
   * 	VT_S150_M00042	Options G62 <--> G20, G33
   *   O_COMMUNICATIONBOARD_S150  O_TERMINAL_BOARD_S150
   */
  var O_COMMUNICATIONBOARD_S150 = ECL_GetValue("O_COMMUNICATIONBOARD_S150");

  var sTable = "VT_S150_M00042" + sDB_Suffix;
  var sWhere = "O_COMMUNICATIONBOARD_S150 = '" + O_COMMUNICATIONBOARD_S150 + "';";

  var sStatus = SetAttributeLogic_Checkbox(sTable, sDTKAttribute, sCB_Attribute, "G62", "F", sWhere, false);

  if (sStatus == "Error") {
    strError = "DICT1_ERR_S150___PL_O_TERMINAL_BOARD";
    return strError;
  }
  // ################################################################################################################



  // ################################################################################################################
  // O_K52_S150	(K52) Zusätzliches Sensor Module Cabinet-Mounted SMC30		F, K52
  // ################################################################################################################
  var sDTKAttribute = "O_K52_S150";
  var sCB_Attribute = "CB_" + sDTKAttribute;
  /**
   * KAG: F, K52
   * CB: CB_O_K52_S150
   * 
   * VT_S150_M00040	Option K01<--> Option K52
   *   O_SAFETY_LIZENZ_S150  O_K52_S150
   * VT_S150_M00041	Opt K46, K48, K50, K51<-->Opt K52
   *  O_MODULE_S150 O_K52_S150
  */
  // --------------------------------------------------------------------------------------------
  /* do not determine K52 during K01, but K01 is mandatory if K52 is selected
  var O_SAFETY_LIZENZ_S150 = "NON";
  if (ECL_ValueSelected("CB_O_SAFETY_LIZENZ_S150", "T")) {
    O_SAFETY_LIZENZ_S150 = "K01";
  }
  var sTable = "VT_S150_M00040" + sDB_Suffix;
  var sWhere = "O_SAFETY_LIZENZ_S150 = '" + O_SAFETY_LIZENZ_S150 + "';";

  var sStatus = SetAttributeLogic_Checkbox(sTable, sDTKAttribute, sCB_Attribute, "K52", "F", sWhere, false);

  if (sStatus == "Error") {
    strError = "DICT1_ERR_S150___PL_K52";
    return strError;
  }*/

  // --------------------------------------------------------------------------------------------
  // VT_S150_M00041	Opt K46, K48, K50, K51<-->Opt K52
  //  O_MODULE_S150 O_K52_S150

  var O_MODULE_S150 = ECL_GetValue("O_MODULE_S150");

  var sTable = "VT_S150_M00041" + sDB_Suffix;
  var sWhere = "O_MODULE_S150 = '" + O_MODULE_S150 + "';";

  var sStatus = SetAttributeLogic_Checkbox(sTable, sDTKAttribute, sCB_Attribute, "K52", "F", sWhere, true);

  if (sStatus == "Error") {
    strError = "DICT1_ERR_S150___PL_K52";
    return strError;
  }
  // ################################################################################################################

  // ################################################################################################################
  // O_SAFETY_LIZENZ_S150	(K01) Safety-Lizenz für eine Achse	NON, K01
  // ################################################################################################################
  var sDTKAttribute = "O_SAFETY_LIZENZ_S150";
  var sCB_Attribute = "CB_" + sDTKAttribute;
  /**
   * KAG: NON, K01
   * CB: CB_O_SAFETY_LIZENZ_S150
   * 
   * VT:
   * VT_S150_M00040	Option K01<--> Option K52
   *   O_SAFETY_LIZENZ_S150  O_K52_S150
  */
  var O_K52_S150 = "F";
  if (ECL_ValueSelected("CB_O_K52_S150", "T")) {
    O_K52_S150 = "K52";
  }
  // --------------------------------------------------------------------------------------------
  // A VT_S150_M00125	ZO Design - Safety
  // 		IN_AUSFUEHRUNG_S150		O_SAFETY_LIZENZ_K01__S150
  var sTable = "VT_S150_M00040" + sDB_Suffix;
  var sWhere = "O_K52_S150 = '" + O_K52_S150 + "';";

  var sStatus = SetAttributeLogic_Checkbox(sTable, sDTKAttribute, sCB_Attribute, "K01", "NON", sWhere, false);

  if (sStatus == "Error") {
    strError = "DICT1_ERR_S150___PL_K01";
    return strError;
  }

  // ################################################################################################################


  // ################################################################################################################
  // O_KLEMMENMODUL_S150	(K82) Klemmenmodul zur Ansteuerung der Sicherheitsfunktionen "Safe Torque Off" und "Safe Stop 1"		NON, K82
  // ################################################################################################################
  var sDTKAttribute = "O_KLEMMENMODUL_S150";
  var sCB_Attribute = "CB_" + sDTKAttribute;
  /**
   * KAG: NON, K82
   * CB: CB_O_KLEMMENMODUL_S150
   * 
  */

  // ################################################################################################################

  // ################################################################################################################
  // O_TM54F_S150	(K87) Terminal Module TM54F  NON, K87
  // ################################################################################################################
  var sDTKAttribute = "O_TM54F_S150";
  var sCB_Attribute = "CB_" + sDTKAttribute;
  /**
   * KAG: NON, K87
   * CB: CB_O_TM54F_S150
   * 
  */
  // ################################################################################################################

  // ################################################################################################################
  // O_SAFETY_SBA_K88_S150	(K88) Safe Brake Adapter SBA AC 230 V				F, K88
  // ################################################################################################################
  var sDTKAttribute = "O_SAFETY_SBA_K88_S150";
  var sCB_Attribute = "CB_" + sDTKAttribute;
  /**
   * KAG: F, K88
   * CB: CB_O_SAFETY_SBA_K88_S150
   * 
  */
  // ################################################################################################################

  // ################################################################################################################
  // O_CU3202_S150	(K95) Control Unit CU320-2 PN (PROFINET, EtherNet/IP)		NON, K95
  // ################################################################################################################
  var sDTKAttribute = "O_CU3202_S150";
  var sCB_Attribute = "CB_" + sDTKAttribute;
  /**
   * KAG: NON, K95
   * CB: CB_O_CU3202_S150
   * 
  */
  // ################################################################################################################

  // ################################################################################################################
  // O_HILFSBETRIEBE_S150	(L19) Anschluss für ext. Hilfsbetriebe			NON, L19
  // ################################################################################################################
  var sDTKAttribute = "O_HILFSBETRIEBE_S150";
  var sCB_Attribute = "CB_" + sDTKAttribute;
  /**
   * KAG: NON, L19
   * CB: CB_O_HILFSBETRIEBE_S150
   * 
  */
  // ################################################################################################################

  // ################################################################################################################
  // O_SCHRANKBELEUCHTUNG_S150	(L50) Schrankbeleuchtung mit Service-Steckdose		NON, L50
  // ################################################################################################################
  var sDTKAttribute = "O_SCHRANKBELEUCHTUNG_S150";
  var sCB_Attribute = "CB_" + sDTKAttribute;
  /**
   * KAG: NON, L50
   * CB: CB_O_SCHRANKBELEUCHTUNG_S150
   * 
  */

  // ################################################################################################################

  // ################################################################################################################
  // O_STILLSTANDSHEIZUNG_S150	(L55) Schrank Stillstandsheizung  NON, L55
  // ################################################################################################################
  var sDTKAttribute = "O_STILLSTANDSHEIZUNG_S150";
  var sCB_Attribute = "CB_" + sDTKAttribute;
  /**
   * KAG: NON, L55
   * CB: CB_O_STILLSTANDSHEIZUNG_S150
   * 
   * VT_S150_M00016	Optionen M66+L55
   *   O_SCHIFFSAUSFUEHRUNG_S150  O_STILLSTANDSHEIZUNG_S150
  */
  var O_SCHIFFSAUSFUEHRUNG_S150 = "NON";
  if (ECL_ValueSelected("H_TRIGGER_IP_M66_S150", "T")) {
    O_SCHIFFSAUSFUEHRUNG_S150 = "M66";
  }

  var sTable = "VT_S150_M00016" + sDB_Suffix;
  var sWhere = "O_SCHIFFSAUSFUEHRUNG_S150 = '" + O_SCHIFFSAUSFUEHRUNG_S150 + "';";

  var sStatus = SetAttributeLogic_Checkbox(sTable, sDTKAttribute, sCB_Attribute, "L55", "NON", sWhere, false);

  if (sStatus == "Error") {
    strError = "DICT1_ERR_S150___PL_L55";
    return strError;
  }
  // ################################################################################################################

  // ################################################################################################################
  // O_ADEREND_M91_S150	(M91) Vollständige Aderendmarkierung der Steuerleitungen	F, M91
  // ################################################################################################################
  var sDTKAttribute = "O_ADEREND_M91_S150";
  var sCB_Attribute = "CB_" + sDTKAttribute;
  /**
   * KAG: F, M91
   * CB: CB_O_ADEREND_M91_S150
   *
   */
  // ################################################################################################################

  // ################################################################################################################
  // O_SONDERLACKIERUNG_S150	(Y09) Schrank-Sonderlackierung  NON, Y09
  //	O_FARBE_S150	(Y09) Schrank-Sonderlackierung - RAL Farbe:
  // ################################################################################################################
  var sDTKAttribute = "O_SONDERLACKIERUNG_S150";

  /**
   * KAG: NON, Y09
   */

  if (ECL_ValueEnabled("O_SONDERLACKIERUNG_S150", "Y09")) {
    ECL_ActivateAttribute("O_FARBE_S150");
  } else {
    ECL_DeactivateAttribute("O_FARBE_S150");
  }

  if (strchangedAttribute == "O_FARBE_S150") {
    var sValueNorm = normalizeOE_Attribute("O_FARBE_S150");
    if (sValueNorm == "") {
      ECL_SelectValue("O_SONDERLACKIERUNG_S150", "NON");
    } else {
      ECL_SelectValue("O_SONDERLACKIERUNG_S150", "Y09");
    }
  }
  // ################################################################################################################


  // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  // Fertigungsablaufpläne
  // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

  // ################################################################################################################
  // O_FLOWCHARTS_S150	Dokument Fertigungsablaufplan			NON, B43, B44, B45
  // ################################################################################################################
  var sDTKAttribute = "O_FLOWCHARTS_S150";
  /**
   * KAG: NON, B43, B44, B45
   */

  // ################################################################################################################

  // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  // Verpackungsoptionen
  // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

  // ################################################################################################################
  // O_PACKING_LIST_B55_S150	(B55) Erstellung einer vorläufigen und einer finalen Packliste (Versand)
  // ################################################################################################################
  var sDTKAttribute = "O_PACKING_LIST_B55_S150";
  var sCB_Attribute = "CB_" + sDTKAttribute;
  /**
   * KAG: F, B55
   * CB: CB_O_PACKING_LIST_B55_S150
   *
   */
  // ################################################################################################################

  // ################################################################################################################
  // O_LABEL_PACKAGE_B56_S150	(B56) Etikettierung der Packstücke mit kundenspezifischem Label
  // ################################################################################################################
  var sDTKAttribute = "O_LABEL_PACKAGE_B56_S150";
  var sCB_Attribute = "CB_" + sDTKAttribute;
  /**
   * KAG: F, B56
   * CB: CB_O_LABEL_PACKAGE_B56_S150
   */
  // ################################################################################################################

  // ################################################################################################################
  // O_PHOTO_DOCU_B57_S150	(B57) Foto-Dokumentation der bestellten Einheiten
  // ################################################################################################################
  var sDTKAttribute = "O_PHOTO_DOCU_B57_S150";
  var sCB_Attribute = "CB_" + sDTKAttribute;
  /**
   * KAG: F, B57
   * CB: CB_O_PHOTO_DOCU_B57_S150
   */
  // ################################################################################################################


  // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  // Branchenspezifische Optionen Chemie
  // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

  // ################################################################################################################
  // O_NAMUR_B00_S150	(B00) Namur Klemmenleiste  NON, B00
  // ################################################################################################################
  /**var sDTKAttribute = "O_NAMUR_B00_S150";
  var sCB_Attribute = "CB_" + sDTKAttribute;
  /**
   * KAG: NON, B00
   * CB: CB_O_NAMUR_B00_S150
   * 
   * 	VT_S150_M00047	Optionen B00+B02+B03
   *    O_NAMUR_B00_S150  O_PELV_B02_S150 O_FREMDABGANG_S150
  */
  // ################################################################################################################

  // ################################################################################################################
  // O_PELV_B02_S150	(B02) Sicher getrennte 24-V-Versorgung (PELV)			NON, B02
  // ################################################################################################################
  var sDTKAttribute = "O_PELV_B02_S150";
  var sCB_Attribute = "CB_" + sDTKAttribute;
  /**
   * KAG: NON, B02
   * CB: CB_O_PELV_B02_S150
   * 
   * 	VT_S150_M00047	Optionen B00+B02+B03
   *    O_NAMUR_B00_S150  O_PELV_B02_S150 O_FREMDABGANG_S150
  */
  var O_NAMUR_B00_S150 = "NON";
  if (ECL_ValueSelected("CB_O_NAMUR_B00_S150", "T")) {
    O_NAMUR_B00_S150 = "B00";
  }

  var sTable = "VT_S150_M00047" + sDB_Suffix;
  var sWhere = "O_NAMUR_B00_S150 = '" + O_NAMUR_B00_S150 + "';";

  var sStatus = SetAttributeLogic_Checkbox(sTable, sDTKAttribute, sCB_Attribute, "B02", "NON", sWhere, false);

  if (sStatus == "Error") {
    strError = "DICT1_ERR_S150___PL_B02";
    return strError;
  }
  // ################################################################################################################

  // ################################################################################################################
  // O_FREMDABGANG_S150	(B03) Fremdabgang externe Hilfsbetriebe (ungesteuert)		NON, B03
  // ################################################################################################################
  var sDTKAttribute = "O_FREMDABGANG_S150";
  var sCB_Attribute = "CB_" + sDTKAttribute;
  /**
   * KAG: NON, B03
   * CB: CB_O_FREMDABGANG_S150
   * 
   * VT_S150_M00047	Optionen B00+B02+B03
   *    O_NAMUR_B00_S150  O_PELV_B02_S150 O_FREMDABGANG_S150
  */
  var O_NAMUR_B00_S150 = "NON";
  if (ECL_ValueSelected("CB_O_NAMUR_B00_S150", "T")) {
    var O_NAMUR_B00_S150 = "B00";
  }
  var O_PELV_B02_S150 = "NON";
  if (ECL_ValueSelected("CB_O_PELV_B02_S150", "T")) {
    var O_PELV_B02_S150 = "B02";
  }

  var sTable = "VT_S150_M00047" + sDB_Suffix;
  var sWhere = "O_NAMUR_B00_S150 = '" + O_NAMUR_B00_S150 + "' AND " +
    "O_PELV_B02_S150 = '" + O_PELV_B02_S150 + "';";

  var sStatus = SetAttributeLogic_Checkbox(sTable, sDTKAttribute, sCB_Attribute, "B03", "NON", sWhere, false);

  if (sStatus == "Error") {
    strError = "DICT1_ERR_S150___PL_B03";
    return strError;
  }
  // ################################################################################################################

  // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  // Branchenspezifische Optionen Schiffbau
  // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

  // ################################################################################################################
  // O_SCHIFFSAUSFUEHRUNG_S150	(M66) Schiffsausführung  NON, M66
  // ################################################################################################################
  var sDTKAttribute = "O_SCHIFFSAUSFUEHRUNG_S150";
  var sCB_Attribute = "CB_" + sDTKAttribute;
  /**
   * KAG: NON, M66
   * CB: CB_O_SCHIFFSAUSFUEHRUNG_S150
   * 
   * B VT_S150_M00012	Optionen M60+M66+M78
   *  O_BERUEHR_SCHUTZ_S150  O_SCHIFFSAUSFUEHRUNG_S150 O_MOTORANSCHLUSS_S150
   * A VT_S150_M00014	Optionen M66+Schutzart
   *  O_SCHIFFSAUSFUEHRUNG_S150 O_SCHUTZART_S150
   * C VT_S150_M00016	Optionen M66+L55
   *  O_SCHIFFSAUSFUEHRUNG_S150  O_STILLSTANDSHEIZUNG_S150
   * n.n. VT_S150_M00023	Optionen M66 + E11-E71
   *  O_SCHIFFSAUSFUEHRUNG_S150  O_EINZELZERTIFIKAT_S150
  */
  // A VT_S150_M00014	Optionen M66+Schutzart
  //  O_SCHIFFSAUSFUEHRUNG_S150 O_SCHUTZART_S150
  var O_SCHUTZART_S150 = ECL_GetValue("O_SCHUTZART_S150");

  var sTable = "VT_S150_M00014" + sDB_Suffix;
  var sWhere = "O_SCHUTZART_S150 = '" + O_SCHUTZART_S150 + "';";

  var sStatus = SetAttributeLogic_Checkbox(sTable, sDTKAttribute, sCB_Attribute, "M66", "NON", sWhere, false);

  if (sStatus == "Error") {
    strError = "DICT1_ERR_S150___PL_M66";
    return strError;
  }
  // --------------------------------------------------------------------------------------------
  // B VT_S150_M00012	Optionen M60+M66+M78
  //  O_BERUEHR_SCHUTZ_S150  O_SCHIFFSAUSFUEHRUNG_S150 O_MOTORANSCHLUSS_S150
  var O_BERUEHR_SCHUTZ_S150 = "NON";
  if (ECL_ValueSelected("CB_O_BERUEHR_SCHUTZ_S150", "T")) {
    O_BERUEHR_SCHUTZ_S150 = "M60";
  }
  var O_MOTORANSCHLUSS_S150 = "NON";
  if (ECL_ValueSelected("CB_O_MOTORANSCHLUSS_S150", "T")) {
    O_MOTORANSCHLUSS_S150 = "M78";
  }

  var sTable = "VT_S150_M00012" + sDB_Suffix;
  var sWhere = "O_BERUEHR_SCHUTZ_S150 = '" + O_BERUEHR_SCHUTZ_S150 + "' AND " + "O_MOTORANSCHLUSS_S150 = '" + O_MOTORANSCHLUSS_S150 + "';";

  var sStatus = SetAttributeLogic_Checkbox(sTable, sDTKAttribute, sCB_Attribute, "M66", "NON", sWhere, true);

  if (sStatus == "Error") {
    strError = "DICT1_ERR_S150___PL_M66";
    return strError;
  }

  // --------------------------------------------------------------------------------------------
  // C VT_S150_M00016	Optionen M66+L55
  //  O_SCHIFFSAUSFUEHRUNG_S150  O_STILLSTANDSHEIZUNG_S150
  var O_STILLSTANDSHEIZUNG_S150 = "NON";
  if (ECL_ValueSelected("CB_O_STILLSTANDSHEIZUNG_S150", "T")) {
    O_STILLSTANDSHEIZUNG_S150 = "L55";
  }

  var sTable = "VT_S150_M00016" + sDB_Suffix;
  var sWhere = "O_STILLSTANDSHEIZUNG_S150 = '" + O_STILLSTANDSHEIZUNG_S150 + "';";

  var sStatus = SetAttributeLogic_Checkbox(sTable, sDTKAttribute, sCB_Attribute, "M66", "NON", sWhere, true);

  if (sStatus == "Error") {
    strError = "DICT1_ERR_S150___PL_M66";
    return strError;
  }
  // ----------------------------------------------------------------------------------------------------------------
  // set H_TRIGGER_IP_M66_S150
  if (ECL_ValueSelected("CB_O_SCHIFFSAUSFUEHRUNG_S150", "T")) {
    ECL_SetValue("H_TRIGGER_IP_M66_S150", "T");
  } else {
    ECL_SetValue("H_TRIGGER_IP_M66_S150", "F");
  }
  // ################################################################################################################

  // ################################################################################################################
  // O_EINZELZERTIFIKAT_S150	Einzelzertifikat  NON, E11, E21, E31, E51, E61, E71
  // ################################################################################################################
  var sDTKAttribute = "O_EINZELZERTIFIKAT_S150";
  /**
   * KAG: NON, E11, E21, E31, E51, E61, E71
   * 
   * 	VT_S150_M00023	Optionen M66 + E11-E71
   *   O_SCHIFFSAUSFUEHRUNG_S150  O_EINZELZERTIFIKAT_S150
  */

  var O_SCHIFFSAUSFUEHRUNG_S150 = "NON";
  if (ECL_ValueSelected("CB_O_SCHIFFSAUSFUEHRUNG_S150", "T")) {
    var O_SCHIFFSAUSFUEHRUNG_S150 = "M66";
  }

  var sTable = "VT_S150_M00023" + sDB_Suffix;
  var sWhere = "O_SCHIFFSAUSFUEHRUNG_S150 = '" + O_SCHIFFSAUSFUEHRUNG_S150 + "';";

  var sStatus = SetAttributeLogic1st(sTable, sDTKAttribute, sWhere);

  if (sStatus == "Error") {
    strError = "DICT1_ERR_S150___PL_O_ZERTIFITKAT";
    return strError;
  }
  // ################################################################################################################

  // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  // Optionen 4	Optionen 4	Optionen 4	-	DOKUMENTATION / PRUEFUNG	-	Optionen 4	Optionen 4	Optionen 4
  // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

  // ################################################################################################################
  // O_LEIST_SCHILDANGAB_S150	Leistungsschildangaben			NON, T58, T60, T80, T83, T85, T91
  // ################################################################################################################
  /**var sDTKAttribute = "O_LEIST_SCHILDANGAB_S150";
  /**
   * KAG: NON, T58, T60, T80, T83, T85, T91
   */
  // ################################################################################################################

  // ################################################################################################################
  // O_DOKU_SPRACHE_S150	Dokumentationssprache			NON, D58, D60, D80, D91, D93, D94
  // ################################################################################################################
  /**var sDTKAttribute = "O_DOKU_SPRACHE_S150";
  /**
   * KAG: NON, D58, D60, D80, D91, D93, D94
   */
  // ################################################################################################################

  // ################################################################################################################
  // O_DOKU_EPLAN_S150	(D01) Kundendokumentation im EPLAN-Format			NON, D01
  // ################################################################################################################
  /**var sDTKAttribute = "O_DOKU_EPLAN_S150";
  var sCB_Attribute = "CB_" + sDTKAttribute;
  /**
   * KAG: NON, D01
   * CB: CB_O_DOKU_EPLAN_S150
   */
  // ################################################################################################################

  // ################################################################################################################
  // O_DOKU_DXF_S150	(D02) Kundendokumentation (Stromlauf-, Klemmen-, Anordnungsplan) im DXF-Format		NON, D02
  // ################################################################################################################
  /**var sDTKAttribute = "O_DOKU_DXF_S150";
  var sCB_Attribute = "CB_" + sDTKAttribute;
  /**
   * KAG: NON, D02
   * CB: CB_O_DOKU_DXF_S150
   */
  // ################################################################################################################

  // ################################################################################################################
  // O_DOKU_VORAB_S150	(D14) Vorab-Erstellung der Kundendokumentation	NON, D14
  // ################################################################################################################
  /**var sDTKAttribute = "O_DOKU_D14_S150";
  var sCB_Attribute = "CB_" + sDTKAttribute;
  /**
   * KAG: NON, D14
   * CB: CB_O_DOKU_VORAB_S150
   */

  // ################################################################################################################

  // ################################################################################################################
  // O_DOKU_SPRACHED00_S1_S150	Dokumentation in Einzelsprache, Deutsch	NON, D00
  // ################################################################################################################
  /**var sDTKAttribute = "O_DOKU_SPRACHED00_S1_S150";
  var sCB_Attribute = "CB_" + sDTKAttribute;
  /**
   * KAG: NON, D00
   * CB: CB_O_DOKU_SPRACHED00_S1_S150
  */
  // ################################################################################################################

  // ################################################################################################################
  // O_DOKU_SPRACHED56_S1_S150	Dokumentation in Einzelsprache, Russisch	NON, D56
  // ################################################################################################################
  /**var sDTKAttribute = "O_DOKU_SPRACHED56_S1_S150";
  var sCB_Attribute = "CB_" + sDTKAttribute;
  /**
   * KAG: NON, D56
   * CB: CB_O_DOKU_SPRACHED56_S1_S150
   */
  // ################################################################################################################

  // ################################################################################################################
  // O_DOKU_SPRACHED72_S1_S150	Dokumentation in Einzelsprache, Italienisch 	NON, D72
  // ################################################################################################################
  /**var sDTKAttribute = "O_DOKU_SPRACHED72_S1_S150";
  var sCB_Attribute = "CB_" + sDTKAttribute;
  /**
   * KAG: NON, D72
   * CB: CB_O_DOKU_SPRACHED72_S1_S150
   */
  // ################################################################################################################

  // ################################################################################################################
  // O_DOKU_SPRACHED76_S1_S150	Dokumentation in Einzelsprache, Englisch  	NON, D76
  // ################################################################################################################
  /**var sDTKAttribute = "O_DOKU_SPRACHED76_S1_S150";
  var sCB_Attribute = "CB_" + sDTKAttribute;
  /**
   * KAG: NON, D76
   * CB: CB_O_DOKU_SPRACHED76_S1_S150
   */
  // ################################################################################################################

  // ################################################################################################################
  // O_DOKU_SPRACHED77_S1_S150	Dokumentation in Einzelsprache, Französisch   	NON, D77
  // ################################################################################################################
  /**var sDTKAttribute = "O_DOKU_SPRACHED77_S1_S150";
  var sCB_Attribute = "CB_" + sDTKAttribute;
  /**
   * KAG: NON, D77
   * CB: CB_O_DOKU_SPRACHED77_S1_S150
   */
  // ################################################################################################################

  // ################################################################################################################
  // O_DOKU_SPRACHED78_S1_S150	Dokumentation in Einzelsprache, Spanisch	NON, D78
  // ################################################################################################################
  /**var sDTKAttribute = "O_DOKU_SPRACHED78_S1_S150";
  var sCB_Attribute = "CB_" + sDTKAttribute;
  /**
   * KAG: NON, D78
   * CB: CB_O_DOKU_SPRACHED78_S1_S150
   */

  // ################################################################################################################

  // ################################################################################################################
  // O_DOKU_SPRACHED84_S1_S150	Dokumentation in Einzelsprache, Chinesisch	NON, D84
  // ################################################################################################################
  /**var sDTKAttribute = "O_DOKU_SPRACHED84_S1_S150";
  var sCB_Attribute = "CB_" + sDTKAttribute;
  /**
   * KAG: NON, D84
   * CB: CB_O_DOKU_SPRACHED84_S1_S150
 */
  // ################################################################################################################


  // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  // Funktionsprüfungen im Kundenbeisein
  // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++



  // ################################################################################################################
  // O_FUNKTIONSPRUEF_F71_S150	Funktionsprüfung ohne angeschlossenen Motor			NON, F71, F72
  // ################################################################################################################
  var sDTKAttribute = "O_FUNKTIONSPRUEF_F71_S150";

  /**
   * KAG: NON, F71, F72
   * 
   * VT_S150_M00046	Dep test options F71 .. F77, F03
   * O_FUNKTIONSPRUEF_F71_S150  O_FUNKTIONSPRUEF_F75_S150 O_ISOLATIONSPRUEFUNG_S150 O_SICHTABNAHME_S150
   */
  var sTable = "VT_S150_M00046" + sDB_Suffix;
  var sSQL = "SELECT DISTINCT O_FUNKTIONSPRUEF_F71_S150 FROM " + sTable + ";";

  var aResult = GetDBDataSetEXT(sSQL);
  if (aResult.length > 0) {
    ECL_DeactivateAllAttributeValues("O_FUNKTIONSPRUEF_F71_S150");
    for (var i = 0; i < aResult.length; i++) {
      ECL_ActivateValue("O_FUNKTIONSPRUEF_F71_S150", aResult[i].O_FUNKTIONSPRUEF_F71_S150);
    }

  } else {
    strError = "DICT1_ERR_S150___PL_O_FUNKTIONSPRUEF_F71";
    return strError;
  }
  // ################################################################################################################

  // ################################################################################################################
  // O_FUNKTIONSPRUEF_F75_S150	Funktionsprüfung mit Prüffeldmotor im Leerlauf  NON, F75, F74
  // ################################################################################################################
  var sDTKAttribute = "O_FUNKTIONSPRUEF_F75_S150";

  /**
   * KAG: NON, F75
   * 
   * VT_S150_M00046	Dep test options F71 .. F77, F03
   * O_FUNKTIONSPRUEF_F71_S150  O_FUNKTIONSPRUEF_F75_S150 O_ISOLATIONSPRUEFUNG_S150 O_SICHTABNAHME_S150
   */
  var O_FUNKTIONSPRUEF_F71_S150 = ECL_GetValue("O_FUNKTIONSPRUEF_F71_S150");

  var sTable = "VT_S150_M00046" + sDB_Suffix;
  var sWhere = "O_FUNKTIONSPRUEF_F71_S150 = '" + O_FUNKTIONSPRUEF_F71_S150 + "';";

  var sStatus = SetAttributeLogic1st(sTable, sDTKAttribute, sWhere);

  if (sStatus == "Error") {
    strError = "DICT1_ERR_S150___PL_O_FUNKTIONSPRUEF_F75";
    return strError;
  }

  // ################################################################################################################

  // ################################################################################################################
  // O_ISOLATIONSPRUEFUNG_S150	Isolationsprüfung   NON, F77, F76
  // ################################################################################################################
  var sDTKAttribute = "O_ISOLATIONSPRUEFUNG_S150";

  /**
   * KAG: NON, F77, F76
   * 
   * VT_S150_M00046	Dep test options F71 .. F77, F03
   * O_FUNKTIONSPRUEF_F71_S150  O_FUNKTIONSPRUEF_F75_S150 O_ISOLATIONSPRUEFUNG_S150 O_SICHTABNAHME_S150
   */
  var O_FUNKTIONSPRUEF_F71_S150 = ECL_GetValue("O_FUNKTIONSPRUEF_F71_S150");
  var O_FUNKTIONSPRUEF_F75_S150 = ECL_GetValue("O_FUNKTIONSPRUEF_F75_S150");

  var sTable = "VT_S150_M00046" + sDB_Suffix;
  var sWhere = "O_FUNKTIONSPRUEF_F71_S150 = '" + O_FUNKTIONSPRUEF_F71_S150 + "' AND " +
    "O_FUNKTIONSPRUEF_F75_S150 = '" + O_FUNKTIONSPRUEF_F75_S150 + "';";

  var sStatus = SetAttributeLogic1st(sTable, sDTKAttribute, sWhere);

  if (sStatus == "Error") {
    strError = "DICT1_ERR_S150___PL_O_FUNKTIONSPRUEF_F77";
    return strError;
  }





  // ################################################################################################################


  // ################################################################################################################
  // O_SICHTABNAHME_S150	(F03) Sichtabnahme  NON, F03
  // ################################################################################################################
  var sDTKAttribute = "O_SICHTABNAHME_S150";
  var sCB_Attribute = "CB_" + sDTKAttribute;
  /**
   * KAG: NON, F03
   * CB: CB_O_SICHTABNAHME_S150
   * 
   * VT_S150_M00046	Dep test options F71 .. F77, F03
    * O_FUNKTIONSPRUEF_F71_S150  O_FUNKTIONSPRUEF_F75_S150 O_ISOLATIONSPRUEFUNG_S150 O_SICHTABNAHME_S150
   */
  var O_FUNKTIONSPRUEF_F71_S150 = ECL_GetValue("O_FUNKTIONSPRUEF_F71_S150");
  var O_FUNKTIONSPRUEF_F75_S150 = ECL_GetValue("O_FUNKTIONSPRUEF_F75_S150");
  var O_ISOLATIONSPRUEFUNG_S150 = ECL_GetValue("O_ISOLATIONSPRUEFUNG_S150");

  var sTable = "VT_S150_M00046" + sDB_Suffix;
  var sWhere = "O_FUNKTIONSPRUEF_F71_S150 = '" + O_FUNKTIONSPRUEF_F71_S150 + "' AND " +
    "O_FUNKTIONSPRUEF_F75_S150 = '" + O_FUNKTIONSPRUEF_F75_S150 + "' AND " +
    "O_ISOLATIONSPRUEFUNG_S150 = '" + O_ISOLATIONSPRUEFUNG_S150 + "';";

  var sStatus = SetAttributeLogic_Checkbox(sTable, sDTKAttribute, sCB_Attribute, "F03", "NON", sWhere, false);

  if (sStatus == "Error") {
    strError = "DICT1_ERR_S150___PL_F03";
    return strError;
  }

  // ################################################################################################################


  // ################################################################################################################
  // O_KUNDENSPEZ_ABNAHME_S150	(F97) Kundenspezifische Abnahme  NON, F97
  // ################################################################################################################
  /**var sDTKAttribute = "O_KUNDENSPEZ_ABNAHME_S150";
  var sCB_Attribute = "CB_" + sDTKAttribute;
  /**
   * KAG: NON, F97
   * CB: CB_O_KUNDENSPEZ_ABNAHME_S150
   */

  // ################################################################################################################




  // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  // Funktionsprüfungen ohne Kundenbeisein
  // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++


  // ################################################################################################################
  // O_FUNC_PRUEFUNG_F72_S150	(F72) Funktionsprüfung ohne angeschlossenen Motor			NON, F72
  // ################################################################################################################
  /**var sDTKAttribute = "O_FUNC_PRUEFUNG_F72_S150";
  var sCB_Attribute = "CB_" + sDTKAttribute;
  /**
   * KAG: NON, F72
   * CB: CB_O_FUNC_PRUEFUNG_F72_S150
   */

  // ################################################################################################################

  // ################################################################################################################
  // O_FUNC_PRUEFUNG_F74_S150	(F74) Funktionsprüfung mit Prüffeldmotor im Leerlauf		NON, F74
  // ################################################################################################################
  /**var sDTKAttribute = "O_FUNC_PRUEFUNG_F74_S150";
  var sCB_Attribute = "CB_" + sDTKAttribute;
  /**
   * KAG: NON, F74
   * CB: CB_O_FUNC_PRUEFUNG_F74_S150
   */

  // ################################################################################################################

  // ################################################################################################################
  // O_ISO_PRUEFUNG_F76_S150	(F76) Isolationsprüfung  NON, F76
  // ################################################################################################################
  /**var sDTKAttribute = "O_ISO_PRUEFUNG_F76_S150";
  var sCB_Attribute = "CB_" + sDTKAttribute;
  /**
   * KAG: NON, F76
   * CB: CB_O_ISO_PRUEFUNG_F76_S150
   */

  // ################################################################################################################


  // ################################################################################################################
  // HMK_DRV_SIM_DESIGNER_S150	DriveSim Designer   SEC-MLFB
  // ################################################################################################################
  //var sDTKAttribute = "HMK_DRV_SIM_DESIGNER_S150";

  // ################################################################################################################


  // ################################################################################################################
  // Safety-context
  // ################################################################################################################
  /* if single-connection (MLFB08 ==1) K50+K52 is mandatory for
        SOS	    6
        SS2	    5
        SBT	    12
    if parallel connection MLFB08==2 K50+K52 is mandatory for
        SS1-a/SS1-r 	14
        SOS             6
        SS2	            5
        SLS	            2
        SSM	            4
        SDI	            3
        SBT	            12
    
  if SBC	11 K88 is mandatory
  * /
 
  var ECSI_CX_SafetyFunctions = ECL_GetValue("ECSI_CX_SafetyFunctions");
  var aSafetyFunctions = ECSI_CX_SafetyFunctions.split(";");
  var bK50Mandatory = false;
  var bK51Mandatory = false;
  var bK52Mandatory = false;
  var bK88Mandatory = false;
 
  if (aSafetyFunctions && aSafetyFunctions.length > 0 && MLFB08_S150 == "1") {
    for (var i = 0; i < aSafetyFunctions.length; i++) {
      if (aSafetyFunctions[i] == "5" || aSafetyFunctions[i] == "6" || aSafetyFunctions[i] == "12") {
        bK50Mandatory = true;
        bK52Mandatory = true;
        break;
      }
    }
    for (var i = 0; i < aSafetyFunctions.length; i++) {
      if (
        aSafetyFunctions[i] == "2" ||
        aSafetyFunctions[i] == "3" ||
        aSafetyFunctions[i] == "4" ||
        aSafetyFunctions[i] == "5" ||
        aSafetyFunctions[i] == "6" ||
        aSafetyFunctions[i] == "12" ||
        aSafetyFunctions[i] == "14"
      ) {
        bK51Mandatory = true;
        break;
      }
    }
    for (var i = 0; i < aSafetyFunctions.length; i++) {
      if (aSafetyFunctions[i] == "11") {
        bK88Mandatory = true;
        break;
      }
    }
  } else if (aSafetyFunctions && aSafetyFunctions.length > 0 && MLFB08_S150 == "2") {
    for (var i = 0; i < aSafetyFunctions.length; i++) {
      if (
        aSafetyFunctions[i] == "2" ||
        aSafetyFunctions[i] == "3" ||
        aSafetyFunctions[i] == "4" ||
        aSafetyFunctions[i] == "5" ||
        aSafetyFunctions[i] == "6" ||
        aSafetyFunctions[i] == "12" ||
        aSafetyFunctions[i] == "14"
      ) {
        bK50Mandatory = true;
        bK51Mandatory = true;
        bK52Mandatory = true;
        break;
      }
    }
    for (var i = 0; i < aSafetyFunctions.length; i++) {
      if (aSafetyFunctions[i] == "11") {
        bK88Mandatory = true;
        break;
      }
    }
  }
 
  if (bK50Mandatory) {
    ECL_DisableAttribute("O_MODULE_S150");
  } else {
    ECL_EnableAttribute("O_MODULE_S150");
  }
  if (bK51Mandatory) {
    ECL_DisableAttribute("CB_O_SAFETY_LIZENZ_K01__S150");
  } else {
    ECL_EnableAttribute("CB_O_SAFETY_LIZENZ_K01__S150");
  }
  if (bK52Mandatory) {
    ECL_DisableAttribute("CB_O_ZUS_SMC30_K52_S150");
  } else {
    ECL_EnableAttribute("CB_O_ZUS_SMC30_K52_S150");
  }
  if (bK88Mandatory) {
    ECL_DisableAttribute("CB_O_SAFETY_SBA_K88_S150");
  } else {
    ECL_EnableAttribute("CB_O_SAFETY_SBA_K88_S150");
  }
*/
  // #############################################################################################################
  // #############################################################################################################

  return "OK";
}

