//@legacy
//#mode(full-ecma)


function SetAttributesFromMlfb() {

    ProcessCancellationToken();
    var mlfbString = ECL_GetValue("ECSI_MLFB");
    var array;
    try {
        array = JSON.parse(mlfbString);
    }
    catch (e) {
    }
    
    if ((typeof array === "object") && (array instanceof Array)) {
        var isStartCfg = false;
        var mlfbBaseType = "";
        var mlfb = "";
        var fullmlfb = "";
        var kb = "";
        var strCalledFunction = "";
        var strECSI_DefaultGearboxAdapter="";
        var strECSI_MotorBaseTypeOrderNumber="";
        
        for (var i=0; i<array.length; ++i) {
            var item = array[i];
            
            if (item.attribute === "ECSI_IS_START_CONFIGURATION") {
                isStartCfg = (item.value=="1");
                //alt:isStartCfg=true;
            }
            else if (item.attribute === "ECSI_MLFB_BASE_TYPE") {
                mlfbBaseType = item.value;
            }
            else if (item.attribute === "ECSI_MLFB") {
                fullmlfb = item.value;
                mlfb = item.value;
                mlfb = mlfb.replace("?",".");
                mlfb = mlfb.replace("-","");
                mlfb = mlfb.left(16);
            }
            // neuer Context SeriesID, in dem die ID der KB übermittelt wird. 
            // Achtung, in letzter TST Version V4.0.5.0_234.24 noch nicht implementiert
            else if (item.attribute === "ECSI_CX_SeriesID") {
                kb = item.value;
            }
            else if (item.attribute === "ECSI_CALLED_FUNCTION") {
                strCalledFunction = item.value;
            }
            else if (item.attribute === "ECSI_CX_DefaultGearboxAdapter") {
                strECSI_DefaultGearboxAdapter = item.value;
            }
            else if (item.attribute === "ECSI_CX_MotorBaseTypeOrderNumber") {
                strECSI_MotorBaseTypeOrderNumber = item.value;
            }
        }
        
        /*
        
        "*" bedeutet, KeepConfiguration nicht aktiviert!!
        
        >>>>> Umrichter
        
        *71105 SINAMICS G110D 
        *71101 SINAMICS G110M WM 
        71206 SINAMICS G120C 
        71205 SINAMICS G120D 
        62101 SINAMICS S210 
        62102 SINAMICS S210 
        62103 SINAMICS S210 
        80201 SINAMICS V20 
        80901 SINAMICS V90 
        71203 SINAMICS G120X 
        80701 SINAMICS V70 feed axis 
        80702 SINAMICS V70 spindle drive 
        *31130 SINAMICS G130 
        *79001 ET200pro FC-2 
        71201 SINAMICS G120 PM240-2 
        71207 SINAMICS G120 PM250 
        71300 SINAMICS G115D MM 
        71350 SINAMICS G115D WM 
        62200 SINAMICS S120 AC/AC 
        62300 SINAMICS S110
        
        >>>>> Motoren / Getriebemotoren
        
        1020 NLC
        1005 NRB
        1010 NRK
        1000 SIMOGEAR
        1001 SIMOGEAR

        250 SIMOGEAR 2KJ3 - IEC
        251 SIMOGEAR 2KJ3 - IEC
        253 SIMOGEAR 2KJ3 - Eagle Line
        254 SIMOGEAR 2KJ3 - Eagle Line
        255 SIMOGEAR 2KJ3 - Reluktanz
        256 SIMOGEAR 2KJ3 - Reluktanz
        310 SIMOTICS S - 1FL6
        311 SIMOTICS S - 1FK2
        312 SIMOTICS S - 1FT2
        200 SIMOTICS GP/SD 1LE1 - IEC
        201 SIMOTICS GP/SD 1LE1 - IEC
        202 SIMOTICS GP/SD 1LE1 - IEC
        203 SIMOTICS GP/SD 1LE1 - Eagle Line
        204 SIMOTICS GP/SD 1LE1 - Eagle Line
        205 SIMOTICS GP/SD 1LE1 - Eagle Line
        206 SIMOTICS GP/SD 1LE1 - APAC Line
        207 SIMOTICS GP/SD 1LE1 - APAC Line
        208 SIMOTICS GP/SD 1LE1 - APAC Line
        209 SIMOTICS GP/SD 1LE1 - IEC
        210 SIMOTICS GP/SD 1LE1 - IEC
        500 SIMOTICS XP 1MB1 - Ex tb IIIC
        501 SIMOTICS XP 1MB1 - Ex tb IIIC
        502 SIMOTICS XP 1MB1 - Ex tb IIIC
        520 SIMOTICS XP 1MB1 - Ex tc IIIB
        521 SIMOTICS XP 1MB1 - Ex tc IIIB
        522 SIMOTICS XP 1MB1 - Ex tc IIIB
        540 SIMOTICS XP 1MB1 - Ex ec IIC T3
        541 SIMOTICS XP 1MB1 - Ex ec IIC T3
        542 SIMOTICS XP 1MB1 - Ex ec IIC T3
        238 SIMOTICS XP 1MB1 - Ex db IIC T4
        400 SIMOTICS M - 1PH1

        300 SIMOTICS S - 1FK7
        301 SIMOTICS S - 1FT7
        *302 SIMOTICS S - 1FK7 mit Planetengetriebe
        *303 SIMOTICS S - 1FT7 mit Planetengetriebe
        305 SIMOTICS S - 1FG1
        600 SIMOGEAR 2KJ8 - Eagle Line
        601 SIMOGEAR 2KJ8 - Eagle Line
        610 SIMOGEAR 2KJ8 - Reluktanz
        611 SIMOGEAR 2KJ8 - Reluktanz
        */
        
        //Überprüfung, ob bei GetStatus und GetConfiguration die MLFB zur BaseType MLFB passt
        var bCheckBaseTypeMLFBConsistency=false;
        var bCheck1FK2_2KJ3_Adapter=false;
        
        if(strCalledFunction == "GetStatus" || strCalledFunction == "GetConfiguration")
        {
            bCheckBaseTypeMLFBConsistency=CheckBaseTypeMLFBConsistency(fullmlfb, mlfb, mlfbBaseType);
            bCheck1FK2_2KJ3_Adapter=Check1FK2_2KJ3_Adapter(mlfb, mlfbBaseType, strECSI_DefaultGearboxAdapter, strECSI_MotorBaseTypeOrderNumber);
            
        }
        
        if(!bCheckBaseTypeMLFBConsistency && !bCheck1FK2_2KJ3_Adapter)
        {
            //KB's, die noch nicht "Keep Configuration" unterstützen (kommt aus dem Context SeriesID)
            
            var oldKBs = ["71101", "71105", "79001","700","710","720","750","751","752","761","90000","90001","90010","90011","90012","90020","90030"];
            
            if ( (isStartCfg && oldKBs.indexOf(kb)>-1) || ( (kb=="" || kb=="0") && isStartCfg && mlfb.left(5)=="6SL35") ) 
            {
                //Muss nur zurückgesetzt werden, falls sich die MLFB zur BaseType an den Fest definierten Stellen unterscheidet.
                var mlfbBaseTypeReg = mlfbBaseType.replace("?",".");
                mlfbBaseTypeReg = mlfbBaseTypeReg.replace("-","");
                mlfbBaseTypeReg = mlfbBaseTypeReg.left(16);
                
                var regEx = new RegExp(mlfbBaseTypeReg);
                var aRet = mlfb.match(regEx);
                var bRet = (aRet == null || aRet.length == 0);
        
                if(bRet)
                {
                    for (var i=0; i<array.length; ++i) {
                        var item = array[i];
                        
                        if (item.attribute === "ECSI_MLFB") {
                            item.value = mlfbBaseType;
                        }
                        
                        if (item.attribute === "ECSI_MLFB_SEC") {
                            item.value = "";
                        }
                    }
                }
            }
            else if (isStartCfg)
            {
                //TST versucht auch über Produkte hinweg das Keep Configurtion Feature zu nutzen.
                //Das funktioniert natürlich nicht. Hier wird die MLFB dann mit der BaseType MLFB überschrieben, wenn es sich um ein anderes Produkt handelt
                for (var i=0; i<array.length; ++i) 
                {
                    var item = array[i];
                    
                    if (item.attribute === "ECSI_MLFB") 
                    {
                        if(left(item.value,4) != left(mlfbBaseType,4))
                        {
                            item.value = mlfbBaseType;
                        }
                        else
                        {
                            // Bei vielen Frequenzumrichtern reichen die ersten 4 Stellen der MLFB nicht.
                            // Hier muss auf Patterns zurückgegriffen werden
                            
                            //Pattern aus Datenbank lesen
                            var strSelect="SELECT PATTERN FROM FC_SERIES WHERE SZ_US_SeriesID='"+kb+"' ";
                            var aResult = Object.fromDatabase("FC_Check", strSelect);
                            if(aResult.length == 1)
                            {
                                var regEx = new RegExp(aResult[0].PATTERN);
                                var aRet = mlfb.match(regEx);
                                var bRet = (aRet == null || aRet.length == 0);
                                
                                if(bRet)
                                {
                                    for (var i=0; i<array.length; ++i) {
                                        var item = array[i];
                                        
                                        if (item.attribute === "ECSI_MLFB") {
                                            item.value = mlfbBaseType;
                                        }
                                        
                                        if (item.attribute === "ECSI_MLFB_SEC") {
                                            item.value = "";
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
            
            for (var i=0; i<array.length; ++i) {
                ECL_SetValue(array[i].attribute, array[i].value);
            }
        }
        else
        {
            ECL_SetValue("ECSI_MLFB", "");
            ECL_SetValue("ECSI_MLFB_BASE_TYPE", "");
            
        }
    }
}

function SetMlfbSec(csvList) {
    var mlfbList = csvList.split(";");
    var array = [];
    var tokens;
    var item;
    
    for (var i=0; i<mlfbList.length; ++i) {
        if (mlfbList[i] == "") {
            continue;
        }
        
        tokens = mlfbList[i].split(":");
        
        var manuId = "MLFB_SEC_MANUFACTURER___" + tokens[0];
        var manuText = translateEx(manuId, false);
        
        if (manuText == manuId) {
            manuText = "";
        }
        
        var artId = "MLFB_SEC_ARTICLE_TEXT___" + mlfbList[i];
        var artText = translateEx(artId, false);
        
        item = {
            mlfb: mlfbList[i],
            manufacturer: manuText,
            articleText: artText
        };
        array.push(item);
    }

    // central setting of consquence variable "IsProtectiveDevice"
    // secondary MLFB's starting with 3NA, 3NE, 3MV, 3RV, 3VL, 3VA, 5SY and 5SJ are protective devices
    var bisProtectiveDevice = false;
    for (var i=0; i<mlfbList.length; ++i) 
    {
        if (mlfbList[i] == "") {
            continue;
        }

        if(mlfbList[i].left(3) == "3NA" || mlfbList[i].left(3) == "3NE" || mlfbList[i].left(3) == "3MV" || mlfbList[i].left(3) == "3RV" || mlfbList[i].left(3) == "3VL" || mlfbList[i].left(3) == "3VA" || mlfbList[i].left(3) == "5SY" || mlfbList[i].left(3) == "5SJ")
        {
            bisProtectiveDevice = true;
        }
    }

    if(bisProtectiveDevice)
    {
        ECL_SetValue("ECSI_CC_IsProtectiveDevice", "1");
    }
    else
    {
        ECL_SetValue("ECSI_CC_IsProtectiveDevice", "0");
    }
    
    return ECL_SetValue("ECSI_MLFB_SEC", JSON.stringify(array));
}

function GetMlfbSec() {
    var mlfbString = ECL_GetValue("ECSI_MLFB_SEC");
    var csvList = "";
    var array;
    try {
        array = JSON.parse(mlfbString);
    }
    catch (e) {
        return mlfbString;
    }
    if ((typeof array === "object") && (array instanceof Array)) {
        for (var i=0; i<array.length; ++i) {
            if (i > 0) {
                csvList += ";";
            }
            csvList += array[i].mlfb;
        }
    }
	else {
		return mlfbString;
	}
    return csvList;
}

function ProcessCancellationToken()
{
    //Falls ein Abbruch angefragt wird, hier einen Error werfen, der das aktuelle Script beendet.
    if( iscancelationrequested())
    {
        ECL_SelectValue ("ECSI_STATUS", "E");
        ECL_SetValue ("ECSI_STATUS_MESSAGE", "Cancellation Token");
        throw new Error("CancellationToken");
    }
}

function CheckBaseTypeMLFBConsistency(fullmlfb, mlfb, mlfbBaseType)
{
    // Bei GetStatus und GetConfiguration müssen BaseType und MLFB übereinstimmen
    
    // Erst die Rumpf MLFB überprüfen
    
    var BaseType16 = mlfbBaseType.left(16);
    
    var bError=false;
    var strErrorText="";
    
    var strBaseTypeCompare="";
    var strMLFBCompare="";
    
    if(mlfb.length != 16 || BaseType16.length != 16)
    {
        bError=true;
        strErrorText="ERRORMSG___MLFB_BASETYPE_ILLEGAL_LENGTH";
        
        ECL_SelectValue ("ECSI_STATUS", "E");
        ECL_SetValue ("ECSI_STATUS_MESSAGE", strErrorText);
    }
    else
    {
        for(var i=0;i<BaseType16.length;i++)
        {
            if(BaseType16.charAt(i) != ".")
            {
                strBaseTypeCompare=strBaseTypeCompare+BaseType16.charAt(i);
                strMLFBCompare=strMLFBCompare+mlfb.charAt(i);
            }
        }
        
        if(strBaseTypeCompare!=strMLFBCompare)
        {
            bError=true;
            strErrorText="ERRORMSG___MLFB_NOT_MATCHING_BASETYPE";
            
            ECL_SelectValue ("ECSI_STATUS", "E");
            ECL_SetValue ("ECSI_STATUS_MESSAGE", translate(strErrorText));
        }
    }
    
    // Die Kurzangaben überprüfen
    // Die Kurzangaben im Basetype müssen auch in der MLFB enthalten sein
    
    var aBaseTypetoken = tokenize(mlfbBaseType, true);
    var aMLFBtoken = tokenize(fullmlfb, true);
    
    for (var i=1;i<aBaseTypetoken.length;i++)
    {
        var btest=false;
        var strKA=aBaseTypetoken[i];
        for (var j=1;j<aMLFBtoken.length;j++)
        {
            if(strKA==aMLFBtoken[j])
            {
                btest=true;
            }
        }
        
        if(!btest)
        {
            bError=true;
            strErrorText="ERRORMSG___MLFB_NOT_MATCHING_BASETYPE";
            
            ECL_SelectValue ("ECSI_STATUS", "E");
            ECL_SetValue ("ECSI_STATUS_MESSAGE", translate(strErrorText));
        }
    }
    
    return ( bError );
}

function tokenize( strMLFB, bStripFreeText )
{
    var nMLFBLen = strMLFB.length;
    var bMasked = false, bStripText = false, bBaseMLFBFinished = false;
    var strToken = '';
    var cToken = '';
    var aTokens = [];
    
    var i = 0;
    while ( i <= nMLFBLen )
    {
        cToken = strMLFB.charAt( i );
        if ( ( cToken === ' ' ) && !bMasked )					// not a space in quotes
        {
            if ( strToken === ' ' )								// clear multiple spaces
                strToken = '';
            else if ( strToken !== '' )							// a single space is a separator between tokens
            {
                aTokens.push( strToken );
                strToken = '';
            }
            // now we are handling blocks of mlfbs - but the MLFB must always be sparated by a space from the short descriptions
            if ( !bBaseMLFBFinished )
                bBaseMLFBFinished = true;
        }
        else if ( _isQuoteChar( cToken ) && !bMasked )	// text (in double or single quotes) started
        {
            // if we don't want the freetext to be included, we must not add a starting double quote
            // and we must prevent following chars to be added to the token until a closing double quote
            bMasked = true;
            if ( !bStripFreeText )
                strToken += cToken;
            else bStripText = true;
        }
        else if ( _isQuoteChar( cToken ) && bMasked )		// text (in double or single quotes) ended
        {
            // } of quote means } of token
            if ( !bStripFreeText )
                strToken += cToken;
            else bStripText = false;
            // if we don't want the freetext to be included, we must not add a starting double quote
            // and we must prevent following chars to be added to the token until a closing double quote
            if ( strToken !== '' )
            {
                aTokens.push( strToken );
                strToken = '';
            }
            bMasked = false;
        }
        else
        {
            if ( !bStripText )
            {
                if ( !_isSpecialChar( cToken, bMasked ) )
                {
                    // the lexer now must accept blocks of short descriptions and must break them into pieces of 3 chars
                    strToken += cToken;
                    if ( bBaseMLFBFinished && !bMasked && ( strToken.length == 3 ) )	// base mlfb is lexed and string is not masked
                    {						
                        if ( ( i + 1 ) <= nMLFBLen )
                            cToken = strMLFB.charAt( i + 1 );
                        if ( !_isQuoteChar( cToken ) )		// don't split a MLFB and quoted freetext
                        {
                            aTokens.push( strToken );
                            strToken = '';
                        }
                    }					
                }
            }
        }	
        ++i;
    } 
    
    if ( strToken !== '' )
    {
        // push the remaining string as token
        aTokens.push( strToken );
    }
        
    return( aTokens );
}


/**
 * determines if a character is a special char, i.e. a character that should not be included in a token
 *
 * @param cChar - char to examin
 * @param bInQuotes - are we just in double quotes?
 *
 * @return boolean - false - not a special character
 *                   true - a special character
 */
function _isSpecialChar( cChar, bInQuotes )
{
    var bIsSpecial = false;
    if ( !bInQuotes )
    {
        if ( ( cChar === '-' ) ||
             ( cChar === ',' ) ||
             ( cChar === 'Z' ) ||
             ( cChar === ';' ) ||
             ( cChar === ':' ) ||
             ( cChar === '_' ) ||
             ( cChar === '//' ) ||
             ( cChar === '?' ) ||
             ( cChar === '*' ) ||
             ( cChar === '+' ) ||
             ( cChar === "'" ) ||
             ( cChar === '/' ) ||
             ( cChar === '(' ) ||
             ( cChar === ')' ) ||
             ( cChar === '[' ) ||
             ( cChar === ']' ) ||
             ( cChar === '\t' ) )
            bIsSpecial = true;
    }
    // else characters that are in quotes are never special
    
    return( bIsSpecial );
}

function _isQuoteChar( cChar )
{
    return( ( cChar === '\"' ) || ( cChar === "'" ) );
}

function Check1FK2_2KJ3_Adapter(mlfb, mlfbBaseType, strECSI_DefaultGearboxAdapter, strECSI_MotorBaseTypeOrderNumber)
{
    if(strECSI_DefaultGearboxAdapter != "" && strECSI_MotorBaseTypeOrderNumber.left(4)=="1FK2")
    {
    
        // Beim 1FK2 muss der 2KJ3-Adapter Context IMMER zur MLFB passen. Ansonsten Fehler
        strDefaultAdapter = strECSI_DefaultGearboxAdapter.substring( 8, 12 );
        strCurrentAdapter = mlfb.substring( 8, 12 );
        if(strDefaultAdapter != strCurrentAdapter)
        {
            var strErrorText="ERRORMSG___MLFB_NOT_MATCHING_DEFAULT_ADAPTER";
            
            ECL_SelectValue ("ECSI_STATUS", "E");
            ECL_SetValue ("ECSI_STATUS_MESSAGE", translate(strErrorText));
            
            return ( true );
        }
        else
        {
            return ( false );
        }
        
    }
    else
    {
        return ( false );
    }
}

function HandleDefaultValuesHighlights()
{
	//vorerst deaktiviert
	return;
	
	if(getstring("HIGHLIGHTED_KB", "") == "TRUE")
		return;
	else
	{
		// gesetzte Startconfiguration wird als Default gesetzt
		logtraceln("SetDefault Configuration!");
		
		setstring("HIGHLIGHTED_KB", "", "TRUE");
		
		var aAttributes = ECL_GetAllAttributes();
		
		for(var i=0; i<aAttributes.length; i++)
		{ 
			if(ECL_AttributeActive(aAttributes[i]) && ECL_AttributeEnabled (aAttributes[i]) && left(aAttributes[i],5) != "ECSI_" && ECL_GetControlType (aAttributes[i])!="EDIT" && ECL_GetControlType (aAttributes[i])!="CHECK_H" )
			{
				var Value = ECL_GetValue (aAttributes[i]);
				ECL_HighlightValue (aAttributes[i], Value, "+")
			}
		}
		
		logtraceln("SetDefault Configuration! END !");
	}
}