//@legacy
/**
* 	Script for applying dependencies für excel based options structures (1FK2, 1FL6, V20, V90, S210)
*
* 	Date: 2019-03-28
* 	Editor: H.N. Bauer, P. Ewen, M. Wille, Plan Software GmbH
*		Mod:	2019-04-02 mb	Werte verstecken statt ausblenden
*		Mod:	2019-05-13 mb	Auswahllisten filtern : abh. von MLFB nur mögliche Werte anzeigen
*/

 // include easyKAT Configuration Library
// ECL.es is currently not full ecma
//#mode(full-ecma)



/**
    wenn die Bedingung erfüllt ist, wird der Wert eines Attributes freigeschaltet
    andernfalls nicht
    
    @param attrId		Attribut ID
    @param valueId	Werte ID
    @param enabled	T - freigeben, F - sperren
*/
function applyCond(attrId, valueId, enabled)
{
    var strControlType= ECL_GetControlType(attrId);
    
    if(strControlType=="CHECK_H")
    {
        if(enabled)
            ECL_ActivateAttribute(attrId);
        else
            ECL_DeactivateAttribute(attrId);
    }
    else
    {
        if(enabled)
            ECL_ActivateValue(attrId, valueId);
        else
            ECL_DeactivateValue(attrId, valueId);
    }
    
    /*
    if(enabled)
        ECL_EnableValue(attrId, valueId);
    else
        ECL_DisableValue(attrId, valueId);
    */

}


/**
    Alle Attribut/Value Einträge
    Attributname muss mit "A_" beginnen

    Array aller Attribut/Value
    [
        [ Attribut, Value ]
        , ...
    ]
*/
function getAllAttributValues()
{
    var a_attrValues = [];
    var i, j,
        aAttributes,
        aValues;
    aAttributes = ECL_GetAllAttributes();
    for(i = 0; i < aAttributes.length; i++)
    {
        if(aAttributes[i].left(2) != "A_")
            continue;
        aValues = ECL_GetAllAttributeValues(aAttributes[i]);
        for(j = 0; j < aValues.length; j++)
        {
            a_attrValues.push([
                aAttributes[i],
                aValues[j]
            ]);
        }
    }
    return a_attrValues;
}

/**
    Verfügbarkeit Attribut/Value bestimmen und entsprechend anzeigen/verbergen
    alle Attribut/Values mit der gefilterten Liste abgleichen
    wenn keine Bedingung vorhanden -> zulassen

*/
function filterValues(mlfb)
{
    filterRelevantOptions(mlfb);  // @@@ For 1FK2 and 1FL6 this is not necessary

    filterRelevantMlfb(mlfb);
}

/**
    Bedingungen für Optionen, welche die MLFB ändern
    Bedingungen für Optionen, welche keine zusätzliche MLFB erzeugen

    Achtung:
    es wird keine Abhängigkeit von anderen Attributen berücksichtigt !!

    Array mit den Zeilen wird bearbeitet
    [
        RegEx einer gültigen MLFB,
        [ Attribut, Value ]
    ]
*/
function filterRelevantMlfb(mlfb)
{
    var a_filter,
        lenFilter,
        enabled,
        i;

    logtraceln("\n filterRelevantMlfb für "+mlfb);

    // die Bedingungen laden
    a_filter = getAttributValueConditions();
    lenFilter = a_filter.length;
    
    // A/V abh. von MLFB zulassen/entfernen
    for(i = 0; i < lenFilter; i++)
    {
        enabled = EK_regFound(mlfb, a_filter[i][0]);
        applyCond(a_filter[i][1][0], a_filter[i][1][1], enabled);

        if (enabled && (a_filter[i][1][0] == "A_ANSCHLUSSTECHNIK_1FL6"))	// @@@ Hack 1FL6; otherwise configuration has to be run 2 times
            ECL_SelectValue("A_ANSCHLUSSTECHNIK_1FL6", a_filter[i][1][1]);
    }
}

/**
    Bedingungen für Optionen
    
    Verfügbarkeit Attribut/Value bestimmen und entsprechend anzeigen/verbergen
    alle Attribut/Values mit der gefilterten Liste abgleichen
    wenn keine Bedingung vorhanden -> zulassen
*/
function filterRelevantOptions(mlfb)
{
    var a_filter,
        a_attrValues,
        noConditions,
        enabled,
        tmpEnabled,
        lenFilter,
        lenValues,
        cond,
        andModus,
        bRet,
        i, j, k;

    logtraceln("\n filterRelevantOptions für "+mlfb);

    // die Bedinungen laden
    a_filter = getFilterValues(mlfb);
    lenFilter = a_filter.length;
    // alle A/V laden
    a_attrValues = getAllAttributValues();
    lenValues = a_attrValues.length;
    
    // jedes A/V prüfen
    for(i = 0; i < lenValues; i++)
    {
        //if (! ECL_AttributeEnabled(a_attrValues[i][0]))
        //	continue;
        logtraceln("CHECK  "+a_attrValues[i][0]+"/"+a_attrValues[i][1])

        // default : verbergen
        enabled = false;
        // wenn keine Bedingung definiert ist -> anzeigen
        noConditions = true;

        for(j = 0; j < lenFilter; j++)
        {
            // Bedingung für dieses A/V ?
            if (a_filter[j][0][0] != a_attrValues[i][0] || a_filter[j][0][1] != a_attrValues[i][1])
                continue;

            noConditions = false;

            logtraceln("COND   "+a_filter[j][1][0])
            // MLFB ist nicht erlaubt
            if (a_filter[j][1][0] == "FALSE")
            {
                enabled = (enabled || false);
            }

            // Bedingungen auswerten
            else {
                cond = a_filter[j][1];
                andModus = (cond[0] == "AND");

                tmpEnabled = true;

                for(k = 0; k < cond[1].length; k++)
                {
                    logtraceln("COND f "+cond[0]+" /"+cond[1][k][0])
                    numValue = cond[1][k][1];
                    tmpEnabled = ECL_ValueSelected(cond[1][k][0], numValue);
                    // kein Treffer - evtl. Nummer mit . statt ,
                    if(! tmpEnabled && numValue.indexOf(",") > -1)
                    {
                        numValue = numValue.replace(",", ".")
                        tmpEnabled = ECL_ValueSelected(cond[1][k][0], numValue);
                    }
                    // selektiert - bei OR Ende da gültig
                    if(tmpEnabled && ! andModus)
                        break;
                    // nicht selektiert - bei AND Ende da nicht gültig
                    else if(! tmpEnabled && andModus)
                        break;

                    enabled = (enabled || tmpEnabled);   // @@@ Für V90 hier && ???
                }
                enabled = (enabled || tmpEnabled);
            }
        }
        // Status nach Auswertung oder keine Bedingung definiert
        enabled = (enabled || noConditions);
        
        if(a_attrValues[i][0]!="A_ZKK_BW_S210" && a_attrValues[i][0]!="A_ZKK_BW_EXTERN_S210")
        {
            logtraceln("RESULT "+a_attrValues[i][0]+"/"+a_attrValues[i][1]+"="+(enabled ? " anzeigen":"löschen"));
            applyCond(a_attrValues[i][0], a_attrValues[i][1], enabled);
        }
    }
    /* @@@ Special S210 - wird das überhaupt gebraucht ?? */
    var v = ECL_GetAllActiveAttributeValues("A_AT_ZKP_S210");
    if (v.length > 1)
        ECL_EnableAttribute("A_AT_ZKP_S210");
    else
        ECL_DisableAttribute("A_AT_ZKP_S210");
}

/**
    Bedingungen für valide Attribut/Value zurückliefern
    sekundäre MLFB und Anzahl entfernen
    die Haupt MLFB wird bereits als erster Filter mit RegEx angewendet

    Array mit den Zeilen aus einem mehr-dimensionalen Array
    [
        [ Attribut, Value ],
        [ "AND"|"OR",
            [ Attribut, Value ]
            , ...
        ]
    ]
*/
function getFilterValues(mlfb)
{
    var a_cond,
        a_filter,
        b_mlfbOK,
        allConditions,
        cond,
        i, j;

        a_cond = getAccConditions(mlfb);

    // Liste erweitern um Attribut/Values
    // welche keine zusätzliche MLFB festlegen

    a_filter = [];
    for(i = 0; i < a_cond.length; i++)
    {
        b_mlfbOK = EK_regFound(mlfb, a_cond[i][1]);

        // Liste erstellen mit den Prüfbedinungen für jedes Attribut/Value
        allConditions = a_cond[i][3];
        // allConditions[j][0] = AND OR
        for (j = 1; j < allConditions.length; j++)
        {
            cond = removedAttrVal(j, allConditions, b_mlfbOK);
            if (cond.length > 0)
            {
                a_filter.push(
                    [
                        allConditions[j],
                        cond
                    ]
                );
            }
        }
    }
    return a_filter;
}

/**
    Umformen des Array mit Bedingungen, um festzustellen, ob ein Attribut/Values
    in der Auswahlliste angezeigt werden soll

    Array mit den Zeilen aus einem mehr-dimensionalen Array
    [
        MLFB des zusätzlichen Artikels,
        RegEx einer gültigen MLFB ( ! die Daten aus der Excel_Datei konvertieren ),
        [ "AND"|"OR",
            [ Attribut, Value ]
            , ...
        ]
    ]
    @param attrVal	Index des zu prüfenden Attribut/Value
    @return umgewandeltes Array mit Bedingungen für jedes Attribut/Value
    [
        [ Attribut, Value ] 
        [ "AND"|"OR",
            [ Attribut, Value ]
            , ...
        ]
    ]

*/
function removedAttrVal(idx, aConditions, b_mlfbOK)
{
    var aAttrVal,
        cond,
        i, j;

    // nur A_xxx.V_yyy
    if (aConditions[idx][0].left(2) != "A_" || aConditions[idx][1].left(2) != "V_")
        return [];

    aAttrVal = [];
    
    // AND OR
    aAttrVal.push(aConditions[0]);

    cond = [];
    for (i = 1; i < aConditions.length; i++)
    {
        if (i == idx)
            continue;
        cond.push(
                aConditions[i]
        );
    }
    // keine Bedingung -> zulassen
    // AND OR wird zu TRUE
    if (cond.length <= 1)
    {
        aAttrVal[0] = (b_mlfbOK ? "TRUE" : "FALSE");
    }
    aAttrVal.push(cond);
    return aAttrVal;
}


/**
    Funktion in der Generierung einer MLFB: 
    Die aus den Attributwerten ableitbaren Zubehör-(Sekundär-) MLFBs einsammeln
*/
function evalAccConditions(mlfb)
{
    var accMLFB = "",
        cDelim = ";";        //LF: "&#10;"
    var bRet = false,
        andModus,
        numValue,
        i, j, k;

    // die zusätzlichen Teile mit Regeln
    var accArray = getAccConditions();

    for(i = 0; i < accArray.length; i++)
    {
        // passt RegEx ?
        if(! EK_regFound(mlfb, accArray[i][1]))
            continue;
        // keine MLFB oder keine Bedingung
        if(accArray[i][0] == "" || accArray[i][3].length <= 1)
            continue;

        andModus = (accArray[i][3][0] == "AND");

        // Bedingungen prüfen
        bRet = false;

        for(j = 1; j < accArray[i][3].length; j++)
        {
            numValue = accArray[i][3][j][1];
            bRet = ECL_ValueSelected(accArray[i][3][j][0], numValue);
            // kein Treffer - evtl. Nummer mit . statt ,
            if(! bRet && numValue.indexOf(",") > -1)
            {
                numValue = numValue.replace(",", ".")
                bRet = ECL_ValueSelected(accArray[i][3][j][0], numValue);
            }
            // selektiert - bei OR Ende da gültig
            if(bRet && ! andModus)
                break;
            // nicht selektiert - bei AND Ende da nicht gültig
            else if(! bRet && andModus)
                break;
        }

        // wenns passt gem. Anzahl aufnehmen
        // (manche Zubehöre werden in mehrfacher Stückzahl benötigt, z.B. Sicherungen bei 3 Netzphasen)
        if(bRet)
        {
            var accCount = 1;
            if (left(accArray[i][2][0], 11) == "ECSI_CX_ANZ")
                accCount = 1 * accArray[i][2][1];
            if(accCount <= 0)
                accCount = 1;
            for(k = 1; k <= accCount; k++)
                accMLFB += accArray[i][0]+cDelim;
        }
    }
    return accMLFB;
}

/**
    Funktion in der Analyse einer MLFB: 
    Die mit den Zubehör-(Sekundär-) MLFBs verknüpften Attribute setzen
    Es werden hier dieselben Patterns verwendet, die auch zur Bestimmung der verfügbaren Attributwerte
    genutzt werden. Hier wird die Datenstruktur "umgedreht" verwendet
*/
function evalAccParts(mlfb, mlfb_sec)
{
    var accMLFB = "",
        cDelim = ";";        //LF: "&#10;"
    var bRet = true,
        andModus,
        numValue,
        accArray,
        mlfbArray,
        i, j, k;

    accArray = getAccConditions();

    if (mlfb_sec === '') return true;

    // die zusätzlichen Teile
    mlfb_sec = trimright(mlfb_sec, ";");
    var mlfbArray = mlfb_sec.split(";");

    for(i = 0; i < mlfbArray.length; i++)
    {
        for(j = 0; j < accArray.length; j++)
        {
            // passt Acc MLFB ? Aufpassen, dass Patterns, die gar kein Zubehör erzeugen hier übersprungen werden
            if(accArray[j][0] == "")
                continue;
            if(mlfbArray[i] != accArray[j][0])
                continue;

            // passt RegEx ?
            if(! EK_regFound(mlfb, accArray[j][1]))
                continue;

            // keine Bedingung
            if(accArray[j][3].length <= 1)
                continue;

            // Dialogattribute setzen
            andModus = (accArray[j][3][0] == "AND"); // and - Modus wird hier ignoriert

            for(k = 1; k < accArray[j][3].length; k++)
            {
                // diese Attribute nicht updaten !
                if(accArray[j][3][k][0] === "ECSI_CX_NP_S210")
                    continue;
                if(accArray[j][3][k][0] === "ECSI_CX_NP_V20")
                    continue;
                if(accArray[j][3][k][0] === "ECSI_CX_NP_V90")
                    continue;
                    
                // @@@ Hack um konkreten Fehler in der Analyse S210 zu beheben:
                // hier wird dieselbe Zubehör MLFB einmal mit F01 und einmal ohne verwendet
                /* vermutlich nicht länger nötig, weil die Zubehöre jetzt doch eindeutig unterscheidbar sind
                if ((accArray[j][3][k][1].indexOf("SAFETY") > 0) && (mlfb.indexOf("F01") < 0))
                    continue;
                */
                ECL_SetValue(accArray[j][3][k][0], accArray[j][3][k][1]);
            }
        }
    }
    return bRet;
}

/**
    n_pos startet bei 0
*/
function replaceChar(s_src, s_char, n_pos)
{
    if(s_src.length < n_pos)
    return s_src;
    var s=s_src.left(n_pos) + s_char + s_src.substring(n_pos + 1);
    return s;
}

/**
    n_pos startet bei 0
*/
function isValidChar(s_src, s_valid, n_pos)
{
    if(s_src.length < n_pos)
    return false;
    var s=s_src.substr(n_pos,1);
    var n=s_valid.indexOf(s);
    return (n >= 0);
}

/**
    Siemens regEx Ausdruck umwandeln
*/
function EK_regPrep(s_src)
{
    var s=s_src.replace("?", ".");
    s=s.replace("{", "(");
    s=s.replace("}", ")");
    s=s.replace(";", "|");
    return s;
}

/**
    Siemens regEx Ausdruck anwenden
*/
function EK_regFound(s_src, s_reg)
{
    var regEx = new RegExp(EK_regPrep(s_reg));
    var aM = null; 
    if(typeof(s_src) == "string"){
        aM = s_src.match(regEx);
    }
    if(aM == null)
        return false;
    if(aM.length == 0)
        return false;
    return true;
}


/**
    die Original einmal MLFB speichern
    damit kann geprüft werden, ob eine Option / Position änderbar ist
*/
function saveMlfb(mlfb)
{
    if (mlfb == "")
        return;
    if (ECL_GetUserVariable("ORIGINAL_MLFB") == "")
        ECL_SetUserVariable("ORIGINAL_MLFB", mlfb);
    
    // var baseMlfb = ECL_GetValue("ECSI_MLFB_BASE_TYPE");
    // if (baseMlfb != mlfb) return;
}

/**
    in der Original MLFB prüfen, ob die Option / Position änderbar ist
    n_pos startet bei 0
*/
function isMlfbPosFix(n_pos)
{
/*	Bugfix issue that after language switch configuration freezes  @@@  has to be checked for collateral issues
    var mlfb = ECL_GetUserVariable("ORIGINAL_MLFB");
    if (isValidChar(mlfb, ".", n_pos))
        return false;
    return true;
*/
    // TODO: ECSI_MLFB_BASE_TYPE nutzen
    
    return false;
}


